"use strict";

module.exports = {
    name: "stocks",
    
    dependencies: ["database"],

    actions: {
        status: {
            async handler() {
                return {
                    status: "ok",
                    service: "stocks",
                    timestamp: new Date().toISOString()
                };
            }
        },

        create: {
            params: {
                name: "string",
                quantity: "number",
                price: "number"
            },
            async handler(ctx) {
                const result = await ctx.call("database.execute", {
                    sql: 'INSERT INTO stocks (name, quantity, price) VALUES (?, ?, ?)',
                    params: [ctx.params.name, ctx.params.quantity, ctx.params.price]
                });

                return {
                    id: result.lastInsertRowid,
                    ...ctx.params
                };
            }
        },

        list: {
            async handler(ctx) {
                return ctx.call("database.query", {
                    sql: 'SELECT * FROM stocks'
                });
            }
        },

        get: {
            params: {
                id: { type: "string", convert: true }
            },
            async handler(ctx) {
                return ctx.call("database.queryOne", {
                    sql: 'SELECT * FROM stocks WHERE id = ?',
                    params: [parseInt(ctx.params.id)]
                });
            }
        },

        update: {
            params: {
                id: { type: "string", convert: true },
                name: "string|optional",
                quantity: "number|optional",
                price: "number|optional"
            },
            async handler(ctx) {
                const { id, ...updateData } = ctx.params;
                const fields = Object.keys(updateData);
                if (fields.length === 0) return this.actions.get({ id });

                const updates = fields.map(field => `${field} = ?`).join(', ');
                const values = fields.map(field => updateData[field]);
                
                await ctx.call("database.execute", {
                    sql: `UPDATE stocks SET ${updates} WHERE id = ?`,
                    params: [...values, parseInt(id)]
                });
                
                return this.actions.get({ id });
            }
        },

        updateQuantity: {
            params: {
                id: { type: "string", convert: true },
                quantity: "number"
            },
            async handler(ctx) {
                await ctx.call("database.execute", {
                    sql: 'UPDATE stocks SET quantity = ? WHERE id = ?',
                    params: [ctx.params.quantity, parseInt(ctx.params.id)]
                });
                return this.actions.get({ id: ctx.params.id });
            }
        },
    }
};
