# BitLocker Administration

# Verify AD requirements
Get-ADObject -SearchBase ((Get-ADRootDSE).SchemaNamingContext) -Filter { Name -like 'ms-FVE-*' } | Select-Object -Property Name, ObjectClass | Format-Table -AutoSize

# Install feature
Install-WindowsFeature -Name BitLocker -IncludeAllSubFeature -IncludeManagementTools
Install-WindowsFeature -Name RSAT-Feature-Tools-BitLocker-BdeAducExt, RSAT-Feature-Tools-BitLocker-RemoteAdminTool, RSAT-Feature-Tools-BitLocker

# Deploy GPO: Computer Configuration > Policies > Administrative Templates > Windows Components > BitLocker Drive Encryption > Store BitLocker Recovery information in Active Directory Domain Services

# Force recovery
manage-bde -forcerecovery c:
