# Configure CredSSP for PowerShell Remoting and Kerberos Delegation
# Ref: timw.info/shr

# Verify the problem
Enter-PSSession -ComputerName 'mem1.timw.info'
Invoke-Command -ComputerName 'dc1.timw.info' -ScriptBlock { Get-WindowsFeature | Where-Object -FilterScript { $_.InstallState -eq 'Installed' } }

# Command search
Get-Command -Name *credssp* | Select-Object -Property Name, Source

# Enable mem1 to delegate my credentials
Enable-WSManCredSSP -Role Client -DelegateComputer mem1.timw.info -Force

# Verify configuration
Get-WSManCredSSP

# Configure mem1 to act as a delegate on my behalf
Invoke-Command -ComputerName "mem1.timw.info" -Scriptblock {Get-WSManCredSSP}

# connect to mem1 specifying CredSSP
Enter-PSSession -ComputerName "mem1.timw.info"-Credential "timw\tim" -Authentication CredSSP

Invoke-Command -ComputerName 'dc1.timw.info' -ScriptBlock { Get-WindowsFeature | Where-Object -FilterScript { $_.InstallState -eq 'Installed' } }

Disable-WSManCredSSP -Role Client

Invoke-Command -ComputerName "mem1.timw.info" -ScriptBlock { Disable-WSManCredSSP -Role Server }