Install-WindowsFeature AD-Domain-Services -IncludeManagementTools

$domain = "timw.info"
$password = "" | ConvertTo-SecureString -asPlainText -Force
$username = "tim@timw.info"
$credential = New-Object System.Management.Automation.PSCredential($username, $password)
Add-Computer -DomainName $domain -Credential $credential -Force -Restart

Install-ADDSDomainController -Credential $password -DomainName "timw.info"-InstallDNS:$true -ReadOnlyReplica:$true -SiteName "Default-First-Site-Name" -Force:$true

Get-ADGroupMember -Identity "Denied RODC Password Replication Group" | Format-Table DistinguishedName, Name, ObjectClass

Get-ADUser -SearchBase 'OU=Staff,DC=timw,DC=info' -Filter * | ForEach-Object { Add-ADGroupMember -Identity 'Allowed RODC Password Replication Group' -Members $_ -Confirm:$false }

# Pre-populate passwords
$users = Get-ADUser -SearchBase "OU=Branch Users,dc=timw,dc=info" -Filter *
foreach ($user in $users) {
  Get-ADObject -identity $user | Sync-ADObject -Source SERVER2016 -Destination SRV-02RODC -PasswordOnly
}