#!/usr/bin/python2.7

import argparse
import string
import base64
import ctypes
import random

trickbot_b64_charset  = "HJIA/CB+FGKLNOP3RSlUVWXYZfbcdeaghi5kmn0pqrstuvwx89o12467MEDyzQjT"
VERBOSE = False

def to_uint(c):
    return ctypes.c_uint(c).value

def to_int(c):
    return ctypes.c_int(c).value

def str_checksum(b64str):
    v4 = 0
    i = 0
    for c in b64str:
        if c == '=':
            break
        #print "c: %c" % c
        v4 = to_uint(1025 * to_uint((ord(c) + i)))
        #print "v4: %d" % v4
        i = to_int((v4 >> 6) ^ v4)
        #print "i: %d" % i
        #print "---\n"
    step1 = to_uint(9*i) 
    step2 = to_int(9*i ^ (step1 >> 11))
    return to_uint(0x8001 * step2)

def generate_teststring():
    line = ""
    for i in xrange(0, 256):
        line += chr(i)
    return line

def is_charset(line, charset):
    line = line.strip()
    for x in line:
        if x not in charset:
            return False
    return True

def is_printable(line):
    line = line.strip()
    for x in line:
        if x not in string.printable:
            return False
    return True

def trick_base64_dec(s, my_charset):
    if s is None:
        return None
    std_base64chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/"
    s = s.translate(string.maketrans(my_charset, std_base64chars))
    data = base64.b64decode(s)
    return data

def trick_base64_enc(s, my_charset):
    if s is None:
        return None
    std_base64chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/"
    data = base64.b64encode(s)
    data = data.translate(string.maketrans(std_base64chars, my_charset))
    return data

def swap(c, i, j):
    c = list(c)
    c[i], c[j] = c[j], c[i]
    return ''.join(c)

def randomize_charset(in_charset, n):
    clen = len(in_charset)
    limit = clen-n-1
    while True:
        index1 = random.randint(1,n) + limit
        index2 = random.randint(1,n) + limit
        if index1 != index2:
            break
    in_charset = swap(in_charset, index1, index2)
    return in_charset

def append_padding(val):
    mod = len(val) % 3
    while (len(val) % 4) != 0:
        val += "="
    return val

def process(line, charset):
    pair = line.split('=')
    if len(pair) < 2:
       return
    val  = pair[1].strip()

    decoded = None
    if val is not None and is_charset(val, charset):
        val = append_padding(val)
        try:
            decoded = trick_base64_dec(val, charset)
        except:
            decoded = None
    return decoded

def process_settings(in_lines, charset):
    out_lines = []
    for line in in_lines:
        decoded = process(line, charset)
        if decoded and is_printable(decoded) and len(decoded)>10:
            out_lines.append(decoded)
    return out_lines

def read_settings(fname):
    in_lines = []
    with open(fname) as f:
        for line in f:
            in_lines.append(line)
    return in_lines


def get_checksum(line):
    elements = line.split(' ')
    if elements < 2:
        return None
    return elements[1]

def make_charset_checksum(my_charset):
    test = generate_teststring()
    test_b64 = trick_base64_enc(test, my_charset)
    test_checks = str_checksum(test_b64)
    return test_checks

def is_valid_checksum(line, test_checks):
    line_checks = get_checksum(line)
    if line_checks is None:
        return False
    if VERBOSE:
        print test_checks , " : ", line_checks
    if line_checks == str(test_checks):
        return True
    return False

def check_charset(in_lines, in_charset):
    test1_checks = make_charset_checksum(in_charset)
    out_lines = process_settings(in_lines, in_charset)
    for line in out_lines:
        #print line
        if is_valid_checksum(line, test1_checks):
            return True
    return False

def main():
    parser = argparse.ArgumentParser(description="TrickBot settings decoder: decodes botkey from the settings file")
    parser.add_argument('--file', dest="file", default=None, help="TrickBot settings file (i.e. settings.ini)", required=True)
    parser.add_argument('--brute', dest="brute", default=False, help="Brutforce the charset", required=False, action="store_true")
    args = parser.parse_args()

    in_lines = read_settings(args.file)

    my_charset = trickbot_b64_charset
    if args.brute:
        print "Searching the charset..."
        while True:
            if check_charset(in_lines, my_charset):
                break
            else:
                my_charset = randomize_charset(my_charset, 9)
                if VERBOSE:
                    print my_charset

    test1_checks = make_charset_checksum(my_charset)
    out_lines = process_settings(in_lines, my_charset)
    for out_line in out_lines:
        if is_valid_checksum(out_line, test1_checks):
            print "[+] Decoded with matching charset"
        else:
            print "[!] Decoding with basic charset, some characters may be invalid! (Try option --brute)"
        print out_line


if __name__ == "__main__":
    main()

