##
## Bundle of CA Root Certificates
##
## Certificate data from Mozilla as of: Wed Dec 15 08:36:30 2021
##
## This is a bundle of X.509 certificates of public Certificate Authorities
## (CA). These were automatically extracted from Mozilla's root certificates
## file (certdata.txt).  This file can be found in the mozilla source tree:
## http://hg.mozilla.org/releases/mozilla-release/raw-file/default/security/nss/lib/ckfw/builtins/certdata.txt
##
## It contains the certificates in plain text and PEM format and therefore
## can be directly used with curl / libcurl / php_curl, or with
## an Apache+mod_ssl webserver for SSL client authentication.
## Just configure this file as the SSLCACertificateFile.
##
##


GlobalSign Root CA
================================================
SHA1 Fingerprint=B1:BC:96:8B:D4:F4:9D:62:2A:A8:9A:81:F2:15:01:52:A4:1D:82:9C
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            04:00:00:00:00:01:15:4b:5a:c3:94
    Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=BE, O=GlobalSign nv-sa, OU=Root CA, CN=GlobalSign Root CA
        Validity
            Not Before: Sep  1 12:00:00 1998 GMT
            Not After : Jan 28 12:00:00 2028 GMT
        Subject: C=BE, O=GlobalSign nv-sa, OU=Root CA, CN=GlobalSign Root CA
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (2048 bit)
                Modulus:
                    00:da:0e:e6:99:8d:ce:a3:e3:4f:8a:7e:fb:f1:8b:
                    83:25:6b:ea:48:1f:f1:2a:b0:b9:95:11:04:bd:f0:
                    63:d1:e2:67:66:cf:1c:dd:cf:1b:48:2b:ee:8d:89:
                    8e:9a:af:29:80:65:ab:e9:c7:2d:12:cb:ab:1c:4c:
                    70:07:a1:3d:0a:30:cd:15:8d:4f:f8:dd:d4:8c:50:
                    15:1c:ef:50:ee:c4:2e:f7:fc:e9:52:f2:91:7d:e0:
                    6d:d5:35:30:8e:5e:43:73:f2:41:e9:d5:6a:e3:b2:
                    89:3a:56:39:38:6f:06:3c:88:69:5b:2a:4d:c5:a7:
                    54:b8:6c:89:cc:9b:f9:3c:ca:e5:fd:89:f5:12:3c:
                    92:78:96:d6:dc:74:6e:93:44:61:d1:8d:c7:46:b2:
                    75:0e:86:e8:19:8a:d5:6d:6c:d5:78:16:95:a2:e9:
                    c8:0a:38:eb:f2:24:13:4f:73:54:93:13:85:3a:1b:
                    bc:1e:34:b5:8b:05:8c:b9:77:8b:b1:db:1f:20:91:
                    ab:09:53:6e:90:ce:7b:37:74:b9:70:47:91:22:51:
                    63:16:79:ae:b1:ae:41:26:08:c8:19:2b:d1:46:aa:
                    48:d6:64:2a:d7:83:34:ff:2c:2a:c1:6c:19:43:4a:
                    07:85:e7:d3:7c:f6:21:68:ef:ea:f2:52:9f:7f:93:
                    90:cf
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Subject Key Identifier: 
                60:7B:66:1A:45:0D:97:CA:89:50:2F:7D:04:CD:34:A8:FF:FC:FD:4B
    Signature Algorithm: sha1WithRSAEncryption
         d6:73:e7:7c:4f:76:d0:8d:bf:ec:ba:a2:be:34:c5:28:32:b5:
         7c:fc:6c:9c:2c:2b:bd:09:9e:53:bf:6b:5e:aa:11:48:b6:e5:
         08:a3:b3:ca:3d:61:4d:d3:46:09:b3:3e:c3:a0:e3:63:55:1b:
         f2:ba:ef:ad:39:e1:43:b9:38:a3:e6:2f:8a:26:3b:ef:a0:50:
         56:f9:c6:0a:fd:38:cd:c4:0b:70:51:94:97:98:04:df:c3:5f:
         94:d5:15:c9:14:41:9c:c4:5d:75:64:15:0d:ff:55:30:ec:86:
         8f:ff:0d:ef:2c:b9:63:46:f6:aa:fc:df:bc:69:fd:2e:12:48:
         64:9a:e0:95:f0:a6:ef:29:8f:01:b1:15:b5:0c:1d:a5:fe:69:
         2c:69:24:78:1e:b3:a7:1c:71:62:ee:ca:c8:97:ac:17:5d:8a:
         c2:f8:47:86:6e:2a:c4:56:31:95:d0:67:89:85:2b:f9:6c:a6:
         5d:46:9d:0c:aa:82:e4:99:51:dd:70:b7:db:56:3d:61:e4:6a:
         e1:5c:d6:f6:fe:3d:de:41:cc:07:ae:63:52:bf:53:53:f4:2b:
         e9:c7:fd:b6:f7:82:5f:85:d2:41:18:db:81:b3:04:1c:c5:1f:
         a4:80:6f:15:20:c9:de:0c:88:0a:1d:d6:66:55:e2:fc:48:c9:
         29:26:69:e0
-----BEGIN CERTIFICATE-----
MIIDdTCCAl2gAwIBAgILBAAAAAABFUtaw5QwDQYJKoZIhvcNAQEFBQAwVzELMAkG
A1UEBhMCQkUxGTAXBgNVBAoTEEdsb2JhbFNpZ24gbnYtc2ExEDAOBgNVBAsTB1Jv
b3QgQ0ExGzAZBgNVBAMTEkdsb2JhbFNpZ24gUm9vdCBDQTAeFw05ODA5MDExMjAw
MDBaFw0yODAxMjgxMjAwMDBaMFcxCzAJBgNVBAYTAkJFMRkwFwYDVQQKExBHbG9i
YWxTaWduIG52LXNhMRAwDgYDVQQLEwdSb290IENBMRswGQYDVQQDExJHbG9iYWxT
aWduIFJvb3QgQ0EwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDaDuaZ
jc6j40+Kfvvxi4Mla+pIH/EqsLmVEQS98GPR4mdmzxzdzxtIK+6NiY6arymAZavp
xy0Sy6scTHAHoT0KMM0VjU/43dSMUBUc71DuxC73/OlS8pF94G3VNTCOXkNz8kHp
1Wrjsok6Vjk4bwY8iGlbKk3Fp1S4bInMm/k8yuX9ifUSPJJ4ltbcdG6TRGHRjcdG
snUOhugZitVtbNV4FpWi6cgKOOvyJBNPc1STE4U6G7weNLWLBYy5d4ux2x8gkasJ
U26Qzns3dLlwR5EiUWMWea6xrkEmCMgZK9FGqkjWZCrXgzT/LCrBbBlDSgeF59N8
9iFo7+ryUp9/k5DPAgMBAAGjQjBAMA4GA1UdDwEB/wQEAwIBBjAPBgNVHRMBAf8E
BTADAQH/MB0GA1UdDgQWBBRge2YaRQ2XyolQL30EzTSo//z9SzANBgkqhkiG9w0B
AQUFAAOCAQEA1nPnfE920I2/7LqivjTFKDK1fPxsnCwrvQmeU79rXqoRSLblCKOz
yj1hTdNGCbM+w6DjY1Ub8rrvrTnhQ7k4o+YviiY776BQVvnGCv04zcQLcFGUl5gE
38NflNUVyRRBnMRddWQVDf9VMOyGj/8N7yy5Y0b2qvzfvGn9LhJIZJrglfCm7ymP
AbEVtQwdpf5pLGkkeB6zpxxxYu7KyJesF12KwvhHhm4qxFYxldBniYUr+WymXUad
DKqC5JlR3XC321Y9YeRq4VzW9v493kHMB65jUr9TU/Qr6cf9tveCX4XSQRjbgbME
HMUfpIBvFSDJ3gyICh3WZlXi/EjJKSZp4A==
-----END CERTIFICATE-----

GlobalSign Root CA - R2
================================================
SHA1 Fingerprint=75:E0:AB:B6:13:85:12:27:1C:04:F8:5F:DD:DE:38:E4:B7:24:2E:FE
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            04:00:00:00:00:01:0f:86:26:e6:0d
    Signature Algorithm: sha1WithRSAEncryption
        Issuer: OU=GlobalSign Root CA - R2, O=GlobalSign, CN=GlobalSign
        Validity
            Not Before: Dec 15 08:00:00 2006 GMT
            Not After : Dec 15 08:00:00 2021 GMT
        Subject: OU=GlobalSign Root CA - R2, O=GlobalSign, CN=GlobalSign
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (2048 bit)
                Modulus:
                    00:a6:cf:24:0e:be:2e:6f:28:99:45:42:c4:ab:3e:
                    21:54:9b:0b:d3:7f:84:70:fa:12:b3:cb:bf:87:5f:
                    c6:7f:86:d3:b2:30:5c:d6:fd:ad:f1:7b:dc:e5:f8:
                    60:96:09:92:10:f5:d0:53:de:fb:7b:7e:73:88:ac:
                    52:88:7b:4a:a6:ca:49:a6:5e:a8:a7:8c:5a:11:bc:
                    7a:82:eb:be:8c:e9:b3:ac:96:25:07:97:4a:99:2a:
                    07:2f:b4:1e:77:bf:8a:0f:b5:02:7c:1b:96:b8:c5:
                    b9:3a:2c:bc:d6:12:b9:eb:59:7d:e2:d0:06:86:5f:
                    5e:49:6a:b5:39:5e:88:34:ec:bc:78:0c:08:98:84:
                    6c:a8:cd:4b:b4:a0:7d:0c:79:4d:f0:b8:2d:cb:21:
                    ca:d5:6c:5b:7d:e1:a0:29:84:a1:f9:d3:94:49:cb:
                    24:62:91:20:bc:dd:0b:d5:d9:cc:f9:ea:27:0a:2b:
                    73:91:c6:9d:1b:ac:c8:cb:e8:e0:a0:f4:2f:90:8b:
                    4d:fb:b0:36:1b:f6:19:7a:85:e0:6d:f2:61:13:88:
                    5c:9f:e0:93:0a:51:97:8a:5a:ce:af:ab:d5:f7:aa:
                    09:aa:60:bd:dc:d9:5f:df:72:a9:60:13:5e:00:01:
                    c9:4a:fa:3f:a4:ea:07:03:21:02:8e:82:ca:03:c2:
                    9b:8f
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Subject Key Identifier: 
                9B:E2:07:57:67:1C:1E:C0:6A:06:DE:59:B4:9A:2D:DF:DC:19:86:2E
            X509v3 CRL Distribution Points: 

                Full Name:
                  URI:http://crl.globalsign.net/root-r2.crl

            X509v3 Authority Key Identifier: 
                keyid:9B:E2:07:57:67:1C:1E:C0:6A:06:DE:59:B4:9A:2D:DF:DC:19:86:2E

    Signature Algorithm: sha1WithRSAEncryption
         99:81:53:87:1c:68:97:86:91:ec:e0:4a:b8:44:0b:ab:81:ac:
         27:4f:d6:c1:b8:1c:43:78:b3:0c:9a:fc:ea:2c:3c:6e:61:1b:
         4d:4b:29:f5:9f:05:1d:26:c1:b8:e9:83:00:62:45:b6:a9:08:
         93:b9:a9:33:4b:18:9a:c2:f8:87:88:4e:db:dd:71:34:1a:c1:
         54:da:46:3f:e0:d3:2a:ab:6d:54:22:f5:3a:62:cd:20:6f:ba:
         29:89:d7:dd:91:ee:d3:5c:a2:3e:a1:5b:41:f5:df:e5:64:43:
         2d:e9:d5:39:ab:d2:a2:df:b7:8b:d0:c0:80:19:1c:45:c0:2d:
         8c:e8:f8:2d:a4:74:56:49:c5:05:b5:4f:15:de:6e:44:78:39:
         87:a8:7e:bb:f3:79:18:91:bb:f4:6f:9d:c1:f0:8c:35:8c:5d:
         01:fb:c3:6d:b9:ef:44:6d:79:46:31:7e:0a:fe:a9:82:c1:ff:
         ef:ab:6e:20:c4:50:c9:5f:9d:4d:9b:17:8c:0c:e5:01:c9:a0:
         41:6a:73:53:fa:a5:50:b4:6e:25:0f:fb:4c:18:f4:fd:52:d9:
         8e:69:b1:e8:11:0f:de:88:d8:fb:1d:49:f7:aa:de:95:cf:20:
         78:c2:60:12:db:25:40:8c:6a:fc:7e:42:38:40:64:12:f7:9e:
         81:e1:93:2e
-----BEGIN CERTIFICATE-----
MIIDujCCAqKgAwIBAgILBAAAAAABD4Ym5g0wDQYJKoZIhvcNAQEFBQAwTDEgMB4G
A1UECxMXR2xvYmFsU2lnbiBSb290IENBIC0gUjIxEzARBgNVBAoTCkdsb2JhbFNp
Z24xEzARBgNVBAMTCkdsb2JhbFNpZ24wHhcNMDYxMjE1MDgwMDAwWhcNMjExMjE1
MDgwMDAwWjBMMSAwHgYDVQQLExdHbG9iYWxTaWduIFJvb3QgQ0EgLSBSMjETMBEG
A1UEChMKR2xvYmFsU2lnbjETMBEGA1UEAxMKR2xvYmFsU2lnbjCCASIwDQYJKoZI
hvcNAQEBBQADggEPADCCAQoCggEBAKbPJA6+Lm8omUVCxKs+IVSbC9N/hHD6ErPL
v4dfxn+G07IwXNb9rfF73OX4YJYJkhD10FPe+3t+c4isUoh7SqbKSaZeqKeMWhG8
eoLrvozps6yWJQeXSpkqBy+0Hne/ig+1AnwblrjFuTosvNYSuetZfeLQBoZfXklq
tTleiDTsvHgMCJiEbKjNS7SgfQx5TfC4LcshytVsW33hoCmEofnTlEnLJGKRILzd
C9XZzPnqJworc5HGnRusyMvo4KD0L5CLTfuwNhv2GXqF4G3yYROIXJ/gkwpRl4pa
zq+r1feqCapgvdzZX99yqWATXgAByUr6P6TqBwMhAo6CygPCm48CAwEAAaOBnDCB
mTAOBgNVHQ8BAf8EBAMCAQYwDwYDVR0TAQH/BAUwAwEB/zAdBgNVHQ4EFgQUm+IH
V2ccHsBqBt5ZtJot39wZhi4wNgYDVR0fBC8wLTAroCmgJ4YlaHR0cDovL2NybC5n
bG9iYWxzaWduLm5ldC9yb290LXIyLmNybDAfBgNVHSMEGDAWgBSb4gdXZxwewGoG
3lm0mi3f3BmGLjANBgkqhkiG9w0BAQUFAAOCAQEAmYFThxxol4aR7OBKuEQLq4Gs
J0/WwbgcQ3izDJr86iw8bmEbTUsp9Z8FHSbBuOmDAGJFtqkIk7mpM0sYmsL4h4hO
291xNBrBVNpGP+DTKqttVCL1OmLNIG+6KYnX3ZHu01yiPqFbQfXf5WRDLenVOavS
ot+3i9DAgBkcRcAtjOj4LaR0VknFBbVPFd5uRHg5h6h+u/N5GJG79G+dwfCMNYxd
AfvDbbnvRG15RjF+Cv6pgsH/76tuIMRQyV+dTZsXjAzlAcmgQWpzU/qlULRuJQ/7
TBj0/VLZjmmx6BEP3ojY+x1J96relc8geMJgEtslQIxq/H5COEBkEveegeGTLg==
-----END CERTIFICATE-----

Entrust.net Premium 2048 Secure Server CA
================================================
SHA1 Fingerprint=50:30:06:09:1D:97:D4:F5:AE:39:F7:CB:E7:92:7D:7D:65:2D:34:31
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 946069240 (0x3863def8)
    Signature Algorithm: sha1WithRSAEncryption
        Issuer: O=Entrust.net, OU=www.entrust.net/CPS_2048 incorp. by ref. (limits liab.), OU=(c) 1999 Entrust.net Limited, CN=Entrust.net Certification Authority (2048)
        Validity
            Not Before: Dec 24 17:50:51 1999 GMT
            Not After : Jul 24 14:15:12 2029 GMT
        Subject: O=Entrust.net, OU=www.entrust.net/CPS_2048 incorp. by ref. (limits liab.), OU=(c) 1999 Entrust.net Limited, CN=Entrust.net Certification Authority (2048)
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (2048 bit)
                Modulus:
                    00:ad:4d:4b:a9:12:86:b2:ea:a3:20:07:15:16:64:
                    2a:2b:4b:d1:bf:0b:4a:4d:8e:ed:80:76:a5:67:b7:
                    78:40:c0:73:42:c8:68:c0:db:53:2b:dd:5e:b8:76:
                    98:35:93:8b:1a:9d:7c:13:3a:0e:1f:5b:b7:1e:cf:
                    e5:24:14:1e:b1:81:a9:8d:7d:b8:cc:6b:4b:03:f1:
                    02:0c:dc:ab:a5:40:24:00:7f:74:94:a1:9d:08:29:
                    b3:88:0b:f5:87:77:9d:55:cd:e4:c3:7e:d7:6a:64:
                    ab:85:14:86:95:5b:97:32:50:6f:3d:c8:ba:66:0c:
                    e3:fc:bd:b8:49:c1:76:89:49:19:fd:c0:a8:bd:89:
                    a3:67:2f:c6:9f:bc:71:19:60:b8:2d:e9:2c:c9:90:
                    76:66:7b:94:e2:af:78:d6:65:53:5d:3c:d6:9c:b2:
                    cf:29:03:f9:2f:a4:50:b2:d4:48:ce:05:32:55:8a:
                    fd:b2:64:4c:0e:e4:98:07:75:db:7f:df:b9:08:55:
                    60:85:30:29:f9:7b:48:a4:69:86:e3:35:3f:1e:86:
                    5d:7a:7a:15:bd:ef:00:8e:15:22:54:17:00:90:26:
                    93:bc:0e:49:68:91:bf:f8:47:d3:9d:95:42:c1:0e:
                    4d:df:6f:26:cf:c3:18:21:62:66:43:70:d6:d5:c0:
                    07:e1
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Subject Key Identifier: 
                55:E4:81:D1:11:80:BE:D8:89:B9:08:A3:31:F9:A1:24:09:16:B9:70
    Signature Algorithm: sha1WithRSAEncryption
         3b:9b:8f:56:9b:30:e7:53:99:7c:7a:79:a7:4d:97:d7:19:95:
         90:fb:06:1f:ca:33:7c:46:63:8f:96:66:24:fa:40:1b:21:27:
         ca:e6:72:73:f2:4f:fe:31:99:fd:c8:0c:4c:68:53:c6:80:82:
         13:98:fa:b6:ad:da:5d:3d:f1:ce:6e:f6:15:11:94:82:0c:ee:
         3f:95:af:11:ab:0f:d7:2f:de:1f:03:8f:57:2c:1e:c9:bb:9a:
         1a:44:95:eb:18:4f:a6:1f:cd:7d:57:10:2f:9b:04:09:5a:84:
         b5:6e:d8:1d:3a:e1:d6:9e:d1:6c:79:5e:79:1c:14:c5:e3:d0:
         4c:93:3b:65:3c:ed:df:3d:be:a6:e5:95:1a:c3:b5:19:c3:bd:
         5e:5b:bb:ff:23:ef:68:19:cb:12:93:27:5c:03:2d:6f:30:d0:
         1e:b6:1a:ac:de:5a:f7:d1:aa:a8:27:a6:fe:79:81:c4:79:99:
         33:57:ba:12:b0:a9:e0:42:6c:93:ca:56:de:fe:6d:84:0b:08:
         8b:7e:8d:ea:d7:98:21:c6:f3:e7:3c:79:2f:5e:9c:d1:4c:15:
         8d:e1:ec:22:37:cc:9a:43:0b:97:dc:80:90:8d:b3:67:9b:6f:
         48:08:15:56:cf:bf:f1:2b:7c:5e:9a:76:e9:59:90:c5:7c:83:
         35:11:65:51
-----BEGIN CERTIFICATE-----
MIIEKjCCAxKgAwIBAgIEOGPe+DANBgkqhkiG9w0BAQUFADCBtDEUMBIGA1UEChML
RW50cnVzdC5uZXQxQDA+BgNVBAsUN3d3dy5lbnRydXN0Lm5ldC9DUFNfMjA0OCBp
bmNvcnAuIGJ5IHJlZi4gKGxpbWl0cyBsaWFiLikxJTAjBgNVBAsTHChjKSAxOTk5
IEVudHJ1c3QubmV0IExpbWl0ZWQxMzAxBgNVBAMTKkVudHJ1c3QubmV0IENlcnRp
ZmljYXRpb24gQXV0aG9yaXR5ICgyMDQ4KTAeFw05OTEyMjQxNzUwNTFaFw0yOTA3
MjQxNDE1MTJaMIG0MRQwEgYDVQQKEwtFbnRydXN0Lm5ldDFAMD4GA1UECxQ3d3d3
LmVudHJ1c3QubmV0L0NQU18yMDQ4IGluY29ycC4gYnkgcmVmLiAobGltaXRzIGxp
YWIuKTElMCMGA1UECxMcKGMpIDE5OTkgRW50cnVzdC5uZXQgTGltaXRlZDEzMDEG
A1UEAxMqRW50cnVzdC5uZXQgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkgKDIwNDgp
MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEArU1LqRKGsuqjIAcVFmQq
K0vRvwtKTY7tgHalZ7d4QMBzQshowNtTK91euHaYNZOLGp18EzoOH1u3Hs/lJBQe
sYGpjX24zGtLA/ECDNyrpUAkAH90lKGdCCmziAv1h3edVc3kw37XamSrhRSGlVuX
MlBvPci6Zgzj/L24ScF2iUkZ/cCovYmjZy/Gn7xxGWC4LeksyZB2ZnuU4q941mVT
XTzWnLLPKQP5L6RQstRIzgUyVYr9smRMDuSYB3Xbf9+5CFVghTAp+XtIpGmG4zU/
HoZdenoVve8AjhUiVBcAkCaTvA5JaJG/+EfTnZVCwQ5N328mz8MYIWJmQ3DW1cAH
4QIDAQABo0IwQDAOBgNVHQ8BAf8EBAMCAQYwDwYDVR0TAQH/BAUwAwEB/zAdBgNV
HQ4EFgQUVeSB0RGAvtiJuQijMfmhJAkWuXAwDQYJKoZIhvcNAQEFBQADggEBADub
j1abMOdTmXx6eadNl9cZlZD7Bh/KM3xGY4+WZiT6QBshJ8rmcnPyT/4xmf3IDExo
U8aAghOY+rat2l098c5u9hURlIIM7j+VrxGrD9cv3h8Dj1csHsm7mhpElesYT6Yf
zX1XEC+bBAlahLVu2B064dae0Wx5XnkcFMXj0EyTO2U87d89vqbllRrDtRnDvV5b
u/8j72gZyxKTJ1wDLW8w0B62GqzeWvfRqqgnpv55gcR5mTNXuhKwqeBCbJPKVt7+
bYQLCIt+jerXmCHG8+c8eS9enNFMFY3h7CI3zJpDC5fcgJCNs2ebb0gIFVbPv/Er
fF6adulZkMV8gzURZVE=
-----END CERTIFICATE-----

Baltimore CyberTrust Root
================================================
SHA1 Fingerprint=D4:DE:20:D0:5E:66:FC:53:FE:1A:50:88:2C:78:DB:28:52:CA:E4:74
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 33554617 (0x20000b9)
    Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=IE, O=Baltimore, OU=CyberTrust, CN=Baltimore CyberTrust Root
        Validity
            Not Before: May 12 18:46:00 2000 GMT
            Not After : May 12 23:59:00 2025 GMT
        Subject: C=IE, O=Baltimore, OU=CyberTrust, CN=Baltimore CyberTrust Root
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (2048 bit)
                Modulus:
                    00:a3:04:bb:22:ab:98:3d:57:e8:26:72:9a:b5:79:
                    d4:29:e2:e1:e8:95:80:b1:b0:e3:5b:8e:2b:29:9a:
                    64:df:a1:5d:ed:b0:09:05:6d:db:28:2e:ce:62:a2:
                    62:fe:b4:88:da:12:eb:38:eb:21:9d:c0:41:2b:01:
                    52:7b:88:77:d3:1c:8f:c7:ba:b9:88:b5:6a:09:e7:
                    73:e8:11:40:a7:d1:cc:ca:62:8d:2d:e5:8f:0b:a6:
                    50:d2:a8:50:c3:28:ea:f5:ab:25:87:8a:9a:96:1c:
                    a9:67:b8:3f:0c:d5:f7:f9:52:13:2f:c2:1b:d5:70:
                    70:f0:8f:c0:12:ca:06:cb:9a:e1:d9:ca:33:7a:77:
                    d6:f8:ec:b9:f1:68:44:42:48:13:d2:c0:c2:a4:ae:
                    5e:60:fe:b6:a6:05:fc:b4:dd:07:59:02:d4:59:18:
                    98:63:f5:a5:63:e0:90:0c:7d:5d:b2:06:7a:f3:85:
                    ea:eb:d4:03:ae:5e:84:3e:5f:ff:15:ed:69:bc:f9:
                    39:36:72:75:cf:77:52:4d:f3:c9:90:2c:b9:3d:e5:
                    c9:23:53:3f:1f:24:98:21:5c:07:99:29:bd:c6:3a:
                    ec:e7:6e:86:3a:6b:97:74:63:33:bd:68:18:31:f0:
                    78:8d:76:bf:fc:9e:8e:5d:2a:86:a7:4d:90:dc:27:
                    1a:39
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Subject Key Identifier: 
                E5:9D:59:30:82:47:58:CC:AC:FA:08:54:36:86:7B:3A:B5:04:4D:F0
            X509v3 Basic Constraints: critical
                CA:TRUE, pathlen:3
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
    Signature Algorithm: sha1WithRSAEncryption
         85:0c:5d:8e:e4:6f:51:68:42:05:a0:dd:bb:4f:27:25:84:03:
         bd:f7:64:fd:2d:d7:30:e3:a4:10:17:eb:da:29:29:b6:79:3f:
         76:f6:19:13:23:b8:10:0a:f9:58:a4:d4:61:70:bd:04:61:6a:
         12:8a:17:d5:0a:bd:c5:bc:30:7c:d6:e9:0c:25:8d:86:40:4f:
         ec:cc:a3:7e:38:c6:37:11:4f:ed:dd:68:31:8e:4c:d2:b3:01:
         74:ee:be:75:5e:07:48:1a:7f:70:ff:16:5c:84:c0:79:85:b8:
         05:fd:7f:be:65:11:a3:0f:c0:02:b4:f8:52:37:39:04:d5:a9:
         31:7a:18:bf:a0:2a:f4:12:99:f7:a3:45:82:e3:3c:5e:f5:9d:
         9e:b5:c8:9e:7c:2e:c8:a4:9e:4e:08:14:4b:6d:fd:70:6d:6b:
         1a:63:bd:64:e6:1f:b7:ce:f0:f2:9f:2e:bb:1b:b7:f2:50:88:
         73:92:c2:e2:e3:16:8d:9a:32:02:ab:8e:18:dd:e9:10:11:ee:
         7e:35:ab:90:af:3e:30:94:7a:d0:33:3d:a7:65:0f:f5:fc:8e:
         9e:62:cf:47:44:2c:01:5d:bb:1d:b5:32:d2:47:d2:38:2e:d0:
         fe:81:dc:32:6a:1e:b5:ee:3c:d5:fc:e7:81:1d:19:c3:24:42:
         ea:63:39:a9
-----BEGIN CERTIFICATE-----
MIIDdzCCAl+gAwIBAgIEAgAAuTANBgkqhkiG9w0BAQUFADBaMQswCQYDVQQGEwJJ
RTESMBAGA1UEChMJQmFsdGltb3JlMRMwEQYDVQQLEwpDeWJlclRydXN0MSIwIAYD
VQQDExlCYWx0aW1vcmUgQ3liZXJUcnVzdCBSb290MB4XDTAwMDUxMjE4NDYwMFoX
DTI1MDUxMjIzNTkwMFowWjELMAkGA1UEBhMCSUUxEjAQBgNVBAoTCUJhbHRpbW9y
ZTETMBEGA1UECxMKQ3liZXJUcnVzdDEiMCAGA1UEAxMZQmFsdGltb3JlIEN5YmVy
VHJ1c3QgUm9vdDCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAKMEuyKr
mD1X6CZymrV51Cni4eiVgLGw41uOKymaZN+hXe2wCQVt2yguzmKiYv60iNoS6zjr
IZ3AQSsBUnuId9Mcj8e6uYi1agnnc+gRQKfRzMpijS3ljwumUNKoUMMo6vWrJYeK
mpYcqWe4PwzV9/lSEy/CG9VwcPCPwBLKBsua4dnKM3p31vjsufFoREJIE9LAwqSu
XmD+tqYF/LTdB1kC1FkYmGP1pWPgkAx9XbIGevOF6uvUA65ehD5f/xXtabz5OTZy
dc93Uk3zyZAsuT3lySNTPx8kmCFcB5kpvcY67Oduhjprl3RjM71oGDHweI12v/ye
jl0qhqdNkNwnGjkCAwEAAaNFMEMwHQYDVR0OBBYEFOWdWTCCR1jMrPoIVDaGezq1
BE3wMBIGA1UdEwEB/wQIMAYBAf8CAQMwDgYDVR0PAQH/BAQDAgEGMA0GCSqGSIb3
DQEBBQUAA4IBAQCFDF2O5G9RaEIFoN27TyclhAO992T9Ldcw46QQF+vaKSm2eT92
9hkTI7gQCvlYpNRhcL0EYWoSihfVCr3FvDB81ukMJY2GQE/szKN+OMY3EU/t3Wgx
jkzSswF07r51XgdIGn9w/xZchMB5hbgF/X++ZRGjD8ACtPhSNzkE1akxehi/oCr0
Epn3o0WC4zxe9Z2etciefC7IpJ5OCBRLbf1wbWsaY71k5h+3zvDyny67G7fyUIhz
ksLi4xaNmjICq44Y3ekQEe5+NauQrz4wlHrQMz2nZQ/1/I6eYs9HRCwBXbsdtTLS
R9I4LtD+gdwyah617jzV/OeBHRnDJELqYzmp
-----END CERTIFICATE-----

Entrust Root Certification Authority
=================================================
SHA1 Fingerprint=B3:1E:B1:B7:40:E3:6C:84:02:DA:DC:37:D4:4D:F5:D4:67:49:52:F9
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 1164660820 (0x456b5054)
    Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=Entrust, Inc., OU=www.entrust.net/CPS is incorporated by reference, OU=(c) 2006 Entrust, Inc., CN=Entrust Root Certification Authority
        Validity
            Not Before: Nov 27 20:23:42 2006 GMT
            Not After : Nov 27 20:53:42 2026 GMT
        Subject: C=US, O=Entrust, Inc., OU=www.entrust.net/CPS is incorporated by reference, OU=(c) 2006 Entrust, Inc., CN=Entrust Root Certification Authority
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (2048 bit)
                Modulus:
                    00:b6:95:b6:43:42:fa:c6:6d:2a:6f:48:df:94:4c:
                    39:57:05:ee:c3:79:11:41:68:36:ed:ec:fe:9a:01:
                    8f:a1:38:28:fc:f7:10:46:66:2e:4d:1e:1a:b1:1a:
                    4e:c6:d1:c0:95:88:b0:c9:ff:31:8b:33:03:db:b7:
                    83:7b:3e:20:84:5e:ed:b2:56:28:a7:f8:e0:b9:40:
                    71:37:c5:cb:47:0e:97:2a:68:c0:22:95:62:15:db:
                    47:d9:f5:d0:2b:ff:82:4b:c9:ad:3e:de:4c:db:90:
                    80:50:3f:09:8a:84:00:ec:30:0a:3d:18:cd:fb:fd:
                    2a:59:9a:23:95:17:2c:45:9e:1f:6e:43:79:6d:0c:
                    5c:98:fe:48:a7:c5:23:47:5c:5e:fd:6e:e7:1e:b4:
                    f6:68:45:d1:86:83:5b:a2:8a:8d:b1:e3:29:80:fe:
                    25:71:88:ad:be:bc:8f:ac:52:96:4b:aa:51:8d:e4:
                    13:31:19:e8:4e:4d:9f:db:ac:b3:6a:d5:bc:39:54:
                    71:ca:7a:7a:7f:90:dd:7d:1d:80:d9:81:bb:59:26:
                    c2:11:fe:e6:93:e2:f7:80:e4:65:fb:34:37:0e:29:
                    80:70:4d:af:38:86:2e:9e:7f:57:af:9e:17:ae:eb:
                    1c:cb:28:21:5f:b6:1c:d8:e7:a2:04:22:f9:d3:da:
                    d8:cb
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Private Key Usage Period: 
                Not Before: Nov 27 20:23:42 2006 GMT, Not After: Nov 27 20:53:42 2026 GMT
            X509v3 Authority Key Identifier: 
                keyid:68:90:E4:67:A4:A6:53:80:C7:86:66:A4:F1:F7:4B:43:FB:84:BD:6D

            X509v3 Subject Key Identifier: 
                68:90:E4:67:A4:A6:53:80:C7:86:66:A4:F1:F7:4B:43:FB:84:BD:6D
            1.2.840.113533.7.65.0: 
                0...V7.1:4.0....
    Signature Algorithm: sha1WithRSAEncryption
         93:d4:30:b0:d7:03:20:2a:d0:f9:63:e8:91:0c:05:20:a9:5f:
         19:ca:7b:72:4e:d4:b1:db:d0:96:fb:54:5a:19:2c:0c:08:f7:
         b2:bc:85:a8:9d:7f:6d:3b:52:b3:2a:db:e7:d4:84:8c:63:f6:
         0f:cb:26:01:91:50:6c:f4:5f:14:e2:93:74:c0:13:9e:30:3a:
         50:e3:b4:60:c5:1c:f0:22:44:8d:71:47:ac:c8:1a:c9:e9:9b:
         9a:00:60:13:ff:70:7e:5f:11:4d:49:1b:b3:15:52:7b:c9:54:
         da:bf:9d:95:af:6b:9a:d8:9e:e9:f1:e4:43:8d:e2:11:44:3a:
         bf:af:bd:83:42:73:52:8b:aa:bb:a7:29:cf:f5:64:1c:0a:4d:
         d1:bc:aa:ac:9f:2a:d0:ff:7f:7f:da:7d:ea:b1:ed:30:25:c1:
         84:da:34:d2:5b:78:83:56:ec:9c:36:c3:26:e2:11:f6:67:49:
         1d:92:ab:8c:fb:eb:ff:7a:ee:85:4a:a7:50:80:f0:a7:5c:4a:
         94:2e:5f:05:99:3c:52:41:e0:cd:b4:63:cf:01:43:ba:9c:83:
         dc:8f:60:3b:f3:5a:b4:b4:7b:ae:da:0b:90:38:75:ef:81:1d:
         66:d2:f7:57:70:36:b3:bf:fc:28:af:71:25:85:5b:13:fe:1e:
         7f:5a:b4:3c
-----BEGIN CERTIFICATE-----
MIIEkTCCA3mgAwIBAgIERWtQVDANBgkqhkiG9w0BAQUFADCBsDELMAkGA1UEBhMC
VVMxFjAUBgNVBAoTDUVudHJ1c3QsIEluYy4xOTA3BgNVBAsTMHd3dy5lbnRydXN0
Lm5ldC9DUFMgaXMgaW5jb3Jwb3JhdGVkIGJ5IHJlZmVyZW5jZTEfMB0GA1UECxMW
KGMpIDIwMDYgRW50cnVzdCwgSW5jLjEtMCsGA1UEAxMkRW50cnVzdCBSb290IENl
cnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA2MTEyNzIwMjM0MloXDTI2MTEyNzIw
NTM0MlowgbAxCzAJBgNVBAYTAlVTMRYwFAYDVQQKEw1FbnRydXN0LCBJbmMuMTkw
NwYDVQQLEzB3d3cuZW50cnVzdC5uZXQvQ1BTIGlzIGluY29ycG9yYXRlZCBieSBy
ZWZlcmVuY2UxHzAdBgNVBAsTFihjKSAyMDA2IEVudHJ1c3QsIEluYy4xLTArBgNV
BAMTJEVudHJ1c3QgUm9vdCBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTCCASIwDQYJ
KoZIhvcNAQEBBQADggEPADCCAQoCggEBALaVtkNC+sZtKm9I35RMOVcF7sN5EUFo
Nu3s/poBj6E4KPz3EEZmLk0eGrEaTsbRwJWIsMn/MYszA9u3g3s+IIRe7bJWKKf4
4LlAcTfFy0cOlypowCKVYhXbR9n10Cv/gkvJrT7eTNuQgFA/CYqEAOwwCj0Yzfv9
KlmaI5UXLEWeH25DeW0MXJj+SKfFI0dcXv1u5x609mhF0YaDW6KKjbHjKYD+JXGI
rb68j6xSlkuqUY3kEzEZ6E5Nn9uss2rVvDlUccp6en+Q3X0dgNmBu1kmwhH+5pPi
94DkZfs0Nw4pgHBNrziGLp5/V6+eF67rHMsoIV+2HNjnogQi+dPa2MsCAwEAAaOB
sDCBrTAOBgNVHQ8BAf8EBAMCAQYwDwYDVR0TAQH/BAUwAwEB/zArBgNVHRAEJDAi
gA8yMDA2MTEyNzIwMjM0MlqBDzIwMjYxMTI3MjA1MzQyWjAfBgNVHSMEGDAWgBRo
kORnpKZTgMeGZqTx90tD+4S9bTAdBgNVHQ4EFgQUaJDkZ6SmU4DHhmak8fdLQ/uE
vW0wHQYJKoZIhvZ9B0EABBAwDhsIVjcuMTo0LjADAgSQMA0GCSqGSIb3DQEBBQUA
A4IBAQCT1DCw1wMgKtD5Y+iRDAUgqV8ZyntyTtSx29CW+1RaGSwMCPeyvIWonX9t
O1KzKtvn1ISMY/YPyyYBkVBs9F8U4pN0wBOeMDpQ47RgxRzwIkSNcUesyBrJ6Zua
AGAT/3B+XxFNSRuzFVJ7yVTav52Vr2ua2J7p8eRDjeIRRDq/r72DQnNSi6q7pynP
9WQcCk3RvKqsnyrQ/39/2n3qse0wJcGE2jTSW3iDVuycNsMm4hH2Z0kdkquM++v/
eu6FSqdQgPCnXEqULl8FmTxSQeDNtGPPAUO6nIPcj2A781q0tHuu2guQOHXvgR1m
0vdXcDazv/wor3ElhVsT/h5/WrQ8
-----END CERTIFICATE-----

Comodo AAA Services root
================================================
SHA1 Fingerprint=D1:EB:23:A4:6D:17:D6:8F:D9:25:64:C2:F1:F1:60:17:64:D8:E3:49
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 1 (0x1)
    Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=GB, ST=Greater Manchester, L=Salford, O=Comodo CA Limited, CN=AAA Certificate Services
        Validity
            Not Before: Jan  1 00:00:00 2004 GMT
            Not After : Dec 31 23:59:59 2028 GMT
        Subject: C=GB, ST=Greater Manchester, L=Salford, O=Comodo CA Limited, CN=AAA Certificate Services
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (2048 bit)
                Modulus:
                    00:be:40:9d:f4:6e:e1:ea:76:87:1c:4d:45:44:8e:
                    be:46:c8:83:06:9d:c1:2a:fe:18:1f:8e:e4:02:fa:
                    f3:ab:5d:50:8a:16:31:0b:9a:06:d0:c5:70:22:cd:
                    49:2d:54:63:cc:b6:6e:68:46:0b:53:ea:cb:4c:24:
                    c0:bc:72:4e:ea:f1:15:ae:f4:54:9a:12:0a:c3:7a:
                    b2:33:60:e2:da:89:55:f3:22:58:f3:de:dc:cf:ef:
                    83:86:a2:8c:94:4f:9f:68:f2:98:90:46:84:27:c7:
                    76:bf:e3:cc:35:2c:8b:5e:07:64:65:82:c0:48:b0:
                    a8:91:f9:61:9f:76:20:50:a8:91:c7:66:b5:eb:78:
                    62:03:56:f0:8a:1a:13:ea:31:a3:1e:a0:99:fd:38:
                    f6:f6:27:32:58:6f:07:f5:6b:b8:fb:14:2b:af:b7:
                    aa:cc:d6:63:5f:73:8c:da:05:99:a8:38:a8:cb:17:
                    78:36:51:ac:e9:9e:f4:78:3a:8d:cf:0f:d9:42:e2:
                    98:0c:ab:2f:9f:0e:01:de:ef:9f:99:49:f1:2d:df:
                    ac:74:4d:1b:98:b5:47:c5:e5:29:d1:f9:90:18:c7:
                    62:9c:be:83:c7:26:7b:3e:8a:25:c7:c0:dd:9d:e6:
                    35:68:10:20:9d:8f:d8:de:d2:c3:84:9c:0d:5e:e8:
                    2f:c9
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Subject Key Identifier: 
                A0:11:0A:23:3E:96:F1:07:EC:E2:AF:29:EF:82:A5:7F:D0:30:A4:B4
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 CRL Distribution Points: 

                Full Name:
                  URI:http://crl.comodoca.com/AAACertificateServices.crl

                Full Name:
                  URI:http://crl.comodo.net/AAACertificateServices.crl

    Signature Algorithm: sha1WithRSAEncryption
         08:56:fc:02:f0:9b:e8:ff:a4:fa:d6:7b:c6:44:80:ce:4f:c4:
         c5:f6:00:58:cc:a6:b6:bc:14:49:68:04:76:e8:e6:ee:5d:ec:
         02:0f:60:d6:8d:50:18:4f:26:4e:01:e3:e6:b0:a5:ee:bf:bc:
         74:54:41:bf:fd:fc:12:b8:c7:4f:5a:f4:89:60:05:7f:60:b7:
         05:4a:f3:f6:f1:c2:bf:c4:b9:74:86:b6:2d:7d:6b:cc:d2:f3:
         46:dd:2f:c6:e0:6a:c3:c3:34:03:2c:7d:96:dd:5a:c2:0e:a7:
         0a:99:c1:05:8b:ab:0c:2f:f3:5c:3a:cf:6c:37:55:09:87:de:
         53:40:6c:58:ef:fc:b6:ab:65:6e:04:f6:1b:dc:3c:e0:5a:15:
         c6:9e:d9:f1:59:48:30:21:65:03:6c:ec:e9:21:73:ec:9b:03:
         a1:e0:37:ad:a0:15:18:8f:fa:ba:02:ce:a7:2c:a9:10:13:2c:
         d4:e5:08:26:ab:22:97:60:f8:90:5e:74:d4:a2:9a:53:bd:f2:
         a9:68:e0:a2:6e:c2:d7:6c:b1:a3:0f:9e:bf:eb:68:e7:56:f2:
         ae:f2:e3:2b:38:3a:09:81:b5:6b:85:d7:be:2d:ed:3f:1a:b7:
         b2:63:e2:f5:62:2c:82:d4:6a:00:41:50:f1:39:83:9f:95:e9:
         36:96:98:6e
-----BEGIN CERTIFICATE-----
MIIEMjCCAxqgAwIBAgIBATANBgkqhkiG9w0BAQUFADB7MQswCQYDVQQGEwJHQjEb
MBkGA1UECAwSR3JlYXRlciBNYW5jaGVzdGVyMRAwDgYDVQQHDAdTYWxmb3JkMRow
GAYDVQQKDBFDb21vZG8gQ0EgTGltaXRlZDEhMB8GA1UEAwwYQUFBIENlcnRpZmlj
YXRlIFNlcnZpY2VzMB4XDTA0MDEwMTAwMDAwMFoXDTI4MTIzMTIzNTk1OVowezEL
MAkGA1UEBhMCR0IxGzAZBgNVBAgMEkdyZWF0ZXIgTWFuY2hlc3RlcjEQMA4GA1UE
BwwHU2FsZm9yZDEaMBgGA1UECgwRQ29tb2RvIENBIExpbWl0ZWQxITAfBgNVBAMM
GEFBQSBDZXJ0aWZpY2F0ZSBTZXJ2aWNlczCCASIwDQYJKoZIhvcNAQEBBQADggEP
ADCCAQoCggEBAL5AnfRu4ep2hxxNRUSOvkbIgwadwSr+GB+O5AL686tdUIoWMQua
BtDFcCLNSS1UY8y2bmhGC1Pqy0wkwLxyTurxFa70VJoSCsN6sjNg4tqJVfMiWPPe
3M/vg4aijJRPn2jymJBGhCfHdr/jzDUsi14HZGWCwEiwqJH5YZ92IFCokcdmtet4
YgNW8IoaE+oxox6gmf049vYnMlhvB/VruPsUK6+3qszWY19zjNoFmag4qMsXeDZR
rOme9Hg6jc8P2ULimAyrL58OAd7vn5lJ8S3frHRNG5i1R8XlKdH5kBjHYpy+g8cm
ez6KJcfA3Z3mNWgQIJ2P2N7Sw4ScDV7oL8kCAwEAAaOBwDCBvTAdBgNVHQ4EFgQU
oBEKIz6W8Qfs4q8p74Klf9AwpLQwDgYDVR0PAQH/BAQDAgEGMA8GA1UdEwEB/wQF
MAMBAf8wewYDVR0fBHQwcjA4oDagNIYyaHR0cDovL2NybC5jb21vZG9jYS5jb20v
QUFBQ2VydGlmaWNhdGVTZXJ2aWNlcy5jcmwwNqA0oDKGMGh0dHA6Ly9jcmwuY29t
b2RvLm5ldC9BQUFDZXJ0aWZpY2F0ZVNlcnZpY2VzLmNybDANBgkqhkiG9w0BAQUF
AAOCAQEACFb8AvCb6P+k+tZ7xkSAzk/ExfYAWMymtrwUSWgEdujm7l3sAg9g1o1Q
GE8mTgHj5rCl7r+8dFRBv/38ErjHT1r0iWAFf2C3BUrz9vHCv8S5dIa2LX1rzNLz
Rt0vxuBqw8M0Ayx9lt1awg6nCpnBBYurDC/zXDrPbDdVCYfeU0BsWO/8tqtlbgT2
G9w84FoVxp7Z8VlIMCFlA2zs6SFz7JsDoeA3raAVGI/6ugLOpyypEBMs1OUIJqsi
l2D4kF501KKaU73yqWjgom7C12yxow+ev+to51byrvLjKzg6CYG1a4XXvi3tPxq3
smPi9WIsgtRqAEFQ8TmDn5XpNpaYbg==
-----END CERTIFICATE-----

QuoVadis Root CA 2
================================================
SHA1 Fingerprint=CA:3A:FB:CF:12:40:36:4B:44:B2:16:20:88:80:48:39:19:93:7C:F7
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 1289 (0x509)
    Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=BM, O=QuoVadis Limited, CN=QuoVadis Root CA 2
        Validity
            Not Before: Nov 24 18:27:00 2006 GMT
            Not After : Nov 24 18:23:33 2031 GMT
        Subject: C=BM, O=QuoVadis Limited, CN=QuoVadis Root CA 2
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (4096 bit)
                Modulus:
                    00:9a:18:ca:4b:94:0d:00:2d:af:03:29:8a:f0:0f:
                    81:c8:ae:4c:19:85:1d:08:9f:ab:29:44:85:f3:2f:
                    81:ad:32:1e:90:46:bf:a3:86:26:1a:1e:fe:7e:1c:
                    18:3a:5c:9c:60:17:2a:3a:74:83:33:30:7d:61:54:
                    11:cb:ed:ab:e0:e6:d2:a2:7e:f5:6b:6f:18:b7:0a:
                    0b:2d:fd:e9:3e:ef:0a:c6:b3:10:e9:dc:c2:46:17:
                    f8:5d:fd:a4:da:ff:9e:49:5a:9c:e6:33:e6:24:96:
                    f7:3f:ba:5b:2b:1c:7a:35:c2:d6:67:fe:ab:66:50:
                    8b:6d:28:60:2b:ef:d7:60:c3:c7:93:bc:8d:36:91:
                    f3:7f:f8:db:11:13:c4:9c:77:76:c1:ae:b7:02:6a:
                    81:7a:a9:45:83:e2:05:e6:b9:56:c1:94:37:8f:48:
                    71:63:22:ec:17:65:07:95:8a:4b:df:8f:c6:5a:0a:
                    e5:b0:e3:5f:5e:6b:11:ab:0c:f9:85:eb:44:e9:f8:
                    04:73:f2:e9:fe:5c:98:8c:f5:73:af:6b:b4:7e:cd:
                    d4:5c:02:2b:4c:39:e1:b2:95:95:2d:42:87:d7:d5:
                    b3:90:43:b7:6c:13:f1:de:dd:f6:c4:f8:89:3f:d1:
                    75:f5:92:c3:91:d5:8a:88:d0:90:ec:dc:6d:de:89:
                    c2:65:71:96:8b:0d:03:fd:9c:bf:5b:16:ac:92:db:
                    ea:fe:79:7c:ad:eb:af:f7:16:cb:db:cd:25:2b:e5:
                    1f:fb:9a:9f:e2:51:cc:3a:53:0c:48:e6:0e:bd:c9:
                    b4:76:06:52:e6:11:13:85:72:63:03:04:e0:04:36:
                    2b:20:19:02:e8:74:a7:1f:b6:c9:56:66:f0:75:25:
                    dc:67:c1:0e:61:60:88:b3:3e:d1:a8:fc:a3:da:1d:
                    b0:d1:b1:23:54:df:44:76:6d:ed:41:d8:c1:b2:22:
                    b6:53:1c:df:35:1d:dc:a1:77:2a:31:e4:2d:f5:e5:
                    e5:db:c8:e0:ff:e5:80:d7:0b:63:a0:ff:33:a1:0f:
                    ba:2c:15:15:ea:97:b3:d2:a2:b5:be:f2:8c:96:1e:
                    1a:8f:1d:6c:a4:61:37:b9:86:73:33:d7:97:96:9e:
                    23:7d:82:a4:4c:81:e2:a1:d1:ba:67:5f:95:07:a3:
                    27:11:ee:16:10:7b:bc:45:4a:4c:b2:04:d2:ab:ef:
                    d5:fd:0c:51:ce:50:6a:08:31:f9:91:da:0c:8f:64:
                    5c:03:c3:3a:8b:20:3f:6e:8d:67:3d:3a:d6:fe:7d:
                    5b:88:c9:5e:fb:cc:61:dc:8b:33:77:d3:44:32:35:
                    09:62:04:92:16:10:d8:9e:27:47:fb:3b:21:e3:f8:
                    eb:1d:5b
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Key Usage: 
                Certificate Sign, CRL Sign
            X509v3 Subject Key Identifier: 
                1A:84:62:BC:48:4C:33:25:04:D4:EE:D0:F6:03:C4:19:46:D1:94:6B
            X509v3 Authority Key Identifier: 
                keyid:1A:84:62:BC:48:4C:33:25:04:D4:EE:D0:F6:03:C4:19:46:D1:94:6B
                DirName:/C=BM/O=QuoVadis Limited/CN=QuoVadis Root CA 2
                serial:05:09

    Signature Algorithm: sha1WithRSAEncryption
         3e:0a:16:4d:9f:06:5b:a8:ae:71:5d:2f:05:2f:67:e6:13:45:
         83:c4:36:f6:f3:c0:26:0c:0d:b5:47:64:5d:f8:b4:72:c9:46:
         a5:03:18:27:55:89:78:7d:76:ea:96:34:80:17:20:dc:e7:83:
         f8:8d:fc:07:b8:da:5f:4d:2e:67:b2:84:fd:d9:44:fc:77:50:
         81:e6:7c:b4:c9:0d:0b:72:53:f8:76:07:07:41:47:96:0c:fb:
         e0:82:26:93:55:8c:fe:22:1f:60:65:7c:5f:e7:26:b3:f7:32:
         90:98:50:d4:37:71:55:f6:92:21:78:f7:95:79:fa:f8:2d:26:
         87:66:56:30:77:a6:37:78:33:52:10:58:ae:3f:61:8e:f2:6a:
         b1:ef:18:7e:4a:59:63:ca:8d:a2:56:d5:a7:2f:bc:56:1f:cf:
         39:c1:e2:fb:0a:a8:15:2c:7d:4d:7a:63:c6:6c:97:44:3c:d2:
         6f:c3:4a:17:0a:f8:90:d2:57:a2:19:51:a5:2d:97:41:da:07:
         4f:a9:50:da:90:8d:94:46:e1:3e:f0:94:fd:10:00:38:f5:3b:
         e8:40:e1:b4:6e:56:1a:20:cc:6f:58:8d:ed:2e:45:8f:d6:e9:
         93:3f:e7:b1:2c:df:3a:d6:22:8c:dc:84:bb:22:6f:d0:f8:e4:
         c6:39:e9:04:88:3c:c3:ba:eb:55:7a:6d:80:99:24:f5:6c:01:
         fb:f8:97:b0:94:5b:eb:fd:d2:6f:f1:77:68:0d:35:64:23:ac:
         b8:55:a1:03:d1:4d:42:19:dc:f8:75:59:56:a3:f9:a8:49:79:
         f8:af:0e:b9:11:a0:7c:b7:6a:ed:34:d0:b6:26:62:38:1a:87:
         0c:f8:e8:fd:2e:d3:90:7f:07:91:2a:1d:d6:7e:5c:85:83:99:
         b0:38:08:3f:e9:5e:f9:35:07:e4:c9:62:6e:57:7f:a7:50:95:
         f7:ba:c8:9b:e6:8e:a2:01:c5:d6:66:bf:79:61:f3:3c:1c:e1:
         b9:82:5c:5d:a0:c3:e9:d8:48:bd:19:a2:11:14:19:6e:b2:86:
         1b:68:3e:48:37:1a:88:b7:5d:96:5e:9c:c7:ef:27:62:08:e2:
         91:19:5c:d2:f1:21:dd:ba:17:42:82:97:71:81:53:31:a9:9f:
         f6:7d:62:bf:72:e1:a3:93:1d:cc:8a:26:5a:09:38:d0:ce:d7:
         0d:80:16:b4:78:a5:3a:87:4c:8d:8a:a5:d5:46:97:f2:2c:10:
         b9:bc:54:22:c0:01:50:69:43:9e:f4:b2:ef:6d:f8:ec:da:f1:
         e3:b1:ef:df:91:8f:54:2a:0b:25:c1:26:19:c4:52:10:05:65:
         d5:82:10:ea:c2:31:cd:2e
-----BEGIN CERTIFICATE-----
MIIFtzCCA5+gAwIBAgICBQkwDQYJKoZIhvcNAQEFBQAwRTELMAkGA1UEBhMCQk0x
GTAXBgNVBAoTEFF1b1ZhZGlzIExpbWl0ZWQxGzAZBgNVBAMTElF1b1ZhZGlzIFJv
b3QgQ0EgMjAeFw0wNjExMjQxODI3MDBaFw0zMTExMjQxODIzMzNaMEUxCzAJBgNV
BAYTAkJNMRkwFwYDVQQKExBRdW9WYWRpcyBMaW1pdGVkMRswGQYDVQQDExJRdW9W
YWRpcyBSb290IENBIDIwggIiMA0GCSqGSIb3DQEBAQUAA4ICDwAwggIKAoICAQCa
GMpLlA0ALa8DKYrwD4HIrkwZhR0In6spRIXzL4GtMh6QRr+jhiYaHv5+HBg6XJxg
Fyo6dIMzMH1hVBHL7avg5tKifvVrbxi3Cgst/ek+7wrGsxDp3MJGF/hd/aTa/55J
WpzmM+Yklvc/ulsrHHo1wtZn/qtmUIttKGAr79dgw8eTvI02kfN/+NsRE8Scd3bB
rrcCaoF6qUWD4gXmuVbBlDePSHFjIuwXZQeVikvfj8ZaCuWw419eaxGrDPmF60Tp
+ARz8un+XJiM9XOva7R+zdRcAitMOeGylZUtQofX1bOQQ7dsE/He3fbE+Ik/0XX1
ksOR1YqI0JDs3G3eicJlcZaLDQP9nL9bFqyS2+r+eXyt66/3FsvbzSUr5R/7mp/i
Ucw6UwxI5g69ybR2BlLmEROFcmMDBOAENisgGQLodKcftslWZvB1JdxnwQ5hYIiz
PtGo/KPaHbDRsSNU30R2be1B2MGyIrZTHN81Hdyhdyox5C315eXbyOD/5YDXC2Og
/zOhD7osFRXql7PSorW+8oyWHhqPHWykYTe5hnMz15eWniN9gqRMgeKh0bpnX5UH
oycR7hYQe7xFSkyyBNKr79X9DFHOUGoIMfmR2gyPZFwDwzqLID9ujWc9Otb+fVuI
yV77zGHcizN300QyNQliBJIWENieJ0f7OyHj+OsdWwIDAQABo4GwMIGtMA8GA1Ud
EwEB/wQFMAMBAf8wCwYDVR0PBAQDAgEGMB0GA1UdDgQWBBQahGK8SEwzJQTU7tD2
A8QZRtGUazBuBgNVHSMEZzBlgBQahGK8SEwzJQTU7tD2A8QZRtGUa6FJpEcwRTEL
MAkGA1UEBhMCQk0xGTAXBgNVBAoTEFF1b1ZhZGlzIExpbWl0ZWQxGzAZBgNVBAMT
ElF1b1ZhZGlzIFJvb3QgQ0EgMoICBQkwDQYJKoZIhvcNAQEFBQADggIBAD4KFk2f
BluornFdLwUvZ+YTRYPENvbzwCYMDbVHZF34tHLJRqUDGCdViXh9duqWNIAXINzn
g/iN/Ae42l9NLmeyhP3ZRPx3UIHmfLTJDQtyU/h2BwdBR5YM++CCJpNVjP4iH2Bl
fF/nJrP3MpCYUNQ3cVX2kiF495V5+vgtJodmVjB3pjd4M1IQWK4/YY7yarHvGH5K
WWPKjaJW1acvvFYfzznB4vsKqBUsfU16Y8Zsl0Q80m/DShcK+JDSV6IZUaUtl0Ha
B0+pUNqQjZRG4T7wlP0QADj1O+hA4bRuVhogzG9Yje0uRY/W6ZM/57Es3zrWIozc
hLsib9D45MY56QSIPMO661V6bYCZJPVsAfv4l7CUW+v90m/xd2gNNWQjrLhVoQPR
TUIZ3Ph1WVaj+ahJefivDrkRoHy3au000LYmYjgahwz46P0u05B/B5EqHdZ+XIWD
mbA4CD/pXvk1B+TJYm5Xf6dQlfe6yJvmjqIBxdZmv3lh8zwc4bmCXF2gw+nYSL0Z
ohEUGW6yhhtoPkg3Goi3XZZenMfvJ2II4pEZXNLxId26F0KCl3GBUzGpn/Z9Yr9y
4aOTHcyKJloJONDO1w2AFrR4pTqHTI2KpdVGl/IsELm8VCLAAVBpQ570su9t+Oza
8eOx79+Rj1QqCyXBJhnEUhAFZdWCEOrCMc0u
-----END CERTIFICATE-----

QuoVadis Root CA 3
================================================
SHA1 Fingerprint=1F:49:14:F7:D8:74:95:1D:DD:AE:02:C0:BE:FD:3A:2D:82:75:51:85
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 1478 (0x5c6)
    Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=BM, O=QuoVadis Limited, CN=QuoVadis Root CA 3
        Validity
            Not Before: Nov 24 19:11:23 2006 GMT
            Not After : Nov 24 19:06:44 2031 GMT
        Subject: C=BM, O=QuoVadis Limited, CN=QuoVadis Root CA 3
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (4096 bit)
                Modulus:
                    00:cc:57:42:16:54:9c:e6:98:d3:d3:4d:ee:fe:ed:
                    c7:9f:43:39:4a:65:b3:e8:16:88:34:db:0d:59:91:
                    74:cf:92:b8:04:40:ad:02:4b:31:ab:bc:8d:91:68:
                    d8:20:0e:1a:01:e2:1a:7b:4e:17:5d:e2:8a:b7:3f:
                    99:1a:cd:eb:61:ab:c2:65:a6:1f:b7:b7:bd:b7:8f:
                    fc:fd:70:8f:0b:a0:67:be:01:a2:59:cf:71:e6:0f:
                    29:76:ff:b1:56:79:45:2b:1f:9e:7a:54:e8:a3:29:
                    35:68:a4:01:4f:0f:a4:2e:37:ef:1b:bf:e3:8f:10:
                    a8:72:ab:58:57:e7:54:86:c8:c9:f3:5b:da:2c:da:
                    5d:8e:6e:3c:a3:3e:da:fb:82:e5:dd:f2:5c:b2:05:
                    33:6f:8a:36:ce:d0:13:4e:ff:bf:4a:0c:34:4c:a6:
                    c3:21:bd:50:04:55:eb:b1:bb:9d:fb:45:1e:64:15:
                    de:55:01:8c:02:76:b5:cb:a1:3f:42:69:bc:2f:bd:
                    68:43:16:56:89:2a:37:61:91:fd:a6:ae:4e:c0:cb:
                    14:65:94:37:4b:92:06:ef:04:d0:c8:9c:88:db:0b:
                    7b:81:af:b1:3d:2a:c4:65:3a:78:b6:ee:dc:80:b1:
                    d2:d3:99:9c:3a:ee:6b:5a:6b:b3:8d:b7:d5:ce:9c:
                    c2:be:a5:4b:2f:16:b1:9e:68:3b:06:6f:ae:7d:9f:
                    f8:de:ec:cc:29:a7:98:a3:25:43:2f:ef:f1:5f:26:
                    e1:88:4d:f8:5e:6e:d7:d9:14:6e:19:33:69:a7:3b:
                    84:89:93:c4:53:55:13:a1:51:78:40:f8:b8:c9:a2:
                    ee:7b:ba:52:42:83:9e:14:ed:05:52:5a:59:56:a7:
                    97:fc:9d:3f:0a:29:d8:dc:4f:91:0e:13:bc:de:95:
                    a4:df:8b:99:be:ac:9b:33:88:ef:b5:81:af:1b:c6:
                    22:53:c8:f6:c7:ee:97:14:b0:c5:7c:78:52:c8:f0:
                    ce:6e:77:60:84:a6:e9:2a:76:20:ed:58:01:17:30:
                    93:e9:1a:8b:e0:73:63:d9:6a:92:94:49:4e:b4:ad:
                    4a:85:c4:a3:22:30:fc:09:ed:68:22:73:a6:88:0c:
                    55:21:58:c5:e1:3a:9f:2a:dd:ca:e1:90:e0:d9:73:
                    ab:6c:80:b8:e8:0b:64:93:a0:9c:8c:19:ff:b3:d2:
                    0c:ec:91:26:87:8a:b3:a2:e1:70:8f:2c:0a:e5:cd:
                    6d:68:51:eb:da:3f:05:7f:8b:32:e6:13:5c:6b:fe:
                    5f:40:e2:22:c8:b4:b4:64:4f:d6:ba:7d:48:3e:a8:
                    69:0c:d7:bb:86:71:c9:73:b8:3f:3b:9d:25:4b:da:
                    ff:40:eb
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Certificate Policies: 
                Policy: 1.3.6.1.4.1.8024.0.3
                  User Notice:
                    Explicit Text: Any use of this Certificate constitutes acceptance of the QuoVadis Root CA 3 Certificate Policy / Certification Practice Statement.
                  CPS: http://www.quovadisglobal.com/cps

            X509v3 Key Usage: 
                Certificate Sign, CRL Sign
            X509v3 Subject Key Identifier: 
                F2:C0:13:E0:82:43:3E:FB:EE:2F:67:32:96:35:5C:DB:B8:CB:02:D0
            X509v3 Authority Key Identifier: 
                keyid:F2:C0:13:E0:82:43:3E:FB:EE:2F:67:32:96:35:5C:DB:B8:CB:02:D0
                DirName:/C=BM/O=QuoVadis Limited/CN=QuoVadis Root CA 3
                serial:05:C6

    Signature Algorithm: sha1WithRSAEncryption
         4f:ad:a0:2c:4c:fa:c0:f2:6f:f7:66:55:ab:23:34:ee:e7:29:
         da:c3:5b:b6:b0:83:d9:d0:d0:e2:21:fb:f3:60:a7:3b:5d:60:
         53:27:a2:9b:f6:08:22:2a:e7:bf:a0:72:e5:9c:24:6a:31:b1:
         90:7a:27:db:84:11:89:27:a6:77:5a:38:d7:bf:ac:86:fc:ee:
         5d:83:bc:06:c6:d1:77:6b:0f:6d:24:2f:4b:7a:6c:a7:07:96:
         ca:e3:84:9f:ad:88:8b:1d:ab:16:8d:5b:66:17:d9:16:f4:8b:
         80:d2:dd:f8:b2:76:c3:fc:38:13:aa:0c:de:42:69:2b:6e:f3:
         3c:eb:80:27:db:f5:a6:44:0d:9f:5a:55:59:0b:d5:0d:52:48:
         c5:ae:9f:f2:2f:80:c5:ea:32:50:35:12:97:2e:c1:e1:ff:f1:
         23:88:51:38:9f:f2:66:56:76:e7:0f:51:97:a5:52:0c:4d:49:
         51:95:36:3d:bf:a2:4b:0c:10:1d:86:99:4c:aa:f3:72:11:93:
         e4:ea:f6:9b:da:a8:5d:a7:4d:b7:9e:02:ae:73:00:c8:da:23:
         03:e8:f9:ea:19:74:62:00:94:cb:22:20:be:94:a7:59:b5:82:
         6a:be:99:79:7a:a9:f2:4a:24:52:f7:74:fd:ba:4e:e6:a8:1d:
         02:6e:b1:0d:80:44:c1:ae:d3:23:37:5f:bb:85:7c:2b:92:2e:
         e8:7e:a5:8b:dd:99:e1:bf:27:6f:2d:5d:aa:7b:87:fe:0a:dd:
         4b:fc:8e:f5:26:e4:6e:70:42:6e:33:ec:31:9e:7b:93:c1:e4:
         c9:69:1a:3d:c0:6b:4e:22:6d:ee:ab:58:4d:c6:d0:41:c1:2b:
         ea:4f:12:87:5e:eb:45:d8:6c:f5:98:02:d3:a0:d8:55:8a:06:
         99:19:a2:a0:77:d1:30:9e:ac:cc:75:ee:83:f5:b0:62:39:cf:
         6c:57:e2:4c:d2:91:0b:0e:75:28:1b:9a:bf:fd:1a:43:f1:ca:
         77:fb:3b:8f:61:b8:69:28:16:42:04:5e:70:2a:1c:21:d8:8f:
         e1:bd:23:5b:2d:74:40:92:d9:63:19:0d:73:dd:69:bc:62:47:
         bc:e0:74:2b:b2:eb:7d:be:41:1b:b5:c0:46:c5:a1:22:cb:5f:
         4e:c1:28:92:de:18:ba:d5:2a:28:bb:11:8b:17:93:98:99:60:
         94:5c:23:cf:5a:27:97:5e:0b:05:06:93:37:1e:3b:69:36:eb:
         a9:9e:61:1d:8f:32:da:8e:0c:d6:74:3e:7b:09:24:da:01:77:
         47:c4:3b:cd:34:8c:99:f5:ca:e1:25:61:33:b2:59:1b:e2:6e:
         d7:37:57:b6:0d:a9:12:da
-----BEGIN CERTIFICATE-----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-----END CERTIFICATE-----

Security Communication Root CA
================================================
SHA1 Fingerprint=36:B1:2B:49:F9:81:9E:D7:4C:9E:BC:38:0F:C6:56:8F:5D:AC:B2:F7
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 0 (0x0)
    Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=JP, O=SECOM Trust.net, OU=Security Communication RootCA1
        Validity
            Not Before: Sep 30 04:20:49 2003 GMT
            Not After : Sep 30 04:20:49 2023 GMT
        Subject: C=JP, O=SECOM Trust.net, OU=Security Communication RootCA1
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (2048 bit)
                Modulus:
                    00:b3:b3:fe:7f:d3:6d:b1:ef:16:7c:57:a5:0c:6d:
                    76:8a:2f:4b:bf:64:fb:4c:ee:8a:f0:f3:29:7c:f5:
                    ff:ee:2a:e0:e9:e9:ba:5b:64:22:9a:9a:6f:2c:3a:
                    26:69:51:05:99:26:dc:d5:1c:6a:71:c6:9a:7d:1e:
                    9d:dd:7c:6c:c6:8c:67:67:4a:3e:f8:71:b0:19:27:
                    a9:09:0c:a6:95:bf:4b:8c:0c:fa:55:98:3b:d8:e8:
                    22:a1:4b:71:38:79:ac:97:92:69:b3:89:7e:ea:21:
                    68:06:98:14:96:87:d2:61:36:bc:6d:27:56:9e:57:
                    ee:c0:c0:56:fd:32:cf:a4:d9:8e:c2:23:d7:8d:a8:
                    f3:d8:25:ac:97:e4:70:38:f4:b6:3a:b4:9d:3b:97:
                    26:43:a3:a1:bc:49:59:72:4c:23:30:87:01:58:f6:
                    4e:be:1c:68:56:66:af:cd:41:5d:c8:b3:4d:2a:55:
                    46:ab:1f:da:1e:e2:40:3d:db:cd:7d:b9:92:80:9c:
                    37:dd:0c:96:64:9d:dc:22:f7:64:8b:df:61:de:15:
                    94:52:15:a0:7d:52:c9:4b:a8:21:c9:c6:b1:ed:cb:
                    c3:95:60:d1:0f:f0:ab:70:f8:df:cb:4d:7e:ec:d6:
                    fa:ab:d9:bd:7f:54:f2:a5:e9:79:fa:d9:d6:76:24:
                    28:73
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Subject Key Identifier: 
                A0:73:49:99:68:DC:85:5B:65:E3:9B:28:2F:57:9F:BD:33:BC:07:48
            X509v3 Key Usage: 
                Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
    Signature Algorithm: sha1WithRSAEncryption
         68:40:a9:a8:bb:e4:4f:5d:79:b3:05:b5:17:b3:60:13:eb:c6:
         92:5d:e0:d1:d3:6a:fe:fb:be:9b:6d:bf:c7:05:6d:59:20:c4:
         1c:f0:b7:da:84:58:02:63:fa:48:16:ef:4f:a5:0b:f7:4a:98:
         f2:3f:9e:1b:ad:47:6b:63:ce:08:47:eb:52:3f:78:9c:af:4d:
         ae:f8:d5:4f:cf:9a:98:2a:10:41:39:52:c4:dd:d9:9b:0e:ef:
         93:01:ae:b2:2e:ca:68:42:24:42:6c:b0:b3:3a:3e:cd:e9:da:
         48:c4:15:cb:e9:f9:07:0f:92:50:49:8a:dd:31:97:5f:c9:e9:
         37:aa:3b:59:65:97:94:32:c9:b3:9f:3e:3a:62:58:c5:49:ad:
         62:0e:71:a5:32:aa:2f:c6:89:76:43:40:13:13:67:3d:a2:54:
         25:10:cb:f1:3a:f2:d9:fa:db:49:56:bb:a6:fe:a7:41:35:c3:
         e0:88:61:c9:88:c7:df:36:10:22:98:59:ea:b0:4a:fb:56:16:
         73:6e:ac:4d:f7:22:a1:4f:ad:1d:7a:2d:45:27:e5:30:c1:5e:
         f2:da:13:cb:25:42:51:95:47:03:8c:6c:21:cc:74:42:ed:53:
         ff:33:8b:8f:0f:57:01:16:2f:cf:a6:ee:c9:70:22:14:bd:fd:
         be:6c:0b:03
-----BEGIN CERTIFICATE-----
MIIDWjCCAkKgAwIBAgIBADANBgkqhkiG9w0BAQUFADBQMQswCQYDVQQGEwJKUDEY
MBYGA1UEChMPU0VDT00gVHJ1c3QubmV0MScwJQYDVQQLEx5TZWN1cml0eSBDb21t
dW5pY2F0aW9uIFJvb3RDQTEwHhcNMDMwOTMwMDQyMDQ5WhcNMjMwOTMwMDQyMDQ5
WjBQMQswCQYDVQQGEwJKUDEYMBYGA1UEChMPU0VDT00gVHJ1c3QubmV0MScwJQYD
VQQLEx5TZWN1cml0eSBDb21tdW5pY2F0aW9uIFJvb3RDQTEwggEiMA0GCSqGSIb3
DQEBAQUAA4IBDwAwggEKAoIBAQCzs/5/022x7xZ8V6UMbXaKL0u/ZPtM7orw8yl8
9f/uKuDp6bpbZCKamm8sOiZpUQWZJtzVHGpxxpp9Hp3dfGzGjGdnSj74cbAZJ6kJ
DKaVv0uMDPpVmDvY6CKhS3E4eayXkmmziX7qIWgGmBSWh9JhNrxtJ1aeV+7AwFb9
Ms+k2Y7CI9eNqPPYJayX5HA49LY6tJ07lyZDo6G8SVlyTCMwhwFY9k6+HGhWZq/N
QV3Is00qVUarH9oe4kA92819uZKAnDfdDJZkndwi92SL32HeFZRSFaB9UslLqCHJ
xrHty8OVYNEP8Ktw+N/LTX7s1vqr2b1/VPKl6Xn62dZ2JChzAgMBAAGjPzA9MB0G
A1UdDgQWBBSgc0mZaNyFW2XjmygvV5+9M7wHSDALBgNVHQ8EBAMCAQYwDwYDVR0T
AQH/BAUwAwEB/zANBgkqhkiG9w0BAQUFAAOCAQEAaECpqLvkT115swW1F7NgE+vG
kl3g0dNq/vu+m22/xwVtWSDEHPC32oRYAmP6SBbvT6UL90qY8j+eG61Ha2POCEfr
Uj94nK9NrvjVT8+amCoQQTlSxN3Zmw7vkwGusi7KaEIkQmywszo+zenaSMQVy+n5
Bw+SUEmK3TGXX8npN6o7WWWXlDLJs58+OmJYxUmtYg5xpTKqL8aJdkNAExNnPaJU
JRDL8Try2frbSVa7pv6nQTXD4IhhyYjH3zYQIphZ6rBK+1YWc26sTfcioU+tHXot
RSflMMFe8toTyyVCUZVHA4xsIcx0Qu1T/zOLjw9XARYvz6buyXAiFL39vmwLAw==
-----END CERTIFICATE-----

XRamp Global CA Root
================================================
SHA1 Fingerprint=B8:01:86:D1:EB:9C:86:A5:41:04:CF:30:54:F3:4C:52:B7:E5:58:C6
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            50:94:6c:ec:18:ea:d5:9c:4d:d5:97:ef:75:8f:a0:ad
    Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, OU=www.xrampsecurity.com, O=XRamp Security Services Inc, CN=XRamp Global Certification Authority
        Validity
            Not Before: Nov  1 17:14:04 2004 GMT
            Not After : Jan  1 05:37:19 2035 GMT
        Subject: C=US, OU=www.xrampsecurity.com, O=XRamp Security Services Inc, CN=XRamp Global Certification Authority
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (2048 bit)
                Modulus:
                    00:98:24:1e:bd:15:b4:ba:df:c7:8c:a5:27:b6:38:
                    0b:69:f3:b6:4e:a8:2c:2e:21:1d:5c:44:df:21:5d:
                    7e:23:74:fe:5e:7e:b4:4a:b7:a6:ad:1f:ae:e0:06:
                    16:e2:9b:5b:d9:67:74:6b:5d:80:8f:29:9d:86:1b:
                    d9:9c:0d:98:6d:76:10:28:58:e4:65:b0:7f:4a:98:
                    79:9f:e0:c3:31:7e:80:2b:b5:8c:c0:40:3b:11:86:
                    d0:cb:a2:86:36:60:a4:d5:30:82:6d:d9:6e:d0:0f:
                    12:04:33:97:5f:4f:61:5a:f0:e4:f9:91:ab:e7:1d:
                    3b:bc:e8:cf:f4:6b:2d:34:7c:e2:48:61:1c:8e:f3:
                    61:44:cc:6f:a0:4a:a9:94:b0:4d:da:e7:a9:34:7a:
                    72:38:a8:41:cc:3c:94:11:7d:eb:c8:a6:8c:b7:86:
                    cb:ca:33:3b:d9:3d:37:8b:fb:7a:3e:86:2c:e7:73:
                    d7:0a:57:ac:64:9b:19:eb:f4:0f:04:08:8a:ac:03:
                    17:19:64:f4:5a:25:22:8d:34:2c:b2:f6:68:1d:12:
                    6d:d3:8a:1e:14:da:c4:8f:a6:e2:23:85:d5:7a:0d:
                    bd:6a:e0:e9:ec:ec:17:bb:42:1b:67:aa:25:ed:45:
                    83:21:fc:c1:c9:7c:d5:62:3e:fa:f2:c5:2d:d3:fd:
                    d4:65
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            1.3.6.1.4.1.311.20.2: 
                ...C.A
            X509v3 Key Usage: 
                Digital Signature, Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Subject Key Identifier: 
                C6:4F:A2:3D:06:63:84:09:9C:CE:62:E4:04:AC:8D:5C:B5:E9:B6:1B
            X509v3 CRL Distribution Points: 

                Full Name:
                  URI:http://crl.xrampsecurity.com/XGCA.crl

            1.3.6.1.4.1.311.21.1: 
                ...
    Signature Algorithm: sha1WithRSAEncryption
         91:15:39:03:01:1b:67:fb:4a:1c:f9:0a:60:5b:a1:da:4d:97:
         62:f9:24:53:27:d7:82:64:4e:90:2e:c3:49:1b:2b:9a:dc:fc:
         a8:78:67:35:f1:1d:f0:11:bd:b7:48:e3:10:f6:0d:df:3f:d2:
         c9:b6:aa:55:a4:48:ba:02:db:de:59:2e:15:5b:3b:9d:16:7d:
         47:d7:37:ea:5f:4d:76:12:36:bb:1f:d7:a1:81:04:46:20:a3:
         2c:6d:a9:9e:01:7e:3f:29:ce:00:93:df:fd:c9:92:73:89:89:
         64:9e:e7:2b:e4:1c:91:2c:d2:b9:ce:7d:ce:6f:31:99:d3:e6:
         be:d2:1e:90:f0:09:14:79:5c:23:ab:4d:d2:da:21:1f:4d:99:
         79:9d:e1:cf:27:9f:10:9b:1c:88:0d:b0:8a:64:41:31:b8:0e:
         6c:90:24:a4:9b:5c:71:8f:ba:bb:7e:1c:1b:db:6a:80:0f:21:
         bc:e9:db:a6:b7:40:f4:b2:8b:a9:b1:e4:ef:9a:1a:d0:3d:69:
         99:ee:a8:28:a3:e1:3c:b3:f0:b2:11:9c:cf:7c:40:e6:dd:e7:
         43:7d:a2:d8:3a:b5:a9:8d:f2:34:99:c4:d4:10:e1:06:fd:09:
         84:10:3b:ee:c4:4c:f4:ec:27:7c:42:c2:74:7c:82:8a:09:c9:
         b4:03:25:bc
-----BEGIN CERTIFICATE-----
MIIEMDCCAxigAwIBAgIQUJRs7Bjq1ZxN1ZfvdY+grTANBgkqhkiG9w0BAQUFADCB
gjELMAkGA1UEBhMCVVMxHjAcBgNVBAsTFXd3dy54cmFtcHNlY3VyaXR5LmNvbTEk
MCIGA1UEChMbWFJhbXAgU2VjdXJpdHkgU2VydmljZXMgSW5jMS0wKwYDVQQDEyRY
UmFtcCBHbG9iYWwgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkwHhcNMDQxMTAxMTcx
NDA0WhcNMzUwMTAxMDUzNzE5WjCBgjELMAkGA1UEBhMCVVMxHjAcBgNVBAsTFXd3
dy54cmFtcHNlY3VyaXR5LmNvbTEkMCIGA1UEChMbWFJhbXAgU2VjdXJpdHkgU2Vy
dmljZXMgSW5jMS0wKwYDVQQDEyRYUmFtcCBHbG9iYWwgQ2VydGlmaWNhdGlvbiBB
dXRob3JpdHkwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCYJB69FbS6
38eMpSe2OAtp87ZOqCwuIR1cRN8hXX4jdP5efrRKt6atH67gBhbim1vZZ3RrXYCP
KZ2GG9mcDZhtdhAoWORlsH9KmHmf4MMxfoArtYzAQDsRhtDLooY2YKTVMIJt2W7Q
DxIEM5dfT2Fa8OT5kavnHTu86M/0ay00fOJIYRyO82FEzG+gSqmUsE3a56k0enI4
qEHMPJQRfevIpoy3hsvKMzvZPTeL+3o+hiznc9cKV6xkmxnr9A8ECIqsAxcZZPRa
JSKNNCyy9mgdEm3Tih4U2sSPpuIjhdV6Db1q4Ons7Be7QhtnqiXtRYMh/MHJfNVi
PvryxS3T/dRlAgMBAAGjgZ8wgZwwEwYJKwYBBAGCNxQCBAYeBABDAEEwCwYDVR0P
BAQDAgGGMA8GA1UdEwEB/wQFMAMBAf8wHQYDVR0OBBYEFMZPoj0GY4QJnM5i5ASs
jVy16bYbMDYGA1UdHwQvMC0wK6ApoCeGJWh0dHA6Ly9jcmwueHJhbXBzZWN1cml0
eS5jb20vWEdDQS5jcmwwEAYJKwYBBAGCNxUBBAMCAQEwDQYJKoZIhvcNAQEFBQAD
ggEBAJEVOQMBG2f7Shz5CmBbodpNl2L5JFMn14JkTpAuw0kbK5rc/Kh4ZzXxHfAR
vbdI4xD2Dd8/0sm2qlWkSLoC295ZLhVbO50WfUfXN+pfTXYSNrsf16GBBEYgoyxt
qZ4Bfj8pzgCT3/3JknOJiWSe5yvkHJEs0rnOfc5vMZnT5r7SHpDwCRR5XCOrTdLa
IR9NmXmd4c8nnxCbHIgNsIpkQTG4DmyQJKSbXHGPurt+HBvbaoAPIbzp26a3QPSy
i6mx5O+aGtA9aZnuqCij4Tyz8LIRnM98QObd50N9otg6tamN8jSZxNQQ4Qb9CYQQ
O+7ETPTsJ3xCwnR8gooJybQDJbw=
-----END CERTIFICATE-----

Go Daddy Class 2 CA
================================================
SHA1 Fingerprint=27:96:BA:E6:3F:18:01:E2:77:26:1B:A0:D7:77:70:02:8F:20:EE:E4
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 0 (0x0)
    Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=The Go Daddy Group, Inc., OU=Go Daddy Class 2 Certification Authority
        Validity
            Not Before: Jun 29 17:06:20 2004 GMT
            Not After : Jun 29 17:06:20 2034 GMT
        Subject: C=US, O=The Go Daddy Group, Inc., OU=Go Daddy Class 2 Certification Authority
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (2048 bit)
                Modulus:
                    00:de:9d:d7:ea:57:18:49:a1:5b:eb:d7:5f:48:86:
                    ea:be:dd:ff:e4:ef:67:1c:f4:65:68:b3:57:71:a0:
                    5e:77:bb:ed:9b:49:e9:70:80:3d:56:18:63:08:6f:
                    da:f2:cc:d0:3f:7f:02:54:22:54:10:d8:b2:81:d4:
                    c0:75:3d:4b:7f:c7:77:c3:3e:78:ab:1a:03:b5:20:
                    6b:2f:6a:2b:b1:c5:88:7e:c4:bb:1e:b0:c1:d8:45:
                    27:6f:aa:37:58:f7:87:26:d7:d8:2d:f6:a9:17:b7:
                    1f:72:36:4e:a6:17:3f:65:98:92:db:2a:6e:5d:a2:
                    fe:88:e0:0b:de:7f:e5:8d:15:e1:eb:cb:3a:d5:e2:
                    12:a2:13:2d:d8:8e:af:5f:12:3d:a0:08:05:08:b6:
                    5c:a5:65:38:04:45:99:1e:a3:60:60:74:c5:41:a5:
                    72:62:1b:62:c5:1f:6f:5f:1a:42:be:02:51:65:a8:
                    ae:23:18:6a:fc:78:03:a9:4d:7f:80:c3:fa:ab:5a:
                    fc:a1:40:a4:ca:19:16:fe:b2:c8:ef:5e:73:0d:ee:
                    77:bd:9a:f6:79:98:bc:b1:07:67:a2:15:0d:dd:a0:
                    58:c6:44:7b:0a:3e:62:28:5f:ba:41:07:53:58:cf:
                    11:7e:38:74:c5:f8:ff:b5:69:90:8f:84:74:ea:97:
                    1b:af
                Exponent: 3 (0x3)
        X509v3 extensions:
            X509v3 Subject Key Identifier: 
                D2:C4:B0:D2:91:D4:4C:11:71:B3:61:CB:3D:A1:FE:DD:A8:6A:D4:E3
            X509v3 Authority Key Identifier: 
                keyid:D2:C4:B0:D2:91:D4:4C:11:71:B3:61:CB:3D:A1:FE:DD:A8:6A:D4:E3
                DirName:/C=US/O=The Go Daddy Group, Inc./OU=Go Daddy Class 2 Certification Authority
                serial:00

            X509v3 Basic Constraints: 
                CA:TRUE
    Signature Algorithm: sha1WithRSAEncryption
         32:4b:f3:b2:ca:3e:91:fc:12:c6:a1:07:8c:8e:77:a0:33:06:
         14:5c:90:1e:18:f7:08:a6:3d:0a:19:f9:87:80:11:6e:69:e4:
         96:17:30:ff:34:91:63:72:38:ee:cc:1c:01:a3:1d:94:28:a4:
         31:f6:7a:c4:54:d7:f6:e5:31:58:03:a2:cc:ce:62:db:94:45:
         73:b5:bf:45:c9:24:b5:d5:82:02:ad:23:79:69:8d:b8:b6:4d:
         ce:cf:4c:ca:33:23:e8:1c:88:aa:9d:8b:41:6e:16:c9:20:e5:
         89:9e:cd:3b:da:70:f7:7e:99:26:20:14:54:25:ab:6e:73:85:
         e6:9b:21:9d:0a:6c:82:0e:a8:f8:c2:0c:fa:10:1e:6c:96:ef:
         87:0d:c4:0f:61:8b:ad:ee:83:2b:95:f8:8e:92:84:72:39:eb:
         20:ea:83:ed:83:cd:97:6e:08:bc:eb:4e:26:b6:73:2b:e4:d3:
         f6:4c:fe:26:71:e2:61:11:74:4a:ff:57:1a:87:0f:75:48:2e:
         cf:51:69:17:a0:02:12:61:95:d5:d1:40:b2:10:4c:ee:c4:ac:
         10:43:a6:a5:9e:0a:d5:95:62:9a:0d:cf:88:82:c5:32:0c:e4:
         2b:9f:45:e6:0d:9f:28:9c:b1:b9:2a:5a:57:ad:37:0f:af:1d:
         7f:db:bd:9f
-----BEGIN CERTIFICATE-----
MIIEADCCAuigAwIBAgIBADANBgkqhkiG9w0BAQUFADBjMQswCQYDVQQGEwJVUzEh
MB8GA1UEChMYVGhlIEdvIERhZGR5IEdyb3VwLCBJbmMuMTEwLwYDVQQLEyhHbyBE
YWRkeSBDbGFzcyAyIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA0MDYyOTE3
MDYyMFoXDTM0MDYyOTE3MDYyMFowYzELMAkGA1UEBhMCVVMxITAfBgNVBAoTGFRo
ZSBHbyBEYWRkeSBHcm91cCwgSW5jLjExMC8GA1UECxMoR28gRGFkZHkgQ2xhc3Mg
MiBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTCCASAwDQYJKoZIhvcNAQEBBQADggEN
ADCCAQgCggEBAN6d1+pXGEmhW+vXX0iG6r7d/+TvZxz0ZWizV3GgXne77ZtJ6XCA
PVYYYwhv2vLM0D9/AlQiVBDYsoHUwHU9S3/Hd8M+eKsaA7Ugay9qK7HFiH7Eux6w
wdhFJ2+qN1j3hybX2C32qRe3H3I2TqYXP2WYktsqbl2i/ojgC95/5Y0V4evLOtXi
EqITLdiOr18SPaAIBQi2XKVlOARFmR6jYGB0xUGlcmIbYsUfb18aQr4CUWWoriMY
avx4A6lNf4DD+qta/KFApMoZFv6yyO9ecw3ud72a9nmYvLEHZ6IVDd2gWMZEewo+
YihfukEHU1jPEX44dMX4/7VpkI+EdOqXG68CAQOjgcAwgb0wHQYDVR0OBBYEFNLE
sNKR1EwRcbNhyz2h/t2oatTjMIGNBgNVHSMEgYUwgYKAFNLEsNKR1EwRcbNhyz2h
/t2oatTjoWekZTBjMQswCQYDVQQGEwJVUzEhMB8GA1UEChMYVGhlIEdvIERhZGR5
IEdyb3VwLCBJbmMuMTEwLwYDVQQLEyhHbyBEYWRkeSBDbGFzcyAyIENlcnRpZmlj
YXRpb24gQXV0aG9yaXR5ggEAMAwGA1UdEwQFMAMBAf8wDQYJKoZIhvcNAQEFBQAD
ggEBADJL87LKPpH8EsahB4yOd6AzBhRckB4Y9wimPQoZ+YeAEW5p5JYXMP80kWNy
OO7MHAGjHZQopDH2esRU1/blMVgDoszOYtuURXO1v0XJJLXVggKtI3lpjbi2Tc7P
TMozI+gciKqdi0FuFskg5YmezTvacPd+mSYgFFQlq25zheabIZ0KbIIOqPjCDPoQ
HmyW74cNxA9hi63ugyuV+I6ShHI56yDqg+2DzZduCLzrTia2cyvk0/ZM/iZx4mER
dEr/VxqHD3VILs9RaRegAhJhldXRQLIQTO7ErBBDpqWeCtWVYpoNz4iCxTIM5Cuf
ReYNnyicsbkqWletNw+vHX/bvZ8=
-----END CERTIFICATE-----

Starfield Class 2 CA
================================================
SHA1 Fingerprint=AD:7E:1C:28:B0:64:EF:8F:60:03:40:20:14:C3:D0:E3:37:0E:B5:8A
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 0 (0x0)
    Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=Starfield Technologies, Inc., OU=Starfield Class 2 Certification Authority
        Validity
            Not Before: Jun 29 17:39:16 2004 GMT
            Not After : Jun 29 17:39:16 2034 GMT
        Subject: C=US, O=Starfield Technologies, Inc., OU=Starfield Class 2 Certification Authority
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (2048 bit)
                Modulus:
                    00:b7:32:c8:fe:e9:71:a6:04:85:ad:0c:11:64:df:
                    ce:4d:ef:c8:03:18:87:3f:a1:ab:fb:3c:a6:9f:f0:
                    c3:a1:da:d4:d8:6e:2b:53:90:fb:24:a4:3e:84:f0:
                    9e:e8:5f:ec:e5:27:44:f5:28:a6:3f:7b:de:e0:2a:
                    f0:c8:af:53:2f:9e:ca:05:01:93:1e:8f:66:1c:39:
                    a7:4d:fa:5a:b6:73:04:25:66:eb:77:7f:e7:59:c6:
                    4a:99:25:14:54:eb:26:c7:f3:7f:19:d5:30:70:8f:
                    af:b0:46:2a:ff:ad:eb:29:ed:d7:9f:aa:04:87:a3:
                    d4:f9:89:a5:34:5f:db:43:91:82:36:d9:66:3c:b1:
                    b8:b9:82:fd:9c:3a:3e:10:c8:3b:ef:06:65:66:7a:
                    9b:19:18:3d:ff:71:51:3c:30:2e:5f:be:3d:77:73:
                    b2:5d:06:6c:c3:23:56:9a:2b:85:26:92:1c:a7:02:
                    b3:e4:3f:0d:af:08:79:82:b8:36:3d:ea:9c:d3:35:
                    b3:bc:69:ca:f5:cc:9d:e8:fd:64:8d:17:80:33:6e:
                    5e:4a:5d:99:c9:1e:87:b4:9d:1a:c0:d5:6e:13:35:
                    23:5e:df:9b:5f:3d:ef:d6:f7:76:c2:ea:3e:bb:78:
                    0d:1c:42:67:6b:04:d8:f8:d6:da:6f:8b:f2:44:a0:
                    01:ab
                Exponent: 3 (0x3)
        X509v3 extensions:
            X509v3 Subject Key Identifier: 
                BF:5F:B7:D1:CE:DD:1F:86:F4:5B:55:AC:DC:D7:10:C2:0E:A9:88:E7
            X509v3 Authority Key Identifier: 
                keyid:BF:5F:B7:D1:CE:DD:1F:86:F4:5B:55:AC:DC:D7:10:C2:0E:A9:88:E7
                DirName:/C=US/O=Starfield Technologies, Inc./OU=Starfield Class 2 Certification Authority
                serial:00

            X509v3 Basic Constraints: 
                CA:TRUE
    Signature Algorithm: sha1WithRSAEncryption
         05:9d:3f:88:9d:d1:c9:1a:55:a1:ac:69:f3:f3:59:da:9b:01:
         87:1a:4f:57:a9:a1:79:09:2a:db:f7:2f:b2:1e:cc:c7:5e:6a:
         d8:83:87:a1:97:ef:49:35:3e:77:06:41:58:62:bf:8e:58:b8:
         0a:67:3f:ec:b3:dd:21:66:1f:c9:54:fa:72:cc:3d:4c:40:d8:
         81:af:77:9e:83:7a:bb:a2:c7:f5:34:17:8e:d9:11:40:f4:fc:
         2c:2a:4d:15:7f:a7:62:5d:2e:25:d3:00:0b:20:1a:1d:68:f9:
         17:b8:f4:bd:8b:ed:28:59:dd:4d:16:8b:17:83:c8:b2:65:c7:
         2d:7a:a5:aa:bc:53:86:6d:dd:57:a4:ca:f8:20:41:0b:68:f0:
         f4:fb:74:be:56:5d:7a:79:f5:f9:1d:85:e3:2d:95:be:f5:71:
         90:43:cc:8d:1f:9a:00:0a:87:29:e9:55:22:58:00:23:ea:e3:
         12:43:29:5b:47:08:dd:8c:41:6a:65:06:a8:e5:21:aa:41:b4:
         95:21:95:b9:7d:d1:34:ab:13:d6:ad:bc:dc:e2:3d:39:cd:bd:
         3e:75:70:a1:18:59:03:c9:22:b4:8f:9c:d5:5e:2a:d7:a5:b6:
         d4:0a:6d:f8:b7:40:11:46:9a:1f:79:0e:62:bf:0f:97:ec:e0:
         2f:1f:17:94
-----BEGIN CERTIFICATE-----
MIIEDzCCAvegAwIBAgIBADANBgkqhkiG9w0BAQUFADBoMQswCQYDVQQGEwJVUzEl
MCMGA1UEChMcU3RhcmZpZWxkIFRlY2hub2xvZ2llcywgSW5jLjEyMDAGA1UECxMp
U3RhcmZpZWxkIENsYXNzIDIgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkwHhcNMDQw
NjI5MTczOTE2WhcNMzQwNjI5MTczOTE2WjBoMQswCQYDVQQGEwJVUzElMCMGA1UE
ChMcU3RhcmZpZWxkIFRlY2hub2xvZ2llcywgSW5jLjEyMDAGA1UECxMpU3RhcmZp
ZWxkIENsYXNzIDIgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkwggEgMA0GCSqGSIb3
DQEBAQUAA4IBDQAwggEIAoIBAQC3Msj+6XGmBIWtDBFk385N78gDGIc/oav7PKaf
8MOh2tTYbitTkPskpD6E8J7oX+zlJ0T1KKY/e97gKvDIr1MvnsoFAZMej2YcOadN
+lq2cwQlZut3f+dZxkqZJRRU6ybH838Z1TBwj6+wRir/resp7defqgSHo9T5iaU0
X9tDkYI22WY8sbi5gv2cOj4QyDvvBmVmepsZGD3/cVE8MC5fvj13c7JdBmzDI1aa
K4UmkhynArPkPw2vCHmCuDY96pzTNbO8acr1zJ3o/WSNF4Azbl5KXZnJHoe0nRrA
1W4TNSNe35tfPe/W93bC6j67eA0cQmdrBNj41tpvi/JEoAGrAgEDo4HFMIHCMB0G
A1UdDgQWBBS/X7fRzt0fhvRbVazc1xDCDqmI5zCBkgYDVR0jBIGKMIGHgBS/X7fR
zt0fhvRbVazc1xDCDqmI56FspGowaDELMAkGA1UEBhMCVVMxJTAjBgNVBAoTHFN0
YXJmaWVsZCBUZWNobm9sb2dpZXMsIEluYy4xMjAwBgNVBAsTKVN0YXJmaWVsZCBD
bGFzcyAyIENlcnRpZmljYXRpb24gQXV0aG9yaXR5ggEAMAwGA1UdEwQFMAMBAf8w
DQYJKoZIhvcNAQEFBQADggEBAAWdP4id0ckaVaGsafPzWdqbAYcaT1epoXkJKtv3
L7IezMdeatiDh6GX70k1PncGQVhiv45YuApnP+yz3SFmH8lU+nLMPUxA2IGvd56D
eruix/U0F47ZEUD0/CwqTRV/p2JdLiXTAAsgGh1o+Re49L2L7ShZ3U0WixeDyLJl
xy16paq8U4Zt3VekyvggQQto8PT7dL5WXXp59fkdheMtlb71cZBDzI0fmgAKhynp
VSJYACPq4xJDKVtHCN2MQWplBqjlIapBtJUhlbl90TSrE9atvNziPTnNvT51cKEY
WQPJIrSPnNVeKtelttQKbfi3QBFGmh95DmK/D5fs4C8fF5Q=
-----END CERTIFICATE-----

DigiCert Assured ID Root CA
================================================
SHA1 Fingerprint=05:63:B8:63:0D:62:D7:5A:BB:C8:AB:1E:4B:DF:B5:A8:99:B2:4D:43
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            0c:e7:e0:e5:17:d8:46:fe:8f:e5:60:fc:1b:f0:30:39
    Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=DigiCert Inc, OU=www.digicert.com, CN=DigiCert Assured ID Root CA
        Validity
            Not Before: Nov 10 00:00:00 2006 GMT
            Not After : Nov 10 00:00:00 2031 GMT
        Subject: C=US, O=DigiCert Inc, OU=www.digicert.com, CN=DigiCert Assured ID Root CA
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (2048 bit)
                Modulus:
                    00:ad:0e:15:ce:e4:43:80:5c:b1:87:f3:b7:60:f9:
                    71:12:a5:ae:dc:26:94:88:aa:f4:ce:f5:20:39:28:
                    58:60:0c:f8:80:da:a9:15:95:32:61:3c:b5:b1:28:
                    84:8a:8a:dc:9f:0a:0c:83:17:7a:8f:90:ac:8a:e7:
                    79:53:5c:31:84:2a:f6:0f:98:32:36:76:cc:de:dd:
                    3c:a8:a2:ef:6a:fb:21:f2:52:61:df:9f:20:d7:1f:
                    e2:b1:d9:fe:18:64:d2:12:5b:5f:f9:58:18:35:bc:
                    47:cd:a1:36:f9:6b:7f:d4:b0:38:3e:c1:1b:c3:8c:
                    33:d9:d8:2f:18:fe:28:0f:b3:a7:83:d6:c3:6e:44:
                    c0:61:35:96:16:fe:59:9c:8b:76:6d:d7:f1:a2:4b:
                    0d:2b:ff:0b:72:da:9e:60:d0:8e:90:35:c6:78:55:
                    87:20:a1:cf:e5:6d:0a:c8:49:7c:31:98:33:6c:22:
                    e9:87:d0:32:5a:a2:ba:13:82:11:ed:39:17:9d:99:
                    3a:72:a1:e6:fa:a4:d9:d5:17:31:75:ae:85:7d:22:
                    ae:3f:01:46:86:f6:28:79:c8:b1:da:e4:57:17:c4:
                    7e:1c:0e:b0:b4:92:a6:56:b3:bd:b2:97:ed:aa:a7:
                    f0:b7:c5:a8:3f:95:16:d0:ff:a1:96:eb:08:5f:18:
                    77:4f
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Key Usage: critical
                Digital Signature, Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Subject Key Identifier: 
                45:EB:A2:AF:F4:92:CB:82:31:2D:51:8B:A7:A7:21:9D:F3:6D:C8:0F
            X509v3 Authority Key Identifier: 
                keyid:45:EB:A2:AF:F4:92:CB:82:31:2D:51:8B:A7:A7:21:9D:F3:6D:C8:0F

    Signature Algorithm: sha1WithRSAEncryption
         a2:0e:bc:df:e2:ed:f0:e3:72:73:7a:64:94:bf:f7:72:66:d8:
         32:e4:42:75:62:ae:87:eb:f2:d5:d9:de:56:b3:9f:cc:ce:14:
         28:b9:0d:97:60:5c:12:4c:58:e4:d3:3d:83:49:45:58:97:35:
         69:1a:a8:47:ea:56:c6:79:ab:12:d8:67:81:84:df:7f:09:3c:
         94:e6:b8:26:2c:20:bd:3d:b3:28:89:f7:5f:ff:22:e2:97:84:
         1f:e9:65:ef:87:e0:df:c1:67:49:b3:5d:eb:b2:09:2a:eb:26:
         ed:78:be:7d:3f:2b:f3:b7:26:35:6d:5f:89:01:b6:49:5b:9f:
         01:05:9b:ab:3d:25:c1:cc:b6:7f:c2:f1:6f:86:c6:fa:64:68:
         eb:81:2d:94:eb:42:b7:fa:8c:1e:dd:62:f1:be:50:67:b7:6c:
         bd:f3:f1:1f:6b:0c:36:07:16:7f:37:7c:a9:5b:6d:7a:f1:12:
         46:60:83:d7:27:04:be:4b:ce:97:be:c3:67:2a:68:11:df:80:
         e7:0c:33:66:bf:13:0d:14:6e:f3:7f:1f:63:10:1e:fa:8d:1b:
         25:6d:6c:8f:a5:b7:61:01:b1:d2:a3:26:a1:10:71:9d:ad:e2:
         c3:f9:c3:99:51:b7:2b:07:08:ce:2e:e6:50:b2:a7:fa:0a:45:
         2f:a2:f0:f2
-----BEGIN CERTIFICATE-----
MIIDtzCCAp+gAwIBAgIQDOfg5RfYRv6P5WD8G/AwOTANBgkqhkiG9w0BAQUFADBl
MQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
d3cuZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVkIElEIFJv
b3QgQ0EwHhcNMDYxMTEwMDAwMDAwWhcNMzExMTEwMDAwMDAwWjBlMQswCQYDVQQG
EwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNl
cnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVkIElEIFJvb3QgQ0EwggEi
MA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCtDhXO5EOAXLGH87dg+XESpa7c
JpSIqvTO9SA5KFhgDPiA2qkVlTJhPLWxKISKityfCgyDF3qPkKyK53lTXDGEKvYP
mDI2dsze3Tyoou9q+yHyUmHfnyDXH+Kx2f4YZNISW1/5WBg1vEfNoTb5a3/UsDg+
wRvDjDPZ2C8Y/igPs6eD1sNuRMBhNZYW/lmci3Zt1/GiSw0r/wty2p5g0I6QNcZ4
VYcgoc/lbQrISXwxmDNsIumH0DJaoroTghHtORedmTpyoeb6pNnVFzF1roV9Iq4/
AUaG9ih5yLHa5FcXxH4cDrC0kqZWs72yl+2qp/C3xag/lRbQ/6GW6whfGHdPAgMB
AAGjYzBhMA4GA1UdDwEB/wQEAwIBhjAPBgNVHRMBAf8EBTADAQH/MB0GA1UdDgQW
BBRF66Kv9JLLgjEtUYunpyGd823IDzAfBgNVHSMEGDAWgBRF66Kv9JLLgjEtUYun
pyGd823IDzANBgkqhkiG9w0BAQUFAAOCAQEAog683+Lt8ONyc3pklL/3cmbYMuRC
dWKuh+vy1dneVrOfzM4UKLkNl2BcEkxY5NM9g0lFWJc1aRqoR+pWxnmrEthngYTf
fwk8lOa4JiwgvT2zKIn3X/8i4peEH+ll74fg38FnSbNd67IJKusm7Xi+fT8r87cm
NW1fiQG2SVufAQWbqz0lwcy2f8Lxb4bG+mRo64EtlOtCt/qMHt1i8b5QZ7dsvfPx
H2sMNgcWfzd8qVttevESRmCD1ycEvkvOl77DZypoEd+A5wwzZr8TDRRu838fYxAe
+o0bJW1sj6W3YQGx0qMmoRBxna3iw/nDmVG3KwcIzi7mULKn+gpFL6Lw8g==
-----END CERTIFICATE-----

DigiCert Global Root CA
================================================
SHA1 Fingerprint=A8:98:5D:3A:65:E5:E5:C4:B2:D7:D6:6D:40:C6:DD:2F:B1:9C:54:36
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            08:3b:e0:56:90:42:46:b1:a1:75:6a:c9:59:91:c7:4a
    Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=DigiCert Inc, OU=www.digicert.com, CN=DigiCert Global Root CA
        Validity
            Not Before: Nov 10 00:00:00 2006 GMT
            Not After : Nov 10 00:00:00 2031 GMT
        Subject: C=US, O=DigiCert Inc, OU=www.digicert.com, CN=DigiCert Global Root CA
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (2048 bit)
                Modulus:
                    00:e2:3b:e1:11:72:de:a8:a4:d3:a3:57:aa:50:a2:
                    8f:0b:77:90:c9:a2:a5:ee:12:ce:96:5b:01:09:20:
                    cc:01:93:a7:4e:30:b7:53:f7:43:c4:69:00:57:9d:
                    e2:8d:22:dd:87:06:40:00:81:09:ce:ce:1b:83:bf:
                    df:cd:3b:71:46:e2:d6:66:c7:05:b3:76:27:16:8f:
                    7b:9e:1e:95:7d:ee:b7:48:a3:08:da:d6:af:7a:0c:
                    39:06:65:7f:4a:5d:1f:bc:17:f8:ab:be:ee:28:d7:
                    74:7f:7a:78:99:59:85:68:6e:5c:23:32:4b:bf:4e:
                    c0:e8:5a:6d:e3:70:bf:77:10:bf:fc:01:f6:85:d9:
                    a8:44:10:58:32:a9:75:18:d5:d1:a2:be:47:e2:27:
                    6a:f4:9a:33:f8:49:08:60:8b:d4:5f:b4:3a:84:bf:
                    a1:aa:4a:4c:7d:3e:cf:4f:5f:6c:76:5e:a0:4b:37:
                    91:9e:dc:22:e6:6d:ce:14:1a:8e:6a:cb:fe:cd:b3:
                    14:64:17:c7:5b:29:9e:32:bf:f2:ee:fa:d3:0b:42:
                    d4:ab:b7:41:32:da:0c:d4:ef:f8:81:d5:bb:8d:58:
                    3f:b5:1b:e8:49:28:a2:70:da:31:04:dd:f7:b2:16:
                    f2:4c:0a:4e:07:a8:ed:4a:3d:5e:b5:7f:a3:90:c3:
                    af:27
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Key Usage: critical
                Digital Signature, Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Subject Key Identifier: 
                03:DE:50:35:56:D1:4C:BB:66:F0:A3:E2:1B:1B:C3:97:B2:3D:D1:55
            X509v3 Authority Key Identifier: 
                keyid:03:DE:50:35:56:D1:4C:BB:66:F0:A3:E2:1B:1B:C3:97:B2:3D:D1:55

    Signature Algorithm: sha1WithRSAEncryption
         cb:9c:37:aa:48:13:12:0a:fa:dd:44:9c:4f:52:b0:f4:df:ae:
         04:f5:79:79:08:a3:24:18:fc:4b:2b:84:c0:2d:b9:d5:c7:fe:
         f4:c1:1f:58:cb:b8:6d:9c:7a:74:e7:98:29:ab:11:b5:e3:70:
         a0:a1:cd:4c:88:99:93:8c:91:70:e2:ab:0f:1c:be:93:a9:ff:
         63:d5:e4:07:60:d3:a3:bf:9d:5b:09:f1:d5:8e:e3:53:f4:8e:
         63:fa:3f:a7:db:b4:66:df:62:66:d6:d1:6e:41:8d:f2:2d:b5:
         ea:77:4a:9f:9d:58:e2:2b:59:c0:40:23:ed:2d:28:82:45:3e:
         79:54:92:26:98:e0:80:48:a8:37:ef:f0:d6:79:60:16:de:ac:
         e8:0e:cd:6e:ac:44:17:38:2f:49:da:e1:45:3e:2a:b9:36:53:
         cf:3a:50:06:f7:2e:e8:c4:57:49:6c:61:21:18:d5:04:ad:78:
         3c:2c:3a:80:6b:a7:eb:af:15:14:e9:d8:89:c1:b9:38:6c:e2:
         91:6c:8a:ff:64:b9:77:25:57:30:c0:1b:24:a3:e1:dc:e9:df:
         47:7c:b5:b4:24:08:05:30:ec:2d:bd:0b:bf:45:bf:50:b9:a9:
         f3:eb:98:01:12:ad:c8:88:c6:98:34:5f:8d:0a:3c:c6:e9:d5:
         95:95:6d:de
-----BEGIN CERTIFICATE-----
MIIDrzCCApegAwIBAgIQCDvgVpBCRrGhdWrJWZHHSjANBgkqhkiG9w0BAQUFADBh
MQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
d3cuZGlnaWNlcnQuY29tMSAwHgYDVQQDExdEaWdpQ2VydCBHbG9iYWwgUm9vdCBD
QTAeFw0wNjExMTAwMDAwMDBaFw0zMTExMTAwMDAwMDBaMGExCzAJBgNVBAYTAlVT
MRUwEwYDVQQKEwxEaWdpQ2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5j
b20xIDAeBgNVBAMTF0RpZ2lDZXJ0IEdsb2JhbCBSb290IENBMIIBIjANBgkqhkiG
9w0BAQEFAAOCAQ8AMIIBCgKCAQEA4jvhEXLeqKTTo1eqUKKPC3eQyaKl7hLOllsB
CSDMAZOnTjC3U/dDxGkAV53ijSLdhwZAAIEJzs4bg7/fzTtxRuLWZscFs3YnFo97
nh6Vfe63SKMI2tavegw5BmV/Sl0fvBf4q77uKNd0f3p4mVmFaG5cIzJLv07A6Fpt
43C/dxC//AH2hdmoRBBYMql1GNXRor5H4idq9Joz+EkIYIvUX7Q6hL+hqkpMfT7P
T19sdl6gSzeRntwi5m3OFBqOasv+zbMUZBfHWymeMr/y7vrTC0LUq7dBMtoM1O/4
gdW7jVg/tRvoSSiicNoxBN33shbyTApOB6jtSj1etX+jkMOvJwIDAQABo2MwYTAO
BgNVHQ8BAf8EBAMCAYYwDwYDVR0TAQH/BAUwAwEB/zAdBgNVHQ4EFgQUA95QNVbR
TLtm8KPiGxvDl7I90VUwHwYDVR0jBBgwFoAUA95QNVbRTLtm8KPiGxvDl7I90VUw
DQYJKoZIhvcNAQEFBQADggEBAMucN6pIExIK+t1EnE9SsPTfrgT1eXkIoyQY/Esr
hMAtudXH/vTBH1jLuG2cenTnmCmrEbXjcKChzUyImZOMkXDiqw8cvpOp/2PV5Adg
06O/nVsJ8dWO41P0jmP6P6fbtGbfYmbW0W5BjfIttep3Sp+dWOIrWcBAI+0tKIJF
PnlUkiaY4IBIqDfv8NZ5YBberOgOzW6sRBc4L0na4UU+Krk2U886UAb3LujEV0ls
YSEY1QSteDwsOoBrp+uvFRTp2InBuThs4pFsiv9kuXclVzDAGySj4dzp30d8tbQk
CAUw7C29C79Fv1C5qfPrmAESrciIxpg0X40KPMbp1ZWVbd4=
-----END CERTIFICATE-----

DigiCert High Assurance EV Root CA
================================================
SHA1 Fingerprint=5F:B7:EE:06:33:E2:59:DB:AD:0C:4C:9A:E6:D3:8F:1A:61:C7:DC:25
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            02:ac:5c:26:6a:0b:40:9b:8f:0b:79:f2:ae:46:25:77
    Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=DigiCert Inc, OU=www.digicert.com, CN=DigiCert High Assurance EV Root CA
        Validity
            Not Before: Nov 10 00:00:00 2006 GMT
            Not After : Nov 10 00:00:00 2031 GMT
        Subject: C=US, O=DigiCert Inc, OU=www.digicert.com, CN=DigiCert High Assurance EV Root CA
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (2048 bit)
                Modulus:
                    00:c6:cc:e5:73:e6:fb:d4:bb:e5:2d:2d:32:a6:df:
                    e5:81:3f:c9:cd:25:49:b6:71:2a:c3:d5:94:34:67:
                    a2:0a:1c:b0:5f:69:a6:40:b1:c4:b7:b2:8f:d0:98:
                    a4:a9:41:59:3a:d3:dc:94:d6:3c:db:74:38:a4:4a:
                    cc:4d:25:82:f7:4a:a5:53:12:38:ee:f3:49:6d:71:
                    91:7e:63:b6:ab:a6:5f:c3:a4:84:f8:4f:62:51:be:
                    f8:c5:ec:db:38:92:e3:06:e5:08:91:0c:c4:28:41:
                    55:fb:cb:5a:89:15:7e:71:e8:35:bf:4d:72:09:3d:
                    be:3a:38:50:5b:77:31:1b:8d:b3:c7:24:45:9a:a7:
                    ac:6d:00:14:5a:04:b7:ba:13:eb:51:0a:98:41:41:
                    22:4e:65:61:87:81:41:50:a6:79:5c:89:de:19:4a:
                    57:d5:2e:e6:5d:1c:53:2c:7e:98:cd:1a:06:16:a4:
                    68:73:d0:34:04:13:5c:a1:71:d3:5a:7c:55:db:5e:
                    64:e1:37:87:30:56:04:e5:11:b4:29:80:12:f1:79:
                    39:88:a2:02:11:7c:27:66:b7:88:b7:78:f2:ca:0a:
                    a8:38:ab:0a:64:c2:bf:66:5d:95:84:c1:a1:25:1e:
                    87:5d:1a:50:0b:20:12:cc:41:bb:6e:0b:51:38:b8:
                    4b:cb
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Key Usage: critical
                Digital Signature, Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Subject Key Identifier: 
                B1:3E:C3:69:03:F8:BF:47:01:D4:98:26:1A:08:02:EF:63:64:2B:C3
            X509v3 Authority Key Identifier: 
                keyid:B1:3E:C3:69:03:F8:BF:47:01:D4:98:26:1A:08:02:EF:63:64:2B:C3

    Signature Algorithm: sha1WithRSAEncryption
         1c:1a:06:97:dc:d7:9c:9f:3c:88:66:06:08:57:21:db:21:47:
         f8:2a:67:aa:bf:18:32:76:40:10:57:c1:8a:f3:7a:d9:11:65:
         8e:35:fa:9e:fc:45:b5:9e:d9:4c:31:4b:b8:91:e8:43:2c:8e:
         b3:78:ce:db:e3:53:79:71:d6:e5:21:94:01:da:55:87:9a:24:
         64:f6:8a:66:cc:de:9c:37:cd:a8:34:b1:69:9b:23:c8:9e:78:
         22:2b:70:43:e3:55:47:31:61:19:ef:58:c5:85:2f:4e:30:f6:
         a0:31:16:23:c8:e7:e2:65:16:33:cb:bf:1a:1b:a0:3d:f8:ca:
         5e:8b:31:8b:60:08:89:2d:0c:06:5c:52:b7:c4:f9:0a:98:d1:
         15:5f:9f:12:be:7c:36:63:38:bd:44:a4:7f:e4:26:2b:0a:c4:
         97:69:0d:e9:8c:e2:c0:10:57:b8:c8:76:12:91:55:f2:48:69:
         d8:bc:2a:02:5b:0f:44:d4:20:31:db:f4:ba:70:26:5d:90:60:
         9e:bc:4b:17:09:2f:b4:cb:1e:43:68:c9:07:27:c1:d2:5c:f7:
         ea:21:b9:68:12:9c:3c:9c:bf:9e:fc:80:5c:9b:63:cd:ec:47:
         aa:25:27:67:a0:37:f3:00:82:7d:54:d7:a9:f8:e9:2e:13:a3:
         77:e8:1f:4a
-----BEGIN CERTIFICATE-----
MIIDxTCCAq2gAwIBAgIQAqxcJmoLQJuPC3nyrkYldzANBgkqhkiG9w0BAQUFADBs
MQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
d3cuZGlnaWNlcnQuY29tMSswKQYDVQQDEyJEaWdpQ2VydCBIaWdoIEFzc3VyYW5j
ZSBFViBSb290IENBMB4XDTA2MTExMDAwMDAwMFoXDTMxMTExMDAwMDAwMFowbDEL
MAkGA1UEBhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3
LmRpZ2ljZXJ0LmNvbTErMCkGA1UEAxMiRGlnaUNlcnQgSGlnaCBBc3N1cmFuY2Ug
RVYgUm9vdCBDQTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAMbM5XPm
+9S75S0tMqbf5YE/yc0lSbZxKsPVlDRnogocsF9ppkCxxLeyj9CYpKlBWTrT3JTW
PNt0OKRKzE0lgvdKpVMSOO7zSW1xkX5jtqumX8OkhPhPYlG++MXs2ziS4wblCJEM
xChBVfvLWokVfnHoNb9Ncgk9vjo4UFt3MRuNs8ckRZqnrG0AFFoEt7oT61EKmEFB
Ik5lYYeBQVCmeVyJ3hlKV9Uu5l0cUyx+mM0aBhakaHPQNAQTXKFx01p8VdteZOE3
hzBWBOURtCmAEvF5OYiiAhF8J2a3iLd48soKqDirCmTCv2ZdlYTBoSUeh10aUAsg
EsxBu24LUTi4S8sCAwEAAaNjMGEwDgYDVR0PAQH/BAQDAgGGMA8GA1UdEwEB/wQF
MAMBAf8wHQYDVR0OBBYEFLE+w2kD+L9HAdSYJhoIAu9jZCvDMB8GA1UdIwQYMBaA
FLE+w2kD+L9HAdSYJhoIAu9jZCvDMA0GCSqGSIb3DQEBBQUAA4IBAQAcGgaX3Nec
nzyIZgYIVyHbIUf4KmeqvxgydkAQV8GK83rZEWWONfqe/EW1ntlMMUu4kehDLI6z
eM7b41N5cdblIZQB2lWHmiRk9opmzN6cN82oNLFpmyPInngiK3BD41VHMWEZ71jF
hS9OMPagMRYjyOfiZRYzy78aG6A9+MpeizGLYAiJLQwGXFK3xPkKmNEVX58Svnw2
Yzi9RKR/5CYrCsSXaQ3pjOLAEFe4yHYSkVXySGnYvCoCWw9E1CAx2/S6cCZdkGCe
vEsXCS+0yx5DaMkHJ8HSXPfqIbloEpw8nL+e/IBcm2PN7EeqJSdnoDfzAIJ9VNep
+OkuE6N36B9K
-----END CERTIFICATE-----

DST Root CA X3
=================================================
SHA1 Fingerprint=DA:C9:02:4F:54:D8:F6:DF:94:93:5F:B1:73:26:38:CA:6A:D7:7C:13
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            44:af:b0:80:d6:a3:27:ba:89:30:39:86:2e:f8:40:6b
    Signature Algorithm: sha1WithRSAEncryption
        Issuer: O=Digital Signature Trust Co., CN=DST Root CA X3
        Validity
            Not Before: Sep 30 21:12:19 2000 GMT
            Not After : Sep 30 14:01:15 2021 GMT
        Subject: O=Digital Signature Trust Co., CN=DST Root CA X3
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (2048 bit)
                Modulus:
                    00:df:af:e9:97:50:08:83:57:b4:cc:62:65:f6:90:
                    82:ec:c7:d3:2c:6b:30:ca:5b:ec:d9:c3:7d:c7:40:
                    c1:18:14:8b:e0:e8:33:76:49:2a:e3:3f:21:49:93:
                    ac:4e:0e:af:3e:48:cb:65:ee:fc:d3:21:0f:65:d2:
                    2a:d9:32:8f:8c:e5:f7:77:b0:12:7b:b5:95:c0:89:
                    a3:a9:ba:ed:73:2e:7a:0c:06:32:83:a2:7e:8a:14:
                    30:cd:11:a0:e1:2a:38:b9:79:0a:31:fd:50:bd:80:
                    65:df:b7:51:63:83:c8:e2:88:61:ea:4b:61:81:ec:
                    52:6b:b9:a2:e2:4b:1a:28:9f:48:a3:9e:0c:da:09:
                    8e:3e:17:2e:1e:dd:20:df:5b:c6:2a:8a:ab:2e:bd:
                    70:ad:c5:0b:1a:25:90:74:72:c5:7b:6a:ab:34:d6:
                    30:89:ff:e5:68:13:7b:54:0b:c8:d6:ae:ec:5a:9c:
                    92:1e:3d:64:b3:8c:c6:df:bf:c9:41:70:ec:16:72:
                    d5:26:ec:38:55:39:43:d0:fc:fd:18:5c:40:f1:97:
                    eb:d5:9a:9b:8d:1d:ba:da:25:b9:c6:d8:df:c1:15:
                    02:3a:ab:da:6e:f1:3e:2e:f5:5c:08:9c:3c:d6:83:
                    69:e4:10:9b:19:2a:b6:29:57:e3:e5:3d:9b:9f:f0:
                    02:5d
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Subject Key Identifier: 
                C4:A7:B1:A4:7B:2C:71:FA:DB:E1:4B:90:75:FF:C4:15:60:85:89:10
    Signature Algorithm: sha1WithRSAEncryption
         a3:1a:2c:9b:17:00:5c:a9:1e:ee:28:66:37:3a:bf:83:c7:3f:
         4b:c3:09:a0:95:20:5d:e3:d9:59:44:d2:3e:0d:3e:bd:8a:4b:
         a0:74:1f:ce:10:82:9c:74:1a:1d:7e:98:1a:dd:cb:13:4b:b3:
         20:44:e4:91:e9:cc:fc:7d:a5:db:6a:e5:fe:e6:fd:e0:4e:dd:
         b7:00:3a:b5:70:49:af:f2:e5:eb:02:f1:d1:02:8b:19:cb:94:
         3a:5e:48:c4:18:1e:58:19:5f:1e:02:5a:f0:0c:f1:b1:ad:a9:
         dc:59:86:8b:6e:e9:91:f5:86:ca:fa:b9:66:33:aa:59:5b:ce:
         e2:a7:16:73:47:cb:2b:cc:99:b0:37:48:cf:e3:56:4b:f5:cf:
         0f:0c:72:32:87:c6:f0:44:bb:53:72:6d:43:f5:26:48:9a:52:
         67:b7:58:ab:fe:67:76:71:78:db:0d:a2:56:14:13:39:24:31:
         85:a2:a8:02:5a:30:47:e1:dd:50:07:bc:02:09:90:00:eb:64:
         63:60:9b:16:bc:88:c9:12:e6:d2:7d:91:8b:f9:3d:32:8d:65:
         b4:e9:7c:b1:57:76:ea:c5:b6:28:39:bf:15:65:1c:c8:f6:77:
         96:6a:0a:8d:77:0b:d8:91:0b:04:8e:07:db:29:b6:0a:ee:9d:
         82:35:35:10
-----BEGIN CERTIFICATE-----
MIIDSjCCAjKgAwIBAgIQRK+wgNajJ7qJMDmGLvhAazANBgkqhkiG9w0BAQUFADA/
MSQwIgYDVQQKExtEaWdpdGFsIFNpZ25hdHVyZSBUcnVzdCBDby4xFzAVBgNVBAMT
DkRTVCBSb290IENBIFgzMB4XDTAwMDkzMDIxMTIxOVoXDTIxMDkzMDE0MDExNVow
PzEkMCIGA1UEChMbRGlnaXRhbCBTaWduYXR1cmUgVHJ1c3QgQ28uMRcwFQYDVQQD
Ew5EU1QgUm9vdCBDQSBYMzCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEB
AN+v6ZdQCINXtMxiZfaQguzH0yxrMMpb7NnDfcdAwRgUi+DoM3ZJKuM/IUmTrE4O
rz5Iy2Xu/NMhD2XSKtkyj4zl93ewEnu1lcCJo6m67XMuegwGMoOifooUMM0RoOEq
OLl5CjH9UL2AZd+3UWODyOKIYepLYYHsUmu5ouJLGiifSKOeDNoJjj4XLh7dIN9b
xiqKqy69cK3FCxolkHRyxXtqqzTWMIn/5WgTe1QLyNau7Fqckh49ZLOMxt+/yUFw
7BZy1SbsOFU5Q9D8/RhcQPGX69Wam40dutolucbY38EVAjqr2m7xPi71XAicPNaD
aeQQmxkqtilX4+U9m5/wAl0CAwEAAaNCMEAwDwYDVR0TAQH/BAUwAwEB/zAOBgNV
HQ8BAf8EBAMCAQYwHQYDVR0OBBYEFMSnsaR7LHH62+FLkHX/xBVghYkQMA0GCSqG
SIb3DQEBBQUAA4IBAQCjGiybFwBcqR7uKGY3Or+Dxz9LwwmglSBd49lZRNI+DT69
ikugdB/OEIKcdBodfpga3csTS7MgROSR6cz8faXbauX+5v3gTt23ADq1cEmv8uXr
AvHRAosZy5Q6XkjEGB5YGV8eAlrwDPGxrancWYaLbumR9YbK+rlmM6pZW87ipxZz
R8srzJmwN0jP41ZL9c8PDHIyh8bwRLtTcm1D9SZImlJnt1ir/md2cXjbDaJWFBM5
JDGFoqgCWjBH4d1QB7wCCZAA62RjYJsWvIjJEubSfZGL+T0yjWW06XyxV3bqxbYo
Ob8VZRzI9neWagqNdwvYkQsEjgfbKbYK7p2CNTUQ
-----END CERTIFICATE-----

SwissSign Gold CA - G2
================================================
SHA1 Fingerprint=D8:C5:38:8A:B7:30:1B:1B:6E:D4:7A:E6:45:25:3A:6F:9F:1A:27:61
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 13492815561806991280 (0xbb401c43f55e4fb0)
    Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=CH, O=SwissSign AG, CN=SwissSign Gold CA - G2
        Validity
            Not Before: Oct 25 08:30:35 2006 GMT
            Not After : Oct 25 08:30:35 2036 GMT
        Subject: C=CH, O=SwissSign AG, CN=SwissSign Gold CA - G2
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (4096 bit)
                Modulus:
                    00:af:e4:ee:7e:8b:24:0e:12:6e:a9:50:2d:16:44:
                    3b:92:92:5c:ca:b8:5d:84:92:42:13:2a:bc:65:57:
                    82:40:3e:57:24:cd:50:8b:25:2a:b7:6f:fc:ef:a2:
                    d0:c0:1f:02:24:4a:13:96:8f:23:13:e6:28:58:00:
                    a3:47:c7:06:a7:84:23:2b:bb:bd:96:2b:7f:55:cc:
                    8b:c1:57:1f:0e:62:65:0f:dd:3d:56:8a:73:da:ae:
                    7e:6d:ba:81:1c:7e:42:8c:20:35:d9:43:4d:84:fa:
                    84:db:52:2c:f3:0e:27:77:0b:6b:bf:11:2f:72:78:
                    9f:2e:d8:3e:e6:18:37:5a:2a:72:f9:da:62:90:92:
                    95:ca:1f:9c:e9:b3:3c:2b:cb:f3:01:13:bf:5a:cf:
                    c1:b5:0a:60:bd:dd:b5:99:64:53:b8:a0:96:b3:6f:
                    e2:26:77:91:8c:e0:62:10:02:9f:34:0f:a4:d5:92:
                    33:51:de:be:8d:ba:84:7a:60:3c:6a:db:9f:2b:ec:
                    de:de:01:3f:6e:4d:e5:50:86:cb:b4:af:ed:44:40:
                    c5:ca:5a:8c:da:d2:2b:7c:a8:ee:be:a6:e5:0a:aa:
                    0e:a5:df:05:52:b7:55:c7:22:5d:32:6a:97:97:63:
                    13:db:c9:db:79:36:7b:85:3a:4a:c5:52:89:f9:24:
                    e7:9d:77:a9:82:ff:55:1c:a5:71:69:2b:d1:02:24:
                    f2:b3:26:d4:6b:da:04:55:e5:c1:0a:c7:6d:30:37:
                    90:2a:e4:9e:14:33:5e:16:17:55:c5:5b:b5:cb:34:
                    89:92:f1:9d:26:8f:a1:07:d4:c6:b2:78:50:db:0c:
                    0c:0b:7c:0b:8c:41:d7:b9:e9:dd:8c:88:f7:a3:4d:
                    b2:32:cc:d8:17:da:cd:b7:ce:66:9d:d4:fd:5e:ff:
                    bd:97:3e:29:75:e7:7e:a7:62:58:af:25:34:a5:41:
                    c7:3d:bc:0d:50:ca:03:03:0f:08:5a:1f:95:73:78:
                    62:bf:af:72:14:69:0e:a5:e5:03:0e:78:8e:26:28:
                    42:f0:07:0b:62:20:10:67:39:46:fa:a9:03:cc:04:
                    38:7a:66:ef:20:83:b5:8c:4a:56:8e:91:00:fc:8e:
                    5c:82:de:88:a0:c3:e2:68:6e:7d:8d:ef:3c:dd:65:
                    f4:5d:ac:51:ef:24:80:ae:aa:56:97:6f:f9:ad:7d:
                    da:61:3f:98:77:3c:a5:91:b6:1c:8c:26:da:65:a2:
                    09:6d:c1:e2:54:e3:b9:ca:4c:4c:80:8f:77:7b:60:
                    9a:1e:df:b6:f2:48:1e:0e:ba:4e:54:6d:98:e0:e1:
                    a2:1a:a2:77:50:cf:c4:63:92:ec:47:19:9d:eb:e6:
                    6b:ce:c1
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Subject Key Identifier: 
                5B:25:7B:96:A4:65:51:7E:B8:39:F3:C0:78:66:5E:E8:3A:E7:F0:EE
            X509v3 Authority Key Identifier: 
                keyid:5B:25:7B:96:A4:65:51:7E:B8:39:F3:C0:78:66:5E:E8:3A:E7:F0:EE

            X509v3 Certificate Policies: 
                Policy: 2.16.756.1.89.1.2.1.1
                  CPS: http://repository.swisssign.com/

    Signature Algorithm: sha1WithRSAEncryption
         27:ba:e3:94:7c:f1:ae:c0:de:17:e6:e5:d8:d5:f5:54:b0:83:
         f4:bb:cd:5e:05:7b:4f:9f:75:66:af:3c:e8:56:7e:fc:72:78:
         38:03:d9:2b:62:1b:00:b9:f8:e9:60:cd:cc:ce:51:8a:c7:50:
         31:6e:e1:4a:7e:18:2f:69:59:b6:3d:64:81:2b:e3:83:84:e6:
         22:87:8e:7d:e0:ee:02:99:61:b8:1e:f4:b8:2b:88:12:16:84:
         c2:31:93:38:96:31:a6:b9:3b:53:3f:c3:24:93:56:5b:69:92:
         ec:c5:c1:bb:38:00:e3:ec:17:a9:b8:dc:c7:7c:01:83:9f:32:
         47:ba:52:22:34:1d:32:7a:09:56:a7:7c:25:36:a9:3d:4b:da:
         c0:82:6f:0a:bb:12:c8:87:4b:27:11:f9:1e:2d:c7:93:3f:9e:
         db:5f:26:6b:52:d9:2e:8a:f1:14:c6:44:8d:15:a9:b7:bf:bd:
         de:a6:1a:ee:ae:2d:fb:48:77:17:fe:bb:ec:af:18:f5:2a:51:
         f0:39:84:97:95:6c:6e:1b:c3:2b:c4:74:60:79:25:b0:0a:27:
         df:df:5e:d2:39:cf:45:7d:42:4b:df:b3:2c:1e:c5:c6:5d:ca:
         55:3a:a0:9c:69:9a:8f:da:ef:b2:b0:3c:9f:87:6c:12:2b:65:
         70:15:52:31:1a:24:cf:6f:31:23:50:1f:8c:4f:8f:23:c3:74:
         41:63:1c:55:a8:14:dd:3e:e0:51:50:cf:f1:1b:30:56:0e:92:
         b0:82:85:d8:83:cb:22:64:bc:2d:b8:25:d5:54:a2:b8:06:ea:
         ad:92:a4:24:a0:c1:86:b5:4a:13:6a:47:cf:2e:0b:56:95:54:
         cb:ce:9a:db:6a:b4:a6:b2:db:41:08:86:27:77:f7:6a:a0:42:
         6c:0b:38:ce:d7:75:50:32:92:c2:df:2b:30:22:48:d0:d5:41:
         38:25:5d:a4:e9:5d:9f:c6:94:75:d0:45:fd:30:97:43:8f:90:
         ab:0a:c7:86:73:60:4a:69:2d:de:a5:78:d7:06:da:6a:9e:4b:
         3e:77:3a:20:13:22:01:d0:bf:68:9e:63:60:6b:35:4d:0b:6d:
         ba:a1:3d:c0:93:e0:7f:23:b3:55:ad:72:25:4e:46:f9:d2:16:
         ef:b0:64:c1:01:9e:e9:ca:a0:6a:98:0e:cf:d8:60:f2:2f:49:
         b8:e4:42:e1:38:35:16:f4:c8:6e:4f:f7:81:56:e8:ba:a3:be:
         23:af:ae:fd:6f:03:e0:02:3b:30:76:fa:1b:6d:41:cf:01:b1:
         e9:b8:c9:66:f4:db:26:f3:3a:a4:74:f2:49:24:5b:c9:b0:d0:
         57:c1:fa:3e:7a:e1:97:c9
-----BEGIN CERTIFICATE-----
MIIFujCCA6KgAwIBAgIJALtAHEP1Xk+wMA0GCSqGSIb3DQEBBQUAMEUxCzAJBgNV
BAYTAkNIMRUwEwYDVQQKEwxTd2lzc1NpZ24gQUcxHzAdBgNVBAMTFlN3aXNzU2ln
biBHb2xkIENBIC0gRzIwHhcNMDYxMDI1MDgzMDM1WhcNMzYxMDI1MDgzMDM1WjBF
MQswCQYDVQQGEwJDSDEVMBMGA1UEChMMU3dpc3NTaWduIEFHMR8wHQYDVQQDExZT
d2lzc1NpZ24gR29sZCBDQSAtIEcyMIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIIC
CgKCAgEAr+TufoskDhJuqVAtFkQ7kpJcyrhdhJJCEyq8ZVeCQD5XJM1QiyUqt2/8
76LQwB8CJEoTlo8jE+YoWACjR8cGp4QjK7u9lit/VcyLwVcfDmJlD909Vopz2q5+
bbqBHH5CjCA12UNNhPqE21Is8w4ndwtrvxEvcnifLtg+5hg3Wipy+dpikJKVyh+c
6bM8K8vzARO/Ws/BtQpgvd21mWRTuKCWs2/iJneRjOBiEAKfNA+k1ZIzUd6+jbqE
emA8atufK+ze3gE/bk3lUIbLtK/tREDFylqM2tIrfKjuvqblCqoOpd8FUrdVxyJd
MmqXl2MT28nbeTZ7hTpKxVKJ+STnnXepgv9VHKVxaSvRAiTysybUa9oEVeXBCsdt
MDeQKuSeFDNeFhdVxVu1yzSJkvGdJo+hB9TGsnhQ2wwMC3wLjEHXuendjIj3o02y
MszYF9rNt85mndT9Xv+9lz4pded+p2JYryU0pUHHPbwNUMoDAw8IWh+Vc3hiv69y
FGkOpeUDDniOJihC8AcLYiAQZzlG+qkDzAQ4embvIIO1jEpWjpEA/I5cgt6IoMPi
aG59je883WX0XaxR7ySArqpWl2/5rX3aYT+YdzylkbYcjCbaZaIJbcHiVOO5ykxM
gI93e2CaHt+28kgeDrpOVG2Y4OGiGqJ3UM/EY5LsRxmd6+ZrzsECAwEAAaOBrDCB
qTAOBgNVHQ8BAf8EBAMCAQYwDwYDVR0TAQH/BAUwAwEB/zAdBgNVHQ4EFgQUWyV7
lqRlUX64OfPAeGZe6Drn8O4wHwYDVR0jBBgwFoAUWyV7lqRlUX64OfPAeGZe6Drn
8O4wRgYDVR0gBD8wPTA7BglghXQBWQECAQEwLjAsBggrBgEFBQcCARYgaHR0cDov
L3JlcG9zaXRvcnkuc3dpc3NzaWduLmNvbS8wDQYJKoZIhvcNAQEFBQADggIBACe6
45R88a7A3hfm5djV9VSwg/S7zV4Fe0+fdWavPOhWfvxyeDgD2StiGwC5+OlgzczO
UYrHUDFu4Up+GC9pWbY9ZIEr44OE5iKHjn3g7gKZYbge9LgriBIWhMIxkziWMaa5
O1M/wySTVltpkuzFwbs4AOPsF6m43Md8AYOfMke6UiI0HTJ6CVanfCU2qT1L2sCC
bwq7EsiHSycR+R4tx5M/nttfJmtS2S6K8RTGRI0Vqbe/vd6mGu6uLftIdxf+u+yv
GPUqUfA5hJeVbG4bwyvEdGB5JbAKJ9/fXtI5z0V9QkvfsywexcZdylU6oJxpmo/a
77KwPJ+HbBIrZXAVUjEaJM9vMSNQH4xPjyPDdEFjHFWoFN0+4FFQz/EbMFYOkrCC
hdiDyyJkvC24JdVUorgG6q2SpCSgwYa1ShNqR88uC1aVVMvOmttqtKay20EIhid3
92qgQmwLOM7XdVAyksLfKzAiSNDVQTglXaTpXZ/GlHXQRf0wl0OPkKsKx4ZzYEpp
Ld6leNcG2mqeSz53OiATIgHQv2ieY2BrNU0LbbqhPcCT4H8js1WtciVORvnSFu+w
ZMEBnunKoGqYDs/YYPIvSbjkQuE4NRb0yG5P94FW6LqjviOvrv1vA+ACOzB2+htt
Qc8Bsem4yWb02ybzOqR08kkkW8mw0FfB+j564ZfJ
-----END CERTIFICATE-----

SwissSign Silver CA - G2
================================================
SHA1 Fingerprint=9B:AA:E5:9F:56:EE:21:CB:43:5A:BE:25:93:DF:A7:F0:40:D1:1D:CB
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 5700383053117599563 (0x4f1bd42f54bb2f4b)
    Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=CH, O=SwissSign AG, CN=SwissSign Silver CA - G2
        Validity
            Not Before: Oct 25 08:32:46 2006 GMT
            Not After : Oct 25 08:32:46 2036 GMT
        Subject: C=CH, O=SwissSign AG, CN=SwissSign Silver CA - G2
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (4096 bit)
                Modulus:
                    00:c4:f1:87:7f:d3:78:31:f7:38:c9:f8:c3:99:43:
                    bc:c7:f7:bc:37:e7:4e:71:ba:4b:8f:a5:73:1d:5c:
                    6e:98:ae:03:57:ae:38:37:43:2f:17:3d:1f:c8:ce:
                    68:10:c1:78:ae:19:03:2b:10:fa:2c:79:83:f6:e8:
                    b9:68:b9:55:f2:04:44:a7:39:f9:fc:04:8b:1e:f1:
                    a2:4d:27:f9:61:7b:ba:b7:e5:a2:13:b6:eb:61:3e:
                    d0:6c:d1:e6:fb:fa:5e:ed:1d:b4:9e:a0:35:5b:a1:
                    92:cb:f0:49:92:fe:85:0a:05:3e:e6:d9:0b:e2:4f:
                    bb:dc:95:37:fc:91:e9:32:35:22:d1:1f:3a:4e:27:
                    85:9d:b0:15:94:32:da:61:0d:47:4d:60:42:ae:92:
                    47:e8:83:5a:50:58:e9:8a:8b:b9:5d:a1:dc:dd:99:
                    4a:1f:36:67:bb:48:e4:83:b6:37:eb:48:3a:af:0f:
                    67:8f:17:07:e8:04:ca:ef:6a:31:87:d4:c0:b6:f9:
                    94:71:7b:67:64:b8:b6:91:4a:42:7b:65:2e:30:6a:
                    0c:f5:90:ee:95:e6:f2:cd:82:ec:d9:a1:4a:ec:f6:
                    b2:4b:e5:45:85:e6:6d:78:93:04:2e:9c:82:6d:36:
                    a9:c4:31:64:1f:86:83:0b:2a:f4:35:0a:78:c9:55:
                    cf:41:b0:47:e9:30:9f:99:be:61:a8:06:84:b9:28:
                    7a:5f:38:d9:1b:a9:38:b0:83:7f:73:c1:c3:3b:48:
                    2a:82:0f:21:9b:b8:cc:a8:35:c3:84:1b:83:b3:3e:
                    be:a4:95:69:01:3a:89:00:78:04:d9:c9:f4:99:19:
                    ab:56:7e:5b:8b:86:39:15:91:a4:10:2c:09:32:80:
                    60:b3:93:c0:2a:b6:18:0b:9d:7e:8d:49:f2:10:4a:
                    7f:f9:d5:46:2f:19:92:a3:99:a7:26:ac:bb:8c:3c:
                    e6:0e:bc:47:07:dc:73:51:f1:70:64:2f:08:f9:b4:
                    47:1d:30:6c:44:ea:29:37:85:92:68:66:bc:83:38:
                    fe:7b:39:2e:d3:50:f0:1f:fb:5e:60:b6:a9:a6:fa:
                    27:41:f1:9b:18:72:f2:f5:84:74:4a:c9:67:c4:54:
                    ae:48:64:df:8c:d1:6e:b0:1d:e1:07:8f:08:1e:99:
                    9c:71:e9:4c:d8:a5:f7:47:12:1f:74:d1:51:9e:86:
                    f3:c2:a2:23:40:0b:73:db:4b:a6:e7:73:06:8c:c1:
                    a0:e9:c1:59:ac:46:fa:e6:2f:f8:cf:71:9c:46:6d:
                    b9:c4:15:8d:38:79:03:45:48:ef:c4:5d:d7:08:ee:
                    87:39:22:86:b2:0d:0f:58:43:f7:71:a9:48:2e:fd:
                    ea:d6:1f
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Subject Key Identifier: 
                17:A0:CD:C1:E4:41:B6:3A:5B:3B:CB:45:9D:BD:1C:C2:98:FA:86:58
            X509v3 Authority Key Identifier: 
                keyid:17:A0:CD:C1:E4:41:B6:3A:5B:3B:CB:45:9D:BD:1C:C2:98:FA:86:58

            X509v3 Certificate Policies: 
                Policy: 2.16.756.1.89.1.3.1.1
                  CPS: http://repository.swisssign.com/

    Signature Algorithm: sha1WithRSAEncryption
         73:c6:81:e0:27:d2:2d:0f:e0:95:30:e2:9a:41:7f:50:2c:5f:
         5f:62:61:a9:86:6a:69:18:0c:74:49:d6:5d:84:ea:41:52:18:
         6f:58:ad:50:56:20:6a:c6:bd:28:69:58:91:dc:91:11:35:a9:
         3a:1d:bc:1a:a5:60:9e:d8:1f:7f:45:91:69:d9:7e:bb:78:72:
         c1:06:0f:2a:ce:8f:85:70:61:ac:a0:cd:0b:b8:39:29:56:84:
         32:4e:86:bb:3d:c4:2a:d9:d7:1f:72:ee:fe:51:a1:22:41:b1:
         71:02:63:1a:82:b0:62:ab:5e:57:12:1f:df:cb:dd:75:a0:c0:
         5d:79:90:8c:1b:e0:50:e6:de:31:fe:98:7b:70:5f:a5:90:d8:
         ad:f8:02:b6:6f:d3:60:dd:40:4b:22:c5:3d:ad:3a:7a:9f:1a:
         1a:47:91:79:33:ba:82:dc:32:69:03:96:6e:1f:4b:f0:71:fe:
         e3:67:72:a0:b1:bf:5c:8b:e4:fa:99:22:c7:84:b9:1b:8d:23:
         97:3f:ed:25:e0:cf:65:bb:f5:61:04:ef:dd:1e:b2:5a:41:22:
         5a:a1:9f:5d:2c:e8:5b:c9:6d:a9:0c:0c:78:aa:60:c6:56:8f:
         01:5a:0c:68:bc:69:19:79:c4:1f:7e:97:05:bf:c5:e9:24:51:
         5e:d4:d5:4b:53:ed:d9:23:5a:36:03:65:a3:c1:03:ad:41:30:
         f3:46:1b:85:90:af:65:b5:d5:b1:e4:16:5b:78:75:1d:97:7a:
         6d:59:a9:2a:8f:7b:de:c3:87:89:10:99:49:73:78:c8:3d:bd:
         51:35:74:2a:d5:f1:7e:69:1b:2a:bb:3b:bd:25:b8:9a:5a:3d:
         72:61:90:66:87:ee:0c:d6:4d:d4:11:74:0b:6a:fe:0b:03:fc:
         a3:55:57:89:fe:4a:cb:ae:5b:17:05:c8:f2:8d:23:31:53:38:
         d2:2d:6a:3f:82:b9:8d:08:6a:f7:5e:41:74:6e:c3:11:7e:07:
         ac:29:60:91:3f:38:ca:57:10:0d:bd:30:2f:c7:a5:e6:41:a0:
         da:ae:05:87:9a:a0:a4:65:6c:4c:09:0c:89:ba:b8:d3:b9:c0:
         93:8a:30:fa:8d:e5:9a:6b:15:01:4e:67:aa:da:62:56:3e:84:
         08:66:d2:c4:36:7d:a7:3e:10:fc:88:e0:d4:80:e5:00:bd:aa:
         f3:4e:06:a3:7a:6a:f9:62:72:e3:09:4f:eb:9b:0e:01:23:f1:
         9f:bb:7c:dc:dc:6c:11:97:25:b2:f2:b4:63:14:d2:06:2a:67:
         8c:83:f5:ce:ea:07:d8:9a:6a:1e:ec:e4:0a:bb:2a:4c:eb:09:
         60:39:ce:ca:62:d8:2e:6e
-----BEGIN CERTIFICATE-----
MIIFvTCCA6WgAwIBAgIITxvUL1S7L0swDQYJKoZIhvcNAQEFBQAwRzELMAkGA1UE
BhMCQ0gxFTATBgNVBAoTDFN3aXNzU2lnbiBBRzEhMB8GA1UEAxMYU3dpc3NTaWdu
IFNpbHZlciBDQSAtIEcyMB4XDTA2MTAyNTA4MzI0NloXDTM2MTAyNTA4MzI0Nlow
RzELMAkGA1UEBhMCQ0gxFTATBgNVBAoTDFN3aXNzU2lnbiBBRzEhMB8GA1UEAxMY
U3dpc3NTaWduIFNpbHZlciBDQSAtIEcyMIICIjANBgkqhkiG9w0BAQEFAAOCAg8A
MIICCgKCAgEAxPGHf9N4Mfc4yfjDmUO8x/e8N+dOcbpLj6VzHVxumK4DV644N0Mv
Fz0fyM5oEMF4rhkDKxD6LHmD9ui5aLlV8gREpzn5/ASLHvGiTSf5YXu6t+WiE7br
YT7QbNHm+/pe7R20nqA1W6GSy/BJkv6FCgU+5tkL4k+73JU3/JHpMjUi0R86TieF
nbAVlDLaYQ1HTWBCrpJH6INaUFjpiou5XaHc3ZlKHzZnu0jkg7Y360g6rw9njxcH
6ATK72oxh9TAtvmUcXtnZLi2kUpCe2UuMGoM9ZDulebyzYLs2aFK7PayS+VFheZt
eJMELpyCbTapxDFkH4aDCyr0NQp4yVXPQbBH6TCfmb5hqAaEuSh6XzjZG6k4sIN/
c8HDO0gqgg8hm7jMqDXDhBuDsz6+pJVpATqJAHgE2cn0mRmrVn5bi4Y5FZGkECwJ
MoBgs5PAKrYYC51+jUnyEEp/+dVGLxmSo5mnJqy7jDzmDrxHB9xzUfFwZC8I+bRH
HTBsROopN4WSaGa8gzj+ezku01DwH/teYLappvonQfGbGHLy9YR0SslnxFSuSGTf
jNFusB3hB48IHpmccelM2KX3RxIfdNFRnobzwqIjQAtz20um53MGjMGg6cFZrEb6
5i/4z3GcRm25xBWNOHkDRUjvxF3XCO6HOSKGsg0PWEP3calILv3q1h8CAwEAAaOB
rDCBqTAOBgNVHQ8BAf8EBAMCAQYwDwYDVR0TAQH/BAUwAwEB/zAdBgNVHQ4EFgQU
F6DNweRBtjpbO8tFnb0cwpj6hlgwHwYDVR0jBBgwFoAUF6DNweRBtjpbO8tFnb0c
wpj6hlgwRgYDVR0gBD8wPTA7BglghXQBWQEDAQEwLjAsBggrBgEFBQcCARYgaHR0
cDovL3JlcG9zaXRvcnkuc3dpc3NzaWduLmNvbS8wDQYJKoZIhvcNAQEFBQADggIB
AHPGgeAn0i0P4JUw4ppBf1AsX19iYamGamkYDHRJ1l2E6kFSGG9YrVBWIGrGvShp
WJHckRE1qTodvBqlYJ7YH39FkWnZfrt4csEGDyrOj4VwYaygzQu4OSlWhDJOhrs9
xCrZ1x9y7v5RoSJBsXECYxqCsGKrXlcSH9/L3XWgwF15kIwb4FDm3jH+mHtwX6WQ
2K34ArZv02DdQEsixT2tOnqfGhpHkXkzuoLcMmkDlm4fS/Bx/uNncqCxv1yL5PqZ
IseEuRuNI5c/7SXgz2W79WEE790eslpBIlqhn10s6FvJbakMDHiqYMZWjwFaDGi8
aRl5xB9+lwW/xekkUV7U1UtT7dkjWjYDZaPBA61BMPNGG4WQr2W11bHkFlt4dR2X
em1ZqSqPe97Dh4kQmUlzeMg9vVE1dCrV8X5pGyq7O70luJpaPXJhkGaH7gzWTdQR
dAtq/gsD/KNVV4n+SsuuWxcFyPKNIzFTONItaj+CuY0IavdeQXRuwxF+B6wpYJE/
OMpXEA29MC/HpeZBoNquBYeaoKRlbEwJDIm6uNO5wJOKMPqN5ZprFQFOZ6raYlY+
hAhm0sQ2fac+EPyI4NSA5QC9qvNOBqN6avlicuMJT+ubDgEj8Z+7fNzcbBGXJbLy
tGMU0gYqZ4yD9c7qB9iaah7s5Aq7KkzrCWA5zspi2C5u
-----END CERTIFICATE-----

SecureTrust CA
=================================================
SHA1 Fingerprint=87:82:C6:C3:04:35:3B:CF:D2:96:92:D2:59:3E:7D:44:D9:34:FF:11
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            0c:f0:8e:5c:08:16:a5:ad:42:7f:f0:eb:27:18:59:d0
    Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=SecureTrust Corporation, CN=SecureTrust CA
        Validity
            Not Before: Nov  7 19:31:18 2006 GMT
            Not After : Dec 31 19:40:55 2029 GMT
        Subject: C=US, O=SecureTrust Corporation, CN=SecureTrust CA
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (2048 bit)
                Modulus:
                    00:ab:a4:81:e5:95:cd:f5:f6:14:8e:c2:4f:ca:d4:
                    e2:78:95:58:9c:41:e1:0d:99:40:24:17:39:91:33:
                    66:e9:be:e1:83:af:62:5c:89:d1:fc:24:5b:61:b3:
                    e0:11:11:41:1c:1d:6e:f0:b8:bb:f8:de:a7:81:ba:
                    a6:48:c6:9f:1d:bd:be:8e:a9:41:3e:b8:94:ed:29:
                    1a:d4:8e:d2:03:1d:03:ef:6d:0d:67:1c:57:d7:06:
                    ad:ca:c8:f5:fe:0e:af:66:25:48:04:96:0b:5d:a3:
                    ba:16:c3:08:4f:d1:46:f8:14:5c:f2:c8:5e:01:99:
                    6d:fd:88:cc:86:a8:c1:6f:31:42:6c:52:3e:68:cb:
                    f3:19:34:df:bb:87:18:56:80:26:c4:d0:dc:c0:6f:
                    df:de:a0:c2:91:16:a0:64:11:4b:44:bc:1e:f6:e7:
                    fa:63:de:66:ac:76:a4:71:a3:ec:36:94:68:7a:77:
                    a4:b1:e7:0e:2f:81:7a:e2:b5:72:86:ef:a2:6b:8b:
                    f0:0f:db:d3:59:3f:ba:72:bc:44:24:9c:e3:73:b3:
                    f7:af:57:2f:42:26:9d:a9:74:ba:00:52:f2:4b:cd:
                    53:7c:47:0b:36:85:0e:66:a9:08:97:16:34:57:c1:
                    66:f7:80:e3:ed:70:54:c7:93:e0:2e:28:15:59:87:
                    ba:bb
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            1.3.6.1.4.1.311.20.2: 
                ...C.A
            X509v3 Key Usage: 
                Digital Signature, Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Subject Key Identifier: 
                42:32:B6:16:FA:04:FD:FE:5D:4B:7A:C3:FD:F7:4C:40:1D:5A:43:AF
            X509v3 CRL Distribution Points: 

                Full Name:
                  URI:http://crl.securetrust.com/STCA.crl

            1.3.6.1.4.1.311.21.1: 
                ...
    Signature Algorithm: sha1WithRSAEncryption
         30:ed:4f:4a:e1:58:3a:52:72:5b:b5:a6:a3:65:18:a6:bb:51:
         3b:77:e9:9d:ea:d3:9f:5c:e0:45:65:7b:0d:ca:5b:e2:70:50:
         b2:94:05:14:ae:49:c7:8d:41:07:12:73:94:7e:0c:23:21:fd:
         bc:10:7f:60:10:5a:72:f5:98:0e:ac:ec:b9:7f:dd:7a:6f:5d:
         d3:1c:f4:ff:88:05:69:42:a9:05:71:c8:b7:ac:26:e8:2e:b4:
         8c:6a:ff:71:dc:b8:b1:df:99:bc:7c:21:54:2b:e4:58:a2:bb:
         57:29:ae:9e:a9:a3:19:26:0f:99:2e:08:b0:ef:fd:69:cf:99:
         1a:09:8d:e3:a7:9f:2b:c9:36:34:7b:24:b3:78:4c:95:17:a4:
         06:26:1e:b6:64:52:36:5f:60:67:d9:9c:c5:05:74:0b:e7:67:
         23:d2:08:fc:88:e9:ae:8b:7f:e1:30:f4:37:7e:fd:c6:32:da:
         2d:9e:44:30:30:6c:ee:07:de:d2:34:fc:d2:ff:40:f6:4b:f4:
         66:46:06:54:a6:f2:32:0a:63:26:30:6b:9b:d1:dc:8b:47:ba:
         e1:b9:d5:62:d0:a2:a0:f4:67:05:78:29:63:1a:6f:04:d6:f8:
         c6:4c:a3:9a:b1:37:b4:8d:e5:28:4b:1d:9e:2c:c2:b8:68:bc:
         ed:02:ee:31
-----BEGIN CERTIFICATE-----
MIIDuDCCAqCgAwIBAgIQDPCOXAgWpa1Cf/DrJxhZ0DANBgkqhkiG9w0BAQUFADBI
MQswCQYDVQQGEwJVUzEgMB4GA1UEChMXU2VjdXJlVHJ1c3QgQ29ycG9yYXRpb24x
FzAVBgNVBAMTDlNlY3VyZVRydXN0IENBMB4XDTA2MTEwNzE5MzExOFoXDTI5MTIz
MTE5NDA1NVowSDELMAkGA1UEBhMCVVMxIDAeBgNVBAoTF1NlY3VyZVRydXN0IENv
cnBvcmF0aW9uMRcwFQYDVQQDEw5TZWN1cmVUcnVzdCBDQTCCASIwDQYJKoZIhvcN
AQEBBQADggEPADCCAQoCggEBAKukgeWVzfX2FI7CT8rU4niVWJxB4Q2ZQCQXOZEz
Zum+4YOvYlyJ0fwkW2Gz4BERQRwdbvC4u/jep4G6pkjGnx29vo6pQT64lO0pGtSO
0gMdA+9tDWccV9cGrcrI9f4Or2YlSASWC12juhbDCE/RRvgUXPLIXgGZbf2IzIao
wW8xQmxSPmjL8xk037uHGFaAJsTQ3MBv396gwpEWoGQRS0S8Hvbn+mPeZqx2pHGj
7DaUaHp3pLHnDi+BeuK1cobvomuL8A/b01k/unK8RCSc43Oz969XL0Imnal0ugBS
8kvNU3xHCzaFDmapCJcWNFfBZveA4+1wVMeT4C4oFVmHursCAwEAAaOBnTCBmjAT
BgkrBgEEAYI3FAIEBh4EAEMAQTALBgNVHQ8EBAMCAYYwDwYDVR0TAQH/BAUwAwEB
/zAdBgNVHQ4EFgQUQjK2FvoE/f5dS3rD/fdMQB1aQ68wNAYDVR0fBC0wKzApoCeg
JYYjaHR0cDovL2NybC5zZWN1cmV0cnVzdC5jb20vU1RDQS5jcmwwEAYJKwYBBAGC
NxUBBAMCAQAwDQYJKoZIhvcNAQEFBQADggEBADDtT0rhWDpSclu1pqNlGKa7UTt3
6Z3q059c4EVlew3KW+JwULKUBRSuSceNQQcSc5R+DCMh/bwQf2AQWnL1mA6s7Ll/
3XpvXdMc9P+IBWlCqQVxyLesJugutIxq/3HcuLHfmbx8IVQr5Fiiu1cprp6poxkm
D5kuCLDv/WnPmRoJjeOnnyvJNjR7JLN4TJUXpAYmHrZkUjZfYGfZnMUFdAvnZyPS
CPyI6a6Lf+Ew9Dd+/cYy2i2eRDAwbO4H3tI0/NL/QPZL9GZGBlSm8jIKYyYwa5vR
3ItHuuG51WLQoqD0ZwV4KWMabwTW+MZMo5qxN7SN5ShLHZ4swrhovO0C7jE=
-----END CERTIFICATE-----

Secure Global CA
================================================
SHA1 Fingerprint=3A:44:73:5A:E5:81:90:1F:24:86:61:46:1E:3B:9C:C4:5F:F5:3A:1B
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            07:56:22:a4:e8:d4:8a:89:4d:f4:13:c8:f0:f8:ea:a5
    Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=SecureTrust Corporation, CN=Secure Global CA
        Validity
            Not Before: Nov  7 19:42:28 2006 GMT
            Not After : Dec 31 19:52:06 2029 GMT
        Subject: C=US, O=SecureTrust Corporation, CN=Secure Global CA
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (2048 bit)
                Modulus:
                    00:af:35:2e:d8:ac:6c:55:69:06:71:e5:13:68:24:
                    b3:4f:d8:cc:21:47:f8:f1:60:38:89:89:03:e9:bd:
                    ea:5e:46:53:09:dc:5c:f5:5a:e8:f7:45:2a:02:eb:
                    31:61:d7:29:33:4c:ce:c7:7c:0a:37:7e:0f:ba:32:
                    98:e1:1d:97:af:8f:c7:dc:c9:38:96:f3:db:1a:fc:
                    51:ed:68:c6:d0:6e:a4:7c:24:d1:ae:42:c8:96:50:
                    63:2e:e0:fe:75:fe:98:a7:5f:49:2e:95:e3:39:33:
                    64:8e:1e:a4:5f:90:d2:67:3c:b2:d9:fe:41:b9:55:
                    a7:09:8e:72:05:1e:8b:dd:44:85:82:42:d0:49:c0:
                    1d:60:f0:d1:17:2c:95:eb:f6:a5:c1:92:a3:c5:c2:
                    a7:08:60:0d:60:04:10:96:79:9e:16:34:e6:a9:b6:
                    fa:25:45:39:c8:1e:65:f9:93:f5:aa:f1:52:dc:99:
                    98:3d:a5:86:1a:0c:35:33:fa:4b:a5:04:06:15:1c:
                    31:80:ef:aa:18:6b:c2:7b:d7:da:ce:f9:33:20:d5:
                    f5:bd:6a:33:2d:81:04:fb:b0:5c:d4:9c:a3:e2:5c:
                    1d:e3:a9:42:75:5e:7b:d4:77:ef:39:54:ba:c9:0a:
                    18:1b:12:99:49:2f:88:4b:fd:50:62:d1:73:e7:8f:
                    7a:43
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            1.3.6.1.4.1.311.20.2: 
                ...C.A
            X509v3 Key Usage: 
                Digital Signature, Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Subject Key Identifier: 
                AF:44:04:C2:41:7E:48:83:DB:4E:39:02:EC:EC:84:7A:E6:CE:C9:A4
            X509v3 CRL Distribution Points: 

                Full Name:
                  URI:http://crl.securetrust.com/SGCA.crl

            1.3.6.1.4.1.311.21.1: 
                ...
    Signature Algorithm: sha1WithRSAEncryption
         63:1a:08:40:7d:a4:5e:53:0d:77:d8:7a:ae:1f:0d:0b:51:16:
         03:ef:18:7c:c8:e3:af:6a:58:93:14:60:91:b2:84:dc:88:4e:
         be:39:8a:3a:f3:e6:82:89:5d:01:37:b3:ab:24:a4:15:0e:92:
         35:5a:4a:44:5e:4e:57:fa:75:ce:1f:48:ce:66:f4:3c:40:26:
         92:98:6c:1b:ee:24:46:0c:17:b3:52:a5:db:a5:91:91:cf:37:
         d3:6f:e7:27:08:3a:4e:19:1f:3a:a7:58:5c:17:cf:79:3f:8b:
         e4:a7:d3:26:23:9d:26:0f:58:69:fc:47:7e:b2:d0:8d:8b:93:
         bf:29:4f:43:69:74:76:67:4b:cf:07:8c:e6:02:f7:b5:e1:b4:
         43:b5:4b:2d:14:9f:f9:dc:26:0d:bf:a6:47:74:06:d8:88:d1:
         3a:29:30:84:ce:d2:39:80:62:1b:a8:c7:57:49:bc:6a:55:51:
         67:15:4a:be:35:07:e4:d5:75:98:37:79:30:14:db:29:9d:6c:
         c5:69:cc:47:55:a2:30:f7:cc:5c:7f:c2:c3:98:1c:6b:4e:16:
         80:eb:7a:78:65:45:a2:00:1a:af:0c:0d:55:64:34:48:b8:92:
         b9:f1:b4:50:29:f2:4f:23:1f:da:6c:ac:1f:44:e1:dd:23:78:
         51:5b:c7:16
-----BEGIN CERTIFICATE-----
MIIDvDCCAqSgAwIBAgIQB1YipOjUiolN9BPI8PjqpTANBgkqhkiG9w0BAQUFADBK
MQswCQYDVQQGEwJVUzEgMB4GA1UEChMXU2VjdXJlVHJ1c3QgQ29ycG9yYXRpb24x
GTAXBgNVBAMTEFNlY3VyZSBHbG9iYWwgQ0EwHhcNMDYxMTA3MTk0MjI4WhcNMjkx
MjMxMTk1MjA2WjBKMQswCQYDVQQGEwJVUzEgMB4GA1UEChMXU2VjdXJlVHJ1c3Qg
Q29ycG9yYXRpb24xGTAXBgNVBAMTEFNlY3VyZSBHbG9iYWwgQ0EwggEiMA0GCSqG
SIb3DQEBAQUAA4IBDwAwggEKAoIBAQCvNS7YrGxVaQZx5RNoJLNP2MwhR/jxYDiJ
iQPpvepeRlMJ3Fz1Wuj3RSoC6zFh1ykzTM7HfAo3fg+6MpjhHZevj8fcyTiW89sa
/FHtaMbQbqR8JNGuQsiWUGMu4P51/pinX0kuleM5M2SOHqRfkNJnPLLZ/kG5VacJ
jnIFHovdRIWCQtBJwB1g8NEXLJXr9qXBkqPFwqcIYA1gBBCWeZ4WNOaptvolRTnI
HmX5k/Wq8VLcmZg9pYYaDDUz+kulBAYVHDGA76oYa8J719rO+TMg1fW9ajMtgQT7
sFzUnKPiXB3jqUJ1XnvUd+85VLrJChgbEplJL4hL/VBi0XPnj3pDAgMBAAGjgZ0w
gZowEwYJKwYBBAGCNxQCBAYeBABDAEEwCwYDVR0PBAQDAgGGMA8GA1UdEwEB/wQF
MAMBAf8wHQYDVR0OBBYEFK9EBMJBfkiD2045AuzshHrmzsmkMDQGA1UdHwQtMCsw
KaAnoCWGI2h0dHA6Ly9jcmwuc2VjdXJldHJ1c3QuY29tL1NHQ0EuY3JsMBAGCSsG
AQQBgjcVAQQDAgEAMA0GCSqGSIb3DQEBBQUAA4IBAQBjGghAfaReUw132HquHw0L
URYD7xh8yOOvaliTFGCRsoTciE6+OYo68+aCiV0BN7OrJKQVDpI1WkpEXk5X+nXO
H0jOZvQ8QCaSmGwb7iRGDBezUqXbpZGRzzfTb+cnCDpOGR86p1hcF895P4vkp9Mm
I50mD1hp/Ed+stCNi5O/KU9DaXR2Z0vPB4zmAve14bRDtUstFJ/53CYNv6ZHdAbY
iNE6KTCEztI5gGIbqMdXSbxqVVFnFUq+NQfk1XWYN3kwFNspnWzFacxHVaIw98xc
f8LDmBxrThaA63p4ZUWiABqvDA1VZDRIuJK58bRQKfJPIx/abKwfROHdI3hRW8cW
-----END CERTIFICATE-----

COMODO Certification Authority
================================================
SHA1 Fingerprint=66:31:BF:9E:F7:4F:9E:B6:C9:D5:A6:0C:BA:6A:BE:D1:F7:BD:EF:7B
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            4e:81:2d:8a:82:65:e0:0b:02:ee:3e:35:02:46:e5:3d
    Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=GB, ST=Greater Manchester, L=Salford, O=COMODO CA Limited, CN=COMODO Certification Authority
        Validity
            Not Before: Dec  1 00:00:00 2006 GMT
            Not After : Dec 31 23:59:59 2029 GMT
        Subject: C=GB, ST=Greater Manchester, L=Salford, O=COMODO CA Limited, CN=COMODO Certification Authority
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (2048 bit)
                Modulus:
                    00:d0:40:8b:8b:72:e3:91:1b:f7:51:c1:1b:54:04:
                    98:d3:a9:bf:c1:e6:8a:5d:3b:87:fb:bb:88:ce:0d:
                    e3:2f:3f:06:96:f0:a2:29:50:99:ae:db:3b:a1:57:
                    b0:74:51:71:cd:ed:42:91:4d:41:fe:a9:c8:d8:6a:
                    86:77:44:bb:59:66:97:50:5e:b4:d4:2c:70:44:cf:
                    da:37:95:42:69:3c:30:c4:71:b3:52:f0:21:4d:a1:
                    d8:ba:39:7c:1c:9e:a3:24:9d:f2:83:16:98:aa:16:
                    7c:43:9b:15:5b:b7:ae:34:91:fe:d4:62:26:18:46:
                    9a:3f:eb:c1:f9:f1:90:57:eb:ac:7a:0d:8b:db:72:
                    30:6a:66:d5:e0:46:a3:70:dc:68:d9:ff:04:48:89:
                    77:de:b5:e9:fb:67:6d:41:e9:bc:39:bd:32:d9:62:
                    02:f1:b1:a8:3d:6e:37:9c:e2:2f:e2:d3:a2:26:8b:
                    c6:b8:55:43:88:e1:23:3e:a5:d2:24:39:6a:47:ab:
                    00:d4:a1:b3:a9:25:fe:0d:3f:a7:1d:ba:d3:51:c1:
                    0b:a4:da:ac:38:ef:55:50:24:05:65:46:93:34:4f:
                    2d:8d:ad:c6:d4:21:19:d2:8e:ca:05:61:71:07:73:
                    47:e5:8a:19:12:bd:04:4d:ce:4e:9c:a5:48:ac:bb:
                    26:f7
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Subject Key Identifier: 
                0B:58:E5:8B:C6:4C:15:37:A4:40:A9:30:A9:21:BE:47:36:5A:56:FF
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 CRL Distribution Points: 

                Full Name:
                  URI:http://crl.comodoca.com/COMODOCertificationAuthority.crl

    Signature Algorithm: sha1WithRSAEncryption
         3e:98:9e:9b:f6:1b:e9:d7:39:b7:78:ae:1d:72:18:49:d3:87:
         e4:43:82:eb:3f:c9:aa:f5:a8:b5:ef:55:7c:21:52:65:f9:d5:
         0d:e1:6c:f4:3e:8c:93:73:91:2e:02:c4:4e:07:71:6f:c0:8f:
         38:61:08:a8:1e:81:0a:c0:2f:20:2f:41:8b:91:dc:48:45:bc:
         f1:c6:de:ba:76:6b:33:c8:00:2d:31:46:4c:ed:e7:9d:cf:88:
         94:ff:33:c0:56:e8:24:86:26:b8:d8:38:38:df:2a:6b:dd:12:
         cc:c7:3f:47:17:4c:a2:c2:06:96:09:d6:db:fe:3f:3c:46:41:
         df:58:e2:56:0f:3c:3b:c1:1c:93:35:d9:38:52:ac:ee:c8:ec:
         2e:30:4e:94:35:b4:24:1f:4b:78:69:da:f2:02:38:cc:95:52:
         93:f0:70:25:59:9c:20:67:c4:ee:f9:8b:57:61:f4:92:76:7d:
         3f:84:8d:55:b7:e8:e5:ac:d5:f1:f5:19:56:a6:5a:fb:90:1c:
         af:93:eb:e5:1c:d4:67:97:5d:04:0e:be:0b:83:a6:17:83:b9:
         30:12:a0:c5:33:15:05:b9:0d:fb:c7:05:76:e3:d8:4a:8d:fc:
         34:17:a3:c6:21:28:be:30:45:31:1e:c7:78:be:58:61:38:ac:
         3b:e2:01:65
-----BEGIN CERTIFICATE-----
MIIEHTCCAwWgAwIBAgIQToEtioJl4AsC7j41AkblPTANBgkqhkiG9w0BAQUFADCB
gTELMAkGA1UEBhMCR0IxGzAZBgNVBAgTEkdyZWF0ZXIgTWFuY2hlc3RlcjEQMA4G
A1UEBxMHU2FsZm9yZDEaMBgGA1UEChMRQ09NT0RPIENBIExpbWl0ZWQxJzAlBgNV
BAMTHkNPTU9ETyBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTAeFw0wNjEyMDEwMDAw
MDBaFw0yOTEyMzEyMzU5NTlaMIGBMQswCQYDVQQGEwJHQjEbMBkGA1UECBMSR3Jl
YXRlciBNYW5jaGVzdGVyMRAwDgYDVQQHEwdTYWxmb3JkMRowGAYDVQQKExFDT01P
RE8gQ0EgTGltaXRlZDEnMCUGA1UEAxMeQ09NT0RPIENlcnRpZmljYXRpb24gQXV0
aG9yaXR5MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA0ECLi3LjkRv3
UcEbVASY06m/weaKXTuH+7uIzg3jLz8GlvCiKVCZrts7oVewdFFxze1CkU1B/qnI
2GqGd0S7WWaXUF601CxwRM/aN5VCaTwwxHGzUvAhTaHYujl8HJ6jJJ3ygxaYqhZ8
Q5sVW7euNJH+1GImGEaaP+vB+fGQV+useg2L23IwambV4EajcNxo2f8ESIl33rXp
+2dtQem8Ob0y2WIC8bGoPW43nOIv4tOiJovGuFVDiOEjPqXSJDlqR6sA1KGzqSX+
DT+nHbrTUcELpNqsOO9VUCQFZUaTNE8tja3G1CEZ0o7KBWFxB3NH5YoZEr0ETc5O
nKVIrLsm9wIDAQABo4GOMIGLMB0GA1UdDgQWBBQLWOWLxkwVN6RAqTCpIb5HNlpW
/zAOBgNVHQ8BAf8EBAMCAQYwDwYDVR0TAQH/BAUwAwEB/zBJBgNVHR8EQjBAMD6g
PKA6hjhodHRwOi8vY3JsLmNvbW9kb2NhLmNvbS9DT01PRE9DZXJ0aWZpY2F0aW9u
QXV0aG9yaXR5LmNybDANBgkqhkiG9w0BAQUFAAOCAQEAPpiem/Yb6dc5t3iuHXIY
SdOH5EOC6z/JqvWote9VfCFSZfnVDeFs9D6Mk3ORLgLETgdxb8CPOGEIqB6BCsAv
IC9Bi5HcSEW88cbeunZrM8gALTFGTO3nnc+IlP8zwFboJIYmuNg4ON8qa90SzMc/
RxdMosIGlgnW2/4/PEZB31jiVg88O8EckzXZOFKs7sjsLjBOlDW0JB9LeGna8gI4
zJVSk/BwJVmcIGfE7vmLV2H0knZ9P4SNVbfo5azV8fUZVqZa+5Acr5Pr5RzUZ5dd
BA6+C4OmF4O5MBKgxTMVBbkN+8cFduPYSo38NBejxiEovjBFMR7HeL5YYTisO+IB
ZQ==
-----END CERTIFICATE-----

Network Solutions Certificate Authority
=================================================
SHA1 Fingerprint=74:F8:A3:C3:EF:E7:B3:90:06:4B:83:90:3C:21:64:60:20:E5:DF:CE
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            57:cb:33:6f:c2:5c:16:e6:47:16:17:e3:90:31:68:e0
    Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=Network Solutions L.L.C., CN=Network Solutions Certificate Authority
        Validity
            Not Before: Dec  1 00:00:00 2006 GMT
            Not After : Dec 31 23:59:59 2029 GMT
        Subject: C=US, O=Network Solutions L.L.C., CN=Network Solutions Certificate Authority
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (2048 bit)
                Modulus:
                    00:e4:bc:7e:92:30:6d:c6:d8:8e:2b:0b:bc:46:ce:
                    e0:27:96:de:de:f9:fa:12:d3:3c:33:73:b3:04:2f:
                    bc:71:8c:e5:9f:b6:22:60:3e:5f:5d:ce:09:ff:82:
                    0c:1b:9a:51:50:1a:26:89:dd:d5:61:5d:19:dc:12:
                    0f:2d:0a:a2:43:5d:17:d0:34:92:20:ea:73:cf:38:
                    2c:06:26:09:7a:72:f7:fa:50:32:f8:c2:93:d3:69:
                    a2:23:ce:41:b1:cc:e4:d5:1f:36:d1:8a:3a:f8:8c:
                    63:e2:14:59:69:ed:0d:d3:7f:6b:e8:b8:03:e5:4f:
                    6a:e5:98:63:69:48:05:be:2e:ff:33:b6:e9:97:59:
                    69:f8:67:19:ae:93:61:96:44:15:d3:72:b0:3f:bc:
                    6a:7d:ec:48:7f:8d:c3:ab:aa:71:2b:53:69:41:53:
                    34:b5:b0:b9:c5:06:0a:c4:b0:45:f5:41:5d:6e:89:
                    45:7b:3d:3b:26:8c:74:c2:e5:d2:d1:7d:b2:11:d4:
                    fb:58:32:22:9a:80:c9:dc:fd:0c:e9:7f:5e:03:97:
                    ce:3b:00:14:87:27:70:38:a9:8e:6e:b3:27:76:98:
                    51:e0:05:e3:21:ab:1a:d5:85:22:3c:29:b5:9a:16:
                    c5:80:a8:f4:bb:6b:30:8f:2f:46:02:a2:b1:0c:22:
                    e0:d3
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Subject Key Identifier: 
                21:30:C9:FB:00:D7:4E:98:DA:87:AA:2A:D0:A7:2E:B1:40:31:A7:4C
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 CRL Distribution Points: 

                Full Name:
                  URI:http://crl.netsolssl.com/NetworkSolutionsCertificateAuthority.crl

    Signature Algorithm: sha1WithRSAEncryption
         bb:ae:4b:e7:b7:57:eb:7f:aa:2d:b7:73:47:85:6a:c1:e4:a5:
         1d:e4:e7:3c:e9:f4:59:65:77:b5:7a:5b:5a:8d:25:36:e0:7a:
         97:2e:38:c0:57:60:83:98:06:83:9f:b9:76:7a:6e:50:e0:ba:
         88:2c:fc:45:cc:18:b0:99:95:51:0e:ec:1d:b8:88:ff:87:50:
         1c:82:c2:e3:e0:32:80:bf:a0:0b:47:c8:c3:31:ef:99:67:32:
         80:4f:17:21:79:0c:69:5c:de:5e:34:ae:02:b5:26:ea:50:df:
         7f:18:65:2c:c9:f2:63:e1:a9:07:fe:7c:71:1f:6b:33:24:6a:
         1e:05:f7:05:68:c0:6a:12:cb:2e:5e:61:cb:ae:28:d3:7e:c2:
         b4:66:91:26:5f:3c:2e:24:5f:cb:58:0f:eb:28:ec:af:11:96:
         f3:dc:7b:6f:c0:a7:88:f2:53:77:b3:60:5e:ae:ae:28:da:35:
         2c:6f:34:45:d3:26:e1:de:ec:5b:4f:27:6b:16:7c:bd:44:04:
         18:82:b3:89:79:17:10:71:3d:7a:a2:16:4e:f5:01:cd:a4:6c:
         65:68:a1:49:76:5c:43:c9:d8:bc:36:67:6c:a5:94:b5:d4:cc:
         b9:bd:6a:35:56:21:de:d8:c3:eb:fb:cb:a4:60:4c:b0:55:a0:
         a0:7b:57:b2
-----BEGIN CERTIFICATE-----
MIID5jCCAs6gAwIBAgIQV8szb8JcFuZHFhfjkDFo4DANBgkqhkiG9w0BAQUFADBi
MQswCQYDVQQGEwJVUzEhMB8GA1UEChMYTmV0d29yayBTb2x1dGlvbnMgTC5MLkMu
MTAwLgYDVQQDEydOZXR3b3JrIFNvbHV0aW9ucyBDZXJ0aWZpY2F0ZSBBdXRob3Jp
dHkwHhcNMDYxMjAxMDAwMDAwWhcNMjkxMjMxMjM1OTU5WjBiMQswCQYDVQQGEwJV
UzEhMB8GA1UEChMYTmV0d29yayBTb2x1dGlvbnMgTC5MLkMuMTAwLgYDVQQDEydO
ZXR3b3JrIFNvbHV0aW9ucyBDZXJ0aWZpY2F0ZSBBdXRob3JpdHkwggEiMA0GCSqG
SIb3DQEBAQUAA4IBDwAwggEKAoIBAQDkvH6SMG3G2I4rC7xGzuAnlt7e+foS0zwz
c7MEL7xxjOWftiJgPl9dzgn/ggwbmlFQGiaJ3dVhXRncEg8tCqJDXRfQNJIg6nPP
OCwGJgl6cvf6UDL4wpPTaaIjzkGxzOTVHzbRijr4jGPiFFlp7Q3Tf2vouAPlT2rl
mGNpSAW+Lv8ztumXWWn4Zxmuk2GWRBXTcrA/vGp97Eh/jcOrqnErU2lBUzS1sLnF
BgrEsEX1QV1uiUV7PTsmjHTC5dLRfbIR1PtYMiKagMnc/Qzpf14Dl847ABSHJ3A4
qY5usyd2mFHgBeMhqxrVhSI8KbWaFsWAqPS7azCPL0YCorEMIuDTAgMBAAGjgZcw
gZQwHQYDVR0OBBYEFCEwyfsA106Y2oeqKtCnLrFAMadMMA4GA1UdDwEB/wQEAwIB
BjAPBgNVHRMBAf8EBTADAQH/MFIGA1UdHwRLMEkwR6BFoEOGQWh0dHA6Ly9jcmwu
bmV0c29sc3NsLmNvbS9OZXR3b3JrU29sdXRpb25zQ2VydGlmaWNhdGVBdXRob3Jp
dHkuY3JsMA0GCSqGSIb3DQEBBQUAA4IBAQC7rkvnt1frf6ott3NHhWrB5KUd5Oc8
6fRZZXe1eltajSU24HqXLjjAV2CDmAaDn7l2em5Q4LqILPxFzBiwmZVRDuwduIj/
h1AcgsLj4DKAv6ALR8jDMe+ZZzKATxcheQxpXN5eNK4CtSbqUN9/GGUsyfJj4akH
/nxxH2szJGoeBfcFaMBqEssuXmHLrijTfsK0ZpEmXzwuJF/LWA/rKOyvEZbz3Htv
wKeI8lN3s2Berq4o2jUsbzRF0ybh3uxbTydrFny9RAQYgrOJeRcQcT16ohZO9QHN
pGxlaKFJdlxDydi8NmdspZS11My5vWo1ViHe2MPr+8ukYEywVaCge1ey
-----END CERTIFICATE-----

COMODO ECC Certification Authority
================================================
SHA1 Fingerprint=9F:74:4E:9F:2B:4D:BA:EC:0F:31:2C:50:B6:56:3B:8E:2D:93:C3:11
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            1f:47:af:aa:62:00:70:50:54:4c:01:9e:9b:63:99:2a
    Signature Algorithm: ecdsa-with-SHA384
        Issuer: C=GB, ST=Greater Manchester, L=Salford, O=COMODO CA Limited, CN=COMODO ECC Certification Authority
        Validity
            Not Before: Mar  6 00:00:00 2008 GMT
            Not After : Jan 18 23:59:59 2038 GMT
        Subject: C=GB, ST=Greater Manchester, L=Salford, O=COMODO CA Limited, CN=COMODO ECC Certification Authority
        Subject Public Key Info:
            Public Key Algorithm: id-ecPublicKey
                Public-Key: (384 bit)
                pub: 
                    04:03:47:7b:2f:75:c9:82:15:85:fb:75:e4:91:16:
                    d4:ab:62:99:f5:3e:52:0b:06:ce:41:00:7f:97:e1:
                    0a:24:3c:1d:01:04:ee:3d:d2:8d:09:97:0c:e0:75:
                    e4:fa:fb:77:8a:2a:f5:03:60:4b:36:8b:16:23:16:
                    ad:09:71:f4:4a:f4:28:50:b4:fe:88:1c:6e:3f:6c:
                    2f:2f:09:59:5b:a5:5b:0b:33:99:e2:c3:3d:89:f9:
                    6a:2c:ef:b2:d3:06:e9
                ASN1 OID: secp384r1
        X509v3 extensions:
            X509v3 Subject Key Identifier: 
                75:71:A7:19:48:19:BC:9D:9D:EA:41:47:DF:94:C4:48:77:99:D3:79
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
    Signature Algorithm: ecdsa-with-SHA384
         30:65:02:31:00:ef:03:5b:7a:ac:b7:78:0a:72:b7:88:df:ff:
         b5:46:14:09:0a:fa:a0:e6:7d:08:c6:1a:87:bd:18:a8:73:bd:
         26:ca:60:0c:9d:ce:99:9f:cf:5c:0f:30:e1:be:14:31:ea:02:
         30:14:f4:93:3c:49:a7:33:7a:90:46:47:b3:63:7d:13:9b:4e:
         b7:6f:18:37:80:53:fe:dd:20:e0:35:9a:36:d1:c7:01:b9:e6:
         dc:dd:f3:ff:1d:2c:3a:16:57:d9:92:39:d6
-----BEGIN CERTIFICATE-----
MIICiTCCAg+gAwIBAgIQH0evqmIAcFBUTAGem2OZKjAKBggqhkjOPQQDAzCBhTEL
MAkGA1UEBhMCR0IxGzAZBgNVBAgTEkdyZWF0ZXIgTWFuY2hlc3RlcjEQMA4GA1UE
BxMHU2FsZm9yZDEaMBgGA1UEChMRQ09NT0RPIENBIExpbWl0ZWQxKzApBgNVBAMT
IkNPTU9ETyBFQ0MgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkwHhcNMDgwMzA2MDAw
MDAwWhcNMzgwMTE4MjM1OTU5WjCBhTELMAkGA1UEBhMCR0IxGzAZBgNVBAgTEkdy
ZWF0ZXIgTWFuY2hlc3RlcjEQMA4GA1UEBxMHU2FsZm9yZDEaMBgGA1UEChMRQ09N
T0RPIENBIExpbWl0ZWQxKzApBgNVBAMTIkNPTU9ETyBFQ0MgQ2VydGlmaWNhdGlv
biBBdXRob3JpdHkwdjAQBgcqhkjOPQIBBgUrgQQAIgNiAAQDR3svdcmCFYX7deSR
FtSrYpn1PlILBs5BAH+X4QokPB0BBO490o0JlwzgdeT6+3eKKvUDYEs2ixYjFq0J
cfRK9ChQtP6IHG4/bC8vCVlbpVsLM5niwz2J+Wos77LTBumjQjBAMB0GA1UdDgQW
BBR1cacZSBm8nZ3qQUfflMRId5nTeTAOBgNVHQ8BAf8EBAMCAQYwDwYDVR0TAQH/
BAUwAwEB/zAKBggqhkjOPQQDAwNoADBlAjEA7wNbeqy3eApyt4jf/7VGFAkK+qDm
fQjGGoe9GKhzvSbKYAydzpmfz1wPMOG+FDHqAjAU9JM8SaczepBGR7NjfRObTrdv
GDeAU/7dIOA1mjbRxwG55tzd8/8dLDoWV9mSOdY=
-----END CERTIFICATE-----

Certigna
================================================
SHA1 Fingerprint=B1:2E:13:63:45:86:A4:6F:1A:B2:60:68:37:58:2D:C4:AC:FD:94:97
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 18364802974209362175 (0xfedce3010fc948ff)
    Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=FR, O=Dhimyotis, CN=Certigna
        Validity
            Not Before: Jun 29 15:13:05 2007 GMT
            Not After : Jun 29 15:13:05 2027 GMT
        Subject: C=FR, O=Dhimyotis, CN=Certigna
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (2048 bit)
                Modulus:
                    00:c8:68:f1:c9:d6:d6:b3:34:75:26:82:1e:ec:b4:
                    be:ea:5c:e1:26:ed:11:47:61:e1:a2:7c:16:78:40:
                    21:e4:60:9e:5a:c8:63:e1:c4:b1:96:92:ff:18:6d:
                    69:23:e1:2b:62:f7:dd:e2:36:2f:91:07:b9:48:cf:
                    0e:ec:79:b6:2c:e7:34:4b:70:08:25:a3:3c:87:1b:
                    19:f2:81:07:0f:38:90:19:d3:11:fe:86:b4:f2:d1:
                    5e:1e:1e:96:cd:80:6c:ce:3b:31:93:b6:f2:a0:d0:
                    a9:95:12:7d:a5:9a:cc:6b:c8:84:56:8a:33:a9:e7:
                    22:15:53:16:f0:cc:17:ec:57:5f:e9:a2:0a:98:09:
                    de:e3:5f:9c:6f:dc:48:e3:85:0b:15:5a:a6:ba:9f:
                    ac:48:e3:09:b2:f7:f4:32:de:5e:34:be:1c:78:5d:
                    42:5b:ce:0e:22:8f:4d:90:d7:7d:32:18:b3:0b:2c:
                    6a:bf:8e:3f:14:11:89:20:0e:77:14:b5:3d:94:08:
                    87:f7:25:1e:d5:b2:60:00:ec:6f:2a:28:25:6e:2a:
                    3e:18:63:17:25:3f:3e:44:20:16:f6:26:c8:25:ae:
                    05:4a:b4:e7:63:2c:f3:8c:16:53:7e:5c:fb:11:1a:
                    08:c1:46:62:9f:22:b8:f1:c2:8d:69:dc:fa:3a:58:
                    06:df
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Subject Key Identifier: 
                1A:ED:FE:41:39:90:B4:24:59:BE:01:F2:52:D5:45:F6:5A:39:DC:11
            X509v3 Authority Key Identifier: 
                keyid:1A:ED:FE:41:39:90:B4:24:59:BE:01:F2:52:D5:45:F6:5A:39:DC:11
                DirName:/C=FR/O=Dhimyotis/CN=Certigna
                serial:FE:DC:E3:01:0F:C9:48:FF

            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            Netscape Cert Type: 
                SSL CA, S/MIME CA, Object Signing CA
    Signature Algorithm: sha1WithRSAEncryption
         85:03:1e:92:71:f6:42:af:e1:a3:61:9e:eb:f3:c0:0f:f2:a5:
         d4:da:95:e6:d6:be:68:36:3d:7e:6e:1f:4c:8a:ef:d1:0f:21:
         6d:5e:a5:52:63:ce:12:f8:ef:2a:da:6f:eb:37:fe:13:02:c7:
         cb:3b:3e:22:6b:da:61:2e:7f:d4:72:3d:dd:30:e1:1e:4c:40:
         19:8c:0f:d7:9c:d1:83:30:7b:98:59:dc:7d:c6:b9:0c:29:4c:
         a1:33:a2:eb:67:3a:65:84:d3:96:e2:ed:76:45:70:8f:b5:2b:
         de:f9:23:d6:49:6e:3c:14:b5:c6:9f:35:1e:50:d0:c1:8f:6a:
         70:44:02:62:cb:ae:1d:68:41:a7:aa:57:e8:53:aa:07:d2:06:
         f6:d5:14:06:0b:91:03:75:2c:6c:72:b5:61:95:9a:0d:8b:b9:
         0d:e7:f5:df:54:cd:de:e6:d8:d6:09:08:97:63:e5:c1:2e:b0:
         b7:44:26:c0:26:c0:af:55:30:9e:3b:d5:36:2a:19:04:f4:5c:
         1e:ff:cf:2c:b7:ff:d0:fd:87:40:11:d5:11:23:bb:48:c0:21:
         a9:a4:28:2d:fd:15:f8:b0:4e:2b:f4:30:5b:21:fc:11:91:34:
         be:41:ef:7b:9d:97:75:ff:97:95:c0:96:58:2f:ea:bb:46:d7:
         bb:e4:d9:2e
-----BEGIN CERTIFICATE-----
MIIDqDCCApCgAwIBAgIJAP7c4wEPyUj/MA0GCSqGSIb3DQEBBQUAMDQxCzAJBgNV
BAYTAkZSMRIwEAYDVQQKDAlEaGlteW90aXMxETAPBgNVBAMMCENlcnRpZ25hMB4X
DTA3MDYyOTE1MTMwNVoXDTI3MDYyOTE1MTMwNVowNDELMAkGA1UEBhMCRlIxEjAQ
BgNVBAoMCURoaW15b3RpczERMA8GA1UEAwwIQ2VydGlnbmEwggEiMA0GCSqGSIb3
DQEBAQUAA4IBDwAwggEKAoIBAQDIaPHJ1tazNHUmgh7stL7qXOEm7RFHYeGifBZ4
QCHkYJ5ayGPhxLGWkv8YbWkj4Sti993iNi+RB7lIzw7sebYs5zRLcAglozyHGxny
gQcPOJAZ0xH+hrTy0V4eHpbNgGzOOzGTtvKg0KmVEn2lmsxryIRWijOp5yIVUxbw
zBfsV1/pogqYCd7jX5xv3EjjhQsVWqa6n6xI4wmy9/Qy3l40vhx4XUJbzg4ij02Q
130yGLMLLGq/jj8UEYkgDncUtT2UCIf3JR7VsmAA7G8qKCVuKj4YYxclPz5EIBb2
JsglrgVKtOdjLPOMFlN+XPsRGgjBRmKfIrjxwo1p3Po6WAbfAgMBAAGjgbwwgbkw
DwYDVR0TAQH/BAUwAwEB/zAdBgNVHQ4EFgQUGu3+QTmQtCRZvgHyUtVF9lo53BEw
ZAYDVR0jBF0wW4AUGu3+QTmQtCRZvgHyUtVF9lo53BGhOKQ2MDQxCzAJBgNVBAYT
AkZSMRIwEAYDVQQKDAlEaGlteW90aXMxETAPBgNVBAMMCENlcnRpZ25hggkA/tzj
AQ/JSP8wDgYDVR0PAQH/BAQDAgEGMBEGCWCGSAGG+EIBAQQEAwIABzANBgkqhkiG
9w0BAQUFAAOCAQEAhQMeknH2Qq/ho2Ge6/PAD/Kl1NqV5ta+aDY9fm4fTIrv0Q8h
bV6lUmPOEvjvKtpv6zf+EwLHyzs+ImvaYS5/1HI93TDhHkxAGYwP15zRgzB7mFnc
fca5DClMoTOi62c6ZYTTluLtdkVwj7Ur3vkj1kluPBS1xp81HlDQwY9qcEQCYsuu
HWhBp6pX6FOqB9IG9tUUBguRA3UsbHK1YZWaDYu5Def131TN3ubY1gkIl2PlwS6w
t0QmwCbAr1UwnjvVNioZBPRcHv/PLLf/0P2HQBHVESO7SMAhqaQoLf0V+LBOK/Qw
WyH8EZE0vkHve52Xdf+XlcCWWC/qu0bXu+TZLg==
-----END CERTIFICATE-----

Cybertrust Global Root
=================================================
SHA1 Fingerprint=5F:43:E5:B1:BF:F8:78:8C:AC:1C:C7:CA:4A:9A:C6:22:2B:CC:34:C6
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            04:00:00:00:00:01:0f:85:aa:2d:48
    Signature Algorithm: sha1WithRSAEncryption
        Issuer: O=Cybertrust, Inc, CN=Cybertrust Global Root
        Validity
            Not Before: Dec 15 08:00:00 2006 GMT
            Not After : Dec 15 08:00:00 2021 GMT
        Subject: O=Cybertrust, Inc, CN=Cybertrust Global Root
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (2048 bit)
                Modulus:
                    00:f8:c8:bc:bd:14:50:66:13:ff:f0:d3:79:ec:23:
                    f2:b7:1a:c7:8e:85:f1:12:73:a6:19:aa:10:db:9c:
                    a2:65:74:5a:77:3e:51:7d:56:f6:dc:23:b6:d4:ed:
                    5f:58:b1:37:4d:d5:49:0e:6e:f5:6a:87:d6:d2:8c:
                    d2:27:c6:e2:ff:36:9f:98:65:a0:13:4e:c6:2a:64:
                    9b:d5:90:12:cf:14:06:f4:3b:e3:d4:28:be:e8:0e:
                    f8:ab:4e:48:94:6d:8e:95:31:10:5c:ed:a2:2d:bd:
                    d5:3a:6d:b2:1c:bb:60:c0:46:4b:01:f5:49:ae:7e:
                    46:8a:d0:74:8d:a1:0c:02:ce:ee:fc:e7:8f:b8:6b:
                    66:f3:7f:44:00:bf:66:25:14:2b:dd:10:30:1d:07:
                    96:3f:4d:f6:6b:b8:8f:b7:7b:0c:a5:38:eb:de:47:
                    db:d5:5d:39:fc:88:a7:f3:d7:2a:74:f1:e8:5a:a2:
                    3b:9f:50:ba:a6:8c:45:35:c2:50:65:95:dc:63:82:
                    ef:dd:bf:77:4d:9c:62:c9:63:73:16:d0:29:0f:49:
                    a9:48:f0:b3:aa:b7:6c:c5:a7:30:39:40:5d:ae:c4:
                    e2:5d:26:53:f0:ce:1c:23:08:61:a8:94:19:ba:04:
                    62:40:ec:1f:38:70:77:12:06:71:a7:30:18:5d:25:
                    27:a5
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Subject Key Identifier: 
                B6:08:7B:0D:7A:CC:AC:20:4C:86:56:32:5E:CF:AB:6E:85:2D:70:57
            X509v3 CRL Distribution Points: 

                Full Name:
                  URI:http://www2.public-trust.com/crl/ct/ctroot.crl

            X509v3 Authority Key Identifier: 
                keyid:B6:08:7B:0D:7A:CC:AC:20:4C:86:56:32:5E:CF:AB:6E:85:2D:70:57

    Signature Algorithm: sha1WithRSAEncryption
         56:ef:0a:23:a0:54:4e:95:97:c9:f8:89:da:45:c1:d4:a3:00:
         25:f4:1f:13:ab:b7:a3:85:58:69:c2:30:ad:d8:15:8a:2d:e3:
         c9:cd:81:5a:f8:73:23:5a:a7:7c:05:f3:fd:22:3b:0e:d1:06:
         c4:db:36:4c:73:04:8e:e5:b0:22:e4:c5:f3:2e:a5:d9:23:e3:
         b8:4e:4a:20:a7:6e:02:24:9f:22:60:67:7b:8b:1d:72:09:c5:
         31:5c:e9:79:9f:80:47:3d:ad:a1:0b:07:14:3d:47:ff:03:69:
         1a:0c:0b:44:e7:63:25:a7:7f:b2:c9:b8:76:84:ed:23:f6:7d:
         07:ab:45:7e:d3:df:b3:bf:e9:8a:b6:cd:a8:a2:67:2b:52:d5:
         b7:65:f0:39:4c:63:a0:91:79:93:52:0f:54:dd:83:bb:9f:d1:
         8f:a7:53:73:c3:cb:ff:30:ec:7c:04:b8:d8:44:1f:93:5f:71:
         09:22:b7:6e:3e:ea:1c:03:4e:9d:1a:20:61:fb:81:37:ec:5e:
         fc:0a:45:ab:d7:e7:17:55:d0:a0:ea:60:9b:a6:f6:e3:8c:5b:
         29:c2:06:60:14:9d:2d:97:4c:a9:93:15:9d:61:c4:01:5f:48:
         d6:58:bd:56:31:12:4e:11:c8:21:e0:b3:11:91:65:db:b4:a6:
         88:38:ce:55
-----BEGIN CERTIFICATE-----
MIIDoTCCAomgAwIBAgILBAAAAAABD4WqLUgwDQYJKoZIhvcNAQEFBQAwOzEYMBYG
A1UEChMPQ3liZXJ0cnVzdCwgSW5jMR8wHQYDVQQDExZDeWJlcnRydXN0IEdsb2Jh
bCBSb290MB4XDTA2MTIxNTA4MDAwMFoXDTIxMTIxNTA4MDAwMFowOzEYMBYGA1UE
ChMPQ3liZXJ0cnVzdCwgSW5jMR8wHQYDVQQDExZDeWJlcnRydXN0IEdsb2JhbCBS
b290MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA+Mi8vRRQZhP/8NN5
7CPytxrHjoXxEnOmGaoQ25yiZXRadz5RfVb23CO21O1fWLE3TdVJDm71aofW0ozS
J8bi/zafmGWgE07GKmSb1ZASzxQG9Dvj1Ci+6A74q05IlG2OlTEQXO2iLb3VOm2y
HLtgwEZLAfVJrn5GitB0jaEMAs7u/OePuGtm839EAL9mJRQr3RAwHQeWP032a7iP
t3sMpTjr3kfb1V05/Iin89cqdPHoWqI7n1C6poxFNcJQZZXcY4Lv3b93TZxiyWNz
FtApD0mpSPCzqrdsxacwOUBdrsTiXSZT8M4cIwhhqJQZugRiQOwfOHB3EgZxpzAY
XSUnpQIDAQABo4GlMIGiMA4GA1UdDwEB/wQEAwIBBjAPBgNVHRMBAf8EBTADAQH/
MB0GA1UdDgQWBBS2CHsNesysIEyGVjJez6tuhS1wVzA/BgNVHR8EODA2MDSgMqAw
hi5odHRwOi8vd3d3Mi5wdWJsaWMtdHJ1c3QuY29tL2NybC9jdC9jdHJvb3QuY3Js
MB8GA1UdIwQYMBaAFLYIew16zKwgTIZWMl7Pq26FLXBXMA0GCSqGSIb3DQEBBQUA
A4IBAQBW7wojoFROlZfJ+InaRcHUowAl9B8Tq7ejhVhpwjCt2BWKLePJzYFa+HMj
Wqd8BfP9IjsO0QbE2zZMcwSO5bAi5MXzLqXZI+O4Tkogp24CJJ8iYGd7ix1yCcUx
XOl5n4BHPa2hCwcUPUf/A2kaDAtE52Mlp3+yybh2hO0j9n0Hq0V+09+zv+mKts2o
omcrUtW3ZfA5TGOgkXmTUg9U3YO7n9GPp1Nzw8v/MOx8BLjYRB+TX3EJIrduPuoc
A06dGiBh+4E37F78CkWr1+cXVdCg6mCbpvbjjFspwgZgFJ0tl0ypkxWdYcQBX0jW
WL1WMRJOEcgh4LMRkWXbtKaIOM5V
-----END CERTIFICATE-----

ePKI Root Certification Authority
================================================
SHA1 Fingerprint=67:65:0D:F1:7E:8E:7E:5B:82:40:A4:F4:56:4B:CF:E2:3D:69:C6:F0
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            15:c8:bd:65:47:5c:af:b8:97:00:5e:e4:06:d2:bc:9d
    Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=TW, O=Chunghwa Telecom Co., Ltd., OU=ePKI Root Certification Authority
        Validity
            Not Before: Dec 20 02:31:27 2004 GMT
            Not After : Dec 20 02:31:27 2034 GMT
        Subject: C=TW, O=Chunghwa Telecom Co., Ltd., OU=ePKI Root Certification Authority
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (4096 bit)
                Modulus:
                    00:e1:25:0f:ee:8d:db:88:33:75:67:cd:ad:1f:7d:
                    3a:4e:6d:9d:d3:2f:14:f3:63:74:cb:01:21:6a:37:
                    ea:84:50:07:4b:26:5b:09:43:6c:21:9e:6a:c8:d5:
                    03:f5:60:69:8f:cc:f0:22:e4:1f:e7:f7:6a:22:31:
                    b7:2c:15:f2:e0:fe:00:6a:43:ff:87:65:c6:b5:1a:
                    c1:a7:4c:6d:22:70:21:8a:31:f2:97:74:89:09:12:
                    26:1c:9e:ca:d9:12:a2:95:3c:da:e9:67:bf:08:a0:
                    64:e3:d6:42:b7:45:ef:97:f4:f6:f5:d7:b5:4a:15:
                    02:58:7d:98:58:4b:60:bc:cd:d7:0d:9a:13:33:53:
                    d1:61:f9:7a:d5:d7:78:b3:9a:33:f7:00:86:ce:1d:
                    4d:94:38:af:a8:ec:78:51:70:8a:5c:10:83:51:21:
                    f7:11:3d:34:86:5e:e5:48:cd:97:81:82:35:4c:19:
                    ec:65:f6:6b:c5:05:a1:ee:47:13:d6:b3:21:27:94:
                    10:0a:d9:24:3b:ba:be:44:13:46:30:3f:97:3c:d8:
                    d7:d7:6a:ee:3b:38:e3:2b:d4:97:0e:b9:1b:e7:07:
                    49:7f:37:2a:f9:77:78:cf:54:ed:5b:46:9d:a3:80:
                    0e:91:43:c1:d6:5b:5f:14:ba:9f:a6:8d:24:47:40:
                    59:bf:72:38:b2:36:6c:37:ff:99:d1:5d:0e:59:0a:
                    ab:69:f7:c0:b2:04:45:7a:54:00:ae:be:53:f6:b5:
                    e7:e1:f8:3c:a3:31:d2:a9:fe:21:52:64:c5:a6:67:
                    f0:75:07:06:94:14:81:55:c6:27:e4:01:8f:17:c1:
                    6a:71:d7:be:4b:fb:94:58:7d:7e:11:33:b1:42:f7:
                    62:6c:18:d6:cf:09:68:3e:7f:6c:f6:1e:8f:62:ad:
                    a5:63:db:09:a7:1f:22:42:41:1e:6f:99:8a:3e:d7:
                    f9:3f:40:7a:79:b0:a5:01:92:d2:9d:3d:08:15:a5:
                    10:01:2d:b3:32:76:a8:95:0d:b3:7a:9a:fb:07:10:
                    78:11:6f:e1:8f:c7:ba:0f:25:1a:74:2a:e5:1c:98:
                    41:99:df:21:87:e8:95:06:6a:0a:b3:6a:47:76:65:
                    f6:3a:cf:8f:62:17:19:7b:0a:28:cd:1a:d2:83:1e:
                    21:c7:2c:bf:be:ff:61:68:b7:67:1b:bb:78:4d:8d:
                    ce:67:e5:e4:c1:8e:b7:23:66:e2:9d:90:75:34:98:
                    a9:36:2b:8a:9a:94:b9:9d:ec:cc:8a:b1:f8:25:89:
                    5c:5a:b6:2f:8c:1f:6d:79:24:a7:52:68:c3:84:35:
                    e2:66:8d:63:0e:25:4d:d5:19:b2:e6:79:37:a7:22:
                    9d:54:31
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Subject Key Identifier: 
                1E:0C:F7:B6:67:F2:E1:92:26:09:45:C0:55:39:2E:77:3F:42:4A:A2
            X509v3 Basic Constraints: 
                CA:TRUE
            setCext-hashedRoot: 
                0/0-...0...+......0...g*.....E...
V|.[x....S.....
    Signature Algorithm: sha1WithRSAEncryption
         09:b3:83:53:59:01:3e:95:49:b9:f1:81:ba:f9:76:20:23:b5:
         27:60:74:d4:6a:99:34:5e:6c:00:53:d9:9f:f2:a6:b1:24:07:
         44:6a:2a:c6:a5:8e:78:12:e8:47:d9:58:1b:13:2a:5e:79:9b:
         9f:0a:2a:67:a6:25:3f:06:69:56:73:c3:8a:66:48:fb:29:81:
         57:74:06:ca:9c:ea:28:e8:38:67:26:2b:f1:d5:b5:3f:65:93:
         f8:36:5d:8e:8d:8d:40:20:87:19:ea:ef:27:c0:3d:b4:39:0f:
         25:7b:68:50:74:55:9c:0c:59:7d:5a:3d:41:94:25:52:08:e0:
         47:2c:15:31:19:d5:bf:07:55:c6:bb:12:b5:97:f4:5f:83:85:
         ba:71:c1:d9:6c:81:11:76:0a:0a:b0:bf:82:97:f7:ea:3d:fa:
         fa:ec:2d:a9:28:94:3b:56:dd:d2:51:2e:ae:c0:bd:08:15:8c:
         77:52:34:96:d6:9b:ac:d3:1d:8e:61:0f:35:7b:9b:ae:39:69:
         0b:62:60:40:20:36:8f:af:fb:36:ee:2d:08:4a:1d:b8:bf:9b:
         5c:f8:ea:a5:1b:a0:73:a6:d8:f8:6e:e0:33:04:5f:68:aa:27:
         87:ed:d9:c1:90:9c:ed:bd:e3:6a:35:af:63:df:ab:18:d9:ba:
         e6:e9:4a:ea:50:8a:0f:61:93:1e:e2:2d:19:e2:30:94:35:92:
         5d:0e:b6:07:af:19:80:8f:47:90:51:4b:2e:4d:dd:85:e2:d2:
         0a:52:0a:17:9a:fc:1a:b0:50:02:e5:01:a3:63:37:21:4c:44:
         c4:9b:51:99:11:0e:73:9c:06:8f:54:2e:a7:28:5e:44:39:87:
         56:2d:37:bd:85:44:94:e1:0c:4b:2c:9c:c3:92:85:34:61:cb:
         0f:b8:9b:4a:43:52:fe:34:3a:7d:b8:e9:29:dc:76:a9:c8:30:
         f8:14:71:80:c6:1e:36:48:74:22:41:5c:87:82:e8:18:71:8b:
         41:89:44:e7:7e:58:5b:a8:b8:8d:13:e9:a7:6c:c3:47:ed:b3:
         1a:9d:62:ae:8d:82:ea:94:9e:dd:59:10:c3:ad:dd:e2:4d:e3:
         31:d5:c7:ec:e8:f2:b0:fe:92:1e:16:0a:1a:fc:d9:f3:f8:27:
         b6:c9:be:1d:b4:6c:64:90:7f:f4:e4:c4:5b:d7:37:ae:42:0e:
         dd:a4:1a:6f:7c:88:54:c5:16:6e:e1:7a:68:2e:f8:3a:bf:0d:
         a4:3c:89:3b:78:a7:4e:63:83:04:21:08:67:8d:f2:82:49:d0:
         5b:fd:b1:cd:0f:83:84:d4:3e:20:85:f7:4a:3d:2b:9c:fd:2a:
         0a:09:4d:ea:81:f8:11:9c
-----BEGIN CERTIFICATE-----
MIIFsDCCA5igAwIBAgIQFci9ZUdcr7iXAF7kBtK8nTANBgkqhkiG9w0BAQUFADBe
MQswCQYDVQQGEwJUVzEjMCEGA1UECgwaQ2h1bmdod2EgVGVsZWNvbSBDby4sIEx0
ZC4xKjAoBgNVBAsMIWVQS0kgUm9vdCBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTAe
Fw0wNDEyMjAwMjMxMjdaFw0zNDEyMjAwMjMxMjdaMF4xCzAJBgNVBAYTAlRXMSMw
IQYDVQQKDBpDaHVuZ2h3YSBUZWxlY29tIENvLiwgTHRkLjEqMCgGA1UECwwhZVBL
SSBSb290IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MIICIjANBgkqhkiG9w0BAQEF
AAOCAg8AMIICCgKCAgEA4SUP7o3biDN1Z82tH306Tm2d0y8U82N0ywEhajfqhFAH
SyZbCUNsIZ5qyNUD9WBpj8zwIuQf5/dqIjG3LBXy4P4AakP/h2XGtRrBp0xtInAh
ijHyl3SJCRImHJ7K2RKilTza6We/CKBk49ZCt0Xvl/T29de1ShUCWH2YWEtgvM3X
DZoTM1PRYfl61dd4s5oz9wCGzh1NlDivqOx4UXCKXBCDUSH3ET00hl7lSM2XgYI1
TBnsZfZrxQWh7kcT1rMhJ5QQCtkkO7q+RBNGMD+XPNjX12ruOzjjK9SXDrkb5wdJ
fzcq+Xd4z1TtW0ado4AOkUPB1ltfFLqfpo0kR0BZv3I4sjZsN/+Z0V0OWQqraffA
sgRFelQArr5T9rXn4fg8ozHSqf4hUmTFpmfwdQcGlBSBVcYn5AGPF8Fqcde+S/uU
WH1+ETOxQvdibBjWzwloPn9s9h6PYq2lY9sJpx8iQkEeb5mKPtf5P0B6ebClAZLS
nT0IFaUQAS2zMnaolQ2zepr7BxB4EW/hj8e6DyUadCrlHJhBmd8hh+iVBmoKs2pH
dmX2Os+PYhcZewoozRrSgx4hxyy/vv9haLdnG7t4TY3OZ+XkwY63I2binZB1NJip
NiuKmpS5nezMirH4JYlcWrYvjB9teSSnUmjDhDXiZo1jDiVN1Rmy5nk3pyKdVDEC
AwEAAaNqMGgwHQYDVR0OBBYEFB4M97Zn8uGSJglFwFU5Lnc/QkqiMAwGA1UdEwQF
MAMBAf8wOQYEZyoHAAQxMC8wLQIBADAJBgUrDgMCGgUAMAcGBWcqAwAABBRFsMLH
ClZ87lt4DJX5GFPBphzYEDANBgkqhkiG9w0BAQUFAAOCAgEACbODU1kBPpVJufGB
uvl2ICO1J2B01GqZNF5sAFPZn/KmsSQHRGoqxqWOeBLoR9lYGxMqXnmbnwoqZ6Yl
PwZpVnPDimZI+ymBV3QGypzqKOg4ZyYr8dW1P2WT+DZdjo2NQCCHGervJ8A9tDkP
JXtoUHRVnAxZfVo9QZQlUgjgRywVMRnVvwdVxrsStZf0X4OFunHB2WyBEXYKCrC/
gpf36j36+uwtqSiUO1bd0lEursC9CBWMd1I0ltabrNMdjmEPNXubrjlpC2JgQCA2
j6/7Nu4tCEoduL+bXPjqpRugc6bY+G7gMwRfaKonh+3ZwZCc7b3jajWvY9+rGNm6
5ulK6lCKD2GTHuItGeIwlDWSXQ62B68ZgI9HkFFLLk3dheLSClIKF5r8GrBQAuUB
o2M3IUxExJtRmREOc5wGj1QupyheRDmHVi03vYVElOEMSyycw5KFNGHLD7ibSkNS
/jQ6fbjpKdx2qcgw+BRxgMYeNkh0IkFch4LoGHGLQYlE535YW6i4jRPpp2zDR+2z
Gp1iro2C6pSe3VkQw63d4k3jMdXH7OjysP6SHhYKGvzZ8/gntsm+HbRsZJB/9OTE
W9c3rkIO3aQab3yIVMUWbuF6aC74Or8NpDyJO3inTmODBCEIZ43ygknQW/2xzQ+D
hNQ+IIX3Sj0rnP0qCglN6oH4EZw=
-----END CERTIFICATE-----

certSIGN ROOT CA
================================================
SHA1 Fingerprint=FA:B7:EE:36:97:26:62:FB:2D:B0:2A:F6:BF:03:FD:E8:7C:4B:2F:9B
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 35210227249154 (0x200605167002)
    Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=RO, O=certSIGN, OU=certSIGN ROOT CA
        Validity
            Not Before: Jul  4 17:20:04 2006 GMT
            Not After : Jul  4 17:20:04 2031 GMT
        Subject: C=RO, O=certSIGN, OU=certSIGN ROOT CA
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (2048 bit)
                Modulus:
                    00:b7:33:b9:7e:c8:25:4a:8e:b5:db:b4:28:1b:aa:
                    57:90:e8:d1:22:d3:64:ba:d3:93:e8:d4:ac:86:61:
                    40:6a:60:57:68:54:84:4d:bc:6a:54:02:05:ff:df:
                    9b:9a:2a:ae:5d:07:8f:4a:c3:28:7f:ef:fb:2b:fa:
                    79:f1:c7:ad:f0:10:53:24:90:8b:66:c9:a8:88:ab:
                    af:5a:a3:00:e9:be:ba:46:ee:5b:73:7b:2c:17:82:
                    81:5e:62:2c:a1:02:65:b3:bd:c5:2b:00:7e:c4:fc:
                    03:33:57:0d:ed:e2:fa:ce:5d:45:d6:38:cd:35:b6:
                    b2:c1:d0:9c:81:4a:aa:e4:b2:01:5c:1d:8f:5f:99:
                    c4:b1:ad:db:88:21:eb:90:08:82:80:f3:30:a3:43:
                    e6:90:82:ae:55:28:49:ed:5b:d7:a9:10:38:0e:fe:
                    8f:4c:5b:9b:46:ea:41:f5:b0:08:74:c3:d0:88:33:
                    b6:7c:d7:74:df:dc:84:d1:43:0e:75:39:a1:25:40:
                    28:ea:78:cb:0e:2c:2e:39:9d:8c:8b:6e:16:1c:2f:
                    26:82:10:e2:e3:65:94:0a:04:c0:5e:f7:5d:5b:f8:
                    10:e2:d0:ba:7a:4b:fb:de:37:00:00:1a:5b:28:e3:
                    d2:9c:73:3e:32:87:98:a1:c9:51:2f:d7:de:ac:33:
                    b3:4f
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Key Usage: critical
                Digital Signature, Non Repudiation, Certificate Sign, CRL Sign
            X509v3 Subject Key Identifier: 
                E0:8C:9B:DB:25:49:B3:F1:7C:86:D6:B2:42:87:0B:D0:6B:A0:D9:E4
    Signature Algorithm: sha1WithRSAEncryption
         3e:d2:1c:89:2e:35:fc:f8:75:dd:e6:7f:65:88:f4:72:4c:c9:
         2c:d7:32:4e:f3:dd:19:79:47:bd:8e:3b:5b:93:0f:50:49:24:
         13:6b:14:06:72:ef:09:d3:a1:a1:e3:40:84:c9:e7:18:32:74:
         3c:48:6e:0f:9f:4b:d4:f7:1e:d3:93:86:64:54:97:63:72:50:
         d5:55:cf:fa:20:93:02:a2:9b:c3:23:93:4e:16:55:76:a0:70:
         79:6d:cd:21:1f:cf:2f:2d:bc:19:e3:88:31:f8:59:1a:81:09:
         c8:97:a6:74:c7:60:c4:5b:cc:57:8e:b2:75:fd:1b:02:09:db:
         59:6f:72:93:69:f7:31:41:d6:88:38:bf:87:b2:bd:16:79:f9:
         aa:e4:be:88:25:dd:61:27:23:1c:b5:31:07:04:36:b4:1a:90:
         bd:a0:74:71:50:89:6d:bc:14:e3:0f:86:ae:f1:ab:3e:c7:a0:
         09:cc:a3:48:d1:e0:db:64:e7:92:b5:cf:af:72:43:70:8b:f9:
         c3:84:3c:13:aa:7e:92:9b:57:53:93:fa:70:c2:91:0e:31:f9:
         9b:67:5d:e9:96:38:5e:5f:b3:73:4e:88:15:67:de:9e:76:10:
         62:20:be:55:69:95:43:00:39:4d:f6:ee:b0:5a:4e:49:44:54:
         58:5f:42:83
-----BEGIN CERTIFICATE-----
MIIDODCCAiCgAwIBAgIGIAYFFnACMA0GCSqGSIb3DQEBBQUAMDsxCzAJBgNVBAYT
AlJPMREwDwYDVQQKEwhjZXJ0U0lHTjEZMBcGA1UECxMQY2VydFNJR04gUk9PVCBD
QTAeFw0wNjA3MDQxNzIwMDRaFw0zMTA3MDQxNzIwMDRaMDsxCzAJBgNVBAYTAlJP
MREwDwYDVQQKEwhjZXJ0U0lHTjEZMBcGA1UECxMQY2VydFNJR04gUk9PVCBDQTCC
ASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBALczuX7IJUqOtdu0KBuqV5Do
0SLTZLrTk+jUrIZhQGpgV2hUhE28alQCBf/fm5oqrl0Hj0rDKH/v+yv6efHHrfAQ
UySQi2bJqIirr1qjAOm+ukbuW3N7LBeCgV5iLKECZbO9xSsAfsT8AzNXDe3i+s5d
RdY4zTW2ssHQnIFKquSyAVwdj1+ZxLGt24gh65AIgoDzMKND5pCCrlUoSe1b16kQ
OA7+j0xbm0bqQfWwCHTD0IgztnzXdN/chNFDDnU5oSVAKOp4yw4sLjmdjItuFhwv
JoIQ4uNllAoEwF73XVv4EOLQunpL+943AAAaWyjj0pxzPjKHmKHJUS/X3qwzs08C
AwEAAaNCMEAwDwYDVR0TAQH/BAUwAwEB/zAOBgNVHQ8BAf8EBAMCAcYwHQYDVR0O
BBYEFOCMm9slSbPxfIbWskKHC9BroNnkMA0GCSqGSIb3DQEBBQUAA4IBAQA+0hyJ
LjX8+HXd5n9liPRyTMks1zJO890ZeUe9jjtbkw9QSSQTaxQGcu8J06Gh40CEyecY
MnQ8SG4Pn0vU9x7Tk4ZkVJdjclDVVc/6IJMCopvDI5NOFlV2oHB5bc0hH88vLbwZ
44gx+FkagQnIl6Z0x2DEW8xXjrJ1/RsCCdtZb3KTafcxQdaIOL+Hsr0Wefmq5L6I
Jd1hJyMctTEHBDa0GpC9oHRxUIltvBTjD4au8as+x6AJzKNI0eDbZOeStc+vckNw
i/nDhDwTqn6Sm1dTk/pwwpEOMfmbZ13pljheX7NzTogVZ96edhBiIL5VaZVDADlN
9u6wWk5JRFRYX0KD
-----END CERTIFICATE-----

NetLock Arany (Class Gold) Főtanúsítvány
================================================
SHA1 Fingerprint=06:08:3F:59:3F:15:A1:04:A0:69:A4:6B:A9:03:D0:06:B7:97:09:91
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 80544274841616 (0x49412ce40010)
    Signature Algorithm: sha256WithRSAEncryption
        Issuer: C=HU, L=Budapest, O=NetLock Kft., OU=Tan\xC3\xBAs\xC3\xADtv\xC3\xA1nykiad\xC3\xB3k (Certification Services), CN=NetLock Arany (Class Gold) F\xC5\x91tan\xC3\xBAs\xC3\xADtv\xC3\xA1ny
        Validity
            Not Before: Dec 11 15:08:21 2008 GMT
            Not After : Dec  6 15:08:21 2028 GMT
        Subject: C=HU, L=Budapest, O=NetLock Kft., OU=Tan\xC3\xBAs\xC3\xADtv\xC3\xA1nykiad\xC3\xB3k (Certification Services), CN=NetLock Arany (Class Gold) F\xC5\x91tan\xC3\xBAs\xC3\xADtv\xC3\xA1ny
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (2048 bit)
                Modulus:
                    00:c4:24:5e:73:be:4b:6d:14:c3:a1:f4:e3:97:90:
                    6e:d2:30:45:1e:3c:ee:67:d9:64:e0:1a:8a:7f:ca:
                    30:ca:83:e3:20:c1:e3:f4:3a:d3:94:5f:1a:7c:5b:
                    6d:bf:30:4f:84:27:f6:9f:1f:49:bc:c6:99:0a:90:
                    f2:0f:f5:7f:43:84:37:63:51:8b:7a:a5:70:fc:7a:
                    58:cd:8e:9b:ed:c3:46:6c:84:70:5d:da:f3:01:90:
                    23:fc:4e:30:a9:7e:e1:27:63:e7:ed:64:3c:a0:b8:
                    c9:33:63:fe:16:90:ff:b0:b8:fd:d7:a8:c0:c0:94:
                    43:0b:b6:d5:59:a6:9e:56:d0:24:1f:70:79:af:db:
                    39:54:0d:65:75:d9:15:41:94:01:af:5e:ec:f6:8d:
                    f1:ff:ad:64:fe:20:9a:d7:5c:eb:fe:a6:1f:08:64:
                    a3:8b:76:55:ad:1e:3b:28:60:2e:87:25:e8:aa:af:
                    1f:c6:64:46:20:b7:70:7f:3c:de:48:db:96:53:b7:
                    39:77:e4:1a:e2:c7:16:84:76:97:5b:2f:bb:19:15:
                    85:f8:69:85:f5:99:a7:a9:f2:34:a7:a9:b6:a6:03:
                    fc:6f:86:3d:54:7c:76:04:9b:6b:f9:40:5d:00:34:
                    c7:2e:99:75:9d:e5:88:03:aa:4d:f8:03:d2:42:76:
                    c0:1b
                Exponent: 43147 (0xa88b)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE, pathlen:4
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Subject Key Identifier: 
                CC:FA:67:93:F0:B6:B8:D0:A5:C0:1E:F3:53:FD:8C:53:DF:83:D7:96
    Signature Algorithm: sha256WithRSAEncryption
         ab:7f:ee:1c:16:a9:9c:3c:51:00:a0:c0:11:08:05:a7:99:e6:
         6f:01:88:54:61:6e:f1:b9:18:ad:4a:ad:fe:81:40:23:94:2f:
         fb:75:7c:2f:28:4b:62:24:81:82:0b:f5:61:f1:1c:6e:b8:61:
         38:eb:81:fa:62:a1:3b:5a:62:d3:94:65:c4:e1:e6:6d:82:f8:
         2f:25:70:b2:21:26:c1:72:51:1f:8c:2c:c3:84:90:c3:5a:8f:
         ba:cf:f4:a7:65:a5:eb:98:d1:fb:05:b2:46:75:15:23:6a:6f:
         85:63:30:80:f0:d5:9e:1f:29:1c:c2:6c:b0:50:59:5d:90:5b:
         3b:a8:0d:30:cf:bf:7d:7f:ce:f1:9d:83:bd:c9:46:6e:20:a6:
         f9:61:51:ba:21:2f:7b:be:a5:15:63:a1:d4:95:87:f1:9e:b9:
         f3:89:f3:3d:85:b8:b8:db:be:b5:b9:29:f9:da:37:05:00:49:
         94:03:84:44:e7:bf:43:31:cf:75:8b:25:d1:f4:a6:64:f5:92:
         f6:ab:05:eb:3d:e9:a5:0b:36:62:da:cc:06:5f:36:8b:b6:5e:
         31:b8:2a:fb:5e:f6:71:df:44:26:9e:c4:e6:0d:91:b4:2e:75:
         95:80:51:6a:4b:30:a6:b0:62:a1:93:f1:9b:d8:ce:c4:63:75:
         3f:59:47:b1
-----BEGIN CERTIFICATE-----
MIIEFTCCAv2gAwIBAgIGSUEs5AAQMA0GCSqGSIb3DQEBCwUAMIGnMQswCQYDVQQG
EwJIVTERMA8GA1UEBwwIQnVkYXBlc3QxFTATBgNVBAoMDE5ldExvY2sgS2Z0LjE3
MDUGA1UECwwuVGFuw7pzw610dsOhbnlraWFkw7NrIChDZXJ0aWZpY2F0aW9uIFNl
cnZpY2VzKTE1MDMGA1UEAwwsTmV0TG9jayBBcmFueSAoQ2xhc3MgR29sZCkgRsWR
dGFuw7pzw610dsOhbnkwHhcNMDgxMjExMTUwODIxWhcNMjgxMjA2MTUwODIxWjCB
pzELMAkGA1UEBhMCSFUxETAPBgNVBAcMCEJ1ZGFwZXN0MRUwEwYDVQQKDAxOZXRM
b2NrIEtmdC4xNzA1BgNVBAsMLlRhbsO6c8OtdHbDoW55a2lhZMOzayAoQ2VydGlm
aWNhdGlvbiBTZXJ2aWNlcykxNTAzBgNVBAMMLE5ldExvY2sgQXJhbnkgKENsYXNz
IEdvbGQpIEbFkXRhbsO6c8OtdHbDoW55MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8A
MIIBCgKCAQEAxCRec75LbRTDofTjl5Bu0jBFHjzuZ9lk4BqKf8owyoPjIMHj9DrT
lF8afFttvzBPhCf2nx9JvMaZCpDyD/V/Q4Q3Y1GLeqVw/HpYzY6b7cNGbIRwXdrz
AZAj/E4wqX7hJ2Pn7WQ8oLjJM2P+FpD/sLj916jAwJRDC7bVWaaeVtAkH3B5r9s5
VA1lddkVQZQBr17s9o3x/61k/iCa11zr/qYfCGSji3ZVrR47KGAuhyXoqq8fxmRG
ILdwfzzeSNuWU7c5d+Qa4scWhHaXWy+7GRWF+GmF9ZmnqfI0p6m2pgP8b4Y9VHx2
BJtr+UBdADTHLpl1neWIA6pN+APSQnbAGwIDAKiLo0UwQzASBgNVHRMBAf8ECDAG
AQH/AgEEMA4GA1UdDwEB/wQEAwIBBjAdBgNVHQ4EFgQUzPpnk/C2uNClwB7zU/2M
U9+D15YwDQYJKoZIhvcNAQELBQADggEBAKt/7hwWqZw8UQCgwBEIBaeZ5m8BiFRh
bvG5GK1Krf6BQCOUL/t1fC8oS2IkgYIL9WHxHG64YTjrgfpioTtaYtOUZcTh5m2C
+C8lcLIhJsFyUR+MLMOEkMNaj7rP9KdlpeuY0fsFskZ1FSNqb4VjMIDw1Z4fKRzC
bLBQWV2QWzuoDTDPv31/zvGdg73JRm4gpvlhUbohL3u+pRVjodSVh/GeufOJ8z2F
uLjbvrW5KfnaNwUASZQDhETnv0Mxz3WLJdH0pmT1kvarBes96aULNmLazAZfNou2
XjG4Kvte9nHfRCaexOYNkbQudZWAUWpLMKawYqGT8ZvYzsRjdT9ZR7E=
-----END CERTIFICATE-----

Hongkong Post Root CA 1
=================================================
SHA1 Fingerprint=D6:DA:A8:20:8D:09:D2:15:4D:24:B5:2F:CB:34:6E:B2:58:B2:8A:58
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 1000 (0x3e8)
    Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=HK, O=Hongkong Post, CN=Hongkong Post Root CA 1
        Validity
            Not Before: May 15 05:13:14 2003 GMT
            Not After : May 15 04:52:29 2023 GMT
        Subject: C=HK, O=Hongkong Post, CN=Hongkong Post Root CA 1
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (2048 bit)
                Modulus:
                    00:ac:ff:38:b6:e9:66:02:49:e3:a2:b4:e1:90:f9:
                    40:8f:79:f9:e2:bd:79:fe:02:bd:ee:24:92:1d:22:
                    f6:da:85:72:69:fe:d7:3f:09:d4:dd:91:b5:02:9c:
                    d0:8d:5a:e1:55:c3:50:86:b9:29:26:c2:e3:d9:a0:
                    f1:69:03:28:20:80:45:22:2d:56:a7:3b:54:95:56:
                    22:59:1f:28:df:1f:20:3d:6d:a2:36:be:23:a0:b1:
                    6e:b5:b1:27:3f:39:53:09:ea:ab:6a:e8:74:b2:c2:
                    65:5c:8e:bf:7c:c3:78:84:cd:9e:16:fc:f5:2e:4f:
                    20:2a:08:9f:77:f3:c5:1e:c4:9a:52:66:1e:48:5e:
                    e3:10:06:8f:22:98:e1:65:8e:1b:5d:23:66:3b:b8:
                    a5:32:51:c8:86:aa:a1:a9:9e:7f:76:94:c2:a6:6c:
                    b7:41:f0:d5:c8:06:38:e6:d4:0c:e2:f3:3b:4c:6d:
                    50:8c:c4:83:27:c1:13:84:59:3d:9e:75:74:b6:d8:
                    02:5e:3a:90:7a:c0:42:36:72:ec:6a:4d:dc:ef:c4:
                    00:df:13:18:57:5f:26:78:c8:d6:0a:79:77:bf:f7:
                    af:b7:76:b9:a5:0b:84:17:5d:10:ea:6f:e1:ab:95:
                    11:5f:6d:3c:a3:5c:4d:83:5b:f2:b3:19:8a:80:8b:
                    0b:87
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE, pathlen:3
            X509v3 Key Usage: critical
                Digital Signature, Non Repudiation, Certificate Sign, CRL Sign
    Signature Algorithm: sha1WithRSAEncryption
         0e:46:d5:3c:ae:e2:87:d9:5e:81:8b:02:98:41:08:8c:4c:bc:
         da:db:ee:27:1b:82:e7:6a:45:ec:16:8b:4f:85:a0:f3:b2:70:
         bd:5a:96:ba:ca:6e:6d:ee:46:8b:6e:e7:2a:2e:96:b3:19:33:
         eb:b4:9f:a8:b2:37:ee:98:a8:97:b6:2e:b6:67:27:d4:a6:49:
         fd:1c:93:65:76:9e:42:2f:dc:22:6c:9a:4f:f2:5a:15:39:b1:
         71:d7:2b:51:e8:6d:1c:98:c0:d9:2a:f4:a1:82:7b:d5:c9:41:
         a2:23:01:74:38:55:8b:0f:b9:2e:67:a2:20:04:37:da:9c:0b:
         d3:17:21:e0:8f:97:79:34:6f:84:48:02:20:33:1b:e6:34:44:
         9f:91:70:f4:80:5e:84:43:c2:29:d2:6c:12:14:e4:61:8d:ac:
         10:90:9e:84:50:bb:f0:96:6f:45:9f:8a:f3:ca:6c:4f:fa:11:
         3a:15:15:46:c3:cd:1f:83:5b:2d:41:12:ed:50:67:41:13:3d:
         21:ab:94:8a:aa:4e:7c:c1:b1:fb:a7:d6:b5:27:2f:97:ab:6e:
         e0:1d:e2:d1:1c:2c:1f:44:e2:fc:be:91:a1:9c:fb:d6:29:53:
         73:86:9f:53:d8:43:0e:5d:d6:63:82:71:1d:80:74:ca:f6:e2:
         02:6b:d9:5a
-----BEGIN CERTIFICATE-----
MIIDMDCCAhigAwIBAgICA+gwDQYJKoZIhvcNAQEFBQAwRzELMAkGA1UEBhMCSEsx
FjAUBgNVBAoTDUhvbmdrb25nIFBvc3QxIDAeBgNVBAMTF0hvbmdrb25nIFBvc3Qg
Um9vdCBDQSAxMB4XDTAzMDUxNTA1MTMxNFoXDTIzMDUxNTA0NTIyOVowRzELMAkG
A1UEBhMCSEsxFjAUBgNVBAoTDUhvbmdrb25nIFBvc3QxIDAeBgNVBAMTF0hvbmdr
b25nIFBvc3QgUm9vdCBDQSAxMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKC
AQEArP84tulmAknjorThkPlAj3n54r15/gK97iSSHSL22oVyaf7XPwnU3ZG1ApzQ
jVrhVcNQhrkpJsLj2aDxaQMoIIBFIi1WpztUlVYiWR8o3x8gPW2iNr4joLFutbEn
PzlTCeqrauh0ssJlXI6/fMN4hM2eFvz1Lk8gKgifd/PFHsSaUmYeSF7jEAaPIpjh
ZY4bXSNmO7ilMlHIhqqhqZ5/dpTCpmy3QfDVyAY45tQM4vM7TG1QjMSDJ8EThFk9
nnV0ttgCXjqQesBCNnLsak3c78QA3xMYV18meMjWCnl3v/evt3a5pQuEF10Q6m/h
q5URX208o1xNg1vysxmKgIsLhwIDAQABoyYwJDASBgNVHRMBAf8ECDAGAQH/AgED
MA4GA1UdDwEB/wQEAwIBxjANBgkqhkiG9w0BAQUFAAOCAQEADkbVPK7ih9legYsC
mEEIjEy82tvuJxuC52pF7BaLT4Wg87JwvVqWuspube5Gi27nKi6Wsxkz67SfqLI3
7piol7Yutmcn1KZJ/RyTZXaeQi/cImyaT/JaFTmxcdcrUehtHJjA2Sr0oYJ71clB
oiMBdDhViw+5LmeiIAQ32pwL0xch4I+XeTRvhEgCIDMb5jREn5Fw9IBehEPCKdJs
EhTkYY2sEJCehFC78JZvRZ+K88psT/oROhUVRsPNH4NbLUES7VBnQRM9IauUiqpO
fMGx+6fWtScvl6tu4B3i0RwsH0Ti/L6RoZz71ilTc4afU9hDDl3WY4JxHYB0yvbi
AmvZWg==
-----END CERTIFICATE-----

SecureSign RootCA11
=================================================
SHA1 Fingerprint=3B:C4:9F:48:F8:F3:73:A0:9C:1E:BD:F8:5B:B1:C3:65:C7:D8:11:B3
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 1 (0x1)
    Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=JP, O=Japan Certification Services, Inc., CN=SecureSign RootCA11
        Validity
            Not Before: Apr  8 04:56:47 2009 GMT
            Not After : Apr  8 04:56:47 2029 GMT
        Subject: C=JP, O=Japan Certification Services, Inc., CN=SecureSign RootCA11
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (2048 bit)
                Modulus:
                    00:fd:77:aa:a5:1c:90:05:3b:cb:4c:9b:33:8b:5a:
                    14:45:a4:e7:90:16:d1:df:57:d2:21:10:a4:17:fd:
                    df:ac:d6:1f:a7:e4:db:7c:f7:ec:df:b8:03:da:94:
                    58:fd:5d:72:7c:8c:3f:5f:01:67:74:15:96:e3:02:
                    3c:87:db:ae:cb:01:8e:c2:f3:66:c6:85:45:f4:02:
                    c6:3a:b5:62:b2:af:fa:9c:bf:a4:e6:d4:80:30:98:
                    f3:0d:b6:93:8f:a9:d4:d8:36:f2:b0:fc:8a:ca:2c:
                    a1:15:33:95:31:da:c0:1b:f2:ee:62:99:86:63:3f:
                    bf:dd:93:2a:83:a8:76:b9:13:1f:b7:ce:4e:42:85:
                    8f:22:e7:2e:1a:f2:95:09:b2:05:b5:44:4e:77:a1:
                    20:bd:a9:f2:4e:0a:7d:50:ad:f5:05:0d:45:4f:46:
                    71:fd:28:3e:53:fb:04:d8:2d:d7:65:1d:4a:1b:fa:
                    cf:3b:b0:31:9a:35:6e:c8:8b:06:d3:00:91:f2:94:
                    08:65:4c:b1:34:06:00:7a:89:e2:f0:c7:03:59:cf:
                    d5:d6:e8:a7:32:b3:e6:98:40:86:c5:cd:27:12:8b:
                    cc:7b:ce:b7:11:3c:62:60:07:23:3e:2b:40:6e:94:
                    80:09:6d:b6:b3:6f:77:6f:35:08:50:fb:02:87:c5:
                    3e:89
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Subject Key Identifier: 
                5B:F8:4D:4F:B2:A5:86:D4:3A:D2:F1:63:9A:A0:BE:09:F6:57:B7:DE
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
    Signature Algorithm: sha1WithRSAEncryption
         a0:a1:38:16:66:2e:a7:56:1f:21:9c:06:fa:1d:ed:b9:22:c5:
         38:26:d8:4e:4f:ec:a3:7f:79:de:46:21:a1:87:77:8f:07:08:
         9a:b2:a4:c5:af:0f:32:98:0b:7c:66:29:b6:9b:7d:25:52:49:
         43:ab:4c:2e:2b:6e:7a:70:af:16:0e:e3:02:6c:fb:42:e6:18:
         9d:45:d8:55:c8:e8:3b:dd:e7:e1:f4:2e:0b:1c:34:5c:6c:58:
         4a:fb:8c:88:50:5f:95:1c:bf:ed:ab:22:b5:65:b3:85:ba:9e:
         0f:b8:ad:e5:7a:1b:8a:50:3a:1d:bd:0d:bc:7b:54:50:0b:b9:
         42:af:55:a0:18:81:ad:65:99:ef:be:e4:9c:bf:c4:85:ab:41:
         b2:54:6f:dc:25:cd:ed:78:e2:8e:0c:8d:09:49:dd:63:7b:5a:
         69:96:02:21:a8:bd:52:59:e9:7d:35:cb:c8:52:ca:7f:81:fe:
         d9:6b:d3:f7:11:ed:25:df:f8:e7:f9:a4:fa:72:97:84:53:0d:
         a5:d0:32:18:51:76:59:14:6c:0f:eb:ec:5f:80:8c:75:43:83:
         c3:85:98:ff:4c:9e:2d:0d:e4:77:83:93:4e:b5:96:07:8b:28:
         13:9b:8c:19:8d:41:27:49:40:ee:de:e6:23:44:39:dc:a1:22:
         d6:ba:03:f2
-----BEGIN CERTIFICATE-----
MIIDbTCCAlWgAwIBAgIBATANBgkqhkiG9w0BAQUFADBYMQswCQYDVQQGEwJKUDEr
MCkGA1UEChMiSmFwYW4gQ2VydGlmaWNhdGlvbiBTZXJ2aWNlcywgSW5jLjEcMBoG
A1UEAxMTU2VjdXJlU2lnbiBSb290Q0ExMTAeFw0wOTA0MDgwNDU2NDdaFw0yOTA0
MDgwNDU2NDdaMFgxCzAJBgNVBAYTAkpQMSswKQYDVQQKEyJKYXBhbiBDZXJ0aWZp
Y2F0aW9uIFNlcnZpY2VzLCBJbmMuMRwwGgYDVQQDExNTZWN1cmVTaWduIFJvb3RD
QTExMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA/XeqpRyQBTvLTJsz
i1oURaTnkBbR31fSIRCkF/3frNYfp+TbfPfs37gD2pRY/V1yfIw/XwFndBWW4wI8
h9uuywGOwvNmxoVF9ALGOrVisq/6nL+k5tSAMJjzDbaTj6nU2DbysPyKyiyhFTOV
MdrAG/LuYpmGYz+/3ZMqg6h2uRMft85OQoWPIucuGvKVCbIFtUROd6EgvanyTgp9
UK31BQ1FT0Zx/Sg+U/sE2C3XZR1KG/rPO7AxmjVuyIsG0wCR8pQIZUyxNAYAeoni
8McDWc/V1uinMrPmmECGxc0nEovMe863ETxiYAcjPitAbpSACW22s293bzUIUPsC
h8U+iQIDAQABo0IwQDAdBgNVHQ4EFgQUW/hNT7KlhtQ60vFjmqC+CfZXt94wDgYD
VR0PAQH/BAQDAgEGMA8GA1UdEwEB/wQFMAMBAf8wDQYJKoZIhvcNAQEFBQADggEB
AKChOBZmLqdWHyGcBvod7bkixTgm2E5P7KN/ed5GIaGHd48HCJqypMWvDzKYC3xm
KbabfSVSSUOrTC4rbnpwrxYO4wJs+0LmGJ1F2FXI6Dvd5+H0LgscNFxsWEr7jIhQ
X5Ucv+2rIrVls4W6ng+4reV6G4pQOh29Dbx7VFALuUKvVaAYga1lme++5Jy/xIWr
QbJUb9wlze144o4MjQlJ3WN7WmmWAiGovVJZ6X01y8hSyn+B/tlr0/cR7SXf+Of5
pPpyl4RTDaXQMhhRdlkUbA/r7F+AjHVDg8OFmP9Mni0N5HeDk061lgeLKBObjBmN
QSdJQO7e5iNEOdyhIta6A/I=
-----END CERTIFICATE-----

Microsec e-Szigno Root CA 2009
================================================
SHA1 Fingerprint=89:DF:74:FE:5C:F4:0F:4A:80:F9:E3:37:7D:54:DA:91:E1:01:31:8E
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 14014712776195784473 (0xc27e43044e473f19)
    Signature Algorithm: sha256WithRSAEncryption
        Issuer: C=HU, L=Budapest, O=Microsec Ltd., CN=Microsec e-Szigno Root CA 2009/emailAddress=info@e-szigno.hu
        Validity
            Not Before: Jun 16 11:30:18 2009 GMT
            Not After : Dec 30 11:30:18 2029 GMT
        Subject: C=HU, L=Budapest, O=Microsec Ltd., CN=Microsec e-Szigno Root CA 2009/emailAddress=info@e-szigno.hu
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (2048 bit)
                Modulus:
                    00:e9:f8:8f:f3:63:ad:da:86:d8:a7:e0:42:fb:cf:
                    91:de:a6:26:f8:99:a5:63:70:ad:9b:ae:ca:33:40:
                    7d:6d:96:6e:a1:0e:44:ee:e1:13:9d:94:42:52:9a:
                    bd:75:85:74:2c:a8:0e:1d:93:b6:18:b7:8c:2c:a8:
                    cf:fb:5c:71:b9:da:ec:fe:e8:7e:8f:e4:2f:1d:b2:
                    a8:75:87:d8:b7:a1:e5:3b:cf:99:4a:46:d0:83:19:
                    7d:c0:a1:12:1c:95:6d:4a:f4:d8:c7:a5:4d:33:2e:
                    85:39:40:75:7e:14:7c:80:12:98:50:c7:41:67:b8:
                    a0:80:61:54:a6:6c:4e:1f:e0:9d:0e:07:e9:c9:ba:
                    33:e7:fe:c0:55:28:2c:02:80:a7:19:f5:9e:dc:55:
                    53:03:97:7b:07:48:ff:99:fb:37:8a:24:c4:59:cc:
                    50:10:63:8e:aa:a9:1a:b0:84:1a:86:f9:5f:bb:b1:
                    50:6e:a4:d1:0a:cc:d5:71:7e:1f:a7:1b:7c:f5:53:
                    6e:22:5f:cb:2b:e6:d4:7c:5d:ae:d6:c2:c6:4c:e5:
                    05:01:d9:ed:57:fc:c1:23:79:fc:fa:c8:24:83:95:
                    f3:b5:6a:51:01:d0:77:d6:e9:12:a1:f9:1a:83:fb:
                    82:1b:b9:b0:97:f4:76:06:33:43:49:a0:ff:0b:b5:
                    fa:b5
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Subject Key Identifier: 
                CB:0F:C6:DF:42:43:CC:3D:CB:B5:48:23:A1:1A:7A:A6:2A:BB:34:68
            X509v3 Authority Key Identifier: 
                keyid:CB:0F:C6:DF:42:43:CC:3D:CB:B5:48:23:A1:1A:7A:A6:2A:BB:34:68

            X509v3 Subject Alternative Name: 
                email:info@e-szigno.hu
    Signature Algorithm: sha256WithRSAEncryption
         c9:d1:0e:5e:2e:d5:cc:b3:7c:3e:cb:fc:3d:ff:0d:28:95:93:
         04:c8:bf:da:cd:79:b8:43:90:f0:a4:be:ef:f2:ef:21:98:bc:
         d4:d4:5d:06:f6:ee:42:ec:30:6c:a0:aa:a9:ca:f1:af:8a:fa:
         3f:0b:73:6a:3e:ea:2e:40:7e:1f:ae:54:61:79:eb:2e:08:37:
         d7:23:f3:8c:9f:be:1d:b1:e1:a4:75:db:a0:e2:54:14:b1:ba:
         1c:29:a4:18:f6:12:ba:a2:14:14:e3:31:35:c8:40:ff:b7:e0:
         05:76:57:c1:1c:59:f2:f8:bf:e4:ed:25:62:5c:84:f0:7e:7e:
         1f:b3:be:f9:b7:21:11:cc:03:01:56:70:a7:10:92:1e:1b:34:
         81:1e:ad:9c:1a:c3:04:3c:ed:02:61:d6:1e:06:f3:5f:3a:87:
         f2:2b:f1:45:87:e5:3d:ac:d1:c7:57:84:bd:6b:ae:dc:d8:f9:
         b6:1b:62:70:0b:3d:36:c9:42:f2:32:d7:7a:61:e6:d2:db:3d:
         cf:c8:a9:c9:9b:dc:db:58:44:d7:6f:38:af:7f:78:d3:a3:ad:
         1a:75:ba:1c:c1:36:7c:8f:1e:6d:1c:c3:75:46:ae:35:05:a6:
         f6:5c:3d:21:ee:56:f0:c9:82:22:2d:7a:54:ab:70:c3:7d:22:
         65:82:70:96
-----BEGIN CERTIFICATE-----
MIIECjCCAvKgAwIBAgIJAMJ+QwRORz8ZMA0GCSqGSIb3DQEBCwUAMIGCMQswCQYD
VQQGEwJIVTERMA8GA1UEBwwIQnVkYXBlc3QxFjAUBgNVBAoMDU1pY3Jvc2VjIEx0
ZC4xJzAlBgNVBAMMHk1pY3Jvc2VjIGUtU3ppZ25vIFJvb3QgQ0EgMjAwOTEfMB0G
CSqGSIb3DQEJARYQaW5mb0BlLXN6aWduby5odTAeFw0wOTA2MTYxMTMwMThaFw0y
OTEyMzAxMTMwMThaMIGCMQswCQYDVQQGEwJIVTERMA8GA1UEBwwIQnVkYXBlc3Qx
FjAUBgNVBAoMDU1pY3Jvc2VjIEx0ZC4xJzAlBgNVBAMMHk1pY3Jvc2VjIGUtU3pp
Z25vIFJvb3QgQ0EgMjAwOTEfMB0GCSqGSIb3DQEJARYQaW5mb0BlLXN6aWduby5o
dTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAOn4j/NjrdqG2KfgQvvP
kd6mJviZpWNwrZuuyjNAfW2WbqEORO7hE52UQlKavXWFdCyoDh2Tthi3jCyoz/tc
cbna7P7ofo/kLx2yqHWH2Leh5TvPmUpG0IMZfcChEhyVbUr02MelTTMuhTlAdX4U
fIASmFDHQWe4oIBhVKZsTh/gnQ4H6cm6M+f+wFUoLAKApxn1ntxVUwOXewdI/5n7
N4okxFnMUBBjjqqpGrCEGob5X7uxUG6k0QrM1XF+H6cbfPVTbiJfyyvm1HxdrtbC
xkzlBQHZ7Vf8wSN5/PrIJIOV87VqUQHQd9bpEqH5GoP7ghu5sJf0dgYzQ0mg/wu1
+rUCAwEAAaOBgDB+MA8GA1UdEwEB/wQFMAMBAf8wDgYDVR0PAQH/BAQDAgEGMB0G
A1UdDgQWBBTLD8bfQkPMPcu1SCOhGnqmKrs0aDAfBgNVHSMEGDAWgBTLD8bfQkPM
Pcu1SCOhGnqmKrs0aDAbBgNVHREEFDASgRBpbmZvQGUtc3ppZ25vLmh1MA0GCSqG
SIb3DQEBCwUAA4IBAQDJ0Q5eLtXMs3w+y/w9/w0olZMEyL/azXm4Q5DwpL7v8u8h
mLzU1F0G9u5C7DBsoKqpyvGvivo/C3NqPuouQH4frlRheesuCDfXI/OMn74dseGk
ddug4lQUsbocKaQY9hK6ohQU4zE1yED/t+AFdlfBHFny+L/k7SViXITwfn4fs775
tyERzAMBVnCnEJIeGzSBHq2cGsMEPO0CYdYeBvNfOofyK/FFh+U9rNHHV4S9a67c
2Pm2G2JwCz02yULyMtd6YebS2z3PyKnJm9zbWETXbzivf3jTo60adbocwTZ8jx5t
HMN1Rq41Bab2XD0h7lbwyYIiLXpUq3DDfSJlgnCW
-----END CERTIFICATE-----

GlobalSign Root CA - R3
================================================
SHA1 Fingerprint=D6:9B:56:11:48:F0:1C:77:C5:45:78:C1:09:26:DF:5B:85:69:76:AD
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            04:00:00:00:00:01:21:58:53:08:a2
    Signature Algorithm: sha256WithRSAEncryption
        Issuer: OU=GlobalSign Root CA - R3, O=GlobalSign, CN=GlobalSign
        Validity
            Not Before: Mar 18 10:00:00 2009 GMT
            Not After : Mar 18 10:00:00 2029 GMT
        Subject: OU=GlobalSign Root CA - R3, O=GlobalSign, CN=GlobalSign
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (2048 bit)
                Modulus:
                    00:cc:25:76:90:79:06:78:22:16:f5:c0:83:b6:84:
                    ca:28:9e:fd:05:76:11:c5:ad:88:72:fc:46:02:43:
                    c7:b2:8a:9d:04:5f:24:cb:2e:4b:e1:60:82:46:e1:
                    52:ab:0c:81:47:70:6c:dd:64:d1:eb:f5:2c:a3:0f:
                    82:3d:0c:2b:ae:97:d7:b6:14:86:10:79:bb:3b:13:
                    80:77:8c:08:e1:49:d2:6a:62:2f:1f:5e:fa:96:68:
                    df:89:27:95:38:9f:06:d7:3e:c9:cb:26:59:0d:73:
                    de:b0:c8:e9:26:0e:83:15:c6:ef:5b:8b:d2:04:60:
                    ca:49:a6:28:f6:69:3b:f6:cb:c8:28:91:e5:9d:8a:
                    61:57:37:ac:74:14:dc:74:e0:3a:ee:72:2f:2e:9c:
                    fb:d0:bb:bf:f5:3d:00:e1:06:33:e8:82:2b:ae:53:
                    a6:3a:16:73:8c:dd:41:0e:20:3a:c0:b4:a7:a1:e9:
                    b2:4f:90:2e:32:60:e9:57:cb:b9:04:92:68:68:e5:
                    38:26:60:75:b2:9f:77:ff:91:14:ef:ae:20:49:fc:
                    ad:40:15:48:d1:02:31:61:19:5e:b8:97:ef:ad:77:
                    b7:64:9a:7a:bf:5f:c1:13:ef:9b:62:fb:0d:6c:e0:
                    54:69:16:a9:03:da:6e:e9:83:93:71:76:c6:69:85:
                    82:17
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Subject Key Identifier: 
                8F:F0:4B:7F:A8:2E:45:24:AE:4D:50:FA:63:9A:8B:DE:E2:DD:1B:BC
    Signature Algorithm: sha256WithRSAEncryption
         4b:40:db:c0:50:aa:fe:c8:0c:ef:f7:96:54:45:49:bb:96:00:
         09:41:ac:b3:13:86:86:28:07:33:ca:6b:e6:74:b9:ba:00:2d:
         ae:a4:0a:d3:f5:f1:f1:0f:8a:bf:73:67:4a:83:c7:44:7b:78:
         e0:af:6e:6c:6f:03:29:8e:33:39:45:c3:8e:e4:b9:57:6c:aa:
         fc:12:96:ec:53:c6:2d:e4:24:6c:b9:94:63:fb:dc:53:68:67:
         56:3e:83:b8:cf:35:21:c3:c9:68:fe:ce:da:c2:53:aa:cc:90:
         8a:e9:f0:5d:46:8c:95:dd:7a:58:28:1a:2f:1d:de:cd:00:37:
         41:8f:ed:44:6d:d7:53:28:97:7e:f3:67:04:1e:15:d7:8a:96:
         b4:d3:de:4c:27:a4:4c:1b:73:73:76:f4:17:99:c2:1f:7a:0e:
         e3:2d:08:ad:0a:1c:2c:ff:3c:ab:55:0e:0f:91:7e:36:eb:c3:
         57:49:be:e1:2e:2d:7c:60:8b:c3:41:51:13:23:9d:ce:f7:32:
         6b:94:01:a8:99:e7:2c:33:1f:3a:3b:25:d2:86:40:ce:3b:2c:
         86:78:c9:61:2f:14:ba:ee:db:55:6f:df:84:ee:05:09:4d:bd:
         28:d8:72:ce:d3:62:50:65:1e:eb:92:97:83:31:d9:b3:b5:ca:
         47:58:3f:5f
-----BEGIN CERTIFICATE-----
MIIDXzCCAkegAwIBAgILBAAAAAABIVhTCKIwDQYJKoZIhvcNAQELBQAwTDEgMB4G
A1UECxMXR2xvYmFsU2lnbiBSb290IENBIC0gUjMxEzARBgNVBAoTCkdsb2JhbFNp
Z24xEzARBgNVBAMTCkdsb2JhbFNpZ24wHhcNMDkwMzE4MTAwMDAwWhcNMjkwMzE4
MTAwMDAwWjBMMSAwHgYDVQQLExdHbG9iYWxTaWduIFJvb3QgQ0EgLSBSMzETMBEG
A1UEChMKR2xvYmFsU2lnbjETMBEGA1UEAxMKR2xvYmFsU2lnbjCCASIwDQYJKoZI
hvcNAQEBBQADggEPADCCAQoCggEBAMwldpB5BngiFvXAg7aEyiie/QV2EcWtiHL8
RgJDx7KKnQRfJMsuS+FggkbhUqsMgUdwbN1k0ev1LKMPgj0MK66X17YUhhB5uzsT
gHeMCOFJ0mpiLx9e+pZo34knlTifBtc+ycsmWQ1z3rDI6SYOgxXG71uL0gRgykmm
KPZpO/bLyCiR5Z2KYVc3rHQU3HTgOu5yLy6c+9C7v/U9AOEGM+iCK65TpjoWc4zd
QQ4gOsC0p6Hpsk+QLjJg6VfLuQSSaGjlOCZgdbKfd/+RFO+uIEn8rUAVSNECMWEZ
XriX7613t2Saer9fwRPvm2L7DWzgVGkWqQPabumDk3F2xmmFghcCAwEAAaNCMEAw
DgYDVR0PAQH/BAQDAgEGMA8GA1UdEwEB/wQFMAMBAf8wHQYDVR0OBBYEFI/wS3+o
LkUkrk1Q+mOai97i3Ru8MA0GCSqGSIb3DQEBCwUAA4IBAQBLQNvAUKr+yAzv95ZU
RUm7lgAJQayzE4aGKAczymvmdLm6AC2upArT9fHxD4q/c2dKg8dEe3jgr25sbwMp
jjM5RcOO5LlXbKr8EpbsU8Yt5CRsuZRj+9xTaGdWPoO4zzUhw8lo/s7awlOqzJCK
6fBdRoyV3XpYKBovHd7NADdBj+1EbddTKJd+82cEHhXXipa0095MJ6RMG3NzdvQX
mcIfeg7jLQitChws/zyrVQ4PkX4268NXSb7hLi18YIvDQVETI53O9zJrlAGomecs
Mx86OyXShkDOOyyGeMlhLxS67ttVb9+E7gUJTb0o2HLO02JQZR7rkpeDMdmztcpH
WD9f
-----END CERTIFICATE-----

Autoridad de Certificacion Firmaprofesional CIF A62634068
=========================================================
SHA1 Fingerprint=AE:C5:FB:3F:C8:E1:BF:C4:E5:4F:03:07:5A:9A:E8:00:B7:F7:B6:FA
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 6047274297262753887 (0x53ec3beefbb2485f)
    Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=ES, CN=Autoridad de Certificacion Firmaprofesional CIF A62634068
        Validity
            Not Before: May 20 08:38:15 2009 GMT
            Not After : Dec 31 08:38:15 2030 GMT
        Subject: C=ES, CN=Autoridad de Certificacion Firmaprofesional CIF A62634068
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (4096 bit)
                Modulus:
                    00:ca:96:6b:8e:ea:f8:fb:f1:a2:35:e0:7f:4c:da:
                    e0:c3:52:d7:7d:b6:10:c8:02:5e:b3:43:2a:c4:4f:
                    6a:b2:ca:1c:5d:28:9a:78:11:1a:69:59:57:af:b5:
                    20:42:e4:8b:0f:e6:df:5b:a6:03:92:2f:f5:11:e4:
                    62:d7:32:71:38:d9:04:0c:71:ab:3d:51:7e:0f:07:
                    df:63:05:5c:e9:bf:94:6f:c1:29:82:c0:b4:da:51:
                    b0:c1:3c:bb:ad:37:4a:5c:ca:f1:4b:36:0e:24:ab:
                    bf:c3:84:77:fd:a8:50:f4:b1:e7:c6:2f:d2:2d:59:
                    8d:7a:0a:4e:96:69:52:02:aa:36:98:ec:fc:fa:14:
                    83:0c:37:1f:c9:92:37:7f:d7:81:2d:e5:c4:b9:e0:
                    3e:34:fe:67:f4:3e:66:d1:d3:f4:40:cf:5e:62:34:
                    0f:70:06:3e:20:18:5a:ce:f7:72:1b:25:6c:93:74:
                    14:93:a3:73:b1:0e:aa:87:10:23:59:5f:20:05:19:
                    47:ed:68:8e:92:12:ca:5d:fc:d6:2b:b2:92:3c:20:
                    cf:e1:5f:af:20:be:a0:76:7f:76:e5:ec:1a:86:61:
                    33:3e:e7:7b:b4:3f:a0:0f:8e:a2:b9:6a:6f:b9:87:
                    26:6f:41:6c:88:a6:50:fd:6a:63:0b:f5:93:16:1b:
                    19:8f:b2:ed:9b:9b:c9:90:f5:01:0c:df:19:3d:0f:
                    3e:38:23:c9:2f:8f:0c:d1:02:fe:1b:55:d6:4e:d0:
                    8d:3c:af:4f:a4:f3:fe:af:2a:d3:05:9d:79:08:a1:
                    cb:57:31:b4:9c:c8:90:b2:67:f4:18:16:93:3a:fc:
                    47:d8:d1:78:96:31:1f:ba:2b:0c:5f:5d:99:ad:63:
                    89:5a:24:20:76:d8:df:fd:ab:4e:a6:22:aa:9d:5e:
                    e6:27:8a:7d:68:29:a3:e7:8a:b8:da:11:bb:17:2d:
                    99:9d:13:24:46:f7:c5:e2:d8:9f:8e:7f:c7:8f:74:
                    6d:5a:b2:e8:72:f5:ac:ee:24:10:ad:2f:14:da:ff:
                    2d:9a:46:71:47:be:42:df:bb:01:db:f4:7f:d3:28:
                    8f:31:59:5b:d3:c9:02:a6:b4:52:ca:6e:97:fb:43:
                    c5:08:26:6f:8a:f4:bb:fd:9f:28:aa:0d:d5:45:f3:
                    13:3a:1d:d8:c0:78:8f:41:67:3c:1e:94:64:ae:7b:
                    0b:c5:e8:d9:01:88:39:1a:97:86:64:41:d5:3b:87:
                    0c:6e:fa:0f:c6:bd:48:14:bf:39:4d:d4:9e:41:b6:
                    8f:96:1d:63:96:93:d9:95:06:78:31:68:9e:37:06:
                    3b:80:89:45:61:39:23:c7:1b:44:a3:15:e5:1c:f8:
                    92:30:bb
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE, pathlen:1
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Subject Key Identifier: 
                65:CD:EB:AB:35:1E:00:3E:7E:D5:74:C0:1C:B4:73:47:0E:1A:64:2F
            X509v3 Certificate Policies: 
                Policy: X509v3 Any Policy
                  CPS: http://www.firmaprofesional.com/cps
                  User Notice:
                    Explicit Text: 

    Signature Algorithm: sha1WithRSAEncryption
         17:7d:a0:f9:b4:dd:c5:c5:eb:ad:4b:24:b5:a1:02:ab:dd:a5:
         88:4a:b2:0f:55:4b:2b:57:8c:3b:e5:31:dd:fe:c4:32:f1:e7:
         5b:64:96:36:32:18:ec:a5:32:77:d7:e3:44:b6:c0:11:2a:80:
         b9:3d:6a:6e:7c:9b:d3:ad:fc:c3:d6:a3:e6:64:29:7c:d1:e1:
         38:1e:82:2b:ff:27:65:af:fb:16:15:c4:2e:71:84:e5:b5:ff:
         fa:a4:47:bd:64:32:bb:f6:25:84:a2:27:42:f5:20:b0:c2:13:
         10:11:cd:10:15:ba:42:90:2a:d2:44:e1:96:26:eb:31:48:12:
         fd:2a:da:c9:06:cf:74:1e:a9:4b:d5:87:28:f9:79:34:92:3e:
         2e:44:e8:f6:8f:4f:8f:35:3f:25:b3:39:dc:63:2a:90:6b:20:
         5f:c4:52:12:4e:97:2c:2a:ac:9d:97:de:48:f2:a3:66:db:c2:
         d2:83:95:a6:66:a7:9e:25:0f:e9:0b:33:91:65:0a:5a:c3:d9:
         54:12:dd:af:c3:4e:0e:1f:26:5e:0d:dc:b3:8d:ec:d5:81:70:
         de:d2:4f:24:05:f3:6c:4e:f5:4c:49:66:8d:d1:ff:d2:0b:25:
         41:48:fe:51:84:c6:42:af:80:04:cf:d0:7e:64:49:e4:f2:df:
         a2:ec:b1:4c:c0:2a:1d:e7:b4:b1:65:a2:c4:bc:f1:98:f4:aa:
         70:07:63:b4:b8:da:3b:4c:fa:40:22:30:5b:11:a6:f0:05:0e:
         c6:02:03:48:ab:86:9b:85:dd:db:dd:ea:a2:76:80:73:7d:f5:
         9c:04:c4:45:8d:e7:b9:1c:8b:9e:ea:d7:75:d1:72:b1:de:75:
         44:e7:42:7d:e2:57:6b:7d:dc:99:bc:3d:83:28:ea:80:93:8d:
         c5:4c:65:c1:70:81:b8:38:fc:43:31:b2:f6:03:34:47:b2:ac:
         fb:22:06:cb:1e:dd:17:47:1c:5f:66:b9:d3:1a:a2:da:11:b1:
         a4:bc:23:c9:e4:be:87:ff:b9:94:b6:f8:5d:20:4a:d4:5f:e7:
         bd:68:7b:65:f2:15:1e:d2:3a:a9:2d:e9:d8:6b:24:ac:97:58:
         44:47:ad:59:18:f1:21:65:70:de:ce:34:60:a8:40:f1:f3:3c:
         a4:c3:28:23:8c:fe:27:33:43:40:a0:17:3c:eb:ea:3b:b0:72:
         a6:a3:b9:4a:4b:5e:16:48:f4:b2:bc:c8:8c:92:c5:9d:9f:ac:
         72:36:bc:34:80:34:6b:a9:8b:92:c0:b8:17:ed:ec:76:53:f5:
         24:01:8c:b3:22:e8:4b:7c:55:c6:9d:fa:a3:14:bb:65:85:6e:
         6e:4f:12:7e:0a:3c:9d:95
-----BEGIN CERTIFICATE-----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-----END CERTIFICATE-----

Izenpe.com
=================================================
SHA1 Fingerprint=2F:78:3D:25:52:18:A7:4A:65:39:71:B5:2C:A2:9C:45:15:6F:E9:19
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            b0:b7:5a:16:48:5f:bf:e1:cb:f5:8b:d7:19:e6:7d
    Signature Algorithm: sha256WithRSAEncryption
        Issuer: C=ES, O=IZENPE S.A., CN=Izenpe.com
        Validity
            Not Before: Dec 13 13:08:28 2007 GMT
            Not After : Dec 13 08:27:25 2037 GMT
        Subject: C=ES, O=IZENPE S.A., CN=Izenpe.com
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (4096 bit)
                Modulus:
                    00:c9:d3:7a:ca:0f:1e:ac:a7:86:e8:16:65:6a:b1:
                    c2:1b:45:32:71:95:d9:fe:10:5b:cc:af:e7:a5:79:
                    01:8f:89:c3:ca:f2:55:71:f7:77:be:77:94:f3:72:
                    a4:2c:44:d8:9e:92:9b:14:3a:a1:e7:24:90:0a:0a:
                    56:8e:c5:d8:26:94:e1:d9:48:e1:2d:3e:da:0a:72:
                    dd:a3:99:15:da:81:a2:87:f4:7b:6e:26:77:89:58:
                    ad:d6:eb:0c:b2:41:7a:73:6e:6d:db:7a:78:41:e9:
                    08:88:12:7e:87:2e:66:11:63:6c:54:fb:3c:9d:72:
                    c0:bc:2e:ff:c2:b7:dd:0d:76:e3:3a:d7:f7:b4:68:
                    be:a2:f5:e3:81:6e:c1:46:6f:5d:8d:e0:4d:c6:54:
                    55:89:1a:33:31:0a:b1:57:b9:a3:8a:98:c3:ec:3b:
                    34:c5:95:41:69:7e:75:c2:3c:20:c5:61:ba:51:47:
                    a0:20:90:93:a1:90:4b:f3:4e:7c:85:45:54:9a:d1:
                    05:26:41:b0:b5:4d:1d:33:be:c4:03:c8:25:7c:c1:
                    70:db:3b:f4:09:2d:54:27:48:ac:2f:e1:c4:ac:3e:
                    c8:cb:92:4c:53:39:37:23:ec:d3:01:f9:e0:09:44:
                    4d:4d:64:c0:e1:0d:5a:87:22:bc:ad:1b:a3:fe:26:
                    b5:15:f3:a7:fc:84:19:e9:ec:a1:88:b4:44:69:84:
                    83:f3:89:d1:74:06:a9:cc:0b:d6:c2:de:27:85:50:
                    26:ca:17:b8:c9:7a:87:56:2c:1a:01:1e:6c:be:13:
                    ad:10:ac:b5:24:f5:38:91:a1:d6:4b:da:f1:bb:d2:
                    de:47:b5:f1:bc:81:f6:59:6b:cf:19:53:e9:8d:15:
                    cb:4a:cb:a9:6f:44:e5:1b:41:cf:e1:86:a7:ca:d0:
                    6a:9f:bc:4c:8d:06:33:5a:a2:85:e5:90:35:a0:62:
                    5c:16:4e:f0:e3:a2:fa:03:1a:b4:2c:71:b3:58:2c:
                    de:7b:0b:db:1a:0f:eb:de:21:1f:06:77:06:03:b0:
                    c9:ef:99:fc:c0:b9:4f:0b:86:28:fe:d2:b9:ea:e3:
                    da:a5:c3:47:69:12:e0:db:f0:f6:19:8b:ed:7b:70:
                    d7:02:d6:ed:87:18:28:2c:04:24:4c:77:e4:48:8a:
                    1a:c6:3b:9a:d4:0f:ca:fa:75:d2:01:40:5a:8d:79:
                    bf:8b:cf:4b:cf:aa:16:c1:95:e4:ad:4c:8a:3e:17:
                    91:d4:b1:62:e5:82:e5:80:04:a4:03:7e:8d:bf:da:
                    7f:a2:0f:97:4f:0c:d3:0d:fb:d7:d1:e5:72:7e:1c:
                    c8:77:ff:5b:9a:0f:b7:ae:05:46:e5:f1:a8:16:ec:
                    47:a4:17
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Subject Alternative Name: 
                email:info@izenpe.com, DirName:/O=IZENPE S.A. - CIF A01337260-RMerc.Vitoria-Gasteiz T1055 F62 S8/street=Avda del Mediterraneo Etorbidea 14 - 01010 Vitoria-Gasteiz
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Subject Key Identifier: 
                1D:1C:65:0E:A8:F2:25:7B:B4:91:CF:E4:B1:B1:E6:BD:55:74:6C:05
    Signature Algorithm: sha256WithRSAEncryption
         78:a6:0c:16:4a:9f:4c:88:3a:c0:cb:0e:a5:16:7d:9f:b9:48:
         5f:18:8f:0d:62:36:f6:cd:19:6b:ac:ab:d5:f6:91:7d:ae:71:
         f3:3f:b3:0e:78:85:9b:95:a4:27:21:47:42:4a:7c:48:3a:f5:
         45:7c:b3:0c:8e:51:78:ac:95:13:de:c6:fd:7d:b8:1a:90:4c:
         ab:92:03:c7:ed:42:01:ce:0f:d8:b1:fa:a2:92:e1:60:6d:ae:
         7a:6b:09:aa:c6:29:ee:68:49:67:30:80:24:7a:31:16:39:5b:
         7e:f1:1c:2e:dd:6c:09:ad:f2:31:c1:82:4e:b9:bb:f9:be:bf:
         2a:85:3f:c0:40:a3:3a:59:fc:59:4b:3c:28:24:db:b4:15:75:
         ae:0d:88:ba:2e:73:c0:bd:58:87:e5:42:f2:eb:5e:ee:1e:30:
         22:99:cb:37:d1:c4:21:6c:81:ec:be:6d:26:e6:1c:e4:42:20:
         9e:47:b0:ac:83:59:70:2c:35:d6:af:36:34:b4:cd:3b:f8:32:
         a8:ef:e3:78:89:fb:8d:45:2c:da:9c:b8:7e:40:1c:61:e7:3e:
         a2:92:2c:4b:f2:cd:fa:98:b6:29:ff:f3:f2:7b:a9:1f:2e:a0:
         93:57:2b:de:85:03:f9:69:37:cb:9e:78:6a:05:b4:c5:31:78:
         89:ec:7a:a7:85:e1:b9:7b:3c:de:be:1e:79:84:ce:9f:70:0e:
         59:c2:35:2e:90:2a:31:d9:e4:45:7a:41:a4:2e:13:9b:34:0e:
         66:7b:49:ab:64:97:d0:46:c3:79:9d:72:50:63:a6:98:5b:06:
         bd:48:6d:d8:39:83:70:e8:35:f0:05:d1:aa:bc:e3:db:c8:02:
         ea:7c:fd:82:da:c2:5b:52:35:ae:98:3a:ad:ba:35:93:23:a7:
         1f:48:dd:35:46:98:b2:10:68:e4:a5:31:c2:0a:58:2e:19:81:
         10:c9:50:75:fc:ea:5a:16:ce:11:d7:ee:ef:50:88:2d:61:ff:
         3f:42:73:05:94:43:d5:8e:3c:4e:01:3a:19:a5:1f:46:4e:77:
         d0:5d:e5:81:22:21:87:fe:94:7d:84:d8:93:ad:d6:68:43:48:
         b2:db:eb:73:24:e7:91:7f:54:a4:b6:80:3e:9d:a3:3c:4c:72:
         c2:57:c4:a0:d4:cc:38:27:ce:d5:06:9e:a2:48:d9:e9:9f:ce:
         82:70:36:93:9a:3b:df:96:21:e3:59:b7:0c:da:91:37:f0:fd:
         59:5a:b3:99:c8:69:6c:43:26:01:35:63:60:55:89:03:3a:75:
         d8:ba:4a:d9:54:ff:ee:de:80:d8:2d:d1:38:d5:5e:2d:0b:98:
         7d:3e:6c:db:fc:26:88:c7
-----BEGIN CERTIFICATE-----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-----END CERTIFICATE-----

Go Daddy Root Certificate Authority - G2
=================================================
SHA1 Fingerprint=47:BE:AB:C9:22:EA:E8:0E:78:78:34:62:A7:9F:45:C2:54:FD:E6:8B
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 0 (0x0)
    Signature Algorithm: sha256WithRSAEncryption
        Issuer: C=US, ST=Arizona, L=Scottsdale, O=GoDaddy.com, Inc., CN=Go Daddy Root Certificate Authority - G2
        Validity
            Not Before: Sep  1 00:00:00 2009 GMT
            Not After : Dec 31 23:59:59 2037 GMT
        Subject: C=US, ST=Arizona, L=Scottsdale, O=GoDaddy.com, Inc., CN=Go Daddy Root Certificate Authority - G2
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (2048 bit)
                Modulus:
                    00:bf:71:62:08:f1:fa:59:34:f7:1b:c9:18:a3:f7:
                    80:49:58:e9:22:83:13:a6:c5:20:43:01:3b:84:f1:
                    e6:85:49:9f:27:ea:f6:84:1b:4e:a0:b4:db:70:98:
                    c7:32:01:b1:05:3e:07:4e:ee:f4:fa:4f:2f:59:30:
                    22:e7:ab:19:56:6b:e2:80:07:fc:f3:16:75:80:39:
                    51:7b:e5:f9:35:b6:74:4e:a9:8d:82:13:e4:b6:3f:
                    a9:03:83:fa:a2:be:8a:15:6a:7f:de:0b:c3:b6:19:
                    14:05:ca:ea:c3:a8:04:94:3b:46:7c:32:0d:f3:00:
                    66:22:c8:8d:69:6d:36:8c:11:18:b7:d3:b2:1c:60:
                    b4:38:fa:02:8c:ce:d3:dd:46:07:de:0a:3e:eb:5d:
                    7c:c8:7c:fb:b0:2b:53:a4:92:62:69:51:25:05:61:
                    1a:44:81:8c:2c:a9:43:96:23:df:ac:3a:81:9a:0e:
                    29:c5:1c:a9:e9:5d:1e:b6:9e:9e:30:0a:39:ce:f1:
                    88:80:fb:4b:5d:cc:32:ec:85:62:43:25:34:02:56:
                    27:01:91:b4:3b:70:2a:3f:6e:b1:e8:9c:88:01:7d:
                    9f:d4:f9:db:53:6d:60:9d:bf:2c:e7:58:ab:b8:5f:
                    46:fc:ce:c4:1b:03:3c:09:eb:49:31:5c:69:46:b3:
                    e0:47
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Subject Key Identifier: 
                3A:9A:85:07:10:67:28:B6:EF:F6:BD:05:41:6E:20:C1:94:DA:0F:DE
    Signature Algorithm: sha256WithRSAEncryption
         99:db:5d:79:d5:f9:97:59:67:03:61:f1:7e:3b:06:31:75:2d:
         a1:20:8e:4f:65:87:b4:f7:a6:9c:bc:d8:e9:2f:d0:db:5a:ee:
         cf:74:8c:73:b4:38:42:da:05:7b:f8:02:75:b8:fd:a5:b1:d7:
         ae:f6:d7:de:13:cb:53:10:7e:8a:46:d1:97:fa:b7:2e:2b:11:
         ab:90:b0:27:80:f9:e8:9f:5a:e9:37:9f:ab:e4:df:6c:b3:85:
         17:9d:3d:d9:24:4f:79:91:35:d6:5f:04:eb:80:83:ab:9a:02:
         2d:b5:10:f4:d8:90:c7:04:73:40:ed:72:25:a0:a9:9f:ec:9e:
         ab:68:12:99:57:c6:8f:12:3a:09:a4:bd:44:fd:06:15:37:c1:
         9b:e4:32:a3:ed:38:e8:d8:64:f3:2c:7e:14:fc:02:ea:9f:cd:
         ff:07:68:17:db:22:90:38:2d:7a:8d:d1:54:f1:69:e3:5f:33:
         ca:7a:3d:7b:0a:e3:ca:7f:5f:39:e5:e2:75:ba:c5:76:18:33:
         ce:2c:f0:2f:4c:ad:f7:b1:e7:ce:4f:a8:c4:9b:4a:54:06:c5:
         7f:7d:d5:08:0f:e2:1c:fe:7e:17:b8:ac:5e:f6:d4:16:b2:43:
         09:0c:4d:f6:a7:6b:b4:99:84:65:ca:7a:88:e2:e2:44:be:5c:
         f7:ea:1c:f5
-----BEGIN CERTIFICATE-----
MIIDxTCCAq2gAwIBAgIBADANBgkqhkiG9w0BAQsFADCBgzELMAkGA1UEBhMCVVMx
EDAOBgNVBAgTB0FyaXpvbmExEzARBgNVBAcTClNjb3R0c2RhbGUxGjAYBgNVBAoT
EUdvRGFkZHkuY29tLCBJbmMuMTEwLwYDVQQDEyhHbyBEYWRkeSBSb290IENlcnRp
ZmljYXRlIEF1dGhvcml0eSAtIEcyMB4XDTA5MDkwMTAwMDAwMFoXDTM3MTIzMTIz
NTk1OVowgYMxCzAJBgNVBAYTAlVTMRAwDgYDVQQIEwdBcml6b25hMRMwEQYDVQQH
EwpTY290dHNkYWxlMRowGAYDVQQKExFHb0RhZGR5LmNvbSwgSW5jLjExMC8GA1UE
AxMoR28gRGFkZHkgUm9vdCBDZXJ0aWZpY2F0ZSBBdXRob3JpdHkgLSBHMjCCASIw
DQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAL9xYgjx+lk09xvJGKP3gElY6SKD
E6bFIEMBO4Tx5oVJnyfq9oQbTqC023CYxzIBsQU+B07u9PpPL1kwIuerGVZr4oAH
/PMWdYA5UXvl+TW2dE6pjYIT5LY/qQOD+qK+ihVqf94Lw7YZFAXK6sOoBJQ7Rnwy
DfMAZiLIjWltNowRGLfTshxgtDj6AozO091GB94KPutdfMh8+7ArU6SSYmlRJQVh
GkSBjCypQ5Yj36w6gZoOKcUcqeldHraenjAKOc7xiID7S13MMuyFYkMlNAJWJwGR
tDtwKj9useiciAF9n9T521NtYJ2/LOdYq7hfRvzOxBsDPAnrSTFcaUaz4EcCAwEA
AaNCMEAwDwYDVR0TAQH/BAUwAwEB/zAOBgNVHQ8BAf8EBAMCAQYwHQYDVR0OBBYE
FDqahQcQZyi27/a9BUFuIMGU2g/eMA0GCSqGSIb3DQEBCwUAA4IBAQCZ21151fmX
WWcDYfF+OwYxdS2hII5PZYe096acvNjpL9DbWu7PdIxztDhC2gV7+AJ1uP2lsdeu
9tfeE8tTEH6KRtGX+rcuKxGrkLAngPnon1rpN5+r5N9ss4UXnT3ZJE95kTXWXwTr
gIOrmgIttRD02JDHBHNA7XIloKmf7J6raBKZV8aPEjoJpL1E/QYVN8Gb5DKj7Tjo
2GTzLH4U/ALqn83/B2gX2yKQOC16jdFU8WnjXzPKej17CuPKf1855eJ1usV2GDPO
LPAvTK33sefOT6jEm0pUBsV/fdUID+Ic/n4XuKxe9tQWskMJDE32p2u0mYRlynqI
4uJEvlz36hz1
-----END CERTIFICATE-----

Starfield Root Certificate Authority - G2
=================================================
SHA1 Fingerprint=B5:1C:06:7C:EE:2B:0C:3D:F8:55:AB:2D:92:F4:FE:39:D4:E7:0F:0E
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 0 (0x0)
    Signature Algorithm: sha256WithRSAEncryption
        Issuer: C=US, ST=Arizona, L=Scottsdale, O=Starfield Technologies, Inc., CN=Starfield Root Certificate Authority - G2
        Validity
            Not Before: Sep  1 00:00:00 2009 GMT
            Not After : Dec 31 23:59:59 2037 GMT
        Subject: C=US, ST=Arizona, L=Scottsdale, O=Starfield Technologies, Inc., CN=Starfield Root Certificate Authority - G2
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (2048 bit)
                Modulus:
                    00:bd:ed:c1:03:fc:f6:8f:fc:02:b1:6f:5b:9f:48:
                    d9:9d:79:e2:a2:b7:03:61:56:18:c3:47:b6:d7:ca:
                    3d:35:2e:89:43:f7:a1:69:9b:de:8a:1a:fd:13:20:
                    9c:b4:49:77:32:29:56:fd:b9:ec:8c:dd:22:fa:72:
                    dc:27:61:97:ee:f6:5a:84:ec:6e:19:b9:89:2c:dc:
                    84:5b:d5:74:fb:6b:5f:c5:89:a5:10:52:89:46:55:
                    f4:b8:75:1c:e6:7f:e4:54:ae:4b:f8:55:72:57:02:
                    19:f8:17:71:59:eb:1e:28:07:74:c5:9d:48:be:6c:
                    b4:f4:a4:b0:f3:64:37:79:92:c0:ec:46:5e:7f:e1:
                    6d:53:4c:62:af:cd:1f:0b:63:bb:3a:9d:fb:fc:79:
                    00:98:61:74:cf:26:82:40:63:f3:b2:72:6a:19:0d:
                    99:ca:d4:0e:75:cc:37:fb:8b:89:c1:59:f1:62:7f:
                    5f:b3:5f:65:30:f8:a7:b7:4d:76:5a:1e:76:5e:34:
                    c0:e8:96:56:99:8a:b3:f0:7f:a4:cd:bd:dc:32:31:
                    7c:91:cf:e0:5f:11:f8:6b:aa:49:5c:d1:99:94:d1:
                    a2:e3:63:5b:09:76:b5:56:62:e1:4b:74:1d:96:d4:
                    26:d4:08:04:59:d0:98:0e:0e:e6:de:fc:c3:ec:1f:
                    90:f1
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Subject Key Identifier: 
                7C:0C:32:1F:A7:D9:30:7F:C4:7D:68:A3:62:A8:A1:CE:AB:07:5B:27
    Signature Algorithm: sha256WithRSAEncryption
         11:59:fa:25:4f:03:6f:94:99:3b:9a:1f:82:85:39:d4:76:05:
         94:5e:e1:28:93:6d:62:5d:09:c2:a0:a8:d4:b0:75:38:f1:34:
         6a:9d:e4:9f:8a:86:26:51:e6:2c:d1:c6:2d:6e:95:20:4a:92:
         01:ec:b8:8a:67:7b:31:e2:67:2e:8c:95:03:26:2e:43:9d:4a:
         31:f6:0e:b5:0c:bb:b7:e2:37:7f:22:ba:00:a3:0e:7b:52:fb:
         6b:bb:3b:c4:d3:79:51:4e:cd:90:f4:67:07:19:c8:3c:46:7a:
         0d:01:7d:c5:58:e7:6d:e6:85:30:17:9a:24:c4:10:e0:04:f7:
         e0:f2:7f:d4:aa:0a:ff:42:1d:37:ed:94:e5:64:59:12:20:77:
         38:d3:32:3e:38:81:75:96:73:fa:68:8f:b1:cb:ce:1f:c5:ec:
         fa:9c:7e:cf:7e:b1:f1:07:2d:b6:fc:bf:ca:a4:bf:d0:97:05:
         4a:bc:ea:18:28:02:90:bd:54:78:09:21:71:d3:d1:7d:1d:d9:
         16:b0:a9:61:3d:d0:0a:00:22:fc:c7:7b:cb:09:64:45:0b:3b:
         40:81:f7:7d:7c:32:f5:98:ca:58:8e:7d:2a:ee:90:59:73:64:
         f9:36:74:5e:25:a1:f5:66:05:2e:7f:39:15:a9:2a:fb:50:8b:
         8e:85:69:f4
-----BEGIN CERTIFICATE-----
MIID3TCCAsWgAwIBAgIBADANBgkqhkiG9w0BAQsFADCBjzELMAkGA1UEBhMCVVMx
EDAOBgNVBAgTB0FyaXpvbmExEzARBgNVBAcTClNjb3R0c2RhbGUxJTAjBgNVBAoT
HFN0YXJmaWVsZCBUZWNobm9sb2dpZXMsIEluYy4xMjAwBgNVBAMTKVN0YXJmaWVs
ZCBSb290IENlcnRpZmljYXRlIEF1dGhvcml0eSAtIEcyMB4XDTA5MDkwMTAwMDAw
MFoXDTM3MTIzMTIzNTk1OVowgY8xCzAJBgNVBAYTAlVTMRAwDgYDVQQIEwdBcml6
b25hMRMwEQYDVQQHEwpTY290dHNkYWxlMSUwIwYDVQQKExxTdGFyZmllbGQgVGVj
aG5vbG9naWVzLCBJbmMuMTIwMAYDVQQDEylTdGFyZmllbGQgUm9vdCBDZXJ0aWZp
Y2F0ZSBBdXRob3JpdHkgLSBHMjCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoC
ggEBAL3twQP89o/8ArFvW59I2Z154qK3A2FWGMNHttfKPTUuiUP3oWmb3ooa/RMg
nLRJdzIpVv257IzdIvpy3Cdhl+72WoTsbhm5iSzchFvVdPtrX8WJpRBSiUZV9Lh1
HOZ/5FSuS/hVclcCGfgXcVnrHigHdMWdSL5stPSksPNkN3mSwOxGXn/hbVNMYq/N
Hwtjuzqd+/x5AJhhdM8mgkBj87JyahkNmcrUDnXMN/uLicFZ8WJ/X7NfZTD4p7dN
dloedl40wOiWVpmKs/B/pM293DIxfJHP4F8R+GuqSVzRmZTRouNjWwl2tVZi4Ut0
HZbUJtQIBFnQmA4O5t78w+wfkPECAwEAAaNCMEAwDwYDVR0TAQH/BAUwAwEB/zAO
BgNVHQ8BAf8EBAMCAQYwHQYDVR0OBBYEFHwMMh+n2TB/xH1oo2Kooc6rB1snMA0G
CSqGSIb3DQEBCwUAA4IBAQARWfolTwNvlJk7mh+ChTnUdgWUXuEok21iXQnCoKjU
sHU48TRqneSfioYmUeYs0cYtbpUgSpIB7LiKZ3sx4mcujJUDJi5DnUox9g61DLu3
4jd/IroAow57UvtruzvE03lRTs2Q9GcHGcg8RnoNAX3FWOdt5oUwF5okxBDgBPfg
8n/Uqgr/Qh037ZTlZFkSIHc40zI+OIF1lnP6aI+xy84fxez6nH7PfrHxBy22/L/K
pL/QlwVKvOoYKAKQvVR4CSFx09F9HdkWsKlhPdAKACL8x3vLCWRFCztAgfd9fDL1
mMpYjn0q7pBZc2T5NnReJaH1ZgUufzkVqSr7UIuOhWn0
-----END CERTIFICATE-----

Starfield Services Root Certificate Authority - G2
==================================================
SHA1 Fingerprint=92:5A:8F:8D:2C:6D:04:E0:66:5F:59:6A:FF:22:D8:63:E8:25:6F:3F
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 0 (0x0)
    Signature Algorithm: sha256WithRSAEncryption
        Issuer: C=US, ST=Arizona, L=Scottsdale, O=Starfield Technologies, Inc., CN=Starfield Services Root Certificate Authority - G2
        Validity
            Not Before: Sep  1 00:00:00 2009 GMT
            Not After : Dec 31 23:59:59 2037 GMT
        Subject: C=US, ST=Arizona, L=Scottsdale, O=Starfield Technologies, Inc., CN=Starfield Services Root Certificate Authority - G2
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (2048 bit)
                Modulus:
                    00:d5:0c:3a:c4:2a:f9:4e:e2:f5:be:19:97:5f:8e:
                    88:53:b1:1f:3f:cb:cf:9f:20:13:6d:29:3a:c8:0f:
                    7d:3c:f7:6b:76:38:63:d9:36:60:a8:9b:5e:5c:00:
                    80:b2:2f:59:7f:f6:87:f9:25:43:86:e7:69:1b:52:
                    9a:90:e1:71:e3:d8:2d:0d:4e:6f:f6:c8:49:d9:b6:
                    f3:1a:56:ae:2b:b6:74:14:eb:cf:fb:26:e3:1a:ba:
                    1d:96:2e:6a:3b:58:94:89:47:56:ff:25:a0:93:70:
                    53:83:da:84:74:14:c3:67:9e:04:68:3a:df:8e:40:
                    5a:1d:4a:4e:cf:43:91:3b:e7:56:d6:00:70:cb:52:
                    ee:7b:7d:ae:3a:e7:bc:31:f9:45:f6:c2:60:cf:13:
                    59:02:2b:80:cc:34:47:df:b9:de:90:65:6d:02:cf:
                    2c:91:a6:a6:e7:de:85:18:49:7c:66:4e:a3:3a:6d:
                    a9:b5:ee:34:2e:ba:0d:03:b8:33:df:47:eb:b1:6b:
                    8d:25:d9:9b:ce:81:d1:45:46:32:96:70:87:de:02:
                    0e:49:43:85:b6:6c:73:bb:64:ea:61:41:ac:c9:d4:
                    54:df:87:2f:c7:22:b2:26:cc:9f:59:54:68:9f:fc:
                    be:2a:2f:c4:55:1c:75:40:60:17:85:02:55:39:8b:
                    7f:05
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Subject Key Identifier: 
                9C:5F:00:DF:AA:01:D7:30:2B:38:88:A2:B8:6D:4A:9C:F2:11:91:83
    Signature Algorithm: sha256WithRSAEncryption
         4b:36:a6:84:77:69:dd:3b:19:9f:67:23:08:6f:0e:61:c9:fd:
         84:dc:5f:d8:36:81:cd:d8:1b:41:2d:9f:60:dd:c7:1a:68:d9:
         d1:6e:86:e1:88:23:cf:13:de:43:cf:e2:34:b3:04:9d:1f:29:
         d5:bf:f8:5e:c8:d5:c1:bd:ee:92:6f:32:74:f2:91:82:2f:bd:
         82:42:7a:ad:2a:b7:20:7d:4d:bc:7a:55:12:c2:15:ea:bd:f7:
         6a:95:2e:6c:74:9f:cf:1c:b4:f2:c5:01:a3:85:d0:72:3e:ad:
         73:ab:0b:9b:75:0c:6d:45:b7:8e:94:ac:96:37:b5:a0:d0:8f:
         15:47:0e:e3:e8:83:dd:8f:fd:ef:41:01:77:cc:27:a9:62:85:
         33:f2:37:08:ef:71:cf:77:06:de:c8:19:1d:88:40:cf:7d:46:
         1d:ff:1e:c7:e1:ce:ff:23:db:c6:fa:8d:55:4e:a9:02:e7:47:
         11:46:3e:f4:fd:bd:7b:29:26:bb:a9:61:62:37:28:b6:2d:2a:
         f6:10:86:64:c9:70:a7:d2:ad:b7:29:70:79:ea:3c:da:63:25:
         9f:fd:68:b7:30:ec:70:fb:75:8a:b7:6d:60:67:b2:1e:c8:b9:
         e9:d8:a8:6f:02:8b:67:0d:4d:26:57:71:da:20:fc:c1:4a:50:
         8d:b1:28:ba
-----BEGIN CERTIFICATE-----
MIID7zCCAtegAwIBAgIBADANBgkqhkiG9w0BAQsFADCBmDELMAkGA1UEBhMCVVMx
EDAOBgNVBAgTB0FyaXpvbmExEzARBgNVBAcTClNjb3R0c2RhbGUxJTAjBgNVBAoT
HFN0YXJmaWVsZCBUZWNobm9sb2dpZXMsIEluYy4xOzA5BgNVBAMTMlN0YXJmaWVs
ZCBTZXJ2aWNlcyBSb290IENlcnRpZmljYXRlIEF1dGhvcml0eSAtIEcyMB4XDTA5
MDkwMTAwMDAwMFoXDTM3MTIzMTIzNTk1OVowgZgxCzAJBgNVBAYTAlVTMRAwDgYD
VQQIEwdBcml6b25hMRMwEQYDVQQHEwpTY290dHNkYWxlMSUwIwYDVQQKExxTdGFy
ZmllbGQgVGVjaG5vbG9naWVzLCBJbmMuMTswOQYDVQQDEzJTdGFyZmllbGQgU2Vy
dmljZXMgUm9vdCBDZXJ0aWZpY2F0ZSBBdXRob3JpdHkgLSBHMjCCASIwDQYJKoZI
hvcNAQEBBQADggEPADCCAQoCggEBANUMOsQq+U7i9b4Zl1+OiFOxHz/Lz58gE20p
OsgPfTz3a3Y4Y9k2YKibXlwAgLIvWX/2h/klQ4bnaRtSmpDhcePYLQ1Ob/bISdm2
8xpWriu2dBTrz/sm4xq6HZYuajtYlIlHVv8loJNwU4PahHQUw2eeBGg6345AWh1K
Ts9DkTvnVtYAcMtS7nt9rjrnvDH5RfbCYM8TWQIrgMw0R9+53pBlbQLPLJGmpufe
hRhJfGZOozptqbXuNC66DQO4M99H67FrjSXZm86B0UVGMpZwh94CDklDhbZsc7tk
6mFBrMnUVN+HL8cisibMn1lUaJ/8viovxFUcdUBgF4UCVTmLfwUCAwEAAaNCMEAw
DwYDVR0TAQH/BAUwAwEB/zAOBgNVHQ8BAf8EBAMCAQYwHQYDVR0OBBYEFJxfAN+q
AdcwKziIorhtSpzyEZGDMA0GCSqGSIb3DQEBCwUAA4IBAQBLNqaEd2ndOxmfZyMI
bw5hyf2E3F/YNoHN2BtBLZ9g3ccaaNnRbobhiCPPE95Dz+I0swSdHynVv/heyNXB
ve6SbzJ08pGCL72CQnqtKrcgfU28elUSwhXqvfdqlS5sdJ/PHLTyxQGjhdByPq1z
qwubdQxtRbeOlKyWN7Wg0I8VRw7j6IPdj/3vQQF3zCepYoUz8jcI73HPdwbeyBkd
iEDPfUYd/x7H4c7/I9vG+o1VTqkC50cRRj70/b17KSa7qWFiNyi2LSr2EIZkyXCn
0q23KXB56jzaYyWf/Wi3MOxw+3WKt21gZ7IeyLnp2KhvAotnDU0mV3HaIPzBSlCN
sSi6
-----END CERTIFICATE-----

AffirmTrust Commercial
=================================================
SHA1 Fingerprint=F9:B5:B6:32:45:5F:9C:BE:EC:57:5F:80:DC:E9:6E:2C:C7:B2:78:B7
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 8608355977964138876 (0x7777062726a9b17c)
    Signature Algorithm: sha256WithRSAEncryption
        Issuer: C=US, O=AffirmTrust, CN=AffirmTrust Commercial
        Validity
            Not Before: Jan 29 14:06:06 2010 GMT
            Not After : Dec 31 14:06:06 2030 GMT
        Subject: C=US, O=AffirmTrust, CN=AffirmTrust Commercial
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (2048 bit)
                Modulus:
                    00:f6:1b:4f:67:07:2b:a1:15:f5:06:22:cb:1f:01:
                    b2:e3:73:45:06:44:49:2c:bb:49:25:14:d6:ce:c3:
                    b7:ab:2c:4f:c6:41:32:94:57:fa:12:a7:5b:0e:e2:
                    8f:1f:1e:86:19:a7:aa:b5:2d:b9:5f:0d:8a:c2:af:
                    85:35:79:32:2d:bb:1c:62:37:f2:b1:5b:4a:3d:ca:
                    cd:71:5f:e9:42:be:94:e8:c8:de:f9:22:48:64:c6:
                    e5:ab:c6:2b:6d:ad:05:f0:fa:d5:0b:cf:9a:e5:f0:
                    50:a4:8b:3b:47:a5:23:5b:7a:7a:f8:33:3f:b8:ef:
                    99:97:e3:20:c1:d6:28:89:cf:94:fb:b9:45:ed:e3:
                    40:17:11:d4:74:f0:0b:31:e2:2b:26:6a:9b:4c:57:
                    ae:ac:20:3e:ba:45:7a:05:f3:bd:9b:69:15:ae:7d:
                    4e:20:63:c4:35:76:3a:07:02:c9:37:fd:c7:47:ee:
                    e8:f1:76:1d:73:15:f2:97:a4:b5:c8:7a:79:d9:42:
                    aa:2b:7f:5c:fe:ce:26:4f:a3:66:81:35:af:44:ba:
                    54:1e:1c:30:32:65:9d:e6:3c:93:5e:50:4e:7a:e3:
                    3a:d4:6e:cc:1a:fb:f9:d2:37:ae:24:2a:ab:57:03:
                    22:28:0d:49:75:7f:b7:28:da:75:bf:8e:e3:dc:0e:
                    79:31
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Subject Key Identifier: 
                9D:93:C6:53:8B:5E:CA:AF:3F:9F:1E:0F:E5:99:95:BC:24:F6:94:8F
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
    Signature Algorithm: sha256WithRSAEncryption
         58:ac:f4:04:0e:cd:c0:0d:ff:0a:fd:d4:ba:16:5f:29:bd:7b:
         68:99:58:49:d2:b4:1d:37:4d:7f:27:7d:46:06:5d:43:c6:86:
         2e:3e:73:b2:26:7d:4f:93:a9:b6:c4:2a:9a:ab:21:97:14:b1:
         de:8c:d3:ab:89:15:d8:6b:24:d4:f1:16:ae:d8:a4:5c:d4:7f:
         51:8e:ed:18:01:b1:93:63:bd:bc:f8:61:80:9a:9e:b1:ce:42:
         70:e2:a9:7d:06:25:7d:27:a1:fe:6f:ec:b3:1e:24:da:e3:4b:
         55:1a:00:3b:35:b4:3b:d9:d7:5d:30:fd:81:13:89:f2:c2:06:
         2b:ed:67:c4:8e:c9:43:b2:5c:6b:15:89:02:bc:62:fc:4e:f2:
         b5:33:aa:b2:6f:d3:0a:a2:50:e3:f6:3b:e8:2e:44:c2:db:66:
         38:a9:33:56:48:f1:6d:1b:33:8d:0d:8c:3f:60:37:9d:d3:ca:
         6d:7e:34:7e:0d:9f:72:76:8b:1b:9f:72:fd:52:35:41:45:02:
         96:2f:1c:b2:9a:73:49:21:b1:49:47:45:47:b4:ef:6a:34:11:
         c9:4d:9a:cc:59:b7:d6:02:9e:5a:4e:65:b5:94:ae:1b:df:29:
         b0:16:f1:bf:00:9e:07:3a:17:64:b5:04:b5:23:21:99:0a:95:
         3b:97:7c:ef
-----BEGIN CERTIFICATE-----
MIIDTDCCAjSgAwIBAgIId3cGJyapsXwwDQYJKoZIhvcNAQELBQAwRDELMAkGA1UE
BhMCVVMxFDASBgNVBAoMC0FmZmlybVRydXN0MR8wHQYDVQQDDBZBZmZpcm1UcnVz
dCBDb21tZXJjaWFsMB4XDTEwMDEyOTE0MDYwNloXDTMwMTIzMTE0MDYwNlowRDEL
MAkGA1UEBhMCVVMxFDASBgNVBAoMC0FmZmlybVRydXN0MR8wHQYDVQQDDBZBZmZp
cm1UcnVzdCBDb21tZXJjaWFsMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKC
AQEA9htPZwcroRX1BiLLHwGy43NFBkRJLLtJJRTWzsO3qyxPxkEylFf6EqdbDuKP
Hx6GGaeqtS25Xw2Kwq+FNXkyLbscYjfysVtKPcrNcV/pQr6U6Mje+SJIZMblq8Yr
ba0F8PrVC8+a5fBQpIs7R6UjW3p6+DM/uO+Zl+MgwdYoic+U+7lF7eNAFxHUdPAL
MeIrJmqbTFeurCA+ukV6BfO9m2kVrn1OIGPENXY6BwLJN/3HR+7o8XYdcxXyl6S1
yHp52UKqK39c/s4mT6NmgTWvRLpUHhwwMmWd5jyTXlBOeuM61G7MGvv50jeuJCqr
VwMiKA1JdX+3KNp1v47j3A55MQIDAQABo0IwQDAdBgNVHQ4EFgQUnZPGU4teyq8/
nx4P5ZmVvCT2lI8wDwYDVR0TAQH/BAUwAwEB/zAOBgNVHQ8BAf8EBAMCAQYwDQYJ
KoZIhvcNAQELBQADggEBAFis9AQOzcAN/wr91LoWXym9e2iZWEnStB03TX8nfUYG
XUPGhi4+c7ImfU+TqbbEKpqrIZcUsd6M06uJFdhrJNTxFq7YpFzUf1GO7RgBsZNj
vbz4YYCanrHOQnDiqX0GJX0nof5v7LMeJNrjS1UaADs1tDvZ110w/YETifLCBivt
Z8SOyUOyXGsViQK8YvxO8rUzqrJv0wqiUOP2O+guRMLbZjipM1ZI8W0bM40NjD9g
N53Tym1+NH4Nn3J2ixufcv1SNUFFApYvHLKac0khsUlHRUe072o0EclNmsxZt9YC
nlpOZbWUrhvfKbAW8b8Angc6F2S1BLUjIZkKlTuXfO8=
-----END CERTIFICATE-----

AffirmTrust Networking
=================================================
SHA1 Fingerprint=29:36:21:02:8B:20:ED:02:F5:66:C5:32:D1:D6:ED:90:9F:45:00:2F
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 8957382827206547757 (0x7c4f04391cd4992d)
    Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=AffirmTrust, CN=AffirmTrust Networking
        Validity
            Not Before: Jan 29 14:08:24 2010 GMT
            Not After : Dec 31 14:08:24 2030 GMT
        Subject: C=US, O=AffirmTrust, CN=AffirmTrust Networking
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (2048 bit)
                Modulus:
                    00:b4:84:cc:33:17:2e:6b:94:6c:6b:61:52:a0:eb:
                    a3:cf:79:94:4c:e5:94:80:99:cb:55:64:44:65:8f:
                    67:64:e2:06:e3:5c:37:49:f6:2f:9b:84:84:1e:2d:
                    f2:60:9d:30:4e:cc:84:85:e2:2c:cf:1e:9e:fe:36:
                    ab:33:77:35:44:d8:35:96:1a:3d:36:e8:7a:0e:d8:
                    d5:47:a1:6a:69:8b:d9:fc:bb:3a:ae:79:5a:d5:f4:
                    d6:71:bb:9a:90:23:6b:9a:b7:88:74:87:0c:1e:5f:
                    b9:9e:2d:fa:ab:53:2b:dc:bb:76:3e:93:4c:08:08:
                    8c:1e:a2:23:1c:d4:6a:ad:22:ba:99:01:2e:6d:65:
                    cb:be:24:66:55:24:4b:40:44:b1:1b:d7:e1:c2:85:
                    c0:de:10:3f:3d:ed:b8:fc:f1:f1:23:53:dc:bf:65:
                    97:6f:d9:f9:40:71:8d:7d:bd:95:d4:ce:be:a0:5e:
                    27:23:de:fd:a6:d0:26:0e:00:29:eb:3c:46:f0:3d:
                    60:bf:3f:50:d2:dc:26:41:51:9e:14:37:42:04:a3:
                    70:57:a8:1b:87:ed:2d:fa:7b:ee:8c:0a:e3:a9:66:
                    89:19:cb:41:f9:dd:44:36:61:cf:e2:77:46:c8:7d:
                    f6:f4:92:81:36:fd:db:34:f1:72:7e:f3:0c:16:bd:
                    b4:15
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Subject Key Identifier: 
                07:1F:D2:E7:9C:DA:C2:6E:A2:40:B4:B0:7A:50:10:50:74:C4:C8:BD
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
    Signature Algorithm: sha1WithRSAEncryption
         89:57:b2:16:7a:a8:c2:fd:d6:d9:9b:9b:34:c2:9c:b4:32:14:
         4d:a7:a4:df:ec:be:a7:be:f8:43:db:91:37:ce:b4:32:2e:50:
         55:1a:35:4e:76:43:71:20:ef:93:77:4e:15:70:2e:87:c3:c1:
         1d:6d:dc:cb:b5:27:d4:2c:56:d1:52:53:3a:44:d2:73:c8:c4:
         1b:05:65:5a:62:92:9c:ee:41:8d:31:db:e7:34:ea:59:21:d5:
         01:7a:d7:64:b8:64:39:cd:c9:ed:af:ed:4b:03:48:a7:a0:99:
         01:80:dc:65:a3:36:ae:65:59:48:4f:82:4b:c8:65:f1:57:1d:
         e5:59:2e:0a:3f:6c:d8:d1:f5:e5:09:b4:6c:54:00:0a:e0:15:
         4d:87:75:6d:b7:58:96:5a:dd:6d:d2:00:a0:f4:9b:48:be:c3:
         37:a4:ba:36:e0:7c:87:85:97:1a:15:a2:de:2e:a2:5b:bd:af:
         18:f9:90:50:cd:70:59:f8:27:67:47:cb:c7:a0:07:3a:7d:d1:
         2c:5d:6c:19:3a:66:b5:7d:fd:91:6f:82:b1:be:08:93:db:14:
         47:f1:a2:37:c7:45:9e:3c:c7:77:af:64:a8:93:df:f6:69:83:
         82:60:f2:49:42:34:ed:5a:00:54:85:1c:16:36:92:0c:5c:fa:
         a6:ad:bf:db
-----BEGIN CERTIFICATE-----
MIIDTDCCAjSgAwIBAgIIfE8EORzUmS0wDQYJKoZIhvcNAQEFBQAwRDELMAkGA1UE
BhMCVVMxFDASBgNVBAoMC0FmZmlybVRydXN0MR8wHQYDVQQDDBZBZmZpcm1UcnVz
dCBOZXR3b3JraW5nMB4XDTEwMDEyOTE0MDgyNFoXDTMwMTIzMTE0MDgyNFowRDEL
MAkGA1UEBhMCVVMxFDASBgNVBAoMC0FmZmlybVRydXN0MR8wHQYDVQQDDBZBZmZp
cm1UcnVzdCBOZXR3b3JraW5nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKC
AQEAtITMMxcua5Rsa2FSoOujz3mUTOWUgJnLVWREZY9nZOIG41w3SfYvm4SEHi3y
YJ0wTsyEheIszx6e/jarM3c1RNg1lho9Nuh6DtjVR6FqaYvZ/Ls6rnla1fTWcbua
kCNrmreIdIcMHl+5ni36q1Mr3Lt2PpNMCAiMHqIjHNRqrSK6mQEubWXLviRmVSRL
QESxG9fhwoXA3hA/Pe24/PHxI1Pcv2WXb9n5QHGNfb2V1M6+oF4nI979ptAmDgAp
6zxG8D1gvz9Q0twmQVGeFDdCBKNwV6gbh+0t+nvujArjqWaJGctB+d1ENmHP4ndG
yH329JKBNv3bNPFyfvMMFr20FQIDAQABo0IwQDAdBgNVHQ4EFgQUBx/S55zawm6i
QLSwelAQUHTEyL0wDwYDVR0TAQH/BAUwAwEB/zAOBgNVHQ8BAf8EBAMCAQYwDQYJ
KoZIhvcNAQEFBQADggEBAIlXshZ6qML91tmbmzTCnLQyFE2npN/svqe++EPbkTfO
tDIuUFUaNU52Q3Eg75N3ThVwLofDwR1t3Mu1J9QsVtFSUzpE0nPIxBsFZVpikpzu
QY0x2+c06lkh1QF612S4ZDnNye2v7UsDSKegmQGA3GWjNq5lWUhPgkvIZfFXHeVZ
Lgo/bNjR9eUJtGxUAArgFU2HdW23WJZa3W3SAKD0m0i+wzekujbgfIeFlxoVot4u
olu9rxj5kFDNcFn4J2dHy8egBzp90SxdbBk6ZrV9/ZFvgrG+CJPbFEfxojfHRZ48
x3evZKiT3/Zpg4Jg8klCNO1aAFSFHBY2kgxc+qatv9s=
-----END CERTIFICATE-----

AffirmTrust Premium
=================================================
SHA1 Fingerprint=D8:A6:33:2C:E0:03:6F:B1:85:F6:63:4F:7D:6A:06:65:26:32:28:27
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 7893706540734352110 (0x6d8c1446b1a60aee)
    Signature Algorithm: sha384WithRSAEncryption
        Issuer: C=US, O=AffirmTrust, CN=AffirmTrust Premium
        Validity
            Not Before: Jan 29 14:10:36 2010 GMT
            Not After : Dec 31 14:10:36 2040 GMT
        Subject: C=US, O=AffirmTrust, CN=AffirmTrust Premium
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (4096 bit)
                Modulus:
                    00:c4:12:df:a9:5f:fe:41:dd:dd:f5:9f:8a:e3:f6:
                    ac:e1:3c:78:9a:bc:d8:f0:7f:7a:a0:33:2a:dc:8d:
                    20:5b:ae:2d:6f:e7:93:d9:36:70:6a:68:cf:8e:51:
                    a3:85:5b:67:04:a0:10:24:6f:5d:28:82:c1:97:57:
                    d8:48:29:13:b6:e1:be:91:4d:df:85:0c:53:18:9a:
                    1e:24:a2:4f:8f:f0:a2:85:0b:cb:f4:29:7f:d2:a4:
                    58:ee:26:4d:c9:aa:a8:7b:9a:d9:fa:38:de:44:57:
                    15:e5:f8:8c:c8:d9:48:e2:0d:16:27:1d:1e:c8:83:
                    85:25:b7:ba:aa:55:41:cc:03:22:4b:2d:91:8d:8b:
                    e6:89:af:66:c7:e9:ff:2b:e9:3c:ac:da:d2:b3:c3:
                    e1:68:9c:89:f8:7a:00:56:de:f4:55:95:6c:fb:ba:
                    64:dd:62:8b:df:0b:77:32:eb:62:cc:26:9a:9b:bb:
                    aa:62:83:4c:b4:06:7a:30:c8:29:bf:ed:06:4d:97:
                    b9:1c:c4:31:2b:d5:5f:bc:53:12:17:9c:99:57:29:
                    66:77:61:21:31:07:2e:25:49:9d:18:f2:ee:f3:2b:
                    71:8c:b5:ba:39:07:49:77:fc:ef:2e:92:90:05:8d:
                    2d:2f:77:7b:ef:43:bf:35:bb:9a:d8:f9:73:a7:2c:
                    f2:d0:57:ee:28:4e:26:5f:8f:90:68:09:2f:b8:f8:
                    dc:06:e9:2e:9a:3e:51:a7:d1:22:c4:0a:a7:38:48:
                    6c:b3:f9:ff:7d:ab:86:57:e3:ba:d6:85:78:77:ba:
                    43:ea:48:7f:f6:d8:be:23:6d:1e:bf:d1:36:6c:58:
                    5c:f1:ee:a4:19:54:1a:f5:03:d2:76:e6:e1:8c:bd:
                    3c:b3:d3:48:4b:e2:c8:f8:7f:92:a8:76:46:9c:42:
                    65:3e:a4:1e:c1:07:03:5a:46:2d:b8:97:f3:b7:d5:
                    b2:55:21:ef:ba:dc:4c:00:97:fb:14:95:27:33:bf:
                    e8:43:47:46:d2:08:99:16:60:3b:9a:7e:d2:e6:ed:
                    38:ea:ec:01:1e:3c:48:56:49:09:c7:4c:37:00:9e:
                    88:0e:c0:73:e1:6f:66:e9:72:47:30:3e:10:e5:0b:
                    03:c9:9a:42:00:6c:c5:94:7e:61:c4:8a:df:7f:82:
                    1a:0b:59:c4:59:32:77:b3:bc:60:69:56:39:fd:b4:
                    06:7b:2c:d6:64:36:d9:bd:48:ed:84:1f:7e:a5:22:
                    8f:2a:b8:42:f4:82:b7:d4:53:90:78:4e:2d:1a:fd:
                    81:6f:44:d7:3b:01:74:96:42:e0:00:e2:2e:6b:ea:
                    c5:ee:72:ac:bb:bf:fe:ea:aa:a8:f8:dc:f6:b2:79:
                    8a:b6:67
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Subject Key Identifier: 
                9D:C0:67:A6:0C:22:D9:26:F5:45:AB:A6:65:52:11:27:D8:45:AC:63
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
    Signature Algorithm: sha384WithRSAEncryption
         b3:57:4d:10:62:4e:3a:e4:ac:ea:b8:1c:af:32:23:c8:b3:49:
         5a:51:9c:76:28:8d:79:aa:57:46:17:d5:f5:52:f6:b7:44:e8:
         08:44:bf:18:84:d2:0b:80:cd:c5:12:fd:00:55:05:61:87:41:
         dc:b5:24:9e:3c:c4:d8:c8:fb:70:9e:2f:78:96:83:20:36:de:
         7c:0f:69:13:88:a5:75:36:98:08:a6:c6:df:ac:ce:e3:58:d6:
         b7:3e:de:ba:f3:eb:34:40:d8:a2:81:f5:78:3f:2f:d5:a5:fc:
         d9:a2:d4:5e:04:0e:17:ad:fe:41:f0:e5:b2:72:fa:44:82:33:
         42:e8:2d:58:f7:56:8c:62:3f:ba:42:b0:9c:0c:5c:7e:2e:65:
         26:5c:53:4f:00:b2:78:7e:a1:0d:99:2d:8d:b8:1d:8e:a2:c4:
         b0:fd:60:d0:30:a4:8e:c8:04:62:a9:c4:ed:35:de:7a:97:ed:
         0e:38:5e:92:2f:93:70:a5:a9:9c:6f:a7:7d:13:1d:7e:c6:08:
         48:b1:5e:67:eb:51:08:25:e9:e6:25:6b:52:29:91:9c:d2:39:
         73:08:57:de:99:06:b4:5b:9d:10:06:e1:c2:00:a8:b8:1c:4a:
         02:0a:14:d0:c1:41:ca:fb:8c:35:21:7d:82:38:f2:a9:54:91:
         19:35:93:94:6d:6a:3a:c5:b2:d0:bb:89:86:93:e8:9b:c9:0f:
         3a:a7:7a:b8:a1:f0:78:46:fa:fc:37:2f:e5:8a:84:f3:df:fe:
         04:d9:a1:68:a0:2f:24:e2:09:95:06:d5:95:ca:e1:24:96:eb:
         7c:f6:93:05:bb:ed:73:e9:2d:d1:75:39:d7:e7:24:db:d8:4e:
         5f:43:8f:9e:d0:14:39:bf:55:70:48:99:57:31:b4:9c:ee:4a:
         98:03:96:30:1f:60:06:ee:1b:23:fe:81:60:23:1a:47:62:85:
         a5:cc:19:34:80:6f:b3:ac:1a:e3:9f:f0:7b:48:ad:d5:01:d9:
         67:b6:a9:72:93:ea:2d:66:b5:b2:b8:e4:3d:3c:b2:ef:4c:8c:
         ea:eb:07:bf:ab:35:9a:55:86:bc:18:a6:b5:a8:5e:b4:83:6c:
         6b:69:40:d3:9f:dc:f1:c3:69:6b:b9:e1:6d:09:f4:f1:aa:50:
         76:0a:7a:7d:7a:17:a1:55:96:42:99:31:09:dd:60:11:8d:05:
         30:7e:e6:8e:46:d1:9d:14:da:c7:17:e4:05:96:8c:c4:24:b5:
         1b:cf:14:07:b2:40:f8:a3:9e:41:86:bc:04:d0:6b:96:c8:2a:
         80:34:fd:bf:ef:06:a3:dd:58:c5:85:3d:3e:8f:fe:9e:29:e0:
         b6:b8:09:68:19:1c:18:43
-----BEGIN CERTIFICATE-----
MIIFRjCCAy6gAwIBAgIIbYwURrGmCu4wDQYJKoZIhvcNAQEMBQAwQTELMAkGA1UE
BhMCVVMxFDASBgNVBAoMC0FmZmlybVRydXN0MRwwGgYDVQQDDBNBZmZpcm1UcnVz
dCBQcmVtaXVtMB4XDTEwMDEyOTE0MTAzNloXDTQwMTIzMTE0MTAzNlowQTELMAkG
A1UEBhMCVVMxFDASBgNVBAoMC0FmZmlybVRydXN0MRwwGgYDVQQDDBNBZmZpcm1U
cnVzdCBQcmVtaXVtMIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAxBLf
qV/+Qd3d9Z+K4/as4Tx4mrzY8H96oDMq3I0gW64tb+eT2TZwamjPjlGjhVtnBKAQ
JG9dKILBl1fYSCkTtuG+kU3fhQxTGJoeJKJPj/CihQvL9Cl/0qRY7iZNyaqoe5rZ
+jjeRFcV5fiMyNlI4g0WJx0eyIOFJbe6qlVBzAMiSy2RjYvmia9mx+n/K+k8rNrS
s8PhaJyJ+HoAVt70VZVs+7pk3WKL3wt3MutizCaam7uqYoNMtAZ6MMgpv+0GTZe5
HMQxK9VfvFMSF5yZVylmd2EhMQcuJUmdGPLu8ytxjLW6OQdJd/zvLpKQBY0tL3d7
70O/Nbua2Plzpyzy0FfuKE4mX4+QaAkvuPjcBukumj5Rp9EixAqnOEhss/n/fauG
V+O61oV4d7pD6kh/9ti+I20ev9E2bFhc8e6kGVQa9QPSdubhjL08s9NIS+LI+H+S
qHZGnEJlPqQewQcDWkYtuJfzt9WyVSHvutxMAJf7FJUnM7/oQ0dG0giZFmA7mn7S
5u046uwBHjxIVkkJx0w3AJ6IDsBz4W9m6XJHMD4Q5QsDyZpCAGzFlH5hxIrff4Ia
C1nEWTJ3s7xgaVY5/bQGeyzWZDbZvUjthB9+pSKPKrhC9IK31FOQeE4tGv2Bb0TX
OwF0lkLgAOIua+rF7nKsu7/+6qqo+Nz2snmKtmcCAwEAAaNCMEAwHQYDVR0OBBYE
FJ3AZ6YMItkm9UWrpmVSESfYRaxjMA8GA1UdEwEB/wQFMAMBAf8wDgYDVR0PAQH/
BAQDAgEGMA0GCSqGSIb3DQEBDAUAA4ICAQCzV00QYk465KzquByvMiPIs0laUZx2
KI15qldGF9X1Uva3ROgIRL8YhNILgM3FEv0AVQVhh0HctSSePMTYyPtwni94loMg
Nt58D2kTiKV1NpgIpsbfrM7jWNa3Pt668+s0QNiigfV4Py/VpfzZotReBA4Xrf5B
8OWycvpEgjNC6C1Y91aMYj+6QrCcDFx+LmUmXFNPALJ4fqENmS2NuB2OosSw/WDQ
MKSOyARiqcTtNd56l+0OOF6SL5Nwpamcb6d9Ex1+xghIsV5n61EIJenmJWtSKZGc
0jlzCFfemQa0W50QBuHCAKi4HEoCChTQwUHK+4w1IX2COPKpVJEZNZOUbWo6xbLQ
u4mGk+ibyQ86p3q4ofB4Rvr8Ny/lioTz3/4E2aFooC8k4gmVBtWVyuEklut89pMF
u+1z6S3RdTnX5yTb2E5fQ4+e0BQ5v1VwSJlXMbSc7kqYA5YwH2AG7hsj/oFgIxpH
YoWlzBk0gG+zrBrjn/B7SK3VAdlntqlyk+otZrWyuOQ9PLLvTIzq6we/qzWaVYa8
GKa1qF60g2xraUDTn9zxw2lrueFtCfTxqlB2Cnp9ehehVZZCmTEJ3WARjQUwfuaO
RtGdFNrHF+QFlozEJLUbzxQHskD4o55BhrwE0GuWyCqANP2/7waj3VjFhT0+j/6e
KeC2uAloGRwYQw==
-----END CERTIFICATE-----

AffirmTrust Premium ECC
=================================================
SHA1 Fingerprint=B8:23:6B:00:2F:1D:16:86:53:01:55:6C:11:A4:37:CA:EB:FF:C3:BB
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 8401224907861490260 (0x7497258ac73f7a54)
    Signature Algorithm: ecdsa-with-SHA384
        Issuer: C=US, O=AffirmTrust, CN=AffirmTrust Premium ECC
        Validity
            Not Before: Jan 29 14:20:24 2010 GMT
            Not After : Dec 31 14:20:24 2040 GMT
        Subject: C=US, O=AffirmTrust, CN=AffirmTrust Premium ECC
        Subject Public Key Info:
            Public Key Algorithm: id-ecPublicKey
                Public-Key: (384 bit)
                pub: 
                    04:0d:30:5e:1b:15:9d:03:d0:a1:79:35:b7:3a:3c:
                    92:7a:ca:15:1c:cd:62:f3:9c:26:5c:07:3d:e5:54:
                    fa:a3:d6:cc:12:ea:f4:14:5f:e8:8e:19:ab:2f:2e:
                    48:e6:ac:18:43:78:ac:d0:37:c3:bd:b2:cd:2c:e6:
                    47:e2:1a:e6:63:b8:3d:2e:2f:78:c4:4f:db:f4:0f:
                    a4:68:4c:55:72:6b:95:1d:4e:18:42:95:78:cc:37:
                    3c:91:e2:9b:65:2b:29
                ASN1 OID: secp384r1
        X509v3 extensions:
            X509v3 Subject Key Identifier: 
                9A:AF:29:7A:C0:11:35:35:26:51:30:00:C3:6A:FE:40:D5:AE:D6:3C
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
    Signature Algorithm: ecdsa-with-SHA384
         30:64:02:30:17:09:f3:87:88:50:5a:af:c8:c0:42:bf:47:5f:
         f5:6c:6a:86:e0:c4:27:74:e4:38:53:d7:05:7f:1b:34:e3:c6:
         2f:b3:ca:09:3c:37:9d:d7:e7:b8:46:f1:fd:a1:e2:71:02:30:
         42:59:87:43:d4:51:df:ba:d3:09:32:5a:ce:88:7e:57:3d:9c:
         5f:42:6b:f5:07:2d:b5:f0:82:93:f9:59:6f:ae:64:fa:58:e5:
         8b:1e:e3:63:be:b5:81:cd:6f:02:8c:79
-----BEGIN CERTIFICATE-----
MIIB/jCCAYWgAwIBAgIIdJclisc/elQwCgYIKoZIzj0EAwMwRTELMAkGA1UEBhMC
VVMxFDASBgNVBAoMC0FmZmlybVRydXN0MSAwHgYDVQQDDBdBZmZpcm1UcnVzdCBQ
cmVtaXVtIEVDQzAeFw0xMDAxMjkxNDIwMjRaFw00MDEyMzExNDIwMjRaMEUxCzAJ
BgNVBAYTAlVTMRQwEgYDVQQKDAtBZmZpcm1UcnVzdDEgMB4GA1UEAwwXQWZmaXJt
VHJ1c3QgUHJlbWl1bSBFQ0MwdjAQBgcqhkjOPQIBBgUrgQQAIgNiAAQNMF4bFZ0D
0KF5Nbc6PJJ6yhUczWLznCZcBz3lVPqj1swS6vQUX+iOGasvLkjmrBhDeKzQN8O9
ss0s5kfiGuZjuD0uL3jET9v0D6RoTFVya5UdThhClXjMNzyR4ptlKymjQjBAMB0G
A1UdDgQWBBSaryl6wBE1NSZRMADDav5A1a7WPDAPBgNVHRMBAf8EBTADAQH/MA4G
A1UdDwEB/wQEAwIBBjAKBggqhkjOPQQDAwNnADBkAjAXCfOHiFBar8jAQr9HX/Vs
aobgxCd05DhT1wV/GzTjxi+zygk8N53X57hG8f2h4nECMEJZh0PUUd+60wkyWs6I
flc9nF9Ca/UHLbXwgpP5WW+uZPpY5Yse42O+tYHNbwKMeQ==
-----END CERTIFICATE-----

Certum Trusted Network CA
================================================
SHA1 Fingerprint=07:E0:32:E0:20:B7:2C:3F:19:2F:06:28:A2:59:3A:19:A7:0F:06:9E
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 279744 (0x444c0)
    Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=PL, O=Unizeto Technologies S.A., OU=Certum Certification Authority, CN=Certum Trusted Network CA
        Validity
            Not Before: Oct 22 12:07:37 2008 GMT
            Not After : Dec 31 12:07:37 2029 GMT
        Subject: C=PL, O=Unizeto Technologies S.A., OU=Certum Certification Authority, CN=Certum Trusted Network CA
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (2048 bit)
                Modulus:
                    00:e3:fb:7d:a3:72:ba:c2:f0:c9:14:87:f5:6b:01:
                    4e:e1:6e:40:07:ba:6d:27:5d:7f:f7:5b:2d:b3:5a:
                    c7:51:5f:ab:a4:32:a6:61:87:b6:6e:0f:86:d2:30:
                    02:97:f8:d7:69:57:a1:18:39:5d:6a:64:79:c6:01:
                    59:ac:3c:31:4a:38:7c:d2:04:d2:4b:28:e8:20:5f:
                    3b:07:a2:cc:4d:73:db:f3:ae:4f:c7:56:d5:5a:a7:
                    96:89:fa:f3:ab:68:d4:23:86:59:27:cf:09:27:bc:
                    ac:6e:72:83:1c:30:72:df:e0:a2:e9:d2:e1:74:75:
                    19:bd:2a:9e:7b:15:54:04:1b:d7:43:39:ad:55:28:
                    c5:e2:1a:bb:f4:c0:e4:ae:38:49:33:cc:76:85:9f:
                    39:45:d2:a4:9e:f2:12:8c:51:f8:7c:e4:2d:7f:f5:
                    ac:5f:eb:16:9f:b1:2d:d1:ba:cc:91:42:77:4c:25:
                    c9:90:38:6f:db:f0:cc:fb:8e:1e:97:59:3e:d5:60:
                    4e:e6:05:28:ed:49:79:13:4b:ba:48:db:2f:f9:72:
                    d3:39:ca:fe:1f:d8:34:72:f5:b4:40:cf:31:01:c3:
                    ec:de:11:2d:17:5d:1f:b8:50:d1:5e:19:a7:69:de:
                    07:33:28:ca:50:95:f9:a7:54:cb:54:86:50:45:a9:
                    f9:49
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Subject Key Identifier: 
                08:76:CD:CB:07:FF:24:F6:C5:CD:ED:BB:90:BC:E2:84:37:46:75:F7
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
    Signature Algorithm: sha1WithRSAEncryption
         a6:a8:ad:22:ce:01:3d:a6:a3:ff:62:d0:48:9d:8b:5e:72:b0:
         78:44:e3:dc:1c:af:09:fd:23:48:fa:bd:2a:c4:b9:55:04:b5:
         10:a3:8d:27:de:0b:82:63:d0:ee:de:0c:37:79:41:5b:22:b2:
         b0:9a:41:5c:a6:70:e0:d4:d0:77:cb:23:d3:00:e0:6c:56:2f:
         e1:69:0d:0d:d9:aa:bf:21:81:50:d9:06:a5:a8:ff:95:37:d0:
         aa:fe:e2:b3:f5:99:2d:45:84:8a:e5:42:09:d7:74:02:2f:f7:
         89:d8:99:e9:bc:27:d4:47:8d:ba:0d:46:1c:77:cf:14:a4:1c:
         b9:a4:31:c4:9c:28:74:03:34:ff:33:19:26:a5:e9:0d:74:b7:
         3e:97:c6:76:e8:27:96:a3:66:dd:e1:ae:f2:41:5b:ca:98:56:
         83:73:70:e4:86:1a:d2:31:41:ba:2f:be:2d:13:5a:76:6f:4e:
         e8:4e:81:0e:3f:5b:03:22:a0:12:be:66:58:11:4a:cb:03:c4:
         b4:2a:2a:2d:96:17:e0:39:54:bc:48:d3:76:27:9d:9a:2d:06:
         a6:c9:ec:39:d2:ab:db:9f:9a:0b:27:02:35:29:b1:40:95:e7:
         f9:e8:9c:55:88:19:46:d6:b7:34:f5:7e:ce:39:9a:d9:38:f1:
         51:f7:4f:2c
-----BEGIN CERTIFICATE-----
MIIDuzCCAqOgAwIBAgIDBETAMA0GCSqGSIb3DQEBBQUAMH4xCzAJBgNVBAYTAlBM
MSIwIAYDVQQKExlVbml6ZXRvIFRlY2hub2xvZ2llcyBTLkEuMScwJQYDVQQLEx5D
ZXJ0dW0gQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkxIjAgBgNVBAMTGUNlcnR1bSBU
cnVzdGVkIE5ldHdvcmsgQ0EwHhcNMDgxMDIyMTIwNzM3WhcNMjkxMjMxMTIwNzM3
WjB+MQswCQYDVQQGEwJQTDEiMCAGA1UEChMZVW5pemV0byBUZWNobm9sb2dpZXMg
Uy5BLjEnMCUGA1UECxMeQ2VydHVtIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MSIw
IAYDVQQDExlDZXJ0dW0gVHJ1c3RlZCBOZXR3b3JrIENBMIIBIjANBgkqhkiG9w0B
AQEFAAOCAQ8AMIIBCgKCAQEA4/t9o3K6wvDJFIf1awFO4W5AB7ptJ11/91sts1rH
UV+rpDKmYYe2bg+G0jACl/jXaVehGDldamR5xgFZrDwxSjh80gTSSyjoIF87B6LM
TXPb865Px1bVWqeWifrzq2jUI4ZZJ88JJ7ysbnKDHDBy3+Ci6dLhdHUZvSqeexVU
BBvXQzmtVSjF4hq79MDkrjhJM8x2hZ85RdKknvISjFH4fOQtf/WsX+sWn7Et0brM
kUJ3TCXJkDhv2/DM+44el1k+1WBO5gUo7Ul5E0u6SNsv+XLTOcr+H9g0cvW0QM8x
AcPs3hEtF10fuFDRXhmnad4HMyjKUJX5p1TLVIZQRan5SQIDAQABo0IwQDAPBgNV
HRMBAf8EBTADAQH/MB0GA1UdDgQWBBQIds3LB/8k9sXN7buQvOKEN0Z19zAOBgNV
HQ8BAf8EBAMCAQYwDQYJKoZIhvcNAQEFBQADggEBAKaorSLOAT2mo/9i0Eidi15y
sHhE49wcrwn9I0j6vSrEuVUEtRCjjSfeC4Jj0O7eDDd5QVsisrCaQVymcODU0HfL
I9MA4GxWL+FpDQ3Zqr8hgVDZBqWo/5U30Kr+4rP1mS1FhIrlQgnXdAIv94nYmem8
J9RHjboNRhx3zxSkHLmkMcScKHQDNP8zGSal6Q10tz6XxnboJ5ajZt3hrvJBW8qY
VoNzcOSGGtIxQbovvi0TWnZvTuhOgQ4/WwMioBK+ZlgRSssDxLQqKi2WF+A5VLxI
03YnnZotBqbJ7DnSq9ufmgsnAjUpsUCV5/nonFWIGUbWtzT1fs45mtk48VH3Tyw=
-----END CERTIFICATE-----

TWCA Root Certification Authority
================================================
SHA1 Fingerprint=CF:9E:87:6D:D3:EB:FC:42:26:97:A3:B5:A3:7A:A0:76:A9:06:23:48
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 1 (0x1)
    Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=TW, O=TAIWAN-CA, OU=Root CA, CN=TWCA Root Certification Authority
        Validity
            Not Before: Aug 28 07:24:33 2008 GMT
            Not After : Dec 31 15:59:59 2030 GMT
        Subject: C=TW, O=TAIWAN-CA, OU=Root CA, CN=TWCA Root Certification Authority
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (2048 bit)
                Modulus:
                    00:b0:7e:72:b8:a4:03:94:e6:a7:de:09:38:91:4a:
                    11:40:87:a7:7c:59:64:14:7b:b5:11:10:dd:fe:bf:
                    d5:c0:bb:56:e2:85:25:f4:35:72:0f:f8:53:d0:41:
                    e1:44:01:c2:b4:1c:c3:31:42:16:47:85:33:22:76:
                    b2:0a:6f:0f:e5:25:50:4f:85:86:be:bf:98:2e:10:
                    67:1e:be:11:05:86:05:90:c4:59:d0:7c:78:10:b0:
                    80:5c:b7:e1:c7:2b:75:cb:7c:9f:ae:b5:d1:9d:23:
                    37:63:a7:dc:42:a2:2d:92:04:1b:50:c1:7b:b8:3e:
                    1b:c9:56:04:8b:2f:52:9b:ad:a9:56:e9:c1:ff:ad:
                    a9:58:87:30:b6:81:f7:97:45:fc:19:57:3b:2b:6f:
                    e4:47:f4:99:45:fe:1d:f1:f8:97:a3:88:1d:37:1c:
                    5c:8f:e0:76:25:9a:50:f8:a0:54:ff:44:90:76:23:
                    d2:32:c6:c3:ab:06:bf:fc:fb:bf:f3:ad:7d:92:62:
                    02:5b:29:d3:35:a3:93:9a:43:64:60:5d:b2:fa:32:
                    ff:3b:04:af:4d:40:6a:f9:c7:e3:ef:23:fd:6b:cb:
                    e5:0f:8b:38:0d:ee:0a:fc:fe:0f:98:9f:30:31:dd:
                    6c:52:65:f9:8b:81:be:22:e1:1c:58:03:ba:91:1b:
                    89:07
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Subject Key Identifier: 
                6A:38:5B:26:8D:DE:8B:5A:F2:4F:7A:54:83:19:18:E3:08:35:A6:BA
    Signature Algorithm: sha1WithRSAEncryption
         3c:d5:77:3d:da:df:89:ba:87:0c:08:54:6a:20:50:92:be:b0:
         41:3d:b9:26:64:83:0a:2f:e8:40:c0:97:28:27:82:30:4a:c9:
         93:ff:6a:e7:a6:00:7f:89:42:9a:d6:11:e5:53:ce:2f:cc:f2:
         da:05:c4:fe:e2:50:c4:3a:86:7d:cc:da:7e:10:09:3b:92:35:
         2a:53:b2:fe:eb:2b:05:d9:6c:5d:e6:d0:ef:d3:6a:66:9e:15:
         28:85:7a:e8:82:00:ac:1e:a7:09:69:56:42:d3:68:51:18:be:
         54:9a:bf:44:41:ba:49:be:20:ba:69:5c:ee:b8:77:cd:ce:6c:
         1f:ad:83:96:18:7d:0e:b5:14:39:84:f1:28:e9:2d:a3:9e:7b:
         1e:7a:72:5a:83:b3:79:6f:ef:b4:fc:d0:0a:a5:58:4f:46:df:
         fb:6d:79:59:f2:84:22:52:ae:0f:cc:fb:7c:3b:e7:6a:ca:47:
         61:c3:7a:f8:d3:92:04:1f:b8:20:84:e1:36:54:16:c7:40:de:
         3b:8a:73:dc:df:c6:09:4c:df:ec:da:ff:d4:53:42:a1:c9:f2:
         62:1d:22:83:3c:97:c5:f9:19:62:27:ac:65:22:d7:d3:3c:c6:
         e5:8e:b2:53:cc:49:ce:bc:30:fe:7b:0e:33:90:fb:ed:d2:14:
         91:1f:07:af
-----BEGIN CERTIFICATE-----
MIIDezCCAmOgAwIBAgIBATANBgkqhkiG9w0BAQUFADBfMQswCQYDVQQGEwJUVzES
MBAGA1UECgwJVEFJV0FOLUNBMRAwDgYDVQQLDAdSb290IENBMSowKAYDVQQDDCFU
V0NBIFJvb3QgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkwHhcNMDgwODI4MDcyNDMz
WhcNMzAxMjMxMTU1OTU5WjBfMQswCQYDVQQGEwJUVzESMBAGA1UECgwJVEFJV0FO
LUNBMRAwDgYDVQQLDAdSb290IENBMSowKAYDVQQDDCFUV0NBIFJvb3QgQ2VydGlm
aWNhdGlvbiBBdXRob3JpdHkwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIB
AQCwfnK4pAOU5qfeCTiRShFAh6d8WWQUe7UREN3+v9XAu1bihSX0NXIP+FPQQeFE
AcK0HMMxQhZHhTMidrIKbw/lJVBPhYa+v5guEGcevhEFhgWQxFnQfHgQsIBct+HH
K3XLfJ+utdGdIzdjp9xCoi2SBBtQwXu4PhvJVgSLL1KbralW6cH/ralYhzC2gfeX
RfwZVzsrb+RH9JlF/h3x+JejiB03HFyP4HYlmlD4oFT/RJB2I9IyxsOrBr/8+7/z
rX2SYgJbKdM1o5OaQ2RgXbL6Mv87BK9NQGr5x+PvI/1ry+UPizgN7gr8/g+YnzAx
3WxSZfmLgb4i4RxYA7qRG4kHAgMBAAGjQjBAMA4GA1UdDwEB/wQEAwIBBjAPBgNV
HRMBAf8EBTADAQH/MB0GA1UdDgQWBBRqOFsmjd6LWvJPelSDGRjjCDWmujANBgkq
hkiG9w0BAQUFAAOCAQEAPNV3PdrfibqHDAhUaiBQkr6wQT25JmSDCi/oQMCXKCeC
MErJk/9q56YAf4lCmtYR5VPOL8zy2gXE/uJQxDqGfczafhAJO5I1KlOy/usrBdls
XebQ79NqZp4VKIV66IIArB6nCWlWQtNoURi+VJq/REG6Sb4gumlc7rh3zc5sH62D
lhh9DrUUOYTxKOkto557HnpyWoOzeW/vtPzQCqVYT0bf+215WfKEIlKuD8z7fDvn
aspHYcN6+NOSBB+4IIThNlQWx0DeO4pz3N/GCUzf7Nr/1FNCocnyYh0igzyXxfkZ
YiesZSLX0zzG5Y6yU8xJzrww/nsOM5D77dIUkR8Hrw==
-----END CERTIFICATE-----

Security Communication RootCA2
================================================
SHA1 Fingerprint=5F:3B:8C:F2:F8:10:B3:7D:78:B4:CE:EC:19:19:C3:73:34:B9:C7:74
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 0 (0x0)
    Signature Algorithm: sha256WithRSAEncryption
        Issuer: C=JP, O=SECOM Trust Systems CO.,LTD., OU=Security Communication RootCA2
        Validity
            Not Before: May 29 05:00:39 2009 GMT
            Not After : May 29 05:00:39 2029 GMT
        Subject: C=JP, O=SECOM Trust Systems CO.,LTD., OU=Security Communication RootCA2
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (2048 bit)
                Modulus:
                    00:d0:15:39:52:b1:52:b3:ba:c5:59:82:c4:5d:52:
                    ae:3a:43:65:80:4b:c7:f2:96:bc:db:36:97:d6:a6:
                    64:8c:a8:5e:f0:e3:0a:1c:f7:df:97:3d:4b:ae:f6:
                    5d:ec:21:b5:41:ab:cd:b9:7e:76:9f:be:f9:3e:36:
                    34:a0:3b:c1:f6:31:11:45:74:93:3d:57:80:c5:f9:
                    89:99:ca:e5:ab:6a:d4:b5:da:41:90:10:c1:d6:d6:
                    42:89:c2:bf:f4:38:12:95:4c:54:05:f7:36:e4:45:
                    83:7b:14:65:d6:dc:0c:4d:d1:de:7e:0c:ab:3b:c4:
                    15:be:3a:56:a6:5a:6f:76:69:52:a9:7a:b9:c8:eb:
                    6a:9a:5d:52:d0:2d:0a:6b:35:16:09:10:84:d0:6a:
                    ca:3a:06:00:37:47:e4:7e:57:4f:3f:8b:eb:67:b8:
                    88:aa:c5:be:53:55:b2:91:c4:7d:b9:b0:85:19:06:
                    78:2e:db:61:1a:fa:85:f5:4a:91:a1:e7:16:d5:8e:
                    a2:39:df:94:b8:70:1f:28:3f:8b:fc:40:5e:63:83:
                    3c:83:2a:1a:99:6b:cf:de:59:6a:3b:fc:6f:16:d7:
                    1f:fd:4a:10:eb:4e:82:16:3a:ac:27:0c:53:f1:ad:
                    d5:24:b0:6b:03:50:c1:2d:3c:16:dd:44:34:27:1a:
                    75:fb
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Subject Key Identifier: 
                0A:85:A9:77:65:05:98:7C:40:81:F8:0F:97:2C:38:F1:0A:EC:3C:CF
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
    Signature Algorithm: sha256WithRSAEncryption
         4c:3a:a3:44:ac:b9:45:b1:c7:93:7e:c8:0b:0a:42:df:64:ea:
         1c:ee:59:6c:08:ba:89:5f:6a:ca:4a:95:9e:7a:8f:07:c5:da:
         45:72:82:71:0e:3a:d2:cc:6f:a7:b4:a1:23:bb:f6:24:9f:cb:
         17:fe:8c:a6:ce:c2:d2:db:cc:8d:fc:71:fc:03:29:c1:6c:5d:
         33:5f:64:b6:65:3b:89:6f:18:76:78:f5:dc:a2:48:1f:19:3f:
         8e:93:eb:f1:fa:17:ee:cd:4e:e3:04:12:55:d6:e5:e4:dd:fb:
         3e:05:7c:e2:1d:5e:c6:a7:bc:97:4f:68:3a:f5:e9:2e:0a:43:
         b6:af:57:5c:62:68:7c:b7:fd:a3:8a:84:a0:ac:62:be:2b:09:
         87:34:f0:6a:01:bb:9b:29:56:3c:fe:00:37:cf:23:6c:f1:4e:
         aa:b6:74:46:12:6c:91:ee:34:d5:ec:9a:91:e7:44:be:90:31:
         72:d5:49:02:f6:02:e5:f4:1f:eb:7c:d9:96:55:a9:ff:ec:8a:
         f9:99:47:ff:35:5a:02:aa:04:cb:8a:5b:87:71:29:91:bd:a4:
         b4:7a:0d:bd:9a:f5:57:23:00:07:21:17:3f:4a:39:d1:05:49:
         0b:a7:b6:37:81:a5:5d:8c:aa:33:5e:81:28:7c:a7:7d:27:eb:
         00:ae:8d:37
-----BEGIN CERTIFICATE-----
MIIDdzCCAl+gAwIBAgIBADANBgkqhkiG9w0BAQsFADBdMQswCQYDVQQGEwJKUDEl
MCMGA1UEChMcU0VDT00gVHJ1c3QgU3lzdGVtcyBDTy4sTFRELjEnMCUGA1UECxMe
U2VjdXJpdHkgQ29tbXVuaWNhdGlvbiBSb290Q0EyMB4XDTA5MDUyOTA1MDAzOVoX
DTI5MDUyOTA1MDAzOVowXTELMAkGA1UEBhMCSlAxJTAjBgNVBAoTHFNFQ09NIFRy
dXN0IFN5c3RlbXMgQ08uLExURC4xJzAlBgNVBAsTHlNlY3VyaXR5IENvbW11bmlj
YXRpb24gUm9vdENBMjCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBANAV
OVKxUrO6xVmCxF1SrjpDZYBLx/KWvNs2l9amZIyoXvDjChz335c9S672XewhtUGr
zbl+dp+++T42NKA7wfYxEUV0kz1XgMX5iZnK5atq1LXaQZAQwdbWQonCv/Q4EpVM
VAX3NuRFg3sUZdbcDE3R3n4MqzvEFb46VqZab3ZpUql6ucjrappdUtAtCms1FgkQ
hNBqyjoGADdH5H5XTz+L62e4iKrFvlNVspHEfbmwhRkGeC7bYRr6hfVKkaHnFtWO
ojnflLhwHyg/i/xAXmODPIMqGplrz95Zajv8bxbXH/1KEOtOghY6rCcMU/Gt1SSw
awNQwS08Ft1ENCcadfsCAwEAAaNCMEAwHQYDVR0OBBYEFAqFqXdlBZh8QIH4D5cs
OPEK7DzPMA4GA1UdDwEB/wQEAwIBBjAPBgNVHRMBAf8EBTADAQH/MA0GCSqGSIb3
DQEBCwUAA4IBAQBMOqNErLlFsceTfsgLCkLfZOoc7llsCLqJX2rKSpWeeo8HxdpF
coJxDjrSzG+ntKEju/Ykn8sX/oymzsLS28yN/HH8AynBbF0zX2S2ZTuJbxh2ePXc
okgfGT+Ok+vx+hfuzU7jBBJV1uXk3fs+BXziHV7Gp7yXT2g69ekuCkO2r1dcYmh8
t/2jioSgrGK+KwmHNPBqAbubKVY8/gA3zyNs8U6qtnRGEmyR7jTV7JqR50S+kDFy
1UkC9gLl9B/rfNmWVan/7Ir5mUf/NVoCqgTLiluHcSmRvaS0eg29mvVXIwAHIRc/
SjnRBUkLp7Y3gaVdjKozXoEofKd9J+sAro03
-----END CERTIFICATE-----

EC-ACC
=================================================
SHA1 Fingerprint=28:90:3A:63:5B:52:80:FA:E6:77:4C:0B:6D:A7:D6:BA:A6:4A:F2:E8
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
             (Negative)11:d4:c2:14:2b:de:21:eb:57:9d:53:fb:0c:22:3b:ff
    Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=ES, O=Agencia Catalana de Certificacio (NIF Q-0801176-I), OU=Serveis Publics de Certificacio, OU=Vegeu https://www.catcert.net/verarrel (c)03, OU=Jerarquia Entitats de Certificacio Catalanes, CN=EC-ACC
        Validity
            Not Before: Jan  7 23:00:00 2003 GMT
            Not After : Jan  7 22:59:59 2031 GMT
        Subject: C=ES, O=Agencia Catalana de Certificacio (NIF Q-0801176-I), OU=Serveis Publics de Certificacio, OU=Vegeu https://www.catcert.net/verarrel (c)03, OU=Jerarquia Entitats de Certificacio Catalanes, CN=EC-ACC
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (2048 bit)
                Modulus:
                    00:b3:22:c7:4f:e2:97:42:95:88:47:83:40:f6:1d:
                    17:f3:83:73:24:1e:51:f3:98:8a:c3:92:b8:ff:40:
                    90:05:70:87:60:c9:00:a9:b5:94:65:19:22:15:17:
                    c2:43:6c:66:44:9a:0d:04:3e:39:6f:a5:4b:7a:aa:
                    63:b7:8a:44:9d:d9:63:91:84:66:e0:28:0f:ba:42:
                    e3:6e:8e:f7:14:27:93:69:ee:91:0e:a3:5f:0e:b1:
                    eb:66:a2:72:4f:12:13:86:65:7a:3e:db:4f:07:f4:
                    a7:09:60:da:3a:42:99:c7:b2:7f:b3:16:95:1c:c7:
                    f9:34:b5:94:85:d5:99:5e:a0:48:a0:7e:e7:17:65:
                    b8:a2:75:b8:1e:f3:e5:42:7d:af:ed:f3:8a:48:64:
                    5d:82:14:93:d8:c0:e4:ff:b3:50:72:f2:76:f6:b3:
                    5d:42:50:79:d0:94:3e:6b:0c:00:be:d8:6b:0e:4e:
                    2a:ec:3e:d2:cc:82:a2:18:65:33:13:77:9e:9a:5d:
                    1a:13:d8:c3:db:3d:c8:97:7a:ee:70:ed:a7:e6:7c:
                    db:71:cf:2d:94:62:df:6d:d6:f5:38:be:3f:a5:85:
                    0a:19:b8:a8:d8:09:75:42:70:c4:ea:ef:cb:0e:c8:
                    34:a8:12:22:98:0c:b8:13:94:b6:4b:ec:f0:d0:90:
                    e7:27
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Subject Alternative Name: 
                email:ec_acc@catcert.net
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Subject Key Identifier: 
                A0:C3:8B:44:AA:37:A5:45:BF:97:80:5A:D1:F1:78:A2:9B:E9:5D:8D
            X509v3 Certificate Policies: 
                Policy: 1.3.6.1.4.1.15096.1.3.1.10
                  CPS: https://www.catcert.net/verarrel
                  User Notice:
                    Explicit Text: Vegeu https://www.catcert.net/verarrel 

    Signature Algorithm: sha1WithRSAEncryption
         a0:48:5b:82:01:f6:4d:48:b8:39:55:35:9c:80:7a:53:99:d5:
         5a:ff:b1:71:3b:cc:39:09:94:5e:d6:da:ef:be:01:5b:5d:d3:
         1e:d8:fd:7d:4f:cd:a0:41:e0:34:93:bf:cb:e2:86:9c:37:92:
         90:56:1c:dc:eb:29:05:e5:c4:9e:c7:35:df:8a:0c:cd:c5:21:
         43:e9:aa:88:e5:35:c0:19:42:63:5a:02:5e:a4:48:18:3a:85:
         6f:dc:9d:bc:3f:9d:9c:c1:87:b8:7a:61:08:e9:77:0b:7f:70:
         ab:7a:dd:d9:97:2c:64:1e:85:bf:bc:74:96:a1:c3:7a:12:ec:
         0c:1a:6e:83:0c:3c:e8:72:46:9f:fb:48:d5:5e:97:e6:b1:a1:
         f8:e4:ef:46:25:94:9c:89:db:69:38:be:ec:5c:0e:56:c7:65:
         51:e5:50:88:88:bf:42:d5:2b:3d:e5:f9:ba:9e:2e:b3:ca:f4:
         73:92:02:0b:be:4c:66:eb:20:fe:b9:cb:b5:99:7f:e6:b6:13:
         fa:ca:4b:4d:d9:ee:53:46:06:3b:c6:4e:ad:93:5a:81:7e:6c:
         2a:4b:6a:05:45:8c:f2:21:a4:31:90:87:6c:65:9c:9d:a5:60:
         95:3a:52:7f:f5:d1:ab:08:6e:f3:ee:5b:f9:88:3d:7e:b8:6f:
         6e:03:e4:42
-----BEGIN CERTIFICATE-----
MIIFVjCCBD6gAwIBAgIQ7is969Qh3hSoYqwE893EATANBgkqhkiG9w0BAQUFADCB
8zELMAkGA1UEBhMCRVMxOzA5BgNVBAoTMkFnZW5jaWEgQ2F0YWxhbmEgZGUgQ2Vy
dGlmaWNhY2lvIChOSUYgUS0wODAxMTc2LUkpMSgwJgYDVQQLEx9TZXJ2ZWlzIFB1
YmxpY3MgZGUgQ2VydGlmaWNhY2lvMTUwMwYDVQQLEyxWZWdldSBodHRwczovL3d3
dy5jYXRjZXJ0Lm5ldC92ZXJhcnJlbCAoYykwMzE1MDMGA1UECxMsSmVyYXJxdWlh
IEVudGl0YXRzIGRlIENlcnRpZmljYWNpbyBDYXRhbGFuZXMxDzANBgNVBAMTBkVD
LUFDQzAeFw0wMzAxMDcyMzAwMDBaFw0zMTAxMDcyMjU5NTlaMIHzMQswCQYDVQQG
EwJFUzE7MDkGA1UEChMyQWdlbmNpYSBDYXRhbGFuYSBkZSBDZXJ0aWZpY2FjaW8g
KE5JRiBRLTA4MDExNzYtSSkxKDAmBgNVBAsTH1NlcnZlaXMgUHVibGljcyBkZSBD
ZXJ0aWZpY2FjaW8xNTAzBgNVBAsTLFZlZ2V1IGh0dHBzOi8vd3d3LmNhdGNlcnQu
bmV0L3ZlcmFycmVsIChjKTAzMTUwMwYDVQQLEyxKZXJhcnF1aWEgRW50aXRhdHMg
ZGUgQ2VydGlmaWNhY2lvIENhdGFsYW5lczEPMA0GA1UEAxMGRUMtQUNDMIIBIjAN
BgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAsyLHT+KXQpWIR4NA9h0X84NzJB5R
85iKw5K4/0CQBXCHYMkAqbWUZRkiFRfCQ2xmRJoNBD45b6VLeqpjt4pEndljkYRm
4CgPukLjbo73FCeTae6RDqNfDrHrZqJyTxIThmV6PttPB/SnCWDaOkKZx7J/sxaV
HMf5NLWUhdWZXqBIoH7nF2W4onW4HvPlQn2v7fOKSGRdghST2MDk/7NQcvJ29rNd
QlB50JQ+awwAvthrDk4q7D7SzIKiGGUzE3eeml0aE9jD2z3Il3rucO2n5nzbcc8t
lGLfbdb1OL4/pYUKGbio2Al1QnDE6u/LDsg0qBIimAy4E5S2S+zw0JDnJwIDAQAB
o4HjMIHgMB0GA1UdEQQWMBSBEmVjX2FjY0BjYXRjZXJ0Lm5ldDAPBgNVHRMBAf8E
BTADAQH/MA4GA1UdDwEB/wQEAwIBBjAdBgNVHQ4EFgQUoMOLRKo3pUW/l4Ba0fF4
opvpXY0wfwYDVR0gBHgwdjB0BgsrBgEEAfV4AQMBCjBlMCwGCCsGAQUFBwIBFiBo
dHRwczovL3d3dy5jYXRjZXJ0Lm5ldC92ZXJhcnJlbDA1BggrBgEFBQcCAjApGidW
ZWdldSBodHRwczovL3d3dy5jYXRjZXJ0Lm5ldC92ZXJhcnJlbCAwDQYJKoZIhvcN
AQEFBQADggEBAKBIW4IB9k1IuDlVNZyAelOZ1Vr/sXE7zDkJlF7W2u++AVtd0x7Y
/X1PzaBB4DSTv8vihpw3kpBWHNzrKQXlxJ7HNd+KDM3FIUPpqojlNcAZQmNaAl6k
SBg6hW/cnbw/nZzBh7h6YQjpdwt/cKt63dmXLGQehb+8dJahw3oS7AwaboMMPOhy
Rp/7SNVel+axofjk70YllJyJ22k4vuxcDlbHZVHlUIiIv0LVKz3l+bqeLrPK9HOS
Agu+TGbrIP65y7WZf+a2E/rKS03Z7lNGBjvGTq2TWoF+bCpLagVFjPIhpDGQh2xl
nJ2lYJU6Un/10asIbvPuW/mIPX64b24D5EI=
-----END CERTIFICATE-----

Hellenic Academic and Research Institutions RootCA 2011
=======================================================
SHA1 Fingerprint=FE:45:65:9B:79:03:5B:98:A1:61:B5:51:2E:AC:DA:58:09:48:22:4D
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 0 (0x0)
    Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=GR, O=Hellenic Academic and Research Institutions Cert. Authority, CN=Hellenic Academic and Research Institutions RootCA 2011
        Validity
            Not Before: Dec  6 13:49:52 2011 GMT
            Not After : Dec  1 13:49:52 2031 GMT
        Subject: C=GR, O=Hellenic Academic and Research Institutions Cert. Authority, CN=Hellenic Academic and Research Institutions RootCA 2011
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (2048 bit)
                Modulus:
                    00:a9:53:00:e3:2e:a6:f6:8e:fa:60:d8:2d:95:3e:
                    f8:2c:2a:54:4e:cd:b9:84:61:94:58:4f:8f:3d:8b:
                    e4:43:f3:75:89:8d:51:e4:c3:37:d2:8a:88:4d:79:
                    1e:b7:12:dd:43:78:4a:8a:92:e6:d7:48:d5:0f:a4:
                    3a:29:44:35:b8:07:f6:68:1d:55:cd:38:51:f0:8c:
                    24:31:85:af:83:c9:7d:e9:77:af:ed:1a:7b:9d:17:
                    f9:b3:9d:38:50:0f:a6:5a:79:91:80:af:37:ae:a6:
                    d3:31:fb:b5:26:09:9d:3c:5a:ef:51:c5:2b:df:96:
                    5d:eb:32:1e:02:da:70:49:ec:6e:0c:c8:9a:37:8d:
                    f7:f1:36:60:4b:26:2c:82:9e:d0:78:f3:0d:0f:63:
                    a4:51:30:e1:f9:2b:27:12:07:d8:ea:bd:18:62:98:
                    b0:59:37:7d:be:ee:f3:20:51:42:5a:83:ef:93:ba:
                    69:15:f1:62:9d:9f:99:39:82:a1:b7:74:2e:8b:d4:
                    c5:0b:7b:2f:f0:c8:0a:da:3d:79:0a:9a:93:1c:a5:
                    28:72:73:91:43:9a:a7:d1:4d:85:84:b9:a9:74:8f:
                    14:40:c7:dc:de:ac:41:64:6c:b4:19:9b:02:63:6d:
                    24:64:8f:44:b2:25:ea:ce:5d:74:0c:63:32:5c:8d:
                    87:e5
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Key Usage: 
                Certificate Sign, CRL Sign
            X509v3 Subject Key Identifier: 
                A6:91:42:FD:13:61:4A:23:9E:08:A4:29:E5:D8:13:04:23:EE:41:25
            X509v3 Name Constraints: 
                Permitted:
                  DNS:.gr
                  DNS:.eu
                  DNS:.edu
                  DNS:.org
                  email:.gr
                  email:.eu
                  email:.edu
                  email:.org

    Signature Algorithm: sha1WithRSAEncryption
         1f:ef:79:41:e1:7b:6e:3f:b2:8c:86:37:42:4a:4e:1c:37:1e:
         8d:66:ba:24:81:c9:4f:12:0f:21:c0:03:97:86:25:6d:5d:d3:
         22:29:a8:6c:a2:0d:a9:eb:3d:06:5b:99:3a:c7:cc:c3:9a:34:
         7f:ab:0e:c8:4e:1c:e1:fa:e4:dc:cd:0d:be:bf:24:fe:6c:e7:
         6b:c2:0d:c8:06:9e:4e:8d:61:28:a6:6a:fd:e5:f6:62:ea:18:
         3c:4e:a0:53:9d:b2:3a:9c:eb:a5:9c:91:16:b6:4d:82:e0:0c:
         05:48:a9:6c:f5:cc:f8:cb:9d:49:b4:f0:02:a5:fd:70:03:ed:
         8a:21:a5:ae:13:86:49:c3:33:73:be:87:3b:74:8b:17:45:26:
         4c:16:91:83:fe:67:7d:cd:4d:63:67:fa:f3:03:12:96:78:06:
         8d:b1:67:ed:8e:3f:be:9f:4f:02:f5:b3:09:2f:f3:4c:87:df:
         2a:cb:95:7c:01:cc:ac:36:7a:bf:a2:73:7a:f7:8f:c1:b5:9a:
         a1:14:b2:8f:33:9f:0d:ef:22:dc:66:7b:84:bd:45:17:06:3d:
         3c:ca:b9:77:34:8f:ca:ea:cf:3f:31:3e:e3:88:e3:80:49:25:
         c8:97:b5:9d:9a:99:4d:b0:3c:f8:4a:00:9b:64:dd:9f:39:4b:
         d1:27:d7:b8
-----BEGIN CERTIFICATE-----
MIIEMTCCAxmgAwIBAgIBADANBgkqhkiG9w0BAQUFADCBlTELMAkGA1UEBhMCR1Ix
RDBCBgNVBAoTO0hlbGxlbmljIEFjYWRlbWljIGFuZCBSZXNlYXJjaCBJbnN0aXR1
dGlvbnMgQ2VydC4gQXV0aG9yaXR5MUAwPgYDVQQDEzdIZWxsZW5pYyBBY2FkZW1p
YyBhbmQgUmVzZWFyY2ggSW5zdGl0dXRpb25zIFJvb3RDQSAyMDExMB4XDTExMTIw
NjEzNDk1MloXDTMxMTIwMTEzNDk1MlowgZUxCzAJBgNVBAYTAkdSMUQwQgYDVQQK
EztIZWxsZW5pYyBBY2FkZW1pYyBhbmQgUmVzZWFyY2ggSW5zdGl0dXRpb25zIENl
cnQuIEF1dGhvcml0eTFAMD4GA1UEAxM3SGVsbGVuaWMgQWNhZGVtaWMgYW5kIFJl
c2VhcmNoIEluc3RpdHV0aW9ucyBSb290Q0EgMjAxMTCCASIwDQYJKoZIhvcNAQEB
BQADggEPADCCAQoCggEBAKlTAOMupvaO+mDYLZU++CwqVE7NuYRhlFhPjz2L5EPz
dYmNUeTDN9KKiE15HrcS3UN4SoqS5tdI1Q+kOilENbgH9mgdVc04UfCMJDGFr4PJ
fel3r+0ae50X+bOdOFAPplp5kYCvN66m0zH7tSYJnTxa71HFK9+WXesyHgLacEns
bgzImjeN9/E2YEsmLIKe0HjzDQ9jpFEw4fkrJxIH2Oq9GGKYsFk3fb7u8yBRQlqD
75O6aRXxYp2fmTmCobd0LovUxQt7L/DICto9eQqakxylKHJzkUOap9FNhYS5qXSP
FEDH3N6sQWRstBmbAmNtJGSPRLIl6s5ddAxjMlyNh+UCAwEAAaOBiTCBhjAPBgNV
HRMBAf8EBTADAQH/MAsGA1UdDwQEAwIBBjAdBgNVHQ4EFgQUppFC/RNhSiOeCKQp
5dgTBCPuQSUwRwYDVR0eBEAwPqA8MAWCAy5ncjAFggMuZXUwBoIELmVkdTAGggQu
b3JnMAWBAy5ncjAFgQMuZXUwBoEELmVkdTAGgQQub3JnMA0GCSqGSIb3DQEBBQUA
A4IBAQAf73lB4XtuP7KMhjdCSk4cNx6NZrokgclPEg8hwAOXhiVtXdMiKahsog2p
6z0GW5k6x8zDmjR/qw7IThzh+uTczQ2+vyT+bOdrwg3IBp5OjWEopmr95fZi6hg8
TqBTnbI6nOulnJEWtk2C4AwFSKls9cz4y51JtPACpf1wA+2KIaWuE4ZJwzNzvoc7
dIsXRSZMFpGD/md9zU1jZ/rzAxKWeAaNsWftjj++n08C9bMJL/NMh98qy5V8Acys
Nnq/onN694/BtZqhFLKPM58N7yLcZnuEvUUXBj08yrl3NI/K6s8/MT7jiOOASSXI
l7WdmplNsDz4SgCbZN2fOUvRJ9e4
-----END CERTIFICATE-----

Actalis Authentication Root CA
================================================
SHA1 Fingerprint=F3:73:B3:87:06:5A:28:84:8A:F2:F3:4A:CE:19:2B:DD:C7:8E:9C:AC
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 6271844772424770508 (0x570a119742c4e3cc)
    Signature Algorithm: sha256WithRSAEncryption
        Issuer: C=IT, L=Milan, O=Actalis S.p.A./03358520967, CN=Actalis Authentication Root CA
        Validity
            Not Before: Sep 22 11:22:02 2011 GMT
            Not After : Sep 22 11:22:02 2030 GMT
        Subject: C=IT, L=Milan, O=Actalis S.p.A./03358520967, CN=Actalis Authentication Root CA
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (4096 bit)
                Modulus:
                    00:a7:c6:c4:a5:29:a4:2c:ef:e5:18:c5:b0:50:a3:
                    6f:51:3b:9f:0a:5a:c9:c2:48:38:0a:c2:1c:a0:18:
                    7f:91:b5:87:b9:40:3f:dd:1d:68:1f:08:83:d5:2d:
                    1e:88:a0:f8:8f:56:8f:6d:99:02:92:90:16:d5:5f:
                    08:6c:89:d7:e1:ac:bc:20:c2:b1:e0:83:51:8a:69:
                    4d:00:96:5a:6f:2f:c0:44:7e:a3:0e:e4:91:cd:58:
                    ee:dc:fb:c7:1e:45:47:dd:27:b9:08:01:9f:a6:21:
                    1d:f5:41:2d:2f:4c:fd:28:ad:e0:8a:ad:22:b4:56:
                    65:8e:86:54:8f:93:43:29:de:39:46:78:a3:30:23:
                    ba:cd:f0:7d:13:57:c0:5d:d2:83:6b:48:4c:c4:ab:
                    9f:80:5a:5b:3a:bd:c9:a7:22:3f:80:27:33:5b:0e:
                    b7:8a:0c:5d:07:37:08:cb:6c:d2:7a:47:22:44:35:
                    c5:cc:cc:2e:8e:dd:2a:ed:b7:7d:66:0d:5f:61:51:
                    22:55:1b:e3:46:e3:e3:3d:d0:35:62:9a:db:af:14:
                    c8:5b:a1:cc:89:1b:e1:30:26:fc:a0:9b:1f:81:a7:
                    47:1f:04:eb:a3:39:92:06:9f:99:d3:bf:d3:ea:4f:
                    50:9c:19:fe:96:87:1e:3c:65:f6:a3:18:24:83:86:
                    10:e7:54:3e:a8:3a:76:24:4f:81:21:c5:e3:0f:02:
                    f8:93:94:47:20:bb:fe:d4:0e:d3:68:b9:dd:c4:7a:
                    84:82:e3:53:54:79:dd:db:9c:d2:f2:07:9b:2e:b6:
                    bc:3e:ed:85:6d:ef:25:11:f2:97:1a:42:61:f7:4a:
                    97:e8:8b:b1:10:07:fa:65:81:b2:a2:39:cf:f7:3c:
                    ff:18:fb:c6:f1:5a:8b:59:e2:02:ac:7b:92:d0:4e:
                    14:4f:59:45:f6:0c:5e:28:5f:b0:e8:3f:45:cf:cf:
                    af:9b:6f:fb:84:d3:77:5a:95:6f:ac:94:84:9e:ee:
                    bc:c0:4a:8f:4a:93:f8:44:21:e2:31:45:61:50:4e:
                    10:d8:e3:35:7c:4c:19:b4:de:05:bf:a3:06:9f:c8:
                    b5:cd:e4:1f:d7:17:06:0d:7a:95:74:55:0d:68:1a:
                    fc:10:1b:62:64:9d:6d:e0:95:a0:c3:94:07:57:0d:
                    14:e6:bd:05:fb:b8:9f:e6:df:8b:e2:c6:e7:7e:96:
                    f6:53:c5:80:34:50:28:58:f0:12:50:71:17:30:ba:
                    e6:78:63:bc:f4:b2:ad:9b:2b:b2:fe:e1:39:8c:5e:
                    ba:0b:20:94:de:7b:83:b8:ff:e3:56:8d:b7:11:e9:
                    3b:8c:f2:b1:c1:5d:9d:a4:0b:4c:2b:d9:b2:18:f5:
                    b5:9f:4b
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Subject Key Identifier: 
                52:D8:88:3A:C8:9F:78:66:ED:89:F3:7B:38:70:94:C9:02:02:36:D0
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Authority Key Identifier: 
                keyid:52:D8:88:3A:C8:9F:78:66:ED:89:F3:7B:38:70:94:C9:02:02:36:D0

            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
    Signature Algorithm: sha256WithRSAEncryption
         0b:7b:72:87:c0:60:a6:49:4c:88:58:e6:1d:88:f7:14:64:48:
         a6:d8:58:0a:0e:4f:13:35:df:35:1d:d4:ed:06:31:c8:81:3e:
         6a:d5:dd:3b:1a:32:ee:90:3d:11:d2:2e:f4:8e:c3:63:2e:23:
         66:b0:67:be:6f:b6:c0:13:39:60:aa:a2:34:25:93:75:52:de:
         a7:9d:ad:0e:87:89:52:71:6a:16:3c:19:1d:83:f8:9a:29:65:
         be:f4:3f:9a:d9:f0:f3:5a:87:21:71:80:4d:cb:e0:38:9b:3f:
         bb:fa:e0:30:4d:cf:86:d3:65:10:19:18:d1:97:02:b1:2b:72:
         42:68:ac:a0:bd:4e:5a:da:18:bf:6b:98:81:d0:fd:9a:be:5e:
         15:48:cd:11:15:b9:c0:29:5c:b4:e8:88:f7:3e:36:ae:b7:62:
         fd:1e:62:de:70:78:10:1c:48:5b:da:bc:a4:38:ba:67:ed:55:
         3e:5e:57:df:d4:03:40:4c:81:a4:d2:4f:63:a7:09:42:09:14:
         fc:00:a9:c2:80:73:4f:2e:c0:40:d9:11:7b:48:ea:7a:02:c0:
         d3:eb:28:01:26:58:74:c1:c0:73:22:6d:93:95:fd:39:7d:bb:
         2a:e3:f6:82:e3:2c:97:5f:4e:1f:91:94:fa:fe:2c:a3:d8:76:
         1a:b8:4d:b2:38:4f:9b:fa:1d:48:60:79:26:e2:f3:fd:a9:d0:
         9a:e8:70:8f:49:7a:d6:e5:bd:0a:0e:db:2d:f3:8d:bf:eb:e3:
         a4:7d:cb:c7:95:71:e8:da:a3:7c:c5:c2:f8:74:92:04:1b:86:
         ac:a4:22:53:40:b6:ac:fe:4c:76:cf:fb:94:32:c0:35:9f:76:
         3f:6e:e5:90:6e:a0:a6:26:a2:b8:2c:be:d1:2b:85:fd:a7:68:
         c8:ba:01:2b:b1:6c:74:1d:b8:73:95:e7:ee:b7:c7:25:f0:00:
         4c:00:b2:7e:b6:0b:8b:1c:f3:c0:50:9e:25:b9:e0:08:de:36:
         66:ff:37:a5:d1:bb:54:64:2c:c9:27:b5:4b:92:7e:65:ff:d3:
         2d:e1:b9:4e:bc:7f:a4:41:21:90:41:77:a6:39:1f:ea:9e:e3:
         9f:d0:66:6f:05:ec:aa:76:7e:bf:6b:16:a0:eb:b5:c7:fc:92:
         54:2f:2b:11:27:25:37:78:4c:51:6a:b0:f3:cc:58:5d:14:f1:
         6a:48:15:ff:c2:07:b6:b1:8d:0f:8e:5c:50:46:b3:3d:bf:01:
         98:4f:b2:59:54:47:3e:34:7b:78:6d:56:93:2e:73:ea:66:28:
         78:cd:1d:14:bf:a0:8f:2f:2e:b8:2e:8e:f2:14:8a:cc:e9:b5:
         7c:fb:6c:9d:0c:a5:e1:96
-----BEGIN CERTIFICATE-----
MIIFuzCCA6OgAwIBAgIIVwoRl0LE48wwDQYJKoZIhvcNAQELBQAwazELMAkGA1UE
BhMCSVQxDjAMBgNVBAcMBU1pbGFuMSMwIQYDVQQKDBpBY3RhbGlzIFMucC5BLi8w
MzM1ODUyMDk2NzEnMCUGA1UEAwweQWN0YWxpcyBBdXRoZW50aWNhdGlvbiBSb290
IENBMB4XDTExMDkyMjExMjIwMloXDTMwMDkyMjExMjIwMlowazELMAkGA1UEBhMC
SVQxDjAMBgNVBAcMBU1pbGFuMSMwIQYDVQQKDBpBY3RhbGlzIFMucC5BLi8wMzM1
ODUyMDk2NzEnMCUGA1UEAwweQWN0YWxpcyBBdXRoZW50aWNhdGlvbiBSb290IENB
MIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAp8bEpSmkLO/lGMWwUKNv
UTufClrJwkg4CsIcoBh/kbWHuUA/3R1oHwiD1S0eiKD4j1aPbZkCkpAW1V8IbInX
4ay8IMKx4INRimlNAJZaby/ARH6jDuSRzVju3PvHHkVH3Se5CAGfpiEd9UEtL0z9
KK3giq0itFZljoZUj5NDKd45RnijMCO6zfB9E1fAXdKDa0hMxKufgFpbOr3JpyI/
gCczWw63igxdBzcIy2zSekciRDXFzMwujt0q7bd9Zg1fYVEiVRvjRuPjPdA1Yprb
rxTIW6HMiRvhMCb8oJsfgadHHwTrozmSBp+Z07/T6k9QnBn+locePGX2oxgkg4YQ
51Q+qDp2JE+BIcXjDwL4k5RHILv+1A7TaLndxHqEguNTVHnd25zS8gebLra8Pu2F
be8lEfKXGkJh90qX6IuxEAf6ZYGyojnP9zz/GPvG8VqLWeICrHuS0E4UT1lF9gxe
KF+w6D9Fz8+vm2/7hNN3WpVvrJSEnu68wEqPSpP4RCHiMUVhUE4Q2OM1fEwZtN4F
v6MGn8i1zeQf1xcGDXqVdFUNaBr8EBtiZJ1t4JWgw5QHVw0U5r0F+7if5t+L4sbn
fpb2U8WANFAoWPASUHEXMLrmeGO89LKtmyuy/uE5jF66CyCU3nuDuP/jVo23Eek7
jPKxwV2dpAtMK9myGPW1n0sCAwEAAaNjMGEwHQYDVR0OBBYEFFLYiDrIn3hm7Ynz
ezhwlMkCAjbQMA8GA1UdEwEB/wQFMAMBAf8wHwYDVR0jBBgwFoAUUtiIOsifeGbt
ifN7OHCUyQICNtAwDgYDVR0PAQH/BAQDAgEGMA0GCSqGSIb3DQEBCwUAA4ICAQAL
e3KHwGCmSUyIWOYdiPcUZEim2FgKDk8TNd81HdTtBjHIgT5q1d07GjLukD0R0i70
jsNjLiNmsGe+b7bAEzlgqqI0JZN1Ut6nna0Oh4lScWoWPBkdg/iaKWW+9D+a2fDz
WochcYBNy+A4mz+7+uAwTc+G02UQGRjRlwKxK3JCaKygvU5a2hi/a5iB0P2avl4V
SM0RFbnAKVy06Ij3Pjaut2L9HmLecHgQHEhb2rykOLpn7VU+Xlff1ANATIGk0k9j
pwlCCRT8AKnCgHNPLsBA2RF7SOp6AsDT6ygBJlh0wcBzIm2Tlf05fbsq4/aC4yyX
X04fkZT6/iyj2HYauE2yOE+b+h1IYHkm4vP9qdCa6HCPSXrW5b0KDtst842/6+Ok
fcvHlXHo2qN8xcL4dJIEG4aspCJTQLas/kx2z/uUMsA1n3Y/buWQbqCmJqK4LL7R
K4X9p2jIugErsWx0Hbhzlefut8cl8ABMALJ+tguLHPPAUJ4lueAI3jZm/zel0btU
ZCzJJ7VLkn5l/9Mt4blOvH+kQSGQQXemOR/qnuOf0GZvBeyqdn6/axag67XH/JJU
LysRJyU3eExRarDzzFhdFPFqSBX/wge2sY0PjlxQRrM9vwGYT7JZVEc+NHt4bVaT
LnPqZih4zR0Uv6CPLy64Lo7yFIrM6bV8+2ydDKXhlg==
-----END CERTIFICATE-----

Buypass Class 2 Root CA
=================================================
SHA1 Fingerprint=49:0A:75:74:DE:87:0A:47:FE:58:EE:F6:C7:6B:EB:C6:0B:12:40:99
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 2 (0x2)
    Signature Algorithm: sha256WithRSAEncryption
        Issuer: C=NO, O=Buypass AS-983163327, CN=Buypass Class 2 Root CA
        Validity
            Not Before: Oct 26 08:38:03 2010 GMT
            Not After : Oct 26 08:38:03 2040 GMT
        Subject: C=NO, O=Buypass AS-983163327, CN=Buypass Class 2 Root CA
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (4096 bit)
                Modulus:
                    00:d7:c7:5e:f7:c1:07:d4:77:fb:43:21:f4:f4:f5:
                    69:e4:ee:32:01:db:a3:86:1f:e4:59:0d:ba:e7:75:
                    83:52:eb:ea:1c:61:15:48:bb:1d:07:ca:8c:ae:b0:
                    dc:96:9d:ea:c3:60:92:86:82:28:73:9c:56:06:ff:
                    4b:64:f0:0c:2a:37:49:b5:e5:cf:0c:7c:ee:f1:4a:
                    bb:73:30:65:f3:d5:2f:83:b6:7e:e3:e7:f5:9e:ab:
                    60:f9:d3:f1:9d:92:74:8a:e4:1c:96:ac:5b:80:e9:
                    b5:f4:31:87:a3:51:fc:c7:7e:a1:6f:8e:53:77:d4:
                    97:c1:55:33:92:3e:18:2f:75:d4:ad:86:49:cb:95:
                    af:54:06:6c:d8:06:13:8d:5b:ff:e1:26:19:59:c0:
                    24:ba:81:71:79:90:44:50:68:24:94:5f:b8:b3:11:
                    f1:29:41:61:a3:41:cb:23:36:d5:c1:f1:32:50:10:
                    4e:7f:f4:86:93:ec:84:d3:8e:bc:4b:bf:5c:01:4e:
                    07:3d:dc:14:8a:94:0a:a4:ea:73:fb:0b:51:e8:13:
                    07:18:fa:0e:f1:2b:d1:54:15:7d:3c:e1:f7:b4:19:
                    42:67:62:5e:77:e0:a2:55:ec:b6:d9:69:17:d5:3a:
                    af:44:ed:4a:c5:9e:e4:7a:27:7c:e5:75:d7:aa:cb:
                    25:e7:df:6b:0a:db:0f:4d:93:4e:a8:a0:cd:7b:2e:
                    f2:59:01:6a:b7:0d:b8:07:81:7e:8b:38:1b:38:e6:
                    0a:57:99:3d:ee:21:e8:a3:f5:0c:16:dd:8b:ec:34:
                    8e:9c:2a:1c:00:15:17:8d:68:83:d2:70:9f:18:08:
                    cd:11:68:d5:c9:6b:52:cd:c4:46:8f:dc:b5:f3:d8:
                    57:73:1e:e9:94:39:04:bf:d3:de:38:de:b4:53:ec:
                    69:1c:a2:7e:c4:8f:e4:1b:70:ad:f2:a2:f9:fb:f7:
                    16:64:66:69:9f:49:51:a2:e2:15:18:67:06:4a:7f:
                    d5:6c:b5:4d:b3:33:e0:61:eb:5d:be:e9:98:0f:32:
                    d7:1d:4b:3c:2e:5a:01:52:91:09:f2:df:ea:8d:d8:
                    06:40:63:aa:11:e4:fe:c3:37:9e:14:52:3f:f4:e2:
                    cc:f2:61:93:d1:fd:67:6b:d7:52:ae:bf:68:ab:40:
                    43:a0:57:35:53:78:f0:53:f8:61:42:07:64:c6:d7:
                    6f:9b:4c:38:0d:63:ac:62:af:36:8b:a2:73:0a:0d:
                    f5:21:bd:74:aa:4d:ea:72:03:49:db:c7:5f:1d:62:
                    63:c7:fd:dd:91:ec:33:ee:f5:6d:b4:6e:30:68:de:
                    c8:d6:26:b0:75:5e:7b:b4:07:20:98:a1:76:32:b8:
                    4d:6c:4f
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Subject Key Identifier: 
                C9:80:77:E0:62:92:82:F5:46:9C:F3:BA:F7:4C:C3:DE:B8:A3:AD:39
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
    Signature Algorithm: sha256WithRSAEncryption
         53:5f:21:f5:ba:b0:3a:52:39:2c:92:b0:6c:00:c9:ef:ce:20:
         ef:06:f2:96:9e:e9:a4:74:7f:7a:16:fc:b7:f5:b6:fb:15:1b:
         3f:ab:a6:c0:72:5d:10:b1:71:ee:bc:4f:e3:ad:ac:03:6d:2e:
         71:2e:af:c4:e3:ad:a3:bd:0c:11:a7:b4:ff:4a:b2:7b:10:10:
         1f:a7:57:41:b2:c0:ae:f4:2c:59:d6:47:10:88:f3:21:51:29:
         30:ca:60:86:af:46:ab:1d:ed:3a:5b:b0:94:de:44:e3:41:08:
         a2:c1:ec:1d:d6:fd:4f:b6:d6:47:d0:14:0b:ca:e6:ca:b5:7b:
         77:7e:41:1f:5e:83:c7:b6:8c:39:96:b0:3f:96:81:41:6f:60:
         90:e2:e8:f9:fb:22:71:d9:7d:b3:3d:46:bf:b4:84:af:90:1c:
         0f:8f:12:6a:af:ef:ee:1e:7a:ae:02:4a:8a:17:2b:76:fe:ac:
         54:89:24:2c:4f:3f:b6:b2:a7:4e:8c:a8:91:97:fb:29:c6:7b:
         5c:2d:b9:cb:66:b6:b7:a8:5b:12:51:85:b5:09:7e:62:78:70:
         fe:a9:6a:60:b6:1d:0e:79:0c:fd:ca:ea:24:80:72:c3:97:3f:
         f2:77:ab:43:22:0a:c7:eb:b6:0c:84:82:2c:80:6b:41:8a:08:
         c0:eb:a5:6b:df:99:12:cb:8a:d5:5e:80:0c:91:e0:26:08:36:
         48:c5:fa:38:11:35:ff:25:83:2d:f2:7a:bf:da:fd:8e:fe:a5:
         cb:45:2c:1f:c4:88:53:ae:77:0e:d9:9a:76:c5:8e:2c:1d:a3:
         ba:d5:ec:32:ae:c0:aa:ac:f7:d1:7a:4d:eb:d4:07:e2:48:f7:
         22:8e:b0:a4:9f:6a:ce:8e:b2:b2:60:f4:a3:22:d0:23:eb:94:
         5a:7a:69:dd:0f:bf:40:57:ac:6b:59:50:d9:a3:99:e1:6e:fe:
         8d:01:79:27:23:15:de:92:9d:7b:09:4d:5a:e7:4b:48:30:5a:
         18:e6:0a:6d:e6:8f:e0:d2:bb:e6:df:7c:6e:21:82:c1:68:39:
         4d:b4:98:58:66:62:cc:4a:90:5e:c3:fa:27:04:b1:79:15:74:
         99:cc:be:ad:20:de:26:60:1c:eb:56:51:a6:a3:ea:e4:a3:3f:
         a7:ff:61:dc:f1:5a:4d:6c:32:23:43:ee:ac:a8:ee:ee:4a:12:
         09:3c:5d:71:c2:be:79:fa:c2:87:68:1d:0b:fd:5c:69:cc:06:
         d0:9a:7d:54:99:2a:c9:39:1a:19:af:4b:2a:43:f3:63:5d:5a:
         58:e2:2f:e3:1d:e4:a9:d6:d0:0a:d0:9e:bf:d7:81:09:f1:c9:
         c7:26:0d:ac:98:16:56:a0
-----BEGIN CERTIFICATE-----
MIIFWTCCA0GgAwIBAgIBAjANBgkqhkiG9w0BAQsFADBOMQswCQYDVQQGEwJOTzEd
MBsGA1UECgwUQnV5cGFzcyBBUy05ODMxNjMzMjcxIDAeBgNVBAMMF0J1eXBhc3Mg
Q2xhc3MgMiBSb290IENBMB4XDTEwMTAyNjA4MzgwM1oXDTQwMTAyNjA4MzgwM1ow
TjELMAkGA1UEBhMCTk8xHTAbBgNVBAoMFEJ1eXBhc3MgQVMtOTgzMTYzMzI3MSAw
HgYDVQQDDBdCdXlwYXNzIENsYXNzIDIgUm9vdCBDQTCCAiIwDQYJKoZIhvcNAQEB
BQADggIPADCCAgoCggIBANfHXvfBB9R3+0Mh9PT1aeTuMgHbo4Yf5FkNuud1g1Lr
6hxhFUi7HQfKjK6w3Jad6sNgkoaCKHOcVgb/S2TwDCo3SbXlzwx87vFKu3MwZfPV
L4O2fuPn9Z6rYPnT8Z2SdIrkHJasW4DptfQxh6NR/Md+oW+OU3fUl8FVM5I+GC91
1K2GScuVr1QGbNgGE41b/+EmGVnAJLqBcXmQRFBoJJRfuLMR8SlBYaNByyM21cHx
MlAQTn/0hpPshNOOvEu/XAFOBz3cFIqUCqTqc/sLUegTBxj6DvEr0VQVfTzh97QZ
QmdiXnfgolXsttlpF9U6r0TtSsWe5HonfOV116rLJeffawrbD02TTqigzXsu8lkB
arcNuAeBfos4GzjmCleZPe4h6KP1DBbdi+w0jpwqHAAVF41og9JwnxgIzRFo1clr
Us3ERo/ctfPYV3Me6ZQ5BL/T3jjetFPsaRyifsSP5BtwrfKi+fv3FmRmaZ9JUaLi
FRhnBkp/1Wy1TbMz4GHrXb7pmA8y1x1LPC5aAVKRCfLf6o3YBkBjqhHk/sM3nhRS
P/TizPJhk9H9Z2vXUq6/aKtAQ6BXNVN48FP4YUIHZMbXb5tMOA1jrGKvNouicwoN
9SG9dKpN6nIDSdvHXx1iY8f93ZHsM+71bbRuMGjeyNYmsHVee7QHIJihdjK4TWxP
AgMBAAGjQjBAMA8GA1UdEwEB/wQFMAMBAf8wHQYDVR0OBBYEFMmAd+BikoL1Rpzz
uvdMw964o605MA4GA1UdDwEB/wQEAwIBBjANBgkqhkiG9w0BAQsFAAOCAgEAU18h
9bqwOlI5LJKwbADJ784g7wbylp7ppHR/ehb8t/W2+xUbP6umwHJdELFx7rxP462s
A20ucS6vxOOto70MEae0/0qyexAQH6dXQbLArvQsWdZHEIjzIVEpMMpghq9Gqx3t
OluwlN5E40EIosHsHdb9T7bWR9AUC8rmyrV7d35BH16Dx7aMOZawP5aBQW9gkOLo
+fsicdl9sz1Gv7SEr5AcD48Saq/v7h56rgJKihcrdv6sVIkkLE8/trKnToyokZf7
KcZ7XC25y2a2t6hbElGFtQl+Ynhw/qlqYLYdDnkM/crqJIByw5c/8nerQyIKx+u2
DISCLIBrQYoIwOula9+ZEsuK1V6ADJHgJgg2SMX6OBE1/yWDLfJ6v9r9jv6ly0Us
H8SIU653DtmadsWOLB2jutXsMq7Aqqz30XpN69QH4kj3Io6wpJ9qzo6ysmD0oyLQ
I+uUWnpp3Q+/QFesa1lQ2aOZ4W7+jQF5JyMV3pKdewlNWudLSDBaGOYKbeaP4NK7
5t98biGCwWg5TbSYWGZizEqQXsP6JwSxeRV0mcy+rSDeJmAc61ZRpqPq5KM/p/9h
3PFaTWwyI0PurKju7koSCTxdccK+efrCh2gdC/1cacwG0Jp9VJkqyTkaGa9LKkPz
Y11aWOIv4x3kqdbQCtCev9eBCfHJxyYNrJgWVqA=
-----END CERTIFICATE-----

Buypass Class 3 Root CA
=================================================
SHA1 Fingerprint=DA:FA:F7:FA:66:84:EC:06:8F:14:50:BD:C7:C2:81:A5:BC:A9:64:57
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 2 (0x2)
    Signature Algorithm: sha256WithRSAEncryption
        Issuer: C=NO, O=Buypass AS-983163327, CN=Buypass Class 3 Root CA
        Validity
            Not Before: Oct 26 08:28:58 2010 GMT
            Not After : Oct 26 08:28:58 2040 GMT
        Subject: C=NO, O=Buypass AS-983163327, CN=Buypass Class 3 Root CA
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (4096 bit)
                Modulus:
                    00:a5:da:0a:95:16:50:e3:95:f2:5e:9d:76:31:06:
                    32:7a:9b:f1:10:76:b8:00:9a:b5:52:36:cd:24:47:
                    b0:9f:18:64:bc:9a:f6:fa:d5:79:d8:90:62:4c:22:
                    2f:de:38:3d:d6:e0:a8:e9:1c:2c:db:78:11:e9:8e:
                    68:51:15:72:c7:f3:33:87:e4:a0:5d:0b:5c:e0:57:
                    07:2a:30:f5:cd:c4:37:77:28:4d:18:91:e6:bf:d5:
                    52:fd:71:2d:70:3e:e7:c6:c4:8a:e3:f0:28:0b:f4:
                    76:98:a1:8b:87:55:b2:3a:13:fc:b7:3e:27:37:8e:
                    22:e3:a8:4f:2a:ef:60:bb:3d:b7:39:c3:0e:01:47:
                    99:5d:12:4f:db:43:fa:57:a1:ed:f9:9d:be:11:47:
                    26:5b:13:98:ab:5d:16:8a:b0:37:1c:57:9d:45:ff:
                    88:96:36:bf:bb:ca:07:7b:6f:87:63:d7:d0:32:6a:
                    d6:5d:6c:0c:f1:b3:6e:39:e2:6b:31:2e:39:00:27:
                    14:de:38:c0:ec:19:66:86:12:e8:9d:72:16:13:64:
                    52:c7:a9:37:1c:fd:82:30:ed:84:18:1d:f4:ae:5c:
                    ff:70:13:00:eb:b1:f5:33:7a:4b:d6:55:f8:05:8d:
                    4b:69:b0:f5:b3:28:36:5c:14:c4:51:73:4d:6b:0b:
                    f1:34:07:db:17:39:d7:dc:28:7b:6b:f5:9f:f3:2e:
                    c1:4f:17:2a:10:f3:cc:ca:e8:eb:fd:6b:ab:2e:9a:
                    9f:2d:82:6e:04:d4:52:01:93:2d:3d:86:fc:7e:fc:
                    df:ef:42:1d:a6:6b:ef:b9:20:c6:f7:bd:a0:a7:95:
                    fd:a7:e6:89:24:d8:cc:8c:34:6c:e2:23:2f:d9:12:
                    1a:21:b9:55:91:6f:0b:91:79:19:0c:ad:40:88:0b:
                    70:e2:7a:d2:0e:d8:68:48:bb:82:13:39:10:58:e9:
                    d8:2a:07:c6:12:db:58:db:d2:3b:55:10:47:05:15:
                    67:62:7e:18:63:a6:46:3f:09:0e:54:32:5e:bf:0d:
                    62:7a:27:ef:80:e8:db:d9:4b:06:5a:37:5a:25:d0:
                    08:12:77:d4:6f:09:50:97:3d:c8:1d:c3:df:8c:45:
                    30:56:c6:d3:64:ab:66:f3:c0:5e:96:9c:c3:c4:ef:
                    c3:7c:6b:8b:3a:79:7f:b3:49:cf:3d:e2:89:9f:a0:
                    30:4b:85:b9:9c:94:24:79:8f:7d:6b:a9:45:68:0f:
                    2b:d0:f1:da:1c:cb:69:b8:ca:49:62:6d:c8:d0:63:
                    62:dd:60:0f:58:aa:8f:a1:bc:05:a5:66:a2:cf:1b:
                    76:b2:84:64:b1:4c:39:52:c0:30:ba:f0:8c:4b:02:
                    b0:b6:b7
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Subject Key Identifier: 
                47:B8:CD:FF:E5:6F:EE:F8:B2:EC:2F:4E:0E:F9:25:B0:8E:3C:6B:C3
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
    Signature Algorithm: sha256WithRSAEncryption
         00:20:23:41:35:04:90:c2:40:62:60:ef:e2:35:4c:d7:3f:ac:
         e2:34:90:b8:a1:6f:76:fa:16:16:a4:48:37:2c:e9:90:c2:f2:
         3c:f8:0a:9f:d8:81:e5:bb:5b:da:25:2c:a4:a7:55:71:24:32:
         f6:c8:0b:f2:bc:6a:f8:93:ac:b2:07:c2:5f:9f:db:cc:c8:8a:
         aa:be:6a:6f:e1:49:10:cc:31:d7:80:bb:bb:c8:d8:a2:0e:64:
         57:ea:a2:f5:c2:a9:31:15:d2:20:6a:ec:fc:22:01:28:cf:86:
         b8:80:1e:a9:cc:11:a5:3c:f2:16:b3:47:9d:fc:d2:80:21:c4:
         cb:d0:47:70:41:a1:ca:83:19:08:2c:6d:f2:5d:77:9c:8a:14:
         13:d4:36:1c:92:f0:e5:06:37:dc:a6:e6:90:9b:38:8f:5c:6b:
         1b:46:86:43:42:5f:3e:01:07:53:54:5d:65:7d:f7:8a:73:a1:
         9a:54:5a:1f:29:43:14:27:c2:85:0f:b5:88:7b:1a:3b:94:b7:
         1d:60:a7:b5:9c:e7:29:69:57:5a:9b:93:7a:43:30:1b:03:d7:
         62:c8:40:a6:aa:fc:64:e4:4a:d7:91:53:01:a8:20:88:6e:9c:
         5f:44:b9:cb:60:81:34:ec:6f:d3:7d:da:48:5f:eb:b4:90:bc:
         2d:a9:1c:0b:ac:1c:d5:a2:68:20:80:04:d6:fc:b1:8f:2f:bb:
         4a:31:0d:4a:86:1c:eb:e2:36:29:26:f5:da:d8:c4:f2:75:61:
         cf:7e:ae:76:63:4a:7a:40:65:93:87:f8:1e:80:8c:86:e5:86:
         d6:8f:0e:fc:53:2c:60:e8:16:61:1a:a2:3e:43:7b:cd:39:60:
         54:6a:f5:f2:89:26:01:68:83:48:a2:33:e8:c9:04:91:b2:11:
         34:11:3e:ea:d0:43:19:1f:03:93:90:0c:ff:51:3d:57:f4:41:
         6e:e1:cb:a0:be:eb:c9:63:cd:6d:cc:e4:f8:36:aa:68:9d:ed:
         bd:5d:97:70:44:0d:b6:0e:35:dc:e1:0c:5d:bb:a0:51:94:cb:
         7e:16:eb:11:2f:a3:92:45:c8:4c:71:d9:bc:c9:99:52:57:46:
         2f:50:cf:bd:35:69:f4:3d:15:ce:06:a5:2c:0f:3e:f6:81:ba:
         94:bb:c3:bb:bf:65:78:d2:86:79:ff:49:3b:1a:83:0c:f0:de:
         78:ec:c8:f2:4d:4c:1a:de:82:29:f8:c1:5a:da:ed:ee:e6:27:
         5e:e8:45:d0:9d:1c:51:a8:68:ab:44:e3:d0:8b:6a:e3:f8:3b:
         bb:dc:4d:d7:64:f2:51:be:e6:aa:ab:5a:e9:31:ee:06:bc:73:
         bf:13:62:0a:9f:c7:b9:97
-----BEGIN CERTIFICATE-----
MIIFWTCCA0GgAwIBAgIBAjANBgkqhkiG9w0BAQsFADBOMQswCQYDVQQGEwJOTzEd
MBsGA1UECgwUQnV5cGFzcyBBUy05ODMxNjMzMjcxIDAeBgNVBAMMF0J1eXBhc3Mg
Q2xhc3MgMyBSb290IENBMB4XDTEwMTAyNjA4Mjg1OFoXDTQwMTAyNjA4Mjg1OFow
TjELMAkGA1UEBhMCTk8xHTAbBgNVBAoMFEJ1eXBhc3MgQVMtOTgzMTYzMzI3MSAw
HgYDVQQDDBdCdXlwYXNzIENsYXNzIDMgUm9vdCBDQTCCAiIwDQYJKoZIhvcNAQEB
BQADggIPADCCAgoCggIBAKXaCpUWUOOV8l6ddjEGMnqb8RB2uACatVI2zSRHsJ8Y
ZLya9vrVediQYkwiL944PdbgqOkcLNt4EemOaFEVcsfzM4fkoF0LXOBXByow9c3E
N3coTRiR5r/VUv1xLXA+58bEiuPwKAv0dpihi4dVsjoT/Lc+JzeOIuOoTyrvYLs9
tznDDgFHmV0ST9tD+leh7fmdvhFHJlsTmKtdFoqwNxxXnUX/iJY2v7vKB3tvh2PX
0DJq1l1sDPGzbjniazEuOQAnFN44wOwZZoYS6J1yFhNkUsepNxz9gjDthBgd9K5c
/3ATAOux9TN6S9ZV+AWNS2mw9bMoNlwUxFFzTWsL8TQH2xc519woe2v1n/MuwU8X
KhDzzMro6/1rqy6any2CbgTUUgGTLT2G/H783+9CHaZr77kgxve9oKeV/afmiSTY
zIw0bOIjL9kSGiG5VZFvC5F5GQytQIgLcOJ60g7YaEi7ghM5EFjp2CoHxhLbWNvS
O1UQRwUVZ2J+GGOmRj8JDlQyXr8NYnon74Do29lLBlo3WiXQCBJ31G8JUJc9yB3D
34xFMFbG02SrZvPAXpacw8Tvw3xrizp5f7NJzz3iiZ+gMEuFuZyUJHmPfWupRWgP
K9Dx2hzLabjKSWJtyNBjYt1gD1iqj6G8BaVmos8bdrKEZLFMOVLAMLrwjEsCsLa3
AgMBAAGjQjBAMA8GA1UdEwEB/wQFMAMBAf8wHQYDVR0OBBYEFEe4zf/lb+74suwv
Tg75JbCOPGvDMA4GA1UdDwEB/wQEAwIBBjANBgkqhkiG9w0BAQsFAAOCAgEAACAj
QTUEkMJAYmDv4jVM1z+s4jSQuKFvdvoWFqRINyzpkMLyPPgKn9iB5btb2iUspKdV
cSQy9sgL8rxq+JOssgfCX5/bzMiKqr5qb+FJEMwx14C7u8jYog5kV+qi9cKpMRXS
IGrs/CIBKM+GuIAeqcwRpTzyFrNHnfzSgCHEy9BHcEGhyoMZCCxt8l13nIoUE9Q2
HJLw5QY33KbmkJs4j1xrG0aGQ0JfPgEHU1RdZX33inOhmlRaHylDFCfChQ+1iHsa
O5S3HWCntZznKWlXWpuTekMwGwPXYshApqr8ZORK15FTAaggiG6cX0S5y2CBNOxv
033aSF/rtJC8LakcC6wc1aJoIIAE1vyxjy+7SjENSoYc6+I2KSb12tjE8nVhz36u
dmNKekBlk4f4HoCMhuWG1o8O/FMsYOgWYRqiPkN7zTlgVGr18okmAWiDSKIz6MkE
kbIRNBE+6tBDGR8Dk5AM/1E9V/RBbuHLoL7ryWPNbczk+DaqaJ3tvV2XcEQNtg41
3OEMXbugUZTLfhbrES+jkkXITHHZvMmZUldGL1DPvTVp9D0VzgalLA8+9oG6lLvD
u79leNKGef9JOxqDDPDeeOzI8k1MGt6CKfjBWtrt7uYnXuhF0J0cUahoq0Tj0Itq
4/g7u9xN12TyUb7mqqta6THuBrxzvxNiCp/HuZc=
-----END CERTIFICATE-----

T-TeleSec GlobalRoot Class 3
=================================================
SHA1 Fingerprint=55:A6:72:3E:CB:F2:EC:CD:C3:23:74:70:19:9D:2A:BE:11:E3:81:D1
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 1 (0x1)
    Signature Algorithm: sha256WithRSAEncryption
        Issuer: C=DE, O=T-Systems Enterprise Services GmbH, OU=T-Systems Trust Center, CN=T-TeleSec GlobalRoot Class 3
        Validity
            Not Before: Oct  1 10:29:56 2008 GMT
            Not After : Oct  1 23:59:59 2033 GMT
        Subject: C=DE, O=T-Systems Enterprise Services GmbH, OU=T-Systems Trust Center, CN=T-TeleSec GlobalRoot Class 3
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (2048 bit)
                Modulus:
                    00:bd:75:93:f0:62:22:6f:24:ae:e0:7a:76:ac:7d:
                    bd:d9:24:d5:b8:b7:fc:cd:f0:42:e0:eb:78:88:56:
                    5e:9b:9a:54:1d:4d:0c:8a:f6:d3:cf:70:f4:52:b5:
                    d8:93:04:e3:46:86:71:41:4a:2b:f0:2a:2c:55:03:
                    d6:48:c3:e0:39:38:ed:f2:5c:3c:3f:44:bc:93:3d:
                    61:ab:4e:cd:0d:be:f0:20:27:58:0e:44:7f:04:1a:
                    87:a5:d7:96:14:36:90:d0:49:7b:a1:75:fb:1a:6b:
                    73:b1:f8:ce:a9:09:2c:f2:53:d5:c3:14:44:b8:86:
                    a5:f6:8b:2b:39:da:a3:33:54:d9:fa:72:1a:f7:22:
                    15:1c:88:91:6b:7f:66:e5:c3:6a:80:b0:24:f3:df:
                    86:45:88:fd:19:7f:75:87:1f:1f:b1:1b:0a:73:24:
                    5b:b9:65:e0:2c:54:c8:60:d3:66:17:3f:e1:cc:54:
                    33:73:91:02:3a:a6:7f:7b:76:39:a2:1f:96:b6:38:
                    ae:b5:c8:93:74:1d:9e:b9:b4:e5:60:9d:2f:56:d1:
                    e0:eb:5e:5b:4c:12:70:0c:6c:44:20:ab:11:d8:f4:
                    19:f6:d2:9c:52:37:e7:fa:b6:c2:31:3b:4a:d4:14:
                    99:ad:c7:1a:f5:5d:5f:fa:07:b8:7c:0d:1f:d6:83:
                    1e:b3
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Subject Key Identifier: 
                B5:03:F7:76:3B:61:82:6A:12:AA:18:53:EB:03:21:94:BF:FE:CE:CA
    Signature Algorithm: sha256WithRSAEncryption
         56:3d:ef:94:d5:bd:da:73:b2:58:be:ae:90:ad:98:27:97:fe:
         01:b1:b0:52:00:b8:4d:e4:1b:21:74:1b:7e:c0:ee:5e:69:2a:
         25:af:5c:d6:1d:da:d2:79:c9:f3:97:29:e0:86:87:de:04:59:
         0f:f1:59:d4:64:85:4b:99:af:25:04:1e:c9:46:a9:97:de:82:
         b2:1b:70:9f:9c:f6:af:71:31:dd:7b:05:a5:2c:d3:b9:ca:47:
         f6:ca:f2:f6:e7:ad:b9:48:3f:bc:16:b7:c1:6d:f4:ea:09:af:
         ec:f3:b5:e7:05:9e:a6:1e:8a:53:51:d6:93:81:cc:74:93:f6:
         b9:da:a6:25:05:74:79:5a:7e:40:3e:82:4b:26:11:30:6e:e1:
         3f:41:c7:47:00:35:d5:f5:d3:f7:54:3e:81:3d:da:49:6a:9a:
         b3:ef:10:3d:e6:eb:6f:d1:c8:22:47:cb:cc:cf:01:31:92:d9:
         18:e3:22:be:09:1e:1a:3e:5a:b2:e4:6b:0c:54:7a:7d:43:4e:
         b8:89:a5:7b:d7:a2:3d:96:86:cc:f2:26:34:2d:6a:92:9d:9a:
         1a:d0:30:e2:5d:4e:04:b0:5f:8b:20:7e:77:c1:3d:95:82:d1:
         46:9a:3b:3c:78:b8:6f:a1:d0:0d:64:a2:78:1e:29:4e:93:c3:
         a4:54:14:5b
-----BEGIN CERTIFICATE-----
MIIDwzCCAqugAwIBAgIBATANBgkqhkiG9w0BAQsFADCBgjELMAkGA1UEBhMCREUx
KzApBgNVBAoMIlQtU3lzdGVtcyBFbnRlcnByaXNlIFNlcnZpY2VzIEdtYkgxHzAd
BgNVBAsMFlQtU3lzdGVtcyBUcnVzdCBDZW50ZXIxJTAjBgNVBAMMHFQtVGVsZVNl
YyBHbG9iYWxSb290IENsYXNzIDMwHhcNMDgxMDAxMTAyOTU2WhcNMzMxMDAxMjM1
OTU5WjCBgjELMAkGA1UEBhMCREUxKzApBgNVBAoMIlQtU3lzdGVtcyBFbnRlcnBy
aXNlIFNlcnZpY2VzIEdtYkgxHzAdBgNVBAsMFlQtU3lzdGVtcyBUcnVzdCBDZW50
ZXIxJTAjBgNVBAMMHFQtVGVsZVNlYyBHbG9iYWxSb290IENsYXNzIDMwggEiMA0G
CSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQC9dZPwYiJvJK7genasfb3ZJNW4t/zN
8ELg63iIVl6bmlQdTQyK9tPPcPRStdiTBONGhnFBSivwKixVA9ZIw+A5OO3yXDw/
RLyTPWGrTs0NvvAgJ1gORH8EGoel15YUNpDQSXuhdfsaa3Ox+M6pCSzyU9XDFES4
hqX2iys52qMzVNn6chr3IhUciJFrf2blw2qAsCTz34ZFiP0Zf3WHHx+xGwpzJFu5
ZeAsVMhg02YXP+HMVDNzkQI6pn97djmiH5a2OK61yJN0HZ65tOVgnS9W0eDrXltM
EnAMbEQgqxHY9Bn20pxSN+f6tsIxO0rUFJmtxxr1XV/6B7h8DR/Wgx6zAgMBAAGj
QjBAMA8GA1UdEwEB/wQFMAMBAf8wDgYDVR0PAQH/BAQDAgEGMB0GA1UdDgQWBBS1
A/d2O2GCahKqGFPrAyGUv/7OyjANBgkqhkiG9w0BAQsFAAOCAQEAVj3vlNW92nOy
WL6ukK2YJ5f+AbGwUgC4TeQbIXQbfsDuXmkqJa9c1h3a0nnJ85cp4IaH3gRZD/FZ
1GSFS5mvJQQeyUapl96Cshtwn5z2r3Ex3XsFpSzTucpH9sry9uetuUg/vBa3wW30
6gmv7PO15wWeph6KU1HWk4HMdJP2udqmJQV0eVp+QD6CSyYRMG7hP0HHRwA11fXT
91Q+gT3aSWqas+8QPebrb9HIIkfLzM8BMZLZGOMivgkeGj5asuRrDFR6fUNOuIml
e9eiPZaGzPImNC1qkp2aGtAw4l1OBLBfiyB+d8E9lYLRRpo7PHi4b6HQDWSieB4p
TpPDpFQUWw==
-----END CERTIFICATE-----

D-TRUST Root Class 3 CA 2 2009
=================================================
SHA1 Fingerprint=58:E8:AB:B0:36:15:33:FB:80:F7:9B:1B:6D:29:D3:FF:8D:5F:00:F0
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 623603 (0x983f3)
    Signature Algorithm: sha256WithRSAEncryption
        Issuer: C=DE, O=D-Trust GmbH, CN=D-TRUST Root Class 3 CA 2 2009
        Validity
            Not Before: Nov  5 08:35:58 2009 GMT
            Not After : Nov  5 08:35:58 2029 GMT
        Subject: C=DE, O=D-Trust GmbH, CN=D-TRUST Root Class 3 CA 2 2009
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (2048 bit)
                Modulus:
                    00:d3:b2:4a:cf:7a:47:ef:75:9b:23:fa:3a:2f:d6:
                    50:45:89:35:3a:c6:6b:db:fe:db:00:68:a8:e0:03:
                    11:1d:37:50:08:9f:4d:4a:68:94:35:b3:53:d1:94:
                    63:a7:20:56:af:de:51:78:ec:2a:3d:f3:48:48:50:
                    3e:0a:df:46:55:8b:27:6d:c3:10:4d:0d:91:52:43:
                    d8:87:e0:5d:4e:36:b5:21:ca:5f:39:40:04:5f:5b:
                    7e:cc:a3:c6:2b:a9:40:1e:d9:36:84:d6:48:f3:92:
                    1e:34:46:20:24:c1:a4:51:8e:4a:1a:ef:50:3f:69:
                    5d:19:7f:45:c3:c7:01:8f:51:c9:23:e8:72:ae:b4:
                    bc:56:09:7f:12:cb:1c:b1:af:29:90:0a:c9:55:cc:
                    0f:d3:b4:1a:ed:47:35:5a:4a:ed:9c:73:04:21:d0:
                    aa:bd:0c:13:b5:00:ca:26:6c:c4:6b:0c:94:5a:95:
                    94:da:50:9a:f1:ff:a5:2b:66:31:a4:c9:38:a0:df:
                    1d:1f:b8:09:2e:f3:a7:e8:67:52:ab:95:1f:e0:46:
                    3e:d8:a4:c3:ca:5a:c5:31:80:e8:48:9a:9f:94:69:
                    fe:19:dd:d8:73:7c:81:ca:96:de:8e:ed:b3:32:05:
                    65:84:34:e6:e6:fd:57:10:b5:5f:76:bf:2f:b0:10:
                    0d:c5
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Subject Key Identifier: 
                FD:DA:14:C4:9F:30:DE:21:BD:1E:42:39:FC:AB:63:23:49:E0:F1:84
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 CRL Distribution Points: 

                Full Name:
                  URI:ldap://directory.d-trust.net/CN=D-TRUST%20Root%20Class%203%20CA%202%202009,O=D-Trust%20GmbH,C=DE?certificaterevocationlist

                Full Name:
                  URI:http://www.d-trust.net/crl/d-trust_root_class_3_ca_2_2009.crl

    Signature Algorithm: sha256WithRSAEncryption
         7f:97:db:30:c8:df:a4:9c:7d:21:7a:80:70:ce:14:12:69:88:
         14:95:60:44:01:ac:b2:e9:30:4f:9b:50:c2:66:d8:7e:8d:30:
         b5:70:31:e9:e2:69:c7:f3:70:db:20:15:86:d0:0d:f0:be:ac:
         01:75:84:ce:7e:9f:4d:bf:b7:60:3b:9c:f3:ca:1d:e2:5e:68:
         d8:a3:9d:97:e5:40:60:d2:36:21:fe:d0:b4:b8:17:da:74:a3:
         7f:d4:df:b0:98:02:ac:6f:6b:6b:2c:25:24:72:a1:65:ee:25:
         5a:e5:e6:32:e7:f2:df:ab:49:fa:f3:90:69:23:db:04:d9:e7:
         5c:58:fc:65:d4:97:be:cc:fc:2e:0a:cc:25:2a:35:04:f8:60:
         91:15:75:3d:41:ff:23:1f:19:c8:6c:eb:82:53:04:a6:e4:4c:
         22:4d:8d:8c:ba:ce:5b:73:ec:64:54:50:6d:d1:9c:55:fb:69:
         c3:36:c3:8c:bc:3c:85:a6:6b:0a:26:0d:e0:93:98:60:ae:7e:
         c6:24:97:8a:61:5f:91:8e:66:92:09:87:36:cd:8b:9b:2d:3e:
         f6:51:d4:50:d4:59:28:bd:83:f2:cc:28:7b:53:86:6d:d8:26:
         88:70:d7:ea:91:cd:3e:b9:ca:c0:90:6e:5a:c6:5e:74:65:d7:
         5c:fe:a3:e2
-----BEGIN CERTIFICATE-----
MIIEMzCCAxugAwIBAgIDCYPzMA0GCSqGSIb3DQEBCwUAME0xCzAJBgNVBAYTAkRF
MRUwEwYDVQQKDAxELVRydXN0IEdtYkgxJzAlBgNVBAMMHkQtVFJVU1QgUm9vdCBD
bGFzcyAzIENBIDIgMjAwOTAeFw0wOTExMDUwODM1NThaFw0yOTExMDUwODM1NTha
ME0xCzAJBgNVBAYTAkRFMRUwEwYDVQQKDAxELVRydXN0IEdtYkgxJzAlBgNVBAMM
HkQtVFJVU1QgUm9vdCBDbGFzcyAzIENBIDIgMjAwOTCCASIwDQYJKoZIhvcNAQEB
BQADggEPADCCAQoCggEBANOySs96R+91myP6Oi/WUEWJNTrGa9v+2wBoqOADER03
UAifTUpolDWzU9GUY6cgVq/eUXjsKj3zSEhQPgrfRlWLJ23DEE0NkVJD2IfgXU42
tSHKXzlABF9bfsyjxiupQB7ZNoTWSPOSHjRGICTBpFGOShrvUD9pXRl/RcPHAY9R
ySPocq60vFYJfxLLHLGvKZAKyVXMD9O0Gu1HNVpK7ZxzBCHQqr0ME7UAyiZsxGsM
lFqVlNpQmvH/pStmMaTJOKDfHR+4CS7zp+hnUquVH+BGPtikw8paxTGA6Eian5Rp
/hnd2HN8gcqW3o7tszIFZYQ05ub9VxC1X3a/L7AQDcUCAwEAAaOCARowggEWMA8G
A1UdEwEB/wQFMAMBAf8wHQYDVR0OBBYEFP3aFMSfMN4hvR5COfyrYyNJ4PGEMA4G
A1UdDwEB/wQEAwIBBjCB0wYDVR0fBIHLMIHIMIGAoH6gfIZ6bGRhcDovL2RpcmVj
dG9yeS5kLXRydXN0Lm5ldC9DTj1ELVRSVVNUJTIwUm9vdCUyMENsYXNzJTIwMyUy
MENBJTIwMiUyMDIwMDksTz1ELVRydXN0JTIwR21iSCxDPURFP2NlcnRpZmljYXRl
cmV2b2NhdGlvbmxpc3QwQ6BBoD+GPWh0dHA6Ly93d3cuZC10cnVzdC5uZXQvY3Js
L2QtdHJ1c3Rfcm9vdF9jbGFzc18zX2NhXzJfMjAwOS5jcmwwDQYJKoZIhvcNAQEL
BQADggEBAH+X2zDI36ScfSF6gHDOFBJpiBSVYEQBrLLpME+bUMJm2H6NMLVwMeni
acfzcNsgFYbQDfC+rAF1hM5+n02/t2A7nPPKHeJeaNijnZflQGDSNiH+0LS4F9p0
o3/U37CYAqxva2ssJSRyoWXuJVrl5jLn8t+rSfrzkGkj2wTZ51xY/GXUl77M/C4K
zCUqNQT4YJEVdT1B/yMfGchs64JTBKbkTCJNjYy6zltz7GRUUG3RnFX7acM2w4y8
PIWmawomDeCTmGCufsYkl4phX5GOZpIJhzbNi5stPvZR1FDUWSi9g/LMKHtThm3Y
Johw1+qRzT65ysCQblrGXnRl11z+o+I=
-----END CERTIFICATE-----

D-TRUST Root Class 3 CA 2 EV 2009
=================================================
SHA1 Fingerprint=96:C9:1B:0B:95:B4:10:98:42:FA:D0:D8:22:79:FE:60:FA:B9:16:83
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 623604 (0x983f4)
    Signature Algorithm: sha256WithRSAEncryption
        Issuer: C=DE, O=D-Trust GmbH, CN=D-TRUST Root Class 3 CA 2 EV 2009
        Validity
            Not Before: Nov  5 08:50:46 2009 GMT
            Not After : Nov  5 08:50:46 2029 GMT
        Subject: C=DE, O=D-Trust GmbH, CN=D-TRUST Root Class 3 CA 2 EV 2009
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (2048 bit)
                Modulus:
                    00:99:f1:84:34:70:ba:2f:b7:30:a0:8e:bd:7c:04:
                    cf:be:62:bc:99:fd:82:97:d2:7a:0a:67:96:38:09:
                    f6:10:4e:95:22:73:99:8d:da:15:2d:e7:05:fc:19:
                    73:22:b7:8e:98:00:bc:3c:3d:ac:a1:6c:fb:d6:79:
                    25:4b:ad:f0:cc:64:da:88:3e:29:b8:0f:09:d3:34:
                    dd:33:f5:62:d1:e1:cd:19:e9:ee:18:4f:4c:58:ae:
                    e2:1e:d6:0c:5b:15:5a:d8:3a:b8:c4:18:64:1e:e3:
                    33:b2:b5:89:77:4e:0c:bf:d9:94:6b:13:97:6f:12:
                    a3:fe:99:a9:04:cc:15:ec:60:68:36:ed:08:7b:b7:
                    f5:bf:93:ed:66:31:83:8c:c6:71:34:87:4e:17:ea:
                    af:8b:91:8d:1c:56:41:ae:22:37:5e:37:f2:1d:d9:
                    d1:2d:0d:2f:69:51:a7:be:66:a6:8a:3a:2a:bd:c7:
                    1a:b1:e1:14:f0:be:3a:1d:b9:cf:5b:b1:6a:fe:b4:
                    b1:46:20:a2:fb:1e:3b:70:ef:93:98:7d:8c:73:96:
                    f2:c5:ef:85:70:ad:29:26:fc:1e:04:3e:1c:a0:d8:
                    0f:cb:52:83:62:7c:ee:8b:53:95:90:a9:57:a2:ea:
                    61:05:d8:f9:4d:c4:27:fa:6e:ad:ed:f9:d7:51:f7:
                    6b:a5
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Subject Key Identifier: 
                D3:94:8A:4C:62:13:2A:19:2E:CC:AF:72:8A:7D:36:D7:9A:1C:DC:67
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 CRL Distribution Points: 

                Full Name:
                  URI:ldap://directory.d-trust.net/CN=D-TRUST%20Root%20Class%203%20CA%202%20EV%202009,O=D-Trust%20GmbH,C=DE?certificaterevocationlist

                Full Name:
                  URI:http://www.d-trust.net/crl/d-trust_root_class_3_ca_2_ev_2009.crl

    Signature Algorithm: sha256WithRSAEncryption
         34:ed:7b:5a:3c:a4:94:88:ef:1a:11:75:07:2f:b3:fe:3c:fa:
         1e:51:26:eb:87:f6:29:de:e0:f1:d4:c6:24:09:e9:c1:cf:55:
         1b:b4:30:d9:ce:1a:fe:06:51:a6:15:a4:2d:ef:b2:4b:bf:20:
         28:25:49:d1:a6:36:77:34:e8:64:df:52:b1:11:c7:73:7a:cd:
         39:9e:c2:ad:8c:71:21:f2:5a:6b:af:df:3c:4e:55:af:b2:84:
         65:14:89:b9:77:cb:2a:31:be:cf:a3:6d:cf:6f:48:94:32:46:
         6f:e7:71:8c:a0:a6:84:19:37:07:f2:03:45:09:2b:86:75:7c:
         df:5f:69:57:00:db:6e:d8:a6:72:22:4b:50:d4:75:98:56:df:
         b7:18:ff:43:43:50:ae:7a:44:7b:f0:79:51:d7:43:3d:a7:d3:
         81:d3:f0:c9:4f:b9:da:c6:97:86:d0:82:c3:e4:42:6d:fe:b0:
         e2:64:4e:0e:26:e7:40:34:26:b5:08:89:d7:08:63:63:38:27:
         75:1e:33:ea:6e:a8:dd:9f:99:4f:74:4d:81:89:80:4b:dd:9a:
         97:29:5c:2f:be:81:41:b9:8c:ff:ea:7d:60:06:9e:cd:d7:3d:
         d3:2e:a3:15:bc:a8:e6:26:e5:6f:c3:dc:b8:03:21:ea:9f:16:
         f1:2c:54:b5
-----BEGIN CERTIFICATE-----
MIIEQzCCAyugAwIBAgIDCYP0MA0GCSqGSIb3DQEBCwUAMFAxCzAJBgNVBAYTAkRF
MRUwEwYDVQQKDAxELVRydXN0IEdtYkgxKjAoBgNVBAMMIUQtVFJVU1QgUm9vdCBD
bGFzcyAzIENBIDIgRVYgMjAwOTAeFw0wOTExMDUwODUwNDZaFw0yOTExMDUwODUw
NDZaMFAxCzAJBgNVBAYTAkRFMRUwEwYDVQQKDAxELVRydXN0IEdtYkgxKjAoBgNV
BAMMIUQtVFJVU1QgUm9vdCBDbGFzcyAzIENBIDIgRVYgMjAwOTCCASIwDQYJKoZI
hvcNAQEBBQADggEPADCCAQoCggEBAJnxhDRwui+3MKCOvXwEz75ivJn9gpfSegpn
ljgJ9hBOlSJzmY3aFS3nBfwZcyK3jpgAvDw9rKFs+9Z5JUut8Mxk2og+KbgPCdM0
3TP1YtHhzRnp7hhPTFiu4h7WDFsVWtg6uMQYZB7jM7K1iXdODL/ZlGsTl28So/6Z
qQTMFexgaDbtCHu39b+T7WYxg4zGcTSHThfqr4uRjRxWQa4iN1438h3Z0S0NL2lR
p75mpoo6Kr3HGrHhFPC+Oh25z1uxav60sUYgovseO3Dvk5h9jHOW8sXvhXCtKSb8
HgQ+HKDYD8tSg2J87otTlZCpV6LqYQXY+U3EJ/pure3511H3a6UCAwEAAaOCASQw
ggEgMA8GA1UdEwEB/wQFMAMBAf8wHQYDVR0OBBYEFNOUikxiEyoZLsyvcop9Ntea
HNxnMA4GA1UdDwEB/wQEAwIBBjCB3QYDVR0fBIHVMIHSMIGHoIGEoIGBhn9sZGFw
Oi8vZGlyZWN0b3J5LmQtdHJ1c3QubmV0L0NOPUQtVFJVU1QlMjBSb290JTIwQ2xh
c3MlMjAzJTIwQ0ElMjAyJTIwRVYlMjAyMDA5LE89RC1UcnVzdCUyMEdtYkgsQz1E
RT9jZXJ0aWZpY2F0ZXJldm9jYXRpb25saXN0MEagRKBChkBodHRwOi8vd3d3LmQt
dHJ1c3QubmV0L2NybC9kLXRydXN0X3Jvb3RfY2xhc3NfM19jYV8yX2V2XzIwMDku
Y3JsMA0GCSqGSIb3DQEBCwUAA4IBAQA07XtaPKSUiO8aEXUHL7P+PPoeUSbrh/Yp
3uDx1MYkCenBz1UbtDDZzhr+BlGmFaQt77JLvyAoJUnRpjZ3NOhk31KxEcdzes05
nsKtjHEh8lprr988TlWvsoRlFIm5d8sqMb7Po23Pb0iUMkZv53GMoKaEGTcH8gNF
CSuGdXzfX2lXANtu2KZyIktQ1HWYVt+3GP9DQ1CuekR78HlR10M9p9OB0/DJT7na
xpeG0ILD5EJt/rDiZE4OJudANCa1CInXCGNjOCd1HjPqbqjdn5lPdE2BiYBL3ZqX
KVwvvoFBuYz/6n1gBp7N1z3TLqMVvKjmJuVvw9y4AyHqnxbxLFS1
-----END CERTIFICATE-----

CA Disig Root R2
================================================
SHA1 Fingerprint=B5:61:EB:EA:A4:DE:E4:25:4B:69:1A:98:A5:57:47:C2:34:C7:D9:71
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 10572350602393338211 (0x92b888dbb08ac163)
    Signature Algorithm: sha256WithRSAEncryption
        Issuer: C=SK, L=Bratislava, O=Disig a.s., CN=CA Disig Root R2
        Validity
            Not Before: Jul 19 09:15:30 2012 GMT
            Not After : Jul 19 09:15:30 2042 GMT
        Subject: C=SK, L=Bratislava, O=Disig a.s., CN=CA Disig Root R2
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (4096 bit)
                Modulus:
                    00:a2:a3:c4:00:09:d6:85:5d:2d:6d:14:f6:c2:c3:
                    73:9e:35:c2:71:55:7e:81:fb:ab:46:50:e0:c1:7c:
                    49:78:e6:ab:79:58:3c:da:ff:7c:1c:9f:d8:97:02:
                    78:3e:6b:41:04:e9:41:bd:be:03:2c:45:f6:2f:64:
                    d4:ab:5d:a3:47:3d:64:9b:e9:68:9a:c6:cc:1b:3f:
                    ba:be:b2:8b:34:02:2e:98:55:19:fc:8c:6f:aa:5f:
                    da:4c:ce:4d:03:21:a3:d8:d2:34:93:56:96:cb:4c:
                    0c:00:16:3c:5f:1a:cd:c8:c7:6c:a6:ad:d3:31:a7:
                    bc:e8:e5:e1:66:d6:d2:fb:03:b4:41:65:c9:10:ae:
                    0e:05:63:c6:80:6a:69:30:fd:d2:ee:90:ef:0d:27:
                    df:9f:95:73:f4:e1:25:da:6c:16:de:41:38:34:ea:
                    8b:fc:d1:e8:04:14:61:2d:41:7e:ac:c7:77:4e:cb:
                    51:54:fb:5e:92:18:1b:04:5a:68:c6:c9:c4:fa:b7:
                    13:a0:98:b7:11:2b:b7:d6:57:cc:7c:9e:17:d1:cb:
                    25:fe:86:4e:24:2e:56:0c:78:4d:9e:01:12:a6:2b:
                    a7:01:65:6e:7c:62:1d:84:84:df:ea:c0:6b:b5:a5:
                    2a:95:83:c3:53:11:0c:73:1d:0b:b2:46:90:d1:42:
                    3a:ce:40:6e:95:ad:ff:c6:94:ad:6e:97:84:8e:7d:
                    6f:9e:8a:80:0d:49:6d:73:e2:7b:92:1e:c3:f3:c1:
                    f3:eb:2e:05:6f:d9:1b:cf:37:76:04:c8:b4:5a:e4:
                    17:a7:cb:dd:76:1f:d0:19:76:e8:2c:05:b3:d6:9c:
                    34:d8:96:dc:61:87:91:05:e4:44:08:33:c1:da:b9:
                    08:65:d4:ae:b2:36:0d:eb:ba:38:ba:0c:e5:9b:9e:
                    eb:8d:66:dd:99:cf:d6:89:41:f6:04:92:8a:29:29:
                    6d:6b:3a:1c:e7:75:7d:02:71:0e:f3:c0:e7:bd:cb:
                    19:dd:9d:60:b2:c2:66:60:b6:b1:04:ee:c9:e6:86:
                    b9:9a:66:40:a8:e7:11:ed:81:45:03:8b:f6:67:59:
                    e8:c1:06:11:bd:dd:cf:80:02:4f:65:40:78:5c:47:
                    50:c8:9b:e6:1f:81:7b:e4:44:a8:5b:85:9a:e2:de:
                    5a:d5:c7:f9:3a:44:66:4b:e4:32:54:7c:e4:6c:9c:
                    b3:0e:3d:17:a2:b2:34:12:d6:7e:b2:a8:49:bb:d1:
                    7a:28:40:be:a2:16:1f:df:e4:37:1f:11:73:fb:90:
                    0a:65:43:a2:0d:7c:f8:06:01:55:33:7d:b0:0d:b8:
                    f4:f5:ae:a5:42:57:7c:36:11:8c:7b:5e:c4:03:9d:
                    8c:79:9d
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Subject Key Identifier: 
                B5:99:F8:AF:B0:94:F5:E3:20:D6:0A:AD:CE:4E:56:A4:2E:6E:42:ED
    Signature Algorithm: sha256WithRSAEncryption
         26:06:5e:70:e7:65:33:c8:82:6e:d9:9c:17:3a:1b:7a:66:b2:
         01:f6:78:3b:69:5e:2f:ea:ff:4e:f9:28:c3:98:2a:61:4c:b4:
         24:12:8a:7d:6d:11:14:f7:9c:b5:ca:e6:bc:9e:27:8e:4c:19:
         c8:a9:bd:7a:c0:d7:36:0e:6d:85:72:6e:a8:c6:a2:6d:f6:fa:
         73:63:7f:bc:6e:79:08:1c:9d:8a:9f:1a:8a:53:a6:d8:bb:d9:
         35:55:b1:11:c5:a9:03:b3:56:3b:b9:84:93:22:5e:7e:c1:f6:
         12:52:8b:ea:2c:67:bc:fe:36:4c:f5:b8:cf:d1:b3:49:92:3b:
         d3:29:0e:99:1b:96:f7:61:b8:3b:c4:2b:b6:78:6c:b4:23:6f:
         f0:fd:d3:b2:5e:75:1f:99:95:a8:ac:f6:da:e1:c5:31:7b:fb:
         d1:46:b3:d2:bc:67:b4:62:54:ba:09:f7:63:b0:93:a2:9a:f9:
         e9:52:2e:8b:60:12:ab:fc:f5:60:56:ef:10:5c:8b:c4:1a:42:
         dc:83:5b:64:0e:cb:b5:bc:d6:4f:c1:7c:3c:6e:8d:13:6d:fb:
         7b:eb:30:d0:dc:4d:af:c5:d5:b6:a5:4c:5b:71:c9:e8:31:be:
         e8:38:06:48:a1:1a:e2:ea:d2:de:12:39:58:1a:ff:80:0e:82:
         75:e6:b7:c9:07:6c:0e:ef:ff:38:f1:98:71:c4:b7:7f:0e:15:
         d0:25:69:bd:22:9d:2b:ed:05:f6:46:47:ac:ed:c0:f0:d4:3b:
         e2:ec:ee:96:5b:90:13:4e:1e:56:3a:eb:b0:ef:96:bb:96:23:
         11:ba:f2:43:86:74:64:95:c8:28:75:df:1d:35:ba:d2:37:83:
         38:53:38:36:3b:cf:6c:e9:f9:6b:0e:d0:fb:04:e8:4f:77:d7:
         65:01:78:86:0c:7a:3e:21:62:f1:7f:63:71:0c:c9:9f:44:db:
         a8:27:a2:75:be:6e:81:3e:d7:c0:eb:1b:98:0f:70:5c:34:b2:
         8a:cc:c0:85:18:eb:6e:7a:b3:f7:5a:a1:07:bf:a9:42:92:f3:
         60:22:97:e4:14:a1:07:9b:4e:76:c0:8e:7d:fd:a4:25:c7:47:
         ed:ff:1f:73:ac:cc:c3:a5:e9:6f:0a:8e:9b:65:c2:50:85:b5:
         a3:a0:53:12:cc:55:87:61:f3:81:ae:10:46:61:bd:44:21:b8:
         c2:3d:74:cf:7e:24:35:fa:1c:07:0e:9b:3d:22:ca:ef:31:2f:
         8c:ac:12:bd:ef:40:28:fc:29:67:9f:b2:13:4f:66:24:c4:53:
         19:e9:1e:29:15:ef:e6:6d:b0:7f:2d:67:fd:f3:6c:1b:75:46:
         a3:e5:4a:17:e9:a4:d7:0b
-----BEGIN CERTIFICATE-----
MIIFaTCCA1GgAwIBAgIJAJK4iNuwisFjMA0GCSqGSIb3DQEBCwUAMFIxCzAJBgNV
BAYTAlNLMRMwEQYDVQQHEwpCcmF0aXNsYXZhMRMwEQYDVQQKEwpEaXNpZyBhLnMu
MRkwFwYDVQQDExBDQSBEaXNpZyBSb290IFIyMB4XDTEyMDcxOTA5MTUzMFoXDTQy
MDcxOTA5MTUzMFowUjELMAkGA1UEBhMCU0sxEzARBgNVBAcTCkJyYXRpc2xhdmEx
EzARBgNVBAoTCkRpc2lnIGEucy4xGTAXBgNVBAMTEENBIERpc2lnIFJvb3QgUjIw
ggIiMA0GCSqGSIb3DQEBAQUAA4ICDwAwggIKAoICAQCio8QACdaFXS1tFPbCw3Oe
NcJxVX6B+6tGUODBfEl45qt5WDza/3wcn9iXAng+a0EE6UG9vgMsRfYvZNSrXaNH
PWSb6WiaxswbP7q+sos0Ai6YVRn8jG+qX9pMzk0DIaPY0jSTVpbLTAwAFjxfGs3I
x2ymrdMxp7zo5eFm1tL7A7RBZckQrg4FY8aAamkw/dLukO8NJ9+flXP04SXabBbe
QTg06ov80egEFGEtQX6sx3dOy1FU+16SGBsEWmjGycT6txOgmLcRK7fWV8x8nhfR
yyX+hk4kLlYMeE2eARKmK6cBZW58Yh2EhN/qwGu1pSqVg8NTEQxzHQuyRpDRQjrO
QG6Vrf/GlK1ul4SOfW+eioANSW1z4nuSHsPzwfPrLgVv2RvPN3YEyLRa5Beny912
H9AZdugsBbPWnDTYltxhh5EF5EQIM8HauQhl1K6yNg3ruji6DOWbnuuNZt2Zz9aJ
QfYEkoopKW1rOhzndX0CcQ7zwOe9yxndnWCywmZgtrEE7snmhrmaZkCo5xHtgUUD
i/ZnWejBBhG93c+AAk9lQHhcR1DIm+YfgXvkRKhbhZri3lrVx/k6RGZL5DJUfORs
nLMOPReisjQS1n6yqEm70XooQL6iFh/f5DcfEXP7kAplQ6INfPgGAVUzfbANuPT1
rqVCV3w2EYx7XsQDnYx5nQIDAQABo0IwQDAPBgNVHRMBAf8EBTADAQH/MA4GA1Ud
DwEB/wQEAwIBBjAdBgNVHQ4EFgQUtZn4r7CU9eMg1gqtzk5WpC5uQu0wDQYJKoZI
hvcNAQELBQADggIBACYGXnDnZTPIgm7ZnBc6G3pmsgH2eDtpXi/q/075KMOYKmFM
tCQSin1tERT3nLXK5ryeJ45MGcipvXrA1zYObYVybqjGom32+nNjf7xueQgcnYqf
GopTpti72TVVsRHFqQOzVju5hJMiXn7B9hJSi+osZ7z+Nkz1uM/Rs0mSO9MpDpkb
lvdhuDvEK7Z4bLQjb/D907JedR+Zlais9trhxTF7+9FGs9K8Z7RiVLoJ92Owk6Ka
+elSLotgEqv89WBW7xBci8QaQtyDW2QOy7W81k/BfDxujRNt+3vrMNDcTa/F1bal
TFtxyegxvug4BkihGuLq0t4SOVga/4AOgnXmt8kHbA7v/zjxmHHEt38OFdAlab0i
nSvtBfZGR6ztwPDUO+Ls7pZbkBNOHlY667DvlruWIxG68kOGdGSVyCh13x01utI3
gzhTODY7z2zp+WsO0PsE6E9312UBeIYMej4hYvF/Y3EMyZ9E26gnonW+boE+18Dr
G5gPcFw0sorMwIUY6256s/daoQe/qUKS82Ail+QUoQebTnbAjn39pCXHR+3/H3Os
zMOl6W8KjptlwlCFtaOgUxLMVYdh84GuEEZhvUQhuMI9dM9+JDX6HAcOmz0iyu8x
L4ysEr3vQCj8KWefshNPZiTEUxnpHikV7+ZtsH8tZ/3zbBt1RqPlShfppNcL
-----END CERTIFICATE-----

ACCVRAIZ1
================================================
SHA1 Fingerprint=93:05:7A:88:15:C6:4F:CE:88:2F:FA:91:16:52:28:78:BC:53:64:17
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 6828503384748696800 (0x5ec3b7a6437fa4e0)
    Signature Algorithm: sha1WithRSAEncryption
        Issuer: CN=ACCVRAIZ1, OU=PKIACCV, O=ACCV, C=ES
        Validity
            Not Before: May  5 09:37:37 2011 GMT
            Not After : Dec 31 09:37:37 2030 GMT
        Subject: CN=ACCVRAIZ1, OU=PKIACCV, O=ACCV, C=ES
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (4096 bit)
                Modulus:
                    00:9b:a9:ab:bf:61:4a:97:af:2f:97:66:9a:74:5f:
                    d0:d9:96:fd:cf:e2:e4:66:ef:1f:1f:47:33:c2:44:
                    a3:df:9a:de:1f:b5:54:dd:15:7c:69:35:11:6f:bb:
                    c8:0c:8e:6a:18:1e:d8:8f:d9:16:bc:10:48:36:5c:
                    f0:63:b3:90:5a:5c:24:37:d7:a3:d6:cb:09:71:b9:
                    f1:01:72:84:b0:7d:db:4d:80:cd:fc:d3:6f:c9:f8:
                    da:b6:0e:82:d2:45:85:a8:1b:68:a8:3d:e8:f4:44:
                    6c:bd:a1:c2:cb:03:be:8c:3e:13:00:84:df:4a:48:
                    c0:e3:22:0a:e8:e9:37:a7:18:4c:b1:09:0d:23:56:
                    7f:04:4d:d9:17:84:18:a5:c8:da:40:94:73:eb:ce:
                    0e:57:3c:03:81:3a:9d:0a:a1:57:43:69:ac:57:6d:
                    79:90:78:e5:b5:b4:3b:d8:bc:4c:8d:28:a1:a7:a3:
                    a7:ba:02:4e:25:d1:2a:ae:ed:ae:03:22:b8:6b:20:
                    0f:30:28:54:95:7f:e0:ee:ce:0a:66:9d:d1:40:2d:
                    6e:22:af:9d:1a:c1:05:19:d2:6f:c0:f2:9f:f8:7b:
                    b3:02:42:fb:50:a9:1d:2d:93:0f:23:ab:c6:c1:0f:
                    92:ff:d0:a2:15:f5:53:09:71:1c:ff:45:13:84:e6:
                    26:5e:f8:e0:88:1c:0a:fc:16:b6:a8:73:06:b8:f0:
                    63:84:02:a0:c6:5a:ec:e7:74:df:70:ae:a3:83:25:
                    ea:d6:c7:97:87:93:a7:c6:8a:8a:33:97:60:37:10:
                    3e:97:3e:6e:29:15:d6:a1:0f:d1:88:2c:12:9f:6f:
                    aa:a4:c6:42:eb:41:a2:e3:95:43:d3:01:85:6d:8e:
                    bb:3b:f3:23:36:c7:fe:3b:e0:a1:25:07:48:ab:c9:
                    89:74:ff:08:8f:80:bf:c0:96:65:f3:ee:ec:4b:68:
                    bd:9d:88:c3:31:b3:40:f1:e8:cf:f6:38:bb:9c:e4:
                    d1:7f:d4:e5:58:9b:7c:fa:d4:f3:0e:9b:75:91:e4:
                    ba:52:2e:19:7e:d1:f5:cd:5a:19:fc:ba:06:f6:fb:
                    52:a8:4b:99:04:dd:f8:f9:b4:8b:50:a3:4e:62:89:
                    f0:87:24:fa:83:42:c1:87:fa:d5:2d:29:2a:5a:71:
                    7a:64:6a:d7:27:60:63:0d:db:ce:49:f5:8d:1f:90:
                    89:32:17:f8:73:43:b8:d2:5a:93:86:61:d6:e1:75:
                    0a:ea:79:66:76:88:4f:71:eb:04:25:d6:0a:5a:7a:
                    93:e5:b9:4b:17:40:0f:b1:b6:b9:f5:de:4f:dc:e0:
                    b3:ac:3b:11:70:60:84:4a:43:6e:99:20:c0:29:71:
                    0a:c0:65
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            Authority Information Access: 
                CA Issuers - URI:http://www.accv.es/fileadmin/Archivos/certificados/raizaccv1.crt
                OCSP - URI:http://ocsp.accv.es

            X509v3 Subject Key Identifier: 
                D2:87:B4:E3:DF:37:27:93:55:F6:56:EA:81:E5:36:CC:8C:1E:3F:BD
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Authority Key Identifier: 
                keyid:D2:87:B4:E3:DF:37:27:93:55:F6:56:EA:81:E5:36:CC:8C:1E:3F:BD

            X509v3 Certificate Policies: 
                Policy: X509v3 Any Policy
                  User Notice:
                    Explicit Text: 
                  CPS: http://www.accv.es/legislacion_c.htm

            X509v3 CRL Distribution Points: 

                Full Name:
                  URI:http://www.accv.es/fileadmin/Archivos/certificados/raizaccv1_der.crl

            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Subject Alternative Name: 
                email:accv@accv.es
    Signature Algorithm: sha1WithRSAEncryption
         97:31:02:9f:e7:fd:43:67:48:44:14:e4:29:87:ed:4c:28:66:
         d0:8f:35:da:4d:61:b7:4a:97:4d:b5:db:90:e0:05:2e:0e:c6:
         79:d0:f2:97:69:0f:bd:04:47:d9:be:db:b5:29:da:9b:d9:ae:
         a9:99:d5:d3:3c:30:93:f5:8d:a1:a8:fc:06:8d:44:f4:ca:16:
         95:7c:33:dc:62:8b:a8:37:f8:27:d8:09:2d:1b:ef:c8:14:27:
         20:a9:64:44:ff:2e:d6:75:aa:6c:4d:60:40:19:49:43:54:63:
         da:e2:cc:ba:66:e5:4f:44:7a:5b:d9:6a:81:2b:40:d5:7f:f9:
         01:27:58:2c:c8:ed:48:91:7c:3f:a6:00:cf:c4:29:73:11:36:
         de:86:19:3e:9d:ee:19:8a:1b:d5:b0:ed:8e:3d:9c:2a:c0:0d:
         d8:3d:66:e3:3c:0d:bd:d5:94:5c:e2:e2:a7:35:1b:04:00:f6:
         3f:5a:8d:ea:43:bd:5f:89:1d:a9:c1:b0:cc:99:e2:4d:00:0a:
         da:c9:27:5b:e7:13:90:5c:e4:f5:33:a2:55:6d:dc:e0:09:4d:
         2f:b1:26:5b:27:75:00:09:c4:62:77:29:08:5f:9e:59:ac:b6:
         7e:ad:9f:54:30:22:03:c1:1e:71:64:fe:f9:38:0a:96:18:dd:
         02:14:ac:23:cb:06:1c:1e:a4:7d:8d:0d:de:27:41:e8:ad:da:
         15:b7:b0:23:dd:2b:a8:d3:da:25:87:ed:e8:55:44:4d:88:f4:
         36:7e:84:9a:78:ac:f7:0e:56:49:0e:d6:33:25:d6:84:50:42:
         6c:20:12:1d:2a:d5:be:bc:f2:70:81:a4:70:60:be:05:b5:9b:
         9e:04:44:be:61:23:ac:e9:a5:24:8c:11:80:94:5a:a2:a2:b9:
         49:d2:c1:dc:d1:a7:ed:31:11:2c:9e:19:a6:ee:e1:55:e1:c0:
         ea:cf:0d:84:e4:17:b7:a2:7c:a5:de:55:25:06:ee:cc:c0:87:
         5c:40:da:cc:95:3f:55:e0:35:c7:b8:84:be:b4:5d:cd:7a:83:
         01:72:ee:87:e6:5f:1d:ae:b5:85:c6:26:df:e6:c1:9a:e9:1e:
         02:47:9f:2a:a8:6d:a9:5b:cf:ec:45:77:7f:98:27:9a:32:5d:
         2a:e3:84:ee:c5:98:66:2f:96:20:1d:dd:d8:c3:27:d7:b0:f9:
         fe:d9:7d:cd:d0:9f:8f:0b:14:58:51:9f:2f:8b:c3:38:2d:de:
         e8:8f:d6:8d:87:a4:f5:56:43:16:99:2c:f4:a4:56:b4:34:b8:
         61:37:c9:c2:58:80:1b:a0:97:a1:fc:59:8d:e9:11:f6:d1:0f:
         4b:55:34:46:2a:8b:86:3b
-----BEGIN CERTIFICATE-----
MIIH0zCCBbugAwIBAgIIXsO3pkN/pOAwDQYJKoZIhvcNAQEFBQAwQjESMBAGA1UE
AwwJQUNDVlJBSVoxMRAwDgYDVQQLDAdQS0lBQ0NWMQ0wCwYDVQQKDARBQ0NWMQsw
CQYDVQQGEwJFUzAeFw0xMTA1MDUwOTM3MzdaFw0zMDEyMzEwOTM3MzdaMEIxEjAQ
BgNVBAMMCUFDQ1ZSQUlaMTEQMA4GA1UECwwHUEtJQUNDVjENMAsGA1UECgwEQUND
VjELMAkGA1UEBhMCRVMwggIiMA0GCSqGSIb3DQEBAQUAA4ICDwAwggIKAoICAQCb
qau/YUqXry+XZpp0X9DZlv3P4uRm7x8fRzPCRKPfmt4ftVTdFXxpNRFvu8gMjmoY
HtiP2Ra8EEg2XPBjs5BaXCQ316PWywlxufEBcoSwfdtNgM3802/J+Nq2DoLSRYWo
G2ioPej0RGy9ocLLA76MPhMAhN9KSMDjIgro6TenGEyxCQ0jVn8ETdkXhBilyNpA
lHPrzg5XPAOBOp0KoVdDaaxXbXmQeOW1tDvYvEyNKKGno6e6Ak4l0Squ7a4DIrhr
IA8wKFSVf+DuzgpmndFALW4ir50awQUZ0m/A8p/4e7MCQvtQqR0tkw8jq8bBD5L/
0KIV9VMJcRz/RROE5iZe+OCIHAr8Fraocwa48GOEAqDGWuzndN9wrqODJerWx5eH
k6fGioozl2A3ED6XPm4pFdahD9GILBKfb6qkxkLrQaLjlUPTAYVtjrs78yM2x/47
4KElB0iryYl0/wiPgL/AlmXz7uxLaL2diMMxs0Dx6M/2OLuc5NF/1OVYm3z61PMO
m3WR5LpSLhl+0fXNWhn8ugb2+1KoS5kE3fj5tItQo05iifCHJPqDQsGH+tUtKSpa
cXpkatcnYGMN285J9Y0fkIkyF/hzQ7jSWpOGYdbhdQrqeWZ2iE9x6wQl1gpaepPl
uUsXQA+xtrn13k/c4LOsOxFwYIRKQ26ZIMApcQrAZQIDAQABo4ICyzCCAscwfQYI
KwYBBQUHAQEEcTBvMEwGCCsGAQUFBzAChkBodHRwOi8vd3d3LmFjY3YuZXMvZmls
ZWFkbWluL0FyY2hpdm9zL2NlcnRpZmljYWRvcy9yYWl6YWNjdjEuY3J0MB8GCCsG
AQUFBzABhhNodHRwOi8vb2NzcC5hY2N2LmVzMB0GA1UdDgQWBBTSh7Tj3zcnk1X2
VuqB5TbMjB4/vTAPBgNVHRMBAf8EBTADAQH/MB8GA1UdIwQYMBaAFNKHtOPfNyeT
VfZW6oHlNsyMHj+9MIIBcwYDVR0gBIIBajCCAWYwggFiBgRVHSAAMIIBWDCCASIG
CCsGAQUFBwICMIIBFB6CARAAQQB1AHQAbwByAGkAZABhAGQAIABkAGUAIABDAGUA
cgB0AGkAZgBpAGMAYQBjAGkA8wBuACAAUgBhAO0AegAgAGQAZQAgAGwAYQAgAEEA
QwBDAFYAIAAoAEEAZwBlAG4AYwBpAGEAIABkAGUAIABUAGUAYwBuAG8AbABvAGcA
7QBhACAAeQAgAEMAZQByAHQAaQBmAGkAYwBhAGMAaQDzAG4AIABFAGwAZQBjAHQA
cgDzAG4AaQBjAGEALAAgAEMASQBGACAAUQA0ADYAMAAxADEANQA2AEUAKQAuACAA
QwBQAFMAIABlAG4AIABoAHQAdABwADoALwAvAHcAdwB3AC4AYQBjAGMAdgAuAGUA
czAwBggrBgEFBQcCARYkaHR0cDovL3d3dy5hY2N2LmVzL2xlZ2lzbGFjaW9uX2Mu
aHRtMFUGA1UdHwROMEwwSqBIoEaGRGh0dHA6Ly93d3cuYWNjdi5lcy9maWxlYWRt
aW4vQXJjaGl2b3MvY2VydGlmaWNhZG9zL3JhaXphY2N2MV9kZXIuY3JsMA4GA1Ud
DwEB/wQEAwIBBjAXBgNVHREEEDAOgQxhY2N2QGFjY3YuZXMwDQYJKoZIhvcNAQEF
BQADggIBAJcxAp/n/UNnSEQU5CmH7UwoZtCPNdpNYbdKl02125DgBS4OxnnQ8pdp
D70ER9m+27Up2pvZrqmZ1dM8MJP1jaGo/AaNRPTKFpV8M9xii6g3+CfYCS0b78gU
JyCpZET/LtZ1qmxNYEAZSUNUY9rizLpm5U9EelvZaoErQNV/+QEnWCzI7UiRfD+m
AM/EKXMRNt6GGT6d7hmKG9Ww7Y49nCrADdg9ZuM8Db3VlFzi4qc1GwQA9j9ajepD
vV+JHanBsMyZ4k0ACtrJJ1vnE5Bc5PUzolVt3OAJTS+xJlsndQAJxGJ3KQhfnlms
tn6tn1QwIgPBHnFk/vk4CpYY3QIUrCPLBhwepH2NDd4nQeit2hW3sCPdK6jT2iWH
7ehVRE2I9DZ+hJp4rPcOVkkO1jMl1oRQQmwgEh0q1b688nCBpHBgvgW1m54ERL5h
I6zppSSMEYCUWqKiuUnSwdzRp+0xESyeGabu4VXhwOrPDYTkF7eifKXeVSUG7szA
h1xA2syVP1XgNce4hL60Xc16gwFy7ofmXx2utYXGJt/mwZrpHgJHnyqobalbz+xF
d3+YJ5oyXSrjhO7FmGYvliAd3djDJ9ew+f7Zfc3Qn48LFFhRny+Lwzgt3uiP1o2H
pPVWQxaZLPSkVrQ0uGE3ycJYgBugl6H8WY3pEfbRD0tVNEYqi4Y7
-----END CERTIFICATE-----

TWCA Global Root CA
================================================
SHA1 Fingerprint=9C:BB:48:53:F6:A4:F6:D3:52:A4:E8:32:52:55:60:13:F5:AD:AF:65
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 3262 (0xcbe)
    Signature Algorithm: sha256WithRSAEncryption
        Issuer: C=TW, O=TAIWAN-CA, OU=Root CA, CN=TWCA Global Root CA
        Validity
            Not Before: Jun 27 06:28:33 2012 GMT
            Not After : Dec 31 15:59:59 2030 GMT
        Subject: C=TW, O=TAIWAN-CA, OU=Root CA, CN=TWCA Global Root CA
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (4096 bit)
                Modulus:
                    00:b0:05:db:c8:eb:8c:c4:6e:8a:21:ef:8e:4d:9c:
                    71:0a:1f:52:70:ed:6d:82:9c:97:c5:d7:4c:4e:45:
                    49:cb:40:42:b5:12:34:6c:19:c2:74:a4:31:5f:85:
                    02:97:ec:43:33:0a:53:d2:9c:8c:8e:b7:b8:79:db:
                    2b:d5:6a:f2:8e:66:c4:ee:2b:01:07:92:d4:b3:d0:
                    02:df:50:f6:55:af:66:0e:cb:e0:47:60:2f:2b:32:
                    39:35:52:3a:28:83:f8:7b:16:c6:18:b8:62:d6:47:
                    25:91:ce:f0:19:12:4d:ad:63:f5:d3:3f:75:5f:29:
                    f0:a1:30:1c:2a:a0:98:a6:15:bd:ee:fd:19:36:f0:
                    e2:91:43:8f:fa:ca:d6:10:27:49:4c:ef:dd:c1:f1:
                    85:70:9b:ca:ea:a8:5a:43:fc:6d:86:6f:73:e9:37:
                    45:a9:f0:36:c7:cc:88:75:1e:bb:6c:06:ff:9b:6b:
                    3e:17:ec:61:aa:71:7c:c6:1d:a2:f7:49:e9:15:b5:
                    3c:d6:a1:61:f5:11:f7:05:6f:1d:fd:11:be:d0:30:
                    07:c2:29:b0:09:4e:26:dc:e3:a2:a8:91:6a:1f:c2:
                    91:45:88:5c:e5:98:b8:71:a5:15:19:c9:7c:75:11:
                    cc:70:74:4f:2d:9b:1d:91:44:fd:56:28:a0:fe:bb:
                    86:6a:c8:fa:5c:0b:58:dc:c6:4b:76:c8:ab:22:d9:
                    73:0f:a5:f4:5a:02:89:3f:4f:9e:22:82:ee:a2:74:
                    53:2a:3d:53:27:69:1d:6c:8e:32:2c:64:00:26:63:
                    61:36:4e:a3:46:b7:3f:7d:b3:2d:ac:6d:90:a2:95:
                    a2:ce:cf:da:82:e7:07:34:19:96:e9:b8:21:aa:29:
                    7e:a6:38:be:8e:29:4a:21:66:79:1f:b3:c3:b5:09:
                    67:de:d6:d4:07:46:f3:2a:da:e6:22:37:60:cb:81:
                    b6:0f:a0:0f:e9:c8:95:7f:bf:55:91:05:7a:cf:3d:
                    15:c0:6f:de:09:94:01:83:d7:34:1b:cc:40:a5:f0:
                    b8:9b:67:d5:98:91:3b:a7:84:78:95:26:a4:5a:08:
                    f8:2b:74:b4:00:04:3c:df:b8:14:8e:e8:df:a9:8d:
                    6c:67:92:33:1d:c0:b7:d2:ec:92:c8:be:09:bf:2c:
                    29:05:6f:02:6b:9e:ef:bc:bf:2a:bc:5b:c0:50:8f:
                    41:70:71:87:b2:4d:b7:04:a9:84:a3:32:af:ae:ee:
                    6b:17:8b:b2:b1:fe:6c:e1:90:8c:88:a8:97:48:ce:
                    c8:4d:cb:f3:06:cf:5f:6a:0a:42:b1:1e:1e:77:2f:
                    8e:a0:e6:92:0e:06:fc:05:22:d2:26:e1:31:51:7d:
                    32:dc:0f
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
    Signature Algorithm: sha256WithRSAEncryption
         5f:34:81:76:ef:96:1d:d5:e5:b5:d9:02:63:84:16:c1:ae:a0:
         70:51:a7:f7:4c:47:35:c8:0b:d7:28:3d:89:71:d9:aa:33:41:
         ea:14:1b:6c:21:00:c0:6c:42:19:7e:9f:69:5b:20:42:df:a2:
         d2:da:c4:7c:97:4b:8d:b0:e8:ac:c8:ee:a5:69:04:99:0a:92:
         a6:ab:27:2e:1a:4d:81:bf:84:d4:70:1e:ad:47:fe:fd:4a:9d:
         33:e0:f2:b9:c4:45:08:21:0a:da:69:69:73:72:0d:be:34:fe:
         94:8b:ad:c3:1e:35:d7:a2:83:ef:e5:38:c7:a5:85:1f:ab:cf:
         34:ec:3f:28:fe:0c:f1:57:86:4e:c9:55:f7:1c:d4:d8:a5:7d:
         06:7a:6f:d5:df:10:df:81:4e:21:65:b1:b6:e1:17:79:95:45:
         06:ce:5f:cc:dc:46:89:63:68:44:8d:93:f4:64:70:a0:3d:9d:
         28:05:c3:39:70:b8:62:7b:20:fd:e4:db:e9:08:a1:b8:9e:3d:
         09:c7:4f:fb:2c:f8:93:76:41:de:52:e0:e1:57:d2:9d:03:bc:
         77:9e:fe:9e:29:5e:f7:c1:51:60:1f:de:da:0b:b2:2d:75:b7:
         43:48:93:e7:f6:79:c6:84:5d:80:59:60:94:fc:78:98:8f:3c:
         93:51:ed:40:90:07:df:64:63:24:cb:4e:71:05:a1:d7:94:1a:
         88:32:f1:22:74:22:ae:a5:a6:d8:12:69:4c:60:a3:02:ee:2b:
         ec:d4:63:92:0b:5e:be:2f:76:6b:a3:b6:26:bc:8f:03:d8:0a:
         f2:4c:64:46:bd:39:62:e5:96:eb:34:63:11:28:cc:95:f1:ad:
         ef:ef:dc:80:58:48:e9:4b:b8:ea:65:ac:e9:fc:80:b5:b5:c8:
         45:f9:ac:c1:9f:d9:b9:ea:62:88:8e:c4:f1:4b:83:12:ad:e6:
         8b:84:d6:9e:c2:eb:83:18:9f:6a:bb:1b:24:60:33:70:cc:ec:
         f7:32:f3:5c:d9:79:7d:ef:9e:a4:fe:c9:23:c3:24:ee:15:92:
         b1:3d:91:4f:26:86:bd:66:73:24:13:ea:a4:ae:63:c1:ad:7d:
         84:03:3c:10:78:86:1b:79:e3:c4:f3:f2:04:95:20:ae:23:82:
         c4:b3:3a:00:62:bf:e6:36:24:e1:57:ba:c7:1e:90:75:d5:5f:
         3f:95:61:2b:c1:3b:cd:e5:b3:68:61:d0:46:26:a9:21:52:69:
         2d:eb:2e:c7:eb:77:ce:a6:3a:b5:03:33:4f:76:d1:e7:5c:54:
         01:5d:cb:78:f4:c9:0c:bf:cf:12:8e:17:2d:23:68:94:e7:ab:
         fe:a9:b2:2b:06:d0:04:cd
-----BEGIN CERTIFICATE-----
MIIFQTCCAymgAwIBAgICDL4wDQYJKoZIhvcNAQELBQAwUTELMAkGA1UEBhMCVFcx
EjAQBgNVBAoTCVRBSVdBTi1DQTEQMA4GA1UECxMHUm9vdCBDQTEcMBoGA1UEAxMT
VFdDQSBHbG9iYWwgUm9vdCBDQTAeFw0xMjA2MjcwNjI4MzNaFw0zMDEyMzExNTU5
NTlaMFExCzAJBgNVBAYTAlRXMRIwEAYDVQQKEwlUQUlXQU4tQ0ExEDAOBgNVBAsT
B1Jvb3QgQ0ExHDAaBgNVBAMTE1RXQ0EgR2xvYmFsIFJvb3QgQ0EwggIiMA0GCSqG
SIb3DQEBAQUAA4ICDwAwggIKAoICAQCwBdvI64zEbooh745NnHEKH1Jw7W2CnJfF
10xORUnLQEK1EjRsGcJ0pDFfhQKX7EMzClPSnIyOt7h52yvVavKOZsTuKwEHktSz
0ALfUPZVr2YOy+BHYC8rMjk1Ujoog/h7FsYYuGLWRyWRzvAZEk2tY/XTP3VfKfCh
MBwqoJimFb3u/Rk28OKRQ4/6ytYQJ0lM793B8YVwm8rqqFpD/G2Gb3PpN0Wp8DbH
zIh1HrtsBv+baz4X7GGqcXzGHaL3SekVtTzWoWH1EfcFbx39Eb7QMAfCKbAJTibc
46KokWofwpFFiFzlmLhxpRUZyXx1EcxwdE8tmx2RRP1WKKD+u4ZqyPpcC1jcxkt2
yKsi2XMPpfRaAok/T54igu6idFMqPVMnaR1sjjIsZAAmY2E2TqNGtz99sy2sbZCi
laLOz9qC5wc0GZbpuCGqKX6mOL6OKUohZnkfs8O1CWfe1tQHRvMq2uYiN2DLgbYP
oA/pyJV/v1WRBXrPPRXAb94JlAGD1zQbzECl8LibZ9WYkTunhHiVJqRaCPgrdLQA
BDzfuBSO6N+pjWxnkjMdwLfS7JLIvgm/LCkFbwJrnu+8vyq8W8BQj0FwcYeyTbcE
qYSjMq+u7msXi7Kx/mzhkIyIqJdIzshNy/MGz19qCkKxHh53L46g5pIOBvwFItIm
4TFRfTLcDwIDAQABoyMwITAOBgNVHQ8BAf8EBAMCAQYwDwYDVR0TAQH/BAUwAwEB
/zANBgkqhkiG9w0BAQsFAAOCAgEAXzSBdu+WHdXltdkCY4QWwa6gcFGn90xHNcgL
1yg9iXHZqjNB6hQbbCEAwGxCGX6faVsgQt+i0trEfJdLjbDorMjupWkEmQqSpqsn
LhpNgb+E1HAerUf+/UqdM+DyucRFCCEK2mlpc3INvjT+lIutwx4116KD7+U4x6WF
H6vPNOw/KP4M8VeGTslV9xzU2KV9Bnpv1d8Q34FOIWWxtuEXeZVFBs5fzNxGiWNo
RI2T9GRwoD2dKAXDOXC4Ynsg/eTb6QihuJ49CcdP+yz4k3ZB3lLg4VfSnQO8d57+
nile98FRYB/e2guyLXW3Q0iT5/Z5xoRdgFlglPx4mI88k1HtQJAH32RjJMtOcQWh
15QaiDLxInQirqWm2BJpTGCjAu4r7NRjkgtevi92a6O2JryPA9gK8kxkRr05YuWW
6zRjESjMlfGt7+/cgFhI6Uu46mWs6fyAtbXIRfmswZ/ZuepiiI7E8UuDEq3mi4TW
nsLrgxifarsbJGAzcMzs9zLzXNl5fe+epP7JI8Mk7hWSsT2RTyaGvWZzJBPqpK5j
wa19hAM8EHiGG3njxPPyBJUgriOCxLM6AGK/5jYk4Ve6xx6QddVfP5VhK8E7zeWz
aGHQRiapIVJpLesux+t3zqY6tQMzT3bR51xUAV3LePTJDL/PEo4XLSNolOer/qmy
KwbQBM0=
-----END CERTIFICATE-----

TeliaSonera Root CA v1
================================================
SHA1 Fingerprint=43:13:BB:96:F1:D5:86:9B:C1:4E:6A:92:F6:CF:F6:34:69:87:82:37
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            95:be:16:a0:f7:2e:46:f1:7b:39:82:72:fa:8b:cd:96
    Signature Algorithm: sha1WithRSAEncryption
        Issuer: O=TeliaSonera, CN=TeliaSonera Root CA v1
        Validity
            Not Before: Oct 18 12:00:50 2007 GMT
            Not After : Oct 18 12:00:50 2032 GMT
        Subject: O=TeliaSonera, CN=TeliaSonera Root CA v1
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (4096 bit)
                Modulus:
                    00:c2:be:eb:27:f0:21:a3:f3:69:26:55:7e:9d:c5:
                    55:16:91:5c:fd:ef:21:bf:53:80:7a:2d:d2:91:8c:
                    63:31:f0:ec:24:f0:c3:a5:d2:72:7c:10:6d:f4:37:
                    b7:e5:e6:7c:79:ea:8c:b5:82:8b:ae:48:b6:ac:00:
                    dc:65:75:ec:2a:4d:5f:c1:87:f5:20:65:2b:81:a8:
                    47:3e:89:23:95:30:16:90:7f:e8:57:07:48:e7:19:
                    ae:bf:45:67:b1:37:1b:06:2a:fe:de:f9:ac:7d:83:
                    fb:5e:ba:e4:8f:97:67:be:4b:8e:8d:64:07:57:38:
                    55:69:34:36:3d:13:48:ef:4f:e2:d3:66:1e:a4:cf:
                    1a:b7:5e:36:33:d4:b4:06:bd:18:01:fd:77:84:50:
                    00:45:f5:8c:5d:e8:23:bc:7e:fe:35:e1:ed:50:7b:
                    a9:30:8d:19:d3:09:8e:68:67:5d:bf:3c:97:18:53:
                    bb:29:62:c5:ca:5e:72:c1:c7:96:d4:db:2d:a0:b4:
                    1f:69:03:ec:ea:e2:50:f1:0c:3c:f0:ac:f3:53:2d:
                    f0:1c:f5:ed:6c:39:39:73:80:16:c8:52:b0:23:cd:
                    e0:3e:dc:dd:3c:47:a0:bb:35:8a:e2:98:68:8b:be:
                    e5:bf:72:ee:d2:fa:a5:ed:12:ed:fc:98:18:a9:26:
                    76:dc:28:4b:10:20:1c:d3:7f:16:77:2d:ed:6f:80:
                    f7:49:bb:53:05:bb:5d:68:c7:d4:c8:75:16:3f:89:
                    5a:8b:f7:17:47:d4:4c:f1:d2:89:79:3e:4d:3d:98:
                    a8:61:de:3a:1e:d2:f8:5e:03:e0:c1:c9:1c:8c:d3:
                    8d:4d:d3:95:36:b3:37:5f:63:63:9b:33:14:f0:2d:
                    26:6b:53:7c:89:8c:32:c2:6e:ec:3d:21:00:39:c9:
                    a1:68:e2:50:83:2e:b0:3a:2b:f3:36:a0:ac:2f:e4:
                    6f:61:c2:51:09:39:3e:8b:53:b9:bb:67:da:dc:53:
                    b9:76:59:36:9d:43:e5:20:e0:3d:32:60:85:22:51:
                    b7:c7:33:bb:dd:15:2f:a4:78:a6:07:7b:81:46:36:
                    04:86:dd:79:35:c7:95:2c:3b:b0:a3:17:35:e5:73:
                    1f:b4:5c:59:ef:da:ea:10:65:7b:7a:d0:7f:9f:b3:
                    b4:2a:37:3b:70:8b:9b:5b:b9:2b:b7:ec:b2:51:12:
                    97:53:29:5a:d4:f0:12:10:dc:4f:02:bb:12:92:2f:
                    62:d4:3f:69:43:7c:0d:d6:fc:58:75:01:88:9d:58:
                    16:4b:de:ba:90:ff:47:01:89:06:6a:f6:5f:b2:90:
                    6a:b3:02:a6:02:88:bf:b3:47:7e:2a:d9:d5:fa:68:
                    78:35:4d
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Key Usage: 
                Certificate Sign, CRL Sign
            X509v3 Subject Key Identifier: 
                F0:8F:59:38:00:B3:F5:8F:9A:96:0C:D5:EB:FA:7B:AA:17:E8:13:12
    Signature Algorithm: sha1WithRSAEncryption
         be:e4:5c:62:4e:24:f4:0c:08:ff:f0:d3:0c:68:e4:93:49:22:
         3f:44:27:6f:bb:6d:de:83:66:ce:a8:cc:0d:fc:f5:9a:06:e5:
         77:14:91:eb:9d:41:7b:99:2a:84:e5:ff:fc:21:c1:5d:f0:e4:
         1f:57:b7:75:a9:a1:5f:02:26:ff:d7:c7:f7:4e:de:4f:f8:f7:
         1c:46:c0:7a:4f:40:2c:22:35:f0:19:b1:d0:6b:67:2c:b0:a8:
         e0:c0:40:37:35:f6:84:5c:5c:e3:af:42:78:fe:a7:c9:0d:50:
         ea:0d:84:76:f6:51:ef:83:53:c6:7a:ff:0e:56:49:2e:8f:7a:
         d6:0c:e6:27:54:e3:4d:0a:60:72:62:cd:91:07:d6:a5:bf:c8:
         99:6b:ed:c4:19:e6:ab:4c:11:38:c5:6f:31:e2:6e:49:c8:3f:
         76:80:26:03:26:29:e0:36:f6:f6:20:53:e3:17:70:34:17:9d:
         63:68:1e:6b:ec:c3:4d:86:b8:13:30:2f:5d:46:0d:47:43:d5:
         1b:aa:59:0e:b9:5c:8d:06:48:ad:74:87:5f:c7:fc:31:54:41:
         13:e2:c7:21:0e:9e:e0:1e:0d:e1:c0:7b:43:85:90:c5:8a:58:
         c6:65:0a:78:57:f2:c6:23:0f:01:d9:20:4b:de:0f:fb:92:85:
         75:2a:5c:73:8d:6d:7b:25:91:ca:ee:45:ae:06:4b:00:cc:d3:
         b1:59:50:da:3a:88:3b:29:43:46:5e:97:2b:54:ce:53:6f:8d:
         4a:e7:96:fa:bf:71:0e:42:8b:7c:fd:28:a0:d0:48:ca:da:c4:
         81:4c:bb:a2:73:93:26:c8:eb:0c:d6:26:88:b6:c0:24:cf:bb:
         bd:5b:eb:75:7d:e9:08:8e:86:33:2c:79:77:09:69:a5:89:fc:
         b3:70:90:87:76:8f:d3:22:bb:42:ce:bd:73:0b:20:26:2a:d0:
         9b:3d:70:1e:24:6c:cd:87:76:a9:17:96:b7:cf:0d:92:fb:8e:
         18:a9:98:49:d1:9e:fe:60:44:72:21:b9:19:ed:c2:f5:31:f1:
         39:48:88:90:24:75:54:16:ad:ce:f4:f8:69:14:64:39:fb:a3:
         b8:ba:70:40:c7:27:1c:bf:c4:56:53:fa:63:65:d0:f3:1c:0e:
         16:f5:6b:86:58:4d:18:d4:e4:0d:8e:a5:9d:5b:91:dc:76:24:
         50:3f:c6:2a:fb:d9:b7:9c:b5:d6:e6:d0:d9:e8:19:8b:15:71:
         48:ad:b7:ea:d8:59:88:d4:90:bf:16:b3:d9:e9:ac:59:61:54:
         c8:1c:ba:ca:c1:ca:e1:b9:20:4c:8f:3a:93:89:a5:a0:cc:bf:
         d3:f6:75:a4:75:96:6d:56
-----BEGIN CERTIFICATE-----
MIIFODCCAyCgAwIBAgIRAJW+FqD3LkbxezmCcvqLzZYwDQYJKoZIhvcNAQEFBQAw
NzEUMBIGA1UECgwLVGVsaWFTb25lcmExHzAdBgNVBAMMFlRlbGlhU29uZXJhIFJv
b3QgQ0EgdjEwHhcNMDcxMDE4MTIwMDUwWhcNMzIxMDE4MTIwMDUwWjA3MRQwEgYD
VQQKDAtUZWxpYVNvbmVyYTEfMB0GA1UEAwwWVGVsaWFTb25lcmEgUm9vdCBDQSB2
MTCCAiIwDQYJKoZIhvcNAQEBBQADggIPADCCAgoCggIBAMK+6yfwIaPzaSZVfp3F
VRaRXP3vIb9TgHot0pGMYzHw7CTww6XScnwQbfQ3t+XmfHnqjLWCi65ItqwA3GV1
7CpNX8GH9SBlK4GoRz6JI5UwFpB/6FcHSOcZrr9FZ7E3GwYq/t75rH2D+1665I+X
Z75Ljo1kB1c4VWk0Nj0TSO9P4tNmHqTPGrdeNjPUtAa9GAH9d4RQAEX1jF3oI7x+
/jXh7VB7qTCNGdMJjmhnXb88lxhTuylixcpecsHHltTbLaC0H2kD7OriUPEMPPCs
81Mt8Bz17Ww5OXOAFshSsCPN4D7c3TxHoLs1iuKYaIu+5b9y7tL6pe0S7fyYGKkm
dtwoSxAgHNN/Fnct7W+A90m7UwW7XWjH1Mh1Fj+JWov3F0fUTPHSiXk+TT2YqGHe
Oh7S+F4D4MHJHIzTjU3TlTazN19jY5szFPAtJmtTfImMMsJu7D0hADnJoWjiUIMu
sDor8zagrC/kb2HCUQk5PotTubtn2txTuXZZNp1D5SDgPTJghSJRt8czu90VL6R4
pgd7gUY2BIbdeTXHlSw7sKMXNeVzH7RcWe/a6hBle3rQf5+ztCo3O3CLm1u5K7fs
slESl1MpWtTwEhDcTwK7EpIvYtQ/aUN8Ddb8WHUBiJ1YFkveupD/RwGJBmr2X7KQ
arMCpgKIv7NHfirZ1fpoeDVNAgMBAAGjPzA9MA8GA1UdEwEB/wQFMAMBAf8wCwYD
VR0PBAQDAgEGMB0GA1UdDgQWBBTwj1k4ALP1j5qWDNXr+nuqF+gTEjANBgkqhkiG
9w0BAQUFAAOCAgEAvuRcYk4k9AwI//DTDGjkk0kiP0Qnb7tt3oNmzqjMDfz1mgbl
dxSR651Be5kqhOX//CHBXfDkH1e3damhXwIm/9fH907eT/j3HEbAek9ALCI18Bmx
0GtnLLCo4MBANzX2hFxc469CeP6nyQ1Q6g2EdvZR74NTxnr/DlZJLo961gzmJ1Tj
TQpgcmLNkQfWpb/ImWvtxBnmq0wROMVvMeJuScg/doAmAyYp4Db29iBT4xdwNBed
Y2gea+zDTYa4EzAvXUYNR0PVG6pZDrlcjQZIrXSHX8f8MVRBE+LHIQ6e4B4N4cB7
Q4WQxYpYxmUKeFfyxiMPAdkgS94P+5KFdSpcc41teyWRyu5FrgZLAMzTsVlQ2jqI
OylDRl6XK1TOU2+NSueW+r9xDkKLfP0ooNBIytrEgUy7onOTJsjrDNYmiLbAJM+7
vVvrdX3pCI6GMyx5dwlppYn8s3CQh3aP0yK7Qs69cwsgJirQmz1wHiRszYd2qReW
t88NkvuOGKmYSdGe/mBEciG5Ge3C9THxOUiIkCR1VBatzvT4aRRkOfujuLpwQMcn
HL/EVlP6Y2XQ8xwOFvVrhlhNGNTkDY6lnVuR3HYkUD/GKvvZt5y11ubQ2egZixVx
SK236thZiNSQvxaz2emsWWFUyBy6ysHK4bkgTI86k4mloMy/0/Z1pHWWbVY=
-----END CERTIFICATE-----

E-Tugra Certification Authority
=================================================
SHA1 Fingerprint=51:C6:E7:08:49:06:6E:F3:92:D4:5C:A0:0D:6D:A3:62:8F:C3:52:39
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 7667447206703254355 (0x6a683e9c519bcb53)
    Signature Algorithm: sha256WithRSAEncryption
        Issuer: C=TR, L=Ankara, O=E-Tu\xC4\x9Fra EBG Bili\xC5\x9Fim Teknolojileri ve Hizmetleri A.\xC5\x9E., OU=E-Tugra Sertifikasyon Merkezi, CN=E-Tugra Certification Authority
        Validity
            Not Before: Mar  5 12:09:48 2013 GMT
            Not After : Mar  3 12:09:48 2023 GMT
        Subject: C=TR, L=Ankara, O=E-Tu\xC4\x9Fra EBG Bili\xC5\x9Fim Teknolojileri ve Hizmetleri A.\xC5\x9E., OU=E-Tugra Sertifikasyon Merkezi, CN=E-Tugra Certification Authority
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (4096 bit)
                Modulus:
                    00:e2:f5:3f:93:05:51:1e:85:62:54:5e:7a:0b:f5:
                    18:07:83:ae:7e:af:7c:f7:d4:8a:6b:a5:63:43:39:
                    b9:4b:f7:c3:c6:64:89:3d:94:2e:54:80:52:39:39:
                    07:4b:4b:dd:85:07:76:87:cc:bf:2f:95:4c:cc:7d:
                    a7:3d:bc:47:0f:98:70:f8:8c:85:1e:74:8e:92:6d:
                    1b:40:d1:99:0d:bb:75:6e:c8:a9:6b:9a:c0:84:31:
                    af:ca:43:cb:eb:2b:34:e8:8f:97:6b:01:9b:d5:0e:
                    4a:08:aa:5b:92:74:85:43:d3:80:ae:a1:88:5b:ae:
                    b3:ea:5e:cb:16:9a:77:44:c8:a1:f6:54:68:ce:de:
                    8f:97:2b:ba:5b:40:02:0c:64:17:c0:b5:93:cd:e1:
                    f1:13:66:ce:0c:79:ef:d1:91:28:ab:5f:a0:12:52:
                    30:73:19:8e:8f:e1:8c:07:a2:c3:bb:4a:f0:ea:1f:
                    15:a8:ee:25:cc:a4:46:f8:1b:22:ef:b3:0e:43:ba:
                    2c:24:b8:c5:2c:5c:d4:1c:f8:5d:64:bd:c3:93:5e:
                    28:a7:3f:27:f1:8e:1e:d3:2a:50:05:a3:55:d9:cb:
                    e7:39:53:c0:98:9e:8c:54:62:8b:26:b0:f7:7d:8d:
                    7c:e4:c6:9e:66:42:55:82:47:e7:b2:58:8d:66:f7:
                    07:7c:2e:36:e6:50:1c:3f:db:43:24:c5:bf:86:47:
                    79:b3:79:1c:f7:5a:f4:13:ec:6c:f8:3f:e2:59:1f:
                    95:ee:42:3e:b9:ad:a8:32:85:49:97:46:fe:4b:31:
                    8f:5a:cb:ad:74:47:1f:e9:91:b7:df:28:04:22:a0:
                    d4:0f:5d:e2:79:4f:ea:6c:85:86:bd:a8:a6:ce:e4:
                    fa:c3:e1:b3:ae:de:3c:51:ee:cb:13:7c:01:7f:84:
                    0e:5d:51:94:9e:13:0c:b6:2e:a5:4c:f9:39:70:36:
                    6f:96:ca:2e:0c:44:55:c5:ca:fa:5d:02:a3:df:d6:
                    64:8c:5a:b3:01:0a:a9:b5:0a:47:17:ff:ef:91:40:
                    2a:8e:a1:46:3a:31:98:e5:11:fc:cc:bb:49:56:8a:
                    fc:b9:d0:61:9a:6f:65:6c:e6:c3:cb:3e:75:49:fe:
                    8f:a7:e2:89:c5:67:d7:9d:46:13:4e:31:76:3b:24:
                    b3:9e:11:65:86:ab:7f:ef:1d:d4:f8:bc:e7:ac:5a:
                    5c:b7:5a:47:5c:55:ce:55:b4:22:71:5b:5b:0b:f0:
                    cf:dc:a0:61:64:ea:a9:d7:68:0a:63:a7:e0:0d:3f:
                    a0:af:d3:aa:d2:7e:ef:51:a0:e6:51:2b:55:92:15:
                    17:53:cb:b7:66:0e:66:4c:f8:f9:75:4c:90:e7:12:
                    70:c7:45
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Subject Key Identifier: 
                2E:E3:DB:B2:49:D0:9C:54:79:5C:FA:27:2A:FE:CC:4E:D2:E8:4E:54
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Authority Key Identifier: 
                keyid:2E:E3:DB:B2:49:D0:9C:54:79:5C:FA:27:2A:FE:CC:4E:D2:E8:4E:54

            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
    Signature Algorithm: sha256WithRSAEncryption
         05:37:3a:f4:4d:b7:45:e2:45:75:24:8f:b6:77:52:e8:1c:d8:
         10:93:65:f3:f2:59:06:a4:3e:1e:29:ec:5d:d1:d0:ab:7c:e0:
         0a:90:48:78:ed:4e:98:03:99:fe:28:60:91:1d:30:1d:b8:63:
         7c:a8:e6:35:b5:fa:d3:61:76:e6:d6:07:4b:ca:69:9a:b2:84:
         7a:77:93:45:17:15:9f:24:d0:98:13:12:ff:bb:a0:2e:fd:4e:
         4c:87:f8:ce:5c:aa:98:1b:05:e0:00:46:4a:82:80:a5:33:8b:
         28:dc:ed:38:d3:df:e5:3e:e9:fe:fb:59:dd:61:84:4f:d2:54:
         96:13:61:13:3e:8f:80:69:be:93:47:b5:35:43:d2:5a:bb:3d:
         5c:ef:b3:42:47:cd:3b:55:13:06:b0:09:db:fd:63:f6:3a:88:
         0a:99:6f:7e:e1:ce:1b:53:6a:44:66:23:51:08:7b:bc:5b:52:
         a2:fd:06:37:38:40:61:8f:4a:96:b8:90:37:f8:66:c7:78:90:
         00:15:2e:8b:ad:51:35:53:07:a8:6b:68:ae:f9:4e:3c:07:26:
         cd:08:05:70:cc:39:3f:76:bd:a5:d3:67:26:01:86:a6:53:d2:
         60:3b:7c:43:7f:55:8a:bc:95:1a:c1:28:39:4c:1f:43:d2:91:
         f4:72:59:8a:b9:56:fc:3f:b4:9d:da:70:9c:76:5a:8c:43:50:
         ee:8e:30:72:4d:df:ff:49:f7:c6:a9:67:d9:6d:ac:02:11:e2:
         3a:16:25:a7:58:08:cb:6f:53:41:9c:48:38:47:68:33:d1:d7:
         c7:8f:d4:74:21:d4:c3:05:90:7a:ff:ce:96:88:b1:15:29:5d:
         23:ab:d0:60:a1:12:4f:de:f4:17:cd:32:e5:c9:bf:c8:43:ad:
         fd:2e:8e:f1:af:e2:f4:98:fa:12:1f:20:d8:c0:a7:0c:85:c5:
         90:f4:3b:2d:96:26:b1:2c:be:4c:ab:eb:b1:d2:8a:c9:db:78:
         13:0f:1e:09:9d:6d:8f:00:9f:02:da:c1:fa:1f:7a:7a:09:c4:
         4a:e6:88:2a:97:9f:89:8b:fd:37:5f:5f:3a:ce:38:59:86:4b:
         af:71:0b:b4:d8:f2:70:4f:9f:32:13:e3:b0:a7:57:e5:da:da:
         43:cb:84:34:f2:28:c4:ea:6d:f4:2a:ef:c1:6b:76:da:fb:7e:
         bb:85:3c:d2:53:c2:4d:be:71:e1:45:d1:fd:23:67:0d:13:75:
         fb:cf:65:67:22:9d:ae:b0:09:d1:09:ff:1d:34:bf:fe:23:97:
         37:d2:39:fa:3d:0d:06:0b:b4:db:3b:a3:ab:6f:5c:1d:b6:7e:
         e8:b3:82:34:ed:06:5c:24
-----BEGIN CERTIFICATE-----
MIIGSzCCBDOgAwIBAgIIamg+nFGby1MwDQYJKoZIhvcNAQELBQAwgbIxCzAJBgNV
BAYTAlRSMQ8wDQYDVQQHDAZBbmthcmExQDA+BgNVBAoMN0UtVHXEn3JhIEVCRyBC
aWxpxZ9pbSBUZWtub2xvamlsZXJpIHZlIEhpem1ldGxlcmkgQS7Fni4xJjAkBgNV
BAsMHUUtVHVncmEgU2VydGlmaWthc3lvbiBNZXJrZXppMSgwJgYDVQQDDB9FLVR1
Z3JhIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTEzMDMwNTEyMDk0OFoXDTIz
MDMwMzEyMDk0OFowgbIxCzAJBgNVBAYTAlRSMQ8wDQYDVQQHDAZBbmthcmExQDA+
BgNVBAoMN0UtVHXEn3JhIEVCRyBCaWxpxZ9pbSBUZWtub2xvamlsZXJpIHZlIEhp
em1ldGxlcmkgQS7Fni4xJjAkBgNVBAsMHUUtVHVncmEgU2VydGlmaWthc3lvbiBN
ZXJrZXppMSgwJgYDVQQDDB9FLVR1Z3JhIENlcnRpZmljYXRpb24gQXV0aG9yaXR5
MIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEA4vU/kwVRHoViVF56C/UY
B4Oufq9899SKa6VjQzm5S/fDxmSJPZQuVIBSOTkHS0vdhQd2h8y/L5VMzH2nPbxH
D5hw+IyFHnSOkm0bQNGZDbt1bsipa5rAhDGvykPL6ys06I+XawGb1Q5KCKpbknSF
Q9OArqGIW66z6l7LFpp3RMih9lRozt6Plyu6W0ACDGQXwLWTzeHxE2bODHnv0ZEo
q1+gElIwcxmOj+GMB6LDu0rw6h8VqO4lzKRG+Bsi77MOQ7osJLjFLFzUHPhdZL3D
k14opz8n8Y4e0ypQBaNV2cvnOVPAmJ6MVGKLJrD3fY185MaeZkJVgkfnsliNZvcH
fC425lAcP9tDJMW/hkd5s3kc91r0E+xs+D/iWR+V7kI+ua2oMoVJl0b+SzGPWsut
dEcf6ZG33ygEIqDUD13ieU/qbIWGvaimzuT6w+Gzrt48Ue7LE3wBf4QOXVGUnhMM
ti6lTPk5cDZvlsouDERVxcr6XQKj39ZkjFqzAQqptQpHF//vkUAqjqFGOjGY5RH8
zLtJVor8udBhmm9lbObDyz51Sf6Pp+KJxWfXnUYTTjF2OySznhFlhqt/7x3U+Lzn
rFpct1pHXFXOVbQicVtbC/DP3KBhZOqp12gKY6fgDT+gr9Oq0n7vUaDmUStVkhUX
U8u3Zg5mTPj5dUyQ5xJwx0UCAwEAAaNjMGEwHQYDVR0OBBYEFC7j27JJ0JxUeVz6
Jyr+zE7S6E5UMA8GA1UdEwEB/wQFMAMBAf8wHwYDVR0jBBgwFoAULuPbsknQnFR5
XPonKv7MTtLoTlQwDgYDVR0PAQH/BAQDAgEGMA0GCSqGSIb3DQEBCwUAA4ICAQAF
Nzr0TbdF4kV1JI+2d1LoHNgQk2Xz8lkGpD4eKexd0dCrfOAKkEh47U6YA5n+KGCR
HTAduGN8qOY1tfrTYXbm1gdLymmasoR6d5NFFxWfJNCYExL/u6Au/U5Mh/jOXKqY
GwXgAEZKgoClM4so3O0409/lPun++1ndYYRP0lSWE2ETPo+Aab6TR7U1Q9Jauz1c
77NCR807VRMGsAnb/WP2OogKmW9+4c4bU2pEZiNRCHu8W1Ki/QY3OEBhj0qWuJA3
+GbHeJAAFS6LrVE1Uweoa2iu+U48BybNCAVwzDk/dr2l02cmAYamU9JgO3xDf1WK
vJUawSg5TB9D0pH0clmKuVb8P7Sd2nCcdlqMQ1DujjByTd//SffGqWfZbawCEeI6
FiWnWAjLb1NBnEg4R2gz0dfHj9R0IdTDBZB6/86WiLEVKV0jq9BgoRJP3vQXzTLl
yb/IQ639Lo7xr+L0mPoSHyDYwKcMhcWQ9DstliaxLL5Mq+ux0orJ23gTDx4JnW2P
AJ8C2sH6H3p6CcRK5ogql5+Ji/03X186zjhZhkuvcQu02PJwT58yE+Owp1fl2tpD
y4Q08ijE6m30Ku/Ba3ba+367hTzSU8JNvnHhRdH9I2cNE3X7z2VnIp2usAnRCf8d
NL/+I5c30jn6PQ0GC7TbO6Orb1wdtn7os4I07QZcJA==
-----END CERTIFICATE-----

T-TeleSec GlobalRoot Class 2
================================================
SHA1 Fingerprint=59:0D:2D:7D:88:4F:40:2E:61:7E:A5:62:32:17:65:CF:17:D8:94:E9
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 1 (0x1)
    Signature Algorithm: sha256WithRSAEncryption
        Issuer: C=DE, O=T-Systems Enterprise Services GmbH, OU=T-Systems Trust Center, CN=T-TeleSec GlobalRoot Class 2
        Validity
            Not Before: Oct  1 10:40:14 2008 GMT
            Not After : Oct  1 23:59:59 2033 GMT
        Subject: C=DE, O=T-Systems Enterprise Services GmbH, OU=T-Systems Trust Center, CN=T-TeleSec GlobalRoot Class 2
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (2048 bit)
                Modulus:
                    00:aa:5f:da:1b:5f:e8:73:91:e5:da:5c:f4:a2:e6:
                    47:e5:f3:68:55:60:05:1d:02:a4:b3:9b:59:f3:1e:
                    8a:af:34:ad:fc:0d:c2:d9:48:19:ee:69:8f:c9:20:
                    fc:21:aa:07:19:ed:b0:5c:ac:65:c7:5f:ed:02:7c:
                    7b:7c:2d:1b:d6:ba:b9:80:c2:18:82:16:84:fa:66:
                    b0:08:c6:54:23:81:e4:cd:b9:49:3f:f6:4f:6e:37:
                    48:28:38:0f:c5:be:e7:68:70:fd:39:97:4d:d2:c7:
                    98:91:50:aa:c4:44:b3:23:7d:39:47:e9:52:62:d6:
                    12:93:5e:b7:31:96:42:05:fb:76:a7:1e:a3:f5:c2:
                    fc:e9:7a:c5:6c:a9:71:4f:ea:cb:78:bc:60:af:c7:
                    de:f4:d9:cb:be:7e:33:a5:6e:94:83:f0:34:fa:21:
                    ab:ea:8e:72:a0:3f:a4:de:30:5b:ef:86:4d:6a:95:
                    5b:43:44:a8:10:15:1c:e5:01:57:c5:98:f1:e6:06:
                    28:91:aa:20:c5:b7:53:26:51:43:b2:0b:11:95:58:
                    e1:c0:0f:76:d9:c0:8d:7c:81:f3:72:70:9e:6f:fe:
                    1a:8e:d9:5f:35:c6:b2:6f:34:7c:be:48:4f:e2:5a:
                    39:d7:d8:9d:78:9e:9f:86:3e:03:5e:19:8b:44:a2:
                    d5:c7
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Subject Key Identifier: 
                BF:59:20:36:00:79:A0:A0:22:6B:8C:D5:F2:61:D2:B8:2C:CB:82:4A
    Signature Algorithm: sha256WithRSAEncryption
         31:03:a2:61:0b:1f:74:e8:72:36:c6:6d:f9:4d:9e:fa:22:a8:
         e1:81:56:cf:cd:bb:9f:ea:ab:91:19:38:af:aa:7c:15:4d:f3:
         b6:a3:8d:a5:f4:8e:f6:44:a9:a7:e8:21:95:ad:3e:00:62:16:
         88:f0:02:ba:fc:61:23:e6:33:9b:30:7a:6b:36:62:7b:ad:04:
         23:84:58:65:e2:db:2b:8a:e7:25:53:37:62:53:5f:bc:da:01:
         62:29:a2:a6:27:71:e6:3a:22:7e:c1:6f:1d:95:70:20:4a:07:
         34:df:ea:ff:15:80:e5:ba:d7:7a:d8:5b:75:7c:05:7a:29:47:
         7e:40:a8:31:13:77:cd:40:3b:b4:51:47:7a:2e:11:e3:47:11:
         de:9d:66:d0:8b:d5:54:66:fa:83:55:ea:7c:c2:29:89:1b:e9:
         6f:b3:ce:e2:05:84:c9:2f:3e:78:85:62:6e:c9:5f:c1:78:63:
         74:58:c0:48:18:0c:99:39:eb:a4:cc:1a:b5:79:5a:8d:15:9c:
         d8:14:0d:f6:7a:07:57:c7:22:83:05:2d:3c:9b:25:26:3d:18:
         b3:a9:43:7c:c8:c8:ab:64:8f:0e:a3:bf:9c:1b:9d:30:db:da:
         d0:19:2e:aa:3c:f1:fb:33:80:76:e4:cd:ad:19:4f:05:27:8e:
         13:a1:6e:c2
-----BEGIN CERTIFICATE-----
MIIDwzCCAqugAwIBAgIBATANBgkqhkiG9w0BAQsFADCBgjELMAkGA1UEBhMCREUx
KzApBgNVBAoMIlQtU3lzdGVtcyBFbnRlcnByaXNlIFNlcnZpY2VzIEdtYkgxHzAd
BgNVBAsMFlQtU3lzdGVtcyBUcnVzdCBDZW50ZXIxJTAjBgNVBAMMHFQtVGVsZVNl
YyBHbG9iYWxSb290IENsYXNzIDIwHhcNMDgxMDAxMTA0MDE0WhcNMzMxMDAxMjM1
OTU5WjCBgjELMAkGA1UEBhMCREUxKzApBgNVBAoMIlQtU3lzdGVtcyBFbnRlcnBy
aXNlIFNlcnZpY2VzIEdtYkgxHzAdBgNVBAsMFlQtU3lzdGVtcyBUcnVzdCBDZW50
ZXIxJTAjBgNVBAMMHFQtVGVsZVNlYyBHbG9iYWxSb290IENsYXNzIDIwggEiMA0G
CSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCqX9obX+hzkeXaXPSi5kfl82hVYAUd
AqSzm1nzHoqvNK38DcLZSBnuaY/JIPwhqgcZ7bBcrGXHX+0CfHt8LRvWurmAwhiC
FoT6ZrAIxlQjgeTNuUk/9k9uN0goOA/FvudocP05l03Sx5iRUKrERLMjfTlH6VJi
1hKTXrcxlkIF+3anHqP1wvzpesVsqXFP6st4vGCvx9702cu+fjOlbpSD8DT6Iavq
jnKgP6TeMFvvhk1qlVtDRKgQFRzlAVfFmPHmBiiRqiDFt1MmUUOyCxGVWOHAD3bZ
wI18gfNycJ5v/hqO2V81xrJvNHy+SE/iWjnX2J14np+GPgNeGYtEotXHAgMBAAGj
QjBAMA8GA1UdEwEB/wQFMAMBAf8wDgYDVR0PAQH/BAQDAgEGMB0GA1UdDgQWBBS/
WSA2AHmgoCJrjNXyYdK4LMuCSjANBgkqhkiG9w0BAQsFAAOCAQEAMQOiYQsfdOhy
NsZt+U2e+iKo4YFWz827n+qrkRk4r6p8FU3ztqONpfSO9kSpp+ghla0+AGIWiPAC
uvxhI+YzmzB6azZie60EI4RYZeLbK4rnJVM3YlNfvNoBYimipidx5joifsFvHZVw
IEoHNN/q/xWA5brXethbdXwFeilHfkCoMRN3zUA7tFFHei4R40cR3p1m0IvVVGb6
g1XqfMIpiRvpb7PO4gWEyS8+eIVibslfwXhjdFjASBgMmTnrpMwatXlajRWc2BQN
9noHV8cigwUtPJslJj0Ys6lDfMjIq2SPDqO/nBudMNva0Bkuqjzx+zOAduTNrRlP
BSeOE6Fuwg==
-----END CERTIFICATE-----

Atos TrustedRoot 2011
================================================
SHA1 Fingerprint=2B:B1:F5:3E:55:0C:1D:C5:F1:D4:E6:B7:6A:46:4B:55:06:02:AC:21
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 6643877497813316402 (0x5c33cb622c5fb332)
    Signature Algorithm: sha256WithRSAEncryption
        Issuer: CN=Atos TrustedRoot 2011, O=Atos, C=DE
        Validity
            Not Before: Jul  7 14:58:30 2011 GMT
            Not After : Dec 31 23:59:59 2030 GMT
        Subject: CN=Atos TrustedRoot 2011, O=Atos, C=DE
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (2048 bit)
                Modulus:
                    00:95:85:3b:97:6f:2a:3b:2e:3b:cf:a6:f3:29:35:
                    be:cf:18:ac:3e:aa:d9:f8:4d:a0:3e:1a:47:b9:bc:
                    9a:df:f2:fe:cc:3e:47:e8:7a:96:c2:24:8e:35:f4:
                    a9:0c:fc:82:fd:6d:c1:72:62:27:bd:ea:6b:eb:e7:
                    8a:cc:54:3e:90:50:cf:80:d4:95:fb:e8:b5:82:d4:
                    14:c5:b6:a9:55:25:57:db:b1:50:f6:b0:60:64:59:
                    7a:69:cf:03:b7:6f:0d:be:ca:3e:6f:74:72:ea:aa:
                    30:2a:73:62:be:49:91:61:c8:11:fe:0e:03:2a:f7:
                    6a:20:dc:02:15:0d:5e:15:6a:fc:e3:82:c1:b5:c5:
                    9d:64:09:6c:a3:59:98:07:27:c7:1b:96:2b:61:74:
                    71:6c:43:f1:f7:35:89:10:e0:9e:ec:55:a1:37:22:
                    a2:87:04:05:2c:47:7d:b4:1c:b9:62:29:66:28:ca:
                    b7:e1:93:f5:a4:94:03:99:b9:70:85:b5:e6:48:ea:
                    8d:50:fc:d9:de:cc:6f:07:0e:dd:0b:72:9d:80:30:
                    16:07:95:3f:28:0e:fd:c5:75:4f:53:d6:74:9a:b4:
                    24:2e:8e:02:91:cf:76:c5:9b:1e:55:74:9c:78:21:
                    b1:f0:2d:f1:0b:9f:c2:d5:96:18:1f:f0:54:22:7a:
                    8c:07
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Subject Key Identifier: 
                A7:A5:06:B1:2C:A6:09:60:EE:D1:97:E9:70:AE:BC:3B:19:6C:DB:21
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Authority Key Identifier: 
                keyid:A7:A5:06:B1:2C:A6:09:60:EE:D1:97:E9:70:AE:BC:3B:19:6C:DB:21

            X509v3 Certificate Policies: 
                Policy: 1.3.6.1.4.1.6189.3.4.1.1

            X509v3 Key Usage: critical
                Digital Signature, Certificate Sign, CRL Sign
    Signature Algorithm: sha256WithRSAEncryption
         26:77:34:db:94:48:86:2a:41:9d:2c:3e:06:90:60:c4:8c:ac:
         0b:54:b8:1f:b9:7b:d3:07:39:e4:fa:3e:7b:b2:3d:4e:ed:9f:
         23:bd:97:f3:6b:5c:ef:ee:fd:40:a6:df:a1:93:a1:0a:86:ac:
         ef:20:d0:79:01:bd:78:f7:19:d8:24:31:34:04:01:a6:ba:15:
         9a:c3:27:dc:d8:4f:0f:cc:18:63:ff:99:0f:0e:91:6b:75:16:
         e1:21:fc:d8:26:c7:47:b7:a6:cf:58:72:71:7e:ba:e1:4d:95:
         47:3b:c9:af:6d:a1:b4:c1:ec:89:f6:b4:0f:38:b5:e2:64:dc:
         25:cf:a6:db:eb:9a:5c:99:a1:c5:08:de:fd:e6:da:d5:d6:5a:
         45:0c:c4:b7:c2:b5:14:ef:b4:11:ff:0e:15:b5:f5:f5:db:c6:
         bd:eb:5a:a7:f0:56:22:a9:3c:65:54:c6:15:a8:bd:86:9e:cd:
         83:96:68:7a:71:81:89:e1:0b:e1:ea:11:1b:68:08:cc:69:9e:
         ec:9e:41:9e:44:32:26:7a:e2:87:0a:71:3d:eb:e4:5a:a4:d2:
         db:c5:cd:c6:de:60:7f:b9:f3:4f:44:92:ef:2a:b7:18:3e:a7:
         19:d9:0b:7d:b1:37:41:42:b0:ba:60:1d:f2:fe:09:11:b0:f0:
         87:7b:a7:9d
-----BEGIN CERTIFICATE-----
MIIDdzCCAl+gAwIBAgIIXDPLYixfszIwDQYJKoZIhvcNAQELBQAwPDEeMBwGA1UE
AwwVQXRvcyBUcnVzdGVkUm9vdCAyMDExMQ0wCwYDVQQKDARBdG9zMQswCQYDVQQG
EwJERTAeFw0xMTA3MDcxNDU4MzBaFw0zMDEyMzEyMzU5NTlaMDwxHjAcBgNVBAMM
FUF0b3MgVHJ1c3RlZFJvb3QgMjAxMTENMAsGA1UECgwEQXRvczELMAkGA1UEBhMC
REUwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCVhTuXbyo7LjvPpvMp
Nb7PGKw+qtn4TaA+Gke5vJrf8v7MPkfoepbCJI419KkM/IL9bcFyYie96mvr54rM
VD6QUM+A1JX76LWC1BTFtqlVJVfbsVD2sGBkWXppzwO3bw2+yj5vdHLqqjAqc2K+
SZFhyBH+DgMq92og3AIVDV4VavzjgsG1xZ1kCWyjWZgHJ8cblithdHFsQ/H3NYkQ
4J7sVaE3IqKHBAUsR320HLliKWYoyrfhk/WklAOZuXCFteZI6o1Q/NnezG8HDt0L
cp2AMBYHlT8oDv3FdU9T1nSatCQujgKRz3bFmx5VdJx4IbHwLfELn8LVlhgf8FQi
eowHAgMBAAGjfTB7MB0GA1UdDgQWBBSnpQaxLKYJYO7Rl+lwrrw7GWzbITAPBgNV
HRMBAf8EBTADAQH/MB8GA1UdIwQYMBaAFKelBrEspglg7tGX6XCuvDsZbNshMBgG
A1UdIAQRMA8wDQYLKwYBBAGwLQMEAQEwDgYDVR0PAQH/BAQDAgGGMA0GCSqGSIb3
DQEBCwUAA4IBAQAmdzTblEiGKkGdLD4GkGDEjKwLVLgfuXvTBznk+j57sj1O7Z8j
vZfza1zv7v1Apt+hk6EKhqzvINB5Ab149xnYJDE0BAGmuhWawyfc2E8PzBhj/5kP
DpFrdRbhIfzYJsdHt6bPWHJxfrrhTZVHO8mvbaG0weyJ9rQPOLXiZNwlz6bb65pc
maHFCN795trV1lpFDMS3wrUU77QR/w4VtfX128a961qn8FYiqTxlVMYVqL2Gns2D
lmh6cYGJ4Qvh6hEbaAjMaZ7snkGeRDImeuKHCnE96+RapNLbxc3G3mB/ufNPRJLv
KrcYPqcZ2Qt9sTdBQrC6YB3y/gkRsPCHe6ed
-----END CERTIFICATE-----

QuoVadis Root CA 1 G3
================================================
SHA1 Fingerprint=1B:8E:EA:57:96:29:1A:C9:39:EA:B8:0A:81:1A:73:73:C0:93:79:67
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            78:58:5f:2e:ad:2c:19:4b:e3:37:07:35:34:13:28:b5:96:d4:65:93
    Signature Algorithm: sha256WithRSAEncryption
        Issuer: C=BM, O=QuoVadis Limited, CN=QuoVadis Root CA 1 G3
        Validity
            Not Before: Jan 12 17:27:44 2012 GMT
            Not After : Jan 12 17:27:44 2042 GMT
        Subject: C=BM, O=QuoVadis Limited, CN=QuoVadis Root CA 1 G3
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (4096 bit)
                Modulus:
                    00:a0:be:50:10:8e:e9:f2:6c:40:b4:04:9c:85:b9:
                    31:ca:dc:2d:e4:11:a9:04:3c:1b:55:c1:e7:58:30:
                    1d:24:b4:c3:ef:85:de:8c:2c:e1:c1:3d:df:82:e6:
                    4f:ad:47:87:6c:ec:5b:49:c1:4a:d5:bb:8f:ec:87:
                    ac:7f:82:9a:86:ec:3d:03:99:52:01:d2:35:9e:ac:
                    da:f0:53:c9:66:3c:d4:ac:02:01:da:24:d3:3b:a8:
                    02:46:af:a4:1c:e3:f8:73:58:76:b7:f6:0e:90:0d:
                    b5:f0:cf:cc:fa:f9:c6:4c:e5:c3:86:30:0a:8d:17:
                    7e:35:eb:c5:df:bb:0e:9c:c0:8d:87:e3:88:38:85:
                    67:fa:3e:c7:ab:e0:13:9c:05:18:98:cf:93:f5:b1:
                    92:b4:fc:23:d3:cf:d5:c4:27:49:e0:9e:3c:9b:08:
                    a3:8b:5d:2a:21:e0:fc:39:aa:53:da:7d:7e:cf:1a:
                    09:53:bc:5d:05:04:cf:a1:4a:8f:8b:76:82:0d:a1:
                    f8:d2:c7:14:77:5b:90:36:07:81:9b:3e:06:fa:52:
                    5e:63:c5:a6:00:fe:a5:e9:52:1b:52:b5:92:39:72:
                    03:09:62:bd:b0:60:16:6e:a6:dd:25:c2:03:66:dd:
                    f3:04:d1:40:e2:4e:8b:86:f4:6f:e5:83:a0:27:84:
                    5e:04:c1:f5:90:bd:30:3d:c4:ef:a8:69:bc:38:9b:
                    a4:a4:96:d1:62:da:69:c0:01:96:ae:cb:c4:51:34:
                    ea:0c:aa:ff:21:8e:59:8f:4a:5c:e4:61:9a:a7:d2:
                    e9:2a:78:8d:51:3d:3a:15:ee:a2:59:8e:a9:5c:de:
                    c5:f9:90:22:e5:88:45:71:dd:91:99:6c:7a:9f:3d:
                    3d:98:7c:5e:f6:be:16:68:a0:5e:ae:0b:23:fc:5a:
                    0f:aa:22:76:2d:c9:a1:10:1d:e4:d3:44:23:90:88:
                    9f:c6:2a:e6:d7:f5:9a:b3:58:1e:2f:30:89:08:1b:
                    54:a2:b5:98:23:ec:08:77:1c:95:5d:61:d1:cb:89:
                    9c:5f:a2:4a:91:9a:ef:21:aa:49:16:08:a8:bd:61:
                    28:31:c9:74:ad:85:f6:d9:c5:b1:8b:d1:e5:10:32:
                    4d:5f:8b:20:3a:3c:49:1f:33:85:59:0d:db:cb:09:
                    75:43:69:73:fb:6b:71:7d:f0:df:c4:4c:7d:c6:a3:
                    2e:c8:95:79:cb:73:a2:8e:4e:4d:24:fb:5e:e4:04:
                    be:72:1b:a6:27:2d:49:5a:99:7a:d7:5c:09:20:b7:
                    7f:94:b9:4f:f1:0d:1c:5e:88:42:1b:11:b7:e7:91:
                    db:9e:6c:f4:6a:df:8c:06:98:03:ad:cc:28:ef:a5:
                    47:f3:53
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Subject Key Identifier: 
                A3:97:D6:F3:5E:A2:10:E1:AB:45:9F:3C:17:64:3C:EE:01:70:9C:CC
    Signature Algorithm: sha256WithRSAEncryption
         18:fa:5b:75:fc:3e:7a:c7:5f:77:c7:ca:df:cf:5f:c3:12:c4:
         40:5d:d4:32:aa:b8:6a:d7:d5:15:15:46:98:23:a5:e6:90:5b:
         18:99:4c:e3:ad:42:a3:82:31:36:88:cd:e9:fb:c4:04:96:48:
         8b:01:c7:8d:01:cf:5b:33:06:96:46:66:74:1d:4f:ed:c1:b6:
         b9:b4:0d:61:cc:63:7e:d7:2e:77:8c:96:1c:2a:23:68:6b:85:
         57:76:70:33:13:fe:e1:4f:a6:23:77:18:fa:1a:8c:e8:bd:65:
         c9:cf:3f:f4:c9:17:dc:eb:c7:bc:c0:04:2e:2d:46:2f:69:66:
         c3:1b:8f:fe:ec:3e:d3:ca:94:bf:76:0a:25:0d:a9:7b:02:1c:
         a9:d0:3b:5f:0b:c0:81:3a:3d:64:e1:bf:a7:2d:4e:bd:4d:c4:
         d8:29:c6:22:18:d0:c5:ac:72:02:82:3f:aa:3a:a2:3a:22:97:
         31:dd:08:63:c3:75:14:b9:60:28:2d:5b:68:e0:16:a9:66:82:
         23:51:f5:eb:53:d8:31:9b:7b:e9:b7:9d:4b:eb:88:16:cf:f9:
         5d:38:8a:49:30:8f:ed:f1:eb:19:f4:77:1a:31:18:4d:67:54:
         6c:2f:6f:65:f9:db:3d:ec:21:ec:5e:f4:f4:8b:ca:60:65:54:
         d1:71:64:f4:f9:a6:a3:81:33:36:33:71:f0:a4:78:5f:4e:ad:
         83:21:de:34:49:8d:e8:59:ac:9d:f2:76:5a:36:f2:13:f4:af:
         e0:09:c7:61:2a:6c:f7:e0:9d:ae:bb:86:4a:28:6f:2e:ee:b4:
         79:cd:90:33:c3:b3:76:fa:f5:f0:6c:9d:01:90:fa:9e:90:f6:
         9c:72:cf:47:da:c3:1f:e4:35:20:53:f2:54:d1:df:61:83:a6:
         02:e2:25:38:de:85:32:2d:5e:73:90:52:5d:42:c4:ce:3d:4b:
         e1:f9:19:84:1d:d5:a2:50:cc:41:fb:41:14:c3:bd:d6:c9:5a:
         a3:63:66:02:80:bd:05:3a:3b:47:9c:ec:00:26:4c:f5:88:51:
         bf:a8:23:7f:18:07:b0:0b:ed:8b:26:a1:64:d3:61:4a:eb:5c:
         9f:de:b3:af:67:03:b3:1f:dd:6d:5d:69:68:69:ab:5e:3a:ec:
         7c:69:bc:c7:3b:85:4e:9e:15:b9:b4:15:4f:c3:95:7a:58:d7:
         c9:6c:e9:6c:b9:f3:29:63:5e:b4:2c:f0:2d:3d:ed:5a:65:e0:
         a9:5b:40:c2:48:99:81:6d:9e:1f:06:2a:3c:12:b4:8b:0f:9b:
         a2:24:f0:a6:8d:d6:7a:e0:4b:b6:64:96:63:95:84:c2:4a:cd:
         1c:2e:24:87:33:60:e5:c3
-----BEGIN CERTIFICATE-----
MIIFYDCCA0igAwIBAgIUeFhfLq0sGUvjNwc1NBMotZbUZZMwDQYJKoZIhvcNAQEL
BQAwSDELMAkGA1UEBhMCQk0xGTAXBgNVBAoTEFF1b1ZhZGlzIExpbWl0ZWQxHjAc
BgNVBAMTFVF1b1ZhZGlzIFJvb3QgQ0EgMSBHMzAeFw0xMjAxMTIxNzI3NDRaFw00
MjAxMTIxNzI3NDRaMEgxCzAJBgNVBAYTAkJNMRkwFwYDVQQKExBRdW9WYWRpcyBM
aW1pdGVkMR4wHAYDVQQDExVRdW9WYWRpcyBSb290IENBIDEgRzMwggIiMA0GCSqG
SIb3DQEBAQUAA4ICDwAwggIKAoICAQCgvlAQjunybEC0BJyFuTHK3C3kEakEPBtV
wedYMB0ktMPvhd6MLOHBPd+C5k+tR4ds7FtJwUrVu4/sh6x/gpqG7D0DmVIB0jWe
rNrwU8lmPNSsAgHaJNM7qAJGr6Qc4/hzWHa39g6QDbXwz8z6+cZM5cOGMAqNF341
68Xfuw6cwI2H44g4hWf6Pser4BOcBRiYz5P1sZK0/CPTz9XEJ0ngnjybCKOLXSoh
4Pw5qlPafX7PGglTvF0FBM+hSo+LdoINofjSxxR3W5A2B4GbPgb6Ul5jxaYA/qXp
UhtStZI5cgMJYr2wYBZupt0lwgNm3fME0UDiTouG9G/lg6AnhF4EwfWQvTA9xO+o
abw4m6SkltFi2mnAAZauy8RRNOoMqv8hjlmPSlzkYZqn0ukqeI1RPToV7qJZjqlc
3sX5kCLliEVx3ZGZbHqfPT2YfF72vhZooF6uCyP8Wg+qInYtyaEQHeTTRCOQiJ/G
KubX9ZqzWB4vMIkIG1SitZgj7Ah3HJVdYdHLiZxfokqRmu8hqkkWCKi9YSgxyXSt
hfbZxbGL0eUQMk1fiyA6PEkfM4VZDdvLCXVDaXP7a3F98N/ETH3Goy7IlXnLc6KO
Tk0k+17kBL5yG6YnLUlamXrXXAkgt3+UuU/xDRxeiEIbEbfnkduebPRq34wGmAOt
zCjvpUfzUwIDAQABo0IwQDAPBgNVHRMBAf8EBTADAQH/MA4GA1UdDwEB/wQEAwIB
BjAdBgNVHQ4EFgQUo5fW816iEOGrRZ88F2Q87gFwnMwwDQYJKoZIhvcNAQELBQAD
ggIBABj6W3X8PnrHX3fHyt/PX8MSxEBd1DKquGrX1RUVRpgjpeaQWxiZTOOtQqOC
MTaIzen7xASWSIsBx40Bz1szBpZGZnQdT+3Btrm0DWHMY37XLneMlhwqI2hrhVd2
cDMT/uFPpiN3GPoajOi9ZcnPP/TJF9zrx7zABC4tRi9pZsMbj/7sPtPKlL92CiUN
qXsCHKnQO18LwIE6PWThv6ctTr1NxNgpxiIY0MWscgKCP6o6ojoilzHdCGPDdRS5
YCgtW2jgFqlmgiNR9etT2DGbe+m3nUvriBbP+V04ikkwj+3x6xn0dxoxGE1nVGwv
b2X52z3sIexe9PSLymBlVNFxZPT5pqOBMzYzcfCkeF9OrYMh3jRJjehZrJ3ydlo2
8hP0r+AJx2EqbPfgna67hkooby7utHnNkDPDs3b69fBsnQGQ+p6Q9pxyz0fawx/k
NSBT8lTR32GDpgLiJTjehTItXnOQUl1CxM49S+H5GYQd1aJQzEH7QRTDvdbJWqNj
ZgKAvQU6O0ec7AAmTPWIUb+oI38YB7AL7YsmoWTTYUrrXJ/es69nA7Mf3W1daWhp
q1467HxpvMc7hU6eFbm0FU/DlXpY18ls6Wy58yljXrQs8C097Vpl4KlbQMJImYFt
nh8GKjwStIsPm6Ik8KaN1nrgS7ZklmOVhMJKzRwuJIczYOXD
-----END CERTIFICATE-----

QuoVadis Root CA 2 G3
=================================================
SHA1 Fingerprint=09:3C:61:F3:8B:8B:DC:7D:55:DF:75:38:02:05:00:E1:25:F5:C8:36
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            44:57:34:24:5b:81:89:9b:35:f2:ce:b8:2b:3b:5b:a7:26:f0:75:28
    Signature Algorithm: sha256WithRSAEncryption
        Issuer: C=BM, O=QuoVadis Limited, CN=QuoVadis Root CA 2 G3
        Validity
            Not Before: Jan 12 18:59:32 2012 GMT
            Not After : Jan 12 18:59:32 2042 GMT
        Subject: C=BM, O=QuoVadis Limited, CN=QuoVadis Root CA 2 G3
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (4096 bit)
                Modulus:
                    00:a1:ae:25:b2:01:18:dc:57:88:3f:46:eb:f9:af:
                    e2:eb:23:71:e2:9a:d1:61:66:21:5f:aa:af:27:51:
                    e5:6e:1b:16:d4:2d:7d:50:b0:53:77:bd:78:3a:60:
                    e2:64:02:9b:7c:86:9b:d6:1a:8e:ad:ff:1f:15:7f:
                    d5:95:1e:12:cb:e6:14:84:04:c1:df:36:b3:16:9f:
                    8a:e3:c9:db:98:34:ce:d8:33:17:28:46:fc:a7:c9:
                    f0:d2:b4:d5:4d:09:72:49:f9:f2:87:e3:a9:da:7d:
                    a1:7d:6b:b2:3a:25:a9:6d:52:44:ac:f8:be:6e:fb:
                    dc:a6:73:91:90:61:a6:03:14:20:f2:e7:87:a3:88:
                    ad:ad:a0:8c:ff:a6:0b:25:52:25:e7:16:01:d5:cb:
                    b8:35:81:0c:a3:3b:f0:e1:e1:fc:5a:5d:ce:80:71:
                    6d:f8:49:ab:3e:3b:ba:b8:d7:80:01:fb:a5:eb:5b:
                    b3:c5:5e:60:2a:31:a0:af:37:e8:20:3a:9f:a8:32:
                    2c:0c:cc:09:1d:d3:9e:8e:5d:bc:4c:98:ee:c5:1a:
                    68:7b:ec:53:a6:e9:14:35:a3:df:cd:80:9f:0c:48:
                    fb:1c:f4:f1:bf:4a:b8:fa:d5:8c:71:4a:c7:1f:ad:
                    fe:41:9a:b3:83:5d:f2:84:56:ef:a5:57:43:ce:29:
                    ad:8c:ab:55:bf:c4:fb:5b:01:dd:23:21:a1:58:00:
                    8e:c3:d0:6a:13:ed:13:e3:12:2b:80:dc:67:e6:95:
                    b2:cd:1e:22:6e:2a:f8:41:d4:f2:ca:14:07:8d:8a:
                    55:12:c6:69:f5:b8:86:68:2f:53:5e:b0:d2:aa:21:
                    c1:98:e6:30:e3:67:55:c7:9b:6e:ac:19:a8:55:a6:
                    45:06:d0:23:3a:db:eb:65:5d:2a:11:11:f0:3b:4f:
                    ca:6d:f4:34:c4:71:e4:ff:00:5a:f6:5c:ae:23:60:
                    85:73:f1:e4:10:b1:25:ae:d5:92:bb:13:c1:0c:e0:
                    39:da:b4:39:57:b5:ab:35:aa:72:21:3b:83:35:e7:
                    31:df:7a:21:6e:b8:32:08:7d:1d:32:91:15:4a:62:
                    72:cf:e3:77:a1:bc:d5:11:1b:76:01:67:08:e0:41:
                    0b:c3:eb:15:6e:f8:a4:19:d9:a2:ab:af:e2:27:52:
                    56:2b:02:8a:2c:14:24:f9:bf:42:02:bf:26:c8:c6:
                    8f:e0:6e:38:7d:53:2d:e5:ed:98:b3:95:63:68:7f:
                    f9:35:f4:df:88:c5:60:35:92:c0:7c:69:1c:61:95:
                    16:d0:eb:de:0b:af:3e:04:10:45:65:58:50:38:af:
                    48:f2:59:b6:16:f2:3c:0d:90:02:c6:70:2e:01:ad:
                    3c:15:d7
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Subject Key Identifier: 
                ED:E7:6F:76:5A:BF:60:EC:49:5B:C6:A5:77:BB:72:16:71:9B:C4:3D
    Signature Algorithm: sha256WithRSAEncryption
         91:df:80:3f:43:09:7e:71:c2:f7:eb:b3:88:8f:e1:51:b2:bc:
         3d:75:f9:28:5d:c8:bc:99:9b:7b:5d:aa:e5:ca:e1:0a:f7:e8:
         b2:d3:9f:dd:67:31:7e:ba:01:aa:c7:6a:41:3b:90:d4:08:5c:
         b2:60:6a:90:f0:c8:ce:03:62:f9:8b:ed:fb:6e:2a:dc:06:4d:
         3c:29:0f:89:16:8a:58:4c:48:0f:e8:84:61:ea:3c:72:a6:77:
         e4:42:ae:88:a3:43:58:79:7e:ae:ca:a5:53:0d:a9:3d:70:bd:
         20:19:61:a4:6c:38:fc:43:32:e1:c1:47:ff:f8:ec:f1:11:22:
         32:96:9c:c2:f6:5b:69:96:7b:20:0c:43:41:9a:5b:f6:59:19:
         88:de:55:88:37:51:0b:78:5c:0a:1e:a3:42:fd:c7:9d:88:0f:
         c0:f2:78:02:24:54:93:af:89:87:88:c9:4a:80:1d:ea:d0:6e:
         3e:61:2e:36:bb:35:0e:27:96:fd:66:34:3b:61:72:73:f1:16:
         5c:47:06:54:49:00:7a:58:12:b0:0a:ef:85:fd:b1:b8:33:75:
         6a:93:1c:12:e6:60:5e:6f:1d:7f:c9:1f:23:cb:84:61:9f:1e:
         82:44:f9:5f:ad:62:55:24:9a:52:98:ed:51:e7:a1:7e:97:3a:
         e6:2f:1f:11:da:53:80:2c:85:9e:ab:35:10:db:22:5f:6a:c5:
         5e:97:53:f2:32:02:09:30:a3:58:f0:0d:01:d5:72:c6:b1:7c:
         69:7b:c3:f5:36:45:cc:61:6e:5e:4c:94:c5:5e:ae:e8:0e:5e:
         8b:bf:f7:cd:e0:ed:a1:0e:1b:33:ee:54:18:fe:0f:be:ef:7e:
         84:6b:43:e3:70:98:db:5d:75:b2:0d:59:07:85:15:23:39:d6:
         f1:df:a9:26:0f:d6:48:c7:b3:a6:22:f5:33:37:5a:95:47:9f:
         7b:ba:18:15:6f:ff:d6:14:64:83:49:d2:0a:67:21:db:0f:35:
         63:60:28:22:e3:b1:95:83:cd:85:a6:dd:2f:0f:e7:67:52:6e:
         bb:2f:85:7c:f5:4a:73:e7:c5:3e:c0:bd:21:12:05:3f:fc:b7:
         03:49:02:5b:c8:25:e6:e2:54:38:f5:79:87:8c:1d:53:b2:4e:
         85:7b:06:38:c7:2c:f8:f8:b0:72:8d:25:e5:77:52:f4:03:1c:
         48:a6:50:5f:88:20:30:6e:f2:82:43:ab:3d:97:84:e7:53:fb:
         21:c1:4f:0f:22:9a:86:b8:59:2a:f6:47:3d:19:88:2d:e8:85:
         e1:9e:ec:85:08:6a:b1:6c:34:c9:1d:ec:48:2b:3b:78:ed:66:
         c4:8e:79:69:83:de:7f:8c
-----BEGIN CERTIFICATE-----
MIIFYDCCA0igAwIBAgIURFc0JFuBiZs18s64KztbpybwdSgwDQYJKoZIhvcNAQEL
BQAwSDELMAkGA1UEBhMCQk0xGTAXBgNVBAoTEFF1b1ZhZGlzIExpbWl0ZWQxHjAc
BgNVBAMTFVF1b1ZhZGlzIFJvb3QgQ0EgMiBHMzAeFw0xMjAxMTIxODU5MzJaFw00
MjAxMTIxODU5MzJaMEgxCzAJBgNVBAYTAkJNMRkwFwYDVQQKExBRdW9WYWRpcyBM
aW1pdGVkMR4wHAYDVQQDExVRdW9WYWRpcyBSb290IENBIDIgRzMwggIiMA0GCSqG
SIb3DQEBAQUAA4ICDwAwggIKAoICAQChriWyARjcV4g/Ruv5r+LrI3HimtFhZiFf
qq8nUeVuGxbULX1QsFN3vXg6YOJkApt8hpvWGo6t/x8Vf9WVHhLL5hSEBMHfNrMW
n4rjyduYNM7YMxcoRvynyfDStNVNCXJJ+fKH46nafaF9a7I6JaltUkSs+L5u+9ym
c5GQYaYDFCDy54ejiK2toIz/pgslUiXnFgHVy7g1gQyjO/Dh4fxaXc6AcW34Sas+
O7q414AB+6XrW7PFXmAqMaCvN+ggOp+oMiwMzAkd056OXbxMmO7FGmh77FOm6RQ1
o9/NgJ8MSPsc9PG/Srj61YxxSscfrf5BmrODXfKEVu+lV0POKa2Mq1W/xPtbAd0j
IaFYAI7D0GoT7RPjEiuA3GfmlbLNHiJuKvhB1PLKFAeNilUSxmn1uIZoL1NesNKq
IcGY5jDjZ1XHm26sGahVpkUG0CM62+tlXSoREfA7T8pt9DTEceT/AFr2XK4jYIVz
8eQQsSWu1ZK7E8EM4DnatDlXtas1qnIhO4M15zHfeiFuuDIIfR0ykRVKYnLP43eh
vNURG3YBZwjgQQvD6xVu+KQZ2aKrr+InUlYrAoosFCT5v0ICvybIxo/gbjh9Uy3l
7ZizlWNof/k19N+IxWA1ksB8aRxhlRbQ694Lrz4EEEVlWFA4r0jyWbYW8jwNkALG
cC4BrTwV1wIDAQABo0IwQDAPBgNVHRMBAf8EBTADAQH/MA4GA1UdDwEB/wQEAwIB
BjAdBgNVHQ4EFgQU7edvdlq/YOxJW8ald7tyFnGbxD0wDQYJKoZIhvcNAQELBQAD
ggIBAJHfgD9DCX5xwvfrs4iP4VGyvD11+ShdyLyZm3tdquXK4Qr36LLTn91nMX66
AarHakE7kNQIXLJgapDwyM4DYvmL7ftuKtwGTTwpD4kWilhMSA/ohGHqPHKmd+RC
roijQ1h5fq7KpVMNqT1wvSAZYaRsOPxDMuHBR//47PERIjKWnML2W2mWeyAMQ0Ga
W/ZZGYjeVYg3UQt4XAoeo0L9x52ID8DyeAIkVJOviYeIyUqAHerQbj5hLja7NQ4n
lv1mNDthcnPxFlxHBlRJAHpYErAK74X9sbgzdWqTHBLmYF5vHX/JHyPLhGGfHoJE
+V+tYlUkmlKY7VHnoX6XOuYvHxHaU4AshZ6rNRDbIl9qxV6XU/IyAgkwo1jwDQHV
csaxfGl7w/U2Rcxhbl5MlMVerugOXou/983g7aEOGzPuVBj+D77vfoRrQ+NwmNtd
dbINWQeFFSM51vHfqSYP1kjHs6Yi9TM3WpVHn3u6GBVv/9YUZINJ0gpnIdsPNWNg
KCLjsZWDzYWm3S8P52dSbrsvhXz1SnPnxT7AvSESBT/8twNJAlvIJebiVDj1eYeM
HVOyToV7BjjHLPj4sHKNJeV3UvQDHEimUF+IIDBu8oJDqz2XhOdT+yHBTw8imoa4
WSr2Rz0ZiC3oheGe7IUIarFsNMkd7EgrO3jtZsSOeWmD3n+M
-----END CERTIFICATE-----

QuoVadis Root CA 3 G3
================================================
SHA1 Fingerprint=48:12:BD:92:3C:A8:C4:39:06:E7:30:6D:27:96:E6:A4:CF:22:2E:7D
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            2e:f5:9b:02:28:a7:db:7a:ff:d5:a3:a9:ee:bd:03:a0:cf:12:6a:1d
    Signature Algorithm: sha256WithRSAEncryption
        Issuer: C=BM, O=QuoVadis Limited, CN=QuoVadis Root CA 3 G3
        Validity
            Not Before: Jan 12 20:26:32 2012 GMT
            Not After : Jan 12 20:26:32 2042 GMT
        Subject: C=BM, O=QuoVadis Limited, CN=QuoVadis Root CA 3 G3
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (4096 bit)
                Modulus:
                    00:b3:cb:0e:10:67:8e:ea:14:97:a7:32:2a:0a:56:
                    36:7f:68:4c:c7:b3:6f:3a:23:14:91:ff:19:7f:a5:
                    ca:ac:ee:b3:76:9d:7a:e9:8b:1b:ab:6b:31:db:fa:
                    0b:53:4c:af:c5:a5:1a:79:3c:8a:4c:ff:ac:df:25:
                    de:4e:d9:82:32:0b:44:de:ca:db:8c:ac:a3:6e:16:
                    83:3b:a6:64:4b:32:89:fb:16:16:38:7e:eb:43:e2:
                    d3:74:4a:c2:62:0a:73:0a:dd:49:b3:57:d2:b0:0a:
                    85:9d:71:3c:de:a3:cb:c0:32:f3:01:39:20:43:1b:
                    35:d1:53:b3:b1:ee:c5:93:69:82:3e:16:b5:28:46:
                    a1:de:ea:89:09:ed:43:b8:05:46:8a:86:f5:59:47:
                    be:1b:6f:01:21:10:b9:fd:a9:d2:28:ca:10:39:09:
                    ca:13:36:cf:9c:ad:ad:40:74:79:2b:02:3f:34:ff:
                    fa:20:69:7d:d3:ee:61:f5:ba:b3:e7:30:d0:37:23:
                    86:72:61:45:29:48:59:68:6f:77:a6:2e:81:be:07:
                    4d:6f:af:ce:c4:45:13:91:14:70:06:8f:1f:9f:f8:
                    87:69:b1:0e:ef:c3:89:19:eb:ea:1c:61:fc:7a:6c:
                    8a:dc:d6:03:0b:9e:26:ba:12:dd:d4:54:39:ab:26:
                    a3:33:ea:75:81:da:2d:cd:0f:4f:e4:03:d1:ef:15:
                    97:1b:6b:90:c5:02:90:93:66:02:21:b1:47:de:8b:
                    9a:4a:80:b9:55:8f:b5:a2:2f:c0:d6:33:67:da:7e:
                    c4:a7:b4:04:44:eb:47:fb:e6:58:b9:f7:0c:f0:7b:
                    2b:b1:c0:70:29:c3:40:62:2d:3b:48:69:dc:23:3c:
                    48:eb:7b:09:79:a9:6d:da:a8:30:98:cf:80:72:03:
                    88:a6:5b:46:ae:72:79:7c:08:03:21:65:ae:b7:e1:
                    1c:a5:b1:2a:a2:31:de:66:04:f7:c0:74:e8:71:de:
                    ff:3d:59:cc:96:26:12:8b:85:95:57:1a:ab:6b:75:
                    0b:44:3d:11:28:3c:7b:61:b7:e2:8f:67:4f:e5:ec:
                    3c:4c:60:80:69:57:38:1e:01:5b:8d:55:e8:c7:df:
                    c0:cc:77:23:34:49:75:7c:f6:98:11:eb:2d:de:ed:
                    41:2e:14:05:02:7f:e0:fe:20:eb:35:e7:11:ac:22:
                    ce:57:3d:de:c9:30:6d:10:03:85:cd:f1:ff:8c:16:
                    b5:c1:b2:3e:88:6c:60:7f:90:4f:95:f7:f6:2d:ad:
                    01:39:07:04:fa:75:80:7d:bf:49:50:ed:ef:c9:c4:
                    7c:1c:eb:80:7e:db:b6:d0:dd:13:fe:c9:d3:9c:d7:
                    b2:97:a9
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Subject Key Identifier: 
                C6:17:D0:BC:A8:EA:02:43:F2:1B:06:99:5D:2B:90:20:B9:D7:9C:E4
    Signature Algorithm: sha256WithRSAEncryption
         34:61:d9:56:b5:12:87:55:4d:dd:a3:35:31:46:bb:a4:07:72:
         bc:5f:61:62:e8:a5:fb:0b:37:b1:3c:b6:b3:fa:29:9d:7f:02:
         f5:a4:c9:a8:93:b7:7a:71:28:69:8f:73:e1:52:90:da:d5:be:
         3a:e5:b7:76:6a:56:80:21:df:5d:e6:e9:3a:9e:e5:3e:f6:a2:
         69:c7:2a:0a:b0:18:47:dc:20:70:7d:52:a3:3e:59:7c:c1:ba:
         c9:c8:15:40:61:ca:72:d6:70:ac:d2:b7:f0:1c:e4:86:29:f0:
         ce:ef:68:63:d0:b5:20:8a:15:61:9a:7e:86:98:b4:c9:c2:76:
         fb:cc:ba:30:16:cc:a3:61:c6:74:13:e5:6b:ef:a3:15:ea:03:
         fe:13:8b:64:e4:d3:c1:d2:e8:84:fb:49:d1:10:4d:79:66:eb:
         aa:fd:f4:8d:31:1e:70:14:ad:dc:de:67:13:4c:81:15:61:bc:
         b7:d9:91:77:71:19:81:60:bb:f0:58:a5:b5:9c:0b:f7:8f:22:
         55:27:c0:4b:01:6d:3b:99:0d:d4:1d:9b:63:67:2f:d0:ee:0d:
         ca:66:bc:94:4f:a6:ad:ed:fc:ee:63:ac:57:3f:65:25:cf:b2:
         86:8f:d0:08:ff:b8:76:14:6e:de:e5:27:ec:ab:78:b5:53:b9:
         b6:3f:e8:20:f9:d2:a8:be:61:46:ca:87:8c:84:f3:f9:f1:a0:
         68:9b:22:1e:81:26:9b:10:04:91:71:c0:06:1f:dc:a0:d3:b9:
         56:a7:e3:98:2d:7f:83:9d:df:8c:2b:9c:32:8e:32:94:f0:01:
         3c:22:2a:9f:43:c2:2e:c3:98:39:07:38:7b:fc:5e:00:42:1f:
         f3:32:26:79:83:84:f6:e5:f0:c1:51:12:c0:0b:1e:04:23:0c:
         54:a5:4c:2f:49:c5:4a:d1:b6:6e:60:0d:6b:fc:6b:8b:85:24:
         64:b7:89:0e:ab:25:47:5b:3c:cf:7e:49:bd:c7:e9:0a:c6:da:
         f7:7e:0e:17:08:d3:48:97:d0:71:92:f0:0f:39:3e:34:6a:1c:
         7d:d8:f2:22:ae:bb:69:f4:33:b4:a6:48:55:d1:0f:0e:26:e8:
         ec:b6:0b:2d:a7:85:35:cd:fd:59:c8:9f:d1:cd:3e:5a:29:34:
         b9:3d:84:ce:b1:65:d4:59:91:91:56:75:21:c1:77:9e:f9:7a:
         e1:60:9d:d3:ad:04:18:f4:7c:eb:5e:93:8f:53:4a:22:29:f8:
         48:2b:3e:4d:86:ac:5b:7f:cb:06:99:59:60:d8:58:65:95:8d:
         44:d1:f7:7f:7e:27:7f:7d:ae:80:f5:07:4c:b6:3e:9c:71:54:
         99:04:4b:fd:58:f9:98:f4
-----BEGIN CERTIFICATE-----
MIIFYDCCA0igAwIBAgIULvWbAiin23r/1aOp7r0DoM8Sah0wDQYJKoZIhvcNAQEL
BQAwSDELMAkGA1UEBhMCQk0xGTAXBgNVBAoTEFF1b1ZhZGlzIExpbWl0ZWQxHjAc
BgNVBAMTFVF1b1ZhZGlzIFJvb3QgQ0EgMyBHMzAeFw0xMjAxMTIyMDI2MzJaFw00
MjAxMTIyMDI2MzJaMEgxCzAJBgNVBAYTAkJNMRkwFwYDVQQKExBRdW9WYWRpcyBM
aW1pdGVkMR4wHAYDVQQDExVRdW9WYWRpcyBSb290IENBIDMgRzMwggIiMA0GCSqG
SIb3DQEBAQUAA4ICDwAwggIKAoICAQCzyw4QZ47qFJenMioKVjZ/aEzHs286IxSR
/xl/pcqs7rN2nXrpixurazHb+gtTTK/FpRp5PIpM/6zfJd5O2YIyC0TeytuMrKNu
FoM7pmRLMon7FhY4futD4tN0SsJiCnMK3UmzV9KwCoWdcTzeo8vAMvMBOSBDGzXR
U7Ox7sWTaYI+FrUoRqHe6okJ7UO4BUaKhvVZR74bbwEhELn9qdIoyhA5CcoTNs+c
ra1AdHkrAj80//ogaX3T7mH1urPnMNA3I4ZyYUUpSFlob3emLoG+B01vr87ERROR
FHAGjx+f+IdpsQ7vw4kZ6+ocYfx6bIrc1gMLnia6Et3UVDmrJqMz6nWB2i3ND0/k
A9HvFZcba5DFApCTZgIhsUfei5pKgLlVj7WiL8DWM2fafsSntARE60f75li59wzw
eyuxwHApw0BiLTtIadwjPEjrewl5qW3aqDCYz4ByA4imW0aucnl8CAMhZa634Ryl
sSqiMd5mBPfAdOhx3v89WcyWJhKLhZVXGqtrdQtEPREoPHtht+KPZ0/l7DxMYIBp
VzgeAVuNVejH38DMdyM0SXV89pgR6y3e7UEuFAUCf+D+IOs15xGsIs5XPd7JMG0Q
A4XN8f+MFrXBsj6IbGB/kE+V9/YtrQE5BwT6dYB9v0lQ7e/JxHwc64B+27bQ3RP+
ydOc17KXqQIDAQABo0IwQDAPBgNVHRMBAf8EBTADAQH/MA4GA1UdDwEB/wQEAwIB
BjAdBgNVHQ4EFgQUxhfQvKjqAkPyGwaZXSuQILnXnOQwDQYJKoZIhvcNAQELBQAD
ggIBADRh2Va1EodVTd2jNTFGu6QHcrxfYWLopfsLN7E8trP6KZ1/AvWkyaiTt3px
KGmPc+FSkNrVvjrlt3ZqVoAh313m6Tqe5T72omnHKgqwGEfcIHB9UqM+WXzBusnI
FUBhynLWcKzSt/Ac5IYp8M7vaGPQtSCKFWGafoaYtMnCdvvMujAWzKNhxnQT5Wvv
oxXqA/4Ti2Tk08HS6IT7SdEQTXlm66r99I0xHnAUrdzeZxNMgRVhvLfZkXdxGYFg
u/BYpbWcC/ePIlUnwEsBbTuZDdQdm2NnL9DuDcpmvJRPpq3t/O5jrFc/ZSXPsoaP
0Aj/uHYUbt7lJ+yreLVTubY/6CD50qi+YUbKh4yE8/nxoGibIh6BJpsQBJFxwAYf
3KDTuVan45gtf4Od34wrnDKOMpTwATwiKp9Dwi7DmDkHOHv8XgBCH/MyJnmDhPbl
8MFREsALHgQjDFSlTC9JxUrRtm5gDWv8a4uFJGS3iQ6rJUdbPM9+Sb3H6QrG2vd+
DhcI00iX0HGS8A85PjRqHH3Y8iKuu2n0M7SmSFXRDw4m6Oy2Cy2nhTXN/VnIn9HN
PlopNLk9hM6xZdRZkZFWdSHBd575euFgndOtBBj0fOtek49TSiIp+EgrPk2GrFt/
ywaZWWDYWGWVjUTR939+J399roD1B0y2PpxxVJkES/1Y+Zj0
-----END CERTIFICATE-----

DigiCert Assured ID Root G2
================================================
SHA1 Fingerprint=A1:4B:48:D9:43:EE:0A:0E:40:90:4F:3C:E0:A4:C0:91:93:51:5D:3F
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            0b:93:1c:3a:d6:39:67:ea:67:23:bf:c3:af:9a:f4:4b
    Signature Algorithm: sha256WithRSAEncryption
        Issuer: C=US, O=DigiCert Inc, OU=www.digicert.com, CN=DigiCert Assured ID Root G2
        Validity
            Not Before: Aug  1 12:00:00 2013 GMT
            Not After : Jan 15 12:00:00 2038 GMT
        Subject: C=US, O=DigiCert Inc, OU=www.digicert.com, CN=DigiCert Assured ID Root G2
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (2048 bit)
                Modulus:
                    00:d9:e7:28:2f:52:3f:36:72:49:88:93:34:f3:f8:
                    6a:1e:31:54:80:9f:ad:54:41:b5:47:df:96:a8:d4:
                    af:80:2d:b9:0a:cf:75:fd:89:a5:7d:24:fa:e3:22:
                    0c:2b:bc:95:17:0b:33:bf:19:4d:41:06:90:00:bd:
                    0c:4d:10:fe:07:b5:e7:1c:6e:22:55:31:65:97:bd:
                    d3:17:d2:1e:62:f3:db:ea:6c:50:8c:3f:84:0c:96:
                    cf:b7:cb:03:e0:ca:6d:a1:14:4c:1b:89:dd:ed:00:
                    b0:52:7c:af:91:6c:b1:38:13:d1:e9:12:08:c0:00:
                    b0:1c:2b:11:da:77:70:36:9b:ae:ce:79:87:dc:82:
                    70:e6:09:74:70:55:69:af:a3:68:9f:bf:dd:b6:79:
                    b3:f2:9d:70:29:55:f4:ab:ff:95:61:f3:c9:40:6f:
                    1d:d1:be:93:bb:d3:88:2a:bb:9d:bf:72:5a:56:71:
                    3b:3f:d4:f3:d1:0a:fe:28:ef:a3:ee:d9:99:af:03:
                    d3:8f:60:b7:f2:92:a1:b1:bd:89:89:1f:30:cd:c3:
                    a6:2e:62:33:ae:16:02:77:44:5a:e7:81:0a:3c:a7:
                    44:2e:79:b8:3f:04:bc:5c:a0:87:e1:1b:af:51:8e:
                    cd:ec:2c:fa:f8:fe:6d:f0:3a:7c:aa:8b:e4:67:95:
                    31:8d
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Key Usage: critical
                Digital Signature, Certificate Sign, CRL Sign
            X509v3 Subject Key Identifier: 
                CE:C3:4A:B9:99:55:F2:B8:DB:60:BF:A9:7E:BD:56:B5:97:36:A7:D6
    Signature Algorithm: sha256WithRSAEncryption
         ca:a5:55:8c:e3:c8:41:6e:69:27:a7:75:11:ef:3c:86:36:6f:
         d2:9d:c6:78:38:1d:69:96:a2:92:69:2e:38:6c:9b:7d:04:d4:
         89:a5:b1:31:37:8a:c9:21:cc:ab:6c:cd:8b:1c:9a:d6:bf:48:
         d2:32:66:c1:8a:c0:f3:2f:3a:ef:c0:e3:d4:91:86:d1:50:e3:
         03:db:73:77:6f:4a:39:53:ed:de:26:c7:b5:7d:af:2b:42:d1:
         75:62:e3:4a:2b:02:c7:50:4b:e0:69:e2:96:6c:0e:44:66:10:
         44:8f:ad:05:eb:f8:79:ac:a6:1b:e8:37:34:9d:53:c9:61:aa:
         a2:52:af:4a:70:16:86:c2:3a:c8:b1:13:70:36:d8:cf:ee:f4:
         0a:34:d5:5b:4c:fd:07:9c:a2:ba:d9:01:72:5c:f3:4d:c1:dd:
         0e:b1:1c:0d:c4:63:be:ad:f4:14:fb:89:ec:a2:41:0e:4c:cc:
         c8:57:40:d0:6e:03:aa:cd:0c:8e:89:99:99:6c:f0:3c:30:af:
         38:df:6f:bc:a3:be:29:20:27:ab:74:ff:13:22:78:de:97:52:
         55:1e:83:b5:54:20:03:ee:ae:c0:4f:56:de:37:cc:c3:7f:aa:
         04:27:bb:d3:77:b8:62:db:17:7c:9c:28:22:13:73:6c:cf:26:
         f5:8a:29:e7
-----BEGIN CERTIFICATE-----
MIIDljCCAn6gAwIBAgIQC5McOtY5Z+pnI7/Dr5r0SzANBgkqhkiG9w0BAQsFADBl
MQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
d3cuZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVkIElEIFJv
b3QgRzIwHhcNMTMwODAxMTIwMDAwWhcNMzgwMTE1MTIwMDAwWjBlMQswCQYDVQQG
EwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNl
cnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVkIElEIFJvb3QgRzIwggEi
MA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDZ5ygvUj82ckmIkzTz+GoeMVSA
n61UQbVH35ao1K+ALbkKz3X9iaV9JPrjIgwrvJUXCzO/GU1BBpAAvQxNEP4Htecc
biJVMWWXvdMX0h5i89vqbFCMP4QMls+3ywPgym2hFEwbid3tALBSfK+RbLE4E9Hp
EgjAALAcKxHad3A2m67OeYfcgnDmCXRwVWmvo2ifv922ebPynXApVfSr/5Vh88lA
bx3RvpO704gqu52/clpWcTs/1PPRCv4o76Pu2ZmvA9OPYLfykqGxvYmJHzDNw6Yu
YjOuFgJ3RFrngQo8p0Quebg/BLxcoIfhG69Rjs3sLPr4/m3wOnyqi+RnlTGNAgMB
AAGjQjBAMA8GA1UdEwEB/wQFMAMBAf8wDgYDVR0PAQH/BAQDAgGGMB0GA1UdDgQW
BBTOw0q5mVXyuNtgv6l+vVa1lzan1jANBgkqhkiG9w0BAQsFAAOCAQEAyqVVjOPI
QW5pJ6d1Ee88hjZv0p3GeDgdaZaikmkuOGybfQTUiaWxMTeKySHMq2zNixya1r9I
0jJmwYrA8y8678Dj1JGG0VDjA9tzd29KOVPt3ibHtX2vK0LRdWLjSisCx1BL4Gni
lmwORGYQRI+tBev4eaymG+g3NJ1TyWGqolKvSnAWhsI6yLETcDbYz+70CjTVW0z9
B5yiutkBclzzTcHdDrEcDcRjvq30FPuJ7KJBDkzMyFdA0G4Dqs0MjomZmWzwPDCv
ON9vvKO+KSAnq3T/EyJ43pdSVR6DtVQgA+6uwE9W3jfMw3+qBCe703e4YtsXfJwo
IhNzbM8m9Yop5w==
-----END CERTIFICATE-----

DigiCert Assured ID Root G3
================================================
SHA1 Fingerprint=F5:17:A2:4F:9A:48:C6:C9:F8:A2:00:26:9F:DC:0F:48:2C:AB:30:89
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            0b:a1:5a:fa:1d:df:a0:b5:49:44:af:cd:24:a0:6c:ec
    Signature Algorithm: ecdsa-with-SHA384
        Issuer: C=US, O=DigiCert Inc, OU=www.digicert.com, CN=DigiCert Assured ID Root G3
        Validity
            Not Before: Aug  1 12:00:00 2013 GMT
            Not After : Jan 15 12:00:00 2038 GMT
        Subject: C=US, O=DigiCert Inc, OU=www.digicert.com, CN=DigiCert Assured ID Root G3
        Subject Public Key Info:
            Public Key Algorithm: id-ecPublicKey
                Public-Key: (384 bit)
                pub: 
                    04:19:e7:bc:ac:44:65:ed:cd:b8:3f:58:fb:8d:b1:
                    57:a9:44:2d:05:15:f2:ef:0b:ff:10:74:9f:b5:62:
                    52:5f:66:7e:1f:e5:dc:1b:45:79:0b:cc:c6:53:0a:
                    9d:8d:5d:02:d9:a9:59:de:02:5a:f6:95:2a:0e:8d:
                    38:4a:8a:49:c6:bc:c6:03:38:07:5f:55:da:7e:09:
                    6e:e2:7f:5e:d0:45:20:0f:59:76:10:d6:a0:24:f0:
                    2d:de:36:f2:6c:29:39
                ASN1 OID: secp384r1
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Key Usage: critical
                Digital Signature, Certificate Sign, CRL Sign
            X509v3 Subject Key Identifier: 
                CB:D0:BD:A9:E1:98:05:51:A1:4D:37:A2:83:79:CE:8D:1D:2A:E4:84
    Signature Algorithm: ecdsa-with-SHA384
         30:64:02:30:25:a4:81:45:02:6b:12:4b:75:74:4f:c8:23:e3:
         70:f2:75:72:de:7c:89:f0:cf:91:72:61:9e:5e:10:92:59:56:
         b9:83:c7:10:e7:38:e9:58:26:36:7d:d5:e4:34:86:39:02:30:
         7c:36:53:f0:30:e5:62:63:3a:99:e2:b6:a3:3b:9b:34:fa:1e:
         da:10:92:71:5e:91:13:a7:dd:a4:6e:92:cc:32:d6:f5:21:66:
         c7:2f:ea:96:63:6a:65:45:92:95:01:b4
-----BEGIN CERTIFICATE-----
MIICRjCCAc2gAwIBAgIQC6Fa+h3foLVJRK/NJKBs7DAKBggqhkjOPQQDAzBlMQsw
CQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cu
ZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVkIElEIFJvb3Qg
RzMwHhcNMTMwODAxMTIwMDAwWhcNMzgwMTE1MTIwMDAwWjBlMQswCQYDVQQGEwJV
UzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQu
Y29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVkIElEIFJvb3QgRzMwdjAQBgcq
hkjOPQIBBgUrgQQAIgNiAAQZ57ysRGXtzbg/WPuNsVepRC0FFfLvC/8QdJ+1YlJf
Zn4f5dwbRXkLzMZTCp2NXQLZqVneAlr2lSoOjThKiknGvMYDOAdfVdp+CW7if17Q
RSAPWXYQ1qAk8C3eNvJsKTmjQjBAMA8GA1UdEwEB/wQFMAMBAf8wDgYDVR0PAQH/
BAQDAgGGMB0GA1UdDgQWBBTL0L2p4ZgFUaFNN6KDec6NHSrkhDAKBggqhkjOPQQD
AwNnADBkAjAlpIFFAmsSS3V0T8gj43DydXLefInwz5FyYZ5eEJJZVrmDxxDnOOlY
JjZ91eQ0hjkCMHw2U/Aw5WJjOpnitqM7mzT6HtoQknFekROn3aRukswy1vUhZscv
6pZjamVFkpUBtA==
-----END CERTIFICATE-----

DigiCert Global Root G2
================================================
SHA1 Fingerprint=DF:3C:24:F9:BF:D6:66:76:1B:26:80:73:FE:06:D1:CC:8D:4F:82:A4
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            03:3a:f1:e6:a7:11:a9:a0:bb:28:64:b1:1d:09:fa:e5
    Signature Algorithm: sha256WithRSAEncryption
        Issuer: C=US, O=DigiCert Inc, OU=www.digicert.com, CN=DigiCert Global Root G2
        Validity
            Not Before: Aug  1 12:00:00 2013 GMT
            Not After : Jan 15 12:00:00 2038 GMT
        Subject: C=US, O=DigiCert Inc, OU=www.digicert.com, CN=DigiCert Global Root G2
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (2048 bit)
                Modulus:
                    00:bb:37:cd:34:dc:7b:6b:c9:b2:68:90:ad:4a:75:
                    ff:46:ba:21:0a:08:8d:f5:19:54:c9:fb:88:db:f3:
                    ae:f2:3a:89:91:3c:7a:e6:ab:06:1a:6b:cf:ac:2d:
                    e8:5e:09:24:44:ba:62:9a:7e:d6:a3:a8:7e:e0:54:
                    75:20:05:ac:50:b7:9c:63:1a:6c:30:dc:da:1f:19:
                    b1:d7:1e:de:fd:d7:e0:cb:94:83:37:ae:ec:1f:43:
                    4e:dd:7b:2c:d2:bd:2e:a5:2f:e4:a9:b8:ad:3a:d4:
                    99:a4:b6:25:e9:9b:6b:00:60:92:60:ff:4f:21:49:
                    18:f7:67:90:ab:61:06:9c:8f:f2:ba:e9:b4:e9:92:
                    32:6b:b5:f3:57:e8:5d:1b:cd:8c:1d:ab:95:04:95:
                    49:f3:35:2d:96:e3:49:6d:dd:77:e3:fb:49:4b:b4:
                    ac:55:07:a9:8f:95:b3:b4:23:bb:4c:6d:45:f0:f6:
                    a9:b2:95:30:b4:fd:4c:55:8c:27:4a:57:14:7c:82:
                    9d:cd:73:92:d3:16:4a:06:0c:8c:50:d1:8f:1e:09:
                    be:17:a1:e6:21:ca:fd:83:e5:10:bc:83:a5:0a:c4:
                    67:28:f6:73:14:14:3d:46:76:c3:87:14:89:21:34:
                    4d:af:0f:45:0c:a6:49:a1:ba:bb:9c:c5:b1:33:83:
                    29:85
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Key Usage: critical
                Digital Signature, Certificate Sign, CRL Sign
            X509v3 Subject Key Identifier: 
                4E:22:54:20:18:95:E6:E3:6E:E6:0F:FA:FA:B9:12:ED:06:17:8F:39
    Signature Algorithm: sha256WithRSAEncryption
         60:67:28:94:6f:0e:48:63:eb:31:dd:ea:67:18:d5:89:7d:3c:
         c5:8b:4a:7f:e9:be:db:2b:17:df:b0:5f:73:77:2a:32:13:39:
         81:67:42:84:23:f2:45:67:35:ec:88:bf:f8:8f:b0:61:0c:34:
         a4:ae:20:4c:84:c6:db:f8:35:e1:76:d9:df:a6:42:bb:c7:44:
         08:86:7f:36:74:24:5a:da:6c:0d:14:59:35:bd:f2:49:dd:b6:
         1f:c9:b3:0d:47:2a:3d:99:2f:bb:5c:bb:b5:d4:20:e1:99:5f:
         53:46:15:db:68:9b:f0:f3:30:d5:3e:31:e2:8d:84:9e:e3:8a:
         da:da:96:3e:35:13:a5:5f:f0:f9:70:50:70:47:41:11:57:19:
         4e:c0:8f:ae:06:c4:95:13:17:2f:1b:25:9f:75:f2:b1:8e:99:
         a1:6f:13:b1:41:71:fe:88:2a:c8:4f:10:20:55:d7:f3:14:45:
         e5:e0:44:f4:ea:87:95:32:93:0e:fe:53:46:fa:2c:9d:ff:8b:
         22:b9:4b:d9:09:45:a4:de:a4:b8:9a:58:dd:1b:7d:52:9f:8e:
         59:43:88:81:a4:9e:26:d5:6f:ad:dd:0d:c6:37:7d:ed:03:92:
         1b:e5:77:5f:76:ee:3c:8d:c4:5d:56:5b:a2:d9:66:6e:b3:35:
         37:e5:32:b6
-----BEGIN CERTIFICATE-----
MIIDjjCCAnagAwIBAgIQAzrx5qcRqaC7KGSxHQn65TANBgkqhkiG9w0BAQsFADBh
MQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
d3cuZGlnaWNlcnQuY29tMSAwHgYDVQQDExdEaWdpQ2VydCBHbG9iYWwgUm9vdCBH
MjAeFw0xMzA4MDExMjAwMDBaFw0zODAxMTUxMjAwMDBaMGExCzAJBgNVBAYTAlVT
MRUwEwYDVQQKEwxEaWdpQ2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5j
b20xIDAeBgNVBAMTF0RpZ2lDZXJ0IEdsb2JhbCBSb290IEcyMIIBIjANBgkqhkiG
9w0BAQEFAAOCAQ8AMIIBCgKCAQEAuzfNNNx7a8myaJCtSnX/RrohCgiN9RlUyfuI
2/Ou8jqJkTx65qsGGmvPrC3oXgkkRLpimn7Wo6h+4FR1IAWsULecYxpsMNzaHxmx
1x7e/dfgy5SDN67sH0NO3Xss0r0upS/kqbitOtSZpLYl6ZtrAGCSYP9PIUkY92eQ
q2EGnI/yuum06ZIya7XzV+hdG82MHauVBJVJ8zUtluNJbd134/tJS7SsVQepj5Wz
tCO7TG1F8PapspUwtP1MVYwnSlcUfIKdzXOS0xZKBgyMUNGPHgm+F6HmIcr9g+UQ
vIOlCsRnKPZzFBQ9RnbDhxSJITRNrw9FDKZJobq7nMWxM4MphQIDAQABo0IwQDAP
BgNVHRMBAf8EBTADAQH/MA4GA1UdDwEB/wQEAwIBhjAdBgNVHQ4EFgQUTiJUIBiV
5uNu5g/6+rkS7QYXjzkwDQYJKoZIhvcNAQELBQADggEBAGBnKJRvDkhj6zHd6mcY
1Yl9PMWLSn/pvtsrF9+wX3N3KjITOYFnQoQj8kVnNeyIv/iPsGEMNKSuIEyExtv4
NeF22d+mQrvHRAiGfzZ0JFrabA0UWTW98kndth/Jsw1HKj2ZL7tcu7XUIOGZX1NG
Fdtom/DzMNU+MeKNhJ7jitralj41E6Vf8PlwUHBHQRFXGU7Aj64GxJUTFy8bJZ91
8rGOmaFvE7FBcf6IKshPECBV1/MUReXgRPTqh5Uykw7+U0b6LJ3/iyK5S9kJRaTe
pLiaWN0bfVKfjllDiIGknibVb63dDcY3fe0Dkhvld1927jyNxF1WW6LZZm6zNTfl
MrY=
-----END CERTIFICATE-----

DigiCert Global Root G3
================================================
SHA1 Fingerprint=7E:04:DE:89:6A:3E:66:6D:00:E6:87:D3:3F:FA:D9:3B:E8:3D:34:9E
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            05:55:56:bc:f2:5e:a4:35:35:c3:a4:0f:d5:ab:45:72
    Signature Algorithm: ecdsa-with-SHA384
        Issuer: C=US, O=DigiCert Inc, OU=www.digicert.com, CN=DigiCert Global Root G3
        Validity
            Not Before: Aug  1 12:00:00 2013 GMT
            Not After : Jan 15 12:00:00 2038 GMT
        Subject: C=US, O=DigiCert Inc, OU=www.digicert.com, CN=DigiCert Global Root G3
        Subject Public Key Info:
            Public Key Algorithm: id-ecPublicKey
                Public-Key: (384 bit)
                pub: 
                    04:dd:a7:d9:bb:8a:b8:0b:fb:0b:7f:21:d2:f0:be:
                    be:73:f3:33:5d:1a:bc:34:ea:de:c6:9b:bc:d0:95:
                    f6:f0:cc:d0:0b:ba:61:5b:51:46:7e:9e:2d:9f:ee:
                    8e:63:0c:17:ec:07:70:f5:cf:84:2e:40:83:9c:e8:
                    3f:41:6d:3b:ad:d3:a4:14:59:36:78:9d:03:43:ee:
                    10:13:6c:72:de:ae:88:a7:a1:6b:b5:43:ce:67:dc:
                    23:ff:03:1c:a3:e2:3e
                ASN1 OID: secp384r1
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Key Usage: critical
                Digital Signature, Certificate Sign, CRL Sign
            X509v3 Subject Key Identifier: 
                B3:DB:48:A4:F9:A1:C5:D8:AE:36:41:CC:11:63:69:62:29:BC:4B:C6
    Signature Algorithm: ecdsa-with-SHA384
         30:65:02:31:00:ad:bc:f2:6c:3f:12:4a:d1:2d:39:c3:0a:09:
         97:73:f4:88:36:8c:88:27:bb:e6:88:8d:50:85:a7:63:f9:9e:
         32:de:66:93:0f:f1:cc:b1:09:8f:dd:6c:ab:fa:6b:7f:a0:02:
         30:39:66:5b:c2:64:8d:b8:9e:50:dc:a8:d5:49:a2:ed:c7:dc:
         d1:49:7f:17:01:b8:c8:86:8f:4e:8c:88:2b:a8:9a:a9:8a:c5:
         d1:00:bd:f8:54:e2:9a:e5:5b:7c:b3:27:17
-----BEGIN CERTIFICATE-----
MIICPzCCAcWgAwIBAgIQBVVWvPJepDU1w6QP1atFcjAKBggqhkjOPQQDAzBhMQsw
CQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cu
ZGlnaWNlcnQuY29tMSAwHgYDVQQDExdEaWdpQ2VydCBHbG9iYWwgUm9vdCBHMzAe
Fw0xMzA4MDExMjAwMDBaFw0zODAxMTUxMjAwMDBaMGExCzAJBgNVBAYTAlVTMRUw
EwYDVQQKEwxEaWdpQ2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20x
IDAeBgNVBAMTF0RpZ2lDZXJ0IEdsb2JhbCBSb290IEczMHYwEAYHKoZIzj0CAQYF
K4EEACIDYgAE3afZu4q4C/sLfyHS8L6+c/MzXRq8NOrexpu80JX28MzQC7phW1FG
fp4tn+6OYwwX7Adw9c+ELkCDnOg/QW07rdOkFFk2eJ0DQ+4QE2xy3q6Ip6FrtUPO
Z9wj/wMco+I+o0IwQDAPBgNVHRMBAf8EBTADAQH/MA4GA1UdDwEB/wQEAwIBhjAd
BgNVHQ4EFgQUs9tIpPmhxdiuNkHMEWNpYim8S8YwCgYIKoZIzj0EAwMDaAAwZQIx
AK288mw/EkrRLTnDCgmXc/SINoyIJ7vmiI1Qhadj+Z4y3maTD/HMsQmP3Wyr+mt/
oAIwOWZbwmSNuJ5Q3KjVSaLtx9zRSX8XAbjIho9OjIgrqJqpisXRAL34VOKa5Vt8
sycX
-----END CERTIFICATE-----

DigiCert Trusted Root G4
================================================
SHA1 Fingerprint=DD:FB:16:CD:49:31:C9:73:A2:03:7D:3F:C8:3A:4D:7D:77:5D:05:E4
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            05:9b:1b:57:9e:8e:21:32:e2:39:07:bd:a7:77:75:5c
    Signature Algorithm: sha384WithRSAEncryption
        Issuer: C=US, O=DigiCert Inc, OU=www.digicert.com, CN=DigiCert Trusted Root G4
        Validity
            Not Before: Aug  1 12:00:00 2013 GMT
            Not After : Jan 15 12:00:00 2038 GMT
        Subject: C=US, O=DigiCert Inc, OU=www.digicert.com, CN=DigiCert Trusted Root G4
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (4096 bit)
                Modulus:
                    00:bf:e6:90:73:68:de:bb:e4:5d:4a:3c:30:22:30:
                    69:33:ec:c2:a7:25:2e:c9:21:3d:f2:8a:d8:59:c2:
                    e1:29:a7:3d:58:ab:76:9a:cd:ae:7b:1b:84:0d:c4:
                    30:1f:f3:1b:a4:38:16:eb:56:c6:97:6d:1d:ab:b2:
                    79:f2:ca:11:d2:e4:5f:d6:05:3c:52:0f:52:1f:c6:
                    9e:15:a5:7e:be:9f:a9:57:16:59:55:72:af:68:93:
                    70:c2:b2:ba:75:99:6a:73:32:94:d1:10:44:10:2e:
                    df:82:f3:07:84:e6:74:3b:6d:71:e2:2d:0c:1b:ee:
                    20:d5:c9:20:1d:63:29:2d:ce:ec:5e:4e:c8:93:f8:
                    21:61:9b:34:eb:05:c6:5e:ec:5b:1a:bc:eb:c9:cf:
                    cd:ac:34:40:5f:b1:7a:66:ee:77:c8:48:a8:66:57:
                    57:9f:54:58:8e:0c:2b:b7:4f:a7:30:d9:56:ee:ca:
                    7b:5d:e3:ad:c9:4f:5e:e5:35:e7:31:cb:da:93:5e:
                    dc:8e:8f:80:da:b6:91:98:40:90:79:c3:78:c7:b6:
                    b1:c4:b5:6a:18:38:03:10:8d:d8:d4:37:a4:2e:05:
                    7d:88:f5:82:3e:10:91:70:ab:55:82:41:32:d7:db:
                    04:73:2a:6e:91:01:7c:21:4c:d4:bc:ae:1b:03:75:
                    5d:78:66:d9:3a:31:44:9a:33:40:bf:08:d7:5a:49:
                    a4:c2:e6:a9:a0:67:dd:a4:27:bc:a1:4f:39:b5:11:
                    58:17:f7:24:5c:46:8f:64:f7:c1:69:88:76:98:76:
                    3d:59:5d:42:76:87:89:97:69:7a:48:f0:e0:a2:12:
                    1b:66:9a:74:ca:de:4b:1e:e7:0e:63:ae:e6:d4:ef:
                    92:92:3a:9e:3d:dc:00:e4:45:25:89:b6:9a:44:19:
                    2b:7e:c0:94:b4:d2:61:6d:eb:33:d9:c5:df:4b:04:
                    00:cc:7d:1c:95:c3:8f:f7:21:b2:b2:11:b7:bb:7f:
                    f2:d5:8c:70:2c:41:60:aa:b1:63:18:44:95:1a:76:
                    62:7e:f6:80:b0:fb:e8:64:a6:33:d1:89:07:e1:bd:
                    b7:e6:43:a4:18:b8:a6:77:01:e1:0f:94:0c:21:1d:
                    b2:54:29:25:89:6c:e5:0e:52:51:47:74:be:26:ac:
                    b6:41:75:de:7a:ac:5f:8d:3f:c9:bc:d3:41:11:12:
                    5b:e5:10:50:eb:31:c5:ca:72:16:22:09:df:7c:4c:
                    75:3f:63:ec:21:5f:c4:20:51:6b:6f:b1:ab:86:8b:
                    4f:c2:d6:45:5f:9d:20:fc:a1:1e:c5:c0:8f:a2:b1:
                    7e:0a:26:99:f5:e4:69:2f:98:1d:2d:f5:d9:a9:b2:
                    1d:e5:1b
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Key Usage: critical
                Digital Signature, Certificate Sign, CRL Sign
            X509v3 Subject Key Identifier: 
                EC:D7:E3:82:D2:71:5D:64:4C:DF:2E:67:3F:E7:BA:98:AE:1C:0F:4F
    Signature Algorithm: sha384WithRSAEncryption
         bb:61:d9:7d:a9:6c:be:17:c4:91:1b:c3:a1:a2:00:8d:e3:64:
         68:0f:56:cf:77:ae:70:f9:fd:9a:4a:99:b9:c9:78:5c:0c:0c:
         5f:e4:e6:14:29:56:0b:36:49:5d:44:63:e0:ad:9c:96:18:66:
         1b:23:0d:3d:79:e9:6d:6b:d6:54:f8:d2:3c:c1:43:40:ae:1d:
         50:f5:52:fc:90:3b:bb:98:99:69:6b:c7:c1:a7:a8:68:a4:27:
         dc:9d:f9:27:ae:30:85:b9:f6:67:4d:3a:3e:8f:59:39:22:53:
         44:eb:c8:5d:03:ca:ed:50:7a:7d:62:21:0a:80:c8:73:66:d1:
         a0:05:60:5f:e8:a5:b4:a7:af:a8:f7:6d:35:9c:7c:5a:8a:d6:
         a2:38:99:f3:78:8b:f4:4d:d2:20:0b:de:04:ee:8c:9b:47:81:
         72:0d:c0:14:32:ef:30:59:2e:ae:e0:71:f2:56:e4:6a:97:6f:
         92:50:6d:96:8d:68:7a:9a:b2:36:14:7a:06:f2:24:b9:09:11:
         50:d7:08:b1:b8:89:7a:84:23:61:42:29:e5:a3:cd:a2:20:41:
         d7:d1:9c:64:d9:ea:26:a1:8b:14:d7:4c:19:b2:50:41:71:3d:
         3f:4d:70:23:86:0c:4a:dc:81:d2:cc:32:94:84:0d:08:09:97:
         1c:4f:c0:ee:6b:20:74:30:d2:e0:39:34:10:85:21:15:01:08:
         e8:55:32:de:71:49:d9:28:17:50:4d:e6:be:4d:d1:75:ac:d0:
         ca:fb:41:b8:43:a5:aa:d3:c3:05:44:4f:2c:36:9b:e2:fa:e2:
         45:b8:23:53:6c:06:6f:67:55:7f:46:b5:4c:3f:6e:28:5a:79:
         26:d2:a4:a8:62:97:d2:1e:e2:ed:4a:8b:bc:1b:fd:47:4a:0d:
         df:67:66:7e:b2:5b:41:d0:3b:e4:f4:3b:f4:04:63:e9:ef:c2:
         54:00:51:a0:8a:2a:c9:ce:78:cc:d5:ea:87:04:18:b3:ce:af:
         49:88:af:f3:92:99:b6:b3:e6:61:0f:d2:85:00:e7:50:1a:e4:
         1b:95:9d:19:a1:b9:9c:b1:9b:b1:00:1e:ef:d0:0f:4f:42:6c:
         c9:0a:bc:ee:43:fa:3a:71:a5:c8:4d:26:a5:35:fd:89:5d:bc:
         85:62:1d:32:d2:a0:2b:54:ed:9a:57:c1:db:fa:10:cf:19:b7:
         8b:4a:1b:8f:01:b6:27:95:53:e8:b6:89:6d:5b:bc:68:d4:23:
         e8:8b:51:a2:56:f9:f0:a6:80:a0:d6:1e:b3:bc:0f:0f:53:75:
         29:aa:ea:13:77:e4:de:8c:81:21:ad:07:10:47:11:ad:87:3d:
         07:d1:75:bc:cf:f3:66:7e
-----BEGIN CERTIFICATE-----
MIIFkDCCA3igAwIBAgIQBZsbV56OITLiOQe9p3d1XDANBgkqhkiG9w0BAQwFADBi
MQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
d3cuZGlnaWNlcnQuY29tMSEwHwYDVQQDExhEaWdpQ2VydCBUcnVzdGVkIFJvb3Qg
RzQwHhcNMTMwODAxMTIwMDAwWhcNMzgwMTE1MTIwMDAwWjBiMQswCQYDVQQGEwJV
UzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQu
Y29tMSEwHwYDVQQDExhEaWdpQ2VydCBUcnVzdGVkIFJvb3QgRzQwggIiMA0GCSqG
SIb3DQEBAQUAA4ICDwAwggIKAoICAQC/5pBzaN675F1KPDAiMGkz7MKnJS7JIT3y
ithZwuEppz1Yq3aaza57G4QNxDAf8xukOBbrVsaXbR2rsnnyyhHS5F/WBTxSD1If
xp4VpX6+n6lXFllVcq9ok3DCsrp1mWpzMpTREEQQLt+C8weE5nQ7bXHiLQwb7iDV
ySAdYyktzuxeTsiT+CFhmzTrBcZe7FsavOvJz82sNEBfsXpm7nfISKhmV1efVFiO
DCu3T6cw2Vbuyntd463JT17lNecxy9qTXtyOj4DatpGYQJB5w3jHtrHEtWoYOAMQ
jdjUN6QuBX2I9YI+EJFwq1WCQTLX2wRzKm6RAXwhTNS8rhsDdV14Ztk6MUSaM0C/
CNdaSaTC5qmgZ92kJ7yhTzm1EVgX9yRcRo9k98FpiHaYdj1ZXUJ2h4mXaXpI8OCi
EhtmmnTK3kse5w5jrubU75KSOp493ADkRSWJtppEGSt+wJS00mFt6zPZxd9LBADM
fRyVw4/3IbKyEbe7f/LVjHAsQWCqsWMYRJUadmJ+9oCw++hkpjPRiQfhvbfmQ6QY
uKZ3AeEPlAwhHbJUKSWJbOUOUlFHdL4mrLZBdd56rF+NP8m800ERElvlEFDrMcXK
chYiCd98THU/Y+whX8QgUWtvsauGi0/C1kVfnSD8oR7FwI+isX4KJpn15GkvmB0t
9dmpsh3lGwIDAQABo0IwQDAPBgNVHRMBAf8EBTADAQH/MA4GA1UdDwEB/wQEAwIB
hjAdBgNVHQ4EFgQU7NfjgtJxXWRM3y5nP+e6mK4cD08wDQYJKoZIhvcNAQEMBQAD
ggIBALth2X2pbL4XxJEbw6GiAI3jZGgPVs93rnD5/ZpKmbnJeFwMDF/k5hQpVgs2
SV1EY+CtnJYYZhsjDT156W1r1lT40jzBQ0CuHVD1UvyQO7uYmWlrx8GnqGikJ9yd
+SeuMIW59mdNOj6PWTkiU0TryF0Dyu1Qen1iIQqAyHNm0aAFYF/opbSnr6j3bTWc
fFqK1qI4mfN4i/RN0iAL3gTujJtHgXINwBQy7zBZLq7gcfJW5GqXb5JQbZaNaHqa
sjYUegbyJLkJEVDXCLG4iXqEI2FCKeWjzaIgQdfRnGTZ6iahixTXTBmyUEFxPT9N
cCOGDErcgdLMMpSEDQgJlxxPwO5rIHQw0uA5NBCFIRUBCOhVMt5xSdkoF1BN5r5N
0XWs0Mr7QbhDparTwwVETyw2m+L64kW4I1NsBm9nVX9GtUw/bihaeSbSpKhil9Ie
4u1Ki7wb/UdKDd9nZn6yW0HQO+T0O/QEY+nvwlQAUaCKKsnOeMzV6ocEGLPOr0mI
r/OSmbaz5mEP0oUA51Aa5BuVnRmhuZyxm7EAHu/QD09CbMkKvO5D+jpxpchNJqU1
/YldvIViHTLSoCtU7ZpXwdv6EM8Zt4tKG48BtieVU+i2iW1bvGjUI+iLUaJW+fCm
gKDWHrO8Dw9TdSmq6hN35N6MgSGtBxBHEa2HPQfRdbzP82Z+
-----END CERTIFICATE-----

COMODO RSA Certification Authority
================================================
SHA1 Fingerprint=AF:E5:D2:44:A8:D1:19:42:30:FF:47:9F:E2:F8:97:BB:CD:7A:8C:B4
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            4c:aa:f9:ca:db:63:6f:e0:1f:f7:4e:d8:5b:03:86:9d
    Signature Algorithm: sha384WithRSAEncryption
        Issuer: C=GB, ST=Greater Manchester, L=Salford, O=COMODO CA Limited, CN=COMODO RSA Certification Authority
        Validity
            Not Before: Jan 19 00:00:00 2010 GMT
            Not After : Jan 18 23:59:59 2038 GMT
        Subject: C=GB, ST=Greater Manchester, L=Salford, O=COMODO CA Limited, CN=COMODO RSA Certification Authority
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (4096 bit)
                Modulus:
                    00:91:e8:54:92:d2:0a:56:b1:ac:0d:24:dd:c5:cf:
                    44:67:74:99:2b:37:a3:7d:23:70:00:71:bc:53:df:
                    c4:fa:2a:12:8f:4b:7f:10:56:bd:9f:70:72:b7:61:
                    7f:c9:4b:0f:17:a7:3d:e3:b0:04:61:ee:ff:11:97:
                    c7:f4:86:3e:0a:fa:3e:5c:f9:93:e6:34:7a:d9:14:
                    6b:e7:9c:b3:85:a0:82:7a:76:af:71:90:d7:ec:fd:
                    0d:fa:9c:6c:fa:df:b0:82:f4:14:7e:f9:be:c4:a6:
                    2f:4f:7f:99:7f:b5:fc:67:43:72:bd:0c:00:d6:89:
                    eb:6b:2c:d3:ed:8f:98:1c:14:ab:7e:e5:e3:6e:fc:
                    d8:a8:e4:92:24:da:43:6b:62:b8:55:fd:ea:c1:bc:
                    6c:b6:8b:f3:0e:8d:9a:e4:9b:6c:69:99:f8:78:48:
                    30:45:d5:ad:e1:0d:3c:45:60:fc:32:96:51:27:bc:
                    67:c3:ca:2e:b6:6b:ea:46:c7:c7:20:a0:b1:1f:65:
                    de:48:08:ba:a4:4e:a9:f2:83:46:37:84:eb:e8:cc:
                    81:48:43:67:4e:72:2a:9b:5c:bd:4c:1b:28:8a:5c:
                    22:7b:b4:ab:98:d9:ee:e0:51:83:c3:09:46:4e:6d:
                    3e:99:fa:95:17:da:7c:33:57:41:3c:8d:51:ed:0b:
                    b6:5c:af:2c:63:1a:df:57:c8:3f:bc:e9:5d:c4:9b:
                    af:45:99:e2:a3:5a:24:b4:ba:a9:56:3d:cf:6f:aa:
                    ff:49:58:be:f0:a8:ff:f4:b8:ad:e9:37:fb:ba:b8:
                    f4:0b:3a:f9:e8:43:42:1e:89:d8:84:cb:13:f1:d9:
                    bb:e1:89:60:b8:8c:28:56:ac:14:1d:9c:0a:e7:71:
                    eb:cf:0e:dd:3d:a9:96:a1:48:bd:3c:f7:af:b5:0d:
                    22:4c:c0:11:81:ec:56:3b:f6:d3:a2:e2:5b:b7:b2:
                    04:22:52:95:80:93:69:e8:8e:4c:65:f1:91:03:2d:
                    70:74:02:ea:8b:67:15:29:69:52:02:bb:d7:df:50:
                    6a:55:46:bf:a0:a3:28:61:7f:70:d0:c3:a2:aa:2c:
                    21:aa:47:ce:28:9c:06:45:76:bf:82:18:27:b4:d5:
                    ae:b4:cb:50:e6:6b:f4:4c:86:71:30:e9:a6:df:16:
                    86:e0:d8:ff:40:dd:fb:d0:42:88:7f:a3:33:3a:2e:
                    5c:1e:41:11:81:63:ce:18:71:6b:2b:ec:a6:8a:b7:
                    31:5c:3a:6a:47:e0:c3:79:59:d6:20:1a:af:f2:6a:
                    98:aa:72:bc:57:4a:d2:4b:9d:bb:10:fc:b0:4c:41:
                    e5:ed:1d:3d:5e:28:9d:9c:cc:bf:b3:51:da:a7:47:
                    e5:84:53
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Subject Key Identifier: 
                BB:AF:7E:02:3D:FA:A6:F1:3C:84:8E:AD:EE:38:98:EC:D9:32:32:D4
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
    Signature Algorithm: sha384WithRSAEncryption
         0a:f1:d5:46:84:b7:ae:51:bb:6c:b2:4d:41:14:00:93:4c:9c:
         cb:e5:c0:54:cf:a0:25:8e:02:f9:fd:b0:a2:0d:f5:20:98:3c:
         13:2d:ac:56:a2:b0:d6:7e:11:92:e9:2e:ba:9e:2e:9a:72:b1:
         bd:19:44:6c:61:35:a2:9a:b4:16:12:69:5a:8c:e1:d7:3e:a4:
         1a:e8:2f:03:f4:ae:61:1d:10:1b:2a:a4:8b:7a:c5:fe:05:a6:
         e1:c0:d6:c8:fe:9e:ae:8f:2b:ba:3d:99:f8:d8:73:09:58:46:
         6e:a6:9c:f4:d7:27:d3:95:da:37:83:72:1c:d3:73:e0:a2:47:
         99:03:38:5d:d5:49:79:00:29:1c:c7:ec:9b:20:1c:07:24:69:
         57:78:b2:39:fc:3a:84:a0:b5:9c:7c:8d:bf:2e:93:62:27:b7:
         39:da:17:18:ae:bd:3c:09:68:ff:84:9b:3c:d5:d6:0b:03:e3:
         57:9e:14:f7:d1:eb:4f:c8:bd:87:23:b7:b6:49:43:79:85:5c:
         ba:eb:92:0b:a1:c6:e8:68:a8:4c:16:b1:1a:99:0a:e8:53:2c:
         92:bb:a1:09:18:75:0c:65:a8:7b:cb:23:b7:1a:c2:28:85:c3:
         1b:ff:d0:2b:62:ef:a4:7b:09:91:98:67:8c:14:01:cd:68:06:
         6a:63:21:75:03:80:88:8a:6e:81:c6:85:f2:a9:a4:2d:e7:f4:
         a5:24:10:47:83:ca:cd:f4:8d:79:58:b1:06:9b:e7:1a:2a:d9:
         9d:01:d7:94:7d:ed:03:4a:ca:f0:db:e8:a9:01:3e:f5:56:99:
         c9:1e:8e:49:3d:bb:e5:09:b9:e0:4f:49:92:3d:16:82:40:cc:
         cc:59:c6:e6:3a:ed:12:2e:69:3c:6c:95:b1:fd:aa:1d:7b:7f:
         86:be:1e:0e:32:46:fb:fb:13:8f:75:7f:4c:8b:4b:46:63:fe:
         00:34:40:70:c1:c3:b9:a1:dd:a6:70:e2:04:b3:41:bc:e9:80:
         91:ea:64:9c:7a:e1:22:03:a9:9c:6e:6f:0e:65:4f:6c:87:87:
         5e:f3:6e:a0:f9:75:a5:9b:40:e8:53:b2:27:9d:4a:b9:c0:77:
         21:8d:ff:87:f2:de:bc:8c:ef:17:df:b7:49:0b:d1:f2:6e:30:
         0b:1a:0e:4e:76:ed:11:fc:f5:e9:56:b2:7d:bf:c7:6d:0a:93:
         8c:a5:d0:c0:b6:1d:be:3a:4e:94:a2:d7:6e:6c:0b:c2:8a:7c:
         fa:20:f3:c4:e4:e5:cd:0d:a8:cb:91:92:b1:7c:85:ec:b5:14:
         69:66:0e:82:e7:cd:ce:c8:2d:a6:51:7f:21:c1:35:53:85:06:
         4a:5d:9f:ad:bb:1b:5f:74
-----BEGIN CERTIFICATE-----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-----END CERTIFICATE-----

USERTrust RSA Certification Authority
================================================
SHA1 Fingerprint=2B:8F:1B:57:33:0D:BB:A2:D0:7A:6C:51:F7:0E:E9:0D:DA:B9:AD:8E
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            01:fd:6d:30:fc:a3:ca:51:a8:1b:bc:64:0e:35:03:2d
    Signature Algorithm: sha384WithRSAEncryption
        Issuer: C=US, ST=New Jersey, L=Jersey City, O=The USERTRUST Network, CN=USERTrust RSA Certification Authority
        Validity
            Not Before: Feb  1 00:00:00 2010 GMT
            Not After : Jan 18 23:59:59 2038 GMT
        Subject: C=US, ST=New Jersey, L=Jersey City, O=The USERTRUST Network, CN=USERTrust RSA Certification Authority
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (4096 bit)
                Modulus:
                    00:80:12:65:17:36:0e:c3:db:08:b3:d0:ac:57:0d:
                    76:ed:cd:27:d3:4c:ad:50:83:61:e2:aa:20:4d:09:
                    2d:64:09:dc:ce:89:9f:cc:3d:a9:ec:f6:cf:c1:dc:
                    f1:d3:b1:d6:7b:37:28:11:2b:47:da:39:c6:bc:3a:
                    19:b4:5f:a6:bd:7d:9d:a3:63:42:b6:76:f2:a9:3b:
                    2b:91:f8:e2:6f:d0:ec:16:20:90:09:3e:e2:e8:74:
                    c9:18:b4:91:d4:62:64:db:7f:a3:06:f1:88:18:6a:
                    90:22:3c:bc:fe:13:f0:87:14:7b:f6:e4:1f:8e:d4:
                    e4:51:c6:11:67:46:08:51:cb:86:14:54:3f:bc:33:
                    fe:7e:6c:9c:ff:16:9d:18:bd:51:8e:35:a6:a7:66:
                    c8:72:67:db:21:66:b1:d4:9b:78:03:c0:50:3a:e8:
                    cc:f0:dc:bc:9e:4c:fe:af:05:96:35:1f:57:5a:b7:
                    ff:ce:f9:3d:b7:2c:b6:f6:54:dd:c8:e7:12:3a:4d:
                    ae:4c:8a:b7:5c:9a:b4:b7:20:3d:ca:7f:22:34:ae:
                    7e:3b:68:66:01:44:e7:01:4e:46:53:9b:33:60:f7:
                    94:be:53:37:90:73:43:f3:32:c3:53:ef:db:aa:fe:
                    74:4e:69:c7:6b:8c:60:93:de:c4:c7:0c:df:e1:32:
                    ae:cc:93:3b:51:78:95:67:8b:ee:3d:56:fe:0c:d0:
                    69:0f:1b:0f:f3:25:26:6b:33:6d:f7:6e:47:fa:73:
                    43:e5:7e:0e:a5:66:b1:29:7c:32:84:63:55:89:c4:
                    0d:c1:93:54:30:19:13:ac:d3:7d:37:a7:eb:5d:3a:
                    6c:35:5c:db:41:d7:12:da:a9:49:0b:df:d8:80:8a:
                    09:93:62:8e:b5:66:cf:25:88:cd:84:b8:b1:3f:a4:
                    39:0f:d9:02:9e:eb:12:4c:95:7c:f3:6b:05:a9:5e:
                    16:83:cc:b8:67:e2:e8:13:9d:cc:5b:82:d3:4c:b3:
                    ed:5b:ff:de:e5:73:ac:23:3b:2d:00:bf:35:55:74:
                    09:49:d8:49:58:1a:7f:92:36:e6:51:92:0e:f3:26:
                    7d:1c:4d:17:bc:c9:ec:43:26:d0:bf:41:5f:40:a9:
                    44:44:f4:99:e7:57:87:9e:50:1f:57:54:a8:3e:fd:
                    74:63:2f:b1:50:65:09:e6:58:42:2e:43:1a:4c:b4:
                    f0:25:47:59:fa:04:1e:93:d4:26:46:4a:50:81:b2:
                    de:be:78:b7:fc:67:15:e1:c9:57:84:1e:0f:63:d6:
                    e9:62:ba:d6:5f:55:2e:ea:5c:c6:28:08:04:25:39:
                    b8:0e:2b:a9:f2:4c:97:1c:07:3f:0d:52:f5:ed:ef:
                    2f:82:0f
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Subject Key Identifier: 
                53:79:BF:5A:AA:2B:4A:CF:54:80:E1:D8:9B:C0:9D:F2:B2:03:66:CB
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
    Signature Algorithm: sha384WithRSAEncryption
         5c:d4:7c:0d:cf:f7:01:7d:41:99:65:0c:73:c5:52:9f:cb:f8:
         cf:99:06:7f:1b:da:43:15:9f:9e:02:55:57:96:14:f1:52:3c:
         27:87:94:28:ed:1f:3a:01:37:a2:76:fc:53:50:c0:84:9b:c6:
         6b:4e:ba:8c:21:4f:a2:8e:55:62:91:f3:69:15:d8:bc:88:e3:
         c4:aa:0b:fd:ef:a8:e9:4b:55:2a:06:20:6d:55:78:29:19:ee:
         5f:30:5c:4b:24:11:55:ff:24:9a:6e:5e:2a:2b:ee:0b:4d:9f:
         7f:f7:01:38:94:14:95:43:07:09:fb:60:a9:ee:1c:ab:12:8c:
         a0:9a:5e:a7:98:6a:59:6d:8b:3f:08:fb:c8:d1:45:af:18:15:
         64:90:12:0f:73:28:2e:c5:e2:24:4e:fc:58:ec:f0:f4:45:fe:
         22:b3:eb:2f:8e:d2:d9:45:61:05:c1:97:6f:a8:76:72:8f:8b:
         8c:36:af:bf:0d:05:ce:71:8d:e6:a6:6f:1f:6c:a6:71:62:c5:
         d8:d0:83:72:0c:f1:67:11:89:0c:9c:13:4c:72:34:df:bc:d5:
         71:df:aa:71:dd:e1:b9:6c:8c:3c:12:5d:65:da:bd:57:12:b6:
         43:6b:ff:e5:de:4d:66:11:51:cf:99:ae:ec:17:b6:e8:71:91:
         8c:de:49:fe:dd:35:71:a2:15:27:94:1c:cf:61:e3:26:bb:6f:
         a3:67:25:21:5d:e6:dd:1d:0b:2e:68:1b:3b:82:af:ec:83:67:
         85:d4:98:51:74:b1:b9:99:80:89:ff:7f:78:19:5c:79:4a:60:
         2e:92:40:ae:4c:37:2a:2c:c9:c7:62:c8:0e:5d:f7:36:5b:ca:
         e0:25:25:01:b4:dd:1a:07:9c:77:00:3f:d0:dc:d5:ec:3d:d4:
         fa:bb:3f:cc:85:d6:6f:7f:a9:2d:df:b9:02:f7:f5:97:9a:b5:
         35:da:c3:67:b0:87:4a:a9:28:9e:23:8e:ff:5c:27:6b:e1:b0:
         4f:f3:07:ee:00:2e:d4:59:87:cb:52:41:95:ea:f4:47:d7:ee:
         64:41:55:7c:8d:59:02:95:dd:62:9d:c2:b9:ee:5a:28:74:84:
         a5:9b:b7:90:c7:0c:07:df:f5:89:36:74:32:d6:28:c1:b0:b0:
         0b:e0:9c:4c:c3:1c:d6:fc:e3:69:b5:47:46:81:2f:a2:82:ab:
         d3:63:44:70:c4:8d:ff:2d:33:ba:ad:8f:7b:b5:70:88:ae:3e:
         19:cf:40:28:d8:fc:c8:90:bb:5d:99:22:f5:52:e6:58:c5:1f:
         88:31:43:ee:88:1d:d7:c6:8e:3c:43:6a:1d:a7:18:de:7d:3d:
         16:f1:62:f9:ca:90:a8:fd
-----BEGIN CERTIFICATE-----
MIIF3jCCA8agAwIBAgIQAf1tMPyjylGoG7xkDjUDLTANBgkqhkiG9w0BAQwFADCB
iDELMAkGA1UEBhMCVVMxEzARBgNVBAgTCk5ldyBKZXJzZXkxFDASBgNVBAcTC0pl
cnNleSBDaXR5MR4wHAYDVQQKExVUaGUgVVNFUlRSVVNUIE5ldHdvcmsxLjAsBgNV
BAMTJVVTRVJUcnVzdCBSU0EgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkwHhcNMTAw
MjAxMDAwMDAwWhcNMzgwMTE4MjM1OTU5WjCBiDELMAkGA1UEBhMCVVMxEzARBgNV
BAgTCk5ldyBKZXJzZXkxFDASBgNVBAcTC0plcnNleSBDaXR5MR4wHAYDVQQKExVU
aGUgVVNFUlRSVVNUIE5ldHdvcmsxLjAsBgNVBAMTJVVTRVJUcnVzdCBSU0EgQ2Vy
dGlmaWNhdGlvbiBBdXRob3JpdHkwggIiMA0GCSqGSIb3DQEBAQUAA4ICDwAwggIK
AoICAQCAEmUXNg7D2wiz0KxXDXbtzSfTTK1Qg2HiqiBNCS1kCdzOiZ/MPans9s/B
3PHTsdZ7NygRK0faOca8Ohm0X6a9fZ2jY0K2dvKpOyuR+OJv0OwWIJAJPuLodMkY
tJHUYmTbf6MG8YgYapAiPLz+E/CHFHv25B+O1ORRxhFnRghRy4YUVD+8M/5+bJz/
Fp0YvVGONaanZshyZ9shZrHUm3gDwFA66Mzw3LyeTP6vBZY1H1dat//O+T23LLb2
VN3I5xI6Ta5MirdcmrS3ID3KfyI0rn47aGYBROcBTkZTmzNg95S+UzeQc0PzMsNT
79uq/nROacdrjGCT3sTHDN/hMq7MkztReJVni+49Vv4M0GkPGw/zJSZrM233bkf6
c0Plfg6lZrEpfDKEY1WJxA3Bk1QwGROs0303p+tdOmw1XNtB1xLaqUkL39iAigmT
Yo61Zs8liM2EuLE/pDkP2QKe6xJMlXzzawWpXhaDzLhn4ugTncxbgtNMs+1b/97l
c6wjOy0AvzVVdAlJ2ElYGn+SNuZRkg7zJn0cTRe8yexDJtC/QV9AqURE9JnnV4ee
UB9XVKg+/XRjL7FQZQnmWEIuQxpMtPAlR1n6BB6T1CZGSlCBst6+eLf8ZxXhyVeE
Hg9j1uliutZfVS7qXMYoCAQlObgOK6nyTJccBz8NUvXt7y+CDwIDAQABo0IwQDAd
BgNVHQ4EFgQUU3m/WqorSs9UgOHYm8Cd8rIDZsswDgYDVR0PAQH/BAQDAgEGMA8G
A1UdEwEB/wQFMAMBAf8wDQYJKoZIhvcNAQEMBQADggIBAFzUfA3P9wF9QZllDHPF
Up/L+M+ZBn8b2kMVn54CVVeWFPFSPCeHlCjtHzoBN6J2/FNQwISbxmtOuowhT6KO
VWKR82kV2LyI48SqC/3vqOlLVSoGIG1VeCkZ7l8wXEskEVX/JJpuXior7gtNn3/3
ATiUFJVDBwn7YKnuHKsSjKCaXqeYalltiz8I+8jRRa8YFWSQEg9zKC7F4iRO/Fjs
8PRF/iKz6y+O0tlFYQXBl2+odnKPi4w2r78NBc5xjeambx9spnFixdjQg3IM8WcR
iQycE0xyNN+81XHfqnHd4blsjDwSXWXavVcStkNr/+XeTWYRUc+ZruwXtuhxkYze
Sf7dNXGiFSeUHM9h4ya7b6NnJSFd5t0dCy5oGzuCr+yDZ4XUmFF0sbmZgIn/f3gZ
XHlKYC6SQK5MNyosycdiyA5d9zZbyuAlJQG03RoHnHcAP9Dc1ew91Pq7P8yF1m9/
qS3fuQL39ZeatTXaw2ewh0qpKJ4jjv9cJ2vhsE/zB+4ALtRZh8tSQZXq9EfX7mRB
VXyNWQKV3WKdwrnuWih0hKWbt5DHDAff9Yk2dDLWKMGwsAvgnEzDHNb842m1R0aB
L6KCq9NjRHDEjf8tM7qtj3u1cIiuPhnPQCjY/MiQu12ZIvVS5ljFH4gxQ+6IHdfG
jjxDah2nGN59PRbxYvnKkKj9
-----END CERTIFICATE-----

USERTrust ECC Certification Authority
================================================
SHA1 Fingerprint=D1:CB:CA:5D:B2:D5:2A:7F:69:3B:67:4D:E5:F0:5A:1D:0C:95:7D:F0
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            5c:8b:99:c5:5a:94:c5:d2:71:56:de:cd:89:80:cc:26
    Signature Algorithm: ecdsa-with-SHA384
        Issuer: C=US, ST=New Jersey, L=Jersey City, O=The USERTRUST Network, CN=USERTrust ECC Certification Authority
        Validity
            Not Before: Feb  1 00:00:00 2010 GMT
            Not After : Jan 18 23:59:59 2038 GMT
        Subject: C=US, ST=New Jersey, L=Jersey City, O=The USERTRUST Network, CN=USERTrust ECC Certification Authority
        Subject Public Key Info:
            Public Key Algorithm: id-ecPublicKey
                Public-Key: (384 bit)
                pub: 
                    04:1a:ac:54:5a:a9:f9:68:23:e7:7a:d5:24:6f:53:
                    c6:5a:d8:4b:ab:c6:d5:b6:d1:e6:73:71:ae:dd:9c:
                    d6:0c:61:fd:db:a0:89:03:b8:05:14:ec:57:ce:ee:
                    5d:3f:e2:21:b3:ce:f7:d4:8a:79:e0:a3:83:7e:2d:
                    97:d0:61:c4:f1:99:dc:25:91:63:ab:7f:30:a3:b4:
                    70:e2:c7:a1:33:9c:f3:bf:2e:5c:53:b1:5f:b3:7d:
                    32:7f:8a:34:e3:79:79
                ASN1 OID: secp384r1
        X509v3 extensions:
            X509v3 Subject Key Identifier: 
                3A:E1:09:86:D4:CF:19:C2:96:76:74:49:76:DC:E0:35:C6:63:63:9A
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
    Signature Algorithm: ecdsa-with-SHA384
         30:65:02:30:36:67:a1:16:08:dc:e4:97:00:41:1d:4e:be:e1:
         63:01:cf:3b:aa:42:11:64:a0:9d:94:39:02:11:79:5c:7b:1d:
         fa:64:b9:ee:16:42:b3:bf:8a:c2:09:c4:ec:e4:b1:4d:02:31:
         00:e9:2a:61:47:8c:52:4a:4b:4e:18:70:f6:d6:44:d6:6e:f5:
         83:ba:6d:58:bd:24:d9:56:48:ea:ef:c4:a2:46:81:88:6a:3a:
         46:d1:a9:9b:4d:c9:61:da:d1:5d:57:6a:18
-----BEGIN CERTIFICATE-----
MIICjzCCAhWgAwIBAgIQXIuZxVqUxdJxVt7NiYDMJjAKBggqhkjOPQQDAzCBiDEL
MAkGA1UEBhMCVVMxEzARBgNVBAgTCk5ldyBKZXJzZXkxFDASBgNVBAcTC0plcnNl
eSBDaXR5MR4wHAYDVQQKExVUaGUgVVNFUlRSVVNUIE5ldHdvcmsxLjAsBgNVBAMT
JVVTRVJUcnVzdCBFQ0MgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkwHhcNMTAwMjAx
MDAwMDAwWhcNMzgwMTE4MjM1OTU5WjCBiDELMAkGA1UEBhMCVVMxEzARBgNVBAgT
Ck5ldyBKZXJzZXkxFDASBgNVBAcTC0plcnNleSBDaXR5MR4wHAYDVQQKExVUaGUg
VVNFUlRSVVNUIE5ldHdvcmsxLjAsBgNVBAMTJVVTRVJUcnVzdCBFQ0MgQ2VydGlm
aWNhdGlvbiBBdXRob3JpdHkwdjAQBgcqhkjOPQIBBgUrgQQAIgNiAAQarFRaqflo
I+d61SRvU8Za2EurxtW20eZzca7dnNYMYf3boIkDuAUU7FfO7l0/4iGzzvfUinng
o4N+LZfQYcTxmdwlkWOrfzCjtHDix6EznPO/LlxTsV+zfTJ/ijTjeXmjQjBAMB0G
A1UdDgQWBBQ64QmG1M8ZwpZ2dEl23OA1xmNjmjAOBgNVHQ8BAf8EBAMCAQYwDwYD
VR0TAQH/BAUwAwEB/zAKBggqhkjOPQQDAwNoADBlAjA2Z6EWCNzklwBBHU6+4WMB
zzuqQhFkoJ2UOQIReVx7Hfpkue4WQrO/isIJxOzksU0CMQDpKmFHjFJKS04YcPbW
RNZu9YO6bVi9JNlWSOrvxKJGgYhqOkbRqZtNyWHa0V1Xahg=
-----END CERTIFICATE-----

GlobalSign ECC Root CA - R4
================================================
SHA1 Fingerprint=69:69:56:2E:40:80:F4:24:A1:E7:19:9F:14:BA:F3:EE:58:AB:6A:BB
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            2a:38:a4:1c:96:0a:04:de:42:b2:28:a5:0b:e8:34:98:02
    Signature Algorithm: ecdsa-with-SHA256
        Issuer: OU=GlobalSign ECC Root CA - R4, O=GlobalSign, CN=GlobalSign
        Validity
            Not Before: Nov 13 00:00:00 2012 GMT
            Not After : Jan 19 03:14:07 2038 GMT
        Subject: OU=GlobalSign ECC Root CA - R4, O=GlobalSign, CN=GlobalSign
        Subject Public Key Info:
            Public Key Algorithm: id-ecPublicKey
                Public-Key: (256 bit)
                pub: 
                    04:b8:c6:79:d3:8f:6c:25:0e:9f:2e:39:19:1c:03:
                    a4:ae:9a:e5:39:07:09:16:ca:63:b1:b9:86:f8:8a:
                    57:c1:57:ce:42:fa:73:a1:f7:65:42:ff:1e:c1:00:
                    b2:6e:73:0e:ff:c7:21:e5:18:a4:aa:d9:71:3f:a8:
                    d4:b9:ce:8c:1d
                ASN1 OID: prime256v1
        X509v3 extensions:
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Subject Key Identifier: 
                54:B0:7B:AD:45:B8:E2:40:7F:FB:0A:6E:FB:BE:33:C9:3C:A3:84:D5
    Signature Algorithm: ecdsa-with-SHA256
         30:45:02:21:00:dc:92:a1:a0:13:a6:cf:03:b0:e6:c4:21:97:
         90:fa:14:57:2d:03:ec:ee:3c:d3:6e:ca:a8:6c:76:bc:a2:de:
         bb:02:20:27:a8:85:27:35:9b:56:c6:a3:f2:47:d2:b7:6e:1b:
         02:00:17:aa:67:a6:15:91:de:fa:94:ec:7b:0b:f8:9f:84
-----BEGIN CERTIFICATE-----
MIIB4TCCAYegAwIBAgIRKjikHJYKBN5CsiilC+g0mAIwCgYIKoZIzj0EAwIwUDEk
MCIGA1UECxMbR2xvYmFsU2lnbiBFQ0MgUm9vdCBDQSAtIFI0MRMwEQYDVQQKEwpH
bG9iYWxTaWduMRMwEQYDVQQDEwpHbG9iYWxTaWduMB4XDTEyMTExMzAwMDAwMFoX
DTM4MDExOTAzMTQwN1owUDEkMCIGA1UECxMbR2xvYmFsU2lnbiBFQ0MgUm9vdCBD
QSAtIFI0MRMwEQYDVQQKEwpHbG9iYWxTaWduMRMwEQYDVQQDEwpHbG9iYWxTaWdu
MFkwEwYHKoZIzj0CAQYIKoZIzj0DAQcDQgAEuMZ5049sJQ6fLjkZHAOkrprlOQcJ
FspjsbmG+IpXwVfOQvpzofdlQv8ewQCybnMO/8ch5RikqtlxP6jUuc6MHaNCMEAw
DgYDVR0PAQH/BAQDAgEGMA8GA1UdEwEB/wQFMAMBAf8wHQYDVR0OBBYEFFSwe61F
uOJAf/sKbvu+M8k8o4TVMAoGCCqGSM49BAMCA0gAMEUCIQDckqGgE6bPA7DmxCGX
kPoUVy0D7O48027KqGx2vKLeuwIgJ6iFJzWbVsaj8kfSt24bAgAXqmemFZHe+pTs
ewv4n4Q=
-----END CERTIFICATE-----

GlobalSign ECC Root CA - R5
================================================
SHA1 Fingerprint=1F:24:C6:30:CD:A4:18:EF:20:69:FF:AD:4F:DD:5F:46:3A:1B:69:AA
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            60:59:49:e0:26:2e:bb:55:f9:0a:77:8a:71:f9:4a:d8:6c
    Signature Algorithm: ecdsa-with-SHA384
        Issuer: OU=GlobalSign ECC Root CA - R5, O=GlobalSign, CN=GlobalSign
        Validity
            Not Before: Nov 13 00:00:00 2012 GMT
            Not After : Jan 19 03:14:07 2038 GMT
        Subject: OU=GlobalSign ECC Root CA - R5, O=GlobalSign, CN=GlobalSign
        Subject Public Key Info:
            Public Key Algorithm: id-ecPublicKey
                Public-Key: (384 bit)
                pub: 
                    04:47:45:0e:96:fb:7d:5d:bf:e9:39:d1:21:f8:9f:
                    0b:b6:d5:7b:1e:92:3a:48:59:1c:f0:62:31:2d:c0:
                    7a:28:fe:1a:a7:5c:b3:b6:cc:97:e7:45:d4:58:fa:
                    d1:77:6d:43:a2:c0:87:65:34:0a:1f:7a:dd:eb:3c:
                    33:a1:c5:9d:4d:a4:6f:41:95:38:7f:c9:1e:84:eb:
                    d1:9e:49:92:87:94:87:0c:3a:85:4a:66:9f:9d:59:
                    93:4d:97:61:06:86:4a
                ASN1 OID: secp384r1
        X509v3 extensions:
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Subject Key Identifier: 
                3D:E6:29:48:9B:EA:07:CA:21:44:4A:26:DE:6E:DE:D2:83:D0:9F:59
    Signature Algorithm: ecdsa-with-SHA384
         30:65:02:31:00:e5:69:12:c9:6e:db:c6:31:ba:09:41:e1:97:
         f8:fb:fd:9a:e2:7d:12:c9:ed:7c:64:d3:cb:05:25:8b:56:d9:
         a0:e7:5e:5d:4e:0b:83:9c:5b:76:29:a0:09:26:21:6a:62:02:
         30:71:d2:b5:8f:5c:ea:3b:e1:78:09:85:a8:75:92:3b:c8:5c:
         fd:48:ef:0d:74:22:a8:08:e2:6e:c5:49:ce:c7:0c:bc:a7:61:
         69:f1:f7:3b:e1:2a:cb:f9:2b:f3:66:90:37
-----BEGIN CERTIFICATE-----
MIICHjCCAaSgAwIBAgIRYFlJ4CYuu1X5CneKcflK2GwwCgYIKoZIzj0EAwMwUDEk
MCIGA1UECxMbR2xvYmFsU2lnbiBFQ0MgUm9vdCBDQSAtIFI1MRMwEQYDVQQKEwpH
bG9iYWxTaWduMRMwEQYDVQQDEwpHbG9iYWxTaWduMB4XDTEyMTExMzAwMDAwMFoX
DTM4MDExOTAzMTQwN1owUDEkMCIGA1UECxMbR2xvYmFsU2lnbiBFQ0MgUm9vdCBD
QSAtIFI1MRMwEQYDVQQKEwpHbG9iYWxTaWduMRMwEQYDVQQDEwpHbG9iYWxTaWdu
MHYwEAYHKoZIzj0CAQYFK4EEACIDYgAER0UOlvt9Xb/pOdEh+J8LttV7HpI6SFkc
8GIxLcB6KP4ap1yztsyX50XUWPrRd21DosCHZTQKH3rd6zwzocWdTaRvQZU4f8ke
hOvRnkmSh5SHDDqFSmafnVmTTZdhBoZKo0IwQDAOBgNVHQ8BAf8EBAMCAQYwDwYD
VR0TAQH/BAUwAwEB/zAdBgNVHQ4EFgQUPeYpSJvqB8ohREom3m7e0oPQn1kwCgYI
KoZIzj0EAwMDaAAwZQIxAOVpEslu28YxuglB4Zf4+/2a4n0Sye18ZNPLBSWLVtmg
515dTguDnFt2KaAJJiFqYgIwcdK1j1zqO+F4CYWodZI7yFz9SO8NdCKoCOJuxUnO
xwy8p2Fp8fc74SrL+SvzZpA3
-----END CERTIFICATE-----

Staat der Nederlanden EV Root CA
=================================================
SHA1 Fingerprint=76:E2:7E:C1:4F:DB:82:C1:C0:A6:75:B5:05:BE:3D:29:B4:ED:DB:BB
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 10000013 (0x98968d)
    Signature Algorithm: sha256WithRSAEncryption
        Issuer: C=NL, O=Staat der Nederlanden, CN=Staat der Nederlanden EV Root CA
        Validity
            Not Before: Dec  8 11:19:29 2010 GMT
            Not After : Dec  8 11:10:28 2022 GMT
        Subject: C=NL, O=Staat der Nederlanden, CN=Staat der Nederlanden EV Root CA
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (4096 bit)
                Modulus:
                    00:e3:c7:7e:89:f9:24:4b:3a:d2:33:83:35:2c:69:
                    ec:dc:09:a4:e3:51:a8:25:2b:79:b8:08:3d:e0:91:
                    ba:84:85:c6:85:a4:ca:e6:c9:2e:53:a4:c9:24:1e:
                    fd:55:66:71:5d:2c:c5:60:68:04:b7:d9:c2:52:26:
                    38:88:a4:d6:3b:40:a6:c2:cd:3f:cd:98:93:b3:54:
                    14:58:96:55:d5:50:fe:86:ad:a4:63:7f:5c:87:f6:
                    8e:e6:27:92:67:17:92:02:03:2c:dc:d6:66:74:ed:
                    dd:67:ff:c1:61:8d:63:4f:0f:9b:6d:17:30:26:ef:
                    ab:d2:1f:10:a0:f9:c5:7f:16:69:81:03:47:ed:1e:
                    68:8d:72:a1:4d:b2:26:c6:ba:6c:5f:6d:d6:af:d1:
                    b1:13:8e:a9:ad:f3:5e:69:75:26:18:3e:41:2b:21:
                    7f:ee:8b:5d:07:06:9d:43:c4:29:0a:2b:fc:2a:3e:
                    86:cb:3c:83:3a:f9:c9:0d:da:c5:99:e2:bc:78:41:
                    33:76:e1:bf:2f:5d:e5:a4:98:50:0c:15:dd:e0:fa:
                    9c:7f:38:68:d0:b2:a6:7a:a7:d1:31:bd:7e:8a:58:
                    27:43:b3:ba:33:91:d3:a7:98:15:5c:9a:e6:d3:0f:
                    75:d9:fc:41:98:97:3e:aa:25:db:8f:92:2e:b0:7b:
                    0c:5f:f1:63:a9:37:f9:9b:75:69:4c:28:26:25:da:
                    d5:f2:12:70:45:55:e3:df:73:5e:37:f5:21:6c:90:
                    8e:35:5a:c9:d3:23:eb:d3:c0:be:78:ac:42:28:58:
                    66:a5:46:6d:70:02:d7:10:f9:4b:54:fc:5d:86:4a:
                    87:cf:7f:ca:45:ac:11:5a:b5:20:51:8d:2f:88:47:
                    97:39:c0:cf:ba:c0:42:01:40:99:48:21:0b:6b:a7:
                    d2:fd:96:d5:d1:be:46:9d:49:e0:0b:a6:a0:22:4e:
                    38:d0:c1:3c:30:bc:70:8f:2c:75:cc:d0:c5:8c:51:
                    3b:3d:94:08:64:26:61:7d:b9:c3:65:8f:14:9c:21:
                    d0:aa:fd:17:72:03:8f:bd:9b:8c:e6:5e:53:9e:b9:
                    9d:ef:82:bb:e1:bc:e2:72:41:5b:21:94:d3:45:37:
                    94:d1:df:09:39:5d:e7:23:aa:9a:1d:ca:6d:a8:0a:
                    86:85:8a:82:be:42:07:d6:f2:38:82:73:da:87:5b:
                    e5:3c:d3:9e:3e:a7:3b:9e:f4:03:b3:f9:f1:7d:13:
                    74:02:ff:bb:a1:e5:fa:00:79:1c:a6:66:41:88:5c:
                    60:57:a6:2e:09:c4:ba:fd:9a:cf:a7:1f:40:c3:bb:
                    cc:5a:0a:55:4b:3b:38:76:51:b8:63:8b:84:94:16:
                    e6:56:f3
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Subject Key Identifier: 
                FE:AB:00:90:98:9E:24:FC:A9:CC:1A:8A:FB:27:B8:BF:30:6E:A8:3B
    Signature Algorithm: sha256WithRSAEncryption
         cf:77:2c:6e:56:be:4e:b3:b6:84:00:94:ab:47:c9:0d:d2:76:
         c7:86:9f:1d:07:d3:b6:b4:bb:08:78:af:69:d2:0b:49:de:33:
         c5:ac:ad:c2:88:02:7d:06:b7:35:02:c1:60:c9:bf:c4:e8:94:
         de:d4:d3:a9:13:25:5a:fe:6e:a2:ae:7d:05:dc:7d:f3:6c:f0:
         7e:a6:8d:ee:d9:d7:ce:58:17:e8:a9:29:ae:73:48:87:e7:9b:
         ca:6e:29:a1:64:5f:19:13:f7:ae:06:10:ff:51:c6:9b:4d:55:
         25:4f:93:99:10:01:53:75:f1:13:ce:c7:a6:41:41:d2:bf:88:
         a5:7f:45:fc:ac:b8:a5:b5:33:0c:82:c4:fb:07:f6:6a:e5:25:
         84:5f:06:ca:c1:86:39:11:db:58:cd:77:3b:2c:c2:4c:0f:5e:
         9a:e3:f0:ab:3e:61:1b:50:24:c2:c0:f4:f1:19:f0:11:29:b6:
         a5:18:02:9b:d7:63:4c:70:8c:47:a3:03:43:5c:b9:5d:46:a0:
         0d:6f:ff:59:8e:be:dd:9f:72:c3:5b:2b:df:8c:5b:ce:e5:0c:
         46:6c:92:b2:0a:a3:4c:54:42:18:15:12:18:bd:da:fc:ba:74:
         6e:ff:c1:b6:a0:64:d8:a9:5f:55:ae:9f:5c:6a:76:96:d8:73:
         67:87:fb:4d:7f:5c:ee:69:ca:73:10:fb:8a:a9:fd:9e:bd:36:
         38:49:49:87:f4:0e:14:f0:e9:87:b8:3f:a7:4f:7a:5a:8e:79:
         d4:93:e4:bb:68:52:84:ac:6c:e9:f3:98:70:55:72:32:f9:34:
         ab:2b:49:b5:cd:20:62:e4:3a:7a:67:63:ab:96:dc:6d:ae:97:
         ec:fc:9f:76:56:88:2e:66:cf:5b:b6:c9:a4:b0:d7:05:ba:e1:
         27:2f:93:bb:26:2a:a2:93:b0:1b:f3:8e:be:1d:40:a3:b9:36:
         8f:3e:82:1a:1a:5e:88:ea:50:f8:59:e2:83:46:29:0b:e3:44:
         5c:e1:95:b6:69:90:9a:14:6f:97:ae:81:cf:68:ef:99:9a:be:
         b5:e7:e1:7f:f8:fa:13:47:16:4c:cc:6d:08:40:e7:8b:78:6f:
         50:82:44:50:3f:66:06:8a:ab:43:84:56:4a:0f:20:2d:86:0e:
         f5:d2:db:d2:7a:8a:4b:cd:a5:e8:4e:f1:5e:26:25:01:59:23:
         a0:7e:d2:f6:7e:21:57:d7:27:bc:15:57:4c:a4:46:c1:e0:83:
         1e:0c:4c:4d:1f:4f:06:19:e2:f9:a8:f4:3a:82:a1:b2:79:43:
         79:d6:ad:6f:7a:27:90:03:a4:ea:24:87:3f:d9:bd:d9:e9:f2:
         5f:50:49:1c:ee:ec:d7:2e
-----BEGIN CERTIFICATE-----
MIIFcDCCA1igAwIBAgIEAJiWjTANBgkqhkiG9w0BAQsFADBYMQswCQYDVQQGEwJO
TDEeMBwGA1UECgwVU3RhYXQgZGVyIE5lZGVybGFuZGVuMSkwJwYDVQQDDCBTdGFh
dCBkZXIgTmVkZXJsYW5kZW4gRVYgUm9vdCBDQTAeFw0xMDEyMDgxMTE5MjlaFw0y
MjEyMDgxMTEwMjhaMFgxCzAJBgNVBAYTAk5MMR4wHAYDVQQKDBVTdGFhdCBkZXIg
TmVkZXJsYW5kZW4xKTAnBgNVBAMMIFN0YWF0IGRlciBOZWRlcmxhbmRlbiBFViBS
b290IENBMIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEA48d+ifkkSzrS
M4M1LGns3Amk41GoJSt5uAg94JG6hIXGhaTK5skuU6TJJB79VWZxXSzFYGgEt9nC
UiY4iKTWO0Cmws0/zZiTs1QUWJZV1VD+hq2kY39ch/aO5ieSZxeSAgMs3NZmdO3d
Z//BYY1jTw+bbRcwJu+r0h8QoPnFfxZpgQNH7R5ojXKhTbImxrpsX23Wr9GxE46p
rfNeaXUmGD5BKyF/7otdBwadQ8QpCiv8Kj6GyzyDOvnJDdrFmeK8eEEzduG/L13l
pJhQDBXd4Pqcfzho0LKmeqfRMb1+ilgnQ7O6M5HTp5gVXJrm0w912fxBmJc+qiXb
j5IusHsMX/FjqTf5m3VpTCgmJdrV8hJwRVXj33NeN/UhbJCONVrJ0yPr08C+eKxC
KFhmpUZtcALXEPlLVPxdhkqHz3/KRawRWrUgUY0viEeXOcDPusBCAUCZSCELa6fS
/ZbV0b5GnUngC6agIk440ME8MLxwjyx1zNDFjFE7PZQIZCZhfbnDZY8UnCHQqv0X
cgOPvZuM5l5Tnrmd74K74bzickFbIZTTRTeU0d8JOV3nI6qaHcptqAqGhYqCvkIH
1vI4gnPah1vlPNOePqc7nvQDs/nxfRN0Av+7oeX6AHkcpmZBiFxgV6YuCcS6/ZrP
px9Aw7vMWgpVSzs4dlG4Y4uElBbmVvMCAwEAAaNCMEAwDwYDVR0TAQH/BAUwAwEB
/zAOBgNVHQ8BAf8EBAMCAQYwHQYDVR0OBBYEFP6rAJCYniT8qcwaivsnuL8wbqg7
MA0GCSqGSIb3DQEBCwUAA4ICAQDPdyxuVr5Os7aEAJSrR8kN0nbHhp8dB9O2tLsI
eK9p0gtJ3jPFrK3CiAJ9Brc1AsFgyb/E6JTe1NOpEyVa/m6irn0F3H3zbPB+po3u
2dfOWBfoqSmuc0iH55vKbimhZF8ZE/euBhD/UcabTVUlT5OZEAFTdfETzsemQUHS
v4ilf0X8rLiltTMMgsT7B/Zq5SWEXwbKwYY5EdtYzXc7LMJMD16a4/CrPmEbUCTC
wPTxGfARKbalGAKb12NMcIxHowNDXLldRqANb/9Zjr7dn3LDWyvfjFvO5QxGbJKy
CqNMVEIYFRIYvdr8unRu/8G2oGTYqV9Vrp9canaW2HNnh/tNf1zuacpzEPuKqf2e
vTY4SUmH9A4U8OmHuD+nT3pajnnUk+S7aFKErGzp85hwVXIy+TSrK0m1zSBi5Dp6
Z2Orltxtrpfs/J92VoguZs9btsmksNcFuuEnL5O7Jiqik7Ab846+HUCjuTaPPoIa
Gl6I6lD4WeKDRikL40Rc4ZW2aZCaFG+XroHPaO+Zmr615+F/+PoTRxZMzG0IQOeL
eG9QgkRQP2YGiqtDhFZKDyAthg710tvSeopLzaXoTvFeJiUBWSOgftL2fiFX1ye8
FVdMpEbB4IMeDExNH08GGeL5qPQ6gqGyeUN51q1veieQA6TqJIc/2b3Z6fJfUEkc
7uzXLg==
-----END CERTIFICATE-----

IdenTrust Commercial Root CA 1
================================================
SHA1 Fingerprint=DF:71:7E:AA:4A:D9:4E:C9:55:84:99:60:2D:48:DE:5F:BC:F0:3A:25
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            0a:01:42:80:00:00:01:45:23:c8:44:b5:00:00:00:02
    Signature Algorithm: sha256WithRSAEncryption
        Issuer: C=US, O=IdenTrust, CN=IdenTrust Commercial Root CA 1
        Validity
            Not Before: Jan 16 18:12:23 2014 GMT
            Not After : Jan 16 18:12:23 2034 GMT
        Subject: C=US, O=IdenTrust, CN=IdenTrust Commercial Root CA 1
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (4096 bit)
                Modulus:
                    00:a7:50:19:de:3f:99:3d:d4:33:46:f1:6f:51:61:
                    82:b2:a9:4f:8f:67:89:5d:84:d9:53:dd:0c:28:d9:
                    d7:f0:ff:ae:95:43:72:99:f9:b5:5d:7c:8a:c1:42:
                    e1:31:50:74:d1:81:0d:7c:cd:9b:21:ab:43:e2:ac:
                    ad:5e:86:6e:f3:09:8a:1f:5a:32:bd:a2:eb:94:f9:
                    e8:5c:0a:ec:ff:98:d2:af:71:b3:b4:53:9f:4e:87:
                    ef:92:bc:bd:ec:4f:32:30:88:4b:17:5e:57:c4:53:
                    c2:f6:02:97:8d:d9:62:2b:bf:24:1f:62:8d:df:c3:
                    b8:29:4b:49:78:3c:93:60:88:22:fc:99:da:36:c8:
                    c2:a2:d4:2c:54:00:67:35:6e:73:bf:02:58:f0:a4:
                    dd:e5:b0:a2:26:7a:ca:e0:36:a5:19:16:f5:fd:b7:
                    ef:ae:3f:40:f5:6d:5a:04:fd:ce:34:ca:24:dc:74:
                    23:1b:5d:33:13:12:5d:c4:01:25:f6:30:dd:02:5d:
                    9f:e0:d5:47:bd:b4:eb:1b:a1:bb:49:49:d8:9f:5b:
                    02:f3:8a:e4:24:90:e4:62:4f:4f:c1:af:8b:0e:74:
                    17:a8:d1:72:88:6a:7a:01:49:cc:b4:46:79:c6:17:
                    b1:da:98:1e:07:59:fa:75:21:85:65:dd:90:56:ce:
                    fb:ab:a5:60:9d:c4:9d:f9:52:b0:8b:bd:87:f9:8f:
                    2b:23:0a:23:76:3b:f7:33:e1:c9:00:f3:69:f9:4b:
                    a2:e0:4e:bc:7e:93:39:84:07:f7:44:70:7e:fe:07:
                    5a:e5:b1:ac:d1:18:cc:f2:35:e5:49:49:08:ca:56:
                    c9:3d:fb:0f:18:7d:8b:3b:c1:13:c2:4d:8f:c9:4f:
                    0e:37:e9:1f:a1:0e:6a:df:62:2e:cb:35:06:51:79:
                    2c:c8:25:38:f4:fa:4b:a7:89:5c:9c:d2:e3:0d:39:
                    86:4a:74:7c:d5:59:87:c2:3f:4e:0c:5c:52:f4:3d:
                    f7:52:82:f1:ea:a3:ac:fd:49:34:1a:28:f3:41:88:
                    3a:13:ee:e8:de:ff:99:1d:5f:ba:cb:e8:1e:f2:b9:
                    50:60:c0:31:d3:73:e5:ef:be:a0:ed:33:0b:74:be:
                    20:20:c4:67:6c:f0:08:03:7a:55:80:7f:46:4e:96:
                    a7:f4:1e:3e:e1:f6:d8:09:e1:33:64:2b:63:d7:32:
                    5e:9f:f9:c0:7b:0f:78:6f:97:bc:93:9a:f9:9c:12:
                    90:78:7a:80:87:15:d7:72:74:9c:55:74:78:b1:ba:
                    e1:6e:70:04:ba:4f:a0:ba:68:c3:7b:ff:31:f0:73:
                    3d:3d:94:2a:b1:0b:41:0e:a0:fe:4d:88:65:6b:79:
                    33:b4:d7
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Subject Key Identifier: 
                ED:44:19:C0:D3:F0:06:8B:EE:A4:7B:BE:42:E7:26:54:C8:8E:36:76
    Signature Algorithm: sha256WithRSAEncryption
         0d:ae:90:32:f6:a6:4b:7c:44:76:19:61:1e:27:28:cd:5e:54:
         ef:25:bc:e3:08:90:f9:29:d7:ae:68:08:e1:94:00:58:ef:2e:
         2e:7e:53:52:8c:b6:5c:07:ea:88:ba:99:8b:50:94:d7:82:80:
         df:61:09:00:93:ad:0d:14:e6:ce:c1:f2:37:94:78:b0:5f:9c:
         b3:a2:73:b8:8f:05:93:38:cd:8d:3e:b0:b8:fb:c0:cf:b1:f2:
         ec:2d:2d:1b:cc:ec:aa:9a:b3:aa:60:82:1b:2d:3b:c3:84:3d:
         57:8a:96:1e:9c:75:b8:d3:30:cd:60:08:83:90:d3:8e:54:f1:
         4d:66:c0:5d:74:03:40:a3:ee:85:7e:c2:1f:77:9c:06:e8:c1:
         a7:18:5d:52:95:ed:c9:dd:25:9e:6d:fa:a9:ed:a3:3a:34:d0:
         59:7b:da:ed:50:f3:35:bf:ed:eb:14:4d:31:c7:60:f4:da:f1:
         87:9c:e2:48:e2:c6:c5:37:fb:06:10:fa:75:59:66:31:47:29:
         da:76:9a:1c:e9:82:ae:ef:9a:b9:51:f7:88:23:9a:69:95:62:
         3c:e5:55:80:36:d7:54:02:ff:f1:b9:5d:ce:d4:23:6f:d8:45:
         84:4a:5b:65:ef:89:0c:dd:14:a7:20:cb:18:a5:25:b4:0d:f9:
         01:f0:a2:d2:f4:00:c8:74:8e:a1:2a:48:8e:65:db:13:c4:e2:
         25:17:7d:eb:be:87:5b:17:20:54:51:93:4a:53:03:0b:ec:5d:
         ca:33:ed:62:fd:45:c7:2f:5b:dc:58:a0:80:39:e6:fa:d7:fe:
         13:14:a6:ed:3d:94:4a:42:74:d4:c3:77:59:73:cd:8f:46:be:
         55:38:ef:fa:e8:91:32:ea:97:58:04:22:de:38:c3:cc:bc:6d:
         c9:33:3a:6a:0a:69:3f:a0:c8:ea:72:8f:8c:63:86:23:bd:6d:
         3c:96:9e:95:e0:49:4c:aa:a2:b9:2a:1b:9c:36:81:78:ed:c3:
         e8:46:e2:26:59:44:75:1e:d9:75:89:51:cd:10:84:9d:61:60:
         cb:5d:f9:97:22:4d:8e:98:e6:e3:7f:f6:5b:bb:ae:cd:ca:4a:
         81:6b:5e:0b:f3:51:e1:74:2b:e9:7e:27:a7:d9:99:49:4e:f8:
         a5:80:db:25:0f:1c:63:62:8a:c9:33:67:6b:3c:10:83:c6:ad:
         de:a8:cd:16:8e:8d:f0:07:37:71:9f:f2:ab:fc:41:f5:c1:8b:
         ec:00:37:5d:09:e5:4e:80:ef:fa:b1:5c:38:06:a5:1b:4a:e1:
         dc:38:2d:3c:dc:ab:1f:90:1a:d5:4a:9c:ee:d1:70:6c:cc:ee:
         f4:57:f8:18:ba:84:6e:87
-----BEGIN CERTIFICATE-----
MIIFYDCCA0igAwIBAgIQCgFCgAAAAUUjyES1AAAAAjANBgkqhkiG9w0BAQsFADBK
MQswCQYDVQQGEwJVUzESMBAGA1UEChMJSWRlblRydXN0MScwJQYDVQQDEx5JZGVu
VHJ1c3QgQ29tbWVyY2lhbCBSb290IENBIDEwHhcNMTQwMTE2MTgxMjIzWhcNMzQw
MTE2MTgxMjIzWjBKMQswCQYDVQQGEwJVUzESMBAGA1UEChMJSWRlblRydXN0MScw
JQYDVQQDEx5JZGVuVHJ1c3QgQ29tbWVyY2lhbCBSb290IENBIDEwggIiMA0GCSqG
SIb3DQEBAQUAA4ICDwAwggIKAoICAQCnUBneP5k91DNG8W9RYYKyqU+PZ4ldhNlT
3Qwo2dfw/66VQ3KZ+bVdfIrBQuExUHTRgQ18zZshq0PirK1ehm7zCYofWjK9ouuU
+ehcCuz/mNKvcbO0U59Oh++SvL3sTzIwiEsXXlfEU8L2ApeN2WIrvyQfYo3fw7gp
S0l4PJNgiCL8mdo2yMKi1CxUAGc1bnO/AljwpN3lsKImesrgNqUZFvX9t++uP0D1
bVoE/c40yiTcdCMbXTMTEl3EASX2MN0CXZ/g1Ue9tOsbobtJSdifWwLziuQkkORi
T0/Br4sOdBeo0XKIanoBScy0RnnGF7HamB4HWfp1IYVl3ZBWzvurpWCdxJ35UrCL
vYf5jysjCiN2O/cz4ckA82n5S6LgTrx+kzmEB/dEcH7+B1rlsazRGMzyNeVJSQjK
Vsk9+w8YfYs7wRPCTY/JTw436R+hDmrfYi7LNQZReSzIJTj0+kuniVyc0uMNOYZK
dHzVWYfCP04MXFL0PfdSgvHqo6z9STQaKPNBiDoT7uje/5kdX7rL6B7yuVBgwDHT
c+XvvqDtMwt0viAgxGds8AgDelWAf0ZOlqf0Hj7h9tgJ4TNkK2PXMl6f+cB7D3hv
l7yTmvmcEpB4eoCHFddydJxVdHixuuFucAS6T6C6aMN7/zHwcz09lCqxC0EOoP5N
iGVreTO01wIDAQABo0IwQDAOBgNVHQ8BAf8EBAMCAQYwDwYDVR0TAQH/BAUwAwEB
/zAdBgNVHQ4EFgQU7UQZwNPwBovupHu+QucmVMiONnYwDQYJKoZIhvcNAQELBQAD
ggIBAA2ukDL2pkt8RHYZYR4nKM1eVO8lvOMIkPkp165oCOGUAFjvLi5+U1KMtlwH
6oi6mYtQlNeCgN9hCQCTrQ0U5s7B8jeUeLBfnLOic7iPBZM4zY0+sLj7wM+x8uwt
LRvM7Kqas6pgghstO8OEPVeKlh6cdbjTMM1gCIOQ045U8U1mwF10A0Cj7oV+wh93
nAbowacYXVKV7cndJZ5t+qntozo00Fl72u1Q8zW/7esUTTHHYPTa8Yec4kjixsU3
+wYQ+nVZZjFHKdp2mhzpgq7vmrlR94gjmmmVYjzlVYA211QC//G5Xc7UI2/YRYRK
W2XviQzdFKcgyxilJbQN+QHwotL0AMh0jqEqSI5l2xPE4iUXfeu+h1sXIFRRk0pT
AwvsXcoz7WL9RccvW9xYoIA55vrX/hMUpu09lEpCdNTDd1lzzY9GvlU47/rokTLq
l1gEIt44w8y8bckzOmoKaT+gyOpyj4xjhiO9bTyWnpXgSUyqorkqG5w2gXjtw+hG
4iZZRHUe2XWJUc0QhJ1hYMtd+ZciTY6Y5uN/9lu7rs3KSoFrXgvzUeF0K+l+J6fZ
mUlO+KWA2yUPHGNiiskzZ2s8EIPGrd6ozRaOjfAHN3Gf8qv8QfXBi+wAN10J5U6A
7/qxXDgGpRtK4dw4LTzcqx+QGtVKnO7RcGzM7vRX+Bi6hG6H
-----END CERTIFICATE-----

IdenTrust Public Sector Root CA 1
================================================
SHA1 Fingerprint=BA:29:41:60:77:98:3F:F4:F3:EF:F2:31:05:3B:2E:EA:6D:4D:45:FD
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            0a:01:42:80:00:00:01:45:23:cf:46:7c:00:00:00:02
    Signature Algorithm: sha256WithRSAEncryption
        Issuer: C=US, O=IdenTrust, CN=IdenTrust Public Sector Root CA 1
        Validity
            Not Before: Jan 16 17:53:32 2014 GMT
            Not After : Jan 16 17:53:32 2034 GMT
        Subject: C=US, O=IdenTrust, CN=IdenTrust Public Sector Root CA 1
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (4096 bit)
                Modulus:
                    00:b6:22:94:fc:a4:48:af:e8:47:6b:0a:fb:27:76:
                    e4:f2:3f:8a:3b:7a:4a:2c:31:2a:8c:8d:b0:a9:c3:
                    31:6b:a8:77:76:84:26:b6:ac:81:42:0d:08:eb:55:
                    58:bb:7a:f8:bc:65:7d:f2:a0:6d:8b:a8:47:e9:62:
                    76:1e:11:ee:08:14:d1:b2:44:16:f4:ea:d0:fa:1e:
                    2f:5e:db:cb:73:41:ae:bc:00:b0:4a:2b:40:b2:ac:
                    e1:3b:4b:c2:2d:9d:e4:a1:9b:ec:1a:3a:1e:f0:08:
                    b3:d0:e4:24:35:07:9f:9c:b4:c9:52:6d:db:07:ca:
                    8f:b5:5b:f0:83:f3:4f:c7:2d:a5:c8:ad:cb:95:20:
                    a4:31:28:57:58:5a:e4:8d:1b:9a:ab:9e:0d:0c:f2:
                    0a:33:39:22:39:0a:97:2e:f3:53:77:b9:44:45:fd:
                    84:cb:36:20:81:59:2d:9a:6f:6d:48:48:61:ca:4c:
                    df:53:d1:af:52:bc:44:9f:ab:2f:6b:83:72:ef:75:
                    80:da:06:33:1b:5d:c8:da:63:c6:4d:cd:ac:66:31:
                    cd:d1:de:3e:87:10:36:e1:b9:a4:7a:ef:60:50:b2:
                    cb:ca:a6:56:e0:37:af:ab:34:13:39:25:e8:39:66:
                    e4:98:7a:aa:12:98:9c:59:66:86:3e:ad:f1:b0:ca:
                    3e:06:0f:7b:f0:11:4b:37:a0:44:6d:7b:cb:a8:8c:
                    71:f4:d5:b5:91:36:cc:f0:15:c6:2b:de:51:17:b1:
                    97:4c:50:3d:b1:95:59:7c:05:7d:2d:21:d5:00:bf:
                    01:67:a2:5e:7b:a6:5c:f2:f7:22:f1:90:0d:93:db:
                    aa:44:51:66:cc:7d:76:03:eb:6a:a8:2a:38:19:97:
                    76:0d:6b:8a:61:f9:bc:f6:ee:76:fd:70:2b:dd:29:
                    3c:f8:0a:1e:5b:42:1c:8b:56:2f:55:1b:1c:a1:2e:
                    b5:c7:16:e6:f8:aa:3c:92:8e:69:b6:01:c1:b5:86:
                    9d:89:0f:0b:38:94:54:e8:ea:dc:9e:3d:25:bc:53:
                    26:ed:d5:ab:39:aa:c5:40:4c:54:ab:b2:b4:d9:d9:
                    f8:d7:72:db:1c:bc:6d:bd:65:5f:ef:88:35:2a:66:
                    2f:ee:f6:b3:65:f0:33:8d:7c:98:41:69:46:0f:43:
                    1c:69:fa:9b:b5:d0:61:6a:cd:ca:4b:d9:4c:90:46:
                    ab:15:59:a1:47:54:29:2e:83:28:5f:1c:c2:a2:ab:
                    72:17:00:06:8e:45:ec:8b:e2:33:3d:7f:da:19:44:
                    e4:62:72:c3:df:22:c6:f2:56:d4:dd:5f:95:72:ed:
                    6d:5f:f7:48:03:5b:fd:c5:2a:a0:f6:73:23:84:10:
                    1b:01:e7
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Subject Key Identifier: 
                E3:71:E0:9E:D8:A7:42:D9:DB:71:91:6B:94:93:EB:C3:A3:D1:14:A3
    Signature Algorithm: sha256WithRSAEncryption
         47:fa:dd:0a:b0:11:91:38:ad:4d:5d:f7:e5:0e:97:54:19:82:
         48:87:54:8c:aa:64:99:d8:5a:fe:88:01:c5:58:a5:99:b1:23:
         54:23:b7:6a:1d:20:57:e5:01:62:41:17:d3:09:db:75:cb:6e:
         54:90:75:fe:1a:9f:81:0a:c2:dd:d7:f7:09:d0:5b:72:15:e4:
         1e:09:6a:3d:33:f3:21:9a:e6:15:7e:ad:51:d5:0d:10:ed:7d:
         42:c0:8f:ee:c0:9a:08:d5:41:d6:5c:0e:21:69:6e:80:61:0e:
         15:c0:b8:cf:c5:49:12:52:cc:be:3a:cc:d4:2e:38:05:de:35:
         fd:1f:6f:b8:80:68:98:3d:4d:a0:ca:40:65:d2:73:7c:f5:8b:
         d9:0a:95:3f:d8:3f:23:6d:1a:d1:2a:24:19:d9:85:b3:17:ef:
         78:6e:a9:58:d1:23:d3:c7:13:ed:72:25:7f:5d:b1:73:70:d0:
         7f:06:97:09:84:29:80:61:1d:fa:5e:ff:73:ac:a0:e3:89:b8:
         1c:71:15:c6:de:31:7f:12:dc:e1:6d:9b:af:e7:e8:9f:75:78:
         4c:ab:46:3b:9a:ce:bf:05:18:5d:4d:15:3c:16:9a:19:50:04:
         9a:b2:9a:6f:65:8b:52:5f:3c:58:04:28:25:c0:66:61:31:7e:
         b9:e0:75:b9:1a:a8:81:d6:72:17:b3:c5:03:31:35:11:78:78:
         a2:e0:e9:30:8c:7f:80:df:58:df:3c:ba:27:96:e2:80:34:6d:
         e3:98:d3:64:27:ac:48:7e:28:77:5c:c6:25:61:25:f8:85:0c:
         65:fa:c4:32:2f:a5:98:05:e4:f8:0b:67:16:16:c6:82:b8:32:
         19:f9:f9:b9:79:dc:1f:cd:eb:af:ab:0e:dd:1b:db:45:e4:7a:
         e7:02:e2:95:5d:fc:69:f0:53:69:61:95:75:79:0b:5e:55:e6:
         38:1c:94:a9:59:33:9e:c8:71:74:79:7f:51:89:b6:c8:6a:b8:
         30:c8:6a:38:c3:6e:9e:e1:37:16:ea:05:62:4c:5b:12:47:ed:
         a7:b4:b3:58:56:c7:49:f3:7f:12:68:09:31:71:f0:6d:f8:4e:
         47:fb:d6:85:ee:c5:58:40:19:a4:1d:a7:f9:4b:43:37:dc:68:
         5a:4f:cf:eb:c2:64:74:de:b4:15:d9:f4:54:54:1a:2f:1c:d7:
         97:71:54:90:8e:d9:20:9d:53:2b:7f:ab:8f:e2:ea:30:bc:50:
         37:ef:f1:47:b5:7d:7c:2c:04:ec:68:9d:b4:49:44:10:f4:72:
         4b:1c:64:e7:fc:e6:6b:90:dd:69:7d:69:fd:00:56:a5:b7:ac:
         b6:ad:b7:ca:3e:01:ef:9c
-----BEGIN CERTIFICATE-----
MIIFZjCCA06gAwIBAgIQCgFCgAAAAUUjz0Z8AAAAAjANBgkqhkiG9w0BAQsFADBN
MQswCQYDVQQGEwJVUzESMBAGA1UEChMJSWRlblRydXN0MSowKAYDVQQDEyFJZGVu
VHJ1c3QgUHVibGljIFNlY3RvciBSb290IENBIDEwHhcNMTQwMTE2MTc1MzMyWhcN
MzQwMTE2MTc1MzMyWjBNMQswCQYDVQQGEwJVUzESMBAGA1UEChMJSWRlblRydXN0
MSowKAYDVQQDEyFJZGVuVHJ1c3QgUHVibGljIFNlY3RvciBSb290IENBIDEwggIi
MA0GCSqGSIb3DQEBAQUAA4ICDwAwggIKAoICAQC2IpT8pEiv6EdrCvsnduTyP4o7
ekosMSqMjbCpwzFrqHd2hCa2rIFCDQjrVVi7evi8ZX3yoG2LqEfpYnYeEe4IFNGy
RBb06tD6Hi9e28tzQa68ALBKK0CyrOE7S8ItneShm+waOh7wCLPQ5CQ1B5+ctMlS
bdsHyo+1W/CD80/HLaXIrcuVIKQxKFdYWuSNG5qrng0M8gozOSI5Cpcu81N3uURF
/YTLNiCBWS2ab21ISGHKTN9T0a9SvESfqy9rg3LvdYDaBjMbXcjaY8ZNzaxmMc3R
3j6HEDbhuaR672BQssvKplbgN6+rNBM5Jeg5ZuSYeqoSmJxZZoY+rfGwyj4GD3vw
EUs3oERte8uojHH01bWRNszwFcYr3lEXsZdMUD2xlVl8BX0tIdUAvwFnol57plzy
9yLxkA2T26pEUWbMfXYD62qoKjgZl3YNa4ph+bz27nb9cCvdKTz4Ch5bQhyLVi9V
GxyhLrXHFub4qjySjmm2AcG1hp2JDws4lFTo6tyePSW8Uybt1as5qsVATFSrsrTZ
2fjXctscvG29ZV/viDUqZi/u9rNl8DONfJhBaUYPQxxp+pu10GFqzcpL2UyQRqsV
WaFHVCkugyhfHMKiq3IXAAaOReyL4jM9f9oZRORicsPfIsbyVtTdX5Vy7W1f90gD
W/3FKqD2cyOEEBsB5wIDAQABo0IwQDAOBgNVHQ8BAf8EBAMCAQYwDwYDVR0TAQH/
BAUwAwEB/zAdBgNVHQ4EFgQU43HgntinQtnbcZFrlJPrw6PRFKMwDQYJKoZIhvcN
AQELBQADggIBAEf63QqwEZE4rU1d9+UOl1QZgkiHVIyqZJnYWv6IAcVYpZmxI1Qj
t2odIFflAWJBF9MJ23XLblSQdf4an4EKwt3X9wnQW3IV5B4Jaj0z8yGa5hV+rVHV
DRDtfULAj+7AmgjVQdZcDiFpboBhDhXAuM/FSRJSzL46zNQuOAXeNf0fb7iAaJg9
TaDKQGXSc3z1i9kKlT/YPyNtGtEqJBnZhbMX73huqVjRI9PHE+1yJX9dsXNw0H8G
lwmEKYBhHfpe/3OsoOOJuBxxFcbeMX8S3OFtm6/n6J91eEyrRjuazr8FGF1NFTwW
mhlQBJqymm9li1JfPFgEKCXAZmExfrngdbkaqIHWchezxQMxNRF4eKLg6TCMf4Df
WN88uieW4oA0beOY02QnrEh+KHdcxiVhJfiFDGX6xDIvpZgF5PgLZxYWxoK4Mhn5
+bl53B/N66+rDt0b20XkeucC4pVd/GnwU2lhlXV5C15V5jgclKlZM57IcXR5f1GJ
tshquDDIajjDbp7hNxbqBWJMWxJH7ae0s1hWx0nzfxJoCTFx8G34Tkf71oXuxVhA
GaQdp/lLQzfcaFpPz+vCZHTetBXZ9FRUGi8c15dxVJCO2SCdUyt/q4/i6jC8UDfv
8Ue1fXwsBOxonbRJRBD0ckscZOf85muQ3Wl9af0AVqW3rLatt8o+Ae+c
-----END CERTIFICATE-----

Entrust Root Certification Authority - G2
================================================
SHA1 Fingerprint=8C:F4:27:FD:79:0C:3A:D1:66:06:8D:E8:1E:57:EF:BB:93:22:72:D4
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 1246989352 (0x4a538c28)
    Signature Algorithm: sha256WithRSAEncryption
        Issuer: C=US, O=Entrust, Inc., OU=See www.entrust.net/legal-terms, OU=(c) 2009 Entrust, Inc. - for authorized use only, CN=Entrust Root Certification Authority - G2
        Validity
            Not Before: Jul  7 17:25:54 2009 GMT
            Not After : Dec  7 17:55:54 2030 GMT
        Subject: C=US, O=Entrust, Inc., OU=See www.entrust.net/legal-terms, OU=(c) 2009 Entrust, Inc. - for authorized use only, CN=Entrust Root Certification Authority - G2
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (2048 bit)
                Modulus:
                    00:ba:84:b6:72:db:9e:0c:6b:e2:99:e9:30:01:a7:
                    76:ea:32:b8:95:41:1a:c9:da:61:4e:58:72:cf:fe:
                    f6:82:79:bf:73:61:06:0a:a5:27:d8:b3:5f:d3:45:
                    4e:1c:72:d6:4e:32:f2:72:8a:0f:f7:83:19:d0:6a:
                    80:80:00:45:1e:b0:c7:e7:9a:bf:12:57:27:1c:a3:
                    68:2f:0a:87:bd:6a:6b:0e:5e:65:f3:1c:77:d5:d4:
                    85:8d:70:21:b4:b3:32:e7:8b:a2:d5:86:39:02:b1:
                    b8:d2:47:ce:e4:c9:49:c4:3b:a7:de:fb:54:7d:57:
                    be:f0:e8:6e:c2:79:b2:3a:0b:55:e2:50:98:16:32:
                    13:5c:2f:78:56:c1:c2:94:b3:f2:5a:e4:27:9a:9f:
                    24:d7:c6:ec:d0:9b:25:82:e3:cc:c2:c4:45:c5:8c:
                    97:7a:06:6b:2a:11:9f:a9:0a:6e:48:3b:6f:db:d4:
                    11:19:42:f7:8f:07:bf:f5:53:5f:9c:3e:f4:17:2c:
                    e6:69:ac:4e:32:4c:62:77:ea:b7:e8:e5:bb:34:bc:
                    19:8b:ae:9c:51:e7:b7:7e:b5:53:b1:33:22:e5:6d:
                    cf:70:3c:1a:fa:e2:9b:67:b6:83:f4:8d:a5:af:62:
                    4c:4d:e0:58:ac:64:34:12:03:f8:b6:8d:94:63:24:
                    a4:71
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Subject Key Identifier: 
                6A:72:26:7A:D0:1E:EF:7D:E7:3B:69:51:D4:6C:8D:9F:90:12:66:AB
    Signature Algorithm: sha256WithRSAEncryption
         79:9f:1d:96:c6:b6:79:3f:22:8d:87:d3:87:03:04:60:6a:6b:
         9a:2e:59:89:73:11:ac:43:d1:f5:13:ff:8d:39:2b:c0:f2:bd:
         4f:70:8c:a9:2f:ea:17:c4:0b:54:9e:d4:1b:96:98:33:3c:a8:
         ad:62:a2:00:76:ab:59:69:6e:06:1d:7e:c4:b9:44:8d:98:af:
         12:d4:61:db:0a:19:46:47:f3:eb:f7:63:c1:40:05:40:a5:d2:
         b7:f4:b5:9a:36:bf:a9:88:76:88:04:55:04:2b:9c:87:7f:1a:
         37:3c:7e:2d:a5:1a:d8:d4:89:5e:ca:bd:ac:3d:6c:d8:6d:af:
         d5:f3:76:0f:cd:3b:88:38:22:9d:6c:93:9a:c4:3d:bf:82:1b:
         65:3f:a6:0f:5d:aa:fc:e5:b2:15:ca:b5:ad:c6:bc:3d:d0:84:
         e8:ea:06:72:b0:4d:39:32:78:bf:3e:11:9c:0b:a4:9d:9a:21:
         f3:f0:9b:0b:30:78:db:c1:dc:87:43:fe:bc:63:9a:ca:c5:c2:
         1c:c9:c7:8d:ff:3b:12:58:08:e6:b6:3d:ec:7a:2c:4e:fb:83:
         96:ce:0c:3c:69:87:54:73:a4:73:c2:93:ff:51:10:ac:15:54:
         01:d8:fc:05:b1:89:a1:7f:74:83:9a:49:d7:dc:4e:7b:8a:48:
         6f:8b:45:f6
-----BEGIN CERTIFICATE-----
MIIEPjCCAyagAwIBAgIESlOMKDANBgkqhkiG9w0BAQsFADCBvjELMAkGA1UEBhMC
VVMxFjAUBgNVBAoTDUVudHJ1c3QsIEluYy4xKDAmBgNVBAsTH1NlZSB3d3cuZW50
cnVzdC5uZXQvbGVnYWwtdGVybXMxOTA3BgNVBAsTMChjKSAyMDA5IEVudHJ1c3Qs
IEluYy4gLSBmb3IgYXV0aG9yaXplZCB1c2Ugb25seTEyMDAGA1UEAxMpRW50cnVz
dCBSb290IENlcnRpZmljYXRpb24gQXV0aG9yaXR5IC0gRzIwHhcNMDkwNzA3MTcy
NTU0WhcNMzAxMjA3MTc1NTU0WjCBvjELMAkGA1UEBhMCVVMxFjAUBgNVBAoTDUVu
dHJ1c3QsIEluYy4xKDAmBgNVBAsTH1NlZSB3d3cuZW50cnVzdC5uZXQvbGVnYWwt
dGVybXMxOTA3BgNVBAsTMChjKSAyMDA5IEVudHJ1c3QsIEluYy4gLSBmb3IgYXV0
aG9yaXplZCB1c2Ugb25seTEyMDAGA1UEAxMpRW50cnVzdCBSb290IENlcnRpZmlj
YXRpb24gQXV0aG9yaXR5IC0gRzIwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEK
AoIBAQC6hLZy254Ma+KZ6TABp3bqMriVQRrJ2mFOWHLP/vaCeb9zYQYKpSfYs1/T
RU4cctZOMvJyig/3gxnQaoCAAEUesMfnmr8SVycco2gvCoe9amsOXmXzHHfV1IWN
cCG0szLni6LVhjkCsbjSR87kyUnEO6fe+1R9V77w6G7CebI6C1XiUJgWMhNcL3hW
wcKUs/Ja5CeanyTXxuzQmyWC48zCxEXFjJd6BmsqEZ+pCm5IO2/b1BEZQvePB7/1
U1+cPvQXLOZprE4yTGJ36rfo5bs0vBmLrpxR57d+tVOxMyLlbc9wPBr64ptntoP0
jaWvYkxN4FisZDQSA/i2jZRjJKRxAgMBAAGjQjBAMA4GA1UdDwEB/wQEAwIBBjAP
BgNVHRMBAf8EBTADAQH/MB0GA1UdDgQWBBRqciZ60B7vfec7aVHUbI2fkBJmqzAN
BgkqhkiG9w0BAQsFAAOCAQEAeZ8dlsa2eT8ijYfThwMEYGprmi5ZiXMRrEPR9RP/
jTkrwPK9T3CMqS/qF8QLVJ7UG5aYMzyorWKiAHarWWluBh1+xLlEjZivEtRh2woZ
Rkfz6/djwUAFQKXSt/S1mja/qYh2iARVBCuch38aNzx+LaUa2NSJXsq9rD1s2G2v
1fN2D807iDginWyTmsQ9v4IbZT+mD12q/OWyFcq1rca8PdCE6OoGcrBNOTJ4vz4R
nAuknZoh8/CbCzB428Hch0P+vGOaysXCHMnHjf87ElgI5rY97HosTvuDls4MPGmH
VHOkc8KT/1EQrBVUAdj8BbGJoX90g5pJ19xOe4pIb4tF9g==
-----END CERTIFICATE-----

Entrust Root Certification Authority - EC1
================================================
SHA1 Fingerprint=20:D8:06:40:DF:9B:25:F5:12:25:3A:11:EA:F7:59:8A:EB:14:B5:47
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            a6:8b:79:29:00:00:00:00:50:d0:91:f9
    Signature Algorithm: ecdsa-with-SHA384
        Issuer: C=US, O=Entrust, Inc., OU=See www.entrust.net/legal-terms, OU=(c) 2012 Entrust, Inc. - for authorized use only, CN=Entrust Root Certification Authority - EC1
        Validity
            Not Before: Dec 18 15:25:36 2012 GMT
            Not After : Dec 18 15:55:36 2037 GMT
        Subject: C=US, O=Entrust, Inc., OU=See www.entrust.net/legal-terms, OU=(c) 2012 Entrust, Inc. - for authorized use only, CN=Entrust Root Certification Authority - EC1
        Subject Public Key Info:
            Public Key Algorithm: id-ecPublicKey
                Public-Key: (384 bit)
                pub: 
                    04:84:13:c9:d0:ba:6d:41:7b:e2:6c:d0:eb:55:5f:
                    66:02:1a:24:f4:5b:89:69:47:e3:b8:c2:7d:f1:f2:
                    02:c5:9f:a0:f6:5b:d5:8b:06:19:86:4f:53:10:6d:
                    07:24:27:a1:a0:f8:d5:47:19:61:4c:7d:ca:93:27:
                    ea:74:0c:ef:6f:96:09:fe:63:ec:70:5d:36:ad:67:
                    77:ae:c9:9d:7c:55:44:3a:a2:63:51:1f:f5:e3:62:
                    d4:a9:47:07:3e:cc:20
                ASN1 OID: secp384r1
        X509v3 extensions:
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Subject Key Identifier: 
                B7:63:E7:1A:DD:8D:E9:08:A6:55:83:A4:E0:6A:50:41:65:11:42:49
    Signature Algorithm: ecdsa-with-SHA384
         30:64:02:30:61:79:d8:e5:42:47:df:1c:ae:53:99:17:b6:6f:
         1c:7d:e1:bf:11:94:d1:03:88:75:e4:8d:89:a4:8a:77:46:de:
         6d:61:ef:02:f5:fb:b5:df:cc:fe:4e:ff:fe:a9:e6:a7:02:30:
         5b:99:d7:85:37:06:b5:7b:08:fd:eb:27:8b:4a:94:f9:e1:fa:
         a7:8e:26:08:e8:7c:92:68:6d:73:d8:6f:26:ac:21:02:b8:99:
         b7:26:41:5b:25:60:ae:d0:48:1a:ee:06
-----BEGIN CERTIFICATE-----
MIIC+TCCAoCgAwIBAgINAKaLeSkAAAAAUNCR+TAKBggqhkjOPQQDAzCBvzELMAkG
A1UEBhMCVVMxFjAUBgNVBAoTDUVudHJ1c3QsIEluYy4xKDAmBgNVBAsTH1NlZSB3
d3cuZW50cnVzdC5uZXQvbGVnYWwtdGVybXMxOTA3BgNVBAsTMChjKSAyMDEyIEVu
dHJ1c3QsIEluYy4gLSBmb3IgYXV0aG9yaXplZCB1c2Ugb25seTEzMDEGA1UEAxMq
RW50cnVzdCBSb290IENlcnRpZmljYXRpb24gQXV0aG9yaXR5IC0gRUMxMB4XDTEy
MTIxODE1MjUzNloXDTM3MTIxODE1NTUzNlowgb8xCzAJBgNVBAYTAlVTMRYwFAYD
VQQKEw1FbnRydXN0LCBJbmMuMSgwJgYDVQQLEx9TZWUgd3d3LmVudHJ1c3QubmV0
L2xlZ2FsLXRlcm1zMTkwNwYDVQQLEzAoYykgMjAxMiBFbnRydXN0LCBJbmMuIC0g
Zm9yIGF1dGhvcml6ZWQgdXNlIG9ubHkxMzAxBgNVBAMTKkVudHJ1c3QgUm9vdCBD
ZXJ0aWZpY2F0aW9uIEF1dGhvcml0eSAtIEVDMTB2MBAGByqGSM49AgEGBSuBBAAi
A2IABIQTydC6bUF74mzQ61VfZgIaJPRbiWlH47jCffHyAsWfoPZb1YsGGYZPUxBt
ByQnoaD41UcZYUx9ypMn6nQM72+WCf5j7HBdNq1nd67JnXxVRDqiY1Ef9eNi1KlH
Bz7MIKNCMEAwDgYDVR0PAQH/BAQDAgEGMA8GA1UdEwEB/wQFMAMBAf8wHQYDVR0O
BBYEFLdj5xrdjekIplWDpOBqUEFlEUJJMAoGCCqGSM49BAMDA2cAMGQCMGF52OVC
R98crlOZF7ZvHH3hvxGU0QOIdeSNiaSKd0bebWHvAvX7td/M/k7//qnmpwIwW5nX
hTcGtXsI/esni0qU+eH6p44mCOh8kmhtc9hvJqwhAriZtyZBWyVgrtBIGu4G
-----END CERTIFICATE-----

CFCA EV ROOT
=================================================
SHA1 Fingerprint=E2:B8:29:4B:55:84:AB:6B:58:C2:90:46:6C:AC:3F:B8:39:8F:84:83
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 407555286 (0x184accd6)
    Signature Algorithm: sha256WithRSAEncryption
        Issuer: C=CN, O=China Financial Certification Authority, CN=CFCA EV ROOT
        Validity
            Not Before: Aug  8 03:07:01 2012 GMT
            Not After : Dec 31 03:07:01 2029 GMT
        Subject: C=CN, O=China Financial Certification Authority, CN=CFCA EV ROOT
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (4096 bit)
                Modulus:
                    00:d7:5d:6b:cd:10:3f:1f:05:59:d5:05:4d:37:b1:
                    0e:ec:98:2b:8e:15:1d:fa:93:4b:17:82:21:71:10:
                    52:d7:51:64:70:16:c2:55:69:4d:8e:15:6d:9f:bf:
                    0c:1b:c2:e0:a3:67:d6:0c:ac:cf:22:ae:af:77:54:
                    2a:4b:4c:8a:53:52:7a:c3:ee:2e:de:b3:71:25:c1:
                    e9:5d:3d:ee:a1:2f:a3:f7:2a:3c:c9:23:1d:6a:ab:
                    1d:a1:a7:f1:f3:ec:a0:d5:44:cf:15:cf:72:2f:1d:
                    63:97:e8:99:f9:fd:93:a4:54:80:4c:52:d4:52:ab:
                    2e:49:df:90:cd:b8:5f:be:3f:de:a1:ca:4d:20:d4:
                    25:e8:84:29:53:b7:b1:88:1f:ff:fa:da:90:9f:0a:
                    a9:2d:41:3f:b1:f1:18:29:ee:16:59:2c:34:49:1a:
                    a8:06:d7:a8:88:d2:03:72:7a:32:e2:ea:68:4d:6e:
                    2c:96:65:7b:ca:59:fa:f2:e2:dd:ee:30:2c:fb:cc:
                    46:ac:c4:63:eb:6f:7f:36:2b:34:73:12:94:7f:df:
                    cc:26:9e:f1:72:5d:50:65:59:8f:69:b3:87:5e:32:
                    6f:c3:18:8a:b5:95:8f:b0:7a:37:de:5a:45:3b:c7:
                    36:e1:ef:67:d1:39:d3:97:5b:73:62:19:48:2d:87:
                    1c:06:fb:74:98:20:49:73:f0:05:d2:1b:b1:a0:a3:
                    b7:1b:70:d3:88:69:b9:5a:d6:38:f4:62:dc:25:8b:
                    78:bf:f8:e8:7e:b8:5c:c9:95:4f:5f:a7:2d:b9:20:
                    6b:cf:6b:dd:f5:0d:f4:82:b7:f4:b2:66:2e:10:28:
                    f6:97:5a:7b:96:16:8f:01:19:2d:6c:6e:7f:39:58:
                    06:64:83:01:83:83:c3:4d:92:dd:32:c6:87:a4:37:
                    e9:16:ce:aa:2d:68:af:0a:81:65:3a:70:c1:9b:ad:
                    4d:6d:54:ca:2a:2d:4b:85:1b:b3:80:e6:70:45:0d:
                    6b:5e:35:f0:7f:3b:b8:9c:e4:04:70:89:12:25:93:
                    da:0a:99:22:60:6a:63:60:4e:76:06:98:4e:bd:83:
                    ad:1d:58:8a:25:85:d2:c7:65:1e:2d:8e:c6:df:b6:
                    c6:e1:7f:8a:04:21:15:29:74:f0:3e:9c:90:9d:0c:
                    2e:f1:8a:3e:5a:aa:0c:09:1e:c7:d5:3c:a3:ed:97:
                    c3:1e:34:fa:38:f9:08:0e:e3:c0:5d:2b:83:d1:56:
                    6a:c9:b6:a8:54:53:2e:78:32:67:3d:82:7f:74:d0:
                    fb:e1:b6:05:60:b9:70:db:8e:0b:f9:13:58:6f:71:
                    60:10:52:10:b9:c1:41:09:ef:72:1f:67:31:78:ff:
                    96:05:8d
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Authority Key Identifier: 
                keyid:E3:FE:2D:FD:28:D0:0B:B5:BA:B6:A2:C4:BF:06:AA:05:8C:93:FB:2F

            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Subject Key Identifier: 
                E3:FE:2D:FD:28:D0:0B:B5:BA:B6:A2:C4:BF:06:AA:05:8C:93:FB:2F
    Signature Algorithm: sha256WithRSAEncryption
         25:c6:ba:6b:eb:87:cb:de:82:39:96:3d:f0:44:a7:6b:84:73:
         03:de:9d:2b:4f:ba:20:7f:bc:78:b2:cf:97:b0:1b:9c:f3:d7:
         79:2e:f5:48:b6:d2:fb:17:88:e6:d3:7a:3f:ed:53:13:d0:e2:
         2f:6a:79:cb:00:23:28:e6:1e:37:57:35:89:84:c2:76:4f:34:
         36:ad:67:c3:ce:41:06:88:c5:f7:ee:d8:1a:b8:d6:0b:7f:50:
         ff:93:aa:17:4b:8c:ec:ed:52:60:b2:a4:06:ea:4e:eb:f4:6b:
         19:fd:eb:f5:1a:e0:25:2a:9a:dc:c7:41:36:f7:c8:74:05:84:
         39:95:39:d6:0b:3b:a4:27:fa:08:d8:5c:1e:f8:04:60:52:11:
         28:28:03:ff:ef:53:66:00:a5:4a:34:16:66:7c:fd:09:a4:ae:
         9e:67:1a:6f:41:0b:6b:06:13:9b:8f:86:71:05:b4:2f:8d:89:
         66:33:29:76:54:9a:11:f8:27:fa:b2:3f:91:e0:ce:0d:1b:f3:
         30:1a:ad:bf:22:5d:1b:d3:bf:25:05:4d:e1:92:1a:7f:99:9f:
         3c:44:93:ca:d4:40:49:6c:80:87:d7:04:3a:c3:32:52:35:0e:
         56:f8:a5:dd:7d:c4:8b:0d:11:1f:53:cb:1e:b2:17:b6:68:77:
         5a:e0:d4:cb:c8:07:ae:f5:3a:2e:8e:37:b7:d0:01:4b:43:29:
         77:8c:39:97:8f:82:5a:f8:51:e5:89:a0:18:e7:68:7f:5d:0a:
         2e:fb:a3:47:0e:3d:a6:23:7a:c6:01:c7:8f:c8:5e:bf:6d:80:
         56:be:8a:24:ba:33:ea:9f:e1:32:11:9e:f1:d2:4f:80:f6:1b:
         40:af:38:9e:11:50:79:73:12:12:cd:e6:6c:9d:2c:88:72:3c:
         30:81:06:91:22:ea:59:ad:da:19:2e:22:c2:8d:b9:8c:87:e0:
         66:bc:73:23:5f:21:64:63:80:48:f5:a0:3c:18:3d:94:c8:48:
         41:1d:40:ba:5e:fe:fe:56:39:a1:c8:cf:5e:9e:19:64:46:10:
         da:17:91:b7:05:80:ac:8b:99:92:7d:e7:a2:d8:07:0b:36:27:
         e7:48:79:60:8a:c3:d7:13:5c:f8:72:40:df:4a:cb:cf:99:00:
         0a:00:0b:11:95:da:56:45:03:88:0a:9f:67:d0:d5:79:b1:a8:
         8d:40:6d:0d:c2:7a:40:fa:f3:5f:64:47:92:cb:53:b9:bb:59:
         ce:4f:fd:d0:15:53:01:d8:df:eb:d9:e6:76:ef:d0:23:bb:3b:
         a9:79:b3:d5:02:29:cd:89:a3:96:0f:4a:35:e7:4e:42:c0:75:
         cd:07:cf:e6:2c:eb:7b:2e
-----BEGIN CERTIFICATE-----
MIIFjTCCA3WgAwIBAgIEGErM1jANBgkqhkiG9w0BAQsFADBWMQswCQYDVQQGEwJD
TjEwMC4GA1UECgwnQ2hpbmEgRmluYW5jaWFsIENlcnRpZmljYXRpb24gQXV0aG9y
aXR5MRUwEwYDVQQDDAxDRkNBIEVWIFJPT1QwHhcNMTIwODA4MDMwNzAxWhcNMjkx
MjMxMDMwNzAxWjBWMQswCQYDVQQGEwJDTjEwMC4GA1UECgwnQ2hpbmEgRmluYW5j
aWFsIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MRUwEwYDVQQDDAxDRkNBIEVWIFJP
T1QwggIiMA0GCSqGSIb3DQEBAQUAA4ICDwAwggIKAoICAQDXXWvNED8fBVnVBU03
sQ7smCuOFR36k0sXgiFxEFLXUWRwFsJVaU2OFW2fvwwbwuCjZ9YMrM8irq93VCpL
TIpTUnrD7i7es3ElweldPe6hL6P3KjzJIx1qqx2hp/Hz7KDVRM8Vz3IvHWOX6Jn5
/ZOkVIBMUtRSqy5J35DNuF++P96hyk0g1CXohClTt7GIH//62pCfCqktQT+x8Rgp
7hZZLDRJGqgG16iI0gNyejLi6mhNbiyWZXvKWfry4t3uMCz7zEasxGPrb382KzRz
EpR/38wmnvFyXVBlWY9ps4deMm/DGIq1lY+wejfeWkU7xzbh72fROdOXW3NiGUgt
hxwG+3SYIElz8AXSG7Ggo7cbcNOIabla1jj0Ytwli3i/+Oh+uFzJlU9fpy25IGvP
a931DfSCt/SyZi4QKPaXWnuWFo8BGS1sbn85WAZkgwGDg8NNkt0yxoekN+kWzqot
aK8KgWU6cMGbrU1tVMoqLUuFG7OA5nBFDWteNfB/O7ic5ARwiRIlk9oKmSJgamNg
TnYGmE69g60dWIolhdLHZR4tjsbftsbhf4oEIRUpdPA+nJCdDC7xij5aqgwJHsfV
PKPtl8MeNPo4+QgO48BdK4PRVmrJtqhUUy54Mmc9gn900PvhtgVguXDbjgv5E1hv
cWAQUhC5wUEJ73IfZzF4/5YFjQIDAQABo2MwYTAfBgNVHSMEGDAWgBTj/i39KNAL
tbq2osS/BqoFjJP7LzAPBgNVHRMBAf8EBTADAQH/MA4GA1UdDwEB/wQEAwIBBjAd
BgNVHQ4EFgQU4/4t/SjQC7W6tqLEvwaqBYyT+y8wDQYJKoZIhvcNAQELBQADggIB
ACXGumvrh8vegjmWPfBEp2uEcwPenStPuiB/vHiyz5ewG5zz13ku9Ui20vsXiObT
ej/tUxPQ4i9qecsAIyjmHjdXNYmEwnZPNDatZ8POQQaIxffu2Bq41gt/UP+TqhdL
jOztUmCypAbqTuv0axn96/Ua4CUqmtzHQTb3yHQFhDmVOdYLO6Qn+gjYXB74BGBS
ESgoA//vU2YApUo0FmZ8/Qmkrp5nGm9BC2sGE5uPhnEFtC+NiWYzKXZUmhH4J/qy
P5Hgzg0b8zAarb8iXRvTvyUFTeGSGn+ZnzxEk8rUQElsgIfXBDrDMlI1Dlb4pd19
xIsNER9Tyx6yF7Zod1rg1MvIB671Oi6ON7fQAUtDKXeMOZePglr4UeWJoBjnaH9d
Ci77o0cOPaYjesYBx4/IXr9tgFa+iiS6M+qf4TIRnvHST4D2G0CvOJ4RUHlzEhLN
5mydLIhyPDCBBpEi6lmt2hkuIsKNuYyH4Ga8cyNfIWRjgEj1oDwYPZTISEEdQLpe
/v5WOaHIz16eGWRGENoXkbcFgKyLmZJ956LYBws2J+dIeWCKw9cTXPhyQN9Ky8+Z
AAoACxGV2lZFA4gKn2fQ1XmxqI1AbQ3CekD6819kR5LLU7m7Wc5P/dAVUwHY3+vZ
5nbv0CO7O6l5s9UCKc2Jo5YPSjXnTkLAdc0Hz+Ys63su
-----END CERTIFICATE-----

OISTE WISeKey Global Root GB CA
================================================
SHA1 Fingerprint=0F:F9:40:76:18:D3:D7:6A:4B:98:F0:A8:35:9E:0C:FD:27:AC:CC:ED
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            76:b1:20:52:74:f0:85:87:46:b3:f8:23:1a:f6:c2:c0
    Signature Algorithm: sha256WithRSAEncryption
        Issuer: C=CH, O=WISeKey, OU=OISTE Foundation Endorsed, CN=OISTE WISeKey Global Root GB CA
        Validity
            Not Before: Dec  1 15:00:32 2014 GMT
            Not After : Dec  1 15:10:31 2039 GMT
        Subject: C=CH, O=WISeKey, OU=OISTE Foundation Endorsed, CN=OISTE WISeKey Global Root GB CA
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (2048 bit)
                Modulus:
                    00:d8:17:b7:1c:4a:24:2a:d6:97:b1:ca:e2:1e:fb:
                    7d:38:ef:98:f5:b2:39:98:4e:27:b8:11:5d:7b:d2:
                    25:94:88:82:15:26:6a:1b:31:bb:a8:5b:21:21:2b:
                    d8:0f:4e:9f:5a:f1:b1:5a:e4:79:d6:32:23:2b:e1:
                    53:cc:99:45:5c:7b:4f:ad:bc:bf:87:4a:0b:4b:97:
                    5a:a8:f6:48:ec:7d:7b:0d:cd:21:06:df:9e:15:fd:
                    41:8a:48:b7:20:f4:a1:7a:1b:57:d4:5d:50:ff:ba:
                    67:d8:23:99:1f:c8:3f:e3:de:ff:6f:5b:77:b1:6b:
                    6e:b8:c9:64:f7:e1:ca:41:46:0e:29:71:d0:b9:23:
                    fc:c9:81:5f:4e:f7:6f:df:bf:84:ad:73:64:bb:b7:
                    42:8e:69:f6:d4:76:1d:7e:9d:a7:b8:57:8a:51:67:
                    72:d7:d4:a8:b8:95:54:40:73:03:f6:ea:f4:eb:fe:
                    28:42:77:3f:9d:23:1b:b2:b6:3d:80:14:07:4c:2e:
                    4f:f7:d5:0a:16:0d:bd:66:43:37:7e:23:43:79:c3:
                    40:86:f5:4c:29:da:8e:9a:ad:0d:a5:04:87:88:1e:
                    85:e3:e9:53:d5:9b:c8:8b:03:63:78:eb:e0:19:4a:
                    6e:bb:2f:6b:33:64:58:93:ad:69:bf:8f:1b:ef:82:
                    48:c7
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Key Usage: 
                Digital Signature, Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Subject Key Identifier: 
                35:0F:C8:36:63:5E:E2:A3:EC:F9:3B:66:15:CE:51:52:E3:91:9A:3D
            1.3.6.1.4.1.311.21.1: 
                ...
    Signature Algorithm: sha256WithRSAEncryption
         40:4c:fb:87:b2:99:81:90:7e:9d:c5:b0:b0:26:cd:88:7b:2b:
         32:8d:6e:b8:21:71:58:97:7d:ae:37:14:af:3e:e7:f7:9a:e2:
         7d:f6:71:98:99:04:aa:43:74:78:a3:e3:49:61:3e:73:8c:4d:
         94:e0:f9:71:c4:b6:16:0e:53:78:1f:d6:a2:87:2f:02:39:81:
         29:3c:af:15:98:21:30:fe:28:90:00:8c:d1:e1:cb:fa:5e:c8:
         fd:f8:10:46:3b:a2:78:42:91:17:74:55:0a:de:50:67:4d:66:
         d1:a7:ff:fd:d9:c0:b5:a8:a3:8a:ce:66:f5:0f:43:cd:a7:2b:
         57:7b:63:46:6a:aa:2e:52:d8:f4:ed:e1:6d:ad:29:90:78:48:
         ba:e1:23:aa:a3:89:ec:b5:ab:96:c0:b4:4b:a2:1d:97:9e:7a:
         f2:6e:40:71:df:68:f1:65:4d:ce:7c:05:df:53:65:a9:a5:f0:
         b1:97:04:70:15:46:03:98:d4:d2:bf:54:b4:a0:58:7d:52:6f:
         da:56:26:62:d4:d8:db:89:31:6f:1c:f0:22:c2:d3:62:1c:35:
         cd:4c:69:15:54:1a:90:98:de:eb:1e:5f:ca:77:c7:cb:8e:3d:
         43:69:9c:9a:58:d0:24:3b:df:1b:40:96:7e:35:ad:81:c7:4e:
         71:ba:88:13
-----BEGIN CERTIFICATE-----
MIIDtTCCAp2gAwIBAgIQdrEgUnTwhYdGs/gjGvbCwDANBgkqhkiG9w0BAQsFADBt
MQswCQYDVQQGEwJDSDEQMA4GA1UEChMHV0lTZUtleTEiMCAGA1UECxMZT0lTVEUg
Rm91bmRhdGlvbiBFbmRvcnNlZDEoMCYGA1UEAxMfT0lTVEUgV0lTZUtleSBHbG9i
YWwgUm9vdCBHQiBDQTAeFw0xNDEyMDExNTAwMzJaFw0zOTEyMDExNTEwMzFaMG0x
CzAJBgNVBAYTAkNIMRAwDgYDVQQKEwdXSVNlS2V5MSIwIAYDVQQLExlPSVNURSBG
b3VuZGF0aW9uIEVuZG9yc2VkMSgwJgYDVQQDEx9PSVNURSBXSVNlS2V5IEdsb2Jh
bCBSb290IEdCIENBMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA2Be3
HEokKtaXscriHvt9OO+Y9bI5mE4nuBFde9IllIiCFSZqGzG7qFshISvYD06fWvGx
WuR51jIjK+FTzJlFXHtPrby/h0oLS5daqPZI7H17Dc0hBt+eFf1Biki3IPShehtX
1F1Q/7pn2COZH8g/497/b1t3sWtuuMlk9+HKQUYOKXHQuSP8yYFfTvdv37+ErXNk
u7dCjmn21HYdfp2nuFeKUWdy19SouJVUQHMD9ur06/4oQnc/nSMbsrY9gBQHTC5P
99UKFg29ZkM3fiNDecNAhvVMKdqOmq0NpQSHiB6F4+lT1ZvIiwNjeOvgGUpuuy9r
M2RYk61pv48b74JIxwIDAQABo1EwTzALBgNVHQ8EBAMCAYYwDwYDVR0TAQH/BAUw
AwEB/zAdBgNVHQ4EFgQUNQ/INmNe4qPs+TtmFc5RUuORmj0wEAYJKwYBBAGCNxUB
BAMCAQAwDQYJKoZIhvcNAQELBQADggEBAEBM+4eymYGQfp3FsLAmzYh7KzKNbrgh
cViXfa43FK8+5/ea4n32cZiZBKpDdHij40lhPnOMTZTg+XHEthYOU3gf1qKHLwI5
gSk8rxWYITD+KJAAjNHhy/peyP34EEY7onhCkRd0VQreUGdNZtGn//3ZwLWoo4rO
ZvUPQ82nK1d7Y0Zqqi5S2PTt4W2tKZB4SLrhI6qjiey1q5bAtEuiHZeeevJuQHHf
aPFlTc58Bd9TZaml8LGXBHAVRgOY1NK/VLSgWH1Sb9pWJmLU2NuJMW8c8CLC02Ic
Nc1MaRVUGpCY3useX8p3x8uOPUNpnJpY0CQ73xtAln41rYHHTnG6iBM=
-----END CERTIFICATE-----

SZAFIR ROOT CA2
================================================
SHA1 Fingerprint=E2:52:FA:95:3F:ED:DB:24:60:BD:6E:28:F3:9C:CC:CF:5E:B3:3F:DE
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            3e:8a:5d:07:ec:55:d2:32:d5:b7:e3:b6:5f:01:eb:2d:dc:e4:d6:e4
    Signature Algorithm: sha256WithRSAEncryption
        Issuer: C=PL, O=Krajowa Izba Rozliczeniowa S.A., CN=SZAFIR ROOT CA2
        Validity
            Not Before: Oct 19 07:43:30 2015 GMT
            Not After : Oct 19 07:43:30 2035 GMT
        Subject: C=PL, O=Krajowa Izba Rozliczeniowa S.A., CN=SZAFIR ROOT CA2
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (2048 bit)
                Modulus:
                    00:b7:bc:3e:50:a8:4b:cd:40:b5:ce:61:e7:96:ca:
                    b4:a1:da:0c:22:b0:fa:b5:7b:76:00:77:8c:0b:cf:
                    7d:a8:86:cc:26:51:e4:20:3d:85:0c:d6:58:e3:e7:
                    f4:2a:18:9d:da:d1:ae:26:ee:eb:53:dc:f4:90:d6:
                    13:4a:0c:90:3c:c3:f4:da:d2:8e:0d:92:3a:dc:b1:
                    b1:ff:38:de:c3:ba:2d:5f:80:b9:02:bd:4a:9d:1b:
                    0f:b4:c3:c2:c1:67:03:dd:dc:1b:9c:3d:b3:b0:de:
                    00:1e:a8:34:47:bb:9a:eb:fe:0b:14:bd:36:84:da:
                    0d:20:bf:fa:5b:cb:a9:16:20:ad:39:60:ee:2f:75:
                    b6:e7:97:9c:f9:3e:fd:7e:4d:6f:4d:2f:ef:88:0d:
                    6a:fa:dd:f1:3d:6e:20:a5:a0:12:b4:4d:70:b9:ce:
                    d7:72:3b:89:93:a7:80:84:1c:27:49:72:49:b5:ff:
                    3b:95:9e:c1:cc:c8:01:ec:e8:0e:8a:0a:96:e7:b3:
                    a6:87:e5:d6:f9:05:2b:0d:97:40:70:3c:ba:ac:75:
                    5a:9c:d5:4d:9d:02:0a:d2:4b:9b:66:4b:46:07:17:
                    65:ad:9f:6c:88:00:dc:22:89:e0:e1:64:d4:67:bc:
                    31:79:61:3c:bb:ca:41:cd:5c:6a:00:c8:3c:38:8e:
                    58:af
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Subject Key Identifier: 
                2E:16:A9:4A:18:B5:CB:CC:F5:6F:50:F3:23:5F:F8:5D:E7:AC:F0:C8
    Signature Algorithm: sha256WithRSAEncryption
         b5:73:f8:03:dc:59:5b:1d:76:e9:a3:2a:7b:90:28:b2:4d:c0:
         33:4f:aa:9a:b1:d4:b8:e4:27:ff:a9:96:99:ce:46:e0:6d:7c:
         4c:a2:38:a4:06:70:f0:f4:41:11:ec:3f:47:8d:3f:72:87:f9:
         3b:fd:a4:6f:2b:53:00:e0:ff:39:b9:6a:07:0e:eb:1d:1c:f6:
         a2:72:90:cb:82:3d:11:82:8b:d2:bb:9f:2a:af:21:e6:63:86:
         9d:79:19:ef:f7:bb:0c:35:90:c3:8a:ed:4f:0f:f5:cc:12:d9:
         a4:3e:bb:a0:fc:20:95:5f:4f:26:2f:11:23:83:4e:75:07:0f:
         bf:9b:d1:b4:1d:e9:10:04:fe:ca:60:8f:a2:4c:b8:ad:cf:e1:
         90:0f:cd:ae:0a:c7:5d:7b:b7:50:d2:d4:61:fa:d5:15:db:d7:
         9f:87:51:54:eb:a5:e3:eb:c9:85:a0:25:20:37:fb:8e:ce:0c:
         34:84:e1:3c:81:b2:77:4e:43:a5:88:5f:86:67:a1:3d:e6:b4:
         5c:61:b6:3e:db:fe:b7:28:c5:a2:07:ae:b5:ca:ca:8d:2a:12:
         ef:97:ed:c2:30:a4:c9:2a:7a:fb:f3:4d:23:1b:99:33:34:a0:
         2e:f5:a9:0b:3f:d4:5d:e1:cf:84:9f:e2:19:c2:5f:8a:d6:20:
         1e:e3:73:b7
-----BEGIN CERTIFICATE-----
MIIDcjCCAlqgAwIBAgIUPopdB+xV0jLVt+O2XwHrLdzk1uQwDQYJKoZIhvcNAQEL
BQAwUTELMAkGA1UEBhMCUEwxKDAmBgNVBAoMH0tyYWpvd2EgSXpiYSBSb3psaWN6
ZW5pb3dhIFMuQS4xGDAWBgNVBAMMD1NaQUZJUiBST09UIENBMjAeFw0xNTEwMTkw
NzQzMzBaFw0zNTEwMTkwNzQzMzBaMFExCzAJBgNVBAYTAlBMMSgwJgYDVQQKDB9L
cmFqb3dhIEl6YmEgUm96bGljemVuaW93YSBTLkEuMRgwFgYDVQQDDA9TWkFGSVIg
Uk9PVCBDQTIwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQC3vD5QqEvN
QLXOYeeWyrSh2gwisPq1e3YAd4wLz32ohswmUeQgPYUM1ljj5/QqGJ3a0a4m7utT
3PSQ1hNKDJA8w/Ta0o4NkjrcsbH/ON7Dui1fgLkCvUqdGw+0w8LBZwPd3BucPbOw
3gAeqDRHu5rr/gsUvTaE2g0gv/pby6kWIK05YO4vdbbnl5z5Pv1+TW9NL++IDWr6
3fE9biCloBK0TXC5ztdyO4mTp4CEHCdJckm1/zuVnsHMyAHs6A6KCpbns6aH5db5
BSsNl0BwPLqsdVqc1U2dAgrSS5tmS0YHF2Wtn2yIANwiieDhZNRnvDF5YTy7ykHN
XGoAyDw4jlivAgMBAAGjQjBAMA8GA1UdEwEB/wQFMAMBAf8wDgYDVR0PAQH/BAQD
AgEGMB0GA1UdDgQWBBQuFqlKGLXLzPVvUPMjX/hd56zwyDANBgkqhkiG9w0BAQsF
AAOCAQEAtXP4A9xZWx126aMqe5Aosk3AM0+qmrHUuOQn/6mWmc5G4G18TKI4pAZw
8PRBEew/R40/cof5O/2kbytTAOD/OblqBw7rHRz2onKQy4I9EYKL0rufKq8h5mOG
nXkZ7/e7DDWQw4rtTw/1zBLZpD67oPwglV9PJi8RI4NOdQcPv5vRtB3pEAT+ymCP
oky4rc/hkA/NrgrHXXu3UNLUYfrVFdvXn4dRVOul4+vJhaAlIDf7js4MNIThPIGy
d05DpYhfhmehPea0XGG2Ptv+tyjFogeutcrKjSoS75ftwjCkySp6+/NNIxuZMzSg
LvWpCz/UXeHPhJ/iGcJfitYgHuNztw==
-----END CERTIFICATE-----

Certum Trusted Network CA 2
================================================
SHA1 Fingerprint=D3:DD:48:3E:2B:BF:4C:05:E8:AF:10:F5:FA:76:26:CF:D3:DC:30:92
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            21:d6:d0:4a:4f:25:0f:c9:32:37:fc:aa:5e:12:8d:e9
    Signature Algorithm: sha512WithRSAEncryption
        Issuer: C=PL, O=Unizeto Technologies S.A., OU=Certum Certification Authority, CN=Certum Trusted Network CA 2
        Validity
            Not Before: Oct  6 08:39:56 2011 GMT
            Not After : Oct  6 08:39:56 2046 GMT
        Subject: C=PL, O=Unizeto Technologies S.A., OU=Certum Certification Authority, CN=Certum Trusted Network CA 2
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (4096 bit)
                Modulus:
                    00:bd:f9:78:f8:e6:d5:80:0c:64:9d:86:1b:96:64:
                    67:3f:22:3a:1e:75:01:7d:ef:fb:5c:67:8c:c9:cc:
                    5c:6b:a9:91:e6:b9:42:e5:20:4b:9b:da:9b:7b:b9:
                    99:5d:d9:9b:80:4b:d7:84:40:2b:27:d3:e8:ba:30:
                    bb:3e:09:1a:a7:49:95:ef:2b:40:24:c2:97:c7:a7:
                    ee:9b:25:ef:a8:0a:00:97:85:5a:aa:9d:dc:29:c9:
                    e2:35:07:eb:70:4d:4a:d6:c1:b3:56:b8:a1:41:38:
                    9b:d1:fb:31:7f:8f:e0:5f:e1:b1:3f:0f:8e:16:49:
                    60:d7:06:8d:18:f9:aa:26:10:ab:2a:d3:d0:d1:67:
                    8d:1b:46:be:47:30:d5:2e:72:d1:c5:63:da:e7:63:
                    79:44:7e:4b:63:24:89:86:2e:34:3f:29:4c:52:8b:
                    2a:a7:c0:e2:91:28:89:b9:c0:5b:f9:1d:d9:e7:27:
                    ad:ff:9a:02:97:c1:c6:50:92:9b:02:2c:bd:a9:b9:
                    34:59:0a:bf:84:4a:ff:df:fe:b3:9f:eb:d9:9e:e0:
                    98:23:ec:a6:6b:77:16:2a:db:cc:ad:3b:1c:a4:87:
                    dc:46:73:5e:19:62:68:45:57:e4:90:82:42:bb:42:
                    d6:f0:61:e0:c1:a3:3d:66:a3:5d:f4:18:ee:88:c9:
                    8d:17:45:29:99:32:75:02:31:ee:29:26:c8:6b:02:
                    e6:b5:62:45:7f:37:15:5a:23:68:89:d4:3e:de:4e:
                    27:b0:f0:40:0c:bc:4d:17:cb:4d:a2:b3:1e:d0:06:
                    5a:dd:f6:93:cf:57:75:99:f5:fa:86:1a:67:78:b3:
                    bf:96:fe:34:dc:bd:e7:52:56:e5:b3:e5:75:7b:d7:
                    41:91:05:dc:5d:69:e3:95:0d:43:b9:fc:83:96:39:
                    95:7b:6c:80:5a:4f:13:72:c6:d7:7d:29:7a:44:ba:
                    52:a4:2a:d5:41:46:09:20:fe:22:a0:b6:5b:30:8d:
                    bc:89:0c:d5:d7:70:f8:87:52:fd:da:ef:ac:51:2e:
                    07:b3:4e:fe:d0:09:da:70:ef:98:fa:56:e6:6d:db:
                    b5:57:4b:dc:e5:2c:25:15:c8:9e:2e:78:4e:f8:da:
                    9c:9e:86:2c:ca:57:f3:1a:e5:c8:92:8b:1a:82:96:
                    7a:c3:bc:50:12:69:d8:0e:5a:46:8b:3a:eb:26:fa:
                    23:c9:b6:b0:81:be:42:00:a4:f8:d6:fe:30:2e:c7:
                    d2:46:f6:e5:8e:75:fd:f2:cc:b9:d0:87:5b:cc:06:
                    10:60:bb:83:35:b7:5e:67:de:47:ec:99:48:f1:a4:
                    a1:15:fe:ad:8c:62:8e:39:55:4f:39:16:b9:b1:63:
                    9d:ff:b7
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Subject Key Identifier: 
                B6:A1:54:39:02:C3:A0:3F:8E:8A:BC:FA:D4:F8:1C:A6:D1:3A:0E:FD
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
    Signature Algorithm: sha512WithRSAEncryption
         71:a5:0e:ce:e4:e9:bf:3f:38:d5:89:5a:c4:02:61:fb:4c:c5:
         14:17:2d:8b:4f:53:6b:10:17:fc:65:84:c7:10:49:90:de:db:
         c7:26:93:88:26:6f:70:d6:02:5e:39:a0:f7:8f:ab:96:b5:a5:
         13:5c:81:14:6d:0e:81:82:11:1b:8a:4e:c6:4f:a5:dd:62:1e:
         44:df:09:59:f4:5b:77:0b:37:e9:8b:20:c6:f8:0a:4e:2e:58:
         1c:eb:33:d0:cf:86:60:c9:da:fb:80:2f:9e:4c:60:84:78:3d:
         21:64:d6:fb:41:1f:18:0f:e7:c9:75:71:bd:bd:5c:de:34:87:
         3e:41:b0:0e:f6:b9:d6:3f:09:13:96:14:2f:de:9a:1d:5a:b9:
         56:ce:35:3a:b0:5f:70:4d:5e:e3:29:f1:23:28:72:59:b6:ab:
         c2:8c:66:26:1c:77:2c:26:76:35:8b:28:a7:69:a0:f9:3b:f5:
         23:dd:85:10:74:c9:90:03:56:91:e7:af:ba:47:d4:12:97:11:
         22:e3:a2:49:94:6c:e7:b7:94:4b:ba:2d:a4:da:33:8b:4c:a6:
         44:ff:5a:3c:c6:1d:64:d8:b5:31:e4:a6:3c:7a:a8:57:0b:db:
         ed:61:1a:cb:f1:ce:73:77:63:a4:87:6f:4c:51:38:d6:e4:5f:
         c7:9f:b6:81:2a:e4:85:48:79:58:5e:3b:f8:db:02:82:67:c1:
         39:db:c3:74:4b:3d:36:1e:f9:29:93:88:68:5b:a8:44:19:21:
         f0:a7:e8:81:0d:2c:e8:93:36:b4:37:b2:ca:b0:1b:26:7a:9a:
         25:1f:9a:9a:80:9e:4b:2a:3f:fb:a3:9a:fe:73:32:71:c2:9e:
         c6:72:e1:8a:68:27:f1:e4:0f:b4:c4:4c:a5:61:93:f8:97:10:
         07:2a:30:25:a9:b9:c8:71:b8:ef:68:cc:2d:7e:f5:e0:7e:0f:
         82:a8:6f:b6:ba:6c:83:43:77:cd:8a:92:17:a1:9e:5b:78:16:
         3d:45:e2:33:72:dd:e1:66:ca:99:d3:c9:c5:26:fd:0d:68:04:
         46:ae:b6:d9:9b:8c:be:19:be:b1:c6:f2:19:e3:5c:02:ca:2c:
         d8:6f:4a:07:d9:c9:35:da:40:75:f2:c4:a7:19:6f:9e:42:10:
         98:75:e6:95:8b:60:bc:ed:c5:12:d7:8a:ce:d5:98:5c:56:96:
         03:c5:ee:77:06:35:ff:cf:e4:ee:3f:13:61:ee:db:da:2d:85:
         f0:cd:ae:9d:b2:18:09:45:c3:92:a1:72:17:fc:47:b6:a0:0b:
         2c:f1:c4:de:43:68:08:6a:5f:3b:f0:76:63:fb:cc:06:2c:a6:
         c6:e2:0e:b5:b9:be:24:8f
-----BEGIN CERTIFICATE-----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-----END CERTIFICATE-----

Hellenic Academic and Research Institutions RootCA 2015
=======================================================
SHA1 Fingerprint=01:0C:06:95:A6:98:19:14:FF:BF:5F:C6:B0:B6:95:EA:29:E9:12:A6
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 0 (0x0)
    Signature Algorithm: sha256WithRSAEncryption
        Issuer: C=GR, L=Athens, O=Hellenic Academic and Research Institutions Cert. Authority, CN=Hellenic Academic and Research Institutions RootCA 2015
        Validity
            Not Before: Jul  7 10:11:21 2015 GMT
            Not After : Jun 30 10:11:21 2040 GMT
        Subject: C=GR, L=Athens, O=Hellenic Academic and Research Institutions Cert. Authority, CN=Hellenic Academic and Research Institutions RootCA 2015
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (4096 bit)
                Modulus:
                    00:c2:f8:a9:3f:1b:89:fc:3c:3c:04:5d:3d:90:36:
                    b0:91:3a:79:3c:66:5a:ef:6d:39:01:49:1a:b4:b7:
                    cf:7f:4d:23:53:b7:90:00:e3:13:2a:28:a6:31:f1:
                    91:00:e3:28:ec:ae:21:41:ce:1f:da:fd:7d:12:5b:
                    01:83:0f:b9:b0:5f:99:e1:f2:12:83:80:4d:06:3e:
                    df:ac:af:e7:a1:88:6b:31:af:f0:8b:d0:18:33:b8:
                    db:45:6a:34:f4:02:80:24:28:0a:02:15:95:5e:76:
                    2a:0d:99:3a:14:5b:f6:cb:cb:53:bc:13:4d:01:88:
                    37:94:25:1b:42:bc:22:d8:8e:a3:96:5e:3a:d9:32:
                    db:3e:e8:f0:10:65:ed:74:e1:2f:a7:7c:af:27:34:
                    bb:29:7d:9b:b6:cf:09:c8:e5:d3:0a:fc:88:65:65:
                    74:0a:dc:73:1c:5c:cd:40:b1:1c:d4:b6:84:8c:4c:
                    50:cf:68:8e:a8:59:ae:c2:27:4e:82:a2:35:dd:14:
                    f4:1f:ff:b2:77:d5:87:2f:aa:6e:7d:24:27:e7:c6:
                    cb:26:e6:e5:fe:67:07:63:d8:45:0d:dd:3a:59:65:
                    39:58:7a:92:99:72:3d:9c:84:5e:88:21:b8:d5:f4:
                    2c:fc:d9:70:52:4f:78:b8:bd:3c:2b:8b:95:98:f5:
                    b3:d1:68:cf:20:14:7e:4c:5c:5f:e7:8b:e5:f5:35:
                    81:19:37:d7:11:08:b7:66:be:d3:4a:ce:83:57:00:
                    3a:c3:81:f8:17:cb:92:36:5d:d1:a3:d8:75:1b:e1:
                    8b:27:ea:7a:48:41:fd:45:19:06:ad:27:99:4e:c1:
                    70:47:dd:b5:9f:81:53:12:e5:b1:8c:48:5d:31:43:
                    17:e3:8c:c6:7a:63:96:4b:29:30:4e:84:4e:62:19:
                    5e:3c:ce:97:90:a5:7f:01:eb:9d:e0:f8:8b:89:dd:
                    25:98:3d:92:b6:7e:ef:d9:f1:51:51:7d:2d:26:c8:
                    69:59:61:e0:ac:6a:b8:2a:36:11:04:7a:50:bd:32:
                    84:be:2f:dc:72:d5:d7:1d:16:47:e4:47:66:20:3f:
                    f4:96:c5:af:8e:01:7a:a5:0f:7a:64:f5:0d:18:87:
                    d9:ae:88:d5:fa:84:c1:3a:c0:69:28:2d:f2:0d:68:
                    51:aa:e3:a5:77:c6:a4:90:0e:a1:37:8b:31:23:47:
                    c1:09:08:eb:6e:f7:78:9b:d7:82:fc:84:20:99:49:
                    19:b6:12:46:b1:fb:45:55:16:a9:a3:65:ac:9c:07:
                    0f:ea:6b:dc:1f:2e:06:72:ec:86:88:12:e4:2d:db:
                    5f:05:2f:e4:f0:03:d3:26:33:e7:80:c2:cd:42:a1:
                    17:34:0b
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Subject Key Identifier: 
                71:15:67:C8:C8:C9:BD:75:5D:72:D0:38:18:6A:9D:F3:71:24:54:0B
    Signature Algorithm: sha256WithRSAEncryption
         75:bb:6d:54:4b:aa:10:58:46:34:f2:62:d7:16:36:5d:08:5e:
         d5:6c:c8:87:bd:b4:2e:46:f2:31:f8:7c:ea:42:b5:93:16:55:
         dc:a1:0c:12:a0:da:61:7e:0f:58:58:73:64:72:c7:e8:45:8e:
         dc:a9:f2:26:3f:c6:79:8c:b1:53:08:33:81:b0:56:13:be:e6:
         51:5c:d8:9b:0a:4f:4b:9c:56:53:02:e9:4f:f6:0d:60:ea:4d:
         42:55:e8:7c:1b:21:21:d3:1b:3a:cc:77:f2:b8:90:f1:68:c7:
         f9:5a:fe:fa:2d:f4:bf:c9:f5:45:1b:ce:38:10:2a:37:8a:79:
         a3:b4:e3:09:6c:85:86:93:ff:89:96:27:78:81:8f:67:e3:46:
         74:54:8e:d9:0d:69:e2:4a:f4:4d:74:03:ff:b2:77:ed:95:67:
         97:e4:b1:c5:ab:bf:6a:23:e8:d4:94:e2:44:28:62:c4:4b:e2:
         f0:d8:e2:29:6b:1a:70:7e:24:61:93:7b:4f:03:32:25:0d:45:
         24:2b:96:b4:46:6a:bf:4a:0b:f7:9a:8f:c1:ac:1a:c5:67:f3:
         6f:34:d2:fa:73:63:8c:ef:16:b0:a8:a4:46:2a:f8:eb:12:ec:
         72:b4:ef:f8:2b:7e:8c:52:c0:8b:84:54:f9:2f:3e:e3:55:a8:
         dc:66:b1:d9:e1:5f:d8:b3:8c:59:34:59:a4:ab:4f:6c:bb:1f:
         18:db:75:ab:d8:cb:92:cd:94:38:61:0e:07:06:1f:4b:46:10:
         f1:15:be:8d:85:5c:3b:4a:2b:81:79:0f:b4:69:9f:49:50:97:
         4d:f7:0e:56:5d:c0:95:6a:c2:36:c3:1b:68:c9:f5:2a:dc:47:
         9a:be:b2:ce:c5:25:e8:fa:03:b9:da:f9:16:6e:91:84:f5:1c:
         28:c8:fc:26:cc:d7:1c:90:56:a7:5f:6f:3a:04:bc:cd:78:89:
         0b:8e:0f:2f:a3:aa:4f:a2:1b:12:3d:16:08:40:0f:f1:46:4c:
         d7:aa:7b:08:c1:0a:f5:6d:27:de:02:8f:ca:c3:b5:2b:ca:e9:
         eb:c8:21:53:38:a5:cc:3b:d8:77:37:30:a2:4f:d9:6f:d1:f2:
         40:ad:41:7a:17:c5:d6:4a:35:89:b7:41:d5:7c:86:7f:55:4d:
         83:4a:a5:73:20:c0:3a:af:90:f1:9a:24:8e:d9:8e:71:ca:7b:
         b8:86:da:b2:8f:99:3e:1d:13:0d:12:11:ee:d4:ab:f0:e9:15:
         76:02:e4:e0:df:aa:20:1e:5b:61:85:64:40:a9:90:97:0d:ad:
         53:d2:5a:1d:87:6a:00:97:65:62:b4:be:6f:6a:a7:f5:2c:42:
         ed:32:ad:b6:21:9e:be:bc
-----BEGIN CERTIFICATE-----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-----END CERTIFICATE-----

Hellenic Academic and Research Institutions ECC RootCA 2015
===========================================================
SHA1 Fingerprint=9F:F1:71:8D:92:D5:9A:F3:7D:74:97:B4:BC:6F:84:68:0B:BA:B6:66
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 0 (0x0)
    Signature Algorithm: ecdsa-with-SHA256
        Issuer: C=GR, L=Athens, O=Hellenic Academic and Research Institutions Cert. Authority, CN=Hellenic Academic and Research Institutions ECC RootCA 2015
        Validity
            Not Before: Jul  7 10:37:12 2015 GMT
            Not After : Jun 30 10:37:12 2040 GMT
        Subject: C=GR, L=Athens, O=Hellenic Academic and Research Institutions Cert. Authority, CN=Hellenic Academic and Research Institutions ECC RootCA 2015
        Subject Public Key Info:
            Public Key Algorithm: id-ecPublicKey
                Public-Key: (384 bit)
                pub: 
                    04:92:a0:41:e8:4b:82:84:5c:e2:f8:31:11:99:86:
                    64:4e:09:25:2f:9d:41:2f:0a:ae:35:4f:74:95:b2:
                    51:64:6b:8d:6b:e6:3f:70:95:f0:05:44:47:a6:72:
                    38:50:76:95:02:5a:8e:ae:28:9e:f9:2d:4e:99:ef:
                    2c:48:6f:4c:25:29:e8:d1:71:5b:df:1d:c1:75:37:
                    b4:d7:fa:7b:7a:42:9c:6a:0a:56:5a:7c:69:0b:aa:
                    80:09:24:6c:7e:c1:46
                ASN1 OID: secp384r1
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Subject Key Identifier: 
                B4:22:0B:82:99:24:01:0E:9C:BB:E4:0E:FD:BF:FB:97:20:93:99:2A
    Signature Algorithm: ecdsa-with-SHA256
         30:64:02:30:67:ce:16:62:38:a2:ac:62:45:a7:a9:95:24:c0:
         1a:27:9c:32:3b:c0:c0:d5:ba:a9:e7:f8:04:43:53:85:ee:52:
         21:de:9d:f5:25:83:3e:9e:58:4b:2f:d7:67:13:0e:21:02:30:
         05:e1:75:01:de:68:ed:2a:1f:4d:4c:09:08:0d:ec:4b:ad:64:
         17:28:e7:75:ce:45:65:72:21:17:cb:22:41:0e:8c:13:98:38:
         9a:54:6d:9b:ca:e2:7c:ea:02:58:22:91
-----BEGIN CERTIFICATE-----
MIICwzCCAkqgAwIBAgIBADAKBggqhkjOPQQDAjCBqjELMAkGA1UEBhMCR1IxDzAN
BgNVBAcTBkF0aGVuczFEMEIGA1UEChM7SGVsbGVuaWMgQWNhZGVtaWMgYW5kIFJl
c2VhcmNoIEluc3RpdHV0aW9ucyBDZXJ0LiBBdXRob3JpdHkxRDBCBgNVBAMTO0hl
bGxlbmljIEFjYWRlbWljIGFuZCBSZXNlYXJjaCBJbnN0aXR1dGlvbnMgRUNDIFJv
b3RDQSAyMDE1MB4XDTE1MDcwNzEwMzcxMloXDTQwMDYzMDEwMzcxMlowgaoxCzAJ
BgNVBAYTAkdSMQ8wDQYDVQQHEwZBdGhlbnMxRDBCBgNVBAoTO0hlbGxlbmljIEFj
YWRlbWljIGFuZCBSZXNlYXJjaCBJbnN0aXR1dGlvbnMgQ2VydC4gQXV0aG9yaXR5
MUQwQgYDVQQDEztIZWxsZW5pYyBBY2FkZW1pYyBhbmQgUmVzZWFyY2ggSW5zdGl0
dXRpb25zIEVDQyBSb290Q0EgMjAxNTB2MBAGByqGSM49AgEGBSuBBAAiA2IABJKg
QehLgoRc4vgxEZmGZE4JJS+dQS8KrjVPdJWyUWRrjWvmP3CV8AVER6ZyOFB2lQJa
jq4onvktTpnvLEhvTCUp6NFxW98dwXU3tNf6e3pCnGoKVlp8aQuqgAkkbH7BRqNC
MEAwDwYDVR0TAQH/BAUwAwEB/zAOBgNVHQ8BAf8EBAMCAQYwHQYDVR0OBBYEFLQi
C4KZJAEOnLvkDv2/+5cgk5kqMAoGCCqGSM49BAMCA2cAMGQCMGfOFmI4oqxiRaep
lSTAGiecMjvAwNW6qef4BENThe5SId6d9SWDPp5YSy/XZxMOIQIwBeF1Ad5o7Sof
TUwJCA3sS61kFyjndc5FZXIhF8siQQ6ME5g4mlRtm8rifOoCWCKR
-----END CERTIFICATE-----

ISRG Root X1
=================================================
SHA1 Fingerprint=CA:BD:2A:79:A1:07:6A:31:F2:1D:25:36:35:CB:03:9D:43:29:A5:E8
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            82:10:cf:b0:d2:40:e3:59:44:63:e0:bb:63:82:8b:00
    Signature Algorithm: sha256WithRSAEncryption
        Issuer: C=US, O=Internet Security Research Group, CN=ISRG Root X1
        Validity
            Not Before: Jun  4 11:04:38 2015 GMT
            Not After : Jun  4 11:04:38 2035 GMT
        Subject: C=US, O=Internet Security Research Group, CN=ISRG Root X1
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (4096 bit)
                Modulus:
                    00:ad:e8:24:73:f4:14:37:f3:9b:9e:2b:57:28:1c:
                    87:be:dc:b7:df:38:90:8c:6e:3c:e6:57:a0:78:f7:
                    75:c2:a2:fe:f5:6a:6e:f6:00:4f:28:db:de:68:86:
                    6c:44:93:b6:b1:63:fd:14:12:6b:bf:1f:d2:ea:31:
                    9b:21:7e:d1:33:3c:ba:48:f5:dd:79:df:b3:b8:ff:
                    12:f1:21:9a:4b:c1:8a:86:71:69:4a:66:66:6c:8f:
                    7e:3c:70:bf:ad:29:22:06:f3:e4:c0:e6:80:ae:e2:
                    4b:8f:b7:99:7e:94:03:9f:d3:47:97:7c:99:48:23:
                    53:e8:38:ae:4f:0a:6f:83:2e:d1:49:57:8c:80:74:
                    b6:da:2f:d0:38:8d:7b:03:70:21:1b:75:f2:30:3c:
                    fa:8f:ae:dd:da:63:ab:eb:16:4f:c2:8e:11:4b:7e:
                    cf:0b:e8:ff:b5:77:2e:f4:b2:7b:4a:e0:4c:12:25:
                    0c:70:8d:03:29:a0:e1:53:24:ec:13:d9:ee:19:bf:
                    10:b3:4a:8c:3f:89:a3:61:51:de:ac:87:07:94:f4:
                    63:71:ec:2e:e2:6f:5b:98:81:e1:89:5c:34:79:6c:
                    76:ef:3b:90:62:79:e6:db:a4:9a:2f:26:c5:d0:10:
                    e1:0e:de:d9:10:8e:16:fb:b7:f7:a8:f7:c7:e5:02:
                    07:98:8f:36:08:95:e7:e2:37:96:0d:36:75:9e:fb:
                    0e:72:b1:1d:9b:bc:03:f9:49:05:d8:81:dd:05:b4:
                    2a:d6:41:e9:ac:01:76:95:0a:0f:d8:df:d5:bd:12:
                    1f:35:2f:28:17:6c:d2:98:c1:a8:09:64:77:6e:47:
                    37:ba:ce:ac:59:5e:68:9d:7f:72:d6:89:c5:06:41:
                    29:3e:59:3e:dd:26:f5:24:c9:11:a7:5a:a3:4c:40:
                    1f:46:a1:99:b5:a7:3a:51:6e:86:3b:9e:7d:72:a7:
                    12:05:78:59:ed:3e:51:78:15:0b:03:8f:8d:d0:2f:
                    05:b2:3e:7b:4a:1c:4b:73:05:12:fc:c6:ea:e0:50:
                    13:7c:43:93:74:b3:ca:74:e7:8e:1f:01:08:d0:30:
                    d4:5b:71:36:b4:07:ba:c1:30:30:5c:48:b7:82:3b:
                    98:a6:7d:60:8a:a2:a3:29:82:cc:ba:bd:83:04:1b:
                    a2:83:03:41:a1:d6:05:f1:1b:c2:b6:f0:a8:7c:86:
                    3b:46:a8:48:2a:88:dc:76:9a:76:bf:1f:6a:a5:3d:
                    19:8f:eb:38:f3:64:de:c8:2b:0d:0a:28:ff:f7:db:
                    e2:15:42:d4:22:d0:27:5d:e1:79:fe:18:e7:70:88:
                    ad:4e:e6:d9:8b:3a:c6:dd:27:51:6e:ff:bc:64:f5:
                    33:43:4f
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Subject Key Identifier: 
                79:B4:59:E6:7B:B6:E5:E4:01:73:80:08:88:C8:1A:58:F6:E9:9B:6E
    Signature Algorithm: sha256WithRSAEncryption
         55:1f:58:a9:bc:b2:a8:50:d0:0c:b1:d8:1a:69:20:27:29:08:
         ac:61:75:5c:8a:6e:f8:82:e5:69:2f:d5:f6:56:4b:b9:b8:73:
         10:59:d3:21:97:7e:e7:4c:71:fb:b2:d2:60:ad:39:a8:0b:ea:
         17:21:56:85:f1:50:0e:59:eb:ce:e0:59:e9:ba:c9:15:ef:86:
         9d:8f:84:80:f6:e4:e9:91:90:dc:17:9b:62:1b:45:f0:66:95:
         d2:7c:6f:c2:ea:3b:ef:1f:cf:cb:d6:ae:27:f1:a9:b0:c8:ae:
         fd:7d:7e:9a:fa:22:04:eb:ff:d9:7f:ea:91:2b:22:b1:17:0e:
         8f:f2:8a:34:5b:58:d8:fc:01:c9:54:b9:b8:26:cc:8a:88:33:
         89:4c:2d:84:3c:82:df:ee:96:57:05:ba:2c:bb:f7:c4:b7:c7:
         4e:3b:82:be:31:c8:22:73:73:92:d1:c2:80:a4:39:39:10:33:
         23:82:4c:3c:9f:86:b2:55:98:1d:be:29:86:8c:22:9b:9e:e2:
         6b:3b:57:3a:82:70:4d:dc:09:c7:89:cb:0a:07:4d:6c:e8:5d:
         8e:c9:ef:ce:ab:c7:bb:b5:2b:4e:45:d6:4a:d0:26:cc:e5:72:
         ca:08:6a:a5:95:e3:15:a1:f7:a4:ed:c9:2c:5f:a5:fb:ff:ac:
         28:02:2e:be:d7:7b:bb:e3:71:7b:90:16:d3:07:5e:46:53:7c:
         37:07:42:8c:d3:c4:96:9c:d5:99:b5:2a:e0:95:1a:80:48:ae:
         4c:39:07:ce:cc:47:a4:52:95:2b:ba:b8:fb:ad:d2:33:53:7d:
         e5:1d:4d:6d:d5:a1:b1:c7:42:6f:e6:40:27:35:5c:a3:28:b7:
         07:8d:e7:8d:33:90:e7:23:9f:fb:50:9c:79:6c:46:d5:b4:15:
         b3:96:6e:7e:9b:0c:96:3a:b8:52:2d:3f:d6:5b:e1:fb:08:c2:
         84:fe:24:a8:a3:89:da:ac:6a:e1:18:2a:b1:a8:43:61:5b:d3:
         1f:dc:3b:8d:76:f2:2d:e8:8d:75:df:17:33:6c:3d:53:fb:7b:
         cb:41:5f:ff:dc:a2:d0:61:38:e1:96:b8:ac:5d:8b:37:d7:75:
         d5:33:c0:99:11:ae:9d:41:c1:72:75:84:be:02:41:42:5f:67:
         24:48:94:d1:9b:27:be:07:3f:b9:b8:4f:81:74:51:e1:7a:b7:
         ed:9d:23:e2:be:e0:d5:28:04:13:3c:31:03:9e:dd:7a:6c:8f:
         c6:07:18:c6:7f:de:47:8e:3f:28:9e:04:06:cf:a5:54:34:77:
         bd:ec:89:9b:e9:17:43:df:5b:db:5f:fe:8e:1e:57:a2:cd:40:
         9d:7e:62:22:da:de:18:27
-----BEGIN CERTIFICATE-----
MIIFazCCA1OgAwIBAgIRAIIQz7DSQONZRGPgu2OCiwAwDQYJKoZIhvcNAQELBQAw
TzELMAkGA1UEBhMCVVMxKTAnBgNVBAoTIEludGVybmV0IFNlY3VyaXR5IFJlc2Vh
cmNoIEdyb3VwMRUwEwYDVQQDEwxJU1JHIFJvb3QgWDEwHhcNMTUwNjA0MTEwNDM4
WhcNMzUwNjA0MTEwNDM4WjBPMQswCQYDVQQGEwJVUzEpMCcGA1UEChMgSW50ZXJu
ZXQgU2VjdXJpdHkgUmVzZWFyY2ggR3JvdXAxFTATBgNVBAMTDElTUkcgUm9vdCBY
MTCCAiIwDQYJKoZIhvcNAQEBBQADggIPADCCAgoCggIBAK3oJHP0FDfzm54rVygc
h77ct984kIxuPOZXoHj3dcKi/vVqbvYATyjb3miGbESTtrFj/RQSa78f0uoxmyF+
0TM8ukj13Xnfs7j/EvEhmkvBioZxaUpmZmyPfjxwv60pIgbz5MDmgK7iS4+3mX6U
A5/TR5d8mUgjU+g4rk8Kb4Mu0UlXjIB0ttov0DiNewNwIRt18jA8+o+u3dpjq+sW
T8KOEUt+zwvo/7V3LvSye0rgTBIlDHCNAymg4VMk7BPZ7hm/ELNKjD+Jo2FR3qyH
B5T0Y3HsLuJvW5iB4YlcNHlsdu87kGJ55tukmi8mxdAQ4Q7e2RCOFvu396j3x+UC
B5iPNgiV5+I3lg02dZ77DnKxHZu8A/lJBdiB3QW0KtZB6awBdpUKD9jf1b0SHzUv
KBds0pjBqAlkd25HN7rOrFleaJ1/ctaJxQZBKT5ZPt0m9STJEadao0xAH0ahmbWn
OlFuhjuefXKnEgV4We0+UXgVCwOPjdAvBbI+e0ocS3MFEvzG6uBQE3xDk3SzynTn
jh8BCNAw1FtxNrQHusEwMFxIt4I7mKZ9YIqioymCzLq9gwQbooMDQaHWBfEbwrbw
qHyGO0aoSCqI3Haadr8faqU9GY/rOPNk3sgrDQoo//fb4hVC1CLQJ13hef4Y53CI
rU7m2Ys6xt0nUW7/vGT1M0NPAgMBAAGjQjBAMA4GA1UdDwEB/wQEAwIBBjAPBgNV
HRMBAf8EBTADAQH/MB0GA1UdDgQWBBR5tFnme7bl5AFzgAiIyBpY9umbbjANBgkq
hkiG9w0BAQsFAAOCAgEAVR9YqbyyqFDQDLHYGmkgJykIrGF1XIpu+ILlaS/V9lZL
ubhzEFnTIZd+50xx+7LSYK05qAvqFyFWhfFQDlnrzuBZ6brJFe+GnY+EgPbk6ZGQ
3BebYhtF8GaV0nxvwuo77x/Py9auJ/GpsMiu/X1+mvoiBOv/2X/qkSsisRcOj/KK
NFtY2PwByVS5uCbMiogziUwthDyC3+6WVwW6LLv3xLfHTjuCvjHIInNzktHCgKQ5
ORAzI4JMPJ+GslWYHb4phowim57iaztXOoJwTdwJx4nLCgdNbOhdjsnvzqvHu7Ur
TkXWStAmzOVyyghqpZXjFaH3pO3JLF+l+/+sKAIuvtd7u+Nxe5AW0wdeRlN8NwdC
jNPElpzVmbUq4JUagEiuTDkHzsxHpFKVK7q4+63SM1N95R1NbdWhscdCb+ZAJzVc
oyi3B43njTOQ5yOf+1CceWxG1bQVs5ZufpsMljq4Ui0/1lvh+wjChP4kqKOJ2qxq
4RgqsahDYVvTH9w7jXbyLeiNdd8XM2w9U/t7y0Ff/9yi0GE44Za4rF2LN9d11TPA
mRGunUHBcnWEvgJBQl9nJEiU0Zsnvgc/ubhPgXRR4Xq37Z0j4r7g1SgEEzwxA57d
emyPxgcYxn/eR44/KJ4EBs+lVDR3veyJm+kXQ99b21/+jh5Xos1AnX5iItreGCc=
-----END CERTIFICATE-----

AC RAIZ FNMT-RCM
=================================================
SHA1 Fingerprint=EC:50:35:07:B2:15:C4:95:62:19:E2:A8:9A:5B:42:99:2C:4C:2C:20
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            5d:93:8d:30:67:36:c8:06:1d:1a:c7:54:84:69:07
    Signature Algorithm: sha256WithRSAEncryption
        Issuer: C=ES, O=FNMT-RCM, OU=AC RAIZ FNMT-RCM
        Validity
            Not Before: Oct 29 15:59:56 2008 GMT
            Not After : Jan  1 00:00:00 2030 GMT
        Subject: C=ES, O=FNMT-RCM, OU=AC RAIZ FNMT-RCM
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (4096 bit)
                Modulus:
                    00:ba:71:80:7a:4c:86:6e:7f:c8:13:6d:c0:c6:7d:
                    1c:00:97:8f:2c:0c:23:bb:10:9a:40:a9:1a:b7:87:
                    88:f8:9b:56:6a:fb:e6:7b:8e:8b:92:8e:a7:25:5d:
                    59:11:db:36:2e:b7:51:17:1f:a9:08:1f:04:17:24:
                    58:aa:37:4a:18:df:e5:39:d4:57:fd:d7:c1:2c:91:
                    01:91:e2:22:d4:03:c0:58:fc:77:47:ec:8f:3e:74:
                    43:ba:ac:34:8d:4d:38:76:67:8e:b0:c8:6f:30:33:
                    58:71:5c:b4:f5:6b:6e:d4:01:50:b8:13:7e:6c:4a:
                    a3:49:d1:20:19:ee:bc:c0:29:18:65:a7:de:fe:ef:
                    dd:0a:90:21:e7:1a:67:92:42:10:98:5f:4f:30:bc:
                    3e:1c:45:b4:10:d7:68:40:14:c0:40:fa:e7:77:17:
                    7a:e6:0b:8f:65:5b:3c:d9:9a:52:db:b5:bd:9e:46:
                    cf:3d:eb:91:05:02:c0:96:b2:76:4c:4d:10:96:3b:
                    92:fa:9c:7f:0f:99:df:be:23:35:45:1e:02:5c:fe:
                    b5:a8:9b:99:25:da:5e:f3:22:c3:39:f5:e4:2a:2e:
                    d3:c6:1f:c4:6c:aa:c5:1c:6a:01:05:4a:2f:d2:c5:
                    c1:a8:34:26:5d:66:a5:d2:02:21:f9:18:b7:06:f5:
                    4e:99:6f:a8:ab:4c:51:e8:cf:50:18:c5:77:c8:39:
                    09:2c:49:92:32:99:a8:bb:17:17:79:b0:5a:c5:e6:
                    a3:c4:59:65:47:35:83:5e:a9:e8:35:0b:99:bb:e4:
                    cd:20:c6:9b:4a:06:39:b5:68:fc:22:ba:ee:55:8c:
                    2b:4e:ea:f3:b1:e3:fc:b6:99:9a:d5:42:fa:71:4d:
                    08:cf:87:1e:6a:71:7d:f9:d3:b4:e9:a5:71:81:7b:
                    c2:4e:47:96:a5:f6:76:85:a3:28:8f:e9:80:6e:81:
                    53:a5:6d:5f:b8:48:f9:c2:f9:36:a6:2e:49:ff:b8:
                    96:c2:8c:07:b3:9b:88:58:fc:eb:1b:1c:de:2d:70:
                    e2:97:92:30:a1:89:e3:bc:55:a8:27:d6:4b:ed:90:
                    ad:8b:fa:63:25:59:2d:a8:35:dd:ca:97:33:bc:e5:
                    cd:c7:9d:d1:ec:ef:5e:0e:4a:90:06:26:63:ad:b9:
                    d9:35:2d:07:ba:76:65:2c:ac:57:8f:7d:f4:07:94:
                    d7:81:02:96:5d:a3:07:49:d5:7a:d0:57:f9:1b:e7:
                    53:46:75:aa:b0:79:42:cb:68:71:08:e9:60:bd:39:
                    69:ce:f4:af:c3:56:40:c7:ad:52:a2:09:e4:6f:86:
                    47:8a:1f:eb:28:27:5d:83:20:af:04:c9:6c:56:9a:
                    8b:46:f5
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Subject Key Identifier: 
                F7:7D:C5:FD:C4:E8:9A:1B:77:64:A7:F5:1D:A0:CC:BF:87:60:9A:6D
            X509v3 Certificate Policies: 
                Policy: X509v3 Any Policy
                  CPS: http://www.cert.fnmt.es/dpcs/

    Signature Algorithm: sha256WithRSAEncryption
         07:90:4a:df:f3:23:4e:f0:c3:9c:51:65:9b:9c:22:a2:8a:0c:
         85:f3:73:29:6b:4d:fe:01:e2:a9:0c:63:01:bf:04:67:a5:9d:
         98:5f:fd:01:13:fa:ec:9a:62:e9:86:fe:b6:62:d2:6e:4c:94:
         fb:c0:75:45:7c:65:0c:f8:b2:37:cf:ac:0f:cf:8d:6f:f9:19:
         f7:8f:ec:1e:f2:70:9e:f0:ca:b8:ef:b7:ff:76:37:76:5b:f6:
         6e:88:f3:af:62:32:22:93:0d:3a:6a:8e:14:66:0c:2d:53:74:
         57:65:1e:d5:b2:dd:23:81:3b:a5:66:23:27:67:09:8f:e1:77:
         aa:43:cd:65:51:08:ed:51:58:fe:e6:39:f9:cb:47:84:a4:15:
         f1:76:bb:a4:ee:a4:3b:c4:5f:ef:b2:33:96:11:18:b7:c9:65:
         be:18:e1:a3:a4:dc:fa:18:f9:d3:bc:13:9b:39:7a:34:ba:d3:
         41:fb:fa:32:8a:2a:b7:2b:86:0b:69:83:38:be:cd:8a:2e:0b:
         70:ad:8d:26:92:ee:1e:f5:01:2b:0a:d9:d6:97:9b:6e:e0:a8:
         19:1c:3a:21:8b:0c:1e:40:ad:03:e7:dd:66:7e:f5:b9:20:0d:
         03:e8:96:f9:82:45:d4:39:e0:a0:00:5d:d7:98:e6:7d:9e:67:
         73:c3:9a:2a:f7:ab:8b:a1:3a:14:ef:34:bc:52:0e:89:98:9a:
         04:40:84:1d:7e:45:69:93:57:ce:eb:ce:f8:50:7c:4f:1c:6e:
         04:43:9b:f9:d6:3b:23:18:e9:ea:8e:d1:4d:46:8d:f1:3b:e4:
         6a:ca:ba:fb:23:b7:9b:fa:99:01:29:5a:58:5a:2d:e3:f9:d4:
         6d:0e:26:ad:c1:6e:34:bc:32:f8:0c:05:fa:65:a3:db:3b:37:
         83:22:e9:d6:dc:72:33:fd:5d:f2:20:bd:76:3c:23:da:28:f7:
         f9:1b:eb:59:64:d5:dc:5f:72:7e:20:fc:cd:89:b5:90:67:4d:
         62:7a:3f:4e:ad:1d:c3:39:fe:7a:f4:28:16:df:41:f6:48:80:
         05:d7:0f:51:79:ac:10:ab:d4:ec:03:66:e6:6a:b0:ba:31:92:
         42:40:6a:be:3a:d3:72:e1:6a:37:55:bc:ac:1d:95:b7:69:61:
         f2:43:91:74:e6:a0:d3:0a:24:46:a1:08:af:d6:da:45:19:96:
         d4:53:1d:5b:84:79:f0:c0:f7:47:ef:8b:8f:c5:06:ae:9d:4c:
         62:9d:ff:46:04:f8:d3:c9:b6:10:25:40:75:fe:16:aa:c9:4a:
         60:86:2f:ba:ef:30:77:e4:54:e2:b8:84:99:58:80:aa:13:8b:
         51:3a:4f:48:f6:8b:b6:b3
-----BEGIN CERTIFICATE-----
MIIFgzCCA2ugAwIBAgIPXZONMGc2yAYdGsdUhGkHMA0GCSqGSIb3DQEBCwUAMDsx
CzAJBgNVBAYTAkVTMREwDwYDVQQKDAhGTk1ULVJDTTEZMBcGA1UECwwQQUMgUkFJ
WiBGTk1ULVJDTTAeFw0wODEwMjkxNTU5NTZaFw0zMDAxMDEwMDAwMDBaMDsxCzAJ
BgNVBAYTAkVTMREwDwYDVQQKDAhGTk1ULVJDTTEZMBcGA1UECwwQQUMgUkFJWiBG
Tk1ULVJDTTCCAiIwDQYJKoZIhvcNAQEBBQADggIPADCCAgoCggIBALpxgHpMhm5/
yBNtwMZ9HACXjywMI7sQmkCpGreHiPibVmr75nuOi5KOpyVdWRHbNi63URcfqQgf
BBckWKo3Shjf5TnUV/3XwSyRAZHiItQDwFj8d0fsjz50Q7qsNI1NOHZnjrDIbzAz
WHFctPVrbtQBULgTfmxKo0nRIBnuvMApGGWn3v7v3QqQIecaZ5JCEJhfTzC8PhxF
tBDXaEAUwED653cXeuYLj2VbPNmaUtu1vZ5Gzz3rkQUCwJaydkxNEJY7kvqcfw+Z
374jNUUeAlz+taibmSXaXvMiwzn15Cou08YfxGyqxRxqAQVKL9LFwag0Jl1mpdIC
IfkYtwb1TplvqKtMUejPUBjFd8g5CSxJkjKZqLsXF3mwWsXmo8RZZUc1g16p6DUL
mbvkzSDGm0oGObVo/CK67lWMK07q87Hj/LaZmtVC+nFNCM+HHmpxffnTtOmlcYF7
wk5HlqX2doWjKI/pgG6BU6VtX7hI+cL5NqYuSf+4lsKMB7ObiFj86xsc3i1w4peS
MKGJ47xVqCfWS+2QrYv6YyVZLag13cqXM7zlzced0ezvXg5KkAYmY6252TUtB7p2
ZSysV4999AeU14ECll2jB0nVetBX+RvnU0Z1qrB5QstocQjpYL05ac70r8NWQMet
UqIJ5G+GR4of6ygnXYMgrwTJbFaai0b1AgMBAAGjgYMwgYAwDwYDVR0TAQH/BAUw
AwEB/zAOBgNVHQ8BAf8EBAMCAQYwHQYDVR0OBBYEFPd9xf3E6Jobd2Sn9R2gzL+H
YJptMD4GA1UdIAQ3MDUwMwYEVR0gADArMCkGCCsGAQUFBwIBFh1odHRwOi8vd3d3
LmNlcnQuZm5tdC5lcy9kcGNzLzANBgkqhkiG9w0BAQsFAAOCAgEAB5BK3/MjTvDD
nFFlm5wioooMhfNzKWtN/gHiqQxjAb8EZ6WdmF/9ARP67Jpi6Yb+tmLSbkyU+8B1
RXxlDPiyN8+sD8+Nb/kZ94/sHvJwnvDKuO+3/3Y3dlv2bojzr2IyIpMNOmqOFGYM
LVN0V2Ue1bLdI4E7pWYjJ2cJj+F3qkPNZVEI7VFY/uY5+ctHhKQV8Xa7pO6kO8Rf
77IzlhEYt8llvhjho6Tc+hj507wTmzl6NLrTQfv6MooqtyuGC2mDOL7Nii4LcK2N
JpLuHvUBKwrZ1pebbuCoGRw6IYsMHkCtA+fdZn71uSANA+iW+YJF1DngoABd15jm
fZ5nc8OaKveri6E6FO80vFIOiZiaBECEHX5FaZNXzuvO+FB8TxxuBEOb+dY7Ixjp
6o7RTUaN8Tvkasq6+yO3m/qZASlaWFot4/nUbQ4mrcFuNLwy+AwF+mWj2zs3gyLp
1txyM/1d8iC9djwj2ij3+RvrWWTV3F9yfiD8zYm1kGdNYno/Tq0dwzn+evQoFt9B
9kiABdcPUXmsEKvU7ANm5mqwujGSQkBqvjrTcuFqN1W8rB2Vt2lh8kORdOag0wok
RqEIr9baRRmW1FMdW4R58MD3R++Lj8UGrp1MYp3/RgT408m2ECVAdf4WqslKYIYv
uu8wd+RU4riEmViAqhOLUTpPSPaLtrM=
-----END CERTIFICATE-----

Amazon Root CA 1
================================================
SHA1 Fingerprint=8D:A7:F9:65:EC:5E:FC:37:91:0F:1C:6E:59:FD:C1:CC:6A:6E:DE:16
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            06:6c:9f:cf:99:bf:8c:0a:39:e2:f0:78:8a:43:e6:96:36:5b:ca
    Signature Algorithm: sha256WithRSAEncryption
        Issuer: C=US, O=Amazon, CN=Amazon Root CA 1
        Validity
            Not Before: May 26 00:00:00 2015 GMT
            Not After : Jan 17 00:00:00 2038 GMT
        Subject: C=US, O=Amazon, CN=Amazon Root CA 1
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (2048 bit)
                Modulus:
                    00:b2:78:80:71:ca:78:d5:e3:71:af:47:80:50:74:
                    7d:6e:d8:d7:88:76:f4:99:68:f7:58:21:60:f9:74:
                    84:01:2f:ac:02:2d:86:d3:a0:43:7a:4e:b2:a4:d0:
                    36:ba:01:be:8d:db:48:c8:07:17:36:4c:f4:ee:88:
                    23:c7:3e:eb:37:f5:b5:19:f8:49:68:b0:de:d7:b9:
                    76:38:1d:61:9e:a4:fe:82:36:a5:e5:4a:56:e4:45:
                    e1:f9:fd:b4:16:fa:74:da:9c:9b:35:39:2f:fa:b0:
                    20:50:06:6c:7a:d0:80:b2:a6:f9:af:ec:47:19:8f:
                    50:38:07:dc:a2:87:39:58:f8:ba:d5:a9:f9:48:67:
                    30:96:ee:94:78:5e:6f:89:a3:51:c0:30:86:66:a1:
                    45:66:ba:54:eb:a3:c3:91:f9:48:dc:ff:d1:e8:30:
                    2d:7d:2d:74:70:35:d7:88:24:f7:9e:c4:59:6e:bb:
                    73:87:17:f2:32:46:28:b8:43:fa:b7:1d:aa:ca:b4:
                    f2:9f:24:0e:2d:4b:f7:71:5c:5e:69:ff:ea:95:02:
                    cb:38:8a:ae:50:38:6f:db:fb:2d:62:1b:c5:c7:1e:
                    54:e1:77:e0:67:c8:0f:9c:87:23:d6:3f:40:20:7f:
                    20:80:c4:80:4c:3e:3b:24:26:8e:04:ae:6c:9a:c8:
                    aa:0d
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Key Usage: critical
                Digital Signature, Certificate Sign, CRL Sign
            X509v3 Subject Key Identifier: 
                84:18:CC:85:34:EC:BC:0C:94:94:2E:08:59:9C:C7:B2:10:4E:0A:08
    Signature Algorithm: sha256WithRSAEncryption
         98:f2:37:5a:41:90:a1:1a:c5:76:51:28:20:36:23:0e:ae:e6:
         28:bb:aa:f8:94:ae:48:a4:30:7f:1b:fc:24:8d:4b:b4:c8:a1:
         97:f6:b6:f1:7a:70:c8:53:93:cc:08:28:e3:98:25:cf:23:a4:
         f9:de:21:d3:7c:85:09:ad:4e:9a:75:3a:c2:0b:6a:89:78:76:
         44:47:18:65:6c:8d:41:8e:3b:7f:9a:cb:f4:b5:a7:50:d7:05:
         2c:37:e8:03:4b:ad:e9:61:a0:02:6e:f5:f2:f0:c5:b2:ed:5b:
         b7:dc:fa:94:5c:77:9e:13:a5:7f:52:ad:95:f2:f8:93:3b:de:
         8b:5c:5b:ca:5a:52:5b:60:af:14:f7:4b:ef:a3:fb:9f:40:95:
         6d:31:54:fc:42:d3:c7:46:1f:23:ad:d9:0f:48:70:9a:d9:75:
         78:71:d1:72:43:34:75:6e:57:59:c2:02:5c:26:60:29:cf:23:
         19:16:8e:88:43:a5:d4:e4:cb:08:fb:23:11:43:e8:43:29:72:
         62:a1:a9:5d:5e:08:d4:90:ae:b8:d8:ce:14:c2:d0:55:f2:86:
         f6:c4:93:43:77:66:61:c0:b9:e8:41:d7:97:78:60:03:6e:4a:
         72:ae:a5:d1:7d:ba:10:9e:86:6c:1b:8a:b9:59:33:f8:eb:c4:
         90:be:f1:b9
-----BEGIN CERTIFICATE-----
MIIDQTCCAimgAwIBAgITBmyfz5m/jAo54vB4ikPmljZbyjANBgkqhkiG9w0BAQsF
ADA5MQswCQYDVQQGEwJVUzEPMA0GA1UEChMGQW1hem9uMRkwFwYDVQQDExBBbWF6
b24gUm9vdCBDQSAxMB4XDTE1MDUyNjAwMDAwMFoXDTM4MDExNzAwMDAwMFowOTEL
MAkGA1UEBhMCVVMxDzANBgNVBAoTBkFtYXpvbjEZMBcGA1UEAxMQQW1hem9uIFJv
b3QgQ0EgMTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBALJ4gHHKeNXj
ca9HgFB0fW7Y14h29Jlo91ghYPl0hAEvrAIthtOgQ3pOsqTQNroBvo3bSMgHFzZM
9O6II8c+6zf1tRn4SWiw3te5djgdYZ6k/oI2peVKVuRF4fn9tBb6dNqcmzU5L/qw
IFAGbHrQgLKm+a/sRxmPUDgH3KKHOVj4utWp+UhnMJbulHheb4mjUcAwhmahRWa6
VOujw5H5SNz/0egwLX0tdHA114gk957EWW67c4cX8jJGKLhD+rcdqsq08p8kDi1L
93FcXmn/6pUCyziKrlA4b9v7LWIbxcceVOF34GfID5yHI9Y/QCB/IIDEgEw+OyQm
jgSubJrIqg0CAwEAAaNCMEAwDwYDVR0TAQH/BAUwAwEB/zAOBgNVHQ8BAf8EBAMC
AYYwHQYDVR0OBBYEFIQYzIU07LwMlJQuCFmcx7IQTgoIMA0GCSqGSIb3DQEBCwUA
A4IBAQCY8jdaQZChGsV2USggNiMOruYou6r4lK5IpDB/G/wkjUu0yKGX9rbxenDI
U5PMCCjjmCXPI6T53iHTfIUJrU6adTrCC2qJeHZERxhlbI1Bjjt/msv0tadQ1wUs
N+gDS63pYaACbvXy8MWy7Vu33PqUXHeeE6V/Uq2V8viTO96LXFvKWlJbYK8U90vv
o/ufQJVtMVT8QtPHRh8jrdkPSHCa2XV4cdFyQzR1bldZwgJcJmApzyMZFo6IQ6XU
5MsI+yMRQ+hDKXJioaldXgjUkK642M4UwtBV8ob2xJNDd2ZhwLnoQdeXeGADbkpy
rqXRfboQnoZsG4q5WTP468SQvvG5
-----END CERTIFICATE-----

Amazon Root CA 2
================================================
SHA1 Fingerprint=5A:8C:EF:45:D7:A6:98:59:76:7A:8C:8B:44:96:B5:78:CF:47:4B:1A
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            06:6c:9f:d2:96:35:86:9f:0a:0f:e5:86:78:f8:5b:26:bb:8a:37
    Signature Algorithm: sha384WithRSAEncryption
        Issuer: C=US, O=Amazon, CN=Amazon Root CA 2
        Validity
            Not Before: May 26 00:00:00 2015 GMT
            Not After : May 26 00:00:00 2040 GMT
        Subject: C=US, O=Amazon, CN=Amazon Root CA 2
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (4096 bit)
                Modulus:
                    00:ad:96:9f:2d:9c:4a:4c:4a:81:79:51:99:ec:8a:
                    cb:6b:60:51:13:bc:4d:6d:06:fc:b0:08:8d:dd:19:
                    10:6a:c7:26:0c:35:d8:c0:6f:20:84:e9:94:b1:9b:
                    85:03:c3:5b:db:4a:e8:c8:f8:90:76:d9:5b:4f:e3:
                    4c:e8:06:36:4d:cc:9a:ac:3d:0c:90:2b:92:d4:06:
                    19:60:ac:37:44:79:85:81:82:ad:5a:37:e0:0d:cc:
                    9d:a6:4c:52:76:ea:43:9d:b7:04:d1:50:f6:55:e0:
                    d5:d2:a6:49:85:e9:37:e9:ca:7e:ae:5c:95:4d:48:
                    9a:3f:ae:20:5a:6d:88:95:d9:34:b8:52:1a:43:90:
                    b0:bf:6c:05:b9:b6:78:b7:ea:d0:e4:3a:3c:12:53:
                    62:ff:4a:f2:7b:be:35:05:a9:12:34:e3:f3:64:74:
                    62:2c:3d:00:49:5a:28:fe:32:44:bb:87:dd:65:27:
                    02:71:3b:da:4a:f7:1f:da:cd:f7:21:55:90:4f:0f:
                    ec:ae:82:e1:9f:6b:d9:45:d3:bb:f0:5f:87:ed:3c:
                    2c:39:86:da:3f:de:ec:72:55:eb:79:a3:ad:db:dd:
                    7c:b0:ba:1c:ce:fc:de:4f:35:76:cf:0f:f8:78:1f:
                    6a:36:51:46:27:61:5b:e9:9e:cf:f0:a2:55:7d:7c:
                    25:8a:6f:2f:b4:c5:cf:84:2e:2b:fd:0d:51:10:6c:
                    fb:5f:1b:bc:1b:7e:c5:ae:3b:98:01:31:92:ff:0b:
                    57:f4:9a:b2:b9:57:e9:ab:ef:0d:76:d1:f0:ee:f4:
                    ce:86:a7:e0:6e:e9:b4:69:a1:df:69:f6:33:c6:69:
                    2e:97:13:9e:a5:87:b0:57:10:81:37:c9:53:b3:bb:
                    7f:f6:92:d1:9c:d0:18:f4:92:6e:da:83:4f:a6:63:
                    99:4c:a5:fb:5e:ef:21:64:7a:20:5f:6c:64:85:15:
                    cb:37:e9:62:0c:0b:2a:16:dc:01:2e:32:da:3e:4b:
                    f5:9e:3a:f6:17:40:94:ef:9e:91:08:86:fa:be:63:
                    a8:5a:33:ec:cb:74:43:95:f9:6c:69:52:36:c7:29:
                    6f:fc:55:03:5c:1f:fb:9f:bd:47:eb:e7:49:47:95:
                    0b:4e:89:22:09:49:e0:f5:61:1e:f1:bf:2e:8a:72:
                    6e:80:59:ff:57:3a:f9:75:32:a3:4e:5f:ec:ed:28:
                    62:d9:4d:73:f2:cc:81:17:60:ed:cd:eb:dc:db:a7:
                    ca:c5:7e:02:bd:f2:54:08:54:fd:b4:2d:09:2c:17:
                    54:4a:98:d1:54:e1:51:67:08:d2:ed:6e:7e:6f:3f:
                    d2:2d:81:59:29:66:cb:90:39:95:11:1e:74:27:fe:
                    dd:eb:af
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Key Usage: critical
                Digital Signature, Certificate Sign, CRL Sign
            X509v3 Subject Key Identifier: 
                B0:0C:F0:4C:30:F4:05:58:02:48:FD:33:E5:52:AF:4B:84:E3:66:52
    Signature Algorithm: sha384WithRSAEncryption
         aa:a8:80:8f:0e:78:a3:e0:a2:d4:cd:e6:f5:98:7a:3b:ea:00:
         03:b0:97:0e:93:bc:5a:a8:f6:2c:8c:72:87:a9:b1:fc:7f:73:
         fd:63:71:78:a5:87:59:cf:30:e1:0d:10:b2:13:5a:6d:82:f5:
         6a:e6:80:9f:a0:05:0b:68:e4:47:6b:c7:6a:df:b6:fd:77:32:
         72:e5:18:fa:09:f4:a0:93:2c:5d:d2:8c:75:85:76:65:90:0c:
         03:79:b7:31:23:63:ad:78:83:09:86:68:84:ca:ff:f9:cf:26:
         9a:92:79:e7:cd:4b:c5:e7:61:a7:17:cb:f3:a9:12:93:93:6b:
         a7:e8:2f:53:92:c4:60:58:b0:cc:02:51:18:5b:85:8d:62:59:
         63:b6:ad:b4:de:9a:fb:26:f7:00:27:c0:5d:55:37:74:99:c9:
         50:7f:e3:59:2e:44:e3:2c:25:ee:ec:4c:32:77:b4:9f:1a:e9:
         4b:5d:20:c5:da:fd:1c:87:16:c6:43:e8:d4:bb:26:9a:45:70:
         5e:a9:0b:37:53:e2:46:7b:27:fd:e0:46:f2:89:b7:cc:42:b6:
         cb:28:26:6e:d9:a5:c9:3a:c8:41:13:60:f7:50:8c:15:ae:b2:
         6d:1a:15:1a:57:78:e6:92:2a:d9:65:90:82:3f:6c:02:af:ae:
         12:3a:27:96:36:04:d7:1d:a2:80:63:a9:9b:f1:e5:ba:b4:7c:
         14:b0:4e:c9:b1:1f:74:5f:38:f6:51:ea:9b:fa:2c:a2:11:d4:
         a9:2d:27:1a:45:b1:af:b2:4e:71:0d:c0:58:46:d6:69:06:cb:
         53:cb:b3:fe:6b:41:cd:41:7e:7d:4c:0f:7c:72:79:7a:59:cd:
         5e:4a:0e:ac:9b:a9:98:73:79:7c:b4:f4:cc:b9:b8:07:0c:b2:
         74:5c:b8:c7:6f:88:a1:90:a7:f4:aa:f9:bf:67:3a:f4:1a:15:
         62:1e:b7:9f:be:3d:b1:29:af:67:a1:12:f2:58:10:19:53:03:
         30:1b:b8:1a:89:f6:9c:bd:97:03:8e:a3:09:f3:1d:8b:21:f1:
         b4:df:e4:1c:d1:9f:65:02:06:ea:5c:d6:13:b3:84:ef:a2:a5:
         5c:8c:77:29:a7:68:c0:6b:ae:40:d2:a8:b4:ea:cd:f0:8d:4b:
         38:9c:19:9a:1b:28:54:b8:89:90:ef:ca:75:81:3e:1e:f2:64:
         24:c7:18:af:4e:ff:47:9e:07:f6:35:65:a4:d3:0a:56:ff:f5:
         17:64:6c:ef:a8:22:25:49:93:b6:df:00:17:da:58:7e:5d:ee:
         c5:1b:b0:d1:d1:5f:21:10:c7:f9:f3:ba:02:0a:27:07:c5:f1:
         d6:c7:d3:e0:fb:09:60:6c
-----BEGIN CERTIFICATE-----
MIIFQTCCAymgAwIBAgITBmyf0pY1hp8KD+WGePhbJruKNzANBgkqhkiG9w0BAQwF
ADA5MQswCQYDVQQGEwJVUzEPMA0GA1UEChMGQW1hem9uMRkwFwYDVQQDExBBbWF6
b24gUm9vdCBDQSAyMB4XDTE1MDUyNjAwMDAwMFoXDTQwMDUyNjAwMDAwMFowOTEL
MAkGA1UEBhMCVVMxDzANBgNVBAoTBkFtYXpvbjEZMBcGA1UEAxMQQW1hem9uIFJv
b3QgQ0EgMjCCAiIwDQYJKoZIhvcNAQEBBQADggIPADCCAgoCggIBAK2Wny2cSkxK
gXlRmeyKy2tgURO8TW0G/LAIjd0ZEGrHJgw12MBvIITplLGbhQPDW9tK6Mj4kHbZ
W0/jTOgGNk3Mmqw9DJArktQGGWCsN0R5hYGCrVo34A3MnaZMUnbqQ523BNFQ9lXg
1dKmSYXpN+nKfq5clU1Imj+uIFptiJXZNLhSGkOQsL9sBbm2eLfq0OQ6PBJTYv9K
8nu+NQWpEjTj82R0Yiw9AElaKP4yRLuH3WUnAnE72kr3H9rN9yFVkE8P7K6C4Z9r
2UXTu/Bfh+08LDmG2j/e7HJV63mjrdvdfLC6HM783k81ds8P+HgfajZRRidhW+me
z/CiVX18JYpvL7TFz4QuK/0NURBs+18bvBt+xa47mAExkv8LV/SasrlX6avvDXbR
8O70zoan4G7ptGmh32n2M8ZpLpcTnqWHsFcQgTfJU7O7f/aS0ZzQGPSSbtqDT6Zj
mUyl+17vIWR6IF9sZIUVyzfpYgwLKhbcAS4y2j5L9Z469hdAlO+ekQiG+r5jqFoz
7Mt0Q5X5bGlSNscpb/xVA1wf+5+9R+vnSUeVC06JIglJ4PVhHvG/LopyboBZ/1c6
+XUyo05f7O0oYtlNc/LMgRdg7c3r3NunysV+Ar3yVAhU/bQtCSwXVEqY0VThUWcI
0u1ufm8/0i2BWSlmy5A5lREedCf+3euvAgMBAAGjQjBAMA8GA1UdEwEB/wQFMAMB
Af8wDgYDVR0PAQH/BAQDAgGGMB0GA1UdDgQWBBSwDPBMMPQFWAJI/TPlUq9LhONm
UjANBgkqhkiG9w0BAQwFAAOCAgEAqqiAjw54o+Ci1M3m9Zh6O+oAA7CXDpO8Wqj2
LIxyh6mx/H9z/WNxeKWHWc8w4Q0QshNabYL1auaAn6AFC2jkR2vHat+2/XcycuUY
+gn0oJMsXdKMdYV2ZZAMA3m3MSNjrXiDCYZohMr/+c8mmpJ5581LxedhpxfL86kS
k5Nrp+gvU5LEYFiwzAJRGFuFjWJZY7attN6a+yb3ACfAXVU3dJnJUH/jWS5E4ywl
7uxMMne0nxrpS10gxdr9HIcWxkPo1LsmmkVwXqkLN1PiRnsn/eBG8om3zEK2yygm
btmlyTrIQRNg91CMFa6ybRoVGld45pIq2WWQgj9sAq+uEjonljYE1x2igGOpm/Hl
urR8FLBOybEfdF849lHqm/osohHUqS0nGkWxr7JOcQ3AWEbWaQbLU8uz/mtBzUF+
fUwPfHJ5elnNXkoOrJupmHN5fLT0zLm4BwyydFy4x2+IoZCn9Kr5v2c69BoVYh63
n749sSmvZ6ES8lgQGVMDMBu4Gon2nL2XA46jCfMdiyHxtN/kHNGfZQIG6lzWE7OE
76KlXIx3KadowGuuQNKotOrN8I1LOJwZmhsoVLiJkO/KdYE+HvJkJMcYr07/R54H
9jVlpNMKVv/1F2Rs76giJUmTtt8AF9pYfl3uxRuw0dFfIRDH+fO6AgonB8Xx1sfT
4PsJYGw=
-----END CERTIFICATE-----

Amazon Root CA 3
================================================
SHA1 Fingerprint=0D:44:DD:8C:3C:8C:1A:1A:58:75:64:81:E9:0F:2E:2A:FF:B3:D2:6E
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            06:6c:9f:d5:74:97:36:66:3f:3b:0b:9a:d9:e8:9e:76:03:f2:4a
    Signature Algorithm: ecdsa-with-SHA256
        Issuer: C=US, O=Amazon, CN=Amazon Root CA 3
        Validity
            Not Before: May 26 00:00:00 2015 GMT
            Not After : May 26 00:00:00 2040 GMT
        Subject: C=US, O=Amazon, CN=Amazon Root CA 3
        Subject Public Key Info:
            Public Key Algorithm: id-ecPublicKey
                Public-Key: (256 bit)
                pub: 
                    04:29:97:a7:c6:41:7f:c0:0d:9b:e8:01:1b:56:c6:
                    f2:52:a5:ba:2d:b2:12:e8:d2:2e:d7:fa:c9:c5:d8:
                    aa:6d:1f:73:81:3b:3b:98:6b:39:7c:33:a5:c5:4e:
                    86:8e:80:17:68:62:45:57:7d:44:58:1d:b3:37:e5:
                    67:08:eb:66:de
                ASN1 OID: prime256v1
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Key Usage: critical
                Digital Signature, Certificate Sign, CRL Sign
            X509v3 Subject Key Identifier: 
                AB:B6:DB:D7:06:9E:37:AC:30:86:07:91:70:C7:9C:C4:19:B1:78:C0
    Signature Algorithm: ecdsa-with-SHA256
         30:46:02:21:00:e0:85:92:a3:17:b7:8d:f9:2b:06:a5:93:ac:
         1a:98:68:61:72:fa:e1:a1:d0:fb:1c:78:60:a6:43:99:c5:b8:
         c4:02:21:00:9c:02:ef:f1:94:9c:b3:96:f9:eb:c6:2a:f8:b6:
         2c:fe:3a:90:14:16:d7:8c:63:24:48:1c:df:30:7d:d5:68:3b
-----BEGIN CERTIFICATE-----
MIIBtjCCAVugAwIBAgITBmyf1XSXNmY/Owua2eiedgPySjAKBggqhkjOPQQDAjA5
MQswCQYDVQQGEwJVUzEPMA0GA1UEChMGQW1hem9uMRkwFwYDVQQDExBBbWF6b24g
Um9vdCBDQSAzMB4XDTE1MDUyNjAwMDAwMFoXDTQwMDUyNjAwMDAwMFowOTELMAkG
A1UEBhMCVVMxDzANBgNVBAoTBkFtYXpvbjEZMBcGA1UEAxMQQW1hem9uIFJvb3Qg
Q0EgMzBZMBMGByqGSM49AgEGCCqGSM49AwEHA0IABCmXp8ZBf8ANm+gBG1bG8lKl
ui2yEujSLtf6ycXYqm0fc4E7O5hrOXwzpcVOho6AF2hiRVd9RFgdszflZwjrZt6j
QjBAMA8GA1UdEwEB/wQFMAMBAf8wDgYDVR0PAQH/BAQDAgGGMB0GA1UdDgQWBBSr
ttvXBp43rDCGB5Fwx5zEGbF4wDAKBggqhkjOPQQDAgNJADBGAiEA4IWSoxe3jfkr
BqWTrBqYaGFy+uGh0PsceGCmQ5nFuMQCIQCcAu/xlJyzlvnrxir4tiz+OpAUFteM
YyRIHN8wfdVoOw==
-----END CERTIFICATE-----

Amazon Root CA 4
================================================
SHA1 Fingerprint=F6:10:84:07:D6:F8:BB:67:98:0C:C2:E2:44:C2:EB:AE:1C:EF:63:BE
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            06:6c:9f:d7:c1:bb:10:4c:29:43:e5:71:7b:7b:2c:c8:1a:c1:0e
    Signature Algorithm: ecdsa-with-SHA384
        Issuer: C=US, O=Amazon, CN=Amazon Root CA 4
        Validity
            Not Before: May 26 00:00:00 2015 GMT
            Not After : May 26 00:00:00 2040 GMT
        Subject: C=US, O=Amazon, CN=Amazon Root CA 4
        Subject Public Key Info:
            Public Key Algorithm: id-ecPublicKey
                Public-Key: (384 bit)
                pub: 
                    04:d2:ab:8a:37:4f:a3:53:0d:fe:c1:8a:7b:4b:a8:
                    7b:46:4b:63:b0:62:f6:2d:1b:db:08:71:21:d2:00:
                    e8:63:bd:9a:27:fb:f0:39:6e:5d:ea:3d:a5:c9:81:
                    aa:a3:5b:20:98:45:5d:16:db:fd:e8:10:6d:e3:9c:
                    e0:e3:bd:5f:84:62:f3:70:64:33:a0:cb:24:2f:70:
                    ba:88:a1:2a:a0:75:f8:81:ae:62:06:c4:81:db:39:
                    6e:29:b0:1e:fa:2e:5c
                ASN1 OID: secp384r1
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Key Usage: critical
                Digital Signature, Certificate Sign, CRL Sign
            X509v3 Subject Key Identifier: 
                D3:EC:C7:3A:65:6E:CC:E1:DA:76:9A:56:FB:9C:F3:86:6D:57:E5:81
    Signature Algorithm: ecdsa-with-SHA384
         30:65:02:30:3a:8b:21:f1:bd:7e:11:ad:d0:ef:58:96:2f:d6:
         eb:9d:7e:90:8d:2b:cf:66:55:c3:2c:e3:28:a9:70:0a:47:0e:
         f0:37:59:12:ff:2d:99:94:28:4e:2a:4f:35:4d:33:5a:02:31:
         00:ea:75:00:4e:3b:c4:3a:94:12:91:c9:58:46:9d:21:13:72:
         a7:88:9c:8a:e4:4c:4a:db:96:d4:ac:8b:6b:6b:49:12:53:33:
         ad:d7:e4:be:24:fc:b5:0a:76:d4:a5:bc:10
-----BEGIN CERTIFICATE-----
MIIB8jCCAXigAwIBAgITBmyf18G7EEwpQ+Vxe3ssyBrBDjAKBggqhkjOPQQDAzA5
MQswCQYDVQQGEwJVUzEPMA0GA1UEChMGQW1hem9uMRkwFwYDVQQDExBBbWF6b24g
Um9vdCBDQSA0MB4XDTE1MDUyNjAwMDAwMFoXDTQwMDUyNjAwMDAwMFowOTELMAkG
A1UEBhMCVVMxDzANBgNVBAoTBkFtYXpvbjEZMBcGA1UEAxMQQW1hem9uIFJvb3Qg
Q0EgNDB2MBAGByqGSM49AgEGBSuBBAAiA2IABNKrijdPo1MN/sGKe0uoe0ZLY7Bi
9i0b2whxIdIA6GO9mif78DluXeo9pcmBqqNbIJhFXRbb/egQbeOc4OO9X4Ri83Bk
M6DLJC9wuoihKqB1+IGuYgbEgds5bimwHvouXKNCMEAwDwYDVR0TAQH/BAUwAwEB
/zAOBgNVHQ8BAf8EBAMCAYYwHQYDVR0OBBYEFNPsxzplbszh2naaVvuc84ZtV+WB
MAoGCCqGSM49BAMDA2gAMGUCMDqLIfG9fhGt0O9Yli/W651+kI0rz2ZVwyzjKKlw
CkcO8DdZEv8tmZQoTipPNU0zWgIxAOp1AE47xDqUEpHJWEadIRNyp4iciuRMStuW
1KyLa2tJElMzrdfkviT8tQp21KW8EA==
-----END CERTIFICATE-----

TUBITAK Kamu SM SSL Kok Sertifikasi - Surum 1
=================================================
SHA1 Fingerprint=31:43:64:9B:EC:CE:27:EC:ED:3A:3F:0B:8F:0D:E4:E8:91:DD:EE:CA
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 1 (0x1)
    Signature Algorithm: sha256WithRSAEncryption
        Issuer: C=TR, L=Gebze - Kocaeli, O=Turkiye Bilimsel ve Teknolojik Arastirma Kurumu - TUBITAK, OU=Kamu Sertifikasyon Merkezi - Kamu SM, CN=TUBITAK Kamu SM SSL Kok Sertifikasi - Surum 1
        Validity
            Not Before: Nov 25 08:25:55 2013 GMT
            Not After : Oct 25 08:25:55 2043 GMT
        Subject: C=TR, L=Gebze - Kocaeli, O=Turkiye Bilimsel ve Teknolojik Arastirma Kurumu - TUBITAK, OU=Kamu Sertifikasyon Merkezi - Kamu SM, CN=TUBITAK Kamu SM SSL Kok Sertifikasi - Surum 1
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (2048 bit)
                Modulus:
                    00:af:75:30:33:aa:bb:6b:d3:99:2c:12:37:84:d9:
                    8d:7b:97:80:d3:6e:e7:ff:9b:50:95:3e:90:95:56:
                    42:d7:19:7c:26:84:8d:92:fa:01:1d:3a:0f:e2:64:
                    38:b7:8c:bc:e8:88:f9:8b:24:ab:2e:a3:f5:37:e4:
                    40:8e:18:25:79:83:75:1f:3b:ff:6c:a8:c5:c6:56:
                    f8:b4:ed:8a:44:a3:ab:6c:4c:fc:1d:d0:dc:ef:68:
                    bd:cf:e4:aa:ce:f0:55:f7:a2:34:d4:83:6b:37:7c:
                    1c:c2:fe:b5:03:ec:57:ce:bc:b4:b5:c5:ed:00:0f:
                    53:37:2a:4d:f4:4f:0c:83:fb:86:cf:cb:fe:8c:4e:
                    bd:87:f9:a7:8b:21:57:9c:7a:df:03:67:89:2c:9d:
                    97:61:a7:10:b8:55:90:7f:0e:2d:27:38:74:df:e7:
                    fd:da:4e:12:e3:4d:15:22:02:c8:e0:e0:fc:0f:ad:
                    8a:d7:c9:54:50:cc:3b:0f:ca:16:80:84:d0:51:56:
                    c3:8e:56:7f:89:22:33:2f:e6:85:0a:bd:a5:a8:1b:
                    36:de:d3:dc:2c:6d:3b:c7:13:bd:59:23:2c:e6:e5:
                    a4:f7:d8:0b:ed:ea:90:40:44:a8:95:bb:93:d5:d0:
                    80:34:b6:46:78:0e:1f:00:93:46:e1:ee:e9:f9:ec:
                    4f:17
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Subject Key Identifier: 
                65:3F:C7:8A:86:C6:3C:DD:3C:54:5C:35:F8:3A:ED:52:0C:47:57:C8
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
    Signature Algorithm: sha256WithRSAEncryption
         2a:3f:e1:f1:32:8e:ae:e1:98:5c:4b:5e:cf:6b:1e:6a:09:d2:
         22:a9:12:c7:5e:57:7d:73:56:64:80:84:7a:93:e4:09:b9:10:
         cd:9f:2a:27:e1:00:77:be:48:c8:35:a8:81:9f:e4:b8:2c:c9:
         7f:0e:b0:d2:4b:37:5d:ea:b9:d5:0b:5e:34:bd:f4:73:29:c3:
         ed:26:15:9c:7e:08:53:8a:58:8d:d0:4b:28:df:c1:b3:df:20:
         f3:f9:e3:e3:3a:df:cc:9c:94:d8:4e:4f:c3:6b:17:b7:f7:72:
         e8:ad:66:33:b5:25:53:ab:e0:f8:4c:a9:9d:fd:f2:0d:ba:ae:
         b9:d9:aa:c6:6b:f9:93:bb:ae:ab:b8:97:3c:03:1a:ba:43:c6:
         96:b9:45:72:38:b3:a7:a1:96:3d:91:7b:7e:c0:21:53:4c:87:
         ed:f2:0b:54:95:51:93:d5:22:a5:0d:8a:f1:93:0e:3e:54:0e:
         b0:d8:c9:4e:dc:f2:31:32:56:ea:64:f9:ea:b5:9d:16:66:42:
         72:f3:7f:d3:b1:31:43:fc:a4:8e:17:f1:6d:23:ab:94:66:f8:
         ad:fb:0f:08:6e:26:2d:7f:17:07:09:b2:8c:fb:50:c0:9f:96:
         8d:cf:b6:fd:00:9d:5a:14:9a:bf:02:44:f5:c1:c2:9f:22:5e:
         a2:0f:a1:e3
-----BEGIN CERTIFICATE-----
MIIEYzCCA0ugAwIBAgIBATANBgkqhkiG9w0BAQsFADCB0jELMAkGA1UEBhMCVFIx
GDAWBgNVBAcTD0dlYnplIC0gS29jYWVsaTFCMEAGA1UEChM5VHVya2l5ZSBCaWxp
bXNlbCB2ZSBUZWtub2xvamlrIEFyYXN0aXJtYSBLdXJ1bXUgLSBUVUJJVEFLMS0w
KwYDVQQLEyRLYW11IFNlcnRpZmlrYXN5b24gTWVya2V6aSAtIEthbXUgU00xNjA0
BgNVBAMTLVRVQklUQUsgS2FtdSBTTSBTU0wgS29rIFNlcnRpZmlrYXNpIC0gU3Vy
dW0gMTAeFw0xMzExMjUwODI1NTVaFw00MzEwMjUwODI1NTVaMIHSMQswCQYDVQQG
EwJUUjEYMBYGA1UEBxMPR2ViemUgLSBLb2NhZWxpMUIwQAYDVQQKEzlUdXJraXll
IEJpbGltc2VsIHZlIFRla25vbG9qaWsgQXJhc3Rpcm1hIEt1cnVtdSAtIFRVQklU
QUsxLTArBgNVBAsTJEthbXUgU2VydGlmaWthc3lvbiBNZXJrZXppIC0gS2FtdSBT
TTE2MDQGA1UEAxMtVFVCSVRBSyBLYW11IFNNIFNTTCBLb2sgU2VydGlmaWthc2kg
LSBTdXJ1bSAxMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAr3UwM6q7
a9OZLBI3hNmNe5eA027n/5tQlT6QlVZC1xl8JoSNkvoBHToP4mQ4t4y86Ij5iySr
LqP1N+RAjhgleYN1Hzv/bKjFxlb4tO2KRKOrbEz8HdDc72i9z+SqzvBV96I01INr
N3wcwv61A+xXzry0tcXtAA9TNypN9E8Mg/uGz8v+jE69h/mniyFXnHrfA2eJLJ2X
YacQuFWQfw4tJzh03+f92k4S400VIgLI4OD8D62K18lUUMw7D8oWgITQUVbDjlZ/
iSIzL+aFCr2lqBs23tPcLG07xxO9WSMs5uWk99gL7eqQQESolbuT1dCANLZGeA4f
AJNG4e7p+exPFwIDAQABo0IwQDAdBgNVHQ4EFgQUZT/HiobGPN08VFw1+DrtUgxH
V8gwDgYDVR0PAQH/BAQDAgEGMA8GA1UdEwEB/wQFMAMBAf8wDQYJKoZIhvcNAQEL
BQADggEBACo/4fEyjq7hmFxLXs9rHmoJ0iKpEsdeV31zVmSAhHqT5Am5EM2fKifh
AHe+SMg1qIGf5LgsyX8OsNJLN13qudULXjS99HMpw+0mFZx+CFOKWI3QSyjfwbPf
IPP54+M638yclNhOT8NrF7f3cuitZjO1JVOr4PhMqZ398g26rrnZqsZr+ZO7rqu4
lzwDGrpDxpa5RXI4s6ehlj2Re37AIVNMh+3yC1SVUZPVIqUNivGTDj5UDrDYyU7c
8jEyVupk+eq1nRZmQnLzf9OxMUP8pI4X8W0jq5Rm+K37DwhuJi1/FwcJsoz7UMCf
lo3Ptv0AnVoUmr8CRPXBwp8iXqIPoeM=
-----END CERTIFICATE-----

GDCA TrustAUTH R5 ROOT
=================================================
SHA1 Fingerprint=0F:36:38:5B:81:1A:25:C3:9B:31:4E:83:CA:E9:34:66:70:CC:74:B4
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 9009899650740120186 (0x7d0997fef047ea7a)
    Signature Algorithm: sha256WithRSAEncryption
        Issuer: C=CN, O=GUANG DONG CERTIFICATE AUTHORITY CO.,LTD., CN=GDCA TrustAUTH R5 ROOT
        Validity
            Not Before: Nov 26 05:13:15 2014 GMT
            Not After : Dec 31 15:59:59 2040 GMT
        Subject: C=CN, O=GUANG DONG CERTIFICATE AUTHORITY CO.,LTD., CN=GDCA TrustAUTH R5 ROOT
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (4096 bit)
                Modulus:
                    00:d9:a3:16:f0:c8:74:74:77:9b:ef:33:0d:3b:06:
                    7e:55:fc:b5:60:8f:76:86:12:42:7d:56:66:3e:88:
                    82:ed:72:63:0e:9e:8b:dd:34:2c:02:51:51:c3:19:
                    fd:59:54:84:c9:f1:6b:b3:4c:b0:e9:e8:46:5d:38:
                    c6:a2:a7:2e:11:57:ba:82:15:a2:9c:8f:6d:b0:99:
                    4a:0a:f2:eb:89:70:63:4e:79:c4:b7:5b:bd:a2:5d:
                    b1:f2:41:02:2b:ad:a9:3a:a3:ec:79:0a:ec:5f:3a:
                    e3:fd:ef:80:3c:ad:34:9b:1a:ab:88:26:7b:56:a2:
                    82:86:1f:eb:35:89:83:7f:5f:ae:29:4e:3d:b6:6e:
                    ec:ae:c1:f0:27:9b:ae:e3:f4:ec:ef:ae:7f:f7:86:
                    3d:72:7a:eb:a5:fb:59:4e:a7:eb:95:8c:22:39:79:
                    e1:2d:08:8f:cc:bc:91:b8:41:f7:14:c1:23:a9:c3:
                    ad:9a:45:44:b3:b2:d7:2c:cd:c6:29:e2:50:10:ae:
                    5c:cb:82:8e:17:18:36:7d:97:e6:88:9a:b0:4d:34:
                    09:f4:2c:b9:5a:66:2a:b0:17:9b:9e:1e:76:9d:4a:
                    66:31:41:df:3f:fb:c5:06:ef:1b:b6:7e:1a:46:36:
                    f7:64:63:3b:e3:39:18:23:e7:67:75:14:d5:75:57:
                    92:37:bd:be:6a:1b:26:50:f2:36:26:06:90:c5:70:
                    01:64:6d:76:66:e1:91:db:6e:07:c0:61:80:2e:b2:
                    2e:2f:8c:70:a7:d1:3b:3c:b3:91:e4:6e:b6:c4:3b:
                    70:f2:6c:92:97:09:cd:47:7d:18:c0:f3:bb:9e:0f:
                    d6:8b:ae:07:b6:5a:0f:ce:0b:0c:47:a7:e5:3e:b8:
                    bd:7d:c7:9b:35:a0:61:97:3a:41:75:17:cc:2b:96:
                    77:2a:92:21:1e:d9:95:76:20:67:68:cf:0d:bd:df:
                    d6:1f:09:6a:9a:e2:cc:73:71:a4:2f:7d:12:80:b7:
                    53:30:46:5e:4b:54:99:0f:67:c9:a5:c8:f2:20:c1:
                    82:ec:9d:11:df:c2:02:fb:1a:3b:d1:ed:20:9a:ef:
                    65:64:92:10:0d:2a:e2:de:70:f1:18:67:82:8c:61:
                    de:b8:bc:d1:2f:9c:fb:0f:d0:2b:ed:1b:76:b9:e4:
                    39:55:f8:f8:a1:1d:b8:aa:80:00:4c:82:e7:b2:7f:
                    09:b8:bc:30:a0:2f:0d:f5:52:9e:8e:f7:92:b3:0a:
                    00:1d:00:54:97:06:e0:b1:07:d9:c7:0f:5c:65:7d:
                    3c:6d:59:57:e4:ed:a5:8d:e9:40:53:9f:15:4b:a0:
                    71:f6:1a:21:e3:da:70:06:21:58:14:87:85:77:79:
                    aa:82:79
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Subject Key Identifier: 
                E2:C9:40:9F:4D:CE:E8:9A:A1:7C:CF:0E:3F:65:C5:29:88:6A:19:51
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Key Usage: critical
                Digital Signature, Certificate Sign, CRL Sign
    Signature Algorithm: sha256WithRSAEncryption
         d1:49:57:e0:a7:cc:68:58:ba:01:0f:2b:19:cd:8d:b0:61:45:
         ac:11:ed:63:50:69:f8:1f:7f:be:16:8f:fd:9d:eb:0b:aa:32:
         47:76:d2:67:24:ed:bd:7c:33:32:97:2a:c7:05:86:66:0d:17:
         7d:14:15:1b:d4:eb:fd:1f:9a:f6:5e:97:69:b7:1a:25:a4:0a:
         b3:91:3f:5f:36:ac:8b:ec:57:a8:3e:e7:81:8a:18:57:39:85:
         74:1a:42:c7:e9:5b:13:5f:8f:f9:08:e9:92:74:8d:f5:47:d2:
         ab:3b:d6:fb:78:66:4e:36:7d:f9:e9:92:e9:04:de:fd:49:63:
         fc:6d:fb:14:71:93:67:2f:47:4a:b7:b9:ff:1e:2a:73:70:46:
         30:bf:5a:f2:2f:79:a5:e1:8d:0c:d9:f9:b2:63:37:8c:37:65:
         85:70:6a:5c:5b:09:72:b9:ad:63:3c:b1:dd:f8:fc:32:bf:37:
         86:e4:bb:8e:98:27:7e:ba:1f:16:e1:70:11:f2:03:df:25:62:
         32:27:26:18:32:84:9f:ff:00:3a:13:ba:9a:4d:f4:4f:b8:14:
         70:22:b1:ca:2b:90:ce:29:c1:70:f4:2f:9d:7f:f2:90:1e:d6:
         5a:df:b7:46:fc:e6:86:fa:cb:e0:20:76:7a:ba:a6:cb:f5:7c:
         de:62:a5:b1:8b:ee:de:82:66:8a:4e:3a:30:1f:3f:80:cb:ad:
         27:ba:0c:5e:d7:d0:b1:56:ca:77:71:b2:b5:75:a1:50:a9:40:
         43:17:c2:28:d9:cf:52:8b:5b:c8:63:d4:42:3e:a0:33:7a:46:
         2e:f7:0a:20:46:54:7e:6a:4f:31:f1:81:7e:42:74:38:65:73:
         27:ee:c6:7c:b8:8e:d7:a5:3a:d7:98:a1:9c:8c:10:55:d3:db:
         4b:ec:40:90:f2:cd:6e:57:d2:62:0e:7c:57:93:b1:a7:6d:cd:
         9d:83:bb:2a:e7:e5:b6:3b:71:58:ad:fd:d1:45:bc:5a:91:ee:
         53:15:6f:d3:45:09:75:6e:ba:90:5d:1e:04:cf:37:df:1e:a8:
         66:b1:8c:e6:20:6a:ef:fc:48:4e:74:98:42:af:29:6f:2e:6a:
         c7:fb:7d:d1:66:31:22:cc:86:00:7e:66:83:0c:42:f4:bd:34:
         92:c3:1a:ea:4f:ca:7e:72:4d:0b:70:8c:a6:48:bb:a6:a1:14:
         f6:fb:58:44:99:14:ae:aa:0b:93:69:a0:29:25:4a:a5:cb:2b:
         dd:8a:66:07:16:78:15:57:71:1b:ec:f5:47:84:f3:9e:31:37:
         7a:d5:7f:24:ad:e4:bc:fd:fd:cc:6e:83:e8:0c:a8:b7:41:6c:
         07:dd:bd:3c:86:97:2f:d2
-----BEGIN CERTIFICATE-----
MIIFiDCCA3CgAwIBAgIIfQmX/vBH6nowDQYJKoZIhvcNAQELBQAwYjELMAkGA1UE
BhMCQ04xMjAwBgNVBAoMKUdVQU5HIERPTkcgQ0VSVElGSUNBVEUgQVVUSE9SSVRZ
IENPLixMVEQuMR8wHQYDVQQDDBZHRENBIFRydXN0QVVUSCBSNSBST09UMB4XDTE0
MTEyNjA1MTMxNVoXDTQwMTIzMTE1NTk1OVowYjELMAkGA1UEBhMCQ04xMjAwBgNV
BAoMKUdVQU5HIERPTkcgQ0VSVElGSUNBVEUgQVVUSE9SSVRZIENPLixMVEQuMR8w
HQYDVQQDDBZHRENBIFRydXN0QVVUSCBSNSBST09UMIICIjANBgkqhkiG9w0BAQEF
AAOCAg8AMIICCgKCAgEA2aMW8Mh0dHeb7zMNOwZ+Vfy1YI92hhJCfVZmPoiC7XJj
Dp6L3TQsAlFRwxn9WVSEyfFrs0yw6ehGXTjGoqcuEVe6ghWinI9tsJlKCvLriXBj
TnnEt1u9ol2x8kECK62pOqPseQrsXzrj/e+APK00mxqriCZ7VqKChh/rNYmDf1+u
KU49tm7srsHwJ5uu4/Ts765/94Y9cnrrpftZTqfrlYwiOXnhLQiPzLyRuEH3FMEj
qcOtmkVEs7LXLM3GKeJQEK5cy4KOFxg2fZfmiJqwTTQJ9Cy5WmYqsBebnh52nUpm
MUHfP/vFBu8btn4aRjb3ZGM74zkYI+dndRTVdVeSN72+ahsmUPI2JgaQxXABZG12
ZuGR224HwGGALrIuL4xwp9E7PLOR5G62xDtw8mySlwnNR30YwPO7ng/Wi64HtloP
zgsMR6flPri9fcebNaBhlzpBdRfMK5Z3KpIhHtmVdiBnaM8Nvd/WHwlqmuLMc3Gk
L30SgLdTMEZeS1SZD2fJpcjyIMGC7J0R38IC+xo70e0gmu9lZJIQDSri3nDxGGeC
jGHeuLzRL5z7D9Ar7Rt2ueQ5Vfj4oR24qoAATILnsn8JuLwwoC8N9VKejveSswoA
HQBUlwbgsQfZxw9cZX08bVlX5O2ljelAU58VS6Bx9hoh49pwBiFYFIeFd3mqgnkC
AwEAAaNCMEAwHQYDVR0OBBYEFOLJQJ9NzuiaoXzPDj9lxSmIahlRMA8GA1UdEwEB
/wQFMAMBAf8wDgYDVR0PAQH/BAQDAgGGMA0GCSqGSIb3DQEBCwUAA4ICAQDRSVfg
p8xoWLoBDysZzY2wYUWsEe1jUGn4H3++Fo/9nesLqjJHdtJnJO29fDMylyrHBYZm
DRd9FBUb1Ov9H5r2XpdptxolpAqzkT9fNqyL7FeoPueBihhXOYV0GkLH6VsTX4/5
COmSdI31R9KrO9b7eGZONn356ZLpBN79SWP8bfsUcZNnL0dKt7n/HipzcEYwv1ry
L3ml4Y0M2fmyYzeMN2WFcGpcWwlyua1jPLHd+PwyvzeG5LuOmCd+uh8W4XAR8gPf
JWIyJyYYMoSf/wA6E7qaTfRPuBRwIrHKK5DOKcFw9C+df/KQHtZa37dG/OaG+svg
IHZ6uqbL9XzeYqWxi+7egmaKTjowHz+Ay60nugxe19CxVsp3cbK1daFQqUBDF8Io
2c9Si1vIY9RCPqAzekYu9wogRlR+ak8x8YF+QnQ4ZXMn7sZ8uI7XpTrXmKGcjBBV
09tL7ECQ8s1uV9JiDnxXk7Gnbc2dg7sq5+W2O3FYrf3RRbxake5TFW/TRQl1brqQ
XR4EzzffHqhmsYzmIGrv/EhOdJhCrylvLmrH+33RZjEizIYAfmaDDEL0vTSSwxrq
T8p+ck0LcIymSLumoRT2+1hEmRSuqguTaaApJUqlyyvdimYHFngVV3Eb7PVHhPOe
MTd61X8kreS8/f3MboPoDKi3QWwH3b08hpcv0g==
-----END CERTIFICATE-----

TrustCor RootCert CA-1
================================================
SHA1 Fingerprint=FF:BD:CD:E7:82:C8:43:5E:3C:6F:26:86:5C:CA:A8:3A:45:5B:C3:0A
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 15752444095811006489 (0xda9bec71f303b019)
    Signature Algorithm: sha256WithRSAEncryption
        Issuer: C=PA, ST=Panama, L=Panama City, O=TrustCor Systems S. de R.L., OU=TrustCor Certificate Authority, CN=TrustCor RootCert CA-1
        Validity
            Not Before: Feb  4 12:32:16 2016 GMT
            Not After : Dec 31 17:23:16 2029 GMT
        Subject: C=PA, ST=Panama, L=Panama City, O=TrustCor Systems S. de R.L., OU=TrustCor Certificate Authority, CN=TrustCor RootCert CA-1
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (2048 bit)
                Modulus:
                    00:bf:8e:b7:95:e2:c2:26:12:6b:33:19:c7:40:58:
                    0a:ab:59:aa:8d:00:a3:fc:80:c7:50:7b:8e:d4:20:
                    26:ba:32:12:d8:23:54:49:25:10:22:98:9d:46:d2:
                    c1:c9:9e:4e:1b:2e:2c:0e:38:f3:1a:25:68:1c:a6:
                    5a:05:e6:1e:8b:48:bf:98:96:74:3e:69:ca:e9:b5:
                    78:a5:06:bc:d5:00:5e:09:0a:f2:27:7a:52:fc:2d:
                    d5:b1:ea:b4:89:61:24:f3:1a:13:db:a9:cf:52:ed:
                    0c:24:ba:b9:9e:ec:7e:00:74:fa:93:ad:6c:29:92:
                    ae:51:b4:bb:d3:57:bf:b3:f3:a8:8d:9c:f4:24:4b:
                    2a:d6:99:9e:f4:9e:fe:c0:7e:42:3a:e7:0b:95:53:
                    da:b7:68:0e:90:4c:fb:70:3f:8f:4a:2c:94:f3:26:
                    dd:63:69:a9:94:d8:10:4e:c5:47:08:90:99:1b:17:
                    4d:b9:6c:6e:ef:60:95:11:8e:21:80:b5:bd:a0:73:
                    d8:d0:b2:77:c4:45:ea:5a:26:fb:66:76:76:f8:06:
                    1f:61:6d:0f:55:c5:83:b7:10:56:72:06:07:a5:f3:
                    b1:1a:03:05:64:0e:9d:5a:8a:d6:86:70:1b:24:de:
                    fe:28:8a:2b:d0:6a:b0:fc:7a:a2:dc:b2:79:0e:8b:
                    65:0f
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Subject Key Identifier: 
                EE:6B:49:3C:7A:3F:0D:E3:B1:09:B7:8A:C8:AB:19:9F:73:33:50:E7
            X509v3 Authority Key Identifier: 
                keyid:EE:6B:49:3C:7A:3F:0D:E3:B1:09:B7:8A:C8:AB:19:9F:73:33:50:E7

            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Key Usage: critical
                Digital Signature, Certificate Sign, CRL Sign
    Signature Algorithm: sha256WithRSAEncryption
         25:18:d4:91:8f:13:ee:8f:1e:1d:11:53:da:2d:44:29:19:a0:
         1e:6b:31:9e:4d:0e:9e:ad:3d:5c:41:6f:95:2b:24:a1:79:98:
         3a:38:36:fb:bb:66:9e:48:ff:90:90:ef:3d:d4:b8:9b:b4:87:
         75:3f:20:9b:ce:72:cf:a1:55:c1:4d:64:a2:19:06:a1:07:33:
         0c:0b:29:e5:f1:ea:ab:a3:ec:b5:0a:74:90:c7:7d:72:f2:d7:
         5c:9f:91:ef:91:8b:b7:dc:ed:66:a2:cf:8e:66:3b:bc:9f:3a:
         02:e0:27:dd:16:98:c0:95:d4:0a:a4:e4:81:9a:75:94:35:9c:
         90:5f:88:37:06:ad:59:95:0a:b0:d1:67:d3:19:ca:89:e7:32:
         5a:36:1c:3e:82:a8:5a:93:be:c6:d0:64:91:b6:cf:d9:b6:18:
         cf:db:7e:d2:65:a3:a6:c4:8e:17:31:c1:fb:7e:76:db:d3:85:
         e3:58:b2:77:7a:76:3b:6c:2f:50:1c:e7:db:f6:67:79:1f:f5:
         82:95:9a:07:a7:14:af:8f:dc:28:21:67:09:d2:d6:4d:5a:1c:
         19:1c:8e:77:5c:c3:94:24:3d:32:6b:4b:7e:d4:78:94:83:be:
         37:4d:ce:5f:c7:1e:4e:3c:e0:89:33:95:0b:0f:a5:32:d6:3c:
         5a:79:2c:19
-----BEGIN CERTIFICATE-----
MIIEMDCCAxigAwIBAgIJANqb7HHzA7AZMA0GCSqGSIb3DQEBCwUAMIGkMQswCQYD
VQQGEwJQQTEPMA0GA1UECAwGUGFuYW1hMRQwEgYDVQQHDAtQYW5hbWEgQ2l0eTEk
MCIGA1UECgwbVHJ1c3RDb3IgU3lzdGVtcyBTLiBkZSBSLkwuMScwJQYDVQQLDB5U
cnVzdENvciBDZXJ0aWZpY2F0ZSBBdXRob3JpdHkxHzAdBgNVBAMMFlRydXN0Q29y
IFJvb3RDZXJ0IENBLTEwHhcNMTYwMjA0MTIzMjE2WhcNMjkxMjMxMTcyMzE2WjCB
pDELMAkGA1UEBhMCUEExDzANBgNVBAgMBlBhbmFtYTEUMBIGA1UEBwwLUGFuYW1h
IENpdHkxJDAiBgNVBAoMG1RydXN0Q29yIFN5c3RlbXMgUy4gZGUgUi5MLjEnMCUG
A1UECwweVHJ1c3RDb3IgQ2VydGlmaWNhdGUgQXV0aG9yaXR5MR8wHQYDVQQDDBZU
cnVzdENvciBSb290Q2VydCBDQS0xMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIB
CgKCAQEAv463leLCJhJrMxnHQFgKq1mqjQCj/IDHUHuO1CAmujIS2CNUSSUQIpid
RtLByZ5OGy4sDjjzGiVoHKZaBeYei0i/mJZ0PmnK6bV4pQa81QBeCQryJ3pS/C3V
seq0iWEk8xoT26nPUu0MJLq5nux+AHT6k61sKZKuUbS701e/s/OojZz0JEsq1pme
9J7+wH5COucLlVPat2gOkEz7cD+PSiyU8ybdY2mplNgQTsVHCJCZGxdNuWxu72CV
EY4hgLW9oHPY0LJ3xEXqWib7ZnZ2+AYfYW0PVcWDtxBWcgYHpfOxGgMFZA6dWorW
hnAbJN7+KIor0Gqw/Hqi3LJ5DotlDwIDAQABo2MwYTAdBgNVHQ4EFgQU7mtJPHo/
DeOxCbeKyKsZn3MzUOcwHwYDVR0jBBgwFoAU7mtJPHo/DeOxCbeKyKsZn3MzUOcw
DwYDVR0TAQH/BAUwAwEB/zAOBgNVHQ8BAf8EBAMCAYYwDQYJKoZIhvcNAQELBQAD
ggEBACUY1JGPE+6PHh0RU9otRCkZoB5rMZ5NDp6tPVxBb5UrJKF5mDo4Nvu7Zp5I
/5CQ7z3UuJu0h3U/IJvOcs+hVcFNZKIZBqEHMwwLKeXx6quj7LUKdJDHfXLy11yf
ke+Ri7fc7Waiz45mO7yfOgLgJ90WmMCV1Aqk5IGadZQ1nJBfiDcGrVmVCrDRZ9MZ
yonnMlo2HD6CqFqTvsbQZJG2z9m2GM/bftJlo6bEjhcxwft+dtvTheNYsnd6djts
L1Ac59v2Z3kf9YKVmgenFK+P3CghZwnS1k1aHBkcjndcw5QkPTJrS37UeJSDvjdN
zl/HHk484IkzlQsPpTLWPFp5LBk=
-----END CERTIFICATE-----

TrustCor RootCert CA-2
================================================
SHA1 Fingerprint=B8:BE:6D:CB:56:F1:55:B9:63:D4:12:CA:4E:06:34:C7:94:B2:1C:C0
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 2711694510199101698 (0x25a1dfca33cb5902)
    Signature Algorithm: sha256WithRSAEncryption
        Issuer: C=PA, ST=Panama, L=Panama City, O=TrustCor Systems S. de R.L., OU=TrustCor Certificate Authority, CN=TrustCor RootCert CA-2
        Validity
            Not Before: Feb  4 12:32:23 2016 GMT
            Not After : Dec 31 17:26:39 2034 GMT
        Subject: C=PA, ST=Panama, L=Panama City, O=TrustCor Systems S. de R.L., OU=TrustCor Certificate Authority, CN=TrustCor RootCert CA-2
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (4096 bit)
                Modulus:
                    00:a7:20:6e:c2:2a:a2:62:24:95:90:76:c8:38:7e:
                    80:d2:ab:c1:9b:65:05:94:f4:c1:0a:10:d5:02:ac:
                    ed:9f:93:c7:87:c8:b0:27:2b:42:0c:3d:0a:3e:41:
                    5a:9e:75:dd:8d:ca:e0:9b:ec:68:32:a4:69:92:68:
                    8c:0b:81:0e:56:a0:3e:1a:dd:2c:25:14:82:2f:97:
                    d3:64:46:f4:54:a9:dc:3a:54:2d:31:2b:99:82:f2:
                    d9:2a:d7:ef:71:00:b8:31:a4:be:7a:24:07:c3:42:
                    20:f2:8a:d4:92:04:1b:65:56:4c:6c:d4:fb:b6:61:
                    5a:47:23:b4:d8:69:b4:b7:3a:d0:74:3c:0c:75:a1:
                    8c:4e:76:a1:e9:db:2a:a5:3b:fa:ce:b0:ff:7e:6a:
                    28:fd:27:1c:c8:b1:e9:29:f1:57:6e:64:b4:d0:c1:
                    15:6d:0e:be:2e:0e:46:c8:5e:f4:51:fe:ef:0e:63:
                    3a:3b:71:ba:cf:6f:59:ca:0c:e3:9b:5d:49:b8:4c:
                    e2:57:b1:98:8a:42:57:9c:76:ef:ef:bd:d1:68:a8:
                    d2:f4:09:bb:77:35:be:25:82:08:c4:16:2c:44:20:
                    56:a9:44:11:77:ef:5d:b4:1d:aa:5e:6b:3e:8b:32:
                    f6:07:2f:57:04:92:ca:f5:fe:9d:c2:e9:e8:b3:8e:
                    4c:4b:02:31:d9:e4:3c:48:82:27:f7:18:82:76:48:
                    3a:71:b1:13:a1:39:d5:2e:c5:34:c2:1d:62:85:df:
                    03:fe:4d:f4:af:3d:df:5c:5b:8d:fa:70:e1:a5:7e:
                    27:c7:86:2e:6a:8f:12:c6:84:5e:43:51:50:9c:19:
                    9b:78:e6:fc:f6:ed:47:7e:7b:3d:66:ef:13:13:88:
                    5f:3c:a1:63:fb:f9:ac:87:35:9f:f3:82:9e:a4:3f:
                    0a:9c:31:69:8b:99:a4:88:4a:8e:6e:66:4d:ef:16:
                    c4:0f:79:28:21:60:0d:85:16:7d:d7:54:38:f1:92:
                    56:fd:b5:33:4c:83:dc:d7:10:9f:4b:fd:c6:f8:42:
                    bd:ba:7c:73:02:e0:ff:7d:cd:5b:e1:d4:ac:61:7b:
                    57:d5:4a:7b:5b:d4:85:58:27:5d:bf:f8:2b:60:ac:
                    a0:26:ae:14:21:27:c6:77:9a:33:80:3c:5e:46:3f:
                    f7:c3:b1:a3:86:33:c6:e8:5e:0d:b9:35:2c:aa:46:
                    c1:85:02:75:80:a0:eb:24:fb:15:aa:e4:67:7f:6e:
                    77:3f:f4:04:8a:2f:7c:7b:e3:17:61:f0:dd:09:a9:
                    20:c8:be:09:a4:d0:7e:44:c3:b2:30:4a:38:aa:a9:
                    ec:18:9a:07:82:2b:db:b8:9c:18:ad:da:e0:46:17:
                    ac:cf:5d
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Subject Key Identifier: 
                D9:FE:21:40:6E:94:9E:BC:9B:3D:9C:7D:98:20:19:E5:8C:30:62:B2
            X509v3 Authority Key Identifier: 
                keyid:D9:FE:21:40:6E:94:9E:BC:9B:3D:9C:7D:98:20:19:E5:8C:30:62:B2

            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Key Usage: critical
                Digital Signature, Certificate Sign, CRL Sign
    Signature Algorithm: sha256WithRSAEncryption
         9e:45:9e:0c:3b:b6:ef:e1:3a:c8:7c:d1:00:3d:cf:e2:ea:06:
         b5:b2:3a:bb:06:4b:68:7a:d0:23:97:74:a7:2c:f0:08:d8:79:
         5a:d7:5a:84:8a:d8:12:9a:1b:d9:7d:5c:4d:70:c5:a5:f9:ab:
         e5:a3:89:89:dd:01:fa:ec:dd:f9:e9:92:97:db:b0:46:42:f3:
         d3:62:aa:95:fe:31:67:14:69:58:90:0a:aa:0b:ee:37:23:c7:
         50:51:b4:f5:7e:9e:e3:7b:f7:e4:cc:42:32:2d:49:0c:cb:ff:
         49:0c:9b:1e:34:fd:6e:6e:96:8a:79:03:b6:6f:db:09:cb:fd:
         5f:65:14:37:e1:38:f5:f3:61:16:58:e4:b5:6d:0d:0b:04:1b:
         3f:50:2d:7f:b3:c7:7a:1a:16:80:60:f8:8a:1f:e9:1b:2a:c6:
         f9:ba:01:1a:69:bf:d2:58:c7:54:57:08:8f:e1:39:60:77:4b:
         ac:59:84:1a:88:f1:dd:cb:4f:78:d7:e7:e1:33:2d:fc:ee:41:
         fa:20:b0:be:cb:f7:38:94:c0:e1:d0:85:0f:bb:ed:2c:73:ab:
         ed:fe:92:76:1a:64:7f:5b:0d:33:09:07:33:7b:06:3f:11:a4:
         5c:70:3c:85:c0:cf:e3:90:a8:83:77:fa:db:e6:c5:8c:68:67:
         10:67:a5:52:2d:f0:c4:99:8f:7f:bf:d1:6b:e2:b5:47:d6:d9:
         d0:85:99:4d:94:9b:0f:4b:8d:ee:00:5a:47:1d:11:03:ac:41:
         18:af:87:b7:6f:0c:3a:8f:ca:cf:dc:03:c1:a2:09:c8:e5:fd:
         80:5e:c8:60:42:01:1b:1a:53:5a:bb:37:a6:b7:bc:ba:84:e9:
         1e:6c:1a:d4:64:da:d4:43:fe:93:8b:4b:f2:2c:79:16:10:d4:
         93:0b:88:8f:a1:d8:86:14:46:91:47:9b:28:24:ef:57:52:4e:
         5c:42:9c:aa:f7:49:ec:27:e8:40:1e:b3:a6:89:22:72:9c:f5:
         0d:33:b4:58:a3:30:3b:dd:d4:6a:54:93:be:1a:4d:f3:93:94:
         f7:fc:84:0b:3f:84:20:5c:34:03:44:c5:da:ad:bc:0a:c1:02:
         cf:1e:e5:94:d9:f3:8e:5b:d8:4c:f0:9d:ec:61:17:bb:14:32:
         54:0c:02:29:93:1e:92:86:f6:7f:ef:e7:92:05:0e:59:dd:99:
         08:2e:2e:fa:9c:00:52:d3:c5:66:29:e4:a7:97:44:a4:0e:28:
         81:13:35:c5:f6:6f:64:e6:41:c4:d5:2f:cc:34:45:25:cf:41:
         00:96:3d:4a:2e:c2:96:98:4f:4e:4a:9c:97:b7:db:1f:92:32:
         c8:ff:0f:51:6e:d6:ec:09
-----BEGIN CERTIFICATE-----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-----END CERTIFICATE-----

TrustCor ECA-1
================================================
SHA1 Fingerprint=58:D1:DF:95:95:67:6B:63:C0:F0:5B:1C:17:4D:8B:84:0B:C8:78:BD
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 9548242946988625984 (0x84822c5f1c62d040)
    Signature Algorithm: sha256WithRSAEncryption
        Issuer: C=PA, ST=Panama, L=Panama City, O=TrustCor Systems S. de R.L., OU=TrustCor Certificate Authority, CN=TrustCor ECA-1
        Validity
            Not Before: Feb  4 12:32:33 2016 GMT
            Not After : Dec 31 17:28:07 2029 GMT
        Subject: C=PA, ST=Panama, L=Panama City, O=TrustCor Systems S. de R.L., OU=TrustCor Certificate Authority, CN=TrustCor ECA-1
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (2048 bit)
                Modulus:
                    00:cf:8f:e0:11:b5:9f:a8:76:76:db:df:0f:54:ef:
                    73:63:29:82:ad:47:c6:a3:6b:ed:fe:5f:33:f8:43:
                    51:e9:1a:33:91:31:17:a0:74:c4:d4:a7:01:e6:b2:
                    92:3e:6a:9d:ed:0e:f9:74:98:40:d3:3f:03:80:06:
                    82:40:e8:b1:e2:a7:51:a7:1d:83:26:6b:ab:de:fa:
                    17:91:2b:d8:c6:ac:1e:b1:9e:19:01:d5:97:a6:ea:
                    0d:b7:c4:55:1f:27:7c:d2:08:d5:76:1f:29:15:87:
                    40:39:dd:38:45:11:75:d0:9a:a7:34:e0:bf:cd:c8:
                    52:1d:b9:47:7e:0d:b8:bb:c6:0c:f6:73:57:16:5a:
                    7e:43:91:1f:55:3a:c6:6d:44:04:aa:9c:a9:9c:a7:
                    4c:89:17:83:ae:a3:04:5e:52:80:8b:1e:12:25:11:
                    19:d7:0c:7d:7d:31:44:41:ea:db:af:b0:1c:ef:81:
                    d0:2c:c5:9a:21:9b:3d:ed:42:3b:50:26:f2:ec:ce:
                    71:61:06:62:21:54:4e:7f:c1:9d:3e:7f:20:8c:80:
                    cb:2a:d8:97:62:c8:83:33:91:7d:b0:a2:5a:0f:57:
                    e8:3b:cc:f2:25:b2:d4:7c:2f:ec:4d:c6:a1:3a:15:
                    7a:e7:b6:5d:35:f5:f6:48:4a:36:45:66:d4:ba:98:
                    58:c1
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Subject Key Identifier: 
                44:9E:48:F5:CC:6D:48:D4:A0:4B:7F:FE:59:24:2F:83:97:99:9A:86
            X509v3 Authority Key Identifier: 
                keyid:44:9E:48:F5:CC:6D:48:D4:A0:4B:7F:FE:59:24:2F:83:97:99:9A:86

            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Key Usage: critical
                Digital Signature, Certificate Sign, CRL Sign
    Signature Algorithm: sha256WithRSAEncryption
         05:3e:35:5c:15:70:9b:c9:c7:73:61:6f:72:2b:d4:c2:8f:f2:
         43:5d:02:ce:c4:94:b9:94:11:83:67:5d:e2:67:6c:75:76:bf:
         bb:0c:aa:36:c6:ad:47:93:63:dc:1e:7e:d6:de:2e:fe:e9:19:
         32:38:03:7f:14:f6:00:73:2c:59:b1:21:06:e1:fb:ac:18:95:
         0c:a3:ff:99:96:f7:2b:27:9b:d5:24:cc:1d:dd:c1:3a:e0:98:
         44:b0:c4:e4:3e:77:b1:73:a9:64:2c:f6:1c:01:7c:3f:5d:45:
         85:c0:85:e7:25:8f:95:dc:17:f3:3c:9f:1a:6e:b0:ca:e3:1d:
         2a:e9:4c:63:fa:24:61:62:d6:da:7e:b6:1c:6c:f5:02:1d:d4:
         2a:dd:55:90:eb:2a:11:47:3c:2e:5e:74:b2:82:22:a5:7d:53:
         1f:45:ec:27:91:7d:e7:22:16:e8:c0:68:36:d8:c6:f1:4f:80:
         44:32:f9:e1:d1:d1:1d:aa:de:a8:ab:9c:04:af:ad:20:0e:64:
         98:4d:a5:6b:c0:48:58:96:69:4d:dc:07:8c:51:93:a2:df:9f:
         0f:3d:8b:60:b4:82:8d:aa:08:4e:62:45:e0:f9:0b:d2:e0:e0:
         3c:5b:de:5c:71:27:25:c2:e6:03:81:8b:10:53:e3:c7:55:a2:
         b4:9f:d7:e6
-----BEGIN CERTIFICATE-----
MIIEIDCCAwigAwIBAgIJAISCLF8cYtBAMA0GCSqGSIb3DQEBCwUAMIGcMQswCQYD
VQQGEwJQQTEPMA0GA1UECAwGUGFuYW1hMRQwEgYDVQQHDAtQYW5hbWEgQ2l0eTEk
MCIGA1UECgwbVHJ1c3RDb3IgU3lzdGVtcyBTLiBkZSBSLkwuMScwJQYDVQQLDB5U
cnVzdENvciBDZXJ0aWZpY2F0ZSBBdXRob3JpdHkxFzAVBgNVBAMMDlRydXN0Q29y
IEVDQS0xMB4XDTE2MDIwNDEyMzIzM1oXDTI5MTIzMTE3MjgwN1owgZwxCzAJBgNV
BAYTAlBBMQ8wDQYDVQQIDAZQYW5hbWExFDASBgNVBAcMC1BhbmFtYSBDaXR5MSQw
IgYDVQQKDBtUcnVzdENvciBTeXN0ZW1zIFMuIGRlIFIuTC4xJzAlBgNVBAsMHlRy
dXN0Q29yIENlcnRpZmljYXRlIEF1dGhvcml0eTEXMBUGA1UEAwwOVHJ1c3RDb3Ig
RUNBLTEwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDPj+ARtZ+odnbb
3w9U73NjKYKtR8aja+3+XzP4Q1HpGjORMRegdMTUpwHmspI+ap3tDvl0mEDTPwOA
BoJA6LHip1GnHYMma6ve+heRK9jGrB6xnhkB1Zem6g23xFUfJ3zSCNV2HykVh0A5
3ThFEXXQmqc04L/NyFIduUd+Dbi7xgz2c1cWWn5DkR9VOsZtRASqnKmcp0yJF4Ou
owReUoCLHhIlERnXDH19MURB6tuvsBzvgdAsxZohmz3tQjtQJvLsznFhBmIhVE5/
wZ0+fyCMgMsq2JdiyIMzkX2woloPV+g7zPIlstR8L+xNxqE6FXrntl019fZISjZF
ZtS6mFjBAgMBAAGjYzBhMB0GA1UdDgQWBBREnkj1zG1I1KBLf/5ZJC+Dl5mahjAf
BgNVHSMEGDAWgBREnkj1zG1I1KBLf/5ZJC+Dl5mahjAPBgNVHRMBAf8EBTADAQH/
MA4GA1UdDwEB/wQEAwIBhjANBgkqhkiG9w0BAQsFAAOCAQEABT41XBVwm8nHc2Fv
civUwo/yQ10CzsSUuZQRg2dd4mdsdXa/uwyqNsatR5Nj3B5+1t4u/ukZMjgDfxT2
AHMsWbEhBuH7rBiVDKP/mZb3Kyeb1STMHd3BOuCYRLDE5D53sXOpZCz2HAF8P11F
hcCF5yWPldwX8zyfGm6wyuMdKulMY/okYWLW2n62HGz1Ah3UKt1VkOsqEUc8Ll50
soIipX1TH0XsJ5F95yIW6MBoNtjG8U+ARDL54dHRHareqKucBK+tIA5kmE2la8BI
WJZpTdwHjFGTot+fDz2LYLSCjaoITmJF4PkL0uDgPFveXHEnJcLmA4GLEFPjx1Wi
tJ/X5g==
-----END CERTIFICATE-----

SSL.com Root Certification Authority RSA
================================================
SHA1 Fingerprint=B7:AB:33:08:D1:EA:44:77:BA:14:80:12:5A:6F:BD:A9:36:49:0C:BB
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 8875640296558310041 (0x7b2c9bd316803299)
    Signature Algorithm: sha256WithRSAEncryption
        Issuer: C=US, ST=Texas, L=Houston, O=SSL Corporation, CN=SSL.com Root Certification Authority RSA
        Validity
            Not Before: Feb 12 17:39:39 2016 GMT
            Not After : Feb 12 17:39:39 2041 GMT
        Subject: C=US, ST=Texas, L=Houston, O=SSL Corporation, CN=SSL.com Root Certification Authority RSA
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (4096 bit)
                Modulus:
                    00:f9:0f:dd:a3:2b:7d:cb:d0:2a:fe:ec:67:85:a6:
                    e7:2e:1b:ba:77:e1:e3:f5:af:a4:ec:fa:4a:5d:91:
                    c4:57:47:6b:18:77:6b:76:f2:fd:93:e4:3d:0f:c2:
                    16:9e:0b:66:c3:56:94:9e:17:83:85:ce:56:ef:f2:
                    16:fd:00:62:f5:22:09:54:e8:65:17:4e:41:b9:e0:
                    4f:46:97:aa:1b:c8:b8:6e:62:5e:69:b1:5f:db:2a:
                    02:7e:fc:6c:ca:f3:41:d8:ed:d0:e8:fc:3f:61:48:
                    ed:b0:03:14:1d:10:0e:4b:19:e0:bb:4e:ec:86:65:
                    ff:36:f3:5e:67:02:0b:9d:86:55:61:fd:7a:38:ed:
                    fe:e2:19:00:b7:6f:a1:50:62:75:74:3c:a0:fa:c8:
                    25:92:b4:6e:7a:22:c7:f8:1e:a1:e3:b2:dd:91:31:
                    ab:2b:1d:04:ff:a5:4a:04:37:e9:85:a4:33:2b:fd:
                    e2:d6:55:34:7c:19:a4:4a:68:c7:b2:a8:d3:b7:ca:
                    a1:93:88:eb:c1:97:bc:8c:f9:1d:d9:22:84:24:74:
                    c7:04:3d:6a:a9:29:93:cc:eb:b8:5b:e1:fe:5f:25:
                    aa:34:58:c8:c1:23:54:9d:1b:98:11:c3:38:9c:7e:
                    3d:86:6c:a5:0f:40:86:7c:02:f4:5c:02:4f:28:cb:
                    ae:71:9f:0f:3a:c8:33:fe:11:25:35:ea:fc:ba:c5:
                    60:3d:d9:7c:18:d5:b2:a9:d3:75:78:03:72:22:ca:
                    3a:c3:1f:ef:2c:e5:2e:a9:fa:9e:2c:b6:51:46:fd:
                    af:03:d6:ea:60:68:ea:85:16:36:6b:85:e9:1e:c0:
                    b3:dd:c4:24:dc:80:2a:81:41:6d:94:3e:c8:e0:c9:
                    81:41:00:9e:5e:bf:7f:c5:08:98:a2:18:2c:42:40:
                    b3:f9:6f:38:27:4b:4e:80:f4:3d:81:47:e0:88:7c:
                    ea:1c:ce:b5:75:5c:51:2e:1c:2b:7f:1a:72:28:e7:
                    00:b5:d1:74:c6:d7:e4:9f:ad:07:93:b6:53:35:35:
                    fc:37:e4:c3:f6:5d:16:be:21:73:de:92:0a:f8:a0:
                    63:6a:bc:96:92:6a:3e:f8:bc:65:55:9b:de:f5:0d:
                    89:26:04:fc:25:1a:a6:25:69:cb:c2:6d:ca:7c:e2:
                    59:5f:97:ac:eb:ef:2e:c8:bc:d7:1b:59:3c:2b:cc:
                    f2:19:c8:93:6b:27:63:19:cf:fc:e9:26:f8:ca:71:
                    9b:7f:93:fe:34:67:84:4e:99:eb:fc:b3:78:09:33:
                    70:ba:66:a6:76:ed:1b:73:eb:1a:a5:0d:c4:22:13:
                    20:94:56:0a:4e:2c:6c:4e:b1:fd:cf:9c:09:ba:a2:
                    33:ed:87
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Subject Key Identifier: 
                DD:04:09:07:A2:F5:7A:7D:52:53:12:92:95:EE:38:80:25:0D:A6:59
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Authority Key Identifier: 
                keyid:DD:04:09:07:A2:F5:7A:7D:52:53:12:92:95:EE:38:80:25:0D:A6:59

            X509v3 Key Usage: critical
                Digital Signature, Certificate Sign, CRL Sign
    Signature Algorithm: sha256WithRSAEncryption
         20:18:11:94:29:fb:26:9d:1c:1e:1e:70:61:f1:95:72:93:71:
         24:ad:68:93:58:8e:32:af:1b:b3:70:03:fc:25:2b:74:85:90:
         3d:78:6a:f4:b9:8b:a5:97:3b:b5:18:91:bb:1e:a7:f9:40:5b:
         91:f9:55:99:af:1e:11:d0:5c:1d:a7:66:e3:b1:94:07:0c:32:
         39:a6:ea:1b:b0:79:d8:1d:9c:70:44:e3:8a:dd:c4:f9:95:1f:
         8a:38:43:3f:01:85:a5:47:a7:3d:46:b2:bc:e5:22:68:f7:7b:
         9c:d8:2c:3e:0a:21:c8:2d:33:ac:bf:c5:81:99:31:74:c1:75:
         71:c5:be:b1:f0:23:45:f4:9d:6b:fc:19:63:9d:a3:bc:04:c6:
         18:0b:25:bb:53:89:0f:b3:80:50:de:45:ee:44:7f:ab:94:78:
         64:98:d3:f6:28:dd:87:d8:70:65:74:fb:0e:b9:13:eb:a7:0f:
         61:a9:32:96:cc:de:bb:ed:63:4c:18:bb:a9:40:f7:a0:54:6e:
         20:88:71:75:18:ea:7a:b4:34:72:e0:23:27:77:5c:b6:90:ea:
         86:25:40:ab:ef:33:0f:cb:9f:82:be:a2:20:fb:f6:b5:2d:1a:
         e6:c2:85:b1:74:0f:fb:c8:65:02:a4:52:01:47:dd:49:22:c1:
         bf:d8:eb:6b:ac:7e:de:ec:63:33:15:b7:23:08:8f:c6:0f:8d:
         41:5a:dd:8e:c5:b9:8f:e5:45:3f:78:db:ba:d2:1b:40:b1:fe:
         71:4d:3f:e0:81:a2:ba:5e:b4:ec:15:e0:93:dd:08:1f:7e:e1:
         55:99:0b:21:de:93:9e:0a:fb:e6:a3:49:bd:36:30:fe:e7:77:
         b2:a0:75:97:b5:2d:81:88:17:65:20:f7:da:90:00:9f:c9:52:
         cc:32:ca:35:7c:f5:3d:0f:d8:2b:d7:f5:26:6c:c9:06:34:96:
         16:ea:70:59:1a:32:79:79:0b:b6:88:7f:0f:52:48:3d:bf:6c:
         d8:a2:44:2e:d1:4e:b7:72:58:d3:89:13:95:fe:44:ab:f8:d7:
         8b:1b:6e:9c:bc:2c:a0:5b:d5:6a:00:af:5f:37:e1:d5:fa:10:
         0b:98:9c:86:e7:26:8f:ce:f0:ec:6e:8a:57:0b:80:e3:4e:b2:
         c0:a0:63:61:90:ba:55:68:37:74:6a:b6:92:db:9f:a1:86:22:
         b6:65:27:0e:ec:b6:9f:42:60:e4:67:c2:b5:da:41:0b:c4:d3:
         8b:61:1b:bc:fa:1f:91:2b:d7:44:07:5e:ba:29:ac:d9:c5:e9:
         ef:53:48:5a:eb:80:f1:28:58:21:cd:b0:06:55:fb:27:3f:53:
         90:70:a9:04:1e:57:27:b9
-----BEGIN CERTIFICATE-----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-----END CERTIFICATE-----

SSL.com Root Certification Authority ECC
================================================
SHA1 Fingerprint=C3:19:7C:39:24:E6:54:AF:1B:C4:AB:20:95:7A:E2:C3:0E:13:02:6A
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 8495723813297216424 (0x75e6dfcbc1685ba8)
    Signature Algorithm: ecdsa-with-SHA256
        Issuer: C=US, ST=Texas, L=Houston, O=SSL Corporation, CN=SSL.com Root Certification Authority ECC
        Validity
            Not Before: Feb 12 18:14:03 2016 GMT
            Not After : Feb 12 18:14:03 2041 GMT
        Subject: C=US, ST=Texas, L=Houston, O=SSL Corporation, CN=SSL.com Root Certification Authority ECC
        Subject Public Key Info:
            Public Key Algorithm: id-ecPublicKey
                Public-Key: (384 bit)
                pub: 
                    04:45:6e:a9:50:c4:a6:23:36:9e:5f:28:8d:17:cb:
                    96:22:64:3f:dc:7a:8e:1d:cc:08:b3:a2:71:24:ba:
                    8e:49:b9:04:1b:47:96:58:ab:2d:95:c8:ed:9e:08:
                    35:c8:27:eb:89:8c:53:58:eb:62:8a:fe:f0:5b:0f:
                    6b:31:52:63:41:3b:89:cd:ec:ec:b6:8d:19:d3:34:
                    07:dc:bb:c6:06:7f:c2:45:95:ec:cb:7f:a8:23:e0:
                    09:e9:81:fa:f3:47:d3
                ASN1 OID: secp384r1
        X509v3 extensions:
            X509v3 Subject Key Identifier: 
                82:D1:85:73:30:E7:35:04:D3:8E:02:92:FB:E5:A4:D1:C4:21:E8:CD
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Authority Key Identifier: 
                keyid:82:D1:85:73:30:E7:35:04:D3:8E:02:92:FB:E5:A4:D1:C4:21:E8:CD

            X509v3 Key Usage: critical
                Digital Signature, Certificate Sign, CRL Sign
    Signature Algorithm: ecdsa-with-SHA256
         30:64:02:30:6f:e7:eb:59:11:a4:60:cf:61:b0:96:7b:ed:05:
         f9:2f:13:91:dc:ed:e5:fc:50:6b:11:46:46:b3:1c:21:00:62:
         bb:be:c3:e7:e8:cd:07:99:f9:0d:0b:5d:72:3e:c4:aa:02:30:
         1f:bc:ba:0b:e2:30:24:fb:7c:6d:80:55:0a:99:3e:80:0d:33:
         e5:66:a3:b3:a3:bb:a5:d5:8b:8f:09:2c:a6:5d:7e:e2:f0:07:
         08:68:6d:d2:7c:69:6e:5f:df:e5:6a:65
-----BEGIN CERTIFICATE-----
MIICjTCCAhSgAwIBAgIIdebfy8FoW6gwCgYIKoZIzj0EAwIwfDELMAkGA1UEBhMC
VVMxDjAMBgNVBAgMBVRleGFzMRAwDgYDVQQHDAdIb3VzdG9uMRgwFgYDVQQKDA9T
U0wgQ29ycG9yYXRpb24xMTAvBgNVBAMMKFNTTC5jb20gUm9vdCBDZXJ0aWZpY2F0
aW9uIEF1dGhvcml0eSBFQ0MwHhcNMTYwMjEyMTgxNDAzWhcNNDEwMjEyMTgxNDAz
WjB8MQswCQYDVQQGEwJVUzEOMAwGA1UECAwFVGV4YXMxEDAOBgNVBAcMB0hvdXN0
b24xGDAWBgNVBAoMD1NTTCBDb3Jwb3JhdGlvbjExMC8GA1UEAwwoU1NMLmNvbSBS
b290IENlcnRpZmljYXRpb24gQXV0aG9yaXR5IEVDQzB2MBAGByqGSM49AgEGBSuB
BAAiA2IABEVuqVDEpiM2nl8ojRfLliJkP9x6jh3MCLOicSS6jkm5BBtHllirLZXI
7Z4INcgn64mMU1jrYor+8FsPazFSY0E7ic3s7LaNGdM0B9y7xgZ/wkWV7Mt/qCPg
CemB+vNH06NjMGEwHQYDVR0OBBYEFILRhXMw5zUE044CkvvlpNHEIejNMA8GA1Ud
EwEB/wQFMAMBAf8wHwYDVR0jBBgwFoAUgtGFczDnNQTTjgKS++Wk0cQh6M0wDgYD
VR0PAQH/BAQDAgGGMAoGCCqGSM49BAMCA2cAMGQCMG/n61kRpGDPYbCWe+0F+S8T
kdzt5fxQaxFGRrMcIQBiu77D5+jNB5n5DQtdcj7EqgIwH7y6C+IwJPt8bYBVCpk+
gA0z5Wajs6O7pdWLjwkspl1+4vAHCGht0nxpbl/f5Wpl
-----END CERTIFICATE-----

SSL.com EV Root Certification Authority RSA R2
=================================================
SHA1 Fingerprint=74:3A:F0:52:9B:D0:32:A0:F4:4A:83:CD:D4:BA:A9:7B:7C:2E:C4:9A
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 6248227494352943350 (0x56b629cd34bc78f6)
    Signature Algorithm: sha256WithRSAEncryption
        Issuer: C=US, ST=Texas, L=Houston, O=SSL Corporation, CN=SSL.com EV Root Certification Authority RSA R2
        Validity
            Not Before: May 31 18:14:37 2017 GMT
            Not After : May 30 18:14:37 2042 GMT
        Subject: C=US, ST=Texas, L=Houston, O=SSL Corporation, CN=SSL.com EV Root Certification Authority RSA R2
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (4096 bit)
                Modulus:
                    00:8f:36:65:40:e1:d6:4d:c0:d7:b4:e9:46:da:6b:
                    ea:33:47:cd:4c:f9:7d:7d:be:bd:2d:3d:f0:db:78:
                    e1:86:a5:d9:ba:09:57:68:ed:57:3e:a0:d0:08:41:
                    83:e7:28:41:24:1f:e3:72:15:d0:01:1a:fb:5e:70:
                    23:b2:cb:9f:39:e3:cf:c5:4e:c6:92:6d:26:c6:7b:
                    bb:b3:da:27:9d:0a:86:e9:81:37:05:fe:f0:71:71:
                    ec:c3:1c:e9:63:a2:17:14:9d:ef:1b:67:d3:85:55:
                    02:02:d6:49:c9:cc:5a:e1:b1:f7:6f:32:9f:c9:d4:
                    3b:88:41:a8:9c:bd:cb:ab:db:6d:7b:09:1f:a2:4c:
                    72:90:da:2b:08:fc:cf:3c:54:ce:67:0f:a8:cf:5d:
                    96:19:0b:c4:e3:72:eb:ad:d1:7d:1d:27:ef:92:eb:
                    10:bf:5b:eb:3b:af:cf:80:dd:c1:d2:96:04:5b:7a:
                    7e:a4:a9:3c:38:76:a4:62:8e:a0:39:5e:ea:77:cf:
                    5d:00:59:8f:66:2c:3e:07:a2:a3:05:26:11:69:97:
                    ea:85:b7:0f:96:0b:4b:c8:40:e1:50:ba:2e:8a:cb:
                    f7:0f:9a:22:e7:7f:9a:37:13:cd:f2:4d:13:6b:21:
                    d1:c0:cc:22:f2:a1:46:f6:44:69:9c:ca:61:35:07:
                    00:6f:d6:61:08:11:ea:ba:b8:f6:e9:b3:60:e5:4d:
                    b9:ec:9f:14:66:c9:57:58:db:cd:87:69:f8:8a:86:
                    12:03:47:bf:66:13:76:ac:77:7d:34:24:85:83:cd:
                    d7:aa:9c:90:1a:9f:21:2c:7f:78:b7:64:b8:d8:e8:
                    a6:f4:78:b3:55:cb:84:d2:32:c4:78:ae:a3:8f:61:
                    dd:ce:08:53:ad:ec:88:fc:15:e4:9a:0d:e6:9f:1a:
                    77:ce:4c:8f:b8:14:15:3d:62:9c:86:38:06:00:66:
                    12:e4:59:76:5a:53:c0:02:98:a2:10:2b:68:44:7b:
                    8e:79:ce:33:4a:76:aa:5b:81:16:1b:b5:8a:d8:d0:
                    00:7b:5e:62:b4:09:d6:86:63:0e:a6:05:95:49:ba:
                    28:8b:88:93:b2:34:1c:d8:a4:55:6e:b7:1c:d0:de:
                    99:55:3b:23:f4:22:e0:f9:29:66:26:ec:20:50:77:
                    db:4a:0b:8f:be:e5:02:60:70:41:5e:d4:ae:50:39:
                    22:14:26:cb:b2:3b:73:74:55:47:07:79:81:39:a8:
                    30:13:44:e5:04:8a:ae:96:13:25:42:0f:b9:53:c4:
                    9b:fc:cd:e4:1c:de:3c:fa:ab:d6:06:4a:1f:67:a6:
                    98:30:1c:dd:2c:db:dc:18:95:57:66:c6:ff:5c:8b:
                    56:f5:77
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Authority Key Identifier: 
                keyid:F9:60:BB:D4:E3:D5:34:F6:B8:F5:06:80:25:A7:73:DB:46:69:A8:9E

            X509v3 Subject Key Identifier: 
                F9:60:BB:D4:E3:D5:34:F6:B8:F5:06:80:25:A7:73:DB:46:69:A8:9E
            X509v3 Key Usage: critical
                Digital Signature, Certificate Sign, CRL Sign
    Signature Algorithm: sha256WithRSAEncryption
         56:b3:8e:cb:0a:9d:49:8e:bf:a4:c4:91:bb:66:17:05:51:98:
         75:fb:e5:50:2c:7a:9e:f1:14:fa:ab:d3:8a:3e:ff:91:29:8f:
         63:8b:d8:b4:a9:54:01:0d:be:93:86:2f:f9:4a:6d:c7:5e:f5:
         57:f9:ca:55:1c:12:be:47:0f:36:c5:df:6a:b7:db:75:c2:47:
         25:7f:b9:f1:63:f8:68:2d:55:04:d1:f2:8d:b0:a4:cf:bc:3c:
         5e:1f:78:e7:a5:a0:20:70:b0:04:c5:b7:f7:72:a7:de:22:0d:
         bd:33:25:46:8c:64:92:26:e3:3e:2e:63:96:da:9b:8c:3d:f8:
         18:09:d7:03:cc:7d:86:82:e0:ca:04:07:51:50:d7:ff:92:d5:
         0c:ef:da:86:9f:99:d7:eb:b7:af:68:e2:39:26:94:ba:68:b7:
         bf:83:d3:ea:7a:67:3d:62:67:ae:25:e5:72:e8:e2:e4:ec:ae:
         12:f6:4b:2b:3c:9f:e9:b0:40:f3:38:54:b3:fd:b7:68:c8:da:
         c6:8f:51:3c:b2:fb:91:dc:1c:e7:9b:9d:e1:b7:0d:72:8f:e2:
         a4:c4:a9:78:f9:eb:14:ac:c6:43:05:c2:65:39:28:18:02:c3:
         82:b2:9d:05:be:65:ed:96:5f:65:74:3c:fb:09:35:2e:7b:9c:
         13:fd:1b:0f:5d:c7:6d:81:3a:56:0f:cc:3b:e1:af:02:2f:22:
         ac:46:ca:46:3c:a0:1c:4c:d6:44:b4:5e:2e:5c:15:66:09:e1:
         26:29:fe:c6:52:61:ba:b1:73:ff:c3:0c:9c:e5:6c:6a:94:3f:
         14:ca:40:16:95:84:f3:59:a9:ac:5f:4c:61:93:6d:d1:3b:cc:
         a2:95:0c:22:a6:67:67:44:2e:b9:d9:d2:8a:41:b3:66:0b:5a:
         fb:7d:23:a5:f2:1a:b0:ff:de:9b:83:94:2e:d1:3f:df:92:b7:
         91:af:05:3b:65:c7:a0:6c:b1:cd:62:12:c3:90:1b:e3:25:ce:
         34:bc:6f:77:76:b1:10:c3:f7:05:1a:c0:d6:af:74:62:48:17:
         77:92:69:90:61:1c:de:95:80:74:54:8f:18:1c:c3:f3:03:d0:
         bf:a4:43:75:86:53:18:7a:0a:2e:09:1c:36:9f:91:fd:82:8a:
         22:4b:d1:0e:50:25:dd:cb:03:0c:17:c9:83:00:08:4e:35:4d:
         8a:8b:ed:f0:02:94:66:2c:44:7f:cb:95:27:96:17:ad:09:30:
         ac:b6:71:17:6e:8b:17:f6:1c:09:d4:2d:3b:98:a5:71:d3:54:
         13:d9:60:f3:f5:4b:66:4f:fa:f1:ee:20:12:8d:b4:ac:57:b1:
         45:63:a1:ac:76:a9:c2:fb
-----BEGIN CERTIFICATE-----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-----END CERTIFICATE-----

SSL.com EV Root Certification Authority ECC
=================================================
SHA1 Fingerprint=4C:DD:51:A3:D1:F5:20:32:14:B0:C6:C5:32:23:03:91:C7:46:42:6D
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 3182246526754555285 (0x2c299c5b16ed0595)
    Signature Algorithm: ecdsa-with-SHA256
        Issuer: C=US, ST=Texas, L=Houston, O=SSL Corporation, CN=SSL.com EV Root Certification Authority ECC
        Validity
            Not Before: Feb 12 18:15:23 2016 GMT
            Not After : Feb 12 18:15:23 2041 GMT
        Subject: C=US, ST=Texas, L=Houston, O=SSL Corporation, CN=SSL.com EV Root Certification Authority ECC
        Subject Public Key Info:
            Public Key Algorithm: id-ecPublicKey
                Public-Key: (384 bit)
                pub: 
                    04:aa:12:47:90:98:1b:fb:ef:c3:40:07:83:20:4e:
                    f1:30:82:a2:06:d1:f2:92:86:61:f2:f6:21:68:ca:
                    00:c4:c7:ea:43:00:54:86:dc:fd:1f:df:00:b8:41:
                    62:5c:dc:70:16:32:de:1f:99:d4:cc:c5:07:c8:08:
                    1f:61:16:07:51:3d:7d:5c:07:53:e3:35:38:8c:df:
                    cd:9f:d9:2e:0d:4a:b6:19:2e:5a:70:5a:06:ed:be:
                    f0:a1:b0:ca:d0:09:29
                ASN1 OID: secp384r1
        X509v3 extensions:
            X509v3 Subject Key Identifier: 
                5B:CA:5E:E5:DE:D2:81:AA:CD:A8:2D:64:51:B6:D9:72:9B:97:E6:4F
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Authority Key Identifier: 
                keyid:5B:CA:5E:E5:DE:D2:81:AA:CD:A8:2D:64:51:B6:D9:72:9B:97:E6:4F

            X509v3 Key Usage: critical
                Digital Signature, Certificate Sign, CRL Sign
    Signature Algorithm: ecdsa-with-SHA256
         30:65:02:31:00:8a:e6:40:89:37:eb:e9:d5:13:d9:ca:d4:6b:
         24:f3:b0:3d:87:46:58:1a:ec:b1:df:6f:fb:56:ba:70:6b:c7:
         38:cc:e8:b1:8c:4f:0f:f7:f1:67:76:0e:83:d0:1e:51:8f:02:
         30:3d:f6:23:28:26:4c:c6:60:87:93:26:9b:b2:35:1e:ba:d6:
         f7:3c:d1:1c:ce:fa:25:3c:a6:1a:81:15:5b:f3:12:0f:6c:ee:
         65:8a:c9:87:a8:f9:07:e0:62:9a:8c:5c:4a
-----BEGIN CERTIFICATE-----
MIIClDCCAhqgAwIBAgIILCmcWxbtBZUwCgYIKoZIzj0EAwIwfzELMAkGA1UEBhMC
VVMxDjAMBgNVBAgMBVRleGFzMRAwDgYDVQQHDAdIb3VzdG9uMRgwFgYDVQQKDA9T
U0wgQ29ycG9yYXRpb24xNDAyBgNVBAMMK1NTTC5jb20gRVYgUm9vdCBDZXJ0aWZp
Y2F0aW9uIEF1dGhvcml0eSBFQ0MwHhcNMTYwMjEyMTgxNTIzWhcNNDEwMjEyMTgx
NTIzWjB/MQswCQYDVQQGEwJVUzEOMAwGA1UECAwFVGV4YXMxEDAOBgNVBAcMB0hv
dXN0b24xGDAWBgNVBAoMD1NTTCBDb3Jwb3JhdGlvbjE0MDIGA1UEAwwrU1NMLmNv
bSBFViBSb290IENlcnRpZmljYXRpb24gQXV0aG9yaXR5IEVDQzB2MBAGByqGSM49
AgEGBSuBBAAiA2IABKoSR5CYG/vvw0AHgyBO8TCCogbR8pKGYfL2IWjKAMTH6kMA
VIbc/R/fALhBYlzccBYy3h+Z1MzFB8gIH2EWB1E9fVwHU+M1OIzfzZ/ZLg1Kthku
WnBaBu2+8KGwytAJKaNjMGEwHQYDVR0OBBYEFFvKXuXe0oGqzagtZFG22XKbl+ZP
MA8GA1UdEwEB/wQFMAMBAf8wHwYDVR0jBBgwFoAUW8pe5d7SgarNqC1kUbbZcpuX
5k8wDgYDVR0PAQH/BAQDAgGGMAoGCCqGSM49BAMCA2gAMGUCMQCK5kCJN+vp1RPZ
ytRrJPOwPYdGWBrssd9v+1a6cGvHOMzosYxPD/fxZ3YOg9AeUY8CMD32IygmTMZg
h5Mmm7I1HrrW9zzRHM76JTymGoEVW/MSD2zuZYrJh6j5B+BimoxcSg==
-----END CERTIFICATE-----

GlobalSign Root CA - R6
================================================
SHA1 Fingerprint=80:94:64:0E:B5:A7:A1:CA:11:9C:1F:DD:D5:9F:81:02:63:A7:FB:D1
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            45:e6:bb:03:83:33:c3:85:65:48:e6:ff:45:51
    Signature Algorithm: sha384WithRSAEncryption
        Issuer: OU=GlobalSign Root CA - R6, O=GlobalSign, CN=GlobalSign
        Validity
            Not Before: Dec 10 00:00:00 2014 GMT
            Not After : Dec 10 00:00:00 2034 GMT
        Subject: OU=GlobalSign Root CA - R6, O=GlobalSign, CN=GlobalSign
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (4096 bit)
                Modulus:
                    00:95:07:e8:73:ca:66:f9:ec:14:ca:7b:3c:f7:0d:
                    08:f1:b4:45:0b:2c:82:b4:48:c6:eb:5b:3c:ae:83:
                    b8:41:92:33:14:a4:6f:7f:e9:2a:cc:c6:b0:88:6b:
                    c5:b6:89:d1:c6:b2:ff:14:ce:51:14:21:ec:4a:dd:
                    1b:5a:c6:d6:87:ee:4d:3a:15:06:ed:64:66:0b:92:
                    80:ca:44:de:73:94:4e:f3:a7:89:7f:4f:78:63:08:
                    c8:12:50:6d:42:66:2f:4d:b9:79:28:4d:52:1a:8a:
                    1a:80:b7:19:81:0e:7e:c4:8a:bc:64:4c:21:1c:43:
                    68:d7:3d:3c:8a:c5:b2:66:d5:90:9a:b7:31:06:c5:
                    be:e2:6d:32:06:a6:1e:f9:b9:eb:aa:a3:b8:bf:be:
                    82:63:50:d0:f0:18:89:df:e4:0f:79:f5:ea:a2:1f:
                    2a:d2:70:2e:7b:e7:bc:93:bb:6d:53:e2:48:7c:8c:
                    10:07:38:ff:66:b2:77:61:7e:e0:ea:8c:3c:aa:b4:
                    a4:f6:f3:95:4a:12:07:6d:fd:8c:b2:89:cf:d0:a0:
                    61:77:c8:58:74:b0:d4:23:3a:f7:5d:3a:ca:a2:db:
                    9d:09:de:5d:44:2d:90:f1:81:cd:57:92:fa:7e:bc:
                    50:04:63:34:df:6b:93:18:be:6b:36:b2:39:e4:ac:
                    24:36:b7:f0:ef:b6:1c:13:57:93:b6:de:b2:f8:e2:
                    85:b7:73:a2:b8:35:aa:45:f2:e0:9d:36:a1:6f:54:
                    8a:f1:72:56:6e:2e:88:c5:51:42:44:15:94:ee:a3:
                    c5:38:96:9b:4e:4e:5a:0b:47:f3:06:36:49:77:30:
                    bc:71:37:e5:a6:ec:21:08:75:fc:e6:61:16:3f:77:
                    d5:d9:91:97:84:0a:6c:d4:02:4d:74:c0:14:ed:fd:
                    39:fb:83:f2:5e:14:a1:04:b0:0b:e9:fe:ee:8f:e1:
                    6e:0b:b2:08:b3:61:66:09:6a:b1:06:3a:65:96:59:
                    c0:f0:35:fd:c9:da:28:8d:1a:11:87:70:81:0a:a8:
                    9a:75:1d:9e:3a:86:05:00:9e:db:80:d6:25:f9:dc:
                    05:9e:27:59:4c:76:39:5b:ea:f9:a5:a1:d8:83:0f:
                    d1:ff:df:30:11:f9:85:cf:33:48:f5:ca:6d:64:14:
                    2c:7a:58:4f:d3:4b:08:49:c5:95:64:1a:63:0e:79:
                    3d:f5:b3:8c:ca:58:ad:9c:42:45:79:6e:0e:87:19:
                    5c:54:b1:65:b6:bf:8c:9b:dc:13:e9:0d:6f:b8:2e:
                    dc:67:6e:c9:8b:11:b5:84:14:8a:00:19:70:83:79:
                    91:97:91:d4:1a:27:bf:37:1e:32:07:d8:14:63:3c:
                    28:4c:af
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Subject Key Identifier: 
                AE:6C:05:A3:93:13:E2:A2:E7:E2:D7:1C:D6:C7:F0:7F:C8:67:53:A0
            X509v3 Authority Key Identifier: 
                keyid:AE:6C:05:A3:93:13:E2:A2:E7:E2:D7:1C:D6:C7:F0:7F:C8:67:53:A0

    Signature Algorithm: sha384WithRSAEncryption
         83:25:ed:e8:d1:fd:95:52:cd:9e:c0:04:a0:91:69:e6:5c:d0:
         84:de:dc:ad:a2:4f:e8:47:78:d6:65:98:a9:5b:a8:3c:87:7c:
         02:8a:d1:6e:b7:16:73:e6:5f:c0:54:98:d5:74:be:c1:cd:e2:
         11:91:ad:23:18:3d:dd:e1:72:44:96:b4:95:5e:c0:7b:8e:99:
         78:16:43:13:56:57:b3:a2:b3:3b:b5:77:dc:40:72:ac:a3:eb:
         9b:35:3e:b1:08:21:a1:e7:c4:43:37:79:32:be:b5:e7:9c:2c:
         4c:bc:43:29:99:8e:30:d3:ac:21:e0:e3:1d:fa:d8:07:33:76:
         54:00:22:2a:b9:4d:20:2e:70:68:da:e5:53:fc:83:5c:d3:9d:
         f2:ff:44:0c:44:66:f2:d2:e3:bd:46:00:1a:6d:02:ba:25:5d:
         8d:a1:31:51:dd:54:46:1c:4d:db:99:96:ef:1a:1c:04:5c:a6:
         15:ef:78:e0:79:fe:5d:db:3e:aa:4c:55:fd:9a:15:a9:6f:e1:
         a6:fb:df:70:30:e9:c3:ee:42:46:ed:c2:93:05:89:fa:7d:63:
         7b:3f:d0:71:81:7c:00:e8:98:ae:0e:78:34:c3:25:fb:af:0a:
         9f:20:6b:dd:3b:13:8f:12:8c:e2:41:1a:48:7a:73:a0:77:69:
         c7:b6:5c:7f:82:c8:1e:fe:58:1b:28:2b:a8:6c:ad:5e:6d:c0:
         05:d2:7b:b7:eb:80:fe:25:37:fe:02:9b:68:ac:42:5d:c3:ee:
         f5:cc:dc:f0:50:75:d2:36:69:9c:e6:7b:04:df:6e:06:69:b6:
         de:0a:09:48:59:87:eb:7b:14:60:7a:64:aa:69:43:ef:91:c7:
         4c:ec:18:dd:6c:ef:53:2d:8c:99:e1:5e:f2:72:3e:cf:54:c8:
         bd:67:ec:a4:0f:4c:45:ff:d3:b9:30:23:07:4c:8f:10:bf:86:
         96:d9:99:5a:b4:99:57:1c:a4:cc:bb:15:89:53:ba:2c:05:0f:
         e4:c4:9e:19:b1:18:34:d5:4c:9d:ba:ed:f7:1f:af:24:95:04:
         78:a8:03:bb:ee:81:e5:da:5f:7c:8b:4a:a1:90:74:25:a7:b3:
         3e:4b:c8:2c:56:bd:c7:c8:ef:38:e2:5c:92:f0:79:f7:9c:84:
         ba:74:2d:61:01:20:7e:7e:d1:f2:4f:07:59:5f:8b:2d:43:52:
         eb:46:0c:94:e1:f5:66:47:79:77:d5:54:5b:1f:ad:24:37:cb:
         45:5a:4e:a0:44:48:c8:d8:b0:99:c5:15:84:09:f6:d6:49:49:
         c0:65:b8:e6:1a:71:6e:a0:a8:f1:82:e8:45:3e:6c:d6:02:d7:
         0a:67:83:05:5a:c9:a4:10
-----BEGIN CERTIFICATE-----
MIIFgzCCA2ugAwIBAgIORea7A4Mzw4VlSOb/RVEwDQYJKoZIhvcNAQEMBQAwTDEg
MB4GA1UECxMXR2xvYmFsU2lnbiBSb290IENBIC0gUjYxEzARBgNVBAoTCkdsb2Jh
bFNpZ24xEzARBgNVBAMTCkdsb2JhbFNpZ24wHhcNMTQxMjEwMDAwMDAwWhcNMzQx
MjEwMDAwMDAwWjBMMSAwHgYDVQQLExdHbG9iYWxTaWduIFJvb3QgQ0EgLSBSNjET
MBEGA1UEChMKR2xvYmFsU2lnbjETMBEGA1UEAxMKR2xvYmFsU2lnbjCCAiIwDQYJ
KoZIhvcNAQEBBQADggIPADCCAgoCggIBAJUH6HPKZvnsFMp7PPcNCPG0RQssgrRI
xutbPK6DuEGSMxSkb3/pKszGsIhrxbaJ0cay/xTOURQh7ErdG1rG1ofuTToVBu1k
ZguSgMpE3nOUTvOniX9PeGMIyBJQbUJmL025eShNUhqKGoC3GYEOfsSKvGRMIRxD
aNc9PIrFsmbVkJq3MQbFvuJtMgamHvm566qjuL++gmNQ0PAYid/kD3n16qIfKtJw
LnvnvJO7bVPiSHyMEAc4/2ayd2F+4OqMPKq0pPbzlUoSB239jLKJz9CgYXfIWHSw
1CM69106yqLbnQneXUQtkPGBzVeS+n68UARjNN9rkxi+azayOeSsJDa38O+2HBNX
k7besvjihbdzorg1qkXy4J02oW9UivFyVm4uiMVRQkQVlO6jxTiWm05OWgtH8wY2
SXcwvHE35absIQh1/OZhFj931dmRl4QKbNQCTXTAFO39OfuD8l4UoQSwC+n+7o/h
bguyCLNhZglqsQY6ZZZZwPA1/cnaKI0aEYdwgQqomnUdnjqGBQCe24DWJfncBZ4n
WUx2OVvq+aWh2IMP0f/fMBH5hc8zSPXKbWQULHpYT9NLCEnFlWQaYw55PfWzjMpY
rZxCRXluDocZXFSxZba/jJvcE+kNb7gu3GduyYsRtYQUigAZcIN5kZeR1Bonvzce
MgfYFGM8KEyvAgMBAAGjYzBhMA4GA1UdDwEB/wQEAwIBBjAPBgNVHRMBAf8EBTAD
AQH/MB0GA1UdDgQWBBSubAWjkxPioufi1xzWx/B/yGdToDAfBgNVHSMEGDAWgBSu
bAWjkxPioufi1xzWx/B/yGdToDANBgkqhkiG9w0BAQwFAAOCAgEAgyXt6NH9lVLN
nsAEoJFp5lzQhN7craJP6Ed41mWYqVuoPId8AorRbrcWc+ZfwFSY1XS+wc3iEZGt
Ixg93eFyRJa0lV7Ae46ZeBZDE1ZXs6KzO7V33EByrKPrmzU+sQghoefEQzd5Mr61
55wsTLxDKZmOMNOsIeDjHfrYBzN2VAAiKrlNIC5waNrlU/yDXNOd8v9EDERm8tLj
vUYAGm0CuiVdjaExUd1URhxN25mW7xocBFymFe944Hn+Xds+qkxV/ZoVqW/hpvvf
cDDpw+5CRu3CkwWJ+n1jez/QcYF8AOiYrg54NMMl+68KnyBr3TsTjxKM4kEaSHpz
oHdpx7Zcf4LIHv5YGygrqGytXm3ABdJ7t+uA/iU3/gKbaKxCXcPu9czc8FB10jZp
nOZ7BN9uBmm23goJSFmH63sUYHpkqmlD75HHTOwY3WzvUy2MmeFe8nI+z1TIvWfs
pA9MRf/TuTAjB0yPEL+GltmZWrSZVxykzLsViVO6LAUP5MSeGbEYNNVMnbrt9x+v
JJUEeKgDu+6B5dpffItKoZB0JaezPkvILFa9x8jvOOJckvB595yEunQtYQEgfn7R
8k8HWV+LLUNS60YMlOH1Zkd5d9VUWx+tJDfLRVpOoERIyNiwmcUVhAn21klJwGW4
5hpxbqCo8YLoRT5s1gLXCmeDBVrJpBA=
-----END CERTIFICATE-----

OISTE WISeKey Global Root GC CA
================================================
SHA1 Fingerprint=E0:11:84:5E:34:DE:BE:88:81:B9:9C:F6:16:26:D1:96:1F:C3:B9:31
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            21:2a:56:0c:ae:da:0c:ab:40:45:bf:2b:a2:2d:3a:ea
    Signature Algorithm: ecdsa-with-SHA384
        Issuer: C=CH, O=WISeKey, OU=OISTE Foundation Endorsed, CN=OISTE WISeKey Global Root GC CA
        Validity
            Not Before: May  9 09:48:34 2017 GMT
            Not After : May  9 09:58:33 2042 GMT
        Subject: C=CH, O=WISeKey, OU=OISTE Foundation Endorsed, CN=OISTE WISeKey Global Root GC CA
        Subject Public Key Info:
            Public Key Algorithm: id-ecPublicKey
                Public-Key: (384 bit)
                pub: 
                    04:4c:e9:50:c0:c6:0f:72:18:bc:d8:f1:ba:b3:89:
                    e2:79:4a:a3:16:a7:6b:54:24:db:51:ff:ea:f4:09:
                    24:c3:0b:22:9f:cb:6a:27:82:81:0d:d2:c0:af:31:
                    e4:74:82:6e:ca:25:d9:8c:75:9d:f1:db:d0:9a:a2:
                    4b:21:7e:16:a7:63:90:d2:39:d4:b1:87:78:5f:18:
                    96:0f:50:1b:35:37:0f:6a:c6:dc:d9:13:4d:a4:8e:
                    90:37:e6:bd:5b:31:91
                ASN1 OID: secp384r1
        X509v3 extensions:
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Subject Key Identifier: 
                48:87:14:AC:E3:C3:9E:90:60:3A:D7:CA:89:EE:D3:AD:8C:B4:50:66
            1.3.6.1.4.1.311.21.1: 
                ...
    Signature Algorithm: ecdsa-with-SHA384
         30:65:02:30:26:c7:69:5b:dc:d5:e7:b2:e7:c8:0c:8c:8c:c3:
         dd:79:8c:1b:63:d5:c9:52:94:4e:4d:82:4a:73:1e:b2:80:84:
         a9:25:c0:4c:5a:6d:49:29:60:78:13:e2:7e:48:eb:64:02:31:
         00:db:34:20:32:08:ff:9a:49:02:b6:88:de:14:af:5d:6c:99:
         71:8d:1a:3f:8b:d7:e0:a2:36:86:1c:07:82:3a:76:53:fd:c2:
         a2:ed:ef:7b:b0:80:4f:58:0f:4b:53:39:bd
-----BEGIN CERTIFICATE-----
MIICaTCCAe+gAwIBAgIQISpWDK7aDKtARb8roi066jAKBggqhkjOPQQDAzBtMQsw
CQYDVQQGEwJDSDEQMA4GA1UEChMHV0lTZUtleTEiMCAGA1UECxMZT0lTVEUgRm91
bmRhdGlvbiBFbmRvcnNlZDEoMCYGA1UEAxMfT0lTVEUgV0lTZUtleSBHbG9iYWwg
Um9vdCBHQyBDQTAeFw0xNzA1MDkwOTQ4MzRaFw00MjA1MDkwOTU4MzNaMG0xCzAJ
BgNVBAYTAkNIMRAwDgYDVQQKEwdXSVNlS2V5MSIwIAYDVQQLExlPSVNURSBGb3Vu
ZGF0aW9uIEVuZG9yc2VkMSgwJgYDVQQDEx9PSVNURSBXSVNlS2V5IEdsb2JhbCBS
b290IEdDIENBMHYwEAYHKoZIzj0CAQYFK4EEACIDYgAETOlQwMYPchi82PG6s4ni
eUqjFqdrVCTbUf/q9Akkwwsin8tqJ4KBDdLArzHkdIJuyiXZjHWd8dvQmqJLIX4W
p2OQ0jnUsYd4XxiWD1AbNTcPasbc2RNNpI6QN+a9WzGRo1QwUjAOBgNVHQ8BAf8E
BAMCAQYwDwYDVR0TAQH/BAUwAwEB/zAdBgNVHQ4EFgQUSIcUrOPDnpBgOtfKie7T
rYy0UGYwEAYJKwYBBAGCNxUBBAMCAQAwCgYIKoZIzj0EAwMDaAAwZQIwJsdpW9zV
57LnyAyMjMPdeYwbY9XJUpROTYJKcx6ygISpJcBMWm1JKWB4E+J+SOtkAjEA2zQg
Mgj/mkkCtojeFK9dbJlxjRo/i9fgojaGHAeCOnZT/cKi7e97sIBPWA9LUzm9
-----END CERTIFICATE-----

GTS Root R1
=================================================
SHA1 Fingerprint=E1:C9:50:E6:EF:22:F8:4C:56:45:72:8B:92:20:60:D7:D5:A7:A3:E8
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            6e:47:a9:c5:4b:47:0c:0d:ec:33:d0:89:b9:1c:f4:e1
    Signature Algorithm: sha384WithRSAEncryption
        Issuer: C=US, O=Google Trust Services LLC, CN=GTS Root R1
        Validity
            Not Before: Jun 22 00:00:00 2016 GMT
            Not After : Jun 22 00:00:00 2036 GMT
        Subject: C=US, O=Google Trust Services LLC, CN=GTS Root R1
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (4096 bit)
                Modulus:
                    00:b6:11:02:8b:1e:e3:a1:77:9b:3b:dc:bf:94:3e:
                    b7:95:a7:40:3c:a1:fd:82:f9:7d:32:06:82:71:f6:
                    f6:8c:7f:fb:e8:db:bc:6a:2e:97:97:a3:8c:4b:f9:
                    2b:f6:b1:f9:ce:84:1d:b1:f9:c5:97:de:ef:b9:f2:
                    a3:e9:bc:12:89:5e:a7:aa:52:ab:f8:23:27:cb:a4:
                    b1:9c:63:db:d7:99:7e:f0:0a:5e:eb:68:a6:f4:c6:
                    5a:47:0d:4d:10:33:e3:4e:b1:13:a3:c8:18:6c:4b:
                    ec:fc:09:90:df:9d:64:29:25:23:07:a1:b4:d2:3d:
                    2e:60:e0:cf:d2:09:87:bb:cd:48:f0:4d:c2:c2:7a:
                    88:8a:bb:ba:cf:59:19:d6:af:8f:b0:07:b0:9e:31:
                    f1:82:c1:c0:df:2e:a6:6d:6c:19:0e:b5:d8:7e:26:
                    1a:45:03:3d:b0:79:a4:94:28:ad:0f:7f:26:e5:a8:
                    08:fe:96:e8:3c:68:94:53:ee:83:3a:88:2b:15:96:
                    09:b2:e0:7a:8c:2e:75:d6:9c:eb:a7:56:64:8f:96:
                    4f:68:ae:3d:97:c2:84:8f:c0:bc:40:c0:0b:5c:bd:
                    f6:87:b3:35:6c:ac:18:50:7f:84:e0:4c:cd:92:d3:
                    20:e9:33:bc:52:99:af:32:b5:29:b3:25:2a:b4:48:
                    f9:72:e1:ca:64:f7:e6:82:10:8d:e8:9d:c2:8a:88:
                    fa:38:66:8a:fc:63:f9:01:f9:78:fd:7b:5c:77:fa:
                    76:87:fa:ec:df:b1:0e:79:95:57:b4:bd:26:ef:d6:
                    01:d1:eb:16:0a:bb:8e:0b:b5:c5:c5:8a:55:ab:d3:
                    ac:ea:91:4b:29:cc:19:a4:32:25:4e:2a:f1:65:44:
                    d0:02:ce:aa:ce:49:b4:ea:9f:7c:83:b0:40:7b:e7:
                    43:ab:a7:6c:a3:8f:7d:89:81:fa:4c:a5:ff:d5:8e:
                    c3:ce:4b:e0:b5:d8:b3:8e:45:cf:76:c0:ed:40:2b:
                    fd:53:0f:b0:a7:d5:3b:0d:b1:8a:a2:03:de:31:ad:
                    cc:77:ea:6f:7b:3e:d6:df:91:22:12:e6:be:fa:d8:
                    32:fc:10:63:14:51:72:de:5d:d6:16:93:bd:29:68:
                    33:ef:3a:66:ec:07:8a:26:df:13:d7:57:65:78:27:
                    de:5e:49:14:00:a2:00:7f:9a:a8:21:b6:a9:b1:95:
                    b0:a5:b9:0d:16:11:da:c7:6c:48:3c:40:e0:7e:0d:
                    5a:cd:56:3c:d1:97:05:b9:cb:4b:ed:39:4b:9c:c4:
                    3f:d2:55:13:6e:24:b0:d6:71:fa:f4:c1:ba:cc:ed:
                    1b:f5:fe:81:41:d8:00:98:3d:3a:c8:ae:7a:98:37:
                    18:05:95
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Subject Key Identifier: 
                E4:AF:2B:26:71:1A:2B:48:27:85:2F:52:66:2C:EF:F0:89:13:71:3E
    Signature Algorithm: sha384WithRSAEncryption
         38:96:0a:ee:3d:b4:96:1e:5f:ef:9d:9c:0b:33:9f:2b:e0:ca:
         fd:d2:8e:0a:1f:41:74:a5:7c:aa:84:d4:e5:f2:1e:e6:37:52:
         32:9c:0b:d1:61:1d:bf:28:c1:b6:44:29:35:75:77:98:b2:7c:
         d9:bd:74:ac:8a:68:e3:a9:31:09:29:01:60:73:e3:47:7c:53:
         a8:90:4a:27:ef:4b:d7:9f:93:e7:82:36:ce:9a:68:0c:82:e7:
         cf:d4:10:16:6f:5f:0e:99:5c:f6:1f:71:7d:ef:ef:7b:2f:7e:
         ea:36:d6:97:70:0b:15:ee:d7:5c:56:6a:33:a5:e3:49:38:0c:
         b8:7d:fb:8d:85:a4:b1:59:5e:f4:6a:e1:dd:a1:f6:64:44:ae:
         e6:51:83:21:66:c6:11:3e:f3:ce:47:ee:9c:28:1f:25:da:ff:
         ac:66:95:dd:35:0f:5c:ef:20:2c:62:fd:91:ba:a9:cc:fc:5a:
         9c:93:81:83:29:97:4a:7c:5a:72:b4:39:d0:b7:77:cb:79:fd:
         69:3a:92:37:ed:6e:38:65:46:7e:e9:60:bd:79:88:97:5f:38:
         12:f4:ee:af:5b:82:c8:86:d5:e1:99:6d:8c:04:f2:76:ba:49:
         f6:6e:e9:6d:1e:5f:a0:ef:27:82:76:40:f8:a6:d3:58:5c:0f:
         2c:42:da:42:c6:7b:88:34:c7:c1:d8:45:9b:c1:3e:c5:61:1d:
         d9:63:50:49:f6:34:85:6a:e0:18:c5:6e:47:ab:41:42:29:9b:
         f6:60:0d:d2:31:d3:63:98:23:93:5a:00:81:48:b4:ef:cd:8a:
         cd:c9:cf:99:ee:d9:9e:aa:36:e1:68:4b:71:49:14:36:28:3a:
         3d:1d:ce:9a:8f:25:e6:80:71:61:2b:b5:7b:cc:f9:25:16:81:
         e1:31:5f:a1:a3:7e:16:a4:9c:16:6a:97:18:bd:76:72:a5:0b:
         9e:1d:36:e6:2f:a1:2f:be:70:91:0f:a8:e6:da:f8:c4:92:40:
         6c:25:7e:7b:b3:09:dc:b2:17:ad:80:44:f0:68:a5:8f:94:75:
         ff:74:5a:e8:a8:02:7c:0c:09:e2:a9:4b:0b:a0:85:0b:62:b9:
         ef:a1:31:92:fb:ef:f6:51:04:89:6c:e8:a9:74:a1:bb:17:b3:
         b5:fd:49:0f:7c:3c:ec:83:18:20:43:4e:d5:93:ba:b4:34:b1:
         1f:16:36:1f:0c:e6:64:39:16:4c:dc:e0:fe:1d:c8:a9:62:3d:
         40:ea:ca:c5:34:02:b4:ae:89:88:33:35:dc:2c:13:73:d8:27:
         f1:d0:72:ee:75:3b:22:de:98:68:66:5b:f1:c6:63:47:55:1c:
         ba:a5:08:51:75:a6:48:25
-----BEGIN CERTIFICATE-----
MIIFWjCCA0KgAwIBAgIQbkepxUtHDA3sM9CJuRz04TANBgkqhkiG9w0BAQwFADBH
MQswCQYDVQQGEwJVUzEiMCAGA1UEChMZR29vZ2xlIFRydXN0IFNlcnZpY2VzIExM
QzEUMBIGA1UEAxMLR1RTIFJvb3QgUjEwHhcNMTYwNjIyMDAwMDAwWhcNMzYwNjIy
MDAwMDAwWjBHMQswCQYDVQQGEwJVUzEiMCAGA1UEChMZR29vZ2xlIFRydXN0IFNl
cnZpY2VzIExMQzEUMBIGA1UEAxMLR1RTIFJvb3QgUjEwggIiMA0GCSqGSIb3DQEB
AQUAA4ICDwAwggIKAoICAQC2EQKLHuOhd5s73L+UPreVp0A8of2C+X0yBoJx9vaM
f/vo27xqLpeXo4xL+Sv2sfnOhB2x+cWX3u+58qPpvBKJXqeqUqv4IyfLpLGcY9vX
mX7wCl7raKb0xlpHDU0QM+NOsROjyBhsS+z8CZDfnWQpJSMHobTSPS5g4M/SCYe7
zUjwTcLCeoiKu7rPWRnWr4+wB7CeMfGCwcDfLqZtbBkOtdh+JhpFAz2weaSUKK0P
fyblqAj+lug8aJRT7oM6iCsVlgmy4HqMLnXWnOunVmSPlk9orj2XwoSPwLxAwAtc
vfaHszVsrBhQf4TgTM2S0yDpM7xSma8ytSmzJSq0SPly4cpk9+aCEI3oncKKiPo4
Zor8Y/kB+Xj9e1x3+naH+uzfsQ55lVe0vSbv1gHR6xYKu44LtcXFilWr06zqkUsp
zBmkMiVOKvFlRNACzqrOSbTqn3yDsEB750Orp2yjj32JgfpMpf/VjsPOS+C12LOO
Rc92wO1AK/1TD7Cn1TsNsYqiA94xrcx36m97PtbfkSIS5r762DL8EGMUUXLeXdYW
k70paDPvOmbsB4om3xPXV2V4J95eSRQAogB/mqghtqmxlbCluQ0WEdrHbEg8QOB+
DVrNVjzRlwW5y0vtOUucxD/SVRNuJLDWcfr0wbrM7Rv1/oFB2ACYPTrIrnqYNxgF
lQIDAQABo0IwQDAOBgNVHQ8BAf8EBAMCAQYwDwYDVR0TAQH/BAUwAwEB/zAdBgNV
HQ4EFgQU5K8rJnEaK0gnhS9SZizv8IkTcT4wDQYJKoZIhvcNAQEMBQADggIBADiW
Cu49tJYeX++dnAsznyvgyv3SjgofQXSlfKqE1OXyHuY3UjKcC9FhHb8owbZEKTV1
d5iyfNm9dKyKaOOpMQkpAWBz40d8U6iQSifvS9efk+eCNs6aaAyC58/UEBZvXw6Z
XPYfcX3v73svfuo21pdwCxXu11xWajOl40k4DLh9+42FpLFZXvRq4d2h9mREruZR
gyFmxhE+885H7pwoHyXa/6xmld01D1zvICxi/ZG6qcz8WpyTgYMpl0p8WnK0OdC3
d8t5/Wk6kjftbjhlRn7pYL15iJdfOBL07q9bgsiG1eGZbYwE8na6SfZu6W0eX6Dv
J4J2QPim01hcDyxC2kLGe4g0x8HYRZvBPsVhHdljUEn2NIVq4BjFbkerQUIpm/Zg
DdIx02OYI5NaAIFItO/Nis3Jz5nu2Z6qNuFoS3FJFDYoOj0dzpqPJeaAcWErtXvM
+SUWgeExX6GjfhaknBZqlxi9dnKlC54dNuYvoS++cJEPqOba+MSSQGwlfnuzCdyy
F62ARPBopY+Udf90WuioAnwMCeKpSwughQtiue+hMZL77/ZRBIls6Kl0obsXs7X9
SQ98POyDGCBDTtWTurQ0sR8WNh8M5mQ5Fkzc4P4dyKliPUDqysU0ArSuiYgzNdws
E3PYJ/HQcu51OyLemGhmW/HGY0dVHLqlCFF1pkgl
-----END CERTIFICATE-----

GTS Root R2
=================================================
SHA1 Fingerprint=D2:73:96:2A:2A:5E:39:9F:73:3F:E1:C7:1E:64:3F:03:38:34:FC:4D
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            6e:47:a9:c6:5a:b3:e7:20:c5:30:9a:3f:68:52:f2:6f
    Signature Algorithm: sha384WithRSAEncryption
        Issuer: C=US, O=Google Trust Services LLC, CN=GTS Root R2
        Validity
            Not Before: Jun 22 00:00:00 2016 GMT
            Not After : Jun 22 00:00:00 2036 GMT
        Subject: C=US, O=Google Trust Services LLC, CN=GTS Root R2
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (4096 bit)
                Modulus:
                    00:ce:de:fd:a6:fb:ec:ec:14:34:3c:07:06:5a:6c:
                    59:f7:19:35:dd:f7:c1:9d:55:aa:d3:cd:3b:a4:93:
                    72:ef:0a:fa:6d:9d:f6:f0:85:80:5b:a1:48:52:9f:
                    39:c5:b7:ee:28:ac:ef:cb:76:68:14:b9:df:ad:01:
                    6c:99:1f:c4:22:1d:9f:fe:72:77:e0:2c:5b:af:e4:
                    04:bf:4f:72:a0:1a:34:98:e8:39:68:ec:95:25:7b:
                    76:a1:e6:69:b9:85:19:bd:89:8c:fe:ad:ed:36:ea:
                    73:bc:ff:83:e2:cb:7d:c1:d2:ce:4a:b3:8d:05:9e:
                    8b:49:93:df:c1:5b:d0:6e:5e:f0:2e:30:2e:82:fc:
                    fa:bc:b4:17:0a:48:e5:88:9b:c5:9b:6b:de:b0:ca:
                    b4:03:f0:da:f4:90:b8:65:64:f7:5c:4c:ad:e8:7e:
                    66:5e:99:d7:b8:c2:3e:c8:d0:13:9d:ad:ee:e4:45:
                    7b:89:55:f7:8a:1f:62:52:84:12:b3:c2:40:97:e3:
                    8a:1f:47:91:a6:74:5a:d2:f8:b1:63:28:10:b8:b3:
                    09:b8:56:77:40:a2:26:98:79:c6:fe:df:25:ee:3e:
                    e5:a0:7f:d4:61:0f:51:4b:3c:3f:8c:da:e1:70:74:
                    d8:c2:68:a1:f9:c1:0c:e9:a1:e2:7f:bb:55:3c:76:
                    06:ee:6a:4e:cc:92:88:30:4d:9a:bd:4f:0b:48:9a:
                    84:b5:98:a3:d5:fb:73:c1:57:61:dd:28:56:75:13:
                    ae:87:8e:e7:0c:51:09:10:75:88:4c:bc:8d:f9:7b:
                    3c:d4:22:48:1f:2a:dc:eb:6b:bb:44:b1:cb:33:71:
                    32:46:af:ad:4a:f1:8c:e8:74:3a:ac:e7:1a:22:73:
                    80:d2:30:f7:25:42:c7:22:3b:3b:12:ad:96:2e:c6:
                    c3:76:07:aa:20:b7:35:49:57:e9:92:49:e8:76:16:
                    72:31:67:2b:96:7e:8a:a3:c7:94:56:22:bf:6a:4b:
                    7e:01:21:b2:23:32:df:e4:9a:44:6d:59:5b:5d:f5:
                    00:a0:1c:9b:c6:78:97:8d:90:ff:9b:c8:aa:b4:af:
                    11:51:39:5e:d9:fb:67:ad:d5:5b:11:9d:32:9a:1b:
                    bd:d5:ba:5b:a5:c9:cb:25:69:53:55:27:5c:e0:ca:
                    36:cb:88:61:fb:1e:b7:d0:cb:ee:16:fb:d3:a6:4c:
                    de:92:a5:d4:e2:df:f5:06:54:de:2e:9d:4b:b4:93:
                    30:aa:81:ce:dd:1a:dc:51:73:0d:4f:70:e9:e5:b6:
                    16:21:19:79:b2:e6:89:0b:75:64:ca:d5:ab:bc:09:
                    c1:18:a1:ff:d4:54:a1:85:3c:fd:14:24:03:b2:87:
                    d3:a4:b7
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Subject Key Identifier: 
                BB:FF:CA:8E:23:9F:4F:99:CA:DB:E2:68:A6:A5:15:27:17:1E:D9:0E
    Signature Algorithm: sha384WithRSAEncryption
         b6:69:f0:a6:77:fe:9e:ee:0b:81:ad:e1:c0:a9:c7:f9:35:1d:
         40:82:ab:e6:04:b4:df:cb:f7:1d:0f:83:f0:7e:13:4d:8d:8c:
         ee:e3:33:22:c3:39:fc:40:df:6e:41:4b:42:53:be:16:88:f1:
         d2:38:5e:c4:68:99:1c:98:52:93:8c:e7:68:ed:1b:6a:73:7a:
         05:40:4d:7f:65:3b:d6:58:f1:ce:83:47:60:e3:ff:97:a9:9c:
         60:77:18:55:b5:7e:08:93:cf:d0:f6:3c:67:03:15:61:09:f9:
         81:79:f5:ec:53:a4:9f:c9:8f:01:8b:73:c4:77:76:dc:83:a2:
         f5:0c:49:1a:a8:76:de:92:9b:64:f8:b3:2c:c5:27:d3:07:c0:
         08:80:a4:98:92:e3:01:96:02:aa:02:ee:8f:3b:c5:d1:6d:0a:
         33:30:73:78:b9:4f:54:16:bf:0b:07:a1:a4:5c:e6:cb:c9:5c:
         84:8f:0f:e0:15:77:2c:7e:26:7e:da:c4:4b:db:a7:16:77:07:
         b0:cd:75:e8:72:42:d6:95:84:9d:86:83:f2:e4:90:cd:09:47:
         d4:8b:03:70:da:5a:c6:03:42:f4:ed:37:a2:f0:1b:50:54:4b:
         0e:d8:84:de:19:28:99:81:47:ae:09:1b:3f:48:d1:c3:6f:e2:
         b0:60:17:f5:ee:23:02:a5:da:00:5b:6d:90:ab:ee:a2:e9:1b:
         3b:e9:c7:44:27:45:8e:6b:9f:f5:a4:84:bc:77:f9:6b:97:ac:
         3e:51:45:a2:11:a6:cc:85:ee:0a:68:f2:3e:50:38:7a:24:62:
         1e:17:20:37:6d:6a:4d:b7:09:9b:c9:fc:a4:58:f5:b6:fb:9c:
         4e:18:bb:95:02:e7:a1:ad:9b:07:ee:36:6b:24:d2:39:86:c1:
         93:83:50:d2:81:46:a8:5f:62:57:2c:bb:6c:64:88:08:6e:ef:
         13:54:5f:dd:2d:c4:67:63:d3:cf:89:37:bf:9d:20:f4:fb:7a:
         83:9b:a0:1e:81:00:50:c2:e4:0c:22:59:52:10:ed:43:56:87:
         00:f8:14:52:a7:1d:8b:93:8c:a2:4d:46:7f:27:c6:71:9b:24:
         de:e4:da:86:8b:0d:7e:6b:20:c1:c0:9e:e1:65:d8:6a:a3:a6:
         e8:85:8b:3a:07:08:1c:ba:f5:8f:55:9a:18:75:7e:e5:ec:81:
         66:d1:21:73:a1:35:44:0b:80:3d:5b:9c:5e:6f:2a:17:96:d1:
         83:23:88:66:6d:e6:86:e2:70:32:2f:52:22:e7:c8:e7:7f:c4:
         2c:60:5d:2f:c3:af:9e:45:05:c3:84:02:b7:fd:2c:08:52:4f:
         82:dd:a3:f0:d4:86:09:02
-----BEGIN CERTIFICATE-----
MIIFWjCCA0KgAwIBAgIQbkepxlqz5yDFMJo/aFLybzANBgkqhkiG9w0BAQwFADBH
MQswCQYDVQQGEwJVUzEiMCAGA1UEChMZR29vZ2xlIFRydXN0IFNlcnZpY2VzIExM
QzEUMBIGA1UEAxMLR1RTIFJvb3QgUjIwHhcNMTYwNjIyMDAwMDAwWhcNMzYwNjIy
MDAwMDAwWjBHMQswCQYDVQQGEwJVUzEiMCAGA1UEChMZR29vZ2xlIFRydXN0IFNl
cnZpY2VzIExMQzEUMBIGA1UEAxMLR1RTIFJvb3QgUjIwggIiMA0GCSqGSIb3DQEB
AQUAA4ICDwAwggIKAoICAQDO3v2m++zsFDQ8BwZabFn3GTXd98GdVarTzTukk3Lv
CvptnfbwhYBboUhSnznFt+4orO/LdmgUud+tAWyZH8QiHZ/+cnfgLFuv5AS/T3Kg
GjSY6Dlo7JUle3ah5mm5hRm9iYz+re026nO8/4Piy33B0s5Ks40FnotJk9/BW9Bu
XvAuMC6C/Pq8tBcKSOWIm8Wba96wyrQD8Nr0kLhlZPdcTK3ofmZemde4wj7I0BOd
re7kRXuJVfeKH2JShBKzwkCX44ofR5GmdFrS+LFjKBC4swm4VndAoiaYecb+3yXu
PuWgf9RhD1FLPD+M2uFwdNjCaKH5wQzpoeJ/u1U8dgbuak7MkogwTZq9TwtImoS1
mKPV+3PBV2HdKFZ1E66HjucMUQkQdYhMvI35ezzUIkgfKtzra7tEscszcTJGr61K
8YzodDqs5xoic4DSMPclQsciOzsSrZYuxsN2B6ogtzVJV+mSSeh2FnIxZyuWfoqj
x5RWIr9qS34BIbIjMt/kmkRtWVtd9QCgHJvGeJeNkP+byKq0rxFROV7Z+2et1VsR
nTKaG73VululycslaVNVJ1zgyjbLiGH7HrfQy+4W+9OmTN6SpdTi3/UGVN4unUu0
kzCqgc7dGtxRcw1PcOnlthYhGXmy5okLdWTK1au8CcEYof/UVKGFPP0UJAOyh9Ok
twIDAQABo0IwQDAOBgNVHQ8BAf8EBAMCAQYwDwYDVR0TAQH/BAUwAwEB/zAdBgNV
HQ4EFgQUu//KjiOfT5nK2+JopqUVJxce2Q4wDQYJKoZIhvcNAQEMBQADggIBALZp
8KZ3/p7uC4Gt4cCpx/k1HUCCq+YEtN/L9x0Pg/B+E02NjO7jMyLDOfxA325BS0JT
vhaI8dI4XsRomRyYUpOM52jtG2pzegVATX9lO9ZY8c6DR2Dj/5epnGB3GFW1fgiT
z9D2PGcDFWEJ+YF59exTpJ/JjwGLc8R3dtyDovUMSRqodt6Sm2T4syzFJ9MHwAiA
pJiS4wGWAqoC7o87xdFtCjMwc3i5T1QWvwsHoaRc5svJXISPD+AVdyx+Jn7axEvb
pxZ3B7DNdehyQtaVhJ2Gg/LkkM0JR9SLA3DaWsYDQvTtN6LwG1BUSw7YhN4ZKJmB
R64JGz9I0cNv4rBgF/XuIwKl2gBbbZCr7qLpGzvpx0QnRY5rn/WkhLx3+WuXrD5R
RaIRpsyF7gpo8j5QOHokYh4XIDdtak23CZvJ/KRY9bb7nE4Yu5UC56GtmwfuNmsk
0jmGwZODUNKBRqhfYlcsu2xkiAhu7xNUX90txGdj08+JN7+dIPT7eoOboB6BAFDC
5AwiWVIQ7UNWhwD4FFKnHYuTjKJNRn8nxnGbJN7k2oaLDX5rIMHAnuFl2GqjpuiF
izoHCBy69Y9Vmhh1fuXsgWbRIXOhNUQLgD1bnF5vKheW0YMjiGZt5obicDIvUiLn
yOd/xCxgXS/Dr55FBcOEArf9LAhST4Ldo/DUhgkC
-----END CERTIFICATE-----

GTS Root R3
=================================================
SHA1 Fingerprint=30:D4:24:6F:07:FF:DB:91:89:8A:0B:E9:49:66:11:EB:8C:5E:46:E5
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            6e:47:a9:c7:6c:a9:73:24:40:89:0f:03:55:dd:8d:1d
    Signature Algorithm: ecdsa-with-SHA384
        Issuer: C=US, O=Google Trust Services LLC, CN=GTS Root R3
        Validity
            Not Before: Jun 22 00:00:00 2016 GMT
            Not After : Jun 22 00:00:00 2036 GMT
        Subject: C=US, O=Google Trust Services LLC, CN=GTS Root R3
        Subject Public Key Info:
            Public Key Algorithm: id-ecPublicKey
                Public-Key: (384 bit)
                pub: 
                    04:1f:4f:33:87:33:29:8a:a1:84:de:cb:c7:21:58:
                    41:89:ea:56:9d:2b:4b:85:c6:1d:4c:27:bc:7f:26:
                    51:72:6f:e2:9f:d6:a3:ca:cc:45:14:46:8b:ad:ef:
                    7e:86:8c:ec:b1:7e:2f:ff:a9:71:9d:18:84:45:04:
                    41:55:6e:2b:ea:26:7f:bb:90:01:e3:4b:19:ba:e4:
                    54:96:45:09:b1:d5:6c:91:44:ad:84:13:8e:9a:8c:
                    0d:80:0c:32:f6:e0:27
                ASN1 OID: secp384r1
        X509v3 extensions:
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Subject Key Identifier: 
                C1:F1:26:BA:A0:2D:AE:85:81:CF:D3:F1:2A:12:BD:B8:0A:67:FD:BC
    Signature Algorithm: ecdsa-with-SHA384
         30:66:02:31:00:80:5b:a4:7c:23:c0:95:a5:2c:dc:be:89:6f:
         23:b9:a3:dd:65:00:52:5e:91:ac:c8:9d:72:74:82:53:0b:7d:
         a9:40:bd:68:60:c5:e1:b8:54:3b:c1:36:17:25:d8:c1:bd:02:
         31:00:9e:35:92:74:85:25:51:f5:24:ec:64:52:24:50:a5:1f:
         db:e8:cb:c9:76:ec:ec:82:6e:f5:85:18:53:e8:b8:e3:9a:29:
         aa:96:d3:83:23:c9:a4:7b:61:b3:cc:02:e8:5d
-----BEGIN CERTIFICATE-----
MIICDDCCAZGgAwIBAgIQbkepx2ypcyRAiQ8DVd2NHTAKBggqhkjOPQQDAzBHMQsw
CQYDVQQGEwJVUzEiMCAGA1UEChMZR29vZ2xlIFRydXN0IFNlcnZpY2VzIExMQzEU
MBIGA1UEAxMLR1RTIFJvb3QgUjMwHhcNMTYwNjIyMDAwMDAwWhcNMzYwNjIyMDAw
MDAwWjBHMQswCQYDVQQGEwJVUzEiMCAGA1UEChMZR29vZ2xlIFRydXN0IFNlcnZp
Y2VzIExMQzEUMBIGA1UEAxMLR1RTIFJvb3QgUjMwdjAQBgcqhkjOPQIBBgUrgQQA
IgNiAAQfTzOHMymKoYTey8chWEGJ6ladK0uFxh1MJ7x/JlFyb+Kf1qPKzEUURout
736GjOyxfi//qXGdGIRFBEFVbivqJn+7kAHjSxm65FSWRQmx1WyRRK2EE46ajA2A
DDL24CejQjBAMA4GA1UdDwEB/wQEAwIBBjAPBgNVHRMBAf8EBTADAQH/MB0GA1Ud
DgQWBBTB8Sa6oC2uhYHP0/EqEr24Cmf9vDAKBggqhkjOPQQDAwNpADBmAjEAgFuk
fCPAlaUs3L6JbyO5o91lAFJekazInXJ0glMLfalAvWhgxeG4VDvBNhcl2MG9AjEA
njWSdIUlUfUk7GRSJFClH9voy8l27OyCbvWFGFPouOOaKaqW04MjyaR7YbPMAuhd
-----END CERTIFICATE-----

GTS Root R4
=================================================
SHA1 Fingerprint=2A:1D:60:27:D9:4A:B1:0A:1C:4D:91:5C:CD:33:A0:CB:3E:2D:54:CB
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            6e:47:a9:c8:8b:94:b6:e8:bb:3b:2a:d8:a2:b2:c1:99
    Signature Algorithm: ecdsa-with-SHA384
        Issuer: C=US, O=Google Trust Services LLC, CN=GTS Root R4
        Validity
            Not Before: Jun 22 00:00:00 2016 GMT
            Not After : Jun 22 00:00:00 2036 GMT
        Subject: C=US, O=Google Trust Services LLC, CN=GTS Root R4
        Subject Public Key Info:
            Public Key Algorithm: id-ecPublicKey
                Public-Key: (384 bit)
                pub: 
                    04:f3:74:73:a7:68:8b:60:ae:43:b8:35:c5:81:30:
                    7b:4b:49:9d:fb:c1:61:ce:e6:de:46:bd:6b:d5:61:
                    18:35:ae:40:dd:73:f7:89:91:30:5a:eb:3c:ee:85:
                    7c:a2:40:76:3b:a9:c6:b8:47:d8:2a:e7:92:91:6a:
                    73:e9:b1:72:39:9f:29:9f:a2:98:d3:5f:5e:58:86:
                    65:0f:a1:84:65:06:d1:dc:8b:c9:c7:73:c8:8c:6a:
                    2f:e5:c4:ab:d1:1d:8a
                ASN1 OID: secp384r1
        X509v3 extensions:
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Subject Key Identifier: 
                80:4C:D6:EB:74:FF:49:36:A3:D5:D8:FC:B5:3E:C5:6A:F0:94:1D:8C
    Signature Algorithm: ecdsa-with-SHA384
         30:64:02:30:6a:50:52:74:08:c4:70:dc:9e:50:74:21:e8:8d:
         7a:21:c3:4f:96:6e:15:d1:22:35:61:2d:fa:08:37:ee:19:6d:
         ad:db:b2:cc:7d:07:34:f5:60:19:2c:b5:34:d9:6f:20:02:30:
         03:71:b1:ba:a3:60:0b:86:ed:9a:08:6a:95:68:9f:e2:b3:e1:
         93:64:7c:5e:93:a6:df:79:2d:8d:85:e3:94:cf:23:5d:71:cc:
         f2:b0:4d:d6:fe:99:c8:94:a9:75:a2:e3
-----BEGIN CERTIFICATE-----
MIICCjCCAZGgAwIBAgIQbkepyIuUtui7OyrYorLBmTAKBggqhkjOPQQDAzBHMQsw
CQYDVQQGEwJVUzEiMCAGA1UEChMZR29vZ2xlIFRydXN0IFNlcnZpY2VzIExMQzEU
MBIGA1UEAxMLR1RTIFJvb3QgUjQwHhcNMTYwNjIyMDAwMDAwWhcNMzYwNjIyMDAw
MDAwWjBHMQswCQYDVQQGEwJVUzEiMCAGA1UEChMZR29vZ2xlIFRydXN0IFNlcnZp
Y2VzIExMQzEUMBIGA1UEAxMLR1RTIFJvb3QgUjQwdjAQBgcqhkjOPQIBBgUrgQQA
IgNiAATzdHOnaItgrkO4NcWBMHtLSZ37wWHO5t5GvWvVYRg1rkDdc/eJkTBa6zzu
hXyiQHY7qca4R9gq55KRanPpsXI5nymfopjTX15YhmUPoYRlBtHci8nHc8iMai/l
xKvRHYqjQjBAMA4GA1UdDwEB/wQEAwIBBjAPBgNVHRMBAf8EBTADAQH/MB0GA1Ud
DgQWBBSATNbrdP9JNqPV2Py1PsVq8JQdjDAKBggqhkjOPQQDAwNnADBkAjBqUFJ0
CMRw3J5QdCHojXohw0+WbhXRIjVhLfoIN+4Zba3bssx9BzT1YBkstTTZbyACMANx
sbqjYAuG7ZoIapVon+Kz4ZNkfF6Tpt95LY2F45TPI11xzPKwTdb+mciUqXWi4w==
-----END CERTIFICATE-----

UCA Global G2 Root
================================================
SHA1 Fingerprint=28:F9:78:16:19:7A:FF:18:25:18:AA:44:FE:C1:A0:CE:5C:B6:4C:8A
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            5d:df:b1:da:5a:a3:ed:5d:be:5a:65:20:65:03:90:ef
    Signature Algorithm: sha256WithRSAEncryption
        Issuer: C=CN, O=UniTrust, CN=UCA Global G2 Root
        Validity
            Not Before: Mar 11 00:00:00 2016 GMT
            Not After : Dec 31 00:00:00 2040 GMT
        Subject: C=CN, O=UniTrust, CN=UCA Global G2 Root
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (4096 bit)
                Modulus:
                    00:c5:e6:2b:6f:7c:ef:26:05:27:a3:81:24:da:6f:
                    cb:01:f9:99:9a:a9:32:c2:22:87:61:41:91:3b:cb:
                    c3:68:1b:06:c5:4c:a9:2b:c1:67:17:22:1d:2b:ed:
                    f9:29:89:93:a2:78:bd:92:6b:a0:a3:0d:a2:7e:ca:
                    93:b3:a6:d1:8c:35:d5:75:f9:17:f6:cf:45:c5:e5:
                    7a:ec:77:93:a0:8f:23:ae:0e:1a:03:7f:be:d4:d0:
                    ed:2e:7b:ab:46:23:5b:ff:2c:e6:54:7a:94:c0:2a:
                    15:f0:c9:8d:b0:7a:3b:24:e1:d7:68:e2:31:3c:06:
                    33:46:b6:54:11:a6:a5:2f:22:54:2a:58:0d:01:02:
                    f1:fa:15:51:67:6c:c0:fa:d7:b6:1b:7f:d1:56:88:
                    2f:1a:3a:8d:3b:bb:82:11:e0:47:00:d0:52:87:ab:
                    fb:86:7e:0f:24:6b:40:9d:34:67:bc:8d:c7:2d:86:
                    6f:79:3e:8e:a9:3c:17:4b:7f:b0:99:e3:b0:71:60:
                    dc:0b:f5:64:c3:ce:43:bc:6d:71:b9:d2:de:27:5b:
                    8a:e8:d8:c6:ae:e1:59:7d:cf:28:2d:35:b8:95:56:
                    1a:f1:b2:58:4b:b7:12:37:c8:7c:b3:ed:4b:80:e1:
                    8d:fa:32:23:b6:6f:b7:48:95:08:b1:44:4e:85:8c:
                    3a:02:54:20:2f:df:bf:57:4f:3b:3a:90:21:d7:c1:
                    26:35:54:20:ec:c7:3f:47:ec:ef:5a:bf:4b:7a:c1:
                    ad:3b:17:50:5c:62:d8:0f:4b:4a:dc:2b:fa:6e:bc:
                    73:92:cd:ec:c7:50:e8:41:96:d7:a9:7e:6d:d8:e9:
                    1d:8f:8a:b5:b9:58:92:ba:4a:92:2b:0c:56:fd:80:
                    eb:08:f0:5e:29:6e:1b:1c:0c:af:8f:93:89:ad:db:
                    bd:a3:9e:21:ca:89:19:ec:df:b5:c3:1a:eb:16:fe:
                    78:36:4c:d6:6e:d0:3e:17:1c:90:17:6b:26:ba:fb:
                    7a:2f:bf:11:1c:18:0e:2d:73:03:8f:a0:e5:35:a0:
                    5a:e2:4c:75:1d:71:e1:39:38:53:78:40:cc:83:93:
                    d7:0a:9e:9d:5b:8f:8a:e4:e5:e0:48:e4:48:b2:47:
                    cd:4e:2a:75:2a:7b:f2:22:f6:c9:be:09:91:96:57:
                    7a:88:88:ac:ee:70:ac:f9:dc:29:e3:0c:1c:3b:12:
                    4e:44:d6:a7:4e:b0:26:c8:f3:d9:1a:97:91:68:ea:
                    ef:8d:46:06:d2:56:45:58:9a:3c:0c:0f:83:b8:05:
                    25:c3:39:cf:3b:a4:34:89:b7:79:12:2f:47:c5:e7:
                    a9:97:69:fc:a6:77:67:b5:df:7b:f1:7a:65:15:e4:
                    61:56:65
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Subject Key Identifier: 
                81:C4:8C:CC:F5:E4:30:FF:A5:0C:08:5F:8C:15:67:21:74:01:DF:DF
    Signature Algorithm: sha256WithRSAEncryption
         13:65:22:f5:8e:2b:ad:44:e4:cb:ff:b9:68:e6:c3:80:48:3d:
         04:7b:fa:23:2f:7a:ed:36:da:b2:ce:6d:f6:e6:9e:e5:5f:58:
         8f:cb:37:32:a1:c8:65:b6:ae:38:3d:35:1b:3e:bc:3b:b6:04:
         d0:bc:f9:49:f5:9b:f7:85:c5:36:b6:cb:bc:f8:c8:39:d5:e4:
         5f:07:bd:15:54:97:74:ca:ca:ed:4f:ba:ba:64:76:9f:81:b8:
         84:45:49:4c:8d:6f:a2:eb:b1:cc:d1:c3:94:da:44:c2:e6:e2:
         ea:18:e8:a2:1f:27:05:ba:d7:e5:d6:a9:cd:dd:ef:76:98:8d:
         00:0e:cd:1b:fa:03:b7:8e:80:58:0e:27:3f:52:fb:94:a2:ca:
         5e:65:c9:d6:84:da:b9:35:71:f3:26:c0:4f:77:e6:81:27:d2:
         77:3b:9a:14:6f:79:f4:f6:d0:e1:d3:94:ba:d0:57:51:bd:27:
         05:0d:c1:fd:c8:12:30:ee:6f:8d:11:2b:08:9d:d4:d4:bf:80:
         45:14:9a:88:44:da:30:ea:b4:a7:e3:ee:ef:5b:82:d5:3e:d6:
         ad:78:92:db:5c:3c:f3:d8:ad:fa:b8:6b:7f:c4:36:28:b6:02:
         15:8a:54:2c:9c:b0:17:73:8e:d0:37:a3:14:3c:98:95:00:0c:
         29:05:5b:9e:49:49:b1:5f:c7:e3:cb:cf:27:65:8e:35:17:b7:
         57:c8:30:d9:41:5b:b9:14:b6:e8:c2:0f:94:31:a7:94:98:cc:
         6a:eb:b5:e1:27:f5:10:a8:01:e8:8e:12:62:e8:88:cc:b5:7f:
         46:97:c0:9b:10:66:38:1a:36:46:5f:22:68:3d:df:c9:c6:13:
         27:ab:53:06:ac:a2:3c:86:06:65:6f:b1:7e:b1:29:44:9a:a3:
         ba:49:69:28:69:8f:d7:e5:5f:ad:04:86:64:6f:1a:a0:0c:c5:
         08:62:ce:80:a3:d0:f3:ec:68:de:be:33:c7:17:5b:7f:80:c4:
         4c:4c:b1:a6:84:8a:c3:3b:b8:09:cd:14:81:ba:18:e3:54:57:
         36:fe:db:2f:7c:47:a1:3a:33:c8:f9:58:3b:44:4f:b1:ca:02:
         89:04:96:28:68:c5:4b:b8:26:89:bb:d6:33:2f:50:d5:fe:9a:
         89:ba:18:32:92:54:c6:5b:e0:9d:f9:5e:e5:0d:22:9b:f6:da:
         e2:c8:21:b2:62:21:aa:86:40:b2:2e:64:d3:5f:c8:e3:7e:11:
         67:45:1f:05:fe:e3:a2:ef:b3:a8:b3:f3:7d:8f:f8:0c:1f:22:
         1f:2d:70:b4:b8:01:34:76:30:00:e5:23:78:a7:56:d7:50:1f:
         8a:fb:06:f5:c2:19:f0:d0
-----BEGIN CERTIFICATE-----
MIIFRjCCAy6gAwIBAgIQXd+x2lqj7V2+WmUgZQOQ7zANBgkqhkiG9w0BAQsFADA9
MQswCQYDVQQGEwJDTjERMA8GA1UECgwIVW5pVHJ1c3QxGzAZBgNVBAMMElVDQSBH
bG9iYWwgRzIgUm9vdDAeFw0xNjAzMTEwMDAwMDBaFw00MDEyMzEwMDAwMDBaMD0x
CzAJBgNVBAYTAkNOMREwDwYDVQQKDAhVbmlUcnVzdDEbMBkGA1UEAwwSVUNBIEds
b2JhbCBHMiBSb290MIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAxeYr
b3zvJgUno4Ek2m/LAfmZmqkywiKHYUGRO8vDaBsGxUypK8FnFyIdK+35KYmToni9
kmugow2ifsqTs6bRjDXVdfkX9s9FxeV67HeToI8jrg4aA3++1NDtLnurRiNb/yzm
VHqUwCoV8MmNsHo7JOHXaOIxPAYzRrZUEaalLyJUKlgNAQLx+hVRZ2zA+te2G3/R
VogvGjqNO7uCEeBHANBSh6v7hn4PJGtAnTRnvI3HLYZveT6OqTwXS3+wmeOwcWDc
C/Vkw85DvG1xudLeJ1uK6NjGruFZfc8oLTW4lVYa8bJYS7cSN8h8s+1LgOGN+jIj
tm+3SJUIsUROhYw6AlQgL9+/V087OpAh18EmNVQg7Mc/R+zvWr9LesGtOxdQXGLY
D0tK3Cv6brxzks3sx1DoQZbXqX5t2Okdj4q1uViSukqSKwxW/YDrCPBeKW4bHAyv
j5OJrdu9o54hyokZ7N+1wxrrFv54NkzWbtA+FxyQF2smuvt6L78RHBgOLXMDj6Dl
NaBa4kx1HXHhOThTeEDMg5PXCp6dW4+K5OXgSORIskfNTip1KnvyIvbJvgmRlld6
iIis7nCs+dwp4wwcOxJORNanTrAmyPPZGpeRaOrvjUYG0lZFWJo8DA+DuAUlwznP
O6Q0ibd5Ei9Hxeepl2n8pndntd978XplFeRhVmUCAwEAAaNCMEAwDgYDVR0PAQH/
BAQDAgEGMA8GA1UdEwEB/wQFMAMBAf8wHQYDVR0OBBYEFIHEjMz15DD/pQwIX4wV
ZyF0Ad/fMA0GCSqGSIb3DQEBCwUAA4ICAQATZSL1jiutROTL/7lo5sOASD0Ee/oj
L3rtNtqyzm325p7lX1iPyzcyochltq44PTUbPrw7tgTQvPlJ9Zv3hcU2tsu8+Mg5
1eRfB70VVJd0ysrtT7q6ZHafgbiERUlMjW+i67HM0cOU2kTC5uLqGOiiHycFutfl
1qnN3e92mI0ADs0b+gO3joBYDic/UvuUospeZcnWhNq5NXHzJsBPd+aBJ9J3O5oU
b3n09tDh05S60FdRvScFDcH9yBIw7m+NESsIndTUv4BFFJqIRNow6rSn4+7vW4LV
PtateJLbXDzz2K36uGt/xDYotgIVilQsnLAXc47QN6MUPJiVAAwpBVueSUmxX8fj
y88nZY41F7dXyDDZQVu5FLbowg+UMaeUmMxq67XhJ/UQqAHojhJi6IjMtX9Gl8Cb
EGY4GjZGXyJoPd/JxhMnq1MGrKI8hgZlb7F+sSlEmqO6SWkoaY/X5V+tBIZkbxqg
DMUIYs6Ao9Dz7GjevjPHF1t/gMRMTLGmhIrDO7gJzRSBuhjjVFc2/tsvfEehOjPI
+Vg7RE+xygKJBJYoaMVLuCaJu9YzL1DV/pqJuhgyklTGW+Cd+V7lDSKb9triyCGy
YiGqhkCyLmTTX8jjfhFnRR8F/uOi77Oos/N9j/gMHyIfLXC0uAE0djAA5SN4p1bX
UB+K+wb1whnw0A==
-----END CERTIFICATE-----

UCA Extended Validation Root
=================================================
SHA1 Fingerprint=A3:A1:B0:6F:24:61:23:4A:E3:36:A5:C2:37:FC:A6:FF:DD:F0:D7:3A
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            4f:d2:2b:8f:f5:64:c8:33:9e:4f:34:58:66:23:70:60
    Signature Algorithm: sha256WithRSAEncryption
        Issuer: C=CN, O=UniTrust, CN=UCA Extended Validation Root
        Validity
            Not Before: Mar 13 00:00:00 2015 GMT
            Not After : Dec 31 00:00:00 2038 GMT
        Subject: C=CN, O=UniTrust, CN=UCA Extended Validation Root
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (4096 bit)
                Modulus:
                    00:a9:09:07:28:13:02:b0:99:e0:64:aa:1e:43:16:
                    7a:73:b1:91:a0:75:3e:a8:fa:e3:38:00:7a:ec:89:
                    6a:20:0f:8b:c5:b0:9b:33:03:5a:86:c6:58:86:d5:
                    c1:85:bb:4f:c6:9c:40:4d:ca:be:ee:69:96:b8:ad:
                    81:30:9a:7c:92:05:eb:05:2b:9a:48:d0:b8:76:3e:
                    96:c8:20:bb:d2:b0:f1:8f:d8:ac:45:46:ff:aa:67:
                    60:b4:77:7e:6a:1f:3c:1a:52:7a:04:3d:07:3c:85:
                    0d:84:d0:1f:76:0a:f7:6a:14:df:72:e3:34:7c:57:
                    4e:56:01:3e:79:f1:aa:29:3b:6c:fa:f8:8f:6d:4d:
                    c8:35:df:ae:eb:dc:24:ee:79:45:a7:85:b6:05:88:
                    de:88:5d:25:7c:97:64:67:09:d9:bf:5a:15:05:86:
                    f3:09:1e:ec:58:32:33:11:f3:77:64:b0:76:1f:e4:
                    10:35:17:1b:f2:0e:b1:6c:a4:2a:a3:73:fc:09:1f:
                    1e:32:19:53:11:e7:d9:b3:2c:2e:76:2e:a1:a3:de:
                    7e:6a:88:09:e8:f2:07:8a:f8:b2:cd:10:e7:e2:73:
                    40:93:bb:08:d1:3f:e1:fc:0b:94:b3:25:ef:7c:a6:
                    d7:d1:af:9f:ff:96:9a:f5:91:7b:98:0b:77:d4:7e:
                    e8:07:d2:62:b5:95:39:e3:f3:f1:6d:0f:0e:65:84:
                    8a:63:54:c5:80:b6:e0:9e:4b:7d:47:26:a7:01:08:
                    5d:d1:88:9e:d7:c3:32:44:fa:82:4a:0a:68:54:7f:
                    38:53:03:cc:a4:00:33:64:51:59:0b:a3:82:91:7a:
                    5e:ec:16:c2:f3:2a:e6:62:da:2a:db:59:62:10:25:
                    4a:2a:81:0b:47:07:43:06:70:87:d2:fa:93:11:29:
                    7a:48:4d:eb:94:c7:70:4d:af:67:d5:51:b1:80:20:
                    01:01:b4:7a:08:a6:90:7f:4e:e0:ef:07:41:87:af:
                    6a:a5:5e:8b:fb:cf:50:b2:9a:54:af:c3:89:ba:58:
                    2d:f5:30:98:b1:36:72:39:7e:49:04:fd:29:a7:4c:
                    79:e4:05:57:db:94:b9:16:53:8d:46:b3:1d:95:61:
                    57:56:7f:af:f0:16:5b:61:58:6f:36:50:11:0b:d8:
                    ac:2b:95:16:1a:0e:1f:08:cd:36:34:65:10:62:66:
                    d5:80:5f:14:20:5f:2d:0c:a0:78:0a:68:d6:2c:d7:
                    e9:6f:2b:d2:4a:05:93:fc:9e:6f:6b:67:ff:88:f1:
                    4e:a5:69:4a:52:37:05:ea:c6:16:8d:d2:c4:99:d1:
                    82:2b:3b:ba:35:75:f7:51:51:58:f3:c8:07:dd:e4:
                    b4:03:7f
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Subject Key Identifier: 
                D9:74:3A:E4:30:3D:0D:F7:12:DC:7E:5A:05:9F:1E:34:9A:F7:E1:14
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Key Usage: critical
                Digital Signature, Certificate Sign, CRL Sign
    Signature Algorithm: sha256WithRSAEncryption
         36:8d:97:cc:42:15:64:29:37:9b:26:2c:d6:fb:ae:15:69:2c:
         6b:1a:1a:f7:5f:b6:f9:07:4c:59:ea:f3:c9:c8:b9:ae:cc:ba:
         2e:7a:dc:c0:f5:b0:2d:c0:3b:af:9f:70:05:11:6a:9f:25:4f:
         01:29:70:e3:e5:0c:e1:ea:5a:7c:dc:49:bb:c1:1e:2a:81:f5:
         16:4b:72:91:c8:a2:31:b9:aa:da:fc:9d:1f:f3:5d:40:02:13:
         fc:4e:1c:06:ca:b3:14:90:54:17:19:12:1a:f1:1f:d7:0c:69:
         5a:f6:71:78:f4:94:7d:91:0b:8e:ec:90:54:8e:bc:6f:a1:4c:
         ab:fc:74:64:fd:71:9a:f8:41:07:a1:cd:91:e4:3c:9a:e0:9b:
         32:39:73:ab:2a:d5:69:c8:78:91:26:31:7d:e2:c7:30:f1:fc:
         14:78:77:12:0e:13:f4:dd:16:94:bf:4b:67:7b:70:53:85:ca:
         b0:bb:f3:38:4d:2c:90:39:c0:0d:c2:5d:6b:e9:e2:e5:d5:88:
         8d:d6:2c:bf:ab:1b:be:b5:28:87:12:17:74:6e:fc:7d:fc:8f:
         d0:87:26:b0:1b:fb:b9:6c:ab:e2:9e:3d:15:c1:3b:2e:67:02:
         58:91:9f:ef:f8:42:1f:2c:b7:68:f5:75:ad:cf:b5:f6:ff:11:
         7d:c2:f0:24:a5:ad:d3:fa:a0:3c:a9:fa:5d:dc:a5:a0:ef:44:
         a4:be:d6:e8:e5:e4:13:96:17:7b:06:3e:32:ed:c7:b7:42:bc:
         76:a3:d8:65:38:2b:38:35:51:21:0e:0e:6f:2e:34:13:40:e1:
         2b:67:0c:6d:4a:41:30:18:23:5a:32:55:99:c9:17:e0:3c:de:
         f6:ec:79:ad:2b:58:19:a2:ad:2c:22:1a:95:8e:be:96:90:5d:
         42:57:c4:f9:14:03:35:2b:1c:2d:51:57:08:a7:3a:de:3f:e4:
         c8:b4:03:73:c2:c1:26:80:bb:0b:42:1f:ad:0d:af:26:72:da:
         cc:be:b3:a3:83:58:0d:82:c5:1f:46:51:e3:9c:18:cc:8d:9b:
         8d:ec:49:eb:75:50:d5:8c:28:59:ca:74:34:da:8c:0b:21:ab:
         1e:ea:1b:e5:c7:fd:15:3e:c0:17:aa:fb:23:6e:26:46:cb:fa:
         f9:b1:72:6b:69:cf:22:84:0b:62:0f:ac:d9:19:00:94:a2:76:
         3c:d4:2d:9a:ed:04:9e:2d:06:62:10:37:52:1c:85:72:1b:27:
         e5:cc:c6:31:ec:37:ec:63:59:9b:0b:1d:76:cc:7e:32:9a:88:
         95:08:36:52:bb:de:76:5f:76:49:49:ad:7f:bd:65:20:b2:c9:
         c1:2b:76:18:76:9f:56:b1
-----BEGIN CERTIFICATE-----
MIIFWjCCA0KgAwIBAgIQT9Irj/VkyDOeTzRYZiNwYDANBgkqhkiG9w0BAQsFADBH
MQswCQYDVQQGEwJDTjERMA8GA1UECgwIVW5pVHJ1c3QxJTAjBgNVBAMMHFVDQSBF
eHRlbmRlZCBWYWxpZGF0aW9uIFJvb3QwHhcNMTUwMzEzMDAwMDAwWhcNMzgxMjMx
MDAwMDAwWjBHMQswCQYDVQQGEwJDTjERMA8GA1UECgwIVW5pVHJ1c3QxJTAjBgNV
BAMMHFVDQSBFeHRlbmRlZCBWYWxpZGF0aW9uIFJvb3QwggIiMA0GCSqGSIb3DQEB
AQUAA4ICDwAwggIKAoICAQCpCQcoEwKwmeBkqh5DFnpzsZGgdT6o+uM4AHrsiWog
D4vFsJszA1qGxliG1cGFu0/GnEBNyr7uaZa4rYEwmnySBesFK5pI0Lh2PpbIILvS
sPGP2KxFRv+qZ2C0d35qHzwaUnoEPQc8hQ2E0B92CvdqFN9y4zR8V05WAT558aop
O2z6+I9tTcg1367r3CTueUWnhbYFiN6IXSV8l2RnCdm/WhUFhvMJHuxYMjMR83dk
sHYf5BA1FxvyDrFspCqjc/wJHx4yGVMR59mzLC52LqGj3n5qiAno8geK+LLNEOfi
c0CTuwjRP+H8C5SzJe98ptfRr5//lpr1kXuYC3fUfugH0mK1lTnj8/FtDw5lhIpj
VMWAtuCeS31HJqcBCF3RiJ7XwzJE+oJKCmhUfzhTA8ykADNkUVkLo4KRel7sFsLz
KuZi2irbWWIQJUoqgQtHB0MGcIfS+pMRKXpITeuUx3BNr2fVUbGAIAEBtHoIppB/
TuDvB0GHr2qlXov7z1CymlSvw4m6WC31MJixNnI5fkkE/SmnTHnkBVfblLkWU41G
sx2VYVdWf6/wFlthWG82UBEL2KwrlRYaDh8IzTY0ZRBiZtWAXxQgXy0MoHgKaNYs
1+lvK9JKBZP8nm9rZ/+I8U6laUpSNwXqxhaN0sSZ0YIrO7o1dfdRUVjzyAfd5LQD
fwIDAQABo0IwQDAdBgNVHQ4EFgQU2XQ65DA9DfcS3H5aBZ8eNJr34RQwDwYDVR0T
AQH/BAUwAwEB/zAOBgNVHQ8BAf8EBAMCAYYwDQYJKoZIhvcNAQELBQADggIBADaN
l8xCFWQpN5smLNb7rhVpLGsaGvdftvkHTFnq88nIua7Mui563MD1sC3AO6+fcAUR
ap8lTwEpcOPlDOHqWnzcSbvBHiqB9RZLcpHIojG5qtr8nR/zXUACE/xOHAbKsxSQ
VBcZEhrxH9cMaVr2cXj0lH2RC47skFSOvG+hTKv8dGT9cZr4QQehzZHkPJrgmzI5
c6sq1WnIeJEmMX3ixzDx/BR4dxIOE/TdFpS/S2d7cFOFyrC78zhNLJA5wA3CXWvp
4uXViI3WLL+rG761KIcSF3Ru/H38j9CHJrAb+7lsq+KePRXBOy5nAliRn+/4Qh8s
t2j1da3Ptfb/EX3C8CSlrdP6oDyp+l3cpaDvRKS+1ujl5BOWF3sGPjLtx7dCvHaj
2GU4Kzg1USEODm8uNBNA4StnDG1KQTAYI1oyVZnJF+A83vbsea0rWBmirSwiGpWO
vpaQXUJXxPkUAzUrHC1RVwinOt4/5Mi0A3PCwSaAuwtCH60NryZy2sy+s6ODWA2C
xR9GUeOcGMyNm43sSet1UNWMKFnKdDTajAshqx7qG+XH/RU+wBeq+yNuJkbL+vmx
cmtpzyKEC2IPrNkZAJSidjzULZrtBJ4tBmIQN1IchXIbJ+XMxjHsN+xjWZsLHXbM
fjKaiJUINlK73nZfdklJrX+9ZSCyycErdhh2n1ax
-----END CERTIFICATE-----

Certigna Root CA
================================================
SHA1 Fingerprint=2D:0D:52:14:FF:9E:AD:99:24:01:74:20:47:6E:6C:85:27:27:F5:43
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            ca:e9:1b:89:f1:55:03:0d:a3:e6:41:6d:c4:e3:a6:e1
    Signature Algorithm: sha256WithRSAEncryption
        Issuer: C=FR, O=Dhimyotis, OU=0002 48146308100036, CN=Certigna Root CA
        Validity
            Not Before: Oct  1 08:32:27 2013 GMT
            Not After : Oct  1 08:32:27 2033 GMT
        Subject: C=FR, O=Dhimyotis, OU=0002 48146308100036, CN=Certigna Root CA
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (4096 bit)
                Modulus:
                    00:cd:18:39:65:1a:59:b1:ea:64:16:0e:8c:94:24:
                    95:7c:83:d3:c5:39:26:dc:0c:ef:16:57:8d:d7:d8:
                    ac:a3:42:7f:82:ca:ed:cd:5b:db:0e:b7:2d:ed:45:
                    08:17:b2:d9:b3:cb:d6:17:52:72:28:db:8e:4e:9e:
                    8a:b6:0b:f9:9e:84:9a:4d:76:de:22:29:5c:d2:b3:
                    d2:06:3e:30:39:a9:74:a3:92:56:1c:a1:6f:4c:0a:
                    20:6d:9f:23:7a:b4:c6:da:2c:e4:1d:2c:dc:b3:28:
                    d0:13:f2:4c:4e:02:49:a1:54:40:9e:e6:e5:05:a0:
                    2d:84:c8:ff:98:6c:d0:eb:8a:1a:84:08:1e:b7:68:
                    23:ee:23:d5:70:ce:6d:51:69:10:ee:a1:7a:c2:d1:
                    22:31:c2:82:85:d2:f2:55:76:50:7c:25:7a:c9:84:
                    5c:0b:ac:dd:42:4e:2b:e7:82:a2:24:89:cb:90:b2:
                    d0:ee:23:ba:66:4c:bb:62:a4:f9:53:5a:64:7b:7c:
                    98:fa:a3:48:9e:0f:95:ae:a7:18:f4:6a:ec:2e:03:
                    45:af:f0:74:f8:2a:cd:7a:5d:d1:be:44:26:32:29:
                    f1:f1:f5:6c:cc:7e:02:21:0b:9f:6f:a4:3f:be:9d:
                    53:e2:cf:7d:a9:2c:7c:58:1a:97:e1:3d:37:37:18:
                    66:28:d2:40:c5:51:8a:8c:c3:2d:ce:53:88:24:58:
                    64:30:16:c5:aa:e0:d6:0a:a6:40:df:78:f6:f5:04:
                    7c:69:13:84:bc:d1:d1:a7:06:cf:01:f7:68:c0:a8:
                    57:bb:3a:61:ad:04:8c:93:e3:ad:fc:f0:db:44:6d:
                    59:dc:49:59:ae:ac:9a:99:36:30:41:7b:76:33:22:
                    87:a3:c2:92:86:6e:f9:70:ee:ae:87:87:95:1b:c4:
                    7a:bd:31:f3:d4:d2:e5:99:ff:be:48:ec:75:f5:78:
                    16:1d:a6:70:c1:7f:3c:1b:a1:92:fb:cf:c8:3c:d6:
                    c5:93:0a:8f:f5:55:3a:76:95:ce:59:98:8a:09:95:
                    77:32:9a:83:ba:2c:04:3a:97:bd:d4:2f:be:d7:6c:
                    9b:a2:ca:7d:6d:26:c9:55:d5:cf:c3:79:52:08:09:
                    99:07:24:2d:64:25:6b:a6:21:69:9b:6a:dd:74:4d:
                    6b:97:7a:41:bd:ab:17:f9:90:17:48:8f:36:f9:2d:
                    d5:c5:db:ee:aa:85:45:41:fa:cd:3a:45:b1:68:e6:
                    36:4c:9b:90:57:ec:23:b9:87:08:c2:c4:09:f1:97:
                    86:2a:28:4d:e2:74:c0:da:c4:8c:db:df:e2:a1:17:
                    59:ce:24:59:74:31:da:7f:fd:30:6d:d9:dc:e1:6a:
                    e1:fc:5f
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Subject Key Identifier: 
                18:87:56:E0:6E:77:EE:24:35:3C:4E:73:9A:1F:D6:E1:E2:79:7E:2B
            X509v3 Authority Key Identifier: 
                keyid:18:87:56:E0:6E:77:EE:24:35:3C:4E:73:9A:1F:D6:E1:E2:79:7E:2B

            X509v3 Certificate Policies: 
                Policy: X509v3 Any Policy
                  CPS: https://wwww.certigna.fr/autorites/

            X509v3 CRL Distribution Points: 

                Full Name:
                  URI:http://crl.certigna.fr/certignarootca.crl

                Full Name:
                  URI:http://crl.dhimyotis.com/certignarootca.crl

    Signature Algorithm: sha256WithRSAEncryption
         94:b8:9e:4f:f0:e3:95:08:22:e7:cd:68:41:f7:1c:55:d5:7c:
         00:e2:2d:3a:89:5d:68:38:2f:51:22:0b:4a:8d:cb:e9:bb:5d:
         3e:bb:5c:3d:b1:28:fe:e4:53:55:13:cf:a1:90:1b:02:1d:5f:
         66:46:09:33:28:e1:0d:24:97:70:d3:10:1f:ea:64:57:96:bb:
         5d:da:e7:c4:8c:4f:4c:64:46:1d:5c:87:e3:59:de:42:d1:9b:
         a8:7e:a6:89:dd:8f:1c:c9:30:82:ed:3b:9c:cd:c0:e9:19:e0:
         6a:d8:02:75:37:ab:f7:34:28:28:91:f2:04:0a:4f:35:e3:60:
         26:01:fa:d0:11:8c:f9:11:6a:ee:af:3d:c3:50:d3:8f:5f:33:
         79:3c:86:a8:73:45:90:8c:20:b6:72:73:17:23:be:07:65:e5:
         78:92:0d:ba:01:c0:eb:8c:1c:66:bf:ac:86:77:01:94:0d:9c:
         e6:e9:39:8d:1f:a6:51:8c:99:0c:39:77:e1:b4:9b:fa:1c:67:
         57:6f:6a:6a:8e:a9:2b:4c:57:79:7a:57:22:cf:cd:5f:63:46:
         8d:5c:59:3a:86:f8:32:47:62:a3:67:0d:18:91:dc:fb:a6:6b:
         f5:48:61:73:23:59:8e:02:a7:bc:44:ea:f4:49:9d:f1:54:58:
         f9:60:af:da:18:a4:2f:28:45:dc:7a:a0:88:86:5d:f3:3b:e7:
         ff:29:35:80:fc:64:43:94:e6:e3:1c:6f:be:ad:0e:2a:63:99:
         2b:c9:7e:85:f6:71:e8:06:03:95:fe:de:8f:48:1c:5a:d4:92:
         e8:2b:ee:e7:31:db:ba:04:6a:87:98:e7:c5:5f:ef:7d:a7:22:
         f7:01:d8:4d:f9:89:d0:0e:9a:05:59:a4:9e:98:d9:6f:2b:ca:
         70:be:64:c2:55:a3:f4:e9:af:c3:92:29:dc:88:16:24:99:3c:
         8d:26:98:b6:5b:b7:cc:ce:b7:37:07:fd:26:d9:98:85:24:ff:
         59:23:03:9a:ed:9d:9d:a8:e4:5e:38:ce:d7:52:0d:6f:d2:3f:
         6d:b1:05:6b:49:ce:8a:91:46:73:f4:f6:2f:f0:a8:73:77:0e:
         65:ac:a1:8d:66:52:69:7e:4b:68:0c:c7:1e:37:27:83:a5:8c:
         c7:02:e4:14:cd:49:01:b0:73:b3:fd:c6:90:3a:6f:d2:6c:ed:
         3b:ee:ec:91:be:a2:43:5d:8b:00:4a:66:25:44:70:de:40:0f:
         f8:7c:15:f7:a2:ce:3c:d7:5e:13:8c:81:17:18:17:d1:bd:f1:
         77:10:3a:d4:65:39:c1:27:ac:57:2c:25:54:ff:a2:da:4f:8a:
         61:39:5e:ae:3d:4a:8c:bd
-----BEGIN CERTIFICATE-----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=
-----END CERTIFICATE-----

emSign Root CA - G1
================================================
SHA1 Fingerprint=8A:C7:AD:8F:73:AC:4E:C1:B5:75:4D:A5:40:F4:FC:CF:7C:B5:8E:8C
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            31:f5:e4:62:0c:6c:58:ed:d6:d8
    Signature Algorithm: sha256WithRSAEncryption
        Issuer: C=IN, OU=emSign PKI, O=eMudhra Technologies Limited, CN=emSign Root CA - G1
        Validity
            Not Before: Feb 18 18:30:00 2018 GMT
            Not After : Feb 18 18:30:00 2043 GMT
        Subject: C=IN, OU=emSign PKI, O=eMudhra Technologies Limited, CN=emSign Root CA - G1
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (2048 bit)
                Modulus:
                    00:93:4b:bb:e9:66:8a:ee:9d:5b:d5:34:93:d0:1b:
                    1e:c3:e7:9e:b8:64:33:7f:63:78:68:b4:cd:2e:71:
                    75:d7:9b:20:c6:4d:29:bc:b6:68:60:8a:f7:21:9a:
                    56:35:5a:f3:76:bd:d8:cd:9a:ff:93:56:4b:a5:59:
                    06:a1:93:34:29:dd:16:34:75:4e:f2:81:b4:c7:96:
                    4e:ad:19:15:52:4a:fe:3c:70:75:70:cd:af:2b:ab:
                    15:9a:33:3c:aa:b3:8b:aa:cd:43:fd:f5:ea:70:ff:
                    ed:cf:11:3b:94:ce:4e:32:16:d3:23:40:2a:77:b3:
                    af:3c:01:2c:6c:ed:99:2c:8b:d9:4e:69:98:b2:f7:
                    8f:41:b0:32:78:61:d6:0d:5f:c3:fa:a2:40:92:1d:
                    5c:17:e6:70:3e:35:e7:a2:b7:c2:62:e2:ab:a4:38:
                    4c:b5:39:35:6f:ea:03:69:fa:3a:54:68:85:6d:d6:
                    f2:2f:43:55:1e:91:0d:0e:d8:d5:6a:a4:96:d1:13:
                    3c:2c:78:50:e8:3a:92:d2:17:56:e5:35:1a:40:1c:
                    3e:8d:2c:ed:39:df:42:e0:83:41:74:df:a3:cd:c2:
                    86:60:48:68:e3:69:0b:54:00:8b:e4:76:69:21:0d:
                    79:4e:34:08:5e:14:c2:cc:b1:b7:ad:d7:7c:70:8a:
                    c7:85
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Subject Key Identifier: 
                FB:EF:0D:86:9E:B0:E3:DD:A9:B9:F1:21:17:7F:3E:FC:F0:77:2B:1A
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
    Signature Algorithm: sha256WithRSAEncryption
         59:ff:f2:8c:f5:87:7d:71:3d:a3:9f:1b:5b:d1:da:f8:d3:9c:
         6b:36:bd:9b:a9:61:eb:de:16:2c:74:3d:9e:e6:75:da:d7:ba:
         a7:bc:42:17:e7:3d:91:eb:e5:7d:dd:3e:9c:f1:cf:92:ac:6c:
         48:cc:c2:22:3f:69:3b:c5:b6:15:2f:a3:35:c6:68:2a:1c:57:
         af:39:ef:8d:d0:35:c3:18:0c:7b:00:56:1c:cd:8b:19:74:de:
         be:0f:12:e0:d0:aa:a1:3f:02:34:b1:70:ce:9d:18:d6:08:03:
         09:46:ee:60:e0:7e:b6:c4:49:04:51:7d:70:60:bc:aa:b2:ff:
         79:72:7a:a6:1d:3d:5f:2a:f8:ca:e2:fd:39:b7:47:b9:eb:7e:
         df:04:23:af:fa:9c:06:07:e9:fb:63:93:80:40:b5:c6:6c:0a:
         31:28:ce:0c:9f:cf:b3:23:35:80:41:8d:6c:c4:37:7b:81:2f:
         80:a1:40:42:85:e9:d9:38:8d:e8:a1:53:cd:01:bf:69:e8:5a:
         06:f2:45:0b:90:fa:ae:e1:bf:9d:f2:ae:57:3c:a5:ae:b2:56:
         f4:8b:65:40:e9:fd:31:81:2c:f4:39:09:d8:ee:6b:a7:b4:a6:
         1d:15:a5:98:f7:01:81:d8:85:7d:f3:51:5c:71:88:de:ba:cc:
         1f:80:7e:4a
-----BEGIN CERTIFICATE-----
MIIDlDCCAnygAwIBAgIKMfXkYgxsWO3W2DANBgkqhkiG9w0BAQsFADBnMQswCQYD
VQQGEwJJTjETMBEGA1UECxMKZW1TaWduIFBLSTElMCMGA1UEChMcZU11ZGhyYSBU
ZWNobm9sb2dpZXMgTGltaXRlZDEcMBoGA1UEAxMTZW1TaWduIFJvb3QgQ0EgLSBH
MTAeFw0xODAyMTgxODMwMDBaFw00MzAyMTgxODMwMDBaMGcxCzAJBgNVBAYTAklO
MRMwEQYDVQQLEwplbVNpZ24gUEtJMSUwIwYDVQQKExxlTXVkaHJhIFRlY2hub2xv
Z2llcyBMaW1pdGVkMRwwGgYDVQQDExNlbVNpZ24gUm9vdCBDQSAtIEcxMIIBIjAN
BgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAk0u76WaK7p1b1TST0Bsew+eeuGQz
f2N4aLTNLnF115sgxk0pvLZoYIr3IZpWNVrzdr3YzZr/k1ZLpVkGoZM0Kd0WNHVO
8oG0x5ZOrRkVUkr+PHB1cM2vK6sVmjM8qrOLqs1D/fXqcP/tzxE7lM5OMhbTI0Aq
d7OvPAEsbO2ZLIvZTmmYsvePQbAyeGHWDV/D+qJAkh1cF+ZwPjXnorfCYuKrpDhM
tTk1b+oDafo6VGiFbdbyL0NVHpENDtjVaqSW0RM8LHhQ6DqS0hdW5TUaQBw+jSzt
Od9C4INBdN+jzcKGYEho42kLVACL5HZpIQ15TjQIXhTCzLG3rdd8cIrHhQIDAQAB
o0IwQDAdBgNVHQ4EFgQU++8Nhp6w492pufEhF38+/PB3KxowDgYDVR0PAQH/BAQD
AgEGMA8GA1UdEwEB/wQFMAMBAf8wDQYJKoZIhvcNAQELBQADggEBAFn/8oz1h31x
PaOfG1vR2vjTnGs2vZupYeveFix0PZ7mddrXuqe8QhfnPZHr5X3dPpzxz5KsbEjM
wiI/aTvFthUvozXGaCocV685743QNcMYDHsAVhzNixl03r4PEuDQqqE/AjSxcM6d
GNYIAwlG7mDgfrbESQRRfXBgvKqy/3lyeqYdPV8q+Mri/Tm3R7nrft8EI6/6nAYH
6ftjk4BAtcZsCjEozgyfz7MjNYBBjWzEN3uBL4ChQEKF6dk4jeihU80Bv2noWgby
RQuQ+q7hv53yrlc8pa6yVvSLZUDp/TGBLPQ5Cdjua6e0ph0VpZj3AYHYhX3zUVxx
iN66zB+Afko=
-----END CERTIFICATE-----

emSign ECC Root CA - G3
================================================
SHA1 Fingerprint=30:43:FA:4F:F2:57:DC:A0:C3:80:EE:2E:58:EA:78:B2:3F:E6:BB:C1
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            3c:f6:07:a9:68:70:0e:da:8b:84
    Signature Algorithm: ecdsa-with-SHA384
        Issuer: C=IN, OU=emSign PKI, O=eMudhra Technologies Limited, CN=emSign ECC Root CA - G3
        Validity
            Not Before: Feb 18 18:30:00 2018 GMT
            Not After : Feb 18 18:30:00 2043 GMT
        Subject: C=IN, OU=emSign PKI, O=eMudhra Technologies Limited, CN=emSign ECC Root CA - G3
        Subject Public Key Info:
            Public Key Algorithm: id-ecPublicKey
                Public-Key: (384 bit)
                pub: 
                    04:23:a5:0c:b8:2d:12:f5:28:f3:b1:b2:dd:e2:02:
                    12:80:9e:39:5f:49:4d:9f:c9:25:34:59:74:ec:bb:
                    06:1c:e7:c0:72:af:e8:ae:2f:e1:41:54:87:14:a8:
                    4a:b2:e8:7c:82:e6:5b:6a:b5:dc:b3:75:ce:8b:06:
                    d0:86:23:bf:46:d5:8e:0f:3f:04:f4:d7:1c:92:7e:
                    f6:a5:63:c2:f5:5f:8e:2e:4f:a1:18:19:02:2b:32:
                    0a:82:64:7d:16:93:d1
                ASN1 OID: secp384r1
        X509v3 extensions:
            X509v3 Subject Key Identifier: 
                7C:5D:02:84:13:D4:CC:8A:9B:81:CE:17:1C:2E:29:1E:9C:48:63:42
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
    Signature Algorithm: ecdsa-with-SHA384
         30:66:02:31:00:be:f3:61:cf:02:10:1d:64:95:07:b8:18:6e:
         88:85:05:2f:83:08:17:90:ca:1f:8a:4c:e8:0d:1b:7a:b1:ad:
         d5:81:09:47:ef:3b:ac:08:04:7c:5c:99:b1:ed:47:07:d2:02:
         31:00:9d:ba:55:fc:a9:4a:e8:ed:ed:e6:76:01:42:7b:c8:f8:
         60:d9:8d:51:8b:55:3b:fb:8c:7b:eb:65:09:c3:f8:96:cd:47:
         a8:82:f2:16:55:77:24:7e:12:10:95:04:2c:a3
-----BEGIN CERTIFICATE-----
MIICTjCCAdOgAwIBAgIKPPYHqWhwDtqLhDAKBggqhkjOPQQDAzBrMQswCQYDVQQG
EwJJTjETMBEGA1UECxMKZW1TaWduIFBLSTElMCMGA1UEChMcZU11ZGhyYSBUZWNo
bm9sb2dpZXMgTGltaXRlZDEgMB4GA1UEAxMXZW1TaWduIEVDQyBSb290IENBIC0g
RzMwHhcNMTgwMjE4MTgzMDAwWhcNNDMwMjE4MTgzMDAwWjBrMQswCQYDVQQGEwJJ
TjETMBEGA1UECxMKZW1TaWduIFBLSTElMCMGA1UEChMcZU11ZGhyYSBUZWNobm9s
b2dpZXMgTGltaXRlZDEgMB4GA1UEAxMXZW1TaWduIEVDQyBSb290IENBIC0gRzMw
djAQBgcqhkjOPQIBBgUrgQQAIgNiAAQjpQy4LRL1KPOxst3iAhKAnjlfSU2fySU0
WXTsuwYc58Byr+iuL+FBVIcUqEqy6HyC5ltqtdyzdc6LBtCGI79G1Y4PPwT01xyS
fvalY8L1X44uT6EYGQIrMgqCZH0Wk9GjQjBAMB0GA1UdDgQWBBR8XQKEE9TMipuB
zhccLikenEhjQjAOBgNVHQ8BAf8EBAMCAQYwDwYDVR0TAQH/BAUwAwEB/zAKBggq
hkjOPQQDAwNpADBmAjEAvvNhzwIQHWSVB7gYboiFBS+DCBeQyh+KTOgNG3qxrdWB
CUfvO6wIBHxcmbHtRwfSAjEAnbpV/KlK6O3t5nYBQnvI+GDZjVGLVTv7jHvrZQnD
+JbNR6iC8hZVdyR+EhCVBCyj
-----END CERTIFICATE-----

emSign Root CA - C1
================================================
SHA1 Fingerprint=E7:2E:F1:DF:FC:B2:09:28:CF:5D:D4:D5:67:37:B1:51:CB:86:4F:01
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            ae:cf:00:ba:c4:cf:32:f8:43:b2
    Signature Algorithm: sha256WithRSAEncryption
        Issuer: C=US, OU=emSign PKI, O=eMudhra Inc, CN=emSign Root CA - C1
        Validity
            Not Before: Feb 18 18:30:00 2018 GMT
            Not After : Feb 18 18:30:00 2043 GMT
        Subject: C=US, OU=emSign PKI, O=eMudhra Inc, CN=emSign Root CA - C1
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (2048 bit)
                Modulus:
                    00:cf:eb:a9:b9:f1:99:05:cc:d8:28:21:4a:f3:73:
                    34:51:84:56:10:f5:a0:4f:2c:12:e3:fa:13:9a:27:
                    d0:cf:f9:79:1a:74:5f:1d:79:39:fc:5b:f8:70:8e:
                    e0:92:52:f7:e4:25:f9:54:83:d9:1d:d3:c8:5a:85:
                    3f:5e:c7:b6:07:ee:3e:c0:ce:9a:af:ac:56:42:2a:
                    39:25:70:d6:bf:b5:7b:36:ad:ac:f6:73:dc:cd:d7:
                    1d:8a:83:a5:fb:2b:90:15:37:6b:1c:26:47:dc:3b:
                    29:56:93:6a:b3:c1:6a:3a:9d:3d:f5:c1:97:38:58:
                    05:8b:1c:11:e3:e4:b4:b8:5d:85:1d:83:fe:78:5f:
                    0b:45:68:18:48:a5:46:73:34:3b:fe:0f:c8:76:bb:
                    c7:18:f3:05:d1:86:f3:85:ed:e7:b9:d9:32:ad:55:
                    88:ce:a6:b6:91:b0:4f:ac:7e:15:23:96:f6:3f:f0:
                    20:34:16:de:0a:c6:c4:04:45:79:7f:a7:fd:be:d2:
                    a9:a5:af:9c:c5:23:2a:f7:3c:21:6c:bd:af:8f:4e:
                    c5:3a:b2:f3:34:12:fc:df:80:1a:49:a4:d4:a9:95:
                    f7:9e:89:5e:a2:89:ac:94:cb:a8:68:9b:af:8a:65:
                    27:cd:89:ee:dd:8c:b5:6b:29:70:43:a0:69:0b:e4:
                    b9:0f
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Subject Key Identifier: 
                FE:A1:E0:70:1E:2A:03:39:52:5A:42:BE:5C:91:85:7A:18:AA:4D:B5
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
    Signature Algorithm: sha256WithRSAEncryption
         c2:4a:56:fa:15:21:7b:28:a2:e9:e5:1d:fb:f8:2d:c4:39:96:
         41:4c:3b:27:2c:c4:6c:18:15:80:c6:ac:af:47:59:2f:26:0b:
         e3:36:b0:ef:3b:fe:43:97:49:32:99:12:15:5b:df:11:29:ff:
         ab:53:f8:bb:c1:78:0f:ac:9c:53:af:57:bd:68:8c:3d:69:33:
         f0:a3:a0:23:63:3b:64:67:22:44:ad:d5:71:cb:56:2a:78:92:
         a3:4f:12:31:36:36:e2:de:fe:00:c4:a3:60:0f:27:ad:a0:b0:
         8a:b5:36:7a:52:a1:bd:27:f4:20:27:62:e8:4d:94:24:13:e4:
         0a:04:e9:3c:ab:2e:c8:43:09:4a:c6:61:04:e5:49:34:7e:d3:
         c4:c8:f5:0f:c0:aa:e9:ba:54:5e:f3:63:2b:4f:4f:50:d4:fe:
         b9:7b:99:8c:3d:c0:2e:bc:02:2b:d3:c4:40:e4:8a:07:31:1e:
         9b:ce:26:99:13:fb:11:ea:9a:22:0c:11:19:c7:5e:1b:81:50:
         30:c8:96:12:6e:e7:cb:41:7f:91:3b:a2:47:b7:54:80:1b:dc:
         00:cc:9a:90:ea:c3:c3:50:06:62:0c:30:c0:15:48:a7:a8:59:
         7c:e1:ae:22:a2:e2:0a:7a:0f:fa:62:ab:52:4c:e1:f1:df:ca:
         be:83:0d:42
-----BEGIN CERTIFICATE-----
MIIDczCCAlugAwIBAgILAK7PALrEzzL4Q7IwDQYJKoZIhvcNAQELBQAwVjELMAkG
A1UEBhMCVVMxEzARBgNVBAsTCmVtU2lnbiBQS0kxFDASBgNVBAoTC2VNdWRocmEg
SW5jMRwwGgYDVQQDExNlbVNpZ24gUm9vdCBDQSAtIEMxMB4XDTE4MDIxODE4MzAw
MFoXDTQzMDIxODE4MzAwMFowVjELMAkGA1UEBhMCVVMxEzARBgNVBAsTCmVtU2ln
biBQS0kxFDASBgNVBAoTC2VNdWRocmEgSW5jMRwwGgYDVQQDExNlbVNpZ24gUm9v
dCBDQSAtIEMxMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAz+upufGZ
BczYKCFK83M0UYRWEPWgTywS4/oTmifQz/l5GnRfHXk5/Fv4cI7gklL35CX5VIPZ
HdPIWoU/Xse2B+4+wM6ar6xWQio5JXDWv7V7Nq2s9nPczdcdioOl+yuQFTdrHCZH
3DspVpNqs8FqOp099cGXOFgFixwR4+S0uF2FHYP+eF8LRWgYSKVGczQ7/g/IdrvH
GPMF0Ybzhe3nudkyrVWIzqa2kbBPrH4VI5b2P/AgNBbeCsbEBEV5f6f9vtKppa+c
xSMq9zwhbL2vj07FOrLzNBL834AaSaTUqZX3noleoomslMuoaJuvimUnzYnu3Yy1
aylwQ6BpC+S5DwIDAQABo0IwQDAdBgNVHQ4EFgQU/qHgcB4qAzlSWkK+XJGFehiq
TbUwDgYDVR0PAQH/BAQDAgEGMA8GA1UdEwEB/wQFMAMBAf8wDQYJKoZIhvcNAQEL
BQADggEBAMJKVvoVIXsoounlHfv4LcQ5lkFMOycsxGwYFYDGrK9HWS8mC+M2sO87
/kOXSTKZEhVb3xEp/6tT+LvBeA+snFOvV71ojD1pM/CjoCNjO2RnIkSt1XHLVip4
kqNPEjE2NuLe/gDEo2APJ62gsIq1NnpSob0n9CAnYuhNlCQT5AoE6TyrLshDCUrG
YQTlSTR+08TI9Q/Aqum6VF7zYytPT1DU/rl7mYw9wC68AivTxEDkigcxHpvOJpkT
+xHqmiIMERnHXhuBUDDIlhJu58tBf5E7oke3VIAb3ADMmpDqw8NQBmIMMMAVSKeo
WXzhriKi4gp6D/piq1JM4fHfyr6DDUI=
-----END CERTIFICATE-----

emSign ECC Root CA - C3
================================================
SHA1 Fingerprint=B6:AF:43:C2:9B:81:53:7D:F6:EF:6B:C3:1F:1F:60:15:0C:EE:48:66
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            7b:71:b6:82:56:b8:12:7c:9c:a8
    Signature Algorithm: ecdsa-with-SHA384
        Issuer: C=US, OU=emSign PKI, O=eMudhra Inc, CN=emSign ECC Root CA - C3
        Validity
            Not Before: Feb 18 18:30:00 2018 GMT
            Not After : Feb 18 18:30:00 2043 GMT
        Subject: C=US, OU=emSign PKI, O=eMudhra Inc, CN=emSign ECC Root CA - C3
        Subject Public Key Info:
            Public Key Algorithm: id-ecPublicKey
                Public-Key: (384 bit)
                pub: 
                    04:fd:a5:61:ae:7b:26:10:1d:e9:b7:22:30:ae:06:
                    f4:81:b3:b1:42:71:95:39:bc:d3:52:e3:af:af:f9:
                    f2:97:35:92:36:46:0e:87:95:8d:b9:39:5a:e9:bb:
                    df:d0:fe:c8:07:41:3c:bb:55:6f:83:a3:6a:fb:62:
                    b0:81:89:02:70:7d:48:c5:4a:e3:e9:22:54:22:4d:
                    93:bb:42:0c:af:77:9c:23:a6:7d:d7:61:11:ce:65:
                    c7:f8:7f:fe:f5:f2:a9
                ASN1 OID: secp384r1
        X509v3 extensions:
            X509v3 Subject Key Identifier: 
                FB:5A:48:D0:80:20:40:F2:A8:E9:00:07:69:19:77:A7:E6:C3:F4:CF
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
    Signature Algorithm: ecdsa-with-SHA384
         30:65:02:31:00:b4:d8:2f:02:89:fd:b6:4c:62:ba:43:4e:13:
         84:72:b5:ae:dd:1c:de:d6:b5:dc:56:8f:58:40:5a:2d:de:20:
         4c:22:83:ca:93:a8:7e:ee:12:40:c7:d6:87:4f:f8:df:85:02:
         30:1c:14:64:e4:7c:96:83:11:9c:b0:d1:5a:61:4b:a6:0f:49:
         d3:00:fc:a1:fc:e4:a5:ff:7f:ad:d7:30:d0:c7:77:7f:be:81:
         07:55:30:50:20:14:f5:57:38:0a:a8:31:51
-----BEGIN CERTIFICATE-----
MIICKzCCAbGgAwIBAgIKe3G2gla4EnycqDAKBggqhkjOPQQDAzBaMQswCQYDVQQG
EwJVUzETMBEGA1UECxMKZW1TaWduIFBLSTEUMBIGA1UEChMLZU11ZGhyYSBJbmMx
IDAeBgNVBAMTF2VtU2lnbiBFQ0MgUm9vdCBDQSAtIEMzMB4XDTE4MDIxODE4MzAw
MFoXDTQzMDIxODE4MzAwMFowWjELMAkGA1UEBhMCVVMxEzARBgNVBAsTCmVtU2ln
biBQS0kxFDASBgNVBAoTC2VNdWRocmEgSW5jMSAwHgYDVQQDExdlbVNpZ24gRUND
IFJvb3QgQ0EgLSBDMzB2MBAGByqGSM49AgEGBSuBBAAiA2IABP2lYa57JhAd6bci
MK4G9IGzsUJxlTm801Ljr6/58pc1kjZGDoeVjbk5Wum739D+yAdBPLtVb4Ojavti
sIGJAnB9SMVK4+kiVCJNk7tCDK93nCOmfddhEc5lx/h//vXyqaNCMEAwHQYDVR0O
BBYEFPtaSNCAIEDyqOkAB2kZd6fmw/TPMA4GA1UdDwEB/wQEAwIBBjAPBgNVHRMB
Af8EBTADAQH/MAoGCCqGSM49BAMDA2gAMGUCMQC02C8Cif22TGK6Q04ThHK1rt0c
3ta13FaPWEBaLd4gTCKDypOofu4SQMfWh0/434UCMBwUZOR8loMRnLDRWmFLpg9J
0wD8ofzkpf9/rdcw0Md3f76BB1UwUCAU9Vc4CqgxUQ==
-----END CERTIFICATE-----

Hongkong Post Root CA 3
=================================================
SHA1 Fingerprint=58:A2:D0:EC:20:52:81:5B:C1:F3:F8:64:02:24:4E:C2:8E:02:4B:02
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            08:16:5f:8a:4c:a5:ec:00:c9:93:40:df:c4:c6:ae:23:b8:1c:5a:a4
    Signature Algorithm: sha256WithRSAEncryption
        Issuer: C=HK, ST=Hong Kong, L=Hong Kong, O=Hongkong Post, CN=Hongkong Post Root CA 3
        Validity
            Not Before: Jun  3 02:29:46 2017 GMT
            Not After : Jun  3 02:29:46 2042 GMT
        Subject: C=HK, ST=Hong Kong, L=Hong Kong, O=Hongkong Post, CN=Hongkong Post Root CA 3
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (4096 bit)
                Modulus:
                    00:b3:88:d7:ea:ce:0f:20:4e:be:e6:d6:03:6d:ee:
                    59:fc:c2:57:df:29:68:a1:83:0e:3e:68:c7:68:58:
                    9c:1c:60:4b:89:43:0c:b9:d4:15:b2:ee:c1:4e:75:
                    e9:b5:a7:ef:e5:e9:35:99:e4:cc:1c:e7:4b:5f:8d:
                    33:30:20:33:53:d9:a6:bb:d5:3e:13:8e:e9:1f:87:
                    49:ad:50:2d:50:ca:18:be:01:58:a2:13:70:96:bb:
                    89:88:56:80:5c:f8:bd:2c:3c:e1:4c:57:88:bb:d3:
                    b9:95:ef:cb:c7:f6:da:31:74:28:a6:e6:54:89:f5:
                    41:31:ca:e5:26:1a:cd:82:e0:70:da:3b:29:bb:d5:
                    03:f5:99:ba:55:f5:64:d1:60:0e:b3:89:49:b8:8a:
                    2f:05:d2:84:45:28:7c:8f:68:50:12:78:fc:0b:b5:
                    53:cb:c2:98:1c:84:a3:9e:b0:be:23:a4:da:dc:c8:
                    2b:1e:da:6e:45:1e:89:98:da:f9:00:2e:06:e9:0c:
                    3b:70:d5:50:25:88:99:cb:cd:73:60:f7:d5:ff:35:
                    67:c5:a1:bc:5e:ab:cd:4a:b8:45:eb:c8:68:1e:0d:
                    0d:14:46:12:e3:d2:64:62:8a:42:98:bc:b4:c6:08:
                    08:f8:fd:a8:4c:64:9c:76:01:bd:2f:a9:6c:33:0f:
                    d8:3f:28:b8:3c:69:01:42:86:7e:69:c1:c9:06:ca:
                    e5:7a:46:65:e9:c2:d6:50:41:2e:3f:b7:e4:ed:6c:
                    d7:bf:26:01:11:a2:16:29:4a:6b:34:06:90:ec:13:
                    d2:b6:fb:6a:76:d2:3c:ed:f0:d6:2d:dd:e1:15:ec:
                    a3:9b:2f:2c:c9:3e:2b:e4:69:3b:ff:72:25:b1:36:
                    86:5b:c7:7f:6b:8b:55:1b:4a:c5:20:61:3d:ae:cb:
                    50:e1:08:3a:be:b0:8f:63:41:53:30:08:59:3c:98:
                    1d:77:ba:63:91:7a:ca:10:50:60:bf:f0:d7:bc:95:
                    87:8f:97:c5:fe:97:6a:01:94:a3:7c:5b:85:1d:2a:
                    39:3a:d0:54:a1:d1:39:71:9d:fd:21:f9:b5:7b:f0:
                    e2:e0:02:8f:6e:96:24:25:2c:a0:1e:2c:a8:c4:89:
                    a7:ef:ed:99:06:2f:b6:0a:4c:4f:db:a2:cc:37:1a:
                    af:47:85:2d:8a:5f:c4:34:34:4c:00:fd:18:93:67:
                    13:d1:37:e6:48:b4:8b:06:c5:57:7b:19:86:0a:79:
                    cb:00:c9:52:af:42:ff:37:8f:e1:a3:1e:7a:3d:50:
                    ab:63:06:e7:15:b5:3f:b6:45:37:94:37:b1:7e:f2:
                    48:c3:7f:c5:75:fe:97:8d:45:8f:1a:a7:1a:72:28:
                    1a:40:0f
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Authority Key Identifier: 
                keyid:17:9D:CD:1E:8B:D6:39:2B:70:D3:5C:D4:A0:B8:1F:B0:00:FC:C5:61

            X509v3 Subject Key Identifier: 
                17:9D:CD:1E:8B:D6:39:2B:70:D3:5C:D4:A0:B8:1F:B0:00:FC:C5:61
    Signature Algorithm: sha256WithRSAEncryption
         56:d5:7b:6e:e6:22:01:d2:42:9b:18:d5:0e:d7:66:23:5c:e3:
         fe:a0:c7:92:d2:e9:94:ad:4b:a2:c6:ec:12:7c:74:d5:48:d2:
         59:14:99:c0:eb:b9:d1:eb:f4:48:30:5b:ad:a7:57:73:99:a9:
         d3:e5:b7:d1:2e:59:24:58:dc:68:2e:2e:62:d8:6a:e4:70:0b:
         2d:20:50:20:a4:32:95:d1:00:98:bb:d3:fd:f7:32:f2:49:ae:
         c6:7a:e0:47:be:6e:ce:cb:a3:72:3a:2d:69:5d:cb:c8:e8:45:
         39:d4:fa:42:c1:11:4c:77:5d:92:fb:6a:ff:58:44:e5:eb:81:
         9e:af:a0:99:ad:be:a9:01:66:cb:38:1d:3c:df:43:1f:f4:4d:
         6e:b4:ba:17:46:fc:7d:fd:87:81:79:6a:0d:33:0f:fa:2f:f8:
         14:b9:80:b3:5d:4d:aa:97:e1:f9:e4:18:c5:f8:d5:38:8c:26:
         3c:fd:f2:28:e2:ee:5a:49:88:2c:df:79:3d:8e:9e:90:3c:bd:
         41:4a:3a:dd:5b:f6:9a:b4:ce:3f:25:30:7f:32:7d:a2:03:94:
         d0:dc:7a:a1:52:de:6e:93:8d:18:26:fd:55:ac:bd:8f:9b:d2:
         cf:af:e7:86:2c:cb:1f:09:6f:a3:6f:a9:84:d4:73:bf:4d:a1:
         74:1b:4e:23:60:f2:cc:0e:aa:7f:a4:9c:4c:25:a8:b2:66:3b:
         38:ff:d9:94:30:f6:72:84:be:68:55:10:0f:c6:73:2c:16:69:
         93:07:fe:b1:45:ed:bb:a2:55:6a:b0:da:b5:4a:02:25:27:85:
         d7:b7:b7:86:44:16:89:6c:80:2b:3e:97:a9:9c:d5:7e:55:4c:
         c6:de:45:10:1c:ea:e9:3b:9f:03:53:ee:ee:7a:01:02:16:78:
         d4:e8:c2:be:46:76:88:13:3f:22:bb:48:12:1d:52:00:b4:02:
         7e:21:1a:1e:9c:25:f4:f3:3d:5e:1e:d2:1c:f9:b3:2d:b6:f7:
         37:5c:c6:cb:21:4e:b0:f7:99:47:18:85:c1:2b:ba:55:ae:06:
         ea:d0:07:b2:dc:ab:d0:82:96:75:ce:d2:50:fe:99:e7:cf:2f:
         9f:e7:76:d1:61:2a:fb:21:bb:31:d0:aa:9f:47:a4:b2:22:ca:
         16:3a:50:57:c4:5b:43:67:c5:65:62:03:49:01:eb:43:d9:d8:
         f8:9e:ad:cf:b1:63:0e:45:f4:a0:5a:2c:9b:2d:c5:a6:c0:ad:
         a8:47:f4:27:4c:38:0d:2e:1b:49:3b:52:f4:e8:88:83:2b:54:
         28:d4:f2:35:52:b4:32:83:62:69:64:0c:91:9c:9f:97:ea:74:
         16:fd:1f:11:06:9a:9b:f4
-----BEGIN CERTIFICATE-----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-----END CERTIFICATE-----

Entrust Root Certification Authority - G4
================================================
SHA1 Fingerprint=14:88:4E:86:26:37:B0:26:AF:59:62:5C:40:77:EC:35:29:BA:96:01
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            d9:b5:43:7f:af:a9:39:0f:00:00:00:00:55:65:ad:58
    Signature Algorithm: sha256WithRSAEncryption
        Issuer: C=US, O=Entrust, Inc., OU=See www.entrust.net/legal-terms, OU=(c) 2015 Entrust, Inc. - for authorized use only, CN=Entrust Root Certification Authority - G4
        Validity
            Not Before: May 27 11:11:16 2015 GMT
            Not After : Dec 27 11:41:16 2037 GMT
        Subject: C=US, O=Entrust, Inc., OU=See www.entrust.net/legal-terms, OU=(c) 2015 Entrust, Inc. - for authorized use only, CN=Entrust Root Certification Authority - G4
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (4096 bit)
                Modulus:
                    00:b1:ec:2c:42:ee:e2:d1:30:ff:a5:92:47:e2:2d:
                    c3:ba:64:97:6d:ca:f7:0d:b5:59:c1:b3:cb:a8:68:
                    19:d8:af:84:6d:30:70:5d:7e:f3:2e:d2:53:99:e1:
                    fe:1f:5e:d9:48:af:5d:13:8d:db:ff:63:33:4d:d3:
                    00:02:bc:c4:f8:d1:06:08:94:79:58:8a:15:de:29:
                    b3:fd:fd:c4:4f:e8:aa:e2:a0:3b:79:cd:bf:6b:43:
                    32:dd:d9:74:10:b9:f7:f4:68:d4:bb:d0:87:d5:aa:
                    4b:8a:2a:6f:2a:04:b5:b2:a6:c7:a0:7a:e6:48:ab:
                    d2:d1:59:cc:d6:7e:23:e6:97:6c:f0:42:e5:dc:51:
                    4b:15:41:ed:49:4a:c9:de:10:97:d6:76:c1:ef:a5:
                    b5:36:14:97:35:d8:78:22:35:52:ef:43:bd:db:27:
                    db:61:56:82:34:dc:cb:88:60:0c:0b:5a:e5:2c:01:
                    c6:54:af:d7:aa:c1:10:7b:d2:05:5a:b8:40:9e:86:
                    a7:c3:90:86:02:56:52:09:7a:9c:d2:27:82:53:4a:
                    65:52:6a:f5:3c:e7:a8:f2:9c:af:8b:bd:d3:0e:d4:
                    d4:5e:6e:87:9e:6a:3d:45:1d:d1:5d:1b:f4:e9:0a:
                    ac:60:99:fb:89:b4:ff:98:2c:cf:7c:1d:e9:02:aa:
                    04:9a:1e:b8:dc:88:6e:25:b3:6c:66:f7:3c:90:f3:
                    57:c1:b3:2f:f5:6d:f2:fb:ca:a1:f8:29:9d:46:8b:
                    b3:6a:f6:e6:67:07:be:2c:67:0a:2a:1f:5a:b2:3e:
                    57:c4:d3:21:21:63:65:52:91:1b:b1:99:8e:79:7e:
                    e6:eb:8d:00:d9:5a:aa:ea:73:e8:a4:82:02:47:96:
                    fe:5b:8e:54:61:a3:eb:2f:4b:30:b0:8b:23:75:72:
                    7c:21:3c:c8:f6:f1:74:d4:1c:7b:a3:05:55:ee:bb:
                    4d:3b:32:be:9a:77:66:9e:ac:69:90:22:07:1f:61:
                    3a:96:be:e5:9a:4f:cc:05:3c:28:59:d3:c1:0c:54:
                    a8:59:61:bd:c8:72:4c:e8:dc:9f:87:7f:bd:9c:48:
                    36:5e:95:a3:0e:b9:38:24:55:fc:75:66:eb:02:e3:
                    08:34:29:4a:c6:e3:2b:2f:33:a0:da:a3:86:a5:12:
                    97:fd:80:2b:da:14:42:e3:92:bd:3e:f2:5d:5e:67:
                    74:2e:1c:88:47:29:34:5f:e2:32:a8:9c:25:37:8c:
                    ba:98:00:97:8b:49:96:1e:fd:25:8a:ac:dc:da:d8:
                    5d:74:6e:66:b0:ff:44:df:a1:18:c6:be:48:2f:37:
                    94:78:f8:95:4a:3f:7f:13:5e:5d:59:fd:74:86:43:
                    63:73:49
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Subject Key Identifier: 
                9F:38:C4:56:23:C3:39:E8:A0:71:6C:E8:54:4C:E4:E8:3A:B1:BF:67
    Signature Algorithm: sha256WithRSAEncryption
         12:e5:42:a6:7b:8b:0f:0c:e4:46:a5:b6:60:40:87:8c:25:7e:
         ad:b8:68:2e:5b:c6:40:76:3c:03:f8:c9:59:f4:f3:ab:62:ce:
         10:8d:b4:5a:64:8c:68:c0:b0:72:43:34:d2:1b:0b:f6:2c:53:
         d2:ca:90:4b:86:66:fc:aa:83:22:f4:8b:1a:6f:26:48:ac:76:
         77:08:bf:c5:98:5c:f4:26:89:9e:7b:c3:b9:64:32:01:7f:d3:
         c3:dd:58:6d:ec:b1:ab:84:55:74:77:84:04:27:52:6b:86:4c:
         ce:dd:b9:65:ff:d6:c6:5e:9f:9a:10:99:4b:75:6a:fe:6a:e9:
         97:20:e4:e4:76:7a:c6:d0:24:aa:90:cd:20:90:ba:47:64:fb:
         7f:07:b3:53:78:b5:0a:62:f2:73:43:ce:41:2b:81:6a:2e:85:
         16:94:53:d4:6b:5f:72:22:ab:51:2d:42:d5:00:9c:99:bf:de:
         bb:94:3b:57:fd:9a:f5:86:cb:56:3b:5b:88:01:e5:7c:28:4b:
         03:f9:49:83:7c:b2:7f:7c:e3:ed:8e:a1:7f:60:53:8e:55:9d:
         50:34:12:0f:b7:97:7b:6c:87:4a:44:e7:f5:6d:ec:80:37:f0:
         58:19:6e:4a:68:76:f0:1f:92:e4:ea:b5:92:d3:61:51:10:0b:
         ad:a7:d9:5f:c7:5f:dc:1f:a3:5c:8c:a1:7e:9b:b7:9e:d3:56:
         6f:66:5e:07:96:20:ed:0b:74:fb:66:4e:8b:11:15:e9:81:49:
         7e:6f:b0:d4:50:7f:22:d7:5f:65:02:0d:a6:f4:85:1e:d8:ae:
         06:4b:4a:a7:d2:31:66:c2:f8:ce:e5:08:a6:a4:02:96:44:68:
         57:c4:d5:33:cf:19:2f:14:c4:94:1c:7b:a4:d9:f0:9f:0e:b1:
         80:e2:d1:9e:11:64:a9:88:11:3a:76:82:e5:62:c2:80:d8:a4:
         83:ed:93:ef:7c:2f:90:b0:32:4c:96:15:68:48:52:d4:99:08:
         c0:24:e8:1c:e3:b3:a5:21:0e:92:c0:90:1f:cf:20:5f:ca:3b:
         38:c7:b7:6d:3a:f3:e6:44:b8:0e:31:6b:88:8e:70:eb:9c:17:
         52:a8:41:94:2e:87:b6:e7:a6:12:c5:75:df:5b:c0:0a:6e:7b:
         a4:e4:5e:86:f9:36:94:df:77:c3:e9:0d:c0:39:f1:79:bb:46:
         8e:ab:43:59:27:b7:20:bb:23:e9:56:40:21:ec:31:3d:65:aa:
         43:f2:3d:df:70:44:e1:ba:4d:26:10:3b:98:9f:f3:c8:8e:1b:
         38:56:21:6a:51:93:d3:91:ca:46:da:89:b7:3d:53:83:2c:08:
         1f:8b:8f:53:dd:ff:ac:1f
-----BEGIN CERTIFICATE-----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-----END CERTIFICATE-----

Microsoft ECC Root Certificate Authority 2017
=================================================
SHA1 Fingerprint=99:9A:64:C3:7F:F4:7D:9F:AB:95:F1:47:69:89:14:60:EE:C4:C3:C5
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            66:f2:3d:af:87:de:8b:b1:4a:ea:0c:57:31:01:c2:ec
    Signature Algorithm: ecdsa-with-SHA384
        Issuer: C=US, O=Microsoft Corporation, CN=Microsoft ECC Root Certificate Authority 2017
        Validity
            Not Before: Dec 18 23:06:45 2019 GMT
            Not After : Jul 18 23:16:04 2042 GMT
        Subject: C=US, O=Microsoft Corporation, CN=Microsoft ECC Root Certificate Authority 2017
        Subject Public Key Info:
            Public Key Algorithm: id-ecPublicKey
                Public-Key: (384 bit)
                pub: 
                    04:d4:bc:3d:02:42:75:41:13:23:cd:80:04:86:02:
                    51:2f:6a:a8:81:62:0b:65:cc:f6:ca:9d:1e:6f:4a:
                    66:51:a2:03:d9:9d:91:fa:b6:16:b1:8c:6e:de:7c:
                    cd:db:79:a6:2f:ce:bb:ce:71:2f:e5:a5:ab:28:ec:
                    63:04:66:99:f8:fa:f2:93:10:05:e1:81:28:42:e3:
                    c6:68:f4:e6:1b:84:60:4a:89:af:ed:79:0f:3b:ce:
                    f1:f6:44:f5:01:78:c0
                ASN1 OID: secp384r1
        X509v3 extensions:
            X509v3 Key Usage: critical
                Digital Signature, Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Subject Key Identifier: 
                C8:CB:99:72:70:52:0C:F8:E6:BE:B2:04:57:29:2A:CF:42:10:ED:35
            1.3.6.1.4.1.311.21.1: 
                ...
    Signature Algorithm: ecdsa-with-SHA384
         30:65:02:30:58:f2:4d:ea:0c:f9:5f:5e:ee:60:29:cb:3a:f2:
         db:d6:32:84:19:3f:7c:d5:2f:c2:b1:cc:93:ae:50:bb:09:32:
         c6:c6:ed:7e:c9:36:94:12:e4:68:85:06:a2:1b:d0:2f:02:31:
         00:99:e9:16:b4:0e:fa:56:48:d4:a4:30:16:91:78:db:54:8c:
         65:01:8a:e7:50:66:c2:31:b7:39:ba:b8:1a:22:07:4e:fc:6b:
         54:16:20:ff:2b:b5:e7:4c:0c:4d:a6:4f:73
-----BEGIN CERTIFICATE-----
MIICWTCCAd+gAwIBAgIQZvI9r4fei7FK6gxXMQHC7DAKBggqhkjOPQQDAzBlMQsw
CQYDVQQGEwJVUzEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9uMTYwNAYD
VQQDEy1NaWNyb3NvZnQgRUNDIFJvb3QgQ2VydGlmaWNhdGUgQXV0aG9yaXR5IDIw
MTcwHhcNMTkxMjE4MjMwNjQ1WhcNNDIwNzE4MjMxNjA0WjBlMQswCQYDVQQGEwJV
UzEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9uMTYwNAYDVQQDEy1NaWNy
b3NvZnQgRUNDIFJvb3QgQ2VydGlmaWNhdGUgQXV0aG9yaXR5IDIwMTcwdjAQBgcq
hkjOPQIBBgUrgQQAIgNiAATUvD0CQnVBEyPNgASGAlEvaqiBYgtlzPbKnR5vSmZR
ogPZnZH6thaxjG7efM3beaYvzrvOcS/lpaso7GMEZpn4+vKTEAXhgShC48Zo9OYb
hGBKia/teQ87zvH2RPUBeMCjVDBSMA4GA1UdDwEB/wQEAwIBhjAPBgNVHRMBAf8E
BTADAQH/MB0GA1UdDgQWBBTIy5lycFIM+Oa+sgRXKSrPQhDtNTAQBgkrBgEEAYI3
FQEEAwIBADAKBggqhkjOPQQDAwNoADBlAjBY8k3qDPlfXu5gKcs68tvWMoQZP3zV
L8KxzJOuULsJMsbG7X7JNpQS5GiFBqIb0C8CMQCZ6Ra0DvpWSNSkMBaReNtUjGUB
iudQZsIxtzm6uBoiB078a1QWIP8rtedMDE2mT3M=
-----END CERTIFICATE-----

Microsoft RSA Root Certificate Authority 2017
=================================================
SHA1 Fingerprint=73:A5:E6:4A:3B:FF:83:16:FF:0E:DC:CC:61:8A:90:6E:4E:AE:4D:74
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            1e:d3:97:09:5f:d8:b4:b3:47:70:1e:aa:be:7f:45:b3
    Signature Algorithm: sha384WithRSAEncryption
        Issuer: C=US, O=Microsoft Corporation, CN=Microsoft RSA Root Certificate Authority 2017
        Validity
            Not Before: Dec 18 22:51:22 2019 GMT
            Not After : Jul 18 23:00:23 2042 GMT
        Subject: C=US, O=Microsoft Corporation, CN=Microsoft RSA Root Certificate Authority 2017
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (4096 bit)
                Modulus:
                    00:ca:5b:be:94:33:8c:29:95:91:16:0a:95:bd:47:
                    62:c1:89:f3:99:36:df:46:90:c9:a5:ed:78:6a:6f:
                    47:91:68:f8:27:67:50:33:1d:a1:a6:fb:e0:e5:43:
                    a3:84:02:57:01:5d:9c:48:40:82:53:10:bc:bf:c7:
                    3b:68:90:b6:82:2d:e5:f4:65:d0:cc:6d:19:cc:95:
                    f9:7b:ac:4a:94:ad:0e:de:4b:43:1d:87:07:92:13:
                    90:80:83:64:35:39:04:fc:e5:e9:6c:b3:b6:1f:50:
                    94:38:65:50:5c:17:46:b9:b6:85:b5:1c:b5:17:e8:
                    d6:45:9d:d8:b2:26:b0:ca:c4:70:4a:ae:60:a4:dd:
                    b3:d9:ec:fc:3b:d5:57:72:bc:3f:c8:c9:b2:de:4b:
                    6b:f8:23:6c:03:c0:05:bd:95:c7:cd:73:3b:66:80:
                    64:e3:1a:ac:2e:f9:47:05:f2:06:b6:9b:73:f5:78:
                    33:5b:c7:a1:fb:27:2a:a1:b4:9a:91:8c:91:d3:3a:
                    82:3e:76:40:b4:cd:52:61:51:70:28:3f:c5:c5:5a:
                    f2:c9:8c:49:bb:14:5b:4d:c8:ff:67:4d:4c:12:96:
                    ad:f5:fe:78:a8:97:87:d7:fd:5e:20:80:dc:a1:4b:
                    22:fb:d4:89:ad:ba:ce:47:97:47:55:7b:8f:45:c8:
                    67:28:84:95:1c:68:30:ef:ef:49:e0:35:7b:64:e7:
                    98:b0:94:da:4d:85:3b:3e:55:c4:28:af:57:f3:9e:
                    13:db:46:27:9f:1e:a2:5e:44:83:a4:a5:ca:d5:13:
                    b3:4b:3f:c4:e3:c2:e6:86:61:a4:52:30:b9:7a:20:
                    4f:6f:0f:38:53:cb:33:0c:13:2b:8f:d6:9a:bd:2a:
                    c8:2d:b1:1c:7d:4b:51:ca:47:d1:48:27:72:5d:87:
                    eb:d5:45:e6:48:65:9d:af:52:90:ba:5b:a2:18:65:
                    57:12:9f:68:b9:d4:15:6b:94:c4:69:22:98:f4:33:
                    e0:ed:f9:51:8e:41:50:c9:34:4f:76:90:ac:fc:38:
                    c1:d8:e1:7b:b9:e3:e3:94:e1:46:69:cb:0e:0a:50:
                    6b:13:ba:ac:0f:37:5a:b7:12:b5:90:81:1e:56:ae:
                    57:22:86:d9:c9:d2:d1:d7:51:e3:ab:3b:c6:55:fd:
                    1e:0e:d3:74:0a:d1:da:aa:ea:69:b8:97:28:8f:48:
                    c4:07:f8:52:43:3a:f4:ca:55:35:2c:b0:a6:6a:c0:
                    9c:f9:f2:81:e1:12:6a:c0:45:d9:67:b3:ce:ff:23:
                    a2:89:0a:54:d4:14:b9:2a:a8:d7:ec:f9:ab:cd:25:
                    58:32:79:8f:90:5b:98:39:c4:08:06:c1:ac:7f:0e:
                    3d:00:a5
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Key Usage: critical
                Digital Signature, Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Subject Key Identifier: 
                09:CB:59:7F:86:B2:70:8F:1A:C3:39:E3:C0:D9:E9:BF:BB:4D:B2:23
            1.3.6.1.4.1.311.21.1: 
                ...
    Signature Algorithm: sha384WithRSAEncryption
         ac:af:3e:5d:c2:11:96:89:8e:a3:e7:92:d6:97:15:b8:13:a2:
         a6:42:2e:02:cd:16:05:59:27:ca:20:e8:ba:b8:e8:1a:ec:4d:
         a8:97:56:ae:65:43:b1:8f:00:9b:52:cd:55:cd:53:39:6d:62:
         4c:8b:0d:5b:7c:2e:44:bf:83:10:8f:f3:53:82:80:c3:4f:3a:
         c7:6e:11:3f:e6:e3:16:91:84:fb:6d:84:7f:34:74:ad:89:a7:
         ce:b9:d7:d7:9f:84:64:92:be:95:a1:ad:09:53:33:dd:ee:0a:
         ea:4a:51:8e:6f:55:ab:ba:b5:94:46:ae:8c:7f:d8:a2:50:25:
         65:60:80:46:db:33:04:ae:6c:b5:98:74:54:25:dc:93:e4:f8:
         e3:55:15:3d:b8:6d:c3:0a:a4:12:c1:69:85:6e:df:64:f1:53:
         99:e1:4a:75:20:9d:95:0f:e4:d6:dc:03:f1:59:18:e8:47:89:
         b2:57:5a:94:b6:a9:d8:17:2b:17:49:e5:76:cb:c1:56:99:3a:
         37:b1:ff:69:2c:91:91:93:e1:df:4c:a3:37:76:4d:a1:9f:f8:
         6d:1e:1d:d3:fa:ec:fb:f4:45:1d:13:6d:cf:f7:59:e5:22:27:
         72:2b:86:f3:57:bb:30:ed:24:4d:dc:7d:56:bb:a3:b3:f8:34:
         79:89:c1:e0:f2:02:61:f7:a6:fc:0f:bb:1c:17:0b:ae:41:d9:
         7c:bd:27:a3:fd:2e:3a:d1:93:94:b1:73:1d:24:8b:af:5b:20:
         89:ad:b7:67:66:79:f5:3a:c6:a6:96:33:fe:53:92:c8:46:b1:
         11:91:c6:99:7f:8f:c9:d6:66:31:20:41:10:87:2d:0c:d6:c1:
         af:34:98:ca:64:83:fb:13:57:d1:c1:f0:3c:7a:8c:a5:c1:fd:
         95:21:a0:71:c1:93:67:71:12:ea:8f:88:0a:69:19:64:99:23:
         56:fb:ac:2a:2e:70:be:66:c4:0c:84:ef:e5:8b:f3:93:01:f8:
         6a:90:93:67:4b:b2:68:a3:b5:62:8f:e9:3f:8c:7a:3b:5e:0f:
         e7:8c:b8:c6:7c:ef:37:fd:74:e2:c8:4f:33:72:e1:94:39:6d:
         bd:12:af:be:0c:4e:70:7c:1b:6f:8d:b3:32:93:73:44:16:6d:
         e8:f4:f7:e0:95:80:8f:96:5d:38:a4:f4:ab:de:0a:30:87:93:
         d8:4d:00:71:62:45:27:4b:3a:42:84:5b:7f:65:b7:67:34:52:
         2d:9c:16:6b:aa:a8:d8:7b:a3:42:4c:71:c7:0c:ca:3e:83:e4:
         a6:ef:b7:01:30:5e:51:a3:79:f5:70:69:a6:41:44:0f:86:b0:
         2c:91:c6:3d:ea:ae:0f:84
-----BEGIN CERTIFICATE-----
MIIFqDCCA5CgAwIBAgIQHtOXCV/YtLNHcB6qvn9FszANBgkqhkiG9w0BAQwFADBl
MQswCQYDVQQGEwJVUzEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9uMTYw
NAYDVQQDEy1NaWNyb3NvZnQgUlNBIFJvb3QgQ2VydGlmaWNhdGUgQXV0aG9yaXR5
IDIwMTcwHhcNMTkxMjE4MjI1MTIyWhcNNDIwNzE4MjMwMDIzWjBlMQswCQYDVQQG
EwJVUzEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9uMTYwNAYDVQQDEy1N
aWNyb3NvZnQgUlNBIFJvb3QgQ2VydGlmaWNhdGUgQXV0aG9yaXR5IDIwMTcwggIi
MA0GCSqGSIb3DQEBAQUAA4ICDwAwggIKAoICAQDKW76UM4wplZEWCpW9R2LBifOZ
Nt9GkMml7Xhqb0eRaPgnZ1AzHaGm++DlQ6OEAlcBXZxIQIJTELy/xztokLaCLeX0
ZdDMbRnMlfl7rEqUrQ7eS0MdhweSE5CAg2Q1OQT85elss7YfUJQ4ZVBcF0a5toW1
HLUX6NZFndiyJrDKxHBKrmCk3bPZ7Pw71VdyvD/IybLeS2v4I2wDwAW9lcfNcztm
gGTjGqwu+UcF8ga2m3P1eDNbx6H7JyqhtJqRjJHTOoI+dkC0zVJhUXAoP8XFWvLJ
jEm7FFtNyP9nTUwSlq31/niol4fX/V4ggNyhSyL71Imtus5Hl0dVe49FyGcohJUc
aDDv70ngNXtk55iwlNpNhTs+VcQor1fznhPbRiefHqJeRIOkpcrVE7NLP8TjwuaG
YaRSMLl6IE9vDzhTyzMMEyuP1pq9KsgtsRx9S1HKR9FIJ3Jdh+vVReZIZZ2vUpC6
W6IYZVcSn2i51BVrlMRpIpj0M+Dt+VGOQVDJNE92kKz8OMHY4Xu54+OU4UZpyw4K
UGsTuqwPN1q3ErWQgR5WrlcihtnJ0tHXUeOrO8ZV/R4O03QK0dqq6mm4lyiPSMQH
+FJDOvTKVTUssKZqwJz58oHhEmrARdlns87/I6KJClTUFLkqqNfs+avNJVgyeY+Q
W5g5xAgGwax/Dj0ApQIDAQABo1QwUjAOBgNVHQ8BAf8EBAMCAYYwDwYDVR0TAQH/
BAUwAwEB/zAdBgNVHQ4EFgQUCctZf4aycI8awznjwNnpv7tNsiMwEAYJKwYBBAGC
NxUBBAMCAQAwDQYJKoZIhvcNAQEMBQADggIBAKyvPl3CEZaJjqPnktaXFbgToqZC
LgLNFgVZJ8og6Lq46BrsTaiXVq5lQ7GPAJtSzVXNUzltYkyLDVt8LkS/gxCP81OC
gMNPOsduET/m4xaRhPtthH80dK2Jp86519efhGSSvpWhrQlTM93uCupKUY5vVau6
tZRGrox/2KJQJWVggEbbMwSubLWYdFQl3JPk+ONVFT24bcMKpBLBaYVu32TxU5nh
SnUgnZUP5NbcA/FZGOhHibJXWpS2qdgXKxdJ5XbLwVaZOjex/2kskZGT4d9Mozd2
TaGf+G0eHdP67Pv0RR0Tbc/3WeUiJ3IrhvNXuzDtJE3cfVa7o7P4NHmJweDyAmH3
pvwPuxwXC65B2Xy9J6P9LjrRk5Sxcx0ki69bIImtt2dmefU6xqaWM/5TkshGsRGR
xpl/j8nWZjEgQRCHLQzWwa80mMpkg/sTV9HB8Dx6jKXB/ZUhoHHBk2dxEuqPiApp
GWSZI1b7rCoucL5mxAyE7+WL85MB+GqQk2dLsmijtWKP6T+MejteD+eMuMZ87zf9
dOLITzNy4ZQ5bb0Sr74MTnB8G2+NszKTc0QWbej09+CVgI+WXTik9KveCjCHk9hN
AHFiRSdLOkKEW39lt2c0Ui2cFmuqqNh7o0JMcccMyj6D5KbvtwEwXlGjefVwaaZB
RA+GsCyRxj3qrg+E
-----END CERTIFICATE-----

e-Szigno Root CA 2017
================================================
SHA1 Fingerprint=89:D4:83:03:4F:9E:9A:48:80:5F:72:37:D4:A9:A6:EF:CB:7C:1F:D1
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            01:54:48:ef:21:fd:97:59:0d:f5:04:0a
    Signature Algorithm: ecdsa-with-SHA256
        Issuer: C=HU, L=Budapest, O=Microsec Ltd./2.5.4.97=VATHU-23584497, CN=e-Szigno Root CA 2017
        Validity
            Not Before: Aug 22 12:07:06 2017 GMT
            Not After : Aug 22 12:07:06 2042 GMT
        Subject: C=HU, L=Budapest, O=Microsec Ltd./2.5.4.97=VATHU-23584497, CN=e-Szigno Root CA 2017
        Subject Public Key Info:
            Public Key Algorithm: id-ecPublicKey
                Public-Key: (256 bit)
                pub: 
                    04:96:dc:3d:8a:d8:b0:7b:6f:c6:27:be:44:90:b1:
                    b3:56:15:7b:8e:43:24:7d:1a:84:59:ee:63:68:b2:
                    c6:5e:87:d0:15:48:1e:a8:90:ad:bd:53:a2:da:de:
                    3a:90:a6:60:5f:68:32:b5:86:41:df:87:5b:2c:7b:
                    c5:fe:7c:7a:da
                ASN1 OID: prime256v1
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Subject Key Identifier: 
                87:11:15:08:D1:AA:C1:78:0C:B1:AF:CE:C6:C9:90:EF:BF:30:04:C0
            X509v3 Authority Key Identifier: 
                keyid:87:11:15:08:D1:AA:C1:78:0C:B1:AF:CE:C6:C9:90:EF:BF:30:04:C0

    Signature Algorithm: ecdsa-with-SHA256
         30:46:02:21:00:b5:57:dd:d7:8a:55:0b:36:e1:86:44:fa:d4:
         d9:68:8d:b8:dc:23:8a:8a:0d:d4:2f:7d:ea:73:ec:bf:4d:6c:
         a8:02:21:00:cb:a5:b4:12:fa:e7:b5:e8:cf:7e:93:fc:f3:35:
         8f:6f:4e:5a:7c:b4:bc:4e:b2:fc:72:aa:5b:59:f9:e7:dc:31
-----BEGIN CERTIFICATE-----
MIICQDCCAeWgAwIBAgIMAVRI7yH9l1kN9QQKMAoGCCqGSM49BAMCMHExCzAJBgNV
BAYTAkhVMREwDwYDVQQHDAhCdWRhcGVzdDEWMBQGA1UECgwNTWljcm9zZWMgTHRk
LjEXMBUGA1UEYQwOVkFUSFUtMjM1ODQ0OTcxHjAcBgNVBAMMFWUtU3ppZ25vIFJv
b3QgQ0EgMjAxNzAeFw0xNzA4MjIxMjA3MDZaFw00MjA4MjIxMjA3MDZaMHExCzAJ
BgNVBAYTAkhVMREwDwYDVQQHDAhCdWRhcGVzdDEWMBQGA1UECgwNTWljcm9zZWMg
THRkLjEXMBUGA1UEYQwOVkFUSFUtMjM1ODQ0OTcxHjAcBgNVBAMMFWUtU3ppZ25v
IFJvb3QgQ0EgMjAxNzBZMBMGByqGSM49AgEGCCqGSM49AwEHA0IABJbcPYrYsHtv
xie+RJCxs1YVe45DJH0ahFnuY2iyxl6H0BVIHqiQrb1TotreOpCmYF9oMrWGQd+H
Wyx7xf58etqjYzBhMA8GA1UdEwEB/wQFMAMBAf8wDgYDVR0PAQH/BAQDAgEGMB0G
A1UdDgQWBBSHERUI0arBeAyxr87GyZDvvzAEwDAfBgNVHSMEGDAWgBSHERUI0arB
eAyxr87GyZDvvzAEwDAKBggqhkjOPQQDAgNJADBGAiEAtVfd14pVCzbhhkT61Nlo
jbjcI4qKDdQvfepz7L9NbKgCIQDLpbQS+ue16M9+k/zzNY9vTlp8tLxOsvxyqltZ
+efcMQ==
-----END CERTIFICATE-----

certSIGN Root CA G2
=================================================
SHA1 Fingerprint=26:F9:93:B4:ED:3D:28:27:B0:B9:4B:A7:E9:15:1D:A3:8D:92:E5:32
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            11:00:34:b6:4e:c6:36:2d:36
    Signature Algorithm: sha256WithRSAEncryption
        Issuer: C=RO, O=CERTSIGN SA, OU=certSIGN ROOT CA G2
        Validity
            Not Before: Feb  6 09:27:35 2017 GMT
            Not After : Feb  6 09:27:35 2042 GMT
        Subject: C=RO, O=CERTSIGN SA, OU=certSIGN ROOT CA G2
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (4096 bit)
                Modulus:
                    00:c0:c5:75:19:91:7d:44:74:74:87:fe:0e:3b:96:
                    dc:d8:01:16:cc:ee:63:91:e7:0b:6f:ce:3b:0a:69:
                    1a:7c:c2:e3:af:82:8e:86:d7:5e:8f:57:eb:d3:21:
                    59:fd:39:37:42:30:be:50:ea:b6:0f:a9:88:d8:2e:
                    2d:69:21:e7:d1:37:18:4e:7d:91:d5:16:5f:6b:5b:
                    00:c2:39:43:0d:36:85:52:b9:53:65:0f:1d:42:e5:
                    8f:cf:05:d3:ee:dc:0c:1a:d9:b8:8b:78:22:67:e4:
                    69:b0:68:c5:3c:e4:6c:5a:46:e7:cd:c7:fa:ef:c4:
                    ec:4b:bd:6a:a4:ac:fd:cc:28:51:ef:92:b4:29:ab:
                    ab:35:9a:4c:e4:c4:08:c6:26:cc:f8:69:9f:e4:9c:
                    f0:29:d3:5c:f9:c6:16:25:9e:23:c3:20:c1:3d:0f:
                    3f:38:40:b0:fe:82:44:38:aa:5a:1a:8a:6b:63:58:
                    38:b4:15:d3:b6:11:69:7b:1e:54:ee:8c:1a:22:ac:
                    72:97:3f:23:59:9b:c9:22:84:c1:07:4f:cc:7f:e2:
                    57:ca:12:70:bb:a6:65:f3:69:75:63:bd:95:fb:1b:
                    97:cd:e4:a8:af:f6:d1:4e:a8:d9:8a:71:24:cd:36:
                    3d:bc:96:c4:f1:6c:a9:ae:e5:cf:0d:6e:28:0d:b0:
                    0e:b5:ca:51:7b:78:14:c3:20:2f:7f:fb:14:55:e1:
                    11:99:fd:d5:0a:a1:9e:02:e3:62:5f:eb:35:4b:2c:
                    b8:72:e8:3e:3d:4f:ac:2c:bb:2e:86:e2:a3:76:8f:
                    e5:93:2a:cf:a5:ab:c8:5c:8d:4b:06:ff:12:46:ac:
                    78:cb:14:07:35:e0:a9:df:8b:e9:af:15:4f:16:89:
                    5b:bd:f6:8d:c6:59:ae:88:85:0e:c1:89:eb:1f:67:
                    c5:45:8e:ff:6d:37:36:2b:78:66:83:91:51:2b:3d:
                    ff:51:77:76:62:a1:ec:67:3e:3e:81:83:e0:56:a9:
                    50:1f:1f:7a:99:ab:63:bf:84:17:77:f1:0d:3b:df:
                    f7:9c:61:b3:35:98:8a:3a:b2:ec:3c:1a:37:3f:7e:
                    8f:92:cf:d9:12:14:64:da:10:02:15:41:ff:4f:c4:
                    eb:1c:a3:c9:fa:99:f7:46:e9:e1:18:d9:b1:b8:32:
                    2d:cb:14:0c:50:d8:83:65:83:ee:b9:5c:cf:cb:05:
                    5a:4c:fa:19:97:6b:d6:5d:13:d3:c2:5c:54:bc:32:
                    73:a0:78:f5:f1:6d:1e:cb:9f:a5:a6:9f:22:dc:d1:
                    51:9e:82:79:64:60:29:13:3e:a3:fd:4f:72:6a:ab:
                    e2:d4:e5:b8:24:55:2c:44:4b:8a:88:44:9c:ca:84:
                    d3:2a:3b
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Subject Key Identifier: 
                82:21:2D:66:C6:D7:A0:E0:15:EB:CE:4C:09:77:C4:60:9E:54:6E:03
    Signature Algorithm: sha256WithRSAEncryption
         60:de:1a:b8:e7:f2:60:82:d5:03:33:81:cb:06:8a:f1:22:49:
         e9:e8:ea:91:7f:c6:33:5e:68:19:03:86:3b:43:01:cf:07:70:
         e4:08:1e:65:85:91:e6:11:22:b7:f5:02:23:8e:ae:b9:1e:7d:
         1f:7e:6c:e6:bd:25:d5:95:1a:f2:05:a6:af:85:02:6f:ae:f8:
         d6:31:ff:25:c9:4a:c8:c7:8a:a9:d9:9f:4b:49:9b:11:57:99:
         92:43:11:de:b6:33:a4:cc:d7:8d:64:7d:d4:cd:3c:28:2c:b4:
         9a:96:ea:4d:f5:c4:44:c4:25:aa:20:80:d8:29:55:f7:e0:41:
         fc:06:26:ff:b9:36:f5:43:14:03:66:78:e1:11:b1:da:20:5f:
         46:00:78:00:21:a5:1e:00:28:61:78:6f:a8:01:01:8f:9d:34:
         9a:ff:f4:38:90:fb:b8:d1:b3:72:06:c9:71:e6:81:c5:79:ed:
         0b:a6:79:f2:13:0b:9c:f7:5d:0e:7b:24:93:b4:48:db:86:5f:
         de:50:86:78:e7:40:e6:31:a8:90:76:70:61:af:9c:37:2c:11:
         b5:82:b7:aa:ae:24:34:5b:72:0c:69:0d:cd:59:9f:f6:71:af:
         9c:0b:d1:0a:38:f9:06:22:83:53:25:0c:fc:51:c4:e6:be:e2:
         39:95:0b:24:ad:af:d1:95:e4:96:d7:74:64:6b:71:4e:02:3c:
         aa:85:f3:20:a3:43:39:76:5b:6c:50:fe:9a:9c:14:1e:65:14:
         8a:15:bd:a3:82:45:5a:49:56:6a:d2:9c:b1:63:32:e5:61:e0:
         53:22:0e:a7:0a:49:ea:cb:7e:1f:a8:e2:62:80:f6:10:45:52:
         98:06:18:de:a5:cd:2f:7f:aa:d4:e9:3e:08:72:ec:23:03:02:
         3c:a6:aa:d8:bc:67:74:3d:14:17:fb:54:4b:17:e3:d3:79:3d:
         6d:6b:49:c9:28:0e:2e:74:50:bf:0c:d9:46:3a:10:86:c9:a7:
         3f:e9:a0:ec:7f:eb:a5:77:58:69:71:e6:83:0a:37:f2:86:49:
         6a:be:79:08:90:f6:02:16:64:3e:e5:da:4c:7e:0c:34:c9:f9:
         5f:b6:b3:28:51:a7:a7:2b:aa:49:fa:8d:65:29:4e:e3:6b:13:
         a7:94:a3:2d:51:6d:78:0c:44:cb:df:de:08:6f:ce:a3:64:ab:
         d3:95:84:d4:b9:52:54:72:7b:96:25:cc:bc:69:e3:48:6e:0d:
         d0:c7:9d:27:9a:aa:f8:13:92:dd:1e:df:63:9f:35:a9:16:36:
         ec:8c:b8:83:f4:3d:89:8f:cd:b4:17:5e:d7:b3:17:41:10:5d:
         27:73:60:85:57:49:22:07
-----BEGIN CERTIFICATE-----
MIIFRzCCAy+gAwIBAgIJEQA0tk7GNi02MA0GCSqGSIb3DQEBCwUAMEExCzAJBgNV
BAYTAlJPMRQwEgYDVQQKEwtDRVJUU0lHTiBTQTEcMBoGA1UECxMTY2VydFNJR04g
Uk9PVCBDQSBHMjAeFw0xNzAyMDYwOTI3MzVaFw00MjAyMDYwOTI3MzVaMEExCzAJ
BgNVBAYTAlJPMRQwEgYDVQQKEwtDRVJUU0lHTiBTQTEcMBoGA1UECxMTY2VydFNJ
R04gUk9PVCBDQSBHMjCCAiIwDQYJKoZIhvcNAQEBBQADggIPADCCAgoCggIBAMDF
dRmRfUR0dIf+DjuW3NgBFszuY5HnC2/OOwppGnzC46+CjobXXo9X69MhWf05N0Iw
vlDqtg+piNguLWkh59E3GE59kdUWX2tbAMI5Qw02hVK5U2UPHULlj88F0+7cDBrZ
uIt4ImfkabBoxTzkbFpG583H+u/E7Eu9aqSs/cwoUe+StCmrqzWaTOTECMYmzPhp
n+Sc8CnTXPnGFiWeI8MgwT0PPzhAsP6CRDiqWhqKa2NYOLQV07YRaXseVO6MGiKs
cpc/I1mbySKEwQdPzH/iV8oScLumZfNpdWO9lfsbl83kqK/20U6o2YpxJM02PbyW
xPFsqa7lzw1uKA2wDrXKUXt4FMMgL3/7FFXhEZn91QqhngLjYl/rNUssuHLoPj1P
rCy7Lobio3aP5ZMqz6WryFyNSwb/EkaseMsUBzXgqd+L6a8VTxaJW732jcZZroiF
DsGJ6x9nxUWO/203Nit4ZoORUSs9/1F3dmKh7Gc+PoGD4FapUB8fepmrY7+EF3fx
DTvf95xhszWYijqy7DwaNz9+j5LP2RIUZNoQAhVB/0/E6xyjyfqZ90bp4RjZsbgy
LcsUDFDYg2WD7rlcz8sFWkz6GZdr1l0T08JcVLwyc6B49fFtHsufpaafItzRUZ6C
eWRgKRM+o/1Pcmqr4tTluCRVLERLiohEnMqE0yo7AgMBAAGjQjBAMA8GA1UdEwEB
/wQFMAMBAf8wDgYDVR0PAQH/BAQDAgEGMB0GA1UdDgQWBBSCIS1mxteg4BXrzkwJ
d8RgnlRuAzANBgkqhkiG9w0BAQsFAAOCAgEAYN4auOfyYILVAzOBywaK8SJJ6ejq
kX/GM15oGQOGO0MBzwdw5AgeZYWR5hEit/UCI46uuR59H35s5r0l1ZUa8gWmr4UC
b6741jH/JclKyMeKqdmfS0mbEVeZkkMR3rYzpMzXjWR91M08KCy0mpbqTfXERMQl
qiCA2ClV9+BB/AYm/7k29UMUA2Z44RGx2iBfRgB4ACGlHgAoYXhvqAEBj500mv/0
OJD7uNGzcgbJceaBxXntC6Z58hMLnPddDnskk7RI24Zf3lCGeOdA5jGokHZwYa+c
NywRtYK3qq4kNFtyDGkNzVmf9nGvnAvRCjj5BiKDUyUM/FHE5r7iOZULJK2v0ZXk
ltd0ZGtxTgI8qoXzIKNDOXZbbFD+mpwUHmUUihW9o4JFWklWatKcsWMy5WHgUyIO
pwpJ6st+H6jiYoD2EEVSmAYY3qXNL3+q1Ok+CHLsIwMCPKaq2LxndD0UF/tUSxfj
03k9bWtJySgOLnRQvwzZRjoQhsmnP+mg7H/rpXdYaXHmgwo38oZJar55CJD2AhZk
PuXaTH4MNMn5X7azKFGnpyuqSfqNZSlO42sTp5SjLVFteAxEy9/eCG/Oo2Sr05WE
1LlSVHJ7liXMvGnjSG4N0MedJ5qq+BOS3R7fY581qRY27Iy4g/Q9iY/NtBde17MX
QRBdJ3NghVdJIgc=
-----END CERTIFICATE-----

Trustwave Global Certification Authority
================================================
SHA1 Fingerprint=2F:8F:36:4F:E1:58:97:44:21:59:87:A5:2A:9A:D0:69:95:26:7F:B5
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            05:f7:0e:86:da:49:f3:46:35:2e:ba:b2
    Signature Algorithm: sha256WithRSAEncryption
        Issuer: C=US, ST=Illinois, L=Chicago, O=Trustwave Holdings, Inc., CN=Trustwave Global Certification Authority
        Validity
            Not Before: Aug 23 19:34:12 2017 GMT
            Not After : Aug 23 19:34:12 2042 GMT
        Subject: C=US, ST=Illinois, L=Chicago, O=Trustwave Holdings, Inc., CN=Trustwave Global Certification Authority
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (4096 bit)
                Modulus:
                    00:b9:5d:51:28:4b:3c:37:92:d1:82:ce:bd:1d:bd:
                    cd:dd:b8:ab:cf:0a:3e:e1:5d:e5:dc:aa:09:b9:57:
                    02:3e:e6:63:61:df:f2:0f:82:63:ae:a3:f7:ac:73:
                    d1:7c:e7:b3:0b:af:08:00:09:59:7f:cd:29:2a:88:
                    93:87:17:18:80:ed:88:b2:b4:b6:10:1f:2d:d6:5f:
                    55:a2:13:5d:d1:c6:eb:06:56:89:88:fe:ac:32:9d:
                    fd:5c:c3:05:c7:6e:ee:86:89:ba:88:03:9d:72:21:
                    86:90:ae:8f:03:a5:dc:9f:88:28:cb:a3:92:49:0f:
                    ec:d0:0f:e2:6d:44:4f:80:6a:b2:d4:e7:a0:0a:53:
                    01:ba:8e:97:91:76:6e:bc:fc:d5:6b:36:e6:40:88:
                    d6:7b:2f:5f:05:e8:2c:6d:11:f3:e7:b2:be:92:44:
                    4c:d2:97:a4:fe:d2:72:81:43:07:9c:e9:11:3e:f5:
                    8b:1a:59:7d:1f:68:58:dd:04:00:2c:96:f3:43:b3:
                    7e:98:19:74:d9:9c:73:d9:18:be:41:c7:34:79:d9:
                    f4:62:c2:43:b9:b3:27:b0:22:cb:f9:3d:52:c7:30:
                    47:b3:c9:3e:b8:6a:e2:e7:e8:81:70:5e:42:8b:4f:
                    26:a5:fe:3a:c2:20:6e:bb:f8:16:8e:cd:0c:a9:b4:
                    1b:6c:76:10:e1:58:79:46:3e:54:ce:80:a8:57:09:
                    37:29:1b:99:13:8f:0c:c8:d6:2c:1c:fb:05:e8:08:
                    95:3d:65:46:dc:ee:cd:69:e2:4d:8f:87:28:4e:34:
                    0b:3e:cf:14:d9:bb:dd:b6:50:9a:ad:77:d4:19:d6:
                    da:1a:88:c8:4e:1b:27:75:d8:b2:08:f1:ae:83:30:
                    b9:11:0e:cd:87:f0:84:8d:15:72:7c:a1:ef:cc:f2:
                    88:61:ba:f4:69:bb:0c:8c:0b:75:57:04:b8:4e:2a:
                    14:2e:3d:0f:1c:1e:32:a6:62:36:ee:66:e2:22:b8:
                    05:40:63:10:22:f3:33:1d:74:72:8a:2c:f5:39:29:
                    a0:d3:e7:1b:80:84:2d:c5:3d:e3:4d:b1:fd:1a:6f:
                    ba:65:07:3b:58:ec:42:45:26:fb:d8:da:25:72:c4:
                    f6:00:b1:22:79:bd:e3:7c:59:62:4a:9c:05:6f:3d:
                    ce:e6:d6:47:63:99:c6:24:6f:72:12:c8:ac:7f:90:
                    b4:0b:91:70:e8:b7:e6:16:10:71:17:ce:de:06:4f:
                    48:41:7d:35:4a:a3:89:f2:c9:4b:7b:41:11:6d:67:
                    b7:08:98:4c:e5:11:19:ae:42:80:dc:fb:90:05:d4:
                    f8:50:ca:be:e4:ad:c7:c2:94:d7:16:9d:e6:17:8f:
                    af:36:fb
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Subject Key Identifier: 
                99:E0:19:67:0D:62:DB:76:B3:DA:3D:B8:5B:E8:FD:42:D2:31:0E:87
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
    Signature Algorithm: sha256WithRSAEncryption
         98:73:70:e2:b0:d3:ed:39:ec:4c:60:d9:a9:12:86:17:1e:96:
         d0:e8:54:28:3b:64:2d:21:a6:f8:9d:56:13:6a:48:3d:4f:c7:
         3e:29:db:6d:58:83:54:3d:87:7d:23:05:d4:e4:1c:dc:e8:38:
         65:86:c5:75:a7:5a:db:35:05:bd:77:de:bb:29:37:40:05:07:
         c3:94:52:9f:ca:64:dd:f1:1b:2b:dc:46:0a:10:02:31:fd:4a:
         68:0d:07:64:90:e6:1e:f5:2a:a1:a8:bb:3c:5d:f9:a3:08:0b:
         11:0c:f1:3f:2d:10:94:6f:fe:e2:34:87:83:d6:cf:e5:1b:35:
         6d:d2:03:e1:b0:0d:a8:a0:aa:46:27:82:36:a7:15:b6:08:a6:
         42:54:57:b6:99:5a:e2:0b:79:90:d7:57:12:51:35:19:88:41:
         68:25:d4:37:17:84:15:fb:01:72:dc:95:de:52:26:20:98:26:
         e2:76:f5:27:6f:fa:00:3b:4a:61:d9:0d:cb:51:93:2a:fd:16:
         06:96:a7:23:9a:23:48:fe:51:bd:b6:c4:b0:b1:54:ce:de:6c:
         41:ad:16:67:7e:db:fd:38:cd:b9:38:4e:b2:c1:60:cb:9d:17:
         df:58:9e:7a:62:b2:26:8f:74:95:9b:e4:5b:1d:d2:0f:dd:98:
         1c:9b:59:b9:23:d3:31:a0:a6:ff:38:dd:cf:20:4f:e9:58:56:
         3a:67:c3:d1:f6:99:99:9d:ba:36:b6:80:2f:88:47:4f:86:bf:
         44:3a:80:e4:37:1c:a6:ba:ea:97:98:11:d0:84:62:47:64:1e:
         aa:ee:40:bf:34:b1:9c:8f:4e:e1:f2:92:4f:1f:8e:f3:9e:97:
         de:f3:a6:79:6a:89:71:4f:4b:27:17:48:fe:ec:f4:50:0f:4f:
         49:7d:cc:45:e3:bd:7a:40:c5:41:dc:61:56:27:06:69:e5:72:
         41:81:d3:b6:01:89:a0:2f:3a:72:79:fe:3a:30:bf:41:ec:c7:
         62:3e:91:4b:c7:d9:31:76:42:f9:f7:3c:63:ec:26:8c:73:0c:
         7d:1a:1d:ea:a8:7c:87:a8:c2:27:7c:e1:33:41:0f:cf:cf:fc:
         00:a0:22:80:9e:4a:a7:6f:00:b0:41:45:b7:22:ca:68:48:c5:
         42:a2:ae:dd:1d:f2:e0:6e:4e:05:58:b1:c0:90:16:2a:a4:3d:
         10:40:be:8f:62:63:83:a9:9c:82:7d:2d:02:e9:83:30:7c:cb:
         27:c9:fd:1e:66:00:b0:2e:d3:21:2f:8e:33:16:6c:98:ed:10:
         a8:07:d6:cc:93:cf:db:d1:69:1c:e4:ca:c9:e0:b6:9c:e9:ce:
         71:71:de:6c:3f:16:a4:79
-----BEGIN CERTIFICATE-----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-----END CERTIFICATE-----

Trustwave Global ECC P256 Certification Authority
=================================================
SHA1 Fingerprint=B4:90:82:DD:45:0C:BE:8B:5B:B1:66:D3:E2:A4:08:26:CD:ED:42:CF
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            0d:6a:5f:08:3f:28:5c:3e:51:95:df:5d
    Signature Algorithm: ecdsa-with-SHA256
        Issuer: C=US, ST=Illinois, L=Chicago, O=Trustwave Holdings, Inc., CN=Trustwave Global ECC P256 Certification Authority
        Validity
            Not Before: Aug 23 19:35:10 2017 GMT
            Not After : Aug 23 19:35:10 2042 GMT
        Subject: C=US, ST=Illinois, L=Chicago, O=Trustwave Holdings, Inc., CN=Trustwave Global ECC P256 Certification Authority
        Subject Public Key Info:
            Public Key Algorithm: id-ecPublicKey
                Public-Key: (256 bit)
                pub: 
                    04:7e:fb:6c:e6:23:e3:73:32:08:ca:60:e6:53:9c:
                    ba:74:8d:18:b0:78:90:52:80:dd:38:c0:4a:1d:d1:
                    a8:cc:93:a4:97:06:38:ca:0d:15:62:c6:8e:01:2a:
                    65:9d:aa:df:34:91:2e:81:c1:e4:33:92:31:c4:fd:
                    09:3a:a6:3f:ad
                ASN1 OID: prime256v1
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Subject Key Identifier: 
                A3:41:06:AC:90:6D:D1:4A:EB:75:A5:4A:10:99:B3:B1:A1:8B:4A:F7
    Signature Algorithm: ecdsa-with-SHA256
         30:44:02:20:07:e6:54:da:0e:a0:5a:b2:ae:11:9f:87:c5:b6:
         ff:69:de:25:be:f8:a0:b7:08:f3:44:ce:2a:df:08:21:0c:37:
         02:20:2d:26:03:a0:05:bd:6b:d1:f6:5c:f8:65:cc:86:6d:b3:
         9c:34:48:63:84:09:c5:8d:77:1a:e2:cc:9c:e1:74:7b
-----BEGIN CERTIFICATE-----
MIICYDCCAgegAwIBAgIMDWpfCD8oXD5Rld9dMAoGCCqGSM49BAMCMIGRMQswCQYD
VQQGEwJVUzERMA8GA1UECBMISWxsaW5vaXMxEDAOBgNVBAcTB0NoaWNhZ28xITAf
BgNVBAoTGFRydXN0d2F2ZSBIb2xkaW5ncywgSW5jLjE6MDgGA1UEAxMxVHJ1c3R3
YXZlIEdsb2JhbCBFQ0MgUDI1NiBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTAeFw0x
NzA4MjMxOTM1MTBaFw00MjA4MjMxOTM1MTBaMIGRMQswCQYDVQQGEwJVUzERMA8G
A1UECBMISWxsaW5vaXMxEDAOBgNVBAcTB0NoaWNhZ28xITAfBgNVBAoTGFRydXN0
d2F2ZSBIb2xkaW5ncywgSW5jLjE6MDgGA1UEAxMxVHJ1c3R3YXZlIEdsb2JhbCBF
Q0MgUDI1NiBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTBZMBMGByqGSM49AgEGCCqG
SM49AwEHA0IABH77bOYj43MyCMpg5lOcunSNGLB4kFKA3TjASh3RqMyTpJcGOMoN
FWLGjgEqZZ2q3zSRLoHB5DOSMcT9CTqmP62jQzBBMA8GA1UdEwEB/wQFMAMBAf8w
DwYDVR0PAQH/BAUDAwcGADAdBgNVHQ4EFgQUo0EGrJBt0UrrdaVKEJmzsaGLSvcw
CgYIKoZIzj0EAwIDRwAwRAIgB+ZU2g6gWrKuEZ+Hxbb/ad4lvvigtwjzRM4q3wgh
DDcCIC0mA6AFvWvR9lz4ZcyGbbOcNEhjhAnFjXca4syc4XR7
-----END CERTIFICATE-----

Trustwave Global ECC P384 Certification Authority
=================================================
SHA1 Fingerprint=E7:F3:A3:C8:CF:6F:C3:04:2E:6D:0E:67:32:C5:9E:68:95:0D:5E:D2
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            08:bd:85:97:6c:99:27:a4:80:68:47:3b
    Signature Algorithm: ecdsa-with-SHA384
        Issuer: C=US, ST=Illinois, L=Chicago, O=Trustwave Holdings, Inc., CN=Trustwave Global ECC P384 Certification Authority
        Validity
            Not Before: Aug 23 19:36:43 2017 GMT
            Not After : Aug 23 19:36:43 2042 GMT
        Subject: C=US, ST=Illinois, L=Chicago, O=Trustwave Holdings, Inc., CN=Trustwave Global ECC P384 Certification Authority
        Subject Public Key Info:
            Public Key Algorithm: id-ecPublicKey
                Public-Key: (384 bit)
                pub: 
                    04:6b:da:0d:75:35:08:31:47:05:ae:45:99:55:f1:
                    11:13:2e:4a:f8:10:31:23:a3:7e:83:d3:7f:28:08:
                    3a:26:1a:3a:cf:97:82:1f:80:b7:27:09:8f:d1:8e:
                    30:c4:0a:9b:0e:ac:58:04:ab:f7:36:7d:94:23:a4:
                    9b:0a:8a:8b:ab:eb:fd:39:25:66:f1:5e:fe:8c:ae:
                    8d:41:79:9d:09:60:ce:28:a9:d3:8a:6d:f3:d6:45:
                    d4:f2:98:84:38:65:a0
                ASN1 OID: secp384r1
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Subject Key Identifier: 
                55:A9:84:89:D2:C1:32:BD:18:CB:6C:A6:07:4E:C8:E7:9D:BE:82:90
    Signature Algorithm: ecdsa-with-SHA384
         30:64:02:30:37:01:92:97:45:12:7e:a0:f3:3e:ad:19:3a:72:
         dd:f4:50:93:03:12:be:44:d2:4f:41:a4:8c:9c:9d:1f:a3:f6:
         c2:92:e7:48:14:fe:4e:9b:a5:91:57:ae:c6:37:72:bb:02:30:
         67:25:0a:b1:0c:5e:ee:a9:63:92:6f:e5:90:0b:fe:66:22:ca:
         47:fd:8a:31:f7:83:fe:7a:bf:10:be:18:2b:1e:8f:f6:29:1e:
         94:59:ef:8e:21:37:cb:51:98:a5:6e:4b
-----BEGIN CERTIFICATE-----
MIICnTCCAiSgAwIBAgIMCL2Fl2yZJ6SAaEc7MAoGCCqGSM49BAMDMIGRMQswCQYD
VQQGEwJVUzERMA8GA1UECBMISWxsaW5vaXMxEDAOBgNVBAcTB0NoaWNhZ28xITAf
BgNVBAoTGFRydXN0d2F2ZSBIb2xkaW5ncywgSW5jLjE6MDgGA1UEAxMxVHJ1c3R3
YXZlIEdsb2JhbCBFQ0MgUDM4NCBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTAeFw0x
NzA4MjMxOTM2NDNaFw00MjA4MjMxOTM2NDNaMIGRMQswCQYDVQQGEwJVUzERMA8G
A1UECBMISWxsaW5vaXMxEDAOBgNVBAcTB0NoaWNhZ28xITAfBgNVBAoTGFRydXN0
d2F2ZSBIb2xkaW5ncywgSW5jLjE6MDgGA1UEAxMxVHJ1c3R3YXZlIEdsb2JhbCBF
Q0MgUDM4NCBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTB2MBAGByqGSM49AgEGBSuB
BAAiA2IABGvaDXU1CDFHBa5FmVXxERMuSvgQMSOjfoPTfygIOiYaOs+Xgh+AtycJ
j9GOMMQKmw6sWASr9zZ9lCOkmwqKi6vr/TklZvFe/oyujUF5nQlgziip04pt89ZF
1PKYhDhloKNDMEEwDwYDVR0TAQH/BAUwAwEB/zAPBgNVHQ8BAf8EBQMDBwYAMB0G
A1UdDgQWBBRVqYSJ0sEyvRjLbKYHTsjnnb6CkDAKBggqhkjOPQQDAwNnADBkAjA3
AZKXRRJ+oPM+rRk6ct30UJMDEr5E0k9BpIycnR+j9sKS50gU/k6bpZFXrsY3crsC
MGclCrEMXu6pY5Jv5ZAL/mYiykf9ijH3g/56vxC+GCsej/YpHpRZ744hN8tRmKVu
Sw==
-----END CERTIFICATE-----

NAVER Global Root Certification Authority
=================================================
SHA1 Fingerprint=8F:6B:F2:A9:27:4A:DA:14:A0:C4:F4:8E:61:27:F9:C0:1E:78:5D:D1
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            01:94:30:1e:a2:0b:dd:f5:c5:33:2a:b1:43:44:71:f8:d6:50:4d:0d
    Signature Algorithm: sha384WithRSAEncryption
        Issuer: C=KR, O=NAVER BUSINESS PLATFORM Corp., CN=NAVER Global Root Certification Authority
        Validity
            Not Before: Aug 18 08:58:42 2017 GMT
            Not After : Aug 18 23:59:59 2037 GMT
        Subject: C=KR, O=NAVER BUSINESS PLATFORM Corp., CN=NAVER Global Root Certification Authority
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (4096 bit)
                Modulus:
                    00:b6:d4:f1:93:5c:b5:40:89:0a:ab:0d:90:5b:50:
                    63:ae:90:94:74:17:45:72:d6:7b:65:5a:29:4b:a7:
                    56:a0:4b:b8:2f:42:75:e9:d9:7b:24:5a:31:65:ab:
                    17:17:d1:33:3a:d9:11:dc:40:36:87:df:c7:6a:e9:
                    26:5e:59:8a:77:e3:e8:48:9c:31:16:fa:3e:91:b1:
                    ca:c9:a3:e2:9f:ce:21:53:a3:02:36:30:cb:52:02:
                    e5:da:32:5d:c3:c5:e6:f9:ee:11:c7:8b:c9:44:1e:
                    84:93:18:4a:b4:9f:e5:12:64:69:d0:26:85:62:01:
                    b6:c9:02:1d:be:83:51:bb:5c:da:f8:ad:15:6a:99:
                    f7:92:54:f7:34:5b:e9:bf:ea:29:81:12:d4:53:91:
                    96:b3:91:5a:dd:fe:90:73:28:fb:30:46:b5:ca:08:
                    07:c7:71:72:c9:66:d3:34:97:f6:8c:f4:18:4a:e1:
                    d0:3d:5a:45:b6:69:a7:29:fb:23:ce:88:d8:12:9c:
                    00:48:a8:a6:0f:b3:3b:92:8d:71:0e:74:c5:8b:c8:
                    4c:f9:f4:9b:8e:b8:3c:69:ed:6f:3b:50:2f:58:ed:
                    c4:b0:d0:1c:1b:6a:0c:e2:bc:44:aa:d8:cd:14:5d:
                    94:78:61:bf:0e:6e:da:2a:bc:2f:0c:0b:71:a6:b3:
                    16:3f:9c:e6:f9:cc:9f:53:35:e2:03:a0:a0:18:bf:
                    bb:f1:be:f4:d6:8c:87:0d:42:f7:06:b9:f1:6d:ed:
                    04:94:a8:fe:b6:d3:06:c6:40:61:df:9d:9d:f3:54:
                    76:ce:53:3a:01:a6:92:41:ec:04:a3:8f:0d:a2:d5:
                    09:ca:d6:cb:9a:f1:ef:43:5d:c0:ab:a5:41:cf:5c:
                    53:70:70:c9:88:a6:2d:d4:6b:61:73:50:26:86:61:
                    0e:5f:1b:c2:2b:e2:8c:d5:bb:9d:c1:03:42:ba:94:
                    da:5f:a9:b0:ca:cc:4d:0a:ef:47:69:03:2f:22:fb:
                    f1:28:ce:bf:5d:50:65:a8:90:6d:b3:74:b0:08:c7:
                    ac:a8:d1:eb:3e:9c:fc:5d:1a:83:2e:2b:cb:b5:f3:
                    44:9d:3a:a7:17:61:96:a2:71:d3:70:96:15:4d:b7:
                    4c:73:ee:19:5c:c5:5b:3e:41:fe:ac:75:60:3b:1b:
                    63:ce:00:dd:da:08:90:62:b4:e5:2d:ee:48:a7:6b:
                    17:99:54:be:87:4a:e3:a9:5e:04:4c:eb:10:6d:54:
                    d6:ef:f1:e8:f2:62:16:cb:80:6b:ed:3d:ed:f5:1f:
                    30:a5:ae:4b:c9:13:ed:8a:01:01:c9:b8:51:58:c0:
                    66:3a:b1:66:4b:c4:d5:31:02:62:e9:74:84:0c:db:
                    4d:46:2d
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Subject Key Identifier: 
                D2:9F:88:DF:A1:CD:2C:BD:EC:F5:3B:01:01:93:33:27:B2:EB:60:4B
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
    Signature Algorithm: sha384WithRSAEncryption
         32:ca:80:b3:9d:3d:54:06:dd:d2:d2:2e:f0:a4:01:21:0b:67:
         48:ca:6d:8e:e0:c8:aa:0d:aa:8d:21:57:8f:c6:3e:7a:ca:db:
         51:d4:52:b3:d4:96:84:a5:58:60:7f:e5:0b:8e:1f:f5:dc:0a:
         15:81:e5:3b:b6:b7:22:2f:09:9c:13:16:b1:6c:0c:35:08:6d:
         ab:63:72:ed:dc:be:ec:c7:57:e6:30:20:71:d6:d7:10:c1:13:
         55:01:8c:2a:43:e4:41:f1:cf:3a:7a:53:92:ce:a2:03:05:0d:
         38:df:02:bb:10:2e:d9:3b:d2:9b:7a:c0:a1:a6:f8:b5:31:e6:
         f4:75:c9:b9:53:99:75:47:22:5a:14:15:c7:78:1b:b6:9d:e9:
         0c:f8:1b:76:f1:85:84:de:a1:da:12:ef:a4:e2:10:97:7a:78:
         de:0c:51:97:a8:21:40:8b:86:bd:0d:f0:5e:4e:4b:36:bb:3b:
         20:1f:8a:42:56:e1:0b:1a:bf:7b:d0:22:43:2c:44:8c:fb:e5:
         2a:b4:6c:1c:1c:ba:94:e0:13:7e:21:e6:9a:c2:cb:c5:42:64:
         b4:1e:94:7b:08:25:c8:71:cc:87:45:57:85:d3:9f:29:62:22:
         83:51:97:00:18:97:77:6a:98:92:c9:7c:60:6c:df:6c:7d:4a:
         e4:70:4c:c2:9e:b8:1d:f7:d0:34:c7:0f:cc:fb:a7:ff:03:be:
         ad:70:90:da:0b:dd:c8:6d:97:5f:9a:7f:09:32:41:fd:cd:a2:
         cc:5a:6d:4c:f2:aa:49:fe:66:f8:e9:d8:35:eb:0e:28:1e:ee:
         48:2f:3a:d0:79:09:38:7c:a6:22:82:93:95:d0:03:be:be:02:
         a0:05:dd:20:22:e3:6f:1d:88:34:60:c6:e6:0a:b9:09:75:0b:
         f0:07:e8:69:96:35:c7:fb:23:81:8e:38:39:b8:45:2b:43:78:
         a2:d1:2c:14:ff:0d:28:72:72:95:9b:5e:09:db:89:44:98:aa:
         a1:49:bb:71:52:f2:bf:f6:ff:27:a1:36:af:b8:b6:77:88:dd:
         3a:a4:6d:9b:34:90:dc:14:5d:30:bf:b7:eb:17:e4:87:b7:71:
         d0:a1:d7:77:15:d4:42:d7:f2:f3:31:99:5d:9b:dd:16:6d:3f:
         ea:06:23:f8:46:a2:22:ed:93:f6:dd:9a:e6:2a:87:b1:98:54:
         f1:22:f7:6b:45:e3:e2:8e:76:1d:9a:8d:c4:06:8d:36:b7:14:
         f3:9d:54:69:b7:8e:3c:d5:a4:6d:93:81:b7:ad:f6:bd:64:7b:
         c2:c9:68:39:a0:92:9c:cd:34:86:91:90:fa:64:51:9d:fe:fe:
         eb:a5:f5:75:de:89:f7:72
-----BEGIN CERTIFICATE-----
MIIFojCCA4qgAwIBAgIUAZQwHqIL3fXFMyqxQ0Rx+NZQTQ0wDQYJKoZIhvcNAQEM
BQAwaTELMAkGA1UEBhMCS1IxJjAkBgNVBAoMHU5BVkVSIEJVU0lORVNTIFBMQVRG
T1JNIENvcnAuMTIwMAYDVQQDDClOQVZFUiBHbG9iYWwgUm9vdCBDZXJ0aWZpY2F0
aW9uIEF1dGhvcml0eTAeFw0xNzA4MTgwODU4NDJaFw0zNzA4MTgyMzU5NTlaMGkx
CzAJBgNVBAYTAktSMSYwJAYDVQQKDB1OQVZFUiBCVVNJTkVTUyBQTEFURk9STSBD
b3JwLjEyMDAGA1UEAwwpTkFWRVIgR2xvYmFsIFJvb3QgQ2VydGlmaWNhdGlvbiBB
dXRob3JpdHkwggIiMA0GCSqGSIb3DQEBAQUAA4ICDwAwggIKAoICAQC21PGTXLVA
iQqrDZBbUGOukJR0F0Vy1ntlWilLp1agS7gvQnXp2XskWjFlqxcX0TM62RHcQDaH
38dq6SZeWYp34+hInDEW+j6RscrJo+KfziFTowI2MMtSAuXaMl3Dxeb57hHHi8lE
HoSTGEq0n+USZGnQJoViAbbJAh2+g1G7XNr4rRVqmfeSVPc0W+m/6imBEtRTkZaz
kVrd/pBzKPswRrXKCAfHcXLJZtM0l/aM9BhK4dA9WkW2aacp+yPOiNgSnABIqKYP
szuSjXEOdMWLyEz59JuOuDxp7W87UC9Y7cSw0BwbagzivESq2M0UXZR4Yb8Obtoq
vC8MC3GmsxY/nOb5zJ9TNeIDoKAYv7vxvvTWjIcNQvcGufFt7QSUqP620wbGQGHf
nZ3zVHbOUzoBppJB7ASjjw2i1QnK1sua8e9DXcCrpUHPXFNwcMmIpi3Ua2FzUCaG
YQ5fG8Ir4ozVu53BA0K6lNpfqbDKzE0K70dpAy8i+/Eozr9dUGWokG2zdLAIx6yo
0es+nPxdGoMuK8u180SdOqcXYZaicdNwlhVNt0xz7hlcxVs+Qf6sdWA7G2POAN3a
CJBitOUt7kinaxeZVL6HSuOpXgRM6xBtVNbv8ejyYhbLgGvtPe31HzClrkvJE+2K
AQHJuFFYwGY6sWZLxNUxAmLpdIQM201GLQIDAQABo0IwQDAdBgNVHQ4EFgQU0p+I
36HNLL3s9TsBAZMzJ7LrYEswDgYDVR0PAQH/BAQDAgEGMA8GA1UdEwEB/wQFMAMB
Af8wDQYJKoZIhvcNAQEMBQADggIBADLKgLOdPVQG3dLSLvCkASELZ0jKbY7gyKoN
qo0hV4/GPnrK21HUUrPUloSlWGB/5QuOH/XcChWB5Tu2tyIvCZwTFrFsDDUIbatj
cu3cvuzHV+YwIHHW1xDBE1UBjCpD5EHxzzp6U5LOogMFDTjfArsQLtk70pt6wKGm
+LUx5vR1yblTmXVHIloUFcd4G7ad6Qz4G3bxhYTeodoS76TiEJd6eN4MUZeoIUCL
hr0N8F5OSza7OyAfikJW4Qsav3vQIkMsRIz75Sq0bBwcupTgE34h5prCy8VCZLQe
lHsIJchxzIdFV4XTnyliIoNRlwAYl3dqmJLJfGBs32x9SuRwTMKeuB330DTHD8z7
p/8Dvq1wkNoL3chtl1+afwkyQf3NosxabUzyqkn+Zvjp2DXrDige7kgvOtB5CTh8
piKCk5XQA76+AqAF3SAi428diDRgxuYKuQl1C/AH6GmWNcf7I4GOODm4RStDeKLR
LBT/DShycpWbXgnbiUSYqqFJu3FS8r/2/yehNq+4tneI3TqkbZs0kNwUXTC/t+sX
5Ie3cdCh13cV1ELX8vMxmV2b3RZtP+oGI/hGoiLtk/bdmuYqh7GYVPEi92tF4+KO
dh2ajcQGjTa3FPOdVGm3jjzVpG2Tgbet9r1ke8LJaDmgkpzNNIaRkPpkUZ3+/uul
9XXeifdy
-----END CERTIFICATE-----

AC RAIZ FNMT-RCM SERVIDORES SEGUROS
=================================================
SHA1 Fingerprint=62:FF:D9:9E:C0:65:0D:03:CE:75:93:D2:ED:3F:2D:32:C9:E3:E5:4A
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            62:f6:32:6c:e5:c4:e3:68:5c:1b:62:dd:9c:2e:9d:95
    Signature Algorithm: ecdsa-with-SHA384
        Issuer: C=ES, O=FNMT-RCM, OU=Ceres/2.5.4.97=VATES-Q2826004J, CN=AC RAIZ FNMT-RCM SERVIDORES SEGUROS
        Validity
            Not Before: Dec 20 09:37:33 2018 GMT
            Not After : Dec 20 09:37:33 2043 GMT
        Subject: C=ES, O=FNMT-RCM, OU=Ceres/2.5.4.97=VATES-Q2826004J, CN=AC RAIZ FNMT-RCM SERVIDORES SEGUROS
        Subject Public Key Info:
            Public Key Algorithm: id-ecPublicKey
                Public-Key: (384 bit)
                pub: 
                    04:f6:ba:57:53:c8:ca:ab:df:36:4a:52:21:e4:97:
                    d2:83:67:9e:f0:65:51:d0:5e:87:c7:47:b1:59:f2:
                    57:47:9b:00:02:93:44:17:69:db:42:c7:b1:b2:3a:
                    18:0e:b4:5d:8c:b3:66:5d:a1:34:f9:36:2c:49:db:
                    f3:46:fc:b3:44:69:44:13:66:fd:d7:c5:fd:af:36:
                    4d:ce:03:4d:07:71:cf:af:6a:05:d2:a2:43:5a:0a:
                    52:6f:01:03:4e:8e:8b
                ASN1 OID: secp384r1
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Subject Key Identifier: 
                01:B9:2F:EF:BF:11:86:60:F2:4F:D0:41:6E:AB:73:1F:E7:D2:6E:49
    Signature Algorithm: ecdsa-with-SHA384
         30:66:02:31:00:ae:4a:e3:2b:40:c3:74:11:f2:95:ad:16:23:
         de:4e:0c:1a:e6:5d:a5:24:5e:6b:44:7b:fc:38:e2:4f:cb:9c:
         45:17:11:4c:14:27:26:55:39:75:4a:03:cc:13:90:9f:92:02:
         31:00:fa:4a:6c:60:88:73:f3:ee:b8:98:62:a9:ce:2b:c2:d9:
         8a:a6:70:31:1d:af:b0:94:4c:eb:4f:c6:e3:d1:f3:62:a7:3c:
         ff:93:2e:07:5c:49:01:67:69:12:02:72:bf:e7
-----BEGIN CERTIFICATE-----
MIICbjCCAfOgAwIBAgIQYvYybOXE42hcG2LdnC6dlTAKBggqhkjOPQQDAzB4MQsw
CQYDVQQGEwJFUzERMA8GA1UECgwIRk5NVC1SQ00xDjAMBgNVBAsMBUNlcmVzMRgw
FgYDVQRhDA9WQVRFUy1RMjgyNjAwNEoxLDAqBgNVBAMMI0FDIFJBSVogRk5NVC1S
Q00gU0VSVklET1JFUyBTRUdVUk9TMB4XDTE4MTIyMDA5MzczM1oXDTQzMTIyMDA5
MzczM1oweDELMAkGA1UEBhMCRVMxETAPBgNVBAoMCEZOTVQtUkNNMQ4wDAYDVQQL
DAVDZXJlczEYMBYGA1UEYQwPVkFURVMtUTI4MjYwMDRKMSwwKgYDVQQDDCNBQyBS
QUlaIEZOTVQtUkNNIFNFUlZJRE9SRVMgU0VHVVJPUzB2MBAGByqGSM49AgEGBSuB
BAAiA2IABPa6V1PIyqvfNkpSIeSX0oNnnvBlUdBeh8dHsVnyV0ebAAKTRBdp20LH
sbI6GA60XYyzZl2hNPk2LEnb80b8s0RpRBNm/dfF/a82Tc4DTQdxz69qBdKiQ1oK
Um8BA06Oi6NCMEAwDwYDVR0TAQH/BAUwAwEB/zAOBgNVHQ8BAf8EBAMCAQYwHQYD
VR0OBBYEFAG5L++/EYZg8k/QQW6rcx/n0m5JMAoGCCqGSM49BAMDA2kAMGYCMQCu
SuMrQMN0EfKVrRYj3k4MGuZdpSRea0R7/DjiT8ucRRcRTBQnJlU5dUoDzBOQn5IC
MQD6SmxgiHPz7riYYqnOK8LZiqZwMR2vsJRM60/G49HzYqc8/5MuB1xJAWdpEgJy
v+c=
-----END CERTIFICATE-----

GlobalSign Root R46
=================================================
SHA1 Fingerprint=53:A2:B0:4B:CA:6B:D6:45:E6:39:8A:8E:C4:0D:D2:BF:77:C3:A2:90
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            11:d2:bb:b9:d7:23:18:9e:40:5f:0a:9d:2d:d0:df:25:67:d1
    Signature Algorithm: sha384WithRSAEncryption
        Issuer: C=BE, O=GlobalSign nv-sa, CN=GlobalSign Root R46
        Validity
            Not Before: Mar 20 00:00:00 2019 GMT
            Not After : Mar 20 00:00:00 2046 GMT
        Subject: C=BE, O=GlobalSign nv-sa, CN=GlobalSign Root R46
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (4096 bit)
                Modulus:
                    00:ac:ac:74:32:e8:b3:65:e5:ba:ed:43:26:1d:a6:
                    89:0d:45:ba:29:88:b2:a4:1d:63:dd:d3:c1:2c:09:
                    57:89:39:a1:55:e9:67:34:77:0c:6e:e4:55:1d:52:
                    25:d2:13:6b:5e:e1:1d:a9:b7:7d:89:32:5f:0d:9e:
                    9f:2c:7a:63:60:40:1f:a6:b0:b6:78:8f:99:54:96:
                    08:58:ae:e4:06:bc:62:05:02:16:bf:af:a8:23:03:
                    b6:94:0f:bc:6e:6c:c2:cb:d5:a6:bb:0c:e9:f6:c1:
                    02:fb:21:de:66:dd:17:ab:74:42:ef:f0:74:2f:25:
                    f4:ea:6b:55:5b:90:db:9d:df:5e:87:0a:40:fb:ad:
                    19:6b:fb:f7:ca:60:88:de:da:c1:8f:d6:ae:d5:7f:
                    d4:3c:83:ee:d7:16:4c:83:45:33:6b:27:d0:86:d0:
                    1c:2d:6b:f3:ab:7d:f1:85:a9:f5:28:d2:ad:ef:f3:
                    84:4b:1c:87:fc:13:a3:3a:72:a2:5a:11:2b:d6:27:
                    71:27:ed:81:2d:6d:66:81:92:87:b4:1b:58:7a:cc:
                    3f:0a:fa:46:4f:4d:78:5c:f8:2b:48:e3:04:84:cb:
                    5d:f6:b4:6a:b3:65:fc:42:9e:51:26:23:20:cb:3d:
                    14:f9:81:ed:65:16:00:4f:1a:64:97:66:08:cf:8c:
                    7b:e3:2b:c0:9d:f9:14:f2:1b:f1:56:6a:16:bf:2c:
                    85:85:cd:78:38:9a:eb:42:6a:02:34:18:83:17:4e:
                    94:56:f8:b6:82:b5:f3:96:dd:3d:f3:be:7f:20:77:
                    3e:7b:19:23:6b:2c:d4:72:73:43:57:7d:e0:f8:d7:
                    69:4f:17:36:04:f9:c0:90:60:37:45:de:e6:0c:d8:
                    74:8d:ae:9c:a2:6d:74:5d:42:be:06:f5:d9:64:6e:
                    02:10:ac:89:b0:4c:3b:07:4d:40:7e:24:c5:8a:98:
                    82:79:8e:a4:a7:82:20:8d:23:fa:27:71:c9:df:c6:
                    41:74:a0:4d:f6:91:16:dc:46:8c:5f:29:63:31:59:
                    71:0c:d8:6f:c2:b6:32:7d:fb:e6:5d:53:a6:7e:15:
                    fc:bb:75:7c:5d:ec:f8:f6:17:1c:ec:c7:6b:19:cb:
                    f3:7b:f0:2b:07:a5:d9:6c:79:54:76:6c:9d:1c:a6:
                    6e:0e:e9:79:0c:a8:23:6a:a3:df:1b:30:31:9f:b1:
                    54:7b:fe:6a:cb:66:aa:dc:65:d0:a2:9e:4a:9a:07:
                    21:6b:81:8f:db:c4:59:fa:de:22:c0:04:9c:e3:aa:
                    5b:36:93:e8:3d:bd:7a:a1:9d:0b:76:b1:0b:c7:9d:
                    fd:cf:98:a8:06:c2:f8:2a:a3:a1:83:a0:b7:25:72:
                    a5:02:e3
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Key Usage: critical
                Digital Signature, Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Subject Key Identifier: 
                03:5C:AB:73:81:87:A8:CC:B0:A6:D5:94:E2:36:96:49:FF:05:99:2C
    Signature Algorithm: sha384WithRSAEncryption
         7c:78:ec:f6:02:2c:bb:5b:7e:92:2b:5d:39:dc:be:d8:1d:a2:
         42:33:4d:f9:ef:a4:2a:3b:44:69:1e:ac:d9:45:a3:4e:3c:a7:
         d8:24:51:b2:54:1c:93:4e:c4:ef:7b:93:85:60:26:ea:09:48:
         e0:f5:bb:c7:e9:68:d2:bb:6a:31:71:cc:79:ae:11:a8:f0:99:
         fd:e5:1f:bc:2f:a8:cc:57:eb:76:c4:21:a6:47:53:55:4d:68:
         bf:05:a4:ee:d7:26:ab:62:da:43:37:4b:e2:c6:b5:e5:b2:83:
         19:3a:c7:d3:db:4d:9e:08:7a:f3:ee:cf:3e:62:fb:ac:e8:60:
         cc:d1:c7:a1:5c:83:45:c4:45:cc:f3:17:6b:14:c9:04:02:3e:
         d2:24:a6:79:e9:1e:ce:a2:e7:c1:59:15:9f:1d:e2:4b:9a:3e:
         9f:76:08:2d:6b:d8:ba:57:14:da:83:ea:fe:8c:55:e9:d0:4e:
         a9:cc:77:31:b1:44:11:7a:5c:b1:3e:d3:14:45:15:18:62:24:
         13:d2:cb:4d:ce:5c:83:c1:36:f2:10:b5:0e:88:6d:b8:e1:56:
         9f:89:de:96:66:39:47:64:2c:6e:4d:ae:62:7b:bf:60:74:19:
         b8:56:ac:92:ac:16:32:ed:ad:68:55:fe:98:ba:d3:34:de:f4:
         c9:61:c3:0e:86:f6:4b:84:60:ee:0d:7b:b5:32:58:79:91:55:
         2c:81:43:b3:74:1f:7a:aa:25:9e:1d:d7:a1:8b:b9:cd:42:2e:
         04:a4:66:83:4d:89:35:b6:6c:a8:36:4a:79:21:78:22:d0:42:
         bc:d1:40:31:90:a1:be:04:cf:ca:67:ed:f5:f0:80:d3:60:c9:
         83:2a:22:05:d0:07:3b:52:bf:0c:9e:aa:2b:f9:bb:e6:1f:8f:
         25:ba:85:8d:17:1e:02:fe:5d:50:04:57:cf:fe:2d:bc:ef:5c:
         c0:1a:ab:b6:9f:24:c6:df:73:68:48:90:2c:14:f4:3f:52:1a:
         e4:d2:cb:14:c3:61:69:cf:e2:f9:18:c5:ba:33:9f:14:a3:04:
         5d:b9:71:f7:b5:94:d8:f6:33:c1:5a:c1:34:8b:7c:9b:dd:93:
         3a:e7:13:a2:70:61:9f:af:8f:eb:d8:c5:75:f8:33:66:d4:74:
         67:3a:37:77:9c:e7:dd:a4:0f:76:43:66:8a:43:f2:9f:fb:0c:
         42:78:63:d1:e2:0f:6f:7b:d4:a1:3d:74:97:85:b7:48:39:41:
         d6:20:fc:d0:3a:b3:fa:e8:6f:c4:8a:ba:71:37:be:8b:97:b1:
         78:31:4f:b3:e7:b6:03:13:ce:54:9d:ae:25:59:cc:7f:35:5f:
         08:f7:40:45:31:78:2a:7a
-----BEGIN CERTIFICATE-----
MIIFWjCCA0KgAwIBAgISEdK7udcjGJ5AXwqdLdDfJWfRMA0GCSqGSIb3DQEBDAUA
MEYxCzAJBgNVBAYTAkJFMRkwFwYDVQQKExBHbG9iYWxTaWduIG52LXNhMRwwGgYD
VQQDExNHbG9iYWxTaWduIFJvb3QgUjQ2MB4XDTE5MDMyMDAwMDAwMFoXDTQ2MDMy
MDAwMDAwMFowRjELMAkGA1UEBhMCQkUxGTAXBgNVBAoTEEdsb2JhbFNpZ24gbnYt
c2ExHDAaBgNVBAMTE0dsb2JhbFNpZ24gUm9vdCBSNDYwggIiMA0GCSqGSIb3DQEB
AQUAA4ICDwAwggIKAoICAQCsrHQy6LNl5brtQyYdpokNRbopiLKkHWPd08EsCVeJ
OaFV6Wc0dwxu5FUdUiXSE2te4R2pt32JMl8Nnp8semNgQB+msLZ4j5lUlghYruQG
vGIFAha/r6gjA7aUD7xubMLL1aa7DOn2wQL7Id5m3RerdELv8HQvJfTqa1VbkNud
316HCkD7rRlr+/fKYIje2sGP1q7Vf9Q8g+7XFkyDRTNrJ9CG0Bwta/OrffGFqfUo
0q3v84RLHIf8E6M6cqJaESvWJ3En7YEtbWaBkoe0G1h6zD8K+kZPTXhc+CtI4wSE
y132tGqzZfxCnlEmIyDLPRT5ge1lFgBPGmSXZgjPjHvjK8Cd+RTyG/FWaha/LIWF
zXg4mutCagI0GIMXTpRW+LaCtfOW3T3zvn8gdz57GSNrLNRyc0NXfeD412lPFzYE
+cCQYDdF3uYM2HSNrpyibXRdQr4G9dlkbgIQrImwTDsHTUB+JMWKmIJ5jqSngiCN
I/onccnfxkF0oE32kRbcRoxfKWMxWXEM2G/CtjJ9++ZdU6Z+Ffy7dXxd7Pj2Fxzs
x2sZy/N78CsHpdlseVR2bJ0cpm4O6XkMqCNqo98bMDGfsVR7/mrLZqrcZdCinkqa
ByFrgY/bxFn63iLABJzjqls2k+g9vXqhnQt2sQvHnf3PmKgGwvgqo6GDoLclcqUC
4wIDAQABo0IwQDAOBgNVHQ8BAf8EBAMCAYYwDwYDVR0TAQH/BAUwAwEB/zAdBgNV
HQ4EFgQUA1yrc4GHqMywptWU4jaWSf8FmSwwDQYJKoZIhvcNAQEMBQADggIBAHx4
7PYCLLtbfpIrXTncvtgdokIzTfnvpCo7RGkerNlFo048p9gkUbJUHJNOxO97k4Vg
JuoJSOD1u8fpaNK7ajFxzHmuEajwmf3lH7wvqMxX63bEIaZHU1VNaL8FpO7XJqti
2kM3S+LGteWygxk6x9PbTZ4IevPuzz5i+6zoYMzRx6Fcg0XERczzF2sUyQQCPtIk
pnnpHs6i58FZFZ8d4kuaPp92CC1r2LpXFNqD6v6MVenQTqnMdzGxRBF6XLE+0xRF
FRhiJBPSy03OXIPBNvIQtQ6IbbjhVp+J3pZmOUdkLG5NrmJ7v2B0GbhWrJKsFjLt
rWhV/pi60zTe9Mlhww6G9kuEYO4Ne7UyWHmRVSyBQ7N0H3qqJZ4d16GLuc1CLgSk
ZoNNiTW2bKg2SnkheCLQQrzRQDGQob4Ez8pn7fXwgNNgyYMqIgXQBztSvwyeqiv5
u+YfjyW6hY0XHgL+XVAEV8/+LbzvXMAaq7afJMbfc2hIkCwU9D9SGuTSyxTDYWnP
4vkYxboznxSjBF25cfe1lNj2M8FawTSLfJvdkzrnE6JwYZ+vj+vYxXX4M2bUdGc6
N3ec592kD3ZDZopD8p/7DEJ4Y9HiD2971KE9dJeFt0g5QdYg/NA6s/rob8SKunE3
vouXsXgxT7PntgMTzlSdriVZzH81Xwj3QEUxeCp6
-----END CERTIFICATE-----

GlobalSign Root E46
=================================================
SHA1 Fingerprint=39:B4:6C:D5:FE:80:06:EB:E2:2F:4A:BB:08:33:A0:AF:DB:B9:DD:84
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            11:d2:bb:ba:33:6e:d4:bc:e6:24:68:c5:0d:84:1d:98:e8:43
    Signature Algorithm: ecdsa-with-SHA384
        Issuer: C=BE, O=GlobalSign nv-sa, CN=GlobalSign Root E46
        Validity
            Not Before: Mar 20 00:00:00 2019 GMT
            Not After : Mar 20 00:00:00 2046 GMT
        Subject: C=BE, O=GlobalSign nv-sa, CN=GlobalSign Root E46
        Subject Public Key Info:
            Public Key Algorithm: id-ecPublicKey
                Public-Key: (384 bit)
                pub: 
                    04:9c:0e:b1:cf:b7:e8:9e:52:77:75:34:fa:a5:46:
                    a7:ad:32:19:32:b4:07:a9:27:ca:94:bb:0c:d2:0a:
                    10:c7:da:89:b0:97:0c:70:13:09:01:8e:d8:ea:47:
                    ea:be:b2:80:2b:cd:fc:28:0d:db:ac:bc:a4:86:37:
                    ed:70:08:00:75:ea:93:0b:7b:2e:52:9c:23:68:23:
                    06:43:ec:92:2f:53:84:db:fb:47:14:07:e8:5f:94:
                    67:5d:c9:7a:81:3c:20
                ASN1 OID: secp384r1
        X509v3 extensions:
            X509v3 Key Usage: critical
                Digital Signature, Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Subject Key Identifier: 
                31:0A:90:8F:B6:C6:9D:D2:44:4B:80:B5:A2:E6:1F:B1:12:4F:1B:95
    Signature Algorithm: ecdsa-with-SHA384
         30:65:02:31:00:df:54:90:ed:9b:ef:8b:94:02:93:17:82:99:
         be:b3:9e:2c:f6:0b:91:8c:9f:4a:14:b1:f6:64:bc:bb:68:51:
         13:0c:03:f7:15:8b:84:60:b9:8b:ff:52:8e:e7:8c:bc:1c:02:
         30:3c:f9:11:d4:8c:4e:c0:c1:61:c2:15:4c:aa:ab:1d:0b:31:
         5f:3b:1c:e2:00:97:44:31:e6:fe:73:96:2f:da:96:d3:fe:08:
         07:b3:34:89:bc:05:9f:f7:1e:86:ee:8b:70
-----BEGIN CERTIFICATE-----
MIICCzCCAZGgAwIBAgISEdK7ujNu1LzmJGjFDYQdmOhDMAoGCCqGSM49BAMDMEYx
CzAJBgNVBAYTAkJFMRkwFwYDVQQKExBHbG9iYWxTaWduIG52LXNhMRwwGgYDVQQD
ExNHbG9iYWxTaWduIFJvb3QgRTQ2MB4XDTE5MDMyMDAwMDAwMFoXDTQ2MDMyMDAw
MDAwMFowRjELMAkGA1UEBhMCQkUxGTAXBgNVBAoTEEdsb2JhbFNpZ24gbnYtc2Ex
HDAaBgNVBAMTE0dsb2JhbFNpZ24gUm9vdCBFNDYwdjAQBgcqhkjOPQIBBgUrgQQA
IgNiAAScDrHPt+ieUnd1NPqlRqetMhkytAepJ8qUuwzSChDH2omwlwxwEwkBjtjq
R+q+soArzfwoDdusvKSGN+1wCAB16pMLey5SnCNoIwZD7JIvU4Tb+0cUB+hflGdd
yXqBPCCjQjBAMA4GA1UdDwEB/wQEAwIBhjAPBgNVHRMBAf8EBTADAQH/MB0GA1Ud
DgQWBBQxCpCPtsad0kRLgLWi5h+xEk8blTAKBggqhkjOPQQDAwNoADBlAjEA31SQ
7Zvvi5QCkxeCmb6zniz2C5GMn0oUsfZkvLtoURMMA/cVi4RguYv/Uo7njLwcAjA8
+RHUjE7AwWHCFUyqqx0LMV87HOIAl0Qx5v5zli/altP+CAezNIm8BZ/3Hobui3A=
-----END CERTIFICATE-----

GLOBALTRUST 2020
================================================
SHA1 Fingerprint=D0:67:C1:13:51:01:0C:AA:D0:C7:6A:65:37:31:16:26:4F:53:71:A2
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            5a:4b:bd:5a:fb:4f:8a:5b:fa:65:e5
    Signature Algorithm: sha256WithRSAEncryption
        Issuer: C=AT, O=e-commerce monitoring GmbH, CN=GLOBALTRUST 2020
        Validity
            Not Before: Feb 10 00:00:00 2020 GMT
            Not After : Jun 10 00:00:00 2040 GMT
        Subject: C=AT, O=e-commerce monitoring GmbH, CN=GLOBALTRUST 2020
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (4096 bit)
                Modulus:
                    00:ae:2e:56:ad:1b:1c:ef:f6:95:8f:a0:77:1b:2b:
                    d3:63:8f:84:4d:45:a2:0f:9f:5b:45:ab:59:7b:51:
                    34:f9:ec:8b:8a:78:c5:dd:6b:af:bd:c4:df:93:45:
                    1e:bf:91:38:0b:ae:0e:16:e7:41:73:f8:db:bb:d1:
                    b8:51:e0:cb:83:3b:73:38:6e:77:8a:0f:59:63:26:
                    cd:a7:2a:ce:54:fb:b8:e2:c0:7c:47:ce:60:7c:3f:
                    b2:73:f2:c0:19:b6:8a:92:87:35:0d:90:28:a2:e4:
                    15:04:63:3e:ba:af:ee:7c:5e:cc:a6:8b:50:b2:38:
                    f7:41:63:ca:ce:ff:69:8f:68:0e:95:36:e5:cc:b9:
                    8c:09:ca:4b:dd:31:90:96:c8:cc:1f:fd:56:96:34:
                    db:8e:1c:ea:2c:be:85:2e:63:dd:aa:a9:95:d3:fd:
                    29:95:13:f0:c8:98:93:d9:2d:16:47:90:11:83:a2:
                    3a:22:a2:28:57:a2:eb:fe:c0:8c:28:a0:a6:7d:e7:
                    2a:42:3b:82:80:63:a5:63:1f:19:cc:7c:b2:66:a8:
                    c2:d3:6d:37:6f:e2:7e:06:51:d9:45:84:1f:12:ce:
                    24:52:64:85:0b:48:80:4e:87:b1:22:22:30:aa:eb:
                    ae:be:e0:02:e0:40:e8:b0:42:80:03:51:aa:b4:7e:
                    aa:44:d7:43:61:f3:a2:6b:16:89:49:a4:a3:a4:2b:
                    8a:02:c4:78:f4:68:8a:c1:e4:7a:36:b1:6f:1b:96:
                    1b:77:49:8d:d4:c9:06:72:8f:cf:53:e3:dc:17:85:
                    20:4a:dc:98:27:d3:91:26:2b:47:1e:69:07:af:de:
                    a2:e4:e4:d4:6b:0b:b3:5e:7c:d4:24:80:47:29:69:
                    3b:6e:e8:ac:fd:40:eb:d8:ed:71:71:2b:f2:e8:58:
                    1d:eb:41:97:22:c5:1f:d4:39:d0:27:8f:87:e3:18:
                    f4:e0:a9:46:0d:f5:74:3a:82:2e:d0:6e:2c:91:a3:
                    31:5c:3b:46:ea:7b:04:10:56:5e:80:1d:f5:a5:65:
                    e8:82:fc:e2:07:8c:62:45:f5:20:de:46:70:86:a1:
                    bc:93:d3:1e:74:a6:6c:b0:2c:f7:03:0c:88:0c:cb:
                    d4:72:53:86:bc:60:46:f3:98:6a:c2:f1:bf:43:f9:
                    70:20:77:ca:37:41:79:55:52:63:8d:5b:12:9f:c5:
                    68:c4:88:9d:ac:f2:30:ab:b7:a3:31:97:67:ad:8f:
                    17:0f:6c:c7:73:ed:24:94:6b:c8:83:9a:d0:9a:37:
                    49:04:ab:b1:16:c8:6c:49:49:2d:ab:a1:d0:8c:92:
                    f2:41:4a:79:21:25:db:63:d7:b6:9c:a7:7e:42:69:
                    fb:3a:63
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Subject Key Identifier: 
                DC:2E:1F:D1:61:37:79:E4:AB:D5:D5:B3:12:71:68:3D:6A:68:9C:22
            X509v3 Authority Key Identifier: 
                keyid:DC:2E:1F:D1:61:37:79:E4:AB:D5:D5:B3:12:71:68:3D:6A:68:9C:22

    Signature Algorithm: sha256WithRSAEncryption
         91:f0:42:02:68:40:ee:c3:68:c0:54:2f:df:ec:62:c3:c3:9e:
         8a:a0:31:28:aa:83:8e:a4:56:96:12:10:86:56:ba:97:72:d2:
         54:30:7c:ad:19:d5:1d:68:6f:fb:14:42:d8:8d:0e:f3:b5:d1:
         a5:e3:02:42:5e:dc:e8:46:58:07:35:02:30:e0:bc:74:4a:c1:
         43:2a:ff:db:1a:d0:b0:af:6c:c3:fd:cb:b3:f5:7f:6d:03:2e:
         59:56:9d:2d:2d:35:8c:b2:d6:43:17:2c:92:0a:cb:5d:e8:8c:
         0f:4b:70:43:d0:82:ff:a8:cc:bf:a4:94:c0:be:87:bd:8a:e3:
         93:7b:c6:8f:9b:16:9d:27:65:bc:7a:c5:42:82:6c:5c:07:d0:
         a9:c1:88:60:44:e9:98:85:16:5f:f8:8f:ca:01:10:ce:25:c3:
         f9:60:1b:a0:c5:97:c3:d3:2c:88:31:a2:bd:30:ec:d0:d0:c0:
         12:f1:c1:39:e3:e5:f5:f8:d6:4a:dd:34:cd:fb:6f:c1:4f:e3:
         00:8b:56:e2:92:f7:28:b2:42:77:72:23:67:c7:3f:11:15:b2:
         c4:03:05:be:bb:11:7b:0a:bf:a8:6e:e7:ff:58:43:cf:9b:67:
         a0:80:07:b6:1d:ca:ad:6d:ea:41:11:7e:2d:74:93:fb:c2:bc:
         be:51:44:c5:ef:68:25:27:80:e3:c8:a0:d4:12:ec:d9:a5:37:
         1d:37:7c:b4:91:ca:da:d4:b1:96:81:ef:68:5c:76:10:49:af:
         7e:a5:37:80:b1:1c:52:bd:33:81:4c:8f:f9:dd:65:d9:14:cd:
         8a:25:58:f4:e2:c5:83:a5:09:90:d4:6c:14:63:b5:40:df:eb:
         c0:fc:c4:58:7e:0d:14:16:87:54:27:6e:56:e4:70:84:b8:6c:
         32:12:7e:82:31:43:be:d7:dd:7c:a1:ad:ae:d6:ab:20:12:ef:
         0a:c3:10:8c:49:96:35:dc:0b:75:5e:b1:4f:d5:4f:34:0e:11:
         20:07:75:43:45:e9:a3:11:da:ac:a3:99:c2:b6:79:27:e2:b9:
         ef:c8:e2:f6:35:29:7a:74:fa:c5:7f:82:05:62:a6:0a:ea:68:
         b2:79:47:06:6e:f2:57:a8:15:33:c6:f7:78:4a:3d:42:7b:6b:
         7e:fe:f7:46:ea:d1:eb:8e:ef:88:68:5b:e8:c1:d9:71:7e:fd:
         64:ef:ff:67:47:88:58:25:2f:3e:86:07:bd:fb:a8:e5:82:a8:
         ac:a5:d3:69:43:cd:31:88:49:84:53:92:c0:b1:39:1b:39:83:
         01:30:c4:f2:a9:fa:d0:03:bd:72:37:60:56:1f:36:7c:bd:39:
         91:f5:6d:0d:bf:7b:d7:92
-----BEGIN CERTIFICATE-----
MIIFgjCCA2qgAwIBAgILWku9WvtPilv6ZeUwDQYJKoZIhvcNAQELBQAwTTELMAkG
A1UEBhMCQVQxIzAhBgNVBAoTGmUtY29tbWVyY2UgbW9uaXRvcmluZyBHbWJIMRkw
FwYDVQQDExBHTE9CQUxUUlVTVCAyMDIwMB4XDTIwMDIxMDAwMDAwMFoXDTQwMDYx
MDAwMDAwMFowTTELMAkGA1UEBhMCQVQxIzAhBgNVBAoTGmUtY29tbWVyY2UgbW9u
aXRvcmluZyBHbWJIMRkwFwYDVQQDExBHTE9CQUxUUlVTVCAyMDIwMIICIjANBgkq
hkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAri5WrRsc7/aVj6B3GyvTY4+ETUWiD59b
RatZe1E0+eyLinjF3WuvvcTfk0Uev5E4C64OFudBc/jbu9G4UeDLgztzOG53ig9Z
YybNpyrOVPu44sB8R85gfD+yc/LAGbaKkoc1DZAoouQVBGM+uq/ufF7MpotQsjj3
QWPKzv9pj2gOlTblzLmMCcpL3TGQlsjMH/1WljTbjhzqLL6FLmPdqqmV0/0plRPw
yJiT2S0WR5ARg6I6IqIoV6Lr/sCMKKCmfecqQjuCgGOlYx8ZzHyyZqjC0203b+J+
BlHZRYQfEs4kUmSFC0iAToexIiIwquuuvuAC4EDosEKAA1GqtH6qRNdDYfOiaxaJ
SaSjpCuKAsR49GiKweR6NrFvG5Ybd0mN1MkGco/PU+PcF4UgStyYJ9ORJitHHmkH
r96i5OTUawuzXnzUJIBHKWk7buis/UDr2O1xcSvy6Fgd60GXIsUf1DnQJ4+H4xj0
4KlGDfV0OoIu0G4skaMxXDtG6nsEEFZegB31pWXogvziB4xiRfUg3kZwhqG8k9Me
dKZssCz3AwyIDMvUclOGvGBG85hqwvG/Q/lwIHfKN0F5VVJjjVsSn8VoxIidrPIw
q7ejMZdnrY8XD2zHc+0klGvIg5rQmjdJBKuxFshsSUktq6HQjJLyQUp5ISXbY9e2
nKd+Qmn7OmMCAwEAAaNjMGEwDwYDVR0TAQH/BAUwAwEB/zAOBgNVHQ8BAf8EBAMC
AQYwHQYDVR0OBBYEFNwuH9FhN3nkq9XVsxJxaD1qaJwiMB8GA1UdIwQYMBaAFNwu
H9FhN3nkq9XVsxJxaD1qaJwiMA0GCSqGSIb3DQEBCwUAA4ICAQCR8EICaEDuw2jA
VC/f7GLDw56KoDEoqoOOpFaWEhCGVrqXctJUMHytGdUdaG/7FELYjQ7ztdGl4wJC
XtzoRlgHNQIw4Lx0SsFDKv/bGtCwr2zD/cuz9X9tAy5ZVp0tLTWMstZDFyySCstd
6IwPS3BD0IL/qMy/pJTAvoe9iuOTe8aPmxadJ2W8esVCgmxcB9CpwYhgROmYhRZf
+I/KARDOJcP5YBugxZfD0yyIMaK9MOzQ0MAS8cE54+X1+NZK3TTN+2/BT+MAi1bi
kvcoskJ3ciNnxz8RFbLEAwW+uxF7Cr+obuf/WEPPm2eggAe2HcqtbepBEX4tdJP7
wry+UUTF72glJ4DjyKDUEuzZpTcdN3y0kcra1LGWge9oXHYQSa9+pTeAsRxSvTOB
TI/53WXZFM2KJVj04sWDpQmQ1GwUY7VA3+vA/MRYfg0UFodUJ25W5HCEuGwyEn6C
MUO+1918oa2u1qsgEu8KwxCMSZY13At1XrFP1U80DhEgB3VDRemjEdqso5nCtnkn
4rnvyOL2NSl6dPrFf4IFYqYK6miyeUcGbvJXqBUzxvd4Sj1Ce2t+/vdG6tHrju+I
aFvowdlxfv1k7/9nR4hYJS8+hge9+6jlgqispdNpQ80xiEmEU5LAsTkbOYMBMMTy
qfrQA71yN2BWHzZ8vTmR9W0Nv3vXkg==
-----END CERTIFICATE-----

ANF Secure Server Root CA
=================================================
SHA1 Fingerprint=5B:6E:68:D0:CC:15:B6:A0:5F:1E:C1:5F:AE:02:FC:6B:2F:5D:6F:74
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 996390341000653745 (0xdd3e3bc6cf96bb1)
    Signature Algorithm: sha256WithRSAEncryption
        Issuer: serialNumber=G63287510, C=ES, O=ANF Autoridad de Certificacion, OU=ANF CA Raiz, CN=ANF Secure Server Root CA
        Validity
            Not Before: Sep  4 10:00:38 2019 GMT
            Not After : Aug 30 10:00:38 2039 GMT
        Subject: serialNumber=G63287510, C=ES, O=ANF Autoridad de Certificacion, OU=ANF CA Raiz, CN=ANF Secure Server Root CA
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (4096 bit)
                Modulus:
                    00:db:eb:6b:2b:e6:64:54:95:82:90:a3:72:a4:19:
                    01:9d:9c:0b:81:5f:73:49:ba:a7:ac:f3:04:4e:7b:
                    96:0b:ec:11:e0:5b:a6:1c:ce:1b:d2:0d:83:1c:2b:
                    b8:9e:1d:7e:45:32:60:0f:07:e9:77:58:7e:9f:6a:
                    c8:61:4e:b6:26:c1:4c:8d:ff:4c:ef:34:b2:1f:65:
                    d8:b9:78:f5:ad:a9:71:b9:ef:4f:58:1d:a5:de:74:
                    20:97:a1:ed:68:4c:de:92:17:4b:bc:ab:ff:65:9a:
                    9e:fb:47:d9:57:72:f3:09:a1:ae:76:44:13:6e:9c:
                    2d:44:39:bc:f9:c7:3b:a4:58:3d:41:bd:b4:c2:49:
                    a3:c8:0d:d2:97:2f:07:65:52:00:a7:6e:c8:af:68:
                    ec:f4:14:96:b6:57:1f:56:c3:39:9f:2b:6d:e4:f3:
                    3e:f6:35:64:da:0c:1c:a1:84:4b:2f:4b:4b:e2:2c:
                    24:9d:6d:93:40:eb:b5:23:8e:32:ca:6f:45:d3:a8:
                    89:7b:1e:cf:1e:fa:5b:43:8b:cd:cd:a8:0f:6a:ca:
                    0c:5e:b9:9e:47:8f:f0:d9:b6:0a:0b:58:65:17:33:
                    b9:23:e4:77:19:7d:cb:4a:2e:92:7b:4f:2f:10:77:
                    b1:8d:2f:68:9c:62:cc:e0:50:f8:ec:91:a7:54:4c:
                    57:09:d5:76:63:c5:e8:65:1e:ee:6d:6a:cf:09:9d:
                    fa:7c:4f:ad:60:08:fd:56:99:0f:15:2c:7b:a9:80:
                    ab:8c:61:8f:4a:07:76:42:de:3d:f4:dd:b2:24:33:
                    5b:b8:b5:a3:44:c9:ac:7f:77:3c:1d:23:ec:82:a9:
                    a6:e2:c8:06:4c:02:fe:ac:5c:99:99:0b:2f:10:8a:
                    a6:f4:7f:d5:87:74:0d:59:49:45:f6:f0:71:5c:39:
                    29:d6:bf:4a:23:8b:f5:5f:01:63:d2:87:73:28:b5:
                    4b:0a:f5:f8:ab:82:2c:7e:73:25:32:1d:0b:63:0a:
                    17:81:00:ff:b6:76:5e:e7:b4:b1:40:ca:21:bb:d5:
                    80:51:e5:48:52:67:2c:d2:61:89:07:0d:0f:ce:42:
                    77:c0:44:73:9c:44:50:a0:db:10:0a:2d:95:1c:81:
                    af:e4:1c:e5:14:1e:f1:36:41:01:02:2f:7d:73:a7:
                    de:42:cc:4c:e9:89:0d:56:f7:9f:91:d4:03:c6:6c:
                    c9:8f:db:d8:1c:e0:40:98:5d:66:99:98:80:6e:2d:
                    ff:01:c5:ce:cb:46:1f:ac:02:c6:43:e6:ae:a2:84:
                    3c:c5:4e:1e:3d:6d:c9:14:4c:e3:2e:41:bb:ca:39:
                    bf:36:3c:2a:19:aa:41:87:4e:a5:ce:4b:32:79:dd:
                    90:49:7f
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Authority Key Identifier: 
                keyid:9C:5F:D0:6C:63:A3:5F:93:CA:93:98:08:AD:8C:87:A5:2C:5C:C1:37

            X509v3 Subject Key Identifier: 
                9C:5F:D0:6C:63:A3:5F:93:CA:93:98:08:AD:8C:87:A5:2C:5C:C1:37
            X509v3 Key Usage: critical
                Digital Signature, Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
    Signature Algorithm: sha256WithRSAEncryption
         4e:1e:b9:8a:c6:a0:98:3f:6e:c3:69:c0:6a:5c:49:52:ac:cb:
         2b:5d:78:38:c1:d5:54:84:9f:93:f0:87:19:3d:2c:66:89:eb:
         0d:42:fc:cc:f0:75:85:3f:8b:f4:80:5d:79:e5:17:67:bd:35:
         82:e2:f2:3c:8e:7d:5b:36:cb:5a:80:00:29:f2:ce:2b:2c:f1:
         8f:aa:6d:05:93:6c:72:c7:56:eb:df:50:23:28:e5:45:10:3d:
         e8:67:a3:af:0e:55:0f:90:09:62:ef:4b:59:a2:f6:53:f1:c0:
         35:e4:2f:c1:24:bd:79:2f:4e:20:22:3b:fd:1a:20:b0:a4:0e:
         2c:70:ed:74:3f:b8:13:95:06:51:c8:e8:87:26:ca:a4:5b:6a:
         16:21:92:dd:73:60:9e:10:18:de:3c:81:ea:e8:18:c3:7c:89:
         f2:8b:50:3e:bd:11:e2:15:03:a8:36:7d:33:01:6c:48:15:d7:
         88:90:99:04:c5:cc:e6:07:f4:bc:f4:90:ed:13:e2:ea:8b:c3:
         8f:a3:33:0f:c1:29:4c:13:4e:da:15:56:71:73:72:82:50:f6:
         9a:33:7c:a2:b1:a8:1a:34:74:65:5c:ce:d1:eb:ab:53:e0:1a:
         80:d8:ea:3a:49:e4:26:30:9b:e5:1c:8a:a8:a9:15:32:86:99:
         92:0a:10:23:56:12:e0:f6:ce:4c:e2:bb:be:db:8d:92:73:01:
         66:2f:62:3e:b2:72:27:45:36:ed:4d:56:e3:97:99:ff:3a:35:
         3e:a5:54:4a:52:59:4b:60:db:ee:fe:78:11:7f:4a:dc:14:79:
         60:b6:6b:64:03:db:15:83:e1:a2:be:f6:23:97:50:f0:09:33:
         36:a7:71:96:25:f3:b9:42:7d:db:38:3f:2c:58:ac:e8:42:e1:
         0e:d8:d3:3b:4c:2e:82:e9:83:2e:6b:31:d9:dd:47:86:4f:6d:
         97:91:2e:4f:e2:28:71:35:16:d1:f2:73:fe:25:2b:07:47:24:
         63:27:c8:f8:f6:d9:6b:fc:12:31:56:08:c0:53:42:af:9c:d0:
         33:7e:fc:06:f0:31:44:03:14:f1:58:ea:f2:6a:0d:a9:11:b2:
         83:be:c5:1a:bf:07:ea:59:dc:a3:88:35:ef:9c:76:32:3c:4d:
         06:22:ce:15:e5:dd:9e:d8:8f:da:de:d2:c4:39:e5:17:81:cf:
         38:47:eb:7f:88:6d:59:1b:df:9f:42:14:ae:7e:cf:a8:b0:66:
         65:da:37:af:9f:aa:3d:ea:28:b6:de:d5:31:58:16:82:5b:ea:
         bb:19:75:02:73:1a:ca:48:1a:21:93:90:0a:8e:93:84:a7:7d:
         3b:23:18:92:89:a0:8d:ac
-----BEGIN CERTIFICATE-----
MIIF7zCCA9egAwIBAgIIDdPjvGz5a7EwDQYJKoZIhvcNAQELBQAwgYQxEjAQBgNV
BAUTCUc2MzI4NzUxMDELMAkGA1UEBhMCRVMxJzAlBgNVBAoTHkFORiBBdXRvcmlk
YWQgZGUgQ2VydGlmaWNhY2lvbjEUMBIGA1UECxMLQU5GIENBIFJhaXoxIjAgBgNV
BAMTGUFORiBTZWN1cmUgU2VydmVyIFJvb3QgQ0EwHhcNMTkwOTA0MTAwMDM4WhcN
MzkwODMwMTAwMDM4WjCBhDESMBAGA1UEBRMJRzYzMjg3NTEwMQswCQYDVQQGEwJF
UzEnMCUGA1UEChMeQU5GIEF1dG9yaWRhZCBkZSBDZXJ0aWZpY2FjaW9uMRQwEgYD
VQQLEwtBTkYgQ0EgUmFpejEiMCAGA1UEAxMZQU5GIFNlY3VyZSBTZXJ2ZXIgUm9v
dCBDQTCCAiIwDQYJKoZIhvcNAQEBBQADggIPADCCAgoCggIBANvrayvmZFSVgpCj
cqQZAZ2cC4Ffc0m6p6zzBE57lgvsEeBbphzOG9INgxwruJ4dfkUyYA8H6XdYfp9q
yGFOtibBTI3/TO80sh9l2Ll49a2pcbnvT1gdpd50IJeh7WhM3pIXS7yr/2WanvtH
2Vdy8wmhrnZEE26cLUQ5vPnHO6RYPUG9tMJJo8gN0pcvB2VSAKduyK9o7PQUlrZX
H1bDOZ8rbeTzPvY1ZNoMHKGESy9LS+IsJJ1tk0DrtSOOMspvRdOoiXsezx76W0OL
zc2oD2rKDF65nkeP8Nm2CgtYZRczuSPkdxl9y0oukntPLxB3sY0vaJxizOBQ+OyR
p1RMVwnVdmPF6GUe7m1qzwmd+nxPrWAI/VaZDxUse6mAq4xhj0oHdkLePfTdsiQz
W7i1o0TJrH93PB0j7IKppuLIBkwC/qxcmZkLLxCKpvR/1Yd0DVlJRfbwcVw5Kda/
SiOL9V8BY9KHcyi1Swr1+KuCLH5zJTIdC2MKF4EA/7Z2Xue0sUDKIbvVgFHlSFJn
LNJhiQcND85Cd8BEc5xEUKDbEAotlRyBr+Qc5RQe8TZBAQIvfXOn3kLMTOmJDVb3
n5HUA8ZsyY/b2BzgQJhdZpmYgG4t/wHFzstGH6wCxkPmrqKEPMVOHj1tyRRM4y5B
u8o5vzY8KhmqQYdOpc5LMnndkEl/AgMBAAGjYzBhMB8GA1UdIwQYMBaAFJxf0Gxj
o1+TypOYCK2Mh6UsXME3MB0GA1UdDgQWBBScX9BsY6Nfk8qTmAitjIelLFzBNzAO
BgNVHQ8BAf8EBAMCAYYwDwYDVR0TAQH/BAUwAwEB/zANBgkqhkiG9w0BAQsFAAOC
AgEATh65isagmD9uw2nAalxJUqzLK114OMHVVISfk/CHGT0sZonrDUL8zPB1hT+L
9IBdeeUXZ701guLyPI59WzbLWoAAKfLOKyzxj6ptBZNscsdW699QIyjlRRA96Gej
rw5VD5AJYu9LWaL2U/HANeQvwSS9eS9OICI7/RogsKQOLHDtdD+4E5UGUcjohybK
pFtqFiGS3XNgnhAY3jyB6ugYw3yJ8otQPr0R4hUDqDZ9MwFsSBXXiJCZBMXM5gf0
vPSQ7RPi6ovDj6MzD8EpTBNO2hVWcXNyglD2mjN8orGoGjR0ZVzO0eurU+AagNjq
OknkJjCb5RyKqKkVMoaZkgoQI1YS4PbOTOK7vtuNknMBZi9iPrJyJ0U27U1W45eZ
/zo1PqVUSlJZS2Db7v54EX9K3BR5YLZrZAPbFYPhor72I5dQ8AkzNqdxliXzuUJ9
2zg/LFis6ELhDtjTO0wugumDLmsx2d1Hhk9tl5EuT+IocTUW0fJz/iUrB0ckYyfI
+PbZa/wSMVYIwFNCr5zQM378BvAxRAMU8Vjq8moNqRGyg77FGr8H6lnco4g175x2
MjxNBiLOFeXdntiP2t7SxDnlF4HPOEfrf4htWRvfn0IUrn7PqLBmZdo3r5+qPeoo
tt7VMVgWglvquxl1AnMaykgaIZOQCo6ThKd9OyMYkomgjaw=
-----END CERTIFICATE-----

Certum EC-384 CA
================================================
SHA1 Fingerprint=F3:3E:78:3C:AC:DF:F4:A2:CC:AC:67:55:69:56:D7:E5:16:3C:E1:ED
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            78:8f:27:5c:81:12:52:20:a5:04:d0:2d:dd:ba:73:f4
    Signature Algorithm: ecdsa-with-SHA384
        Issuer: C=PL, O=Asseco Data Systems S.A., OU=Certum Certification Authority, CN=Certum EC-384 CA
        Validity
            Not Before: Mar 26 07:24:54 2018 GMT
            Not After : Mar 26 07:24:54 2043 GMT
        Subject: C=PL, O=Asseco Data Systems S.A., OU=Certum Certification Authority, CN=Certum EC-384 CA
        Subject Public Key Info:
            Public Key Algorithm: id-ecPublicKey
                Public-Key: (384 bit)
                pub: 
                    04:c4:28:8e:ab:18:5b:6a:be:6e:64:37:63:e4:cd:
                    ec:ab:3a:f7:cc:a1:b8:0e:82:49:d7:86:29:9f:a1:
                    94:f2:e3:60:78:98:81:78:06:4d:f2:ec:9a:0e:57:
                    60:83:9f:b4:e6:17:2f:1a:b3:5d:02:5b:89:23:3c:
                    c2:11:05:2a:a7:88:13:18:f3:50:84:d7:bd:34:2c:
                    27:89:55:ff:ce:4c:e7:df:a6:1f:28:c4:f0:54:c3:
                    b9:7c:b7:53:ad:eb:c2
                ASN1 OID: secp384r1
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Subject Key Identifier: 
                8D:06:66:74:24:76:3A:F3:89:F7:BC:D6:BD:47:7D:2F:BC:10:5F:4B
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
    Signature Algorithm: ecdsa-with-SHA384
         30:65:02:30:03:55:2d:a6:e6:18:c4:7c:ef:c9:50:6e:c1:27:
         0f:9c:87:af:6e:d5:1b:08:18:bd:92:29:c1:ef:94:91:78:d2:
         3a:1c:55:89:62:e5:1b:09:1e:ba:64:6b:f1:76:b4:d4:02:31:
         00:b4:42:84:99:ff:ab:e7:9e:fb:91:97:27:5d:dc:b0:5b:30:
         71:ce:5e:38:1a:6a:d9:25:e7:ea:f7:61:92:56:f8:ea:da:36:
         c2:87:65:96:2e:72:25:2f:7f:df:c3:13:c9
-----BEGIN CERTIFICATE-----
MIICZTCCAeugAwIBAgIQeI8nXIESUiClBNAt3bpz9DAKBggqhkjOPQQDAzB0MQsw
CQYDVQQGEwJQTDEhMB8GA1UEChMYQXNzZWNvIERhdGEgU3lzdGVtcyBTLkEuMScw
JQYDVQQLEx5DZXJ0dW0gQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkxGTAXBgNVBAMT
EENlcnR1bSBFQy0zODQgQ0EwHhcNMTgwMzI2MDcyNDU0WhcNNDMwMzI2MDcyNDU0
WjB0MQswCQYDVQQGEwJQTDEhMB8GA1UEChMYQXNzZWNvIERhdGEgU3lzdGVtcyBT
LkEuMScwJQYDVQQLEx5DZXJ0dW0gQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkxGTAX
BgNVBAMTEENlcnR1bSBFQy0zODQgQ0EwdjAQBgcqhkjOPQIBBgUrgQQAIgNiAATE
KI6rGFtqvm5kN2PkzeyrOvfMobgOgknXhimfoZTy42B4mIF4Bk3y7JoOV2CDn7Tm
Fy8as10CW4kjPMIRBSqniBMY81CE1700LCeJVf/OTOffph8oxPBUw7l8t1Ot68Kj
QjBAMA8GA1UdEwEB/wQFMAMBAf8wHQYDVR0OBBYEFI0GZnQkdjrzife81r1HfS+8
EF9LMA4GA1UdDwEB/wQEAwIBBjAKBggqhkjOPQQDAwNoADBlAjADVS2m5hjEfO/J
UG7BJw+ch69u1RsIGL2SKcHvlJF40jocVYli5RsJHrpka/F2tNQCMQC0QoSZ/6vn
nvuRlydd3LBbMHHOXjgaatkl5+r3YZJW+OraNsKHZZYuciUvf9/DE8k=
-----END CERTIFICATE-----

Certum Trusted Root CA
================================================
SHA1 Fingerprint=C8:83:44:C0:18:AE:9F:CC:F1:87:B7:8F:22:D1:C5:D7:45:84:BA:E5
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            1e:bf:59:50:b8:c9:80:37:4c:06:f7:eb:55:4f:b5:ed
    Signature Algorithm: sha512WithRSAEncryption
        Issuer: C=PL, O=Asseco Data Systems S.A., OU=Certum Certification Authority, CN=Certum Trusted Root CA
        Validity
            Not Before: Mar 16 12:10:13 2018 GMT
            Not After : Mar 16 12:10:13 2043 GMT
        Subject: C=PL, O=Asseco Data Systems S.A., OU=Certum Certification Authority, CN=Certum Trusted Root CA
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (4096 bit)
                Modulus:
                    00:d1:2d:8e:bb:b7:36:ea:6d:37:91:9f:4e:93:a7:
                    05:e4:29:03:25:ce:1c:82:f7:7c:99:9f:41:06:cd:
                    ed:a3:ba:c0:db:09:2c:c1:7c:df:29:7e:4b:65:2f:
                    93:a7:d4:01:6b:03:28:18:a3:d8:9d:05:c1:2a:d8:
                    45:f1:91:de:df:3b:d0:80:02:8c:cf:38:0f:ea:a7:
                    5c:78:11:a4:c1:c8:85:5c:25:d3:d3:b2:e7:25:cf:
                    11:54:97:ab:35:c0:1e:76:1c:ef:00:53:9f:39:dc:
                    14:a5:2c:22:25:b3:72:72:fc:8d:b3:e5:3e:08:1e:
                    14:2a:37:0b:88:3c:ca:b0:f4:c8:c2:a1:ae:bc:c1:
                    be:29:67:55:e2:fc:ad:59:5c:fe:bd:57:2c:b0:90:
                    8d:c2:ed:37:b6:7c:99:88:b5:d5:03:9a:3d:15:0d:
                    3d:3a:a8:a8:45:f0:95:4e:25:59:1d:cd:98:69:bb:
                    d3:cc:32:c9:8d:ef:81:fe:ad:7d:89:bb:ba:60:13:
                    ca:65:95:67:a0:f3:19:f6:03:56:d4:6a:d3:27:e2:
                    a1:ad:83:f0:4a:12:22:77:1c:05:73:e2:19:71:42:
                    c0:ec:75:46:9a:90:58:e0:6a:8e:2b:a5:46:30:04:
                    8e:19:b2:17:e3:be:a9:ba:7f:56:f1:24:03:d7:b2:
                    21:28:76:0e:36:30:4c:79:d5:41:9a:9a:a8:b8:35:
                    ba:0c:3a:f2:44:1b:20:88:f7:c5:25:d7:3d:c6:e3:
                    3e:43:dd:87:fe:c4:ea:f5:53:3e:4c:65:ff:3b:4a:
                    cb:78:5a:6b:17:5f:0d:c7:c3:4f:4e:9a:2a:a2:ed:
                    57:4d:22:e2:46:9a:3f:0f:91:34:24:7d:55:e3:8c:
                    95:37:d3:1a:f0:09:2b:2c:d2:c9:8d:b4:0d:00:ab:
                    67:29:28:d8:01:f5:19:04:b6:1d:be:76:fe:72:5c:
                    c4:85:ca:d2:80:41:df:05:a8:a3:d5:84:90:4f:0b:
                    f3:e0:3f:9b:19:d2:37:89:3f:f2:7b:52:1c:8c:f6:
                    e1:f7:3c:07:97:8c:0e:a2:59:81:0c:b2:90:3d:d3:
                    e3:59:46:ed:0f:a9:a7:de:80:6b:5a:aa:07:b6:19:
                    cb:bc:57:f3:97:21:7a:0c:b1:2b:74:3e:eb:da:a7:
                    67:2d:4c:c4:98:9e:36:09:76:66:66:fc:1a:3f:ea:
                    48:54:1c:be:30:bd:80:50:bf:7c:b5:ce:00:f6:0c:
                    61:d9:e7:24:03:e0:e3:01:81:0e:bd:d8:85:34:88:
                    bd:b2:36:a8:7b:5c:08:e5:44:80:8c:6f:f8:2f:d5:
                    21:ca:1d:1c:d0:fb:c4:b5:87:d1:3a:4e:c7:76:b5:
                    35:48:b5
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Subject Key Identifier: 
                8C:FB:1C:75:BC:02:D3:9F:4E:2E:48:D9:F9:60:54:AA:C4:B3:4F:FA
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
    Signature Algorithm: sha512WithRSAEncryption
         48:a2:d5:00:0b:2e:d0:3f:bc:1c:d5:b5:54:49:1e:5a:6b:f4:
         e4:f2:e0:40:37:e0:cc:14:7b:b9:c9:fa:35:b5:75:17:93:6a:
         05:69:85:9c:cd:4f:19:78:5b:19:81:f3:63:3e:c3:ce:5b:8f:
         f5:2f:5e:01:76:13:3f:2c:00:b9:cd:96:52:39:49:6d:04:4e:
         c5:e9:0f:86:0d:e1:fa:b3:5f:82:12:f1:3a:ce:66:06:24:34:
         2b:e8:cc:ca:e7:69:dc:87:9d:c2:34:d7:79:d1:d3:77:b8:aa:
         59:58:fe:9d:26:fa:38:86:3e:9d:8a:87:64:57:e5:17:3a:e2:
         f9:8d:b9:e3:33:78:c1:90:d8:b8:dd:b7:83:51:e4:c4:cc:23:
         d5:06:7c:e6:51:d3:cd:34:31:c0:f6:46:bb:0b:ad:fc:3d:10:
         05:2a:3b:4a:91:25:ee:8c:d4:84:87:80:2a:bc:09:8c:aa:3a:
         13:5f:e8:34:79:50:c1:10:19:f9:d3:28:1e:d4:d1:51:30:29:
         b3:ae:90:67:d6:1f:0a:63:b1:c5:a9:c6:42:31:63:17:94:ef:
         69:cb:2f:fa:8c:14:7d:c4:43:18:89:d9:f0:32:40:e6:80:e2:
         46:5f:e5:e3:c1:00:59:a8:f9:e8:20:bc:89:2c:0e:47:34:0b:
         ea:57:c2:53:36:fc:a7:d4:af:31:cd:fe:02:e5:75:fa:b9:27:
         09:f9:f3:f5:3b:ca:7d:9f:a9:22:cb:88:c9:aa:d1:47:3d:36:
         77:a8:59:64:6b:27:cf:ef:27:c1:e3:24:b5:86:f7:ae:7e:32:
         4d:b0:79:68:d1:39:e8:90:58:c3:83:bc:0f:2c:d6:97:eb:ce:
         0c:e1:20:c7:da:b7:3e:c3:3f:bf:2f:dc:34:a4:fb:2b:21:cd:
         67:8f:4b:f4:e3:ea:d4:3f:e7:4f:ba:b9:a5:93:45:1c:66:1f:
         21:fa:64:5e:6f:e0:76:94:32:cb:75:f5:6e:e5:f6:8f:c7:b8:
         a4:cc:a8:96:7d:64:fb:24:5a:4a:03:6c:6b:38:c6:e8:03:43:
         9a:f7:57:b9:b3:29:69:93:38:f4:03:f2:bb:fb:82:6b:07:20:
         d1:52:1f:9a:64:02:7b:98:66:db:5c:4d:5a:0f:d0:84:95:a0:
         3c:14:43:06:ca:ca:db:b8:41:36:da:6a:44:67:87:af:af:e3:
         45:11:15:69:08:b2:be:16:39:97:24:6f:12:45:d1:67:5d:09:
         a8:c9:15:da:fa:d2:a6:5f:13:61:1f:bf:85:ac:b4:ad:ad:05:
         94:08:83:1e:75:17:d3:71:3b:93:50:23:59:a0:ed:3c:91:54:
         9d:76:00:c5:c3:b8:38:db
-----BEGIN CERTIFICATE-----
MIIFwDCCA6igAwIBAgIQHr9ZULjJgDdMBvfrVU+17TANBgkqhkiG9w0BAQ0FADB6
MQswCQYDVQQGEwJQTDEhMB8GA1UEChMYQXNzZWNvIERhdGEgU3lzdGVtcyBTLkEu
MScwJQYDVQQLEx5DZXJ0dW0gQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkxHzAdBgNV
BAMTFkNlcnR1bSBUcnVzdGVkIFJvb3QgQ0EwHhcNMTgwMzE2MTIxMDEzWhcNNDMw
MzE2MTIxMDEzWjB6MQswCQYDVQQGEwJQTDEhMB8GA1UEChMYQXNzZWNvIERhdGEg
U3lzdGVtcyBTLkEuMScwJQYDVQQLEx5DZXJ0dW0gQ2VydGlmaWNhdGlvbiBBdXRo
b3JpdHkxHzAdBgNVBAMTFkNlcnR1bSBUcnVzdGVkIFJvb3QgQ0EwggIiMA0GCSqG
SIb3DQEBAQUAA4ICDwAwggIKAoICAQDRLY67tzbqbTeRn06TpwXkKQMlzhyC93yZ
n0EGze2jusDbCSzBfN8pfktlL5On1AFrAygYo9idBcEq2EXxkd7fO9CAAozPOA/q
p1x4EaTByIVcJdPTsuclzxFUl6s1wB52HO8AU5853BSlLCIls3Jy/I2z5T4IHhQq
NwuIPMqw9MjCoa68wb4pZ1Xi/K1ZXP69VyywkI3C7Te2fJmItdUDmj0VDT06qKhF
8JVOJVkdzZhpu9PMMsmN74H+rX2Ju7pgE8pllWeg8xn2A1bUatMn4qGtg/BKEiJ3
HAVz4hlxQsDsdUaakFjgao4rpUYwBI4Zshfjvqm6f1bxJAPXsiEodg42MEx51UGa
mqi4NboMOvJEGyCI98Ul1z3G4z5D3Yf+xOr1Uz5MZf87Sst4WmsXXw3Hw09Omiqi
7VdNIuJGmj8PkTQkfVXjjJU30xrwCSss0smNtA0Aq2cpKNgB9RkEth2+dv5yXMSF
ytKAQd8FqKPVhJBPC/PgP5sZ0jeJP/J7UhyM9uH3PAeXjA6iWYEMspA90+NZRu0P
qafegGtaqge2Gcu8V/OXIXoMsSt0Puvap2ctTMSYnjYJdmZm/Bo/6khUHL4wvYBQ
v3y1zgD2DGHZ5yQD4OMBgQ692IU0iL2yNqh7XAjlRICMb/gv1SHKHRzQ+8S1h9E6
Tsd2tTVItQIDAQABo0IwQDAPBgNVHRMBAf8EBTADAQH/MB0GA1UdDgQWBBSM+xx1
vALTn04uSNn5YFSqxLNP+jAOBgNVHQ8BAf8EBAMCAQYwDQYJKoZIhvcNAQENBQAD
ggIBAEii1QALLtA/vBzVtVRJHlpr9OTy4EA34MwUe7nJ+jW1dReTagVphZzNTxl4
WxmB82M+w85bj/UvXgF2Ez8sALnNllI5SW0ETsXpD4YN4fqzX4IS8TrOZgYkNCvo
zMrnadyHncI013nR03e4qllY/p0m+jiGPp2Kh2RX5Rc64vmNueMzeMGQ2Ljdt4NR
5MTMI9UGfOZR0800McD2RrsLrfw9EAUqO0qRJe6M1ISHgCq8CYyqOhNf6DR5UMEQ
GfnTKB7U0VEwKbOukGfWHwpjscWpxkIxYxeU72nLL/qMFH3EQxiJ2fAyQOaA4kZf
5ePBAFmo+eggvIksDkc0C+pXwlM2/KfUrzHN/gLldfq5Jwn58/U7yn2fqSLLiMmq
0Uc9NneoWWRrJ8/vJ8HjJLWG965+Mk2weWjROeiQWMODvA8s1pfrzgzhIMfatz7D
P78v3DSk+yshzWePS/Tj6tQ/50+6uaWTRRxmHyH6ZF5v4HaUMst19W7l9o/HuKTM
qJZ9ZPskWkoDbGs4xugDQ5r3V7mzKWmTOPQD8rv7gmsHINFSH5pkAnuYZttcTVoP
0ISVoDwUQwbKytu4QTbaakRnh6+v40URFWkIsr4WOZckbxJF0WddCajJFdr60qZf
E2Efv4WstK2tBZQIgx51F9NxO5NQI1mg7TyRVJ12AMXDuDjb
-----END CERTIFICATE-----

TunTrust Root CA
=================================================
SHA1 Fingerprint=CF:E9:70:84:0F:E0:73:0F:9D:F6:0C:7F:2C:4B:EE:20:46:34:9C:BB
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            13:02:d5:e2:40:4c:92:46:86:16:67:5d:b4:bb:bb:b2:6b:3e:fc:13
    Signature Algorithm: sha256WithRSAEncryption
        Issuer: C=TN, O=Agence Nationale de Certification Electronique, CN=TunTrust Root CA
        Validity
            Not Before: Apr 26 08:57:56 2019 GMT
            Not After : Apr 26 08:57:56 2044 GMT
        Subject: C=TN, O=Agence Nationale de Certification Electronique, CN=TunTrust Root CA
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (4096 bit)
                Modulus:
                    00:c3:cd:d3:fc:bd:04:53:dd:0c:20:3a:d5:88:2e:
                    05:4b:41:f5:83:82:7e:f7:59:9f:9e:9e:63:e8:73:
                    da:f6:06:a9:4f:1f:b4:f9:0b:1f:39:8c:9a:20:d0:
                    7e:06:d4:ec:34:d9:86:bc:75:5b:87:88:f0:d2:d9:
                    d4:a3:0a:b2:6c:1b:eb:49:2c:3e:ac:5d:d8:94:03:
                    a0:ec:34:e5:30:c4:35:7d:fb:26:4d:1b:6e:30:54:
                    d8:f5:80:45:9c:39:ad:9c:c9:25:04:4d:9a:90:3e:
                    4e:40:6e:8a:6b:cd:29:67:c6:cc:2d:e0:74:e8:05:
                    57:0a:48:50:fa:7a:43:da:7e:ec:5b:9a:0e:62:76:
                    fe:ea:9d:1d:85:72:ec:11:bb:35:e8:1f:27:bf:c1:
                    a1:c7:bb:48:16:dd:56:d7:cc:4e:a0:e1:b9:ac:db:
                    d5:83:19:1a:85:d1:94:97:d7:ca:a3:65:0b:f3:38:
                    f9:02:ae:dd:f6:67:cf:c9:3f:f5:8a:2c:47:1a:99:
                    6f:05:0d:fd:d0:1d:82:31:fc:29:cc:00:58:97:91:
                    4c:80:00:1c:33:85:96:2f:cb:41:c2:8b:10:84:c3:
                    09:24:89:1f:b5:0f:d9:d9:77:47:18:92:94:60:5c:
                    c7:99:03:3c:fe:f7:95:a7:7d:50:a1:80:c2:a9:83:
                    ad:58:96:55:21:db:86:59:d4:af:c6:bc:dd:81:6e:
                    07:db:60:62:fe:ec:10:6e:da:68:01:f4:83:1b:a9:
                    3e:a2:5b:23:d7:64:c6:df:dc:a2:7d:d8:4b:ba:82:
                    d2:51:f8:66:bf:06:46:e4:79:2a:26:36:79:8f:1f:
                    4e:99:1d:b2:8f:0c:0e:1c:ff:c9:5d:c0:fd:90:10:
                    a6:b1:37:f3:cd:3a:24:6e:b4:85:90:bf:80:b9:0c:
                    8c:d5:9b:d6:c8:f1:56:3f:1a:80:89:7a:a9:e2:1b:
                    32:51:2c:3e:f2:df:7b:f6:5d:7a:29:19:8e:e5:c8:
                    bd:36:71:8b:5d:4c:c2:1d:3f:ad:58:a2:cf:3d:70:
                    4d:a6:50:98:25:dc:23:f9:b8:58:41:08:71:bf:4f:
                    b8:84:a0:8f:00:54:15:fc:91:6d:58:a7:96:3b:eb:
                    4b:96:27:cd:6b:a2:a1:86:ac:0d:7c:54:e6:66:4c:
                    66:5f:90:be:21:9a:02:46:2d:e4:83:c2:80:b9:cf:
                    4b:3e:e8:7f:3c:01:ec:8f:5e:cd:7f:d2:28:42:01:
                    95:8a:e2:97:3d:10:21:7d:f6:9d:1c:c5:34:a1:ec:
                    2c:0e:0a:52:2c:12:55:70:24:3d:cb:c2:14:35:43:
                    5d:27:4e:be:c0:bd:aa:7c:96:e7:fc:9e:61:ad:44:
                    d3:00:97
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Subject Key Identifier: 
                06:9A:9B:1F:53:7D:F1:F5:A4:C8:D3:86:3E:A1:73:59:B4:F7:44:21
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Authority Key Identifier: 
                keyid:06:9A:9B:1F:53:7D:F1:F5:A4:C8:D3:86:3E:A1:73:59:B4:F7:44:21

            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
    Signature Algorithm: sha256WithRSAEncryption
         aa:05:6e:b6:dd:15:c9:bf:b3:c6:20:f6:06:47:b0:86:93:25:
         d3:8d:b9:c8:00:3f:97:f5:52:27:88:71:c9:74:fd:eb:ca:64:
         db:5b:ef:1e:5d:ba:bf:d1:eb:ee:5c:69:ba:16:c8:f3:b9:8f:
         d3:36:2e:40:49:07:0d:59:de:8b:10:b0:49:05:e2:ff:91:3f:
         4b:b7:dd:02:8e:f8:81:28:5c:cc:dc:6d:af:5f:14:9c:7d:58:
         78:0d:f6:80:09:b9:e9:0e:97:29:19:b8:b7:eb:f8:16:cb:55:
         12:e4:c6:7d:bb:c4:ec:f8:b5:1c:4e:3e:67:bf:c5:5f:1b:6d:
         6d:47:28:aa:04:58:61:d6:76:bf:22:7f:d0:07:6a:a7:64:53:
         f0:97:8d:9d:80:3f:bb:c1:07:db:65:af:e6:9b:32:9a:c3:54:
         93:c4:1c:08:c3:44:fb:7b:63:11:43:d1:6a:1a:61:6a:79:6d:
         90:4f:29:8e:47:05:c1:12:69:69:d6:c6:36:31:e1:fc:fa:80:
         ba:5c:4f:c4:eb:b7:32:ac:f8:75:61:17:d7:10:19:b9:f1:d2:
         09:ef:7a:42:9d:5b:5a:0b:d4:c6:95:4e:2a:ce:ff:07:d7:4f:
         7e:18:06:88:f1:19:b5:d9:98:bb:ae:71:c4:1c:e7:74:59:58:
         ef:0c:89:cf:8b:1f:75:93:1a:04:14:92:48:50:a9:eb:57:29:
         00:16:e3:36:1c:c8:f8:bf:f0:33:d5:41:0f:c4:cc:3c:dd:e9:
         33:43:01:91:10:2b:1e:d1:b9:5d:cd:32:19:8b:8f:8c:20:77:
         d7:22:c4:42:dc:84:16:9b:25:6d:e8:b4:55:71:7f:b0:7c:b3:
         d3:71:49:b9:cf:52:a4:04:3f:dc:3d:a0:bb:af:33:9e:0a:30:
         60:8e:db:9d:5d:94:a8:bd:60:e7:62:80:76:81:83:0c:8c:cc:
         30:46:49:e2:0c:d2:a8:af:eb:61:71:ef:e7:22:62:a9:f7:5c:
         64:6c:9f:16:8c:67:36:27:45:f5:09:7b:bf:f6:10:0a:f1:b0:
         8d:54:43:8c:04:ba:a3:3f:ef:e2:35:c7:f9:74:e0:6f:34:41:
         d0:bf:73:65:57:20:f9:9b:67:7a:66:68:24:4e:80:65:bd:10:
         99:06:59:f2:65:af:b8:c6:47:bb:fd:90:78:8b:41:73:2e:af:
         55:1f:dc:3b:92:72:6e:84:d3:d0:61:4c:0d:cc:76:57:e2:2d:
         85:22:15:36:0d:eb:01:9d:eb:d8:eb:c4:84:99:fb:c0:0c:cc:
         32:e8:e3:77:da:83:44:8b:9e:55:28:c0:8b:58:d3:90:3e:4e:
         1b:00:f1:15:ad:83:2b:9a
-----BEGIN CERTIFICATE-----
MIIFszCCA5ugAwIBAgIUEwLV4kBMkkaGFmddtLu7sms+/BMwDQYJKoZIhvcNAQEL
BQAwYTELMAkGA1UEBhMCVE4xNzA1BgNVBAoMLkFnZW5jZSBOYXRpb25hbGUgZGUg
Q2VydGlmaWNhdGlvbiBFbGVjdHJvbmlxdWUxGTAXBgNVBAMMEFR1blRydXN0IFJv
b3QgQ0EwHhcNMTkwNDI2MDg1NzU2WhcNNDQwNDI2MDg1NzU2WjBhMQswCQYDVQQG
EwJUTjE3MDUGA1UECgwuQWdlbmNlIE5hdGlvbmFsZSBkZSBDZXJ0aWZpY2F0aW9u
IEVsZWN0cm9uaXF1ZTEZMBcGA1UEAwwQVHVuVHJ1c3QgUm9vdCBDQTCCAiIwDQYJ
KoZIhvcNAQEBBQADggIPADCCAgoCggIBAMPN0/y9BFPdDCA61YguBUtB9YOCfvdZ
n56eY+hz2vYGqU8ftPkLHzmMmiDQfgbU7DTZhrx1W4eI8NLZ1KMKsmwb60ksPqxd
2JQDoOw05TDENX37Jk0bbjBU2PWARZw5rZzJJQRNmpA+TkBuimvNKWfGzC3gdOgF
VwpIUPp6Q9p+7FuaDmJ2/uqdHYVy7BG7NegfJ7/Boce7SBbdVtfMTqDhuazb1YMZ
GoXRlJfXyqNlC/M4+QKu3fZnz8k/9YosRxqZbwUN/dAdgjH8KcwAWJeRTIAAHDOF
li/LQcKLEITDCSSJH7UP2dl3RxiSlGBcx5kDPP73lad9UKGAwqmDrViWVSHbhlnU
r8a83YFuB9tgYv7sEG7aaAH0gxupPqJbI9dkxt/con3YS7qC0lH4Zr8GRuR5KiY2
eY8fTpkdso8MDhz/yV3A/ZAQprE38806JG60hZC/gLkMjNWb1sjxVj8agIl6qeIb
MlEsPvLfe/ZdeikZjuXIvTZxi11Mwh0/rViizz1wTaZQmCXcI/m4WEEIcb9PuISg
jwBUFfyRbVinljvrS5YnzWuioYasDXxU5mZMZl+QviGaAkYt5IPCgLnPSz7ofzwB
7I9ezX/SKEIBlYrilz0QIX32nRzFNKHsLA4KUiwSVXAkPcvCFDVDXSdOvsC9qnyW
5/yeYa1E0wCXAgMBAAGjYzBhMB0GA1UdDgQWBBQGmpsfU33x9aTI04Y+oXNZtPdE
ITAPBgNVHRMBAf8EBTADAQH/MB8GA1UdIwQYMBaAFAaamx9TffH1pMjThj6hc1m0
90QhMA4GA1UdDwEB/wQEAwIBBjANBgkqhkiG9w0BAQsFAAOCAgEAqgVutt0Vyb+z
xiD2BkewhpMl0425yAA/l/VSJ4hxyXT968pk21vvHl26v9Hr7lxpuhbI87mP0zYu
QEkHDVneixCwSQXi/5E/S7fdAo74gShczNxtr18UnH1YeA32gAm56Q6XKRm4t+v4
FstVEuTGfbvE7Pi1HE4+Z7/FXxttbUcoqgRYYdZ2vyJ/0Adqp2RT8JeNnYA/u8EH
22Wv5psymsNUk8QcCMNE+3tjEUPRahphanltkE8pjkcFwRJpadbGNjHh/PqAulxP
xOu3Mqz4dWEX1xAZufHSCe96Qp1bWgvUxpVOKs7/B9dPfhgGiPEZtdmYu65xxBzn
dFlY7wyJz4sfdZMaBBSSSFCp61cpABbjNhzI+L/wM9VBD8TMPN3pM0MBkRArHtG5
Xc0yGYuPjCB31yLEQtyEFpslbei0VXF/sHyz03FJuc9SpAQ/3D2gu68zngowYI7b
nV2UqL1g52KAdoGDDIzMMEZJ4gzSqK/rYXHv5yJiqfdcZGyfFoxnNidF9Ql7v/YQ
CvGwjVRDjAS6oz/v4jXH+XTgbzRB0L9zZVcg+ZtnemZoJE6AZb0QmQZZ8mWvuMZH
u/2QeItBcy6vVR/cO5JyboTT0GFMDcx2V+IthSIVNg3rAZ3r2OvEhJn7wAzMMujj
d9qDRIueVSjAi1jTkD5OGwDxFa2DK5o=
-----END CERTIFICATE-----

HARICA TLS RSA Root CA 2021
=================================================
SHA1 Fingerprint=02:2D:05:82:FA:88:CE:14:0C:06:79:DE:7F:14:10:E9:45:D7:A5:6D
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            39:ca:93:1c:ef:43:f3:c6:8e:93:c7:f4:64:89:38:7e
    Signature Algorithm: sha256WithRSAEncryption
        Issuer: C=GR, O=Hellenic Academic and Research Institutions CA, CN=HARICA TLS RSA Root CA 2021
        Validity
            Not Before: Feb 19 10:55:38 2021 GMT
            Not After : Feb 13 10:55:37 2045 GMT
        Subject: C=GR, O=Hellenic Academic and Research Institutions CA, CN=HARICA TLS RSA Root CA 2021
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (4096 bit)
                Modulus:
                    00:8b:c2:e7:af:65:9b:05:67:96:c9:0d:24:b9:d0:
                    0e:64:fc:ce:e2:24:18:2c:84:7f:77:51:cb:04:11:
                    36:b8:5e:ed:69:71:a7:9e:e4:25:09:97:67:c1:47:
                    c2:cf:91:16:36:62:3d:38:04:e1:51:82:ff:ac:d2:
                    b4:69:dd:2e:ec:11:a3:45:ee:6b:6b:3b:4c:bf:8c:
                    8d:a4:1e:9d:11:b9:e9:38:f9:7a:0e:0c:98:e2:23:
                    1d:d1:4e:63:d4:e7:b8:41:44:fb:6b:af:6b:da:1f:
                    d3:c5:91:88:5b:a4:89:92:d1:81:e6:8c:39:58:a0:
                    d6:69:43:a9:ad:98:52:58:6e:db:0a:fb:6b:cf:68:
                    fa:e3:a4:5e:3a:45:73:98:07:ea:5f:02:72:de:0c:
                    a5:b3:9f:ae:a9:1d:b7:1d:b3:fc:8a:59:e7:6e:72:
                    65:ad:f5:30:94:23:07:f3:82:16:4b:35:98:9c:53:
                    bb:2f:ca:e4:5a:d9:c7:8d:1d:fc:98:99:fb:2c:a4:
                    82:6b:f0:2a:1f:8e:0b:5f:71:5c:5c:ae:42:7b:29:
                    89:81:cb:03:a3:99:ca:88:9e:0b:40:09:41:33:db:
                    e6:58:7a:fd:ae:99:70:c0:5a:0f:d6:13:86:71:2f:
                    76:69:fc:90:dd:db:2d:6e:d1:f2:9b:f5:1a:6b:9e:
                    6f:15:8c:7a:f0:4b:28:a0:22:38:80:24:6c:36:a4:
                    3b:f2:30:91:f3:78:13:cf:c1:3f:35:ab:f1:1d:11:
                    23:b5:43:22:9e:01:92:b7:18:02:e5:11:d1:82:db:
                    15:00:cc:61:37:c1:2a:7c:9a:e1:d0:ba:b3:50:46:
                    ee:82:ac:9d:31:f8:fb:23:e2:03:00:48:70:a3:09:
                    26:79:15:53:60:f3:38:5c:ad:38:ea:81:00:63:14:
                    b9:33:5e:dd:0b:db:a0:45:07:1a:33:09:f8:4d:b4:
                    a7:02:a6:69:f4:c2:59:05:88:65:85:56:ae:4b:cb:
                    e0:de:3c:7d:2d:1a:c8:e9:fb:1f:a3:61:4a:d6:2a:
                    13:ad:77:4c:1a:18:9b:91:0f:58:d8:06:54:c5:97:
                    f8:aa:3f:20:8a:a6:85:a6:77:f6:a6:fc:1c:e2:ee:
                    6e:94:33:2a:83:50:84:0a:e5:4f:86:f8:50:45:78:
                    00:81:eb:5b:68:e3:26:8d:cc:7b:5c:51:f4:14:2c:
                    40:be:1a:60:1d:7a:72:61:1d:1f:63:2d:88:aa:ce:
                    a2:45:90:08:fc:6b:be:b3:50:2a:5a:fd:a8:48:18:
                    46:d6:90:40:92:90:0a:84:5e:68:31:f8:eb:ed:0d:
                    d3:1d:c6:7d:99:18:55:56:27:65:2e:8d:45:c5:24:
                    ec:ce:e3
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Subject Key Identifier: 
                0A:48:23:A6:60:A4:92:0A:33:EA:93:5B:C5:57:EA:25:4D:BD:12:EE
            X509v3 Key Usage: critical
                Digital Signature, Certificate Sign, CRL Sign
    Signature Algorithm: sha256WithRSAEncryption
         3e:90:48:aa:6e:62:15:25:66:7b:0c:d5:8c:8b:89:9d:d7:ed:
         4e:07:ef:9c:d0:14:5f:5e:50:bd:68:96:90:a4:14:11:aa:68:
         6d:09:35:39:40:09:da:f4:09:2c:34:a5:7b:59:84:49:29:97:
         74:c8:07:1e:47:6d:f2:ce:1c:50:26:e3:9e:3d:40:53:3f:f7:
         7f:96:76:10:c5:46:a5:d0:20:4b:50:f4:35:3b:18:f4:55:6a:
         41:1b:47:06:68:3c:bb:09:08:62:d9:5f:55:42:aa:ac:53:85:
         ac:95:56:36:56:ab:e4:05:8c:c5:a8:da:1f:a3:69:bd:53:0f:
         c4:ff:dc:ca:e3:7e:f2:4c:88:86:47:46:1a:f3:00:f5:80:91:
         a2:dc:43:42:94:9b:20:f0:d1:cd:b2:eb:2c:53:c2:53:78:4a:
         4f:04:94:41:9a:8f:27:32:c1:e5:49:19:bf:f1:f2:c2:8b:a8:
         0a:39:31:28:b4:7d:62:36:2c:4d:ec:1f:33:b6:7e:77:6d:7e:
         50:f0:9f:0e:d7:11:8f:cf:18:c5:e3:27:fe:26:ef:05:9d:cf:
         cf:37:c5:d0:7b:da:3b:b0:16:84:0c:3a:93:d6:be:17:db:0f:
         3e:0e:19:78:09:c7:a9:02:72:22:4b:f7:37:76:ba:75:c4:85:
         03:5a:63:d5:b1:75:05:c2:b9:bd:94:ad:8c:15:99:a7:93:7d:
         f6:c5:f3:aa:74:cf:04:85:94:98:00:f4:e2:f9:ca:24:65:bf:
         e0:62:af:c8:c5:fa:b2:c9:9e:56:48:da:79:fd:96:76:15:be:
         a3:8e:56:c4:b3:34:fc:be:47:f4:c1:b4:a8:fc:d5:30:88:68:
         ee:cb:ae:c9:63:c4:76:be:ac:38:18:e1:5e:5c:cf:ae:3a:22:
         51:eb:d1:8b:b3:f3:2b:33:07:54:87:fa:b4:b2:13:7b:ba:53:
         04:62:01:9d:f1:c0:4f:ee:e1:3a:d4:8b:20:10:fa:02:57:e6:
         ef:c1:0b:b7:90:46:9c:19:29:8c:dc:6f:a0:4a:69:69:94:b7:
         24:65:a0:ff:ac:3f:ce:01:fb:21:2e:fd:68:f8:9b:f2:a5:cf:
         31:38:5c:15:aa:e6:97:00:c1:df:5a:a5:a7:39:aa:e9:84:7f:
         3c:51:a8:3a:d9:94:5b:8c:bf:4f:08:71:e5:db:a8:5c:d4:d2:
         a6:fe:00:a3:c6:16:c7:0f:e8:80:ce:1c:28:64:74:19:08:d3:
         42:e3:ce:00:5d:7f:b1:dc:13:b0:e1:05:cb:d1:20:aa:86:74:
         9e:39:e7:91:fd:ff:5b:d6:f7:ad:a6:2f:03:0b:6d:e3:57:54:
         eb:76:53:18:8d:11:98:ba
-----BEGIN CERTIFICATE-----
MIIFpDCCA4ygAwIBAgIQOcqTHO9D88aOk8f0ZIk4fjANBgkqhkiG9w0BAQsFADBs
MQswCQYDVQQGEwJHUjE3MDUGA1UECgwuSGVsbGVuaWMgQWNhZGVtaWMgYW5kIFJl
c2VhcmNoIEluc3RpdHV0aW9ucyBDQTEkMCIGA1UEAwwbSEFSSUNBIFRMUyBSU0Eg
Um9vdCBDQSAyMDIxMB4XDTIxMDIxOTEwNTUzOFoXDTQ1MDIxMzEwNTUzN1owbDEL
MAkGA1UEBhMCR1IxNzA1BgNVBAoMLkhlbGxlbmljIEFjYWRlbWljIGFuZCBSZXNl
YXJjaCBJbnN0aXR1dGlvbnMgQ0ExJDAiBgNVBAMMG0hBUklDQSBUTFMgUlNBIFJv
b3QgQ0EgMjAyMTCCAiIwDQYJKoZIhvcNAQEBBQADggIPADCCAgoCggIBAIvC569l
mwVnlskNJLnQDmT8zuIkGCyEf3dRywQRNrhe7Wlxp57kJQmXZ8FHws+RFjZiPTgE
4VGC/6zStGndLuwRo0Xua2s7TL+MjaQenRG56Tj5eg4MmOIjHdFOY9TnuEFE+2uv
a9of08WRiFukiZLRgeaMOVig1mlDqa2YUlhu2wr7a89o+uOkXjpFc5gH6l8Cct4M
pbOfrqkdtx2z/IpZ525yZa31MJQjB/OCFks1mJxTuy/K5FrZx40d/JiZ+yykgmvw
Kh+OC19xXFyuQnspiYHLA6OZyoieC0AJQTPb5lh6/a6ZcMBaD9YThnEvdmn8kN3b
LW7R8pv1GmuebxWMevBLKKAiOIAkbDakO/IwkfN4E8/BPzWr8R0RI7VDIp4BkrcY
AuUR0YLbFQDMYTfBKnya4dC6s1BG7oKsnTH4+yPiAwBIcKMJJnkVU2DzOFytOOqB
AGMUuTNe3QvboEUHGjMJ+E20pwKmafTCWQWIZYVWrkvL4N48fS0ayOn7H6NhStYq
E613TBoYm5EPWNgGVMWX+Ko/IIqmhaZ39qb8HOLubpQzKoNQhArlT4b4UEV4AIHr
W2jjJo3Me1xR9BQsQL4aYB16cmEdH2MtiKrOokWQCPxrvrNQKlr9qEgYRtaQQJKQ
CoReaDH46+0N0x3GfZkYVVYnZS6NRcUk7M7jAgMBAAGjQjBAMA8GA1UdEwEB/wQF
MAMBAf8wHQYDVR0OBBYEFApII6ZgpJIKM+qTW8VX6iVNvRLuMA4GA1UdDwEB/wQE
AwIBhjANBgkqhkiG9w0BAQsFAAOCAgEAPpBIqm5iFSVmewzVjIuJndftTgfvnNAU
X15QvWiWkKQUEapobQk1OUAJ2vQJLDSle1mESSmXdMgHHkdt8s4cUCbjnj1AUz/3
f5Z2EMVGpdAgS1D0NTsY9FVqQRtHBmg8uwkIYtlfVUKqrFOFrJVWNlar5AWMxaja
H6NpvVMPxP/cyuN+8kyIhkdGGvMA9YCRotxDQpSbIPDRzbLrLFPCU3hKTwSUQZqP
JzLB5UkZv/HywouoCjkxKLR9YjYsTewfM7Z+d21+UPCfDtcRj88YxeMn/ibvBZ3P
zzfF0HvaO7AWhAw6k9a+F9sPPg4ZeAnHqQJyIkv3N3a6dcSFA1pj1bF1BcK5vZSt
jBWZp5N99sXzqnTPBIWUmAD04vnKJGW/4GKvyMX6ssmeVkjaef2WdhW+o45WxLM0
/L5H9MG0qPzVMIho7suuyWPEdr6sOBjhXlzPrjoiUevRi7PzKzMHVIf6tLITe7pT
BGIBnfHAT+7hOtSLIBD6Alfm78ELt5BGnBkpjNxvoEppaZS3JGWg/6w/zgH7IS79
aPib8qXPMThcFarmlwDB31qlpzmq6YR/PFGoOtmUW4y/Twhx5duoXNTSpv4Ao8YW
xw/ogM4cKGR0GQjTQuPOAF1/sdwTsOEFy9EgqoZ0njnnkf3/W9b3raYvAwtt41dU
63ZTGI0RmLo=
-----END CERTIFICATE-----

HARICA TLS ECC Root CA 2021
=================================================
SHA1 Fingerprint=BC:B0:C1:9D:E9:98:92:70:19:38:57:E9:8D:A7:B4:5D:6E:EE:01:48
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            67:74:9d:8d:77:d8:3b:6a:db:22:f4:ff:59:e2:bf:ce
    Signature Algorithm: ecdsa-with-SHA384
        Issuer: C=GR, O=Hellenic Academic and Research Institutions CA, CN=HARICA TLS ECC Root CA 2021
        Validity
            Not Before: Feb 19 11:01:10 2021 GMT
            Not After : Feb 13 11:01:09 2045 GMT
        Subject: C=GR, O=Hellenic Academic and Research Institutions CA, CN=HARICA TLS ECC Root CA 2021
        Subject Public Key Info:
            Public Key Algorithm: id-ecPublicKey
                Public-Key: (384 bit)
                pub: 
                    04:38:08:fe:b1:a0:96:d2:7a:ac:af:49:3a:d0:c0:
                    e0:c3:3b:28:aa:f1:72:6d:65:00:47:88:84:fc:9a:
                    26:6b:aa:4b:ba:6c:04:0a:88:5e:17:f2:55:87:fc:
                    30:b0:34:e2:34:58:57:1a:84:53:e9:30:d9:a9:f2:
                    96:74:c3:51:1f:58:49:31:cc:98:4e:60:11:87:75:
                    d3:72:94:90:4f:9b:10:25:2a:a8:78:2d:be:90:41:
                    58:90:15:72:a7:a1:b7
                ASN1 OID: secp384r1
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Subject Key Identifier: 
                C9:1B:53:81:12:FE:04:D5:16:D1:AA:BC:9A:6F:B7:A0:95:19:6E:CA
            X509v3 Key Usage: critical
                Digital Signature, Certificate Sign, CRL Sign
    Signature Algorithm: ecdsa-with-SHA384
         30:64:02:30:11:de:ae:f8:dc:4e:88:b0:a9:f0:22:ad:c2:51:
         40:ef:60:71:2d:ee:8f:02:c4:5d:03:70:49:a4:92:ea:c5:14:
         88:70:a6:d3:0d:b0:aa:ca:2c:40:9c:fb:e9:82:6e:9a:02:30:
         2b:47:9a:07:c6:d1:c2:81:7c:ca:0b:96:18:41:1b:a3:f4:30:
         09:9e:b5:23:28:0d:9f:14:b6:3c:53:a2:4c:06:69:7d:fa:6c:
         91:c6:2a:49:45:e6:ec:b7:13:e1:3a:6c
-----BEGIN CERTIFICATE-----
MIICVDCCAdugAwIBAgIQZ3SdjXfYO2rbIvT/WeK/zjAKBggqhkjOPQQDAzBsMQsw
CQYDVQQGEwJHUjE3MDUGA1UECgwuSGVsbGVuaWMgQWNhZGVtaWMgYW5kIFJlc2Vh
cmNoIEluc3RpdHV0aW9ucyBDQTEkMCIGA1UEAwwbSEFSSUNBIFRMUyBFQ0MgUm9v
dCBDQSAyMDIxMB4XDTIxMDIxOTExMDExMFoXDTQ1MDIxMzExMDEwOVowbDELMAkG
A1UEBhMCR1IxNzA1BgNVBAoMLkhlbGxlbmljIEFjYWRlbWljIGFuZCBSZXNlYXJj
aCBJbnN0aXR1dGlvbnMgQ0ExJDAiBgNVBAMMG0hBUklDQSBUTFMgRUNDIFJvb3Qg
Q0EgMjAyMTB2MBAGByqGSM49AgEGBSuBBAAiA2IABDgI/rGgltJ6rK9JOtDA4MM7
KKrxcm1lAEeIhPyaJmuqS7psBAqIXhfyVYf8MLA04jRYVxqEU+kw2anylnTDUR9Y
STHMmE5gEYd103KUkE+bECUqqHgtvpBBWJAVcqeht6NCMEAwDwYDVR0TAQH/BAUw
AwEB/zAdBgNVHQ4EFgQUyRtTgRL+BNUW0aq8mm+3oJUZbsowDgYDVR0PAQH/BAQD
AgGGMAoGCCqGSM49BAMDA2cAMGQCMBHervjcToiwqfAircJRQO9gcS3ujwLEXQNw
SaSS6sUUiHCm0w2wqsosQJz76YJumgIwK0eaB8bRwoF8yguWGEEbo/QwCZ61IygN
nxS2PFOiTAZpffpskcYqSUXm7LcT4Tps
-----END CERTIFICATE-----
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 769 (0x301)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=The Go Daddy Group, Inc., OU=Go Daddy Class 2 Certification Authority
        Validity
            Not Before: Nov 16 01:54:37 2006 GMT
            Not After : Nov 16 01:54:37 2026 GMT
        Subject: C=US, ST=Arizona, L=Scottsdale, O=GoDaddy.com, Inc., OU=http://certificates.godaddy.com/repository, CN=Go Daddy Secure Certification Authority/serialNumber=07969287
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:c4:2d:d5:15:8c:9c:26:4c:ec:32:35:eb:5f:b8:
                    59:01:5a:a6:61:81:59:3b:70:63:ab:e3:dc:3d:c7:
                    2a:b8:c9:33:d3:79:e4:3a:ed:3c:30:23:84:8e:b3:
                    30:14:b6:b2:87:c3:3d:95:54:04:9e:df:99:dd:0b:
                    25:1e:21:de:65:29:7e:35:a8:a9:54:eb:f6:f7:32:
                    39:d4:26:55:95:ad:ef:fb:fe:58:86:d7:9e:f4:00:
                    8d:8c:2a:0c:bd:42:04:ce:a7:3f:04:f6:ee:80:f2:
                    aa:ef:52:a1:69:66:da:be:1a:ad:5d:da:2c:66:ea:
                    1a:6b:bb:e5:1a:51:4a:00:2f:48:c7:98:75:d8:b9:
                    29:c8:ee:f8:66:6d:0a:9c:b3:f3:fc:78:7c:a2:f8:
                    a3:f2:b5:c3:f3:b9:7a:91:c1:a7:e6:25:2e:9c:a8:
                    ed:12:65:6e:6a:f6:12:44:53:70:30:95:c3:9c:2b:
                    58:2b:3d:08:74:4a:f2:be:51:b0:bf:87:d0:4c:27:
                    58:6b:b5:35:c5:9d:af:17:31:f8:0b:8f:ee:ad:81:
                    36:05:89:08:98:cf:3a:af:25:87:c0:49:ea:a7:fd:
                    67:f7:45:8e:97:cc:14:39:e2:36:85:b5:7e:1a:37:
                    fd:16:f6:71:11:9a:74:30:16:fe:13:94:a3:3f:84:
                    0d:4f
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Subject Key Identifier: 
                FD:AC:61:32:93:6C:45:D6:E2:EE:85:5F:9A:BA:E7:76:99:68:CC:E7
            X509v3 Authority Key Identifier: 
                keyid:D2:C4:B0:D2:91:D4:4C:11:71:B3:61:CB:3D:A1:FE:DD:A8:6A:D4:E3

            X509v3 Basic Constraints: critical
                CA:TRUE, pathlen:0
            Authority Information Access: 
                OCSP - URI:http://ocsp.godaddy.com

            X509v3 CRL Distribution Points: 
                URI:http://certificates.godaddy.com/repository/gdroot.crl

            X509v3 Certificate Policies: 
                Policy: X509v3 Any Policy
                  CPS: http://certificates.godaddy.com/repository

            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
    Signature Algorithm: sha1WithRSAEncryption
        d2:86:c0:ec:bd:f9:a1:b6:67:ee:66:0b:a2:06:3a:04:50:8e:
        15:72:ac:4a:74:95:53:cb:37:cb:44:49:ef:07:90:6b:33:d9:
        96:f0:94:56:a5:13:30:05:3c:85:32:21:7b:c9:c7:0a:a8:24:
        a4:90:de:46:d3:25:23:14:03:67:c2:10:d6:6f:0f:5d:7b:7a:
        cc:9f:c5:58:2a:c1:c4:9e:21:a8:5a:f3:ac:a4:46:f3:9e:e4:
        63:cb:2f:90:a4:29:29:01:d9:72:2c:29:df:37:01:27:bc:4f:
        ee:68:d3:21:8f:c0:b3:e4:f5:09:ed:d2:10:aa:53:b4:be:f0:
        cc:59:0b:d6:3b:96:1c:95:24:49:df:ce:ec:fd:a7:48:91:14:
        45:0e:3a:36:6f:da:45:b3:45:a2:41:c9:d4:d7:44:4e:3e:b9:
        74:76:d5:a2:13:55:2c:c6:87:a3:b5:99:ac:06:84:87:7f:75:
        06:fc:bf:14:4c:0e:cc:6e:c4:df:3d:b7:12:71:f4:e8:f1:51:
        40:22:28:49:e0:1d:4b:87:a8:34:cc:06:a2:dd:12:5a:d1:86:
        36:64:03:35:6f:6f:77:6e:eb:f2:85:50:98:5e:ab:03:53:ad:
        91:23:63:1f:16:9c:cd:b9:b2:05:63:3a:e1:f4:68:1b:17:05:
        35:95:53:ee
SHA1 Fingerprint=7C:46:56:C3:06:1F:7F:4C:0D:67:B3:19:A8:55:F6:0E:BC:11:FC:44
-----BEGIN CERTIFICATE-----
MIIE3jCCA8agAwIBAgICAwEwDQYJKoZIhvcNAQEFBQAwYzELMAkGA1UEBhMCVVMx
ITAfBgNVBAoTGFRoZSBHbyBEYWRkeSBHcm91cCwgSW5jLjExMC8GA1UECxMoR28g
RGFkZHkgQ2xhc3MgMiBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTAeFw0wNjExMTYw
MTU0MzdaFw0yNjExMTYwMTU0MzdaMIHKMQswCQYDVQQGEwJVUzEQMA4GA1UECBMH
QXJpem9uYTETMBEGA1UEBxMKU2NvdHRzZGFsZTEaMBgGA1UEChMRR29EYWRkeS5j
b20sIEluYy4xMzAxBgNVBAsTKmh0dHA6Ly9jZXJ0aWZpY2F0ZXMuZ29kYWRkeS5j
b20vcmVwb3NpdG9yeTEwMC4GA1UEAxMnR28gRGFkZHkgU2VjdXJlIENlcnRpZmlj
YXRpb24gQXV0aG9yaXR5MREwDwYDVQQFEwgwNzk2OTI4NzCCASIwDQYJKoZIhvcN
AQEBBQADggEPADCCAQoCggEBAMQt1RWMnCZM7DI161+4WQFapmGBWTtwY6vj3D3H
KrjJM9N55DrtPDAjhI6zMBS2sofDPZVUBJ7fmd0LJR4h3mUpfjWoqVTr9vcyOdQm
VZWt7/v+WIbXnvQAjYwqDL1CBM6nPwT27oDyqu9SoWlm2r4arV3aLGbqGmu75RpR
SgAvSMeYddi5Kcju+GZtCpyz8/x4fKL4o/K1w/O5epHBp+YlLpyo7RJlbmr2EkRT
cDCVw5wrWCs9CHRK8r5RsL+H0EwnWGu1NcWdrxcx+AuP7q2BNgWJCJjPOq8lh8BJ
6qf9Z/dFjpfMFDniNoW1fho3/Rb2cRGadDAW/hOUoz+EDU8CAwEAAaOCATIwggEu
MB0GA1UdDgQWBBT9rGEyk2xF1uLuhV+auud2mWjM5zAfBgNVHSMEGDAWgBTSxLDS
kdRMEXGzYcs9of7dqGrU4zASBgNVHRMBAf8ECDAGAQH/AgEAMDMGCCsGAQUFBwEB
BCcwJTAjBggrBgEFBQcwAYYXaHR0cDovL29jc3AuZ29kYWRkeS5jb20wRgYDVR0f
BD8wPTA7oDmgN4Y1aHR0cDovL2NlcnRpZmljYXRlcy5nb2RhZGR5LmNvbS9yZXBv
c2l0b3J5L2dkcm9vdC5jcmwwSwYDVR0gBEQwQjBABgRVHSAAMDgwNgYIKwYBBQUH
AgEWKmh0dHA6Ly9jZXJ0aWZpY2F0ZXMuZ29kYWRkeS5jb20vcmVwb3NpdG9yeTAO
BgNVHQ8BAf8EBAMCAQYwDQYJKoZIhvcNAQEFBQADggEBANKGwOy9+aG2Z+5mC6IG
OgRQjhVyrEp0lVPLN8tESe8HkGsz2ZbwlFalEzAFPIUyIXvJxwqoJKSQ3kbTJSMU
A2fCENZvD117esyfxVgqwcSeIaha86ykRvOe5GPLL5CkKSkB2XIsKd83ASe8T+5o
0yGPwLPk9Qnt0hCqU7S+8MxZC9Y7lhyVJEnfzuz9p0iRFEUOOjZv2kWzRaJBydTX
RE4+uXR21aITVSzGh6O1mawGhId/dQb8vxRMDsxuxN89txJx9OjxUUAiKEngHUuH
qDTMBqLdElrRhjZkAzVvb3du6/KFUJheqwNTrZEjYx8WnM25sgVjOuH0aBsXBTWV
U+4=
-----END CERTIFICATE-----
SHA1 Fingerprint=42:85:78:55:FB:0E:A4:3F:54:C9:91:1E:30:E7:79:1D:8C:E8:27:05
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            0a:5f:11:4d:03:5b:17:91:17:d2:ef:d4:03:8c:3f:3b
    Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=DigiCert Inc, OU=www.digicert.com, CN=DigiCert High Assurance EV Root CA
        Validity
            Not Before: Apr  2 12:00:00 2008 GMT
            Not After : Apr  3 00:00:00 2022 GMT
        Subject: C=US, O=DigiCert Inc, OU=www.digicert.com, CN=DigiCert High Assurance CA-3
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (2048 bit)
                Modulus:
                    00:bf:61:0a:29:10:1f:5e:fe:34:37:51:08:f8:1e:
                    fb:22:ed:61:be:0b:0d:70:4c:50:63:26:75:15:b9:
                    41:88:97:b6:f0:a0:15:bb:08:60:e0:42:e8:05:29:
                    10:87:36:8a:28:65:a8:ef:31:07:74:6d:36:97:2f:
                    28:46:66:04:c7:2a:79:26:7a:99:d5:8e:c3:6d:4f:
                    a0:5e:ad:bc:3d:91:c2:59:7b:5e:36:6c:c0:53:cf:
                    00:08:32:3e:10:64:58:10:13:69:c7:0c:ee:9c:42:
                    51:00:f9:05:44:ee:24:ce:7a:1f:ed:8c:11:bd:12:
                    a8:f3:15:f4:1c:7a:31:69:01:1b:a7:e6:5d:c0:9a:
                    6c:7e:09:9e:e7:52:44:4a:10:3a:23:e4:9b:b6:03:
                    af:a8:9c:b4:5b:9f:d4:4b:ad:92:8c:ce:b5:11:2a:
                    aa:37:18:8d:b4:c2:b8:d8:5c:06:8c:f8:ff:23:bd:
                    35:5e:d4:7c:3e:7e:83:0e:91:96:05:98:c3:b2:1f:
                    e3:c8:65:eb:a9:7b:5d:a0:2c:cc:fc:3c:d9:6d:ed:
                    cc:fa:4b:43:8c:c9:d4:b8:a5:61:1c:b2:40:b6:28:
                    12:df:b9:f8:5f:fe:d3:b2:c9:ef:3d:b4:1e:4b:7c:
                    1c:4c:99:36:9e:3d:eb:ec:a7:68:5e:1d:df:67:6e:
                    5e:fb
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Key Usage: critical
                Digital Signature, Certificate Sign, CRL Sign
            X509v3 Certificate Policies: 
                Policy: 2.16.840.1.114412.1.3.0.2
                  CPS: http://www.digicert.com/ssl-cps-repository.htm
                  User Notice:
                    Explicit Text: 

            X509v3 Basic Constraints: critical
                CA:TRUE, pathlen:0
            Authority Information Access: 
                OCSP - URI:http://ocsp.digicert.com

            X509v3 CRL Distribution Points: 

                Full Name:
                  URI:http://crl3.digicert.com/DigiCertHighAssuranceEVRootCA.crl

                Full Name:
                  URI:http://crl4.digicert.com/DigiCertHighAssuranceEVRootCA.crl

            X509v3 Authority Key Identifier: 
                keyid:B1:3E:C3:69:03:F8:BF:47:01:D4:98:26:1A:08:02:EF:63:64:2B:C3

            X509v3 Subject Key Identifier: 
                50:EA:73:89:DB:29:FB:10:8F:9E:E5:01:20:D4:DE:79:99:48:83:F7
    Signature Algorithm: sha1WithRSAEncryption
         1e:e2:a5:48:9e:6c:db:53:38:0f:ef:a6:1a:2a:ac:e2:03:43:
         ed:9a:bc:3e:8e:75:1b:f0:fd:2e:22:59:ac:13:c0:61:e2:e7:
         fa:e9:99:cd:87:09:75:54:28:bf:46:60:dc:be:51:2c:92:f3:
         1b:91:7c:31:08:70:e2:37:b9:c1:5b:a8:bd:a3:0b:00:fb:1a:
         15:fd:03:ad:58:6a:c5:c7:24:99:48:47:46:31:1e:92:ef:b4:
         5f:4e:34:c7:90:bf:31:c1:f8:b1:84:86:d0:9c:01:aa:df:8a:
         56:06:ce:3a:e9:0e:ae:97:74:5d:d7:71:9a:42:74:5f:de:8d:
         43:7c:de:e9:55:ed:69:00:cb:05:e0:7a:61:61:33:d1:19:4d:
         f9:08:ee:a0:39:c5:25:35:b7:2b:c4:0f:b2:dd:f1:a5:b7:0e:
         24:c4:26:28:8d:79:77:f5:2f:f0:57:ba:7c:07:d4:e1:fc:cd:
         5a:30:57:7e:86:10:47:dd:31:1f:d7:fc:a2:c2:bf:30:7c:5d:
         24:aa:e8:f9:ae:5f:6a:74:c2:ce:6b:b3:46:d8:21:be:29:d4:
         8e:5e:15:d6:42:4a:e7:32:6f:a4:b1:6b:51:83:58:be:3f:6d:
         c7:fb:da:03:21:cb:6a:16:19:4e:0a:f0:ad:84:ca:5d:94:b3:
         5a:76:f7:61
-----BEGIN CERTIFICATE-----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-----END CERTIFICATE-----
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 0 (0x0)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=ES, ST=Madrid, L=Madrid, O=IPS Certification Authority s.l. ipsCA, OU=ipsCA, CN=ipsCA Global CA Root/emailAddress=global01@ipsca.com
        Validity
            Not Before: Sep  7 14:38:44 2009 GMT
            Not After : Dec 25 14:38:44 2029 GMT
        Subject: C=ES, ST=Madrid, L=Madrid, O=IPS Certification Authority s.l. ipsCA, OU=ipsCA, CN=ipsCA Global CA Root/emailAddress=global01@ipsca.com
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:a7:ef:cc:80:30:b0:91:24:4f:b0:68:f8:c3:ca:
                    2d:15:38:55:58:82:e2:38:63:b0:f7:a3:92:6f:83:
                    b8:b0:5e:b0:8c:ac:54:b1:77:d0:50:e0:97:b3:90:
                    ad:8a:b3:1f:39:2b:45:56:f7:aa:e2:df:7c:b2:ec:
                    6f:53:2f:9a:cb:d0:e6:66:cb:c9:13:e8:72:e2:b4:
                    cd:31:57:87:12:b5:93:e8:fa:72:ce:ea:47:f2:8c:
                    b4:b0:63:d7:04:00:b7:64:36:39:97:e8:95:f1:88:
                    f9:71:0d:03:27:8c:61:cf:08:83:96:4f:83:c5:4e:
                    e8:5c:f8:06:70:f1:02:aa:1c:1e:a9:c8:aa:7e:e7:
                    5d:cd:8d:3c:14:6f:67:d0:1b:a9:23:48:8b:21:28:
                    3a:8a:4c:e6:11:31:f9:21:2e:b2:67:66:c6:29:6e:
                    94:93:cf:40:96:fc:b0:3d:bf:b2:b4:93:bf:56:71:
                    b6:a5:41:87:b0:58:b5:59:23:28:49:b8:98:f9:50:
                    1e:2d:15:28:0b:4c:ac:49:d1:84:a9:9b:9a:e7:72:
                    54:b7:38:d0:db:c9:fe:a9:73:d5:6d:10:cd:8e:75:
                    eb:fe:97:fd:80:3c:fc:b4:d8:48:f4:99:46:0b:88:
                    14:a4:b6:2e:db:4c:60:f4:21:c1:6c:80:95:14:d5:
                    af:d5
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Subject Key Identifier: 
                15:A6:96:80:B1:15:4B:31:C3:C2:9C:F6:E7:13:0B:4B:F3:18:CD:86
            X509v3 Authority Key Identifier: 
                keyid:15:A6:96:80:B1:15:4B:31:C3:C2:9C:F6:E7:13:0B:4B:F3:18:CD:86
                DirName:/C=ES/ST=Madrid/L=Madrid/O=IPS Certification Authority s.l. ipsCA/OU=ipsCA/CN=ipsCA Global CA Root/emailAddress=global01@ipsca.com
                serial:00

            X509v3 Basic Constraints: 
                CA:TRUE
            X509v3 Key Usage: 
                Certificate Sign, CRL Sign
            X509v3 Extended Key Usage: 
                TLS Web Server Authentication, TLS Web Client Authentication, Code Signing, E-mail Protection, Time Stamping, Microsoft Encrypted File System
            X509v3 Subject Alternative Name: 
                email:global01@ipsca.com
            X509v3 Issuer Alternative Name: 
                email:global01@ipsca.com
            X509v3 CRL Distribution Points: 
                URI:http://crlglobal01.ipsca.com/crl/crlglobal01.crl

            Authority Information Access: 
                OCSP - URI:http://crlglobal01.ipsca.com

    Signature Algorithm: sha1WithRSAEncryption
        18:f4:ae:fe:80:0f:8e:c1:77:6f:a2:5a:47:48:9f:23:55:a1:
        53:6b:f9:5d:a7:30:a5:24:be:43:2f:f8:c1:d1:57:f9:3e:2c:
        80:25:cc:46:a9:36:f3:49:5b:1d:f6:7c:d7:63:b3:4d:3e:78:
        f6:a7:b4:02:77:f8:79:0d:3e:6a:cb:18:60:b8:fd:00:af:0c:
        dd:54:e3:54:8f:22:3d:f3:10:6f:11:0d:b5:1e:7a:8d:27:cc:
        08:b8:5b:c3:b8:1a:5f:2b:a7:60:3f:00:1c:f7:0f:5c:42:66:
        64:9e:87:12:80:70:89:e0:fa:57:28:0e:4e:1f:10:2f:d9:05:
        80:b6:80:2f:1c:69:f0:f6:b6:65:34:05:6f:ca:d9:3e:f8:d4:
        5d:37:32:c7:b8:2b:cc:ff:73:93:00:71:e0:01:c8:aa:43:bd:
        a9:f1:ce:fa:80:f9:f1:43:12:91:a6:65:e5:60:07:4d:47:ba:
        2b:2f:04:f6:4a:85:29:88:65:10:c9:b2:53:62:9c:6c:9b:60:
        5c:1a:1b:d3:ae:c5:1d:72:99:06:ff:05:cc:86:26:73:b4:d4:
        54:05:dd:1e:6b:00:3b:b7:89:e8:e3:91:02:20:12:eb:ef:e9:
        fe:0a:29:23:81:23:a3:00:da:70:cc:92:5f:37:23:d0:1c:7b:
        35:5c:03:7a
-----BEGIN CERTIFICATE-----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-----END CERTIFICATE-----
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            10:00:00:00:00:00:00:00:00:00:00:00:00:00:00:00:00:00:00:23
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=ES, ST=Madrid, L=Madrid, O=IPS Certification Authority s.l. ipsCA, OU=ipsCA, CN=ipsCA Global CA Root/emailAddress=global01@ipsca.com
        Validity
            Not Before: Sep 20 09:29:57 2010 GMT
            Not After : Dec 24 09:29:57 2029 GMT
        Subject: C=ES, ST=MADRID, L=MADRID, O=ips Certification Authority, OU=Certificaciones, CN=ipsCA Level 1 CA/emailAddress=ipscalevel1@ipsca.com
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:9f:4d:b3:30:23:c1:3a:79:85:27:82:5d:45:ce:
                    5b:64:f8:2b:af:e1:5d:60:01:e2:94:0e:d5:01:86:
                    36:45:85:8c:0c:8e:76:e1:a0:a4:0d:93:54:17:98:
                    6a:ee:b2:84:0b:23:ea:bf:21:7c:c0:ee:49:c0:26:
                    79:19:54:d6:31:18:90:f7:fb:97:0b:e3:a8:c5:16:
                    40:de:2e:b8:8c:65:5b:32:d9:53:f7:c8:ff:06:fb:
                    89:66:54:f8:ea:44:42:0f:b7:4f:c7:b0:e9:4f:d1:
                    d0:bb:fa:96:8a:33:e3:46:b7:fa:64:bc:65:b1:1f:
                    b1:e0:e1:05:f8:0c:dd:4a:f5:8b:30:97:b4:48:0a:
                    94:fe:af:1d:63:f2:69:2c:6b:1b:44:6a:fd:3b:d9:
                    da:e7:0d:f0:c6:8a:b6:e0:19:01:60:a3:09:a2:b3:
                    20:40:1b:14:07:3a:8c:22:df:33:f4:76:c1:85:b8:
                    62:b8:49:b9:75:c1:96:ed:11:08:af:3c:3f:4e:59:
                    e8:40:dc:99:5a:13:47:47:e3:b2:84:0a:7e:81:30:
                    b7:1c:96:9f:2e:0d:1c:d0:e5:84:5e:5b:ad:3c:ce:
                    4a:6b:7d:68:45:22:f5:4d:5a:e7:9f:5c:19:00:48:
                    27:a5:78:78:82:d3:e2:ff:b1:e6:80:df:eb:2a:12:
                    5b:b1
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            Netscape Base Url: 
                https://level101.ipsca.com/
            Netscape Revocation Url: 
                estado/estado.asp?
            Netscape CA Revocation Url: 
                estadoCATEST/estado.asp?
            Netscape Renewal Url: 
                estado/renueva.asp?
            Netscape CA Policy Url: 
                estado/policy.asp
            Netscape Comment: 
                Certificado por ipsCA
            Netscape Cert Type: 
                SSL CA, S/MIME CA, Object Signing CA
            X509v3 Basic Constraints: 
                CA:TRUE
            X509v3 Subject Key Identifier: 
                7D:9E:6B:0E:FC:13:E1:C4:8B:A7:7F:61:AE:60:21:CF:CD:A0:D3:06
            X509v3 CRL Distribution Points: 
                URI:http://crlglobal01.ipsca.com/crl/crlglobal01.crl

            Authority Information Access: 
                OCSP - URI:http://ocsplevel101.ipsca.com/

            X509v3 Key Usage: 
                Certificate Sign, CRL Sign
            X509v3 Extended Key Usage: 
                TLS Web Server Authentication, TLS Web Client Authentication, Code Signing, E-mail Protection, Time Stamping, Microsoft Encrypted File System
    Signature Algorithm: sha1WithRSAEncryption
        47:ae:1e:75:7e:ec:c3:72:0c:78:85:c0:4c:b8:96:2b:ea:49:
        66:2f:ed:bb:90:93:10:6f:5a:e5:0b:0b:12:55:8f:88:6f:20:
        dd:d7:2a:39:0f:28:a8:a9:30:d2:a0:1f:e7:84:19:bc:28:c0:
        3d:cf:6e:a5:0c:42:7a:8b:2a:de:b2:a0:b9:55:d5:7a:4d:98:
        ce:c6:27:a7:9e:e9:c4:f0:26:4e:91:62:af:88:29:42:9b:5c:
        d0:c6:3e:96:a5:67:f6:65:b5:41:a7:f2:d9:f9:be:02:2b:dd:
        10:ec:ae:76:42:52:3a:7b:e0:ec:41:78:de:79:d9:f6:b0:a1:
        c1:db:81:b4:a7:e3:57:e8:0f:91:b5:18:95:ce:f5:7a:76:af:
        bd:29:f1:7d:f2:07:bc:c4:2d:35:d2:3c:57:be:55:8b:34:be:
        ae:c7:20:f6:80:f3:11:fe:42:91:f3:9e:96:7c:9c:7f:e2:55:
        88:37:2e:db:1f:ff:27:ff:82:6a:60:8b:9e:a4:42:96:f3:3f:
        bb:79:e8:04:4d:78:e4:f8:cd:b5:1f:18:64:5f:c9:1e:1a:bd:
        46:55:bc:05:9b:df:6f:a1:38:3e:90:47:ce:11:ae:f5:26:97:
        76:ec:dd:be:05:e4:a7:6a:6d:7d:30:0f:67:b0:62:de:70:94:
        7b:5d:d0:ef
-----BEGIN CERTIFICATE-----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-----END CERTIFICATE-----
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 513 (0x201)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=Starfield Technologies, Inc., OU=Starfield Class 2 Certification Authority
        Validity
            Not Before: Nov 16 01:15:40 2006 GMT
            Not After : Nov 16 01:15:40 2026 GMT
        Subject: C=US, ST=Arizona, L=Scottsdale, O=Starfield Technologies, Inc., OU=http://certificates.starfieldtech.com/repository, CN=Starfield Secure Certification Authority/serialNumber=10688435
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:e2:a7:5d:a3:ed:66:ef:6a:2f:2b:36:1f:dd:8d:
                    d3:05:02:a0:ca:0f:5e:19:ae:38:72:cf:16:da:54:
                    4a:cb:48:0a:f4:a1:73:11:65:85:43:c9:5b:17:0c:
                    9a:2b:be:0f:98:51:7a:60:29:0d:6c:de:e2:e8:e5:
                    15:4d:56:ff:90:d1:a7:a6:04:3f:60:07:4a:ca:6f:
                    a5:10:e7:b3:f8:5c:b1:bc:2b:2a:dc:01:79:f5:1d:
                    35:f5:7a:28:83:f2:93:73:82:89:ac:60:6d:cb:c2:
                    48:c2:1d:d4:06:44:17:3c:ac:01:47:ab:3e:70:84:
                    09:0b:b8:20:08:40:20:87:a1:63:1a:ca:3e:83:d2:
                    37:b3:98:8d:32:3f:37:bf:a1:b7:5b:5f:de:5c:33:
                    92:cf:3e:07:ce:b9:48:4b:e2:f0:55:50:2f:f8:70:
                    42:89:d1:93:96:8a:63:d9:66:0d:e6:58:6e:b9:6d:
                    90:bd:ca:dc:84:66:f2:39:8e:5b:a6:58:55:73:cb:
                    62:6c:1b:d7:20:16:3b:2c:59:f5:cb:c8:56:32:4a:
                    50:27:ba:55:d3:a8:01:cb:72:a9:74:8b:0c:ad:3a:
                    e5:15:b6:2a:df:65:f8:de:8a:f5:ef:84:3b:f9:e7:
                    54:65:0b:80:bd:47:45:a5:f0:44:d8:53:3b:be:80:
                    f1:2f
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Subject Key Identifier: 
                49:4B:52:27:D1:1B:BC:F2:A1:21:6A:62:7B:51:42:7A:8A:D7:D5:56
            X509v3 Authority Key Identifier: 
                keyid:BF:5F:B7:D1:CE:DD:1F:86:F4:5B:55:AC:DC:D7:10:C2:0E:A9:88:E7

            X509v3 Basic Constraints: critical
                CA:TRUE, pathlen:0
            Authority Information Access: 
                OCSP - URI:http://ocsp.starfieldtech.com

            X509v3 CRL Distribution Points: 
                URI:http://certificates.starfieldtech.com/repository/sfroot.crl

            X509v3 Certificate Policies: 
                Policy: 2.5.29.32.0
                  CPS: http://certificates.starfieldtech.com/repository

            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
    Signature Algorithm: sha1WithRSAEncryption
        86:52:ba:b3:1f:a6:5e:6b:90:a6:64:2a:fc:45:b2:ae:9f:3e:
        b3:62:af:db:1f:67:c4:bd:ca:a1:2f:c7:9c:0d:21:57:d0:f8:
        36:21:ce:3a:25:3e:78:76:b3:d9:dd:bc:de:fb:6c:84:5f:0c:
        a3:0d:12:eb:11:3b:71:5f:80:1e:f1:1f:6d:0e:5f:c1:ec:d4:
        a5:f7:65:bb:1f:4c:95:01:13:b2:6a:9c:0b:eb:1f:9d:b1:e7:
        ed:19:0d:bc:85:7c:f3:17:bd:59:63:ae:a7:1a:05:cd:47:e3:
        2d:96:62:51:32:0a:08:68:4b:22:77:5f:f7:45:dc:61:de:f4:
        cb:2b:22:29:44:25:d2:9f:0b:77:7a:a1:26:7c:4a:d7:0f:c2:
        d1:3c:ba:0e:a7:95:9a:5b:05:0a:10:f9:55:5f:c1:97:8b:74:
        cc:5e:28:69:13:7e:d0:0a:8d:9d:0f:60:54:7a:c4:8c:1b:35:
        0f:74:7a:70:b2:82:cf:1d:b5:e2:8a:db:2a:c6:b2:51:69:bf:
        12:17:92:60:17:aa:3d:5b:09:f8:87:65:1d:a7:a4:28:e5:22:
        02:03:82:44:9a:34:63:9e:fb:28:cf:e8:cd:2e:0e:52:20:ed:
        4a:cb:38:7c:9d:ae:6e:79:d7:95:2c:a8:91:f3:86:01:21:91:
        4b:b5:40:a4
SHA1 Fingerprint=7E:18:74:A9:8F:AA:5D:6D:2F:50:6A:89:20:FF:22:FB:D1:66:52:D9
-----BEGIN CERTIFICATE-----
MIIFBzCCA++gAwIBAgICAgEwDQYJKoZIhvcNAQEFBQAwaDELMAkGA1UEBhMCVVMx
JTAjBgNVBAoTHFN0YXJmaWVsZCBUZWNobm9sb2dpZXMsIEluYy4xMjAwBgNVBAsT
KVN0YXJmaWVsZCBDbGFzcyAyIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTA2
MTExNjAxMTU0MFoXDTI2MTExNjAxMTU0MFowgdwxCzAJBgNVBAYTAlVTMRAwDgYD
VQQIEwdBcml6b25hMRMwEQYDVQQHEwpTY290dHNkYWxlMSUwIwYDVQQKExxTdGFy
ZmllbGQgVGVjaG5vbG9naWVzLCBJbmMuMTkwNwYDVQQLEzBodHRwOi8vY2VydGlm
aWNhdGVzLnN0YXJmaWVsZHRlY2guY29tL3JlcG9zaXRvcnkxMTAvBgNVBAMTKFN0
YXJmaWVsZCBTZWN1cmUgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkxETAPBgNVBAUT
CDEwNjg4NDM1MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA4qddo+1m
72ovKzYf3Y3TBQKgyg9eGa44cs8W2lRKy0gK9KFzEWWFQ8lbFwyaK74PmFF6YCkN
bN7i6OUVTVb/kNGnpgQ/YAdKym+lEOez+FyxvCsq3AF59R019Xoog/KTc4KJrGBt
y8JIwh3UBkQXPKwBR6s+cIQJC7ggCEAgh6FjGso+g9I3s5iNMj83v6G3W1/eXDOS
zz4HzrlIS+LwVVAv+HBCidGTlopj2WYN5lhuuW2QvcrchGbyOY5bplhVc8tibBvX
IBY7LFn1y8hWMkpQJ7pV06gBy3KpdIsMrTrlFbYq32X43or174Q7+edUZQuAvUdF
pfBE2FM7voDxLwIDAQABo4IBRDCCAUAwHQYDVR0OBBYEFElLUifRG7zyoSFqYntR
QnqK19VWMB8GA1UdIwQYMBaAFL9ft9HO3R+G9FtVrNzXEMIOqYjnMBIGA1UdEwEB
/wQIMAYBAf8CAQAwOQYIKwYBBQUHAQEELTArMCkGCCsGAQUFBzABhh1odHRwOi8v
b2NzcC5zdGFyZmllbGR0ZWNoLmNvbTBMBgNVHR8ERTBDMEGgP6A9hjtodHRwOi8v
Y2VydGlmaWNhdGVzLnN0YXJmaWVsZHRlY2guY29tL3JlcG9zaXRvcnkvc2Zyb290
LmNybDBRBgNVHSAESjBIMEYGBFUdIAAwPjA8BggrBgEFBQcCARYwaHR0cDovL2Nl
cnRpZmljYXRlcy5zdGFyZmllbGR0ZWNoLmNvbS9yZXBvc2l0b3J5MA4GA1UdDwEB
/wQEAwIBBjANBgkqhkiG9w0BAQUFAAOCAQEAhlK6sx+mXmuQpmQq/EWyrp8+s2Kv
2x9nxL3KoS/HnA0hV9D4NiHOOiU+eHaz2d283vtshF8Mow0S6xE7cV+AHvEfbQ5f
wezUpfdlux9MlQETsmqcC+sfnbHn7RkNvIV88xe9WWOupxoFzUfjLZZiUTIKCGhL
Indf90XcYd70yysiKUQl0p8Ld3qhJnxK1w/C0Ty6DqeVmlsFChD5VV/Bl4t0zF4o
aRN+0AqNnQ9gVHrEjBs1D3R6cLKCzx214orbKsayUWm/EheSYBeqPVsJ+IdlHaek
KOUiAgOCRJo0Y577KM/ozS4OUiDtSss4fJ2ubnnXlSyokfOGASGRS7VApA==
-----END CERTIFICATE-----
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 0 (0x0)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, ST=Arizona, L=Scottsdale, O=Starfield Technologies, Inc., OU=http://certificates.starfieldtech.com/repository/, CN=Starfield Services Root Certificate Authority
        Validity
            Not Before: Jun  2 00:00:00 2008 GMT
            Not After : Dec 31 23:59:59 2029 GMT
        Subject: C=US, ST=Arizona, L=Scottsdale, O=Starfield Technologies, Inc., OU=http://certificates.starfieldtech.com/repository/, CN=Starfield Services Root Certificate Authority
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (2048 bit)
                Modulus:
                    00:f2:cc:56:2a:4d:e6:16:37:5a:97:ea:6d:35:38:
                    d1:10:9b:db:b8:dc:a9:04:09:95:33:2e:09:c5:00:
                    7b:1a:78:42:8f:c8:f4:05:8e:fe:d2:68:83:1e:4e:
                    99:cd:17:db:47:3e:50:f3:89:d2:e7:dc:98:fb:05:
                    f8:aa:d6:63:f4:54:4d:c1:71:03:b0:1f:1b:76:b3:
                    1a:34:30:73:f1:28:32:60:83:fd:b4:9c:d7:b6:d2:
                    22:37:7c:19:aa:3b:de:13:10:69:6e:5c:06:d3:6f:
                    a3:f2:66:5a:76:42:48:af:80:d1:54:59:3d:d4:b9:
                    d4:db:ed:b9:ab:39:99:f4:ee:62:ab:e1:78:72:7b:
                    d8:38:8d:40:b6:cc:dc:12:00:70:43:85:69:d8:18:
                    e3:ca:57:72:9f:b4:df:3f:fc:22:a8:42:52:f5:77:
                    5b:99:f0:56:2d:26:70:16:36:12:c2:27:9e:57:a6:
                    7c:d0:23:f1:79:dc:a3:93:58:28:38:3d:9f:ad:36:
                    43:ee:37:fb:f8:f9:43:ad:c8:56:f2:94:12:5e:42:
                    eb:73:b8:13:0d:cb:a6:d5:86:b9:aa:28:6a:54:03:
                    a1:3f:0f:29:eb:09:00:e8:3f:5e:a2:7f:17:3d:a1:
                    2b:f8:be:d0:75:1d:a4:84:e3:ab:17:65:06:52:00:
                    af:b1
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Subject Key Identifier: 
                B4:C6:7F:1A:43:CC:9B:75:5D:2F:C4:4B:F2:8B:98:10:E9:F1:51:10
            X509v3 Authority Key Identifier: 
                keyid:B4:C6:7F:1A:43:CC:9B:75:5D:2F:C4:4B:F2:8B:98:10:E9:F1:51:10

    Signature Algorithm: sha1WithRSAEncryption
        ac:80:bb:c4:25:05:0b:58:a4:e4:7e:29:7e:af:bc:3b:ec:2d:
        c0:44:2e:f9:91:e0:d2:3b:32:27:90:2d:f6:80:09:5c:c2:ab:
        65:24:da:38:10:46:c4:49:d2:fd:9a:ab:28:48:77:88:c6:e9:
        6f:d1:47:91:d5:35:4f:14:09:a8:5b:40:07:1d:7c:71:56:cb:
        89:42:d4:bf:61:c0:22:f7:2e:df:ab:f3:72:43:8b:40:e8:94:
        eb:b0:26:da:d1:13:d3:ab:d0:36:2d:2e:3a:95:b3:77:2e:15:
        39:18:0c:69:ba:aa:80:ed:f1:53:4e:33:9b:68:04:e2:a0:30:
        2e:d7:d1:5d:d4:a6:66:9d:84:e6:e7:bb:3c:89:bb:36:9d:fc:
        17:a9:3d:55:2b:8a:fb:9b:c4:4c:84:ff:df:d2:be:69:1b:74:
        b0:a8:f6:ea:b0:9c:b2:29:74:81:4c:68:3a:9a:7f:73:25:39:
        f5:13:e0:66:91:69:d4:57:4b:b7:ee:ad:45:e0:2c:c3:88:d3:
        be:94:49:89:1f:ff:70:d5:5b:6d:39:13:b0:1d:cb:98:e6:67:
        63:0d:63:f6:fb:c3:d7:61:72:83:88:3f:70:7e:53:c9:9e:89:
        54:d6:4f:7f:7d:71:b9:ae:f1:60:8b:77:60:ec:f8:bf:fa:6a:
        a3:9c:01:22
SHA1 Fingerprint=5D:00:38:60:F0:02:ED:82:9D:EA:A4:18:68:F7:88:18:6D:62:12:7F
-----BEGIN CERTIFICATE-----
MIIEfjCCA2agAwIBAgIBADANBgkqhkiG9w0BAQUFADCBzzELMAkGA1UEBhMCVVMx
EDAOBgNVBAgTB0FyaXpvbmExEzARBgNVBAcTClNjb3R0c2RhbGUxJTAjBgNVBAoT
HFN0YXJmaWVsZCBUZWNobm9sb2dpZXMsIEluYy4xOjA4BgNVBAsTMWh0dHA6Ly9j
ZXJ0aWZpY2F0ZXMuc3RhcmZpZWxkdGVjaC5jb20vcmVwb3NpdG9yeS8xNjA0BgNV
BAMTLVN0YXJmaWVsZCBTZXJ2aWNlcyBSb290IENlcnRpZmljYXRlIEF1dGhvcml0
eTAeFw0wODA2MDIwMDAwMDBaFw0yOTEyMzEyMzU5NTlaMIHPMQswCQYDVQQGEwJV
UzEQMA4GA1UECBMHQXJpem9uYTETMBEGA1UEBxMKU2NvdHRzZGFsZTElMCMGA1UE
ChMcU3RhcmZpZWxkIFRlY2hub2xvZ2llcywgSW5jLjE6MDgGA1UECxMxaHR0cDov
L2NlcnRpZmljYXRlcy5zdGFyZmllbGR0ZWNoLmNvbS9yZXBvc2l0b3J5LzE2MDQG
A1UEAxMtU3RhcmZpZWxkIFNlcnZpY2VzIFJvb3QgQ2VydGlmaWNhdGUgQXV0aG9y
aXR5MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA8sxWKk3mFjdal+pt
NTjREJvbuNypBAmVMy4JxQB7GnhCj8j0BY7+0miDHk6ZzRfbRz5Q84nS59yY+wX4
qtZj9FRNwXEDsB8bdrMaNDBz8SgyYIP9tJzXttIiN3wZqjveExBpblwG02+j8mZa
dkJIr4DRVFk91LnU2+25qzmZ9O5iq+F4cnvYOI1AtszcEgBwQ4Vp2Bjjyldyn7Tf
P/wiqEJS9XdbmfBWLSZwFjYSwieeV6Z80CPxedyjk1goOD2frTZD7jf7+PlDrchW
8pQSXkLrc7gTDcum1Ya5qihqVAOhPw8p6wkA6D9eon8XPaEr+L7QdR2khOOrF2UG
UgCvsQIDAQABo2MwYTAPBgNVHRMBAf8EBTADAQH/MA4GA1UdDwEB/wQEAwIBBjAd
BgNVHQ4EFgQUtMZ/GkPMm3VdL8RL8ouYEOnxURAwHwYDVR0jBBgwFoAUtMZ/GkPM
m3VdL8RL8ouYEOnxURAwDQYJKoZIhvcNAQEFBQADggEBAKyAu8QlBQtYpOR+KX6v
vDvsLcBELvmR4NI7MieQLfaACVzCq2Uk2jgQRsRJ0v2aqyhId4jG6W/RR5HVNU8U
CahbQAcdfHFWy4lC1L9hwCL3Lt+r83JDi0DolOuwJtrRE9Or0DYtLjqVs3cuFTkY
DGm6qoDt8VNOM5toBOKgMC7X0V3UpmadhObnuzyJuzad/BepPVUrivubxEyE/9/S
vmkbdLCo9uqwnLIpdIFMaDqaf3MlOfUT4GaRadRXS7furUXgLMOI076USYkf/3DV
W205E7Ady5jmZ2MNY/b7w9dhcoOIP3B+U8meiVTWT399cbmu8WCLd2Ds+L/6aqOc
ASI=
-----END CERTIFICATE-----
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 260 (0x104)
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: L=ValiCert Validation Network, O=ValiCert, Inc., OU=ValiCert Class 2 Policy Validation Authority, CN=http://www.valicert.com//emailAddress=info@valicert.com
        Validity
            Not Before: Jan 14 21:05:21 2004 GMT
            Not After : Jan  9 21:05:21 2024 GMT
        Subject: C=US, ST=Arizona, L=Scottsdale, O=Starfield Technologies, Inc., OU=http://www.starfieldtech.com/repository, CN=Starfield Secure Certification Authority/emailAddress=practices@starfieldtech.com
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (1024 bit)
                Modulus:
                    00:db:11:43:6b:dc:d1:69:78:59:49:e8:6e:74:14:
                    08:74:11:6c:7e:b7:2a:a8:22:d8:42:3c:7a:cf:9f:
                    50:b2:46:ae:a6:67:1a:23:22:be:0f:b3:34:fb:ac:
                    ac:90:aa:5b:28:c2:70:f6:b6:8a:80:2a:e0:9b:9c:
                    52:e0:91:a8:72:a0:16:e1:c4:4e:7d:11:09:b3:9e:
                    b9:d4:f3:b2:50:c4:6d:48:08:bd:bc:2a:97:0c:6d:
                    a3:8a:6a:3c:9a:cf:4a:34:dc:1e:de:ea:5a:26:c0:
                    a1:a2:82:a9:4a:fb:86:22:12:90:3a:b2:82:d4:92:
                    91:9f:a9:45:9f:c3:a4:db:fb
                Exponent: 3 (0x3)
        X509v3 extensions:
            X509v3 Basic Constraints: 
                CA:TRUE
            X509v3 Key Usage: 
                Certificate Sign, CRL Sign
            X509v3 CRL Distribution Points: 

                Full Name:
                  URI:http://certificates.starfieldtech.com/repository/root.crl

            X509v3 Certificate Policies: 
                Policy: 2.16.840.1.113733.1.7.23.3
                  CPS: http://www.starfieldtech.com/repository

            Authority Information Access: 
                OCSP - URI:http://ocsp.starfieldtech.com

            X509v3 Subject Key Identifier: 
                AC:55:DE:B7:EA:13:EB:FC:98:68:E2:53:60:1E:F1:25:3E:8C:EE:E7
            X509v3 Authority Key Identifier: 
                0.
    Signature Algorithm: sha1WithRSAEncryption
        7e:1c:98:be:ad:03:8d:25:85:ee:7c:90:88:22:2b:fe:27:f4:
        42:b2:ec:7f:b5:fc:72:68:05:a4:7d:91:ef:28:d1:7d:20:39:
        3b:79:08:37:68:18:52:d5:8f:03:d2:89:4f:1e:11:d1:e9:a5:
        74:4b:fc:5f:67:65:84:71:84:78:59:b7:d6:c9:d7:d7:93:35:
        e6:13:ab:94:3c:8e:93:40:89:8c:c0:d7:f2:e7:07:52:d1:70:
        8f:98:8c:eb:a0:6d:d1:36:53:90:a0:8f:16:30:1e:de:c3:bf:
        7f:46:a5:95:2a:f9:c8:de:3b:db:77:f4:f2:32:b1:33:61:a2:
        30:35
SHA1 Fingerprint=44:6A:2A:00:C1:BB:A3:6D:59:D1:C1:78:A6:7A:27:C5:0E:6D:03:DF
-----BEGIN CERTIFICATE-----
MIIEQTCCA6qgAwIBAgICAQQwDQYJKoZIhvcNAQEFBQAwgbsxJDAiBgNVBAcTG1Zh
bGlDZXJ0IFZhbGlkYXRpb24gTmV0d29yazEXMBUGA1UEChMOVmFsaUNlcnQsIElu
Yy4xNTAzBgNVBAsTLFZhbGlDZXJ0IENsYXNzIDIgUG9saWN5IFZhbGlkYXRpb24g
QXV0aG9yaXR5MSEwHwYDVQQDExhodHRwOi8vd3d3LnZhbGljZXJ0LmNvbS8xIDAe
BgkqhkiG9w0BCQEWEWluZm9AdmFsaWNlcnQuY29tMB4XDTA0MDExNDIxMDUyMVoX
DTI0MDEwOTIxMDUyMVowgewxCzAJBgNVBAYTAlVTMRAwDgYDVQQIEwdBcml6b25h
MRMwEQYDVQQHEwpTY290dHNkYWxlMSUwIwYDVQQKExxTdGFyZmllbGQgVGVjaG5v
bG9naWVzLCBJbmMuMTAwLgYDVQQLEydodHRwOi8vd3d3LnN0YXJmaWVsZHRlY2gu
Y29tL3JlcG9zaXRvcnkxMTAvBgNVBAMTKFN0YXJmaWVsZCBTZWN1cmUgQ2VydGlm
aWNhdGlvbiBBdXRob3JpdHkxKjAoBgkqhkiG9w0BCQEWG3ByYWN0aWNlc0BzdGFy
ZmllbGR0ZWNoLmNvbTCBnTANBgkqhkiG9w0BAQEFAAOBiwAwgYcCgYEA2xFDa9zR
aXhZSehudBQIdBFsfrcqqCLYQjx6z59QskaupmcaIyK+D7M0+6yskKpbKMJw9raK
gCrgm5xS4JGocqAW4cROfREJs5651POyUMRtSAi9vCqXDG2jimo8ms9KNNwe3upa
JsChooKpSvuGIhKQOrKC1JKRn6lFn8Ok2/sCAQOjggEhMIIBHTAMBgNVHRMEBTAD
AQH/MAsGA1UdDwQEAwIBBjBKBgNVHR8EQzBBMD+gPaA7hjlodHRwOi8vY2VydGlm
aWNhdGVzLnN0YXJmaWVsZHRlY2guY29tL3JlcG9zaXRvcnkvcm9vdC5jcmwwTwYD
VR0gBEgwRjBEBgtghkgBhvhFAQcXAzA1MDMGCCsGAQUFBwIBFidodHRwOi8vd3d3
LnN0YXJmaWVsZHRlY2guY29tL3JlcG9zaXRvcnkwOQYIKwYBBQUHAQEELTArMCkG
CCsGAQUFBzABhh1odHRwOi8vb2NzcC5zdGFyZmllbGR0ZWNoLmNvbTAdBgNVHQ4E
FgQUrFXet+oT6/yYaOJTYB7xJT6M7ucwCQYDVR0jBAIwADANBgkqhkiG9w0BAQUF
AAOBgQB+HJi+rQONJYXufJCIIiv+J/RCsux/tfxyaAWkfZHvKNF9IDk7eQg3aBhS
1Y8D0olPHhHR6aV0S/xfZ2WEcYR4WbfWydfXkzXmE6uUPI6TQImMwNfy5wdS0XCP
mIzroG3RNlOQoI8WMB7ew79/RqWVKvnI3jvbd/TyMrEzYaIwNQ==
-----END CERTIFICATE-----
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            04:00:00:00:00:01:2f:4e:e1:3f:11
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=BE, O=GlobalSign nv-sa, OU=Root CA, CN=GlobalSign Root CA
        Validity
            Not Before: Apr 13 10:00:00 2011 GMT
            Not After : Apr 13 10:00:00 2022 GMT
        Subject: C=BE, O=GlobalSign nv-sa, CN=GlobalSign Domain Validation CA - G2
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (2048 bit)
                Modulus:
                    00:b1:a3:cd:c0:df:33:40:26:eb:de:5a:d7:94:66:
                    d4:01:63:cc:33:44:89:e0:e2:b8:c2:47:0d:8f:ad:
                    69:86:1c:a8:73:42:0b:f1:72:fb:2d:ac:b5:11:72:
                    83:22:f6:56:e7:2e:c5:67:71:9d:00:1c:32:bc:e3:
                    ed:2e:08:45:a9:e6:fa:dd:c8:8c:83:05:c1:6f:4b:
                    d0:26:4a:0b:f6:1b:45:c0:4d:7e:93:bc:0d:27:84:
                    ed:30:a3:e9:c6:26:26:dd:2d:1f:d8:8b:c3:ce:19:
                    d0:5b:fc:08:9f:e4:d8:e2:35:e4:a0:68:a6:f6:0d:
                    a3:74:60:42:b2:97:82:24:8e:41:a4:f2:2e:5e:b6:
                    8e:a7:6e:d9:6c:7f:0d:3b:24:35:6a:d0:ab:5b:6a:
                    f7:97:02:00:3f:51:a6:a7:6e:73:ca:77:0d:76:7c:
                    9b:b6:30:1a:1a:9c:f7:1f:28:7b:0e:8b:47:1f:e7:
                    7f:05:8c:c6:c9:c8:bb:cf:e9:dc:7a:41:2e:a1:86:
                    da:d4:39:b2:e2:13:40:a6:a8:3a:fa:0f:53:1e:4f:
                    ec:6e:98:09:1b:ca:9a:77:b3:55:85:85:e9:2e:16:
                    b5:9d:5e:54:f1:4a:7a:6c:39:ba:6e:17:06:34:b3:
                    b2:42:e1:f7:f3:9c:9a:0b:11:44:de:6a:78:8e:b1:
                    13:4f
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE, pathlen:0
            X509v3 Subject Key Identifier: 
                96:AD:FA:B0:5B:B9:83:64:2A:76:C2:1C:8A:69:DA:42:DC:FE:FD:28
            X509v3 Certificate Policies: 
                Policy: X509v3 Any Policy
                  CPS: https://www.globalsign.com/repository/

            X509v3 CRL Distribution Points: 

                Full Name:
                  URI:http://crl.globalsign.net/root.crl

            Authority Information Access: 
                OCSP - URI:http://ocsp.globalsign.com/rootr1

            X509v3 Extended Key Usage: 
                TLS Web Server Authentication, TLS Web Client Authentication, Microsoft Server Gated Crypto
            X509v3 Authority Key Identifier: 
                keyid:60:7B:66:1A:45:0D:97:CA:89:50:2F:7D:04:CD:34:A8:FF:FC:FD:4B

    Signature Algorithm: sha1WithRSAEncryption
        7e:9a:13:39:71:69:a0:fc:8c:35:ac:af:b4:d6:de:64:ea:33:
        6f:95:53:92:71:ad:4c:c0:fb:d0:6b:ba:80:0e:c2:0a:e6:37:
        fa:d2:25:a3:22:f7:89:9f:52:12:43:2f:bb:c4:fc:6c:ce:e4:
        aa:9d:f6:9d:57:7b:cc:2a:ac:75:49:1b:54:66:cf:a7:e9:b9:
        b0:c2:7c:70:23:fb:9c:97:00:f2:25:a4:d9:a1:0a:5d:85:06:
        1d:1a:87:f5:2d:54:c5:64:21:8e:ac:aa:ec:19:3e:9b:ff:c0:
        67:a7:2e:00:e3:f1:81:40:00:5b:83:e2:a8:a7:ef:35:50:83:
        c0:f4:9b:88:2a:89:a9:a9:9c:2f:82:b9:18:9e:fa:eb:47:24:
        6e:13:ee:b2:8c:f0:42:37:5e:e6:8f:91:bc:a5:5f:51:2b:ae:
        bb:8c:76:31:4e:53:11:79:ec:11:4e:38:73:e5:1a:66:70:f4:
        82:f7:7b:10:55:f8:bb:a5:c3:1d:e5:d3:f6:bc:fa:28:b6:31:
        10:d5:fe:91:23:a4:21:3f:ba:4c:91:8f:87:c7:82:ab:38:c2:
        01:73:89:48:1a:f9:0c:91:b9:95:fb:6d:21:5f:03:c8:bf:7b:
        74:ef:7b:71:79:b5:3e:73:23:d1:5a:dc:a6:0c:e1:2d:64:65:
        91:be:c2:b9
SHA1 Fingerprint=04:81:C8:CA:31:BE:0F:A9:40:C7:E0:CC:D5:72:37:4E:AD:F5:2B:73
-----BEGIN CERTIFICATE-----
MIIEhTCCA22gAwIBAgILBAAAAAABL07hPxEwDQYJKoZIhvcNAQEFBQAwVzELMAkG
A1UEBhMCQkUxGTAXBgNVBAoTEEdsb2JhbFNpZ24gbnYtc2ExEDAOBgNVBAsTB1Jv
b3QgQ0ExGzAZBgNVBAMTEkdsb2JhbFNpZ24gUm9vdCBDQTAeFw0xMTA0MTMxMDAw
MDBaFw0yMjA0MTMxMDAwMDBaMFcxCzAJBgNVBAYTAkJFMRkwFwYDVQQKExBHbG9i
YWxTaWduIG52LXNhMS0wKwYDVQQDEyRHbG9iYWxTaWduIERvbWFpbiBWYWxpZGF0
aW9uIENBIC0gRzIwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCxo83A
3zNAJuveWteUZtQBY8wzRIng4rjCRw2PrWmGHKhzQgvxcvstrLURcoMi9lbnLsVn
cZ0AHDK84+0uCEWp5vrdyIyDBcFvS9AmSgv2G0XATX6TvA0nhO0wo+nGJibdLR/Y
i8POGdBb/Aif5NjiNeSgaKb2DaN0YEKyl4IkjkGk8i5eto6nbtlsfw07JDVq0Ktb
aveXAgA/UaanbnPKdw12fJu2MBoanPcfKHsOi0cf538FjMbJyLvP6dx6QS6hhtrU
ObLiE0CmqDr6D1MeT+xumAkbypp3s1WFhekuFrWdXlTxSnpsObpuFwY0s7JC4ffz
nJoLEUTeaniOsRNPAgMBAAGjggFQMIIBTDAOBgNVHQ8BAf8EBAMCAQYwEgYDVR0T
AQH/BAgwBgEB/wIBADAdBgNVHQ4EFgQUlq36sFu5g2QqdsIcimnaQtz+/SgwRwYD
VR0gBEAwPjA8BgRVHSAAMDQwMgYIKwYBBQUHAgEWJmh0dHBzOi8vd3d3Lmdsb2Jh
bHNpZ24uY29tL3JlcG9zaXRvcnkvMDMGA1UdHwQsMCowKKAmoCSGImh0dHA6Ly9j
cmwuZ2xvYmFsc2lnbi5uZXQvcm9vdC5jcmwwPQYIKwYBBQUHAQEEMTAvMC0GCCsG
AQUFBzABhiFodHRwOi8vb2NzcC5nbG9iYWxzaWduLmNvbS9yb290cjEwKQYDVR0l
BCIwIAYIKwYBBQUHAwEGCCsGAQUFBwMCBgorBgEEAYI3CgMDMB8GA1UdIwQYMBaA
FGB7ZhpFDZfKiVAvfQTNNKj//P1LMA0GCSqGSIb3DQEBBQUAA4IBAQB+mhM5cWmg
/Iw1rK+01t5k6jNvlVOSca1MwPvQa7qADsIK5jf60iWjIveJn1ISQy+7xPxszuSq
nfadV3vMKqx1SRtUZs+n6bmwwnxwI/uclwDyJaTZoQpdhQYdGof1LVTFZCGOrKrs
GT6b/8Bnpy4A4/GBQABbg+Kop+81UIPA9JuIKompqZwvgrkYnvrrRyRuE+6yjPBC
N17mj5G8pV9RK667jHYxTlMReewRTjhz5RpmcPSC93sQVfi7pcMd5dP2vPootjEQ
1f6RI6QhP7pMkY+Hx4KrOMIBc4lIGvkMkbmV+20hXwPIv3t073txebU+cyPRWtym
DOEtZGWRvsK5
-----END CERTIFICATE-----
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            04:00:00:00:00:01:2f:4e:e1:42:f9
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=BE, O=GlobalSign nv-sa, OU=Root CA, CN=GlobalSign Root CA
        Validity
            Not Before: Apr 13 10:00:00 2011 GMT
            Not After : Apr 13 10:00:00 2022 GMT
        Subject: C=BE, O=GlobalSign nv-sa, CN=GlobalSign Organization Validation CA - G2
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (2048 bit)
                Modulus:
                    00:dd:35:1d:f2:20:54:26:1a:d0:ef:a5:6f:81:76:
                    59:70:dc:e7:f4:d4:03:24:1f:24:0e:9d:22:9f:d4:
                    27:32:7a:2b:7c:ee:8b:e3:61:62:38:17:af:b4:4b:
                    7a:9f:67:21:1c:2d:95:54:ba:79:ba:b6:c4:f2:0d:
                    21:74:17:67:74:e2:b1:64:08:99:60:78:fb:67:c2:
                    4b:f7:27:8d:6f:36:76:cf:31:8c:e5:f1:06:d7:dc:
                    57:0e:5b:ac:ee:ce:2d:ab:aa:a9:70:2f:02:86:c8:
                    b1:d0:08:07:95:ea:2a:ec:d1:9e:e4:36:5c:3b:a6:
                    36:b5:43:8b:ab:f7:8e:3e:00:1b:ff:85:59:6b:62:
                    01:8d:82:e8:4a:ba:38:b3:e0:c3:f4:6d:19:a7:ea:
                    05:dd:84:67:c2:66:c7:24:02:73:5a:b5:ee:a4:19:
                    d9:fc:00:ce:b6:a4:8d:df:7e:bd:5f:b2:3a:9d:84:
                    31:4f:c8:63:0c:e4:d8:0d:52:a3:7e:01:1b:d4:67:
                    a5:18:28:eb:01:a7:82:3c:d9:8e:1d:e5:47:0d:ba:
                    8b:59:14:a3:1f:1f:4b:ea:e2:27:46:86:ce:9d:39:
                    c4:66:41:a7:e2:15:23:6b:56:47:c1:ed:c5:53:e4:
                    d4:80:1f:6b:fa:80:46:98:b2:09:a6:0f:95:be:66:
                    88:93
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE, pathlen:0
            X509v3 Subject Key Identifier: 
                5D:46:B2:8D:C4:4B:74:1C:BB:ED:F5:73:B6:3A:B7:38:8F:75:9E:7E
            X509v3 Certificate Policies: 
                Policy: X509v3 Any Policy
                  CPS: https://www.globalsign.com/repository/

            X509v3 CRL Distribution Points: 

                Full Name:
                  URI:http://crl.globalsign.net/root.crl

            Authority Information Access: 
                OCSP - URI:http://ocsp.globalsign.com/rootr1

            X509v3 Extended Key Usage: 
                TLS Web Server Authentication, TLS Web Client Authentication, Microsoft Server Gated Crypto
            X509v3 Authority Key Identifier: 
                keyid:60:7B:66:1A:45:0D:97:CA:89:50:2F:7D:04:CD:34:A8:FF:FC:FD:4B

    Signature Algorithm: sha1WithRSAEncryption
        73:7a:ec:01:2c:17:22:91:9a:ca:b1:67:18:a2:ba:c8:05:89:
        92:24:de:1f:b8:ab:44:9f:f7:40:55:65:f2:e0:f4:2e:c7:de:
        b0:3f:99:15:1f:95:70:82:e9:9b:4a:64:24:20:16:f0:76:17:
        d2:1b:fe:ac:fa:06:b4:77:cf:98:d8:2a:ec:57:15:d8:5e:4e:
        dd:8b:96:e1:53:33:19:91:d5:84:6e:25:ef:0f:cb:ad:bf:db:
        4b:6b:56:cc:b5:d4:40:3e:26:5e:b6:59:f4:c5:90:c9:09:c4:
        84:df:bc:26:7d:82:e9:eb:f4:5b:fc:c8:15:de:09:18:45:86:
        b3:8b:4d:c7:6b:35:27:9b:60:f6:a4:5a:2a:58:49:b1:d8:35:
        43:c6:32:bb:5e:3b:c4:4a:21:c1:a0:3b:5e:c1:23:a9:ce:db:
        d5:ba:fe:5d:6d:fd:00:7e:fa:f1:94:37:61:b9:00:39:66:96:
        a9:9c:b4:1e:11:ef:55:d8:b4:d8:b0:c4:a5:ae:32:0a:2f:f8:
        2d:f4:a2:a7:ff:36:d3:5e:63:8b:4e:12:f7:b5:28:80:75:ee:
        94:2f:70:a0:56:77:39:aa:39:97:17:fc:00:f3:cf:66:e7:a2:
        71:92:ab:05:9b:73:2e:7a:e7:e7:21:59:09:8d:30:a1:ac:5c:
        ca:19:7a:f8
SHA1 Fingerprint=1D:31:4E:8E:56:D3:63:3B:48:F6:75:6D:4C:E5:79:C6:70:33:38:BD
-----BEGIN CERTIFICATE-----
MIIEizCCA3OgAwIBAgILBAAAAAABL07hQvkwDQYJKoZIhvcNAQEFBQAwVzELMAkG
A1UEBhMCQkUxGTAXBgNVBAoTEEdsb2JhbFNpZ24gbnYtc2ExEDAOBgNVBAsTB1Jv
b3QgQ0ExGzAZBgNVBAMTEkdsb2JhbFNpZ24gUm9vdCBDQTAeFw0xMTA0MTMxMDAw
MDBaFw0yMjA0MTMxMDAwMDBaMF0xCzAJBgNVBAYTAkJFMRkwFwYDVQQKExBHbG9i
YWxTaWduIG52LXNhMTMwMQYDVQQDEypHbG9iYWxTaWduIE9yZ2FuaXphdGlvbiBW
YWxpZGF0aW9uIENBIC0gRzIwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIB
AQDdNR3yIFQmGtDvpW+Bdllw3Of01AMkHyQOnSKf1Ccyeit87ovjYWI4F6+0S3qf
ZyEcLZVUunm6tsTyDSF0F2d04rFkCJlgePtnwkv3J41vNnbPMYzl8QbX3FcOW6zu
zi2rqqlwLwKGyLHQCAeV6irs0Z7kNlw7pja1Q4ur944+ABv/hVlrYgGNguhKujiz
4MP0bRmn6gXdhGfCZsckAnNate6kGdn8AM62pI3ffr1fsjqdhDFPyGMM5NgNUqN+
ARvUZ6UYKOsBp4I82Y4d5UcNuotZFKMfH0vq4idGhs6dOcRmQafiFSNrVkfB7cVT
5NSAH2v6gEaYsgmmD5W+ZoiTAgMBAAGjggFQMIIBTDAOBgNVHQ8BAf8EBAMCAQYw
EgYDVR0TAQH/BAgwBgEB/wIBADAdBgNVHQ4EFgQUXUayjcRLdBy77fVztjq3OI91
nn4wRwYDVR0gBEAwPjA8BgRVHSAAMDQwMgYIKwYBBQUHAgEWJmh0dHBzOi8vd3d3
Lmdsb2JhbHNpZ24uY29tL3JlcG9zaXRvcnkvMDMGA1UdHwQsMCowKKAmoCSGImh0
dHA6Ly9jcmwuZ2xvYmFsc2lnbi5uZXQvcm9vdC5jcmwwPQYIKwYBBQUHAQEEMTAv
MC0GCCsGAQUFBzABhiFodHRwOi8vb2NzcC5nbG9iYWxzaWduLmNvbS9yb290cjEw
KQYDVR0lBCIwIAYIKwYBBQUHAwEGCCsGAQUFBwMCBgorBgEEAYI3CgMDMB8GA1Ud
IwQYMBaAFGB7ZhpFDZfKiVAvfQTNNKj//P1LMA0GCSqGSIb3DQEBBQUAA4IBAQBz
euwBLBcikZrKsWcYorrIBYmSJN4fuKtEn/dAVWXy4PQux96wP5kVH5VwgumbSmQk
IBbwdhfSG/6s+ga0d8+Y2CrsVxXYXk7di5bhUzMZkdWEbiXvD8utv9tLa1bMtdRA
PiZetln0xZDJCcSE37wmfYLp6/Rb/MgV3gkYRYazi03HazUnm2D2pFoqWEmx2DVD
xjK7XjvESiHBoDtewSOpztvVuv5dbf0AfvrxlDdhuQA5ZpapnLQeEe9V2LTYsMSl
rjIKL/gt9KKn/zbTXmOLThL3tSiAde6UL3CgVnc5qjmXF/wA889m56JxkqsFm3Mu
eufnIVkJjTChrFzKGXr4
-----END CERTIFICATE-----
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            04:00:00:00:00:01:2f:4e:e1:5d:d4
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: OU=GlobalSign Root CA - R2, O=GlobalSign, CN=GlobalSign
        Validity
            Not Before: Apr 13 10:00:00 2011 GMT
            Not After : Apr 13 10:00:00 2022 GMT
        Subject: C=BE, O=GlobalSign nv-sa, CN=GlobalSign Extended Validation CA - G2
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (2048 bit)
                Modulus:
                    00:cd:a1:46:cc:52:9a:b8:a5:b4:7f:58:d9:cd:d8:
                    4b:a0:72:0c:97:5b:a6:88:20:c3:b9:3d:46:dc:d0:
                    5c:52:30:f6:fa:59:4f:85:5f:b0:db:88:b4:a9:5f:
                    2b:23:48:ac:ab:f5:92:78:14:b6:32:0f:fb:5c:6a:
                    85:5b:00:90:e0:bb:65:f5:5a:f9:4f:67:7e:c7:6c:
                    29:ec:93:c0:2b:ca:c4:5e:d8:b0:db:d6:be:3f:9b:
                    0b:c0:8f:a9:5d:ae:f7:00:02:a4:fc:ba:66:11:38:
                    77:fe:23:20:25:55:10:c5:bd:82:b9:4c:b1:68:c6:
                    e2:70:7b:83:5c:13:67:c1:a1:f3:7c:0b:a8:99:9a:
                    d0:e2:9b:25:31:c8:2b:8d:40:f6:52:63:b1:a0:ad:
                    5a:2e:f5:79:36:6d:35:2c:0e:dd:05:e4:d0:e2:07:
                    48:b7:28:5e:2b:d5:58:d5:6c:d0:0c:a1:01:46:01:
                    5a:8f:c6:af:64:c7:55:01:5d:e1:d1:c6:6c:50:25:
                    a0:05:ad:00:ab:0c:8d:65:6b:dd:eb:c2:72:54:c9:
                    0f:3c:00:17:87:22:ef:db:b9:86:78:16:51:ae:77:
                    d9:a6:28:4d:f3:58:8d:83:67:b9:34:25:9b:1c:51:
                    80:51:f3:83:92:6a:a3:ae:47:9a:d6:e4:8b:1b:c0:
                    ed:b1
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE, pathlen:0
            X509v3 Subject Key Identifier: 
                B0:B0:4A:FD:1C:75:28:F8:1C:61:AA:13:F6:FA:C1:90:3D:6B:16:A3
            X509v3 Certificate Policies: 
                Policy: X509v3 Any Policy
                  CPS: https://www.globalsign.com/repository/

            X509v3 CRL Distribution Points: 

                Full Name:
                  URI:http://crl.globalsign.net/root-r2.crl

            Authority Information Access: 
                OCSP - URI:http://ocsp.globalsign.com/ExtendedSSLCA

            X509v3 Extended Key Usage: 
                TLS Web Server Authentication, TLS Web Client Authentication, Microsoft Server Gated Crypto
            X509v3 Authority Key Identifier: 
                keyid:9B:E2:07:57:67:1C:1E:C0:6A:06:DE:59:B4:9A:2D:DF:DC:19:86:2E

    Signature Algorithm: sha1WithRSAEncryption
        2f:49:b6:f2:b6:5a:a4:95:ab:9e:5a:e9:2b:82:9b:cc:90:6b:
        7c:74:45:20:e7:5e:d8:c7:23:ee:28:35:b1:35:65:2a:a5:51:
        e0:55:3f:f6:83:67:b4:e4:36:29:b0:da:ec:97:95:a9:8a:05:
        a3:45:fe:23:2e:52:88:b4:1f:10:80:ad:d2:8b:9f:a3:5f:a8:
        c5:eb:73:de:79:88:41:98:33:ee:a7:60:18:b1:46:c9:40:10:
        07:9c:8f:0a:52:c9:13:1a:06:6e:a0:9b:2d:3a:f6:ae:4f:e7:
        a3:51:35:2a:5b:18:05:12:e5:51:dc:b6:36:62:f3:e1:a4:0f:
        fb:e4:cf:c3:94:bf:11:ab:a1:59:31:01:f0:cc:53:ec:8f:63:
        d7:6c:96:d3:48:2a:8a:23:ed:45:56:a8:66:41:ea:01:b9:47:
        ee:a1:47:0c:14:f1:23:e1:20:73:ca:7d:50:7c:64:38:57:a3:
        8f:4a:9c:9b:e9:6d:45:cf:44:6b:4d:60:20:40:71:25:b5:46:
        aa:6c:08:7e:df:c8:fa:c8:56:2a:92:cb:83:b8:79:09:97:2d:
        5e:a1:01:ce:06:ed:b4:97:c9:04:dc:41:ef:e0:4f:36:4d:e4:
        40:73:46:ec:11:12:7c:88:5b:34:26:25:4d:ea:dc:18:be:c5:
        1b:cd:64:c0
SHA1 Fingerprint=19:64:23:71:53:B8:93:1C:2D:DB:E8:55:9C:5F:F8:D9:76:22:83:11
-----BEGIN CERTIFICATE-----
MIIEhjCCA26gAwIBAgILBAAAAAABL07hXdQwDQYJKoZIhvcNAQEFBQAwTDEgMB4G
A1UECxMXR2xvYmFsU2lnbiBSb290IENBIC0gUjIxEzARBgNVBAoTCkdsb2JhbFNp
Z24xEzARBgNVBAMTCkdsb2JhbFNpZ24wHhcNMTEwNDEzMTAwMDAwWhcNMjIwNDEz
MTAwMDAwWjBZMQswCQYDVQQGEwJCRTEZMBcGA1UEChMQR2xvYmFsU2lnbiBudi1z
YTEvMC0GA1UEAxMmR2xvYmFsU2lnbiBFeHRlbmRlZCBWYWxpZGF0aW9uIENBIC0g
RzIwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDNoUbMUpq4pbR/WNnN
2EugcgyXW6aIIMO5PUbc0FxSMPb6WU+FX7DbiLSpXysjSKyr9ZJ4FLYyD/tcaoVb
AJDgu2X1WvlPZ37HbCnsk8ArysRe2LDb1r4/mwvAj6ldrvcAAqT8umYROHf+IyAl
VRDFvYK5TLFoxuJwe4NcE2fBofN8C6iZmtDimyUxyCuNQPZSY7GgrVou9Xk2bTUs
Dt0F5NDiB0i3KF4r1VjVbNAMoQFGAVqPxq9kx1UBXeHRxmxQJaAFrQCrDI1la93r
wnJUyQ88ABeHIu/buYZ4FlGud9mmKE3zWI2DZ7k0JZscUYBR84OSaqOuR5rW5Isb
wO2xAgMBAAGjggFaMIIBVjAOBgNVHQ8BAf8EBAMCAQYwEgYDVR0TAQH/BAgwBgEB
/wIBADAdBgNVHQ4EFgQUsLBK/Rx1KPgcYaoT9vrBkD1rFqMwRwYDVR0gBEAwPjA8
BgRVHSAAMDQwMgYIKwYBBQUHAgEWJmh0dHBzOi8vd3d3Lmdsb2JhbHNpZ24uY29t
L3JlcG9zaXRvcnkvMDYGA1UdHwQvMC0wK6ApoCeGJWh0dHA6Ly9jcmwuZ2xvYmFs
c2lnbi5uZXQvcm9vdC1yMi5jcmwwRAYIKwYBBQUHAQEEODA2MDQGCCsGAQUFBzAB
hihodHRwOi8vb2NzcC5nbG9iYWxzaWduLmNvbS9FeHRlbmRlZFNTTENBMCkGA1Ud
JQQiMCAGCCsGAQUFBwMBBggrBgEFBQcDAgYKKwYBBAGCNwoDAzAfBgNVHSMEGDAW
gBSb4gdXZxwewGoG3lm0mi3f3BmGLjANBgkqhkiG9w0BAQUFAAOCAQEAL0m28rZa
pJWrnlrpK4KbzJBrfHRFIOde2Mcj7ig1sTVlKqVR4FU/9oNntOQ2KbDa7JeVqYoF
o0X+Iy5SiLQfEICt0oufo1+oxetz3nmIQZgz7qdgGLFGyUAQB5yPClLJExoGbqCb
LTr2rk/no1E1KlsYBRLlUdy2NmLz4aQP++TPw5S/EauhWTEB8MxT7I9j12yW00gq
iiPtRVaoZkHqAblH7qFHDBTxI+Egc8p9UHxkOFejj0qcm+ltRc9Ea01gIEBxJbVG
qmwIft/I+shWKpLLg7h5CZctXqEBzgbttJfJBNxB7+BPNk3kQHNG7BESfIhbNCYl
TercGL7FG81kwA==
-----END CERTIFICATE-----
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            04:00:00:00:00:01:2f:4e:e1:47:10
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=BE, O=GlobalSign nv-sa, OU=Root CA, CN=GlobalSign Root CA
        Validity
            Not Before: Dec 15 08:00:00 2006 GMT
            Not After : Jan 28 12:00:00 2028 GMT
        Subject: OU=GlobalSign Root CA - R2, O=GlobalSign, CN=GlobalSign
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (2048 bit)
                Modulus:
                    00:a6:cf:24:0e:be:2e:6f:28:99:45:42:c4:ab:3e:
                    21:54:9b:0b:d3:7f:84:70:fa:12:b3:cb:bf:87:5f:
                    c6:7f:86:d3:b2:30:5c:d6:fd:ad:f1:7b:dc:e5:f8:
                    60:96:09:92:10:f5:d0:53:de:fb:7b:7e:73:88:ac:
                    52:88:7b:4a:a6:ca:49:a6:5e:a8:a7:8c:5a:11:bc:
                    7a:82:eb:be:8c:e9:b3:ac:96:25:07:97:4a:99:2a:
                    07:2f:b4:1e:77:bf:8a:0f:b5:02:7c:1b:96:b8:c5:
                    b9:3a:2c:bc:d6:12:b9:eb:59:7d:e2:d0:06:86:5f:
                    5e:49:6a:b5:39:5e:88:34:ec:bc:78:0c:08:98:84:
                    6c:a8:cd:4b:b4:a0:7d:0c:79:4d:f0:b8:2d:cb:21:
                    ca:d5:6c:5b:7d:e1:a0:29:84:a1:f9:d3:94:49:cb:
                    24:62:91:20:bc:dd:0b:d5:d9:cc:f9:ea:27:0a:2b:
                    73:91:c6:9d:1b:ac:c8:cb:e8:e0:a0:f4:2f:90:8b:
                    4d:fb:b0:36:1b:f6:19:7a:85:e0:6d:f2:61:13:88:
                    5c:9f:e0:93:0a:51:97:8a:5a:ce:af:ab:d5:f7:aa:
                    09:aa:60:bd:dc:d9:5f:df:72:a9:60:13:5e:00:01:
                    c9:4a:fa:3f:a4:ea:07:03:21:02:8e:82:ca:03:c2:
                    9b:8f
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Subject Key Identifier: 
                9B:E2:07:57:67:1C:1E:C0:6A:06:DE:59:B4:9A:2D:DF:DC:19:86:2E
            X509v3 Certificate Policies: 
                Policy: X509v3 Any Policy
                  CPS: https://www.globalsign.com/repository/

            X509v3 CRL Distribution Points: 

                Full Name:
                  URI:http://crl.globalsign.net/root.crl

            Authority Information Access: 
                OCSP - URI:http://ocsp.globalsign.com/rootr1

            X509v3 Extended Key Usage: 
                TLS Web Server Authentication, TLS Web Client Authentication, Microsoft Server Gated Crypto
            X509v3 Authority Key Identifier: 
                keyid:60:7B:66:1A:45:0D:97:CA:89:50:2F:7D:04:CD:34:A8:FF:FC:FD:4B

    Signature Algorithm: sha1WithRSAEncryption
        3a:0f:cd:26:4d:38:30:08:a8:c6:fc:5c:d8:08:7a:ef:fa:1c:
        2a:03:ce:32:ae:44:96:e1:52:03:95:0a:52:d6:67:af:5b:96:
        7c:dd:19:8b:30:5b:36:3a:6b:6e:a0:15:c6:82:a1:cb:39:66:
        00:57:8b:02:a2:6e:85:fb:ac:55:5a:b8:15:50:1a:90:de:09:
        48:ec:a8:f6:57:1c:18:31:bd:c6:7d:c8:bd:eb:c2:a7:39:51:
        6d:a2:ff:1c:78:de:1c:27:04:e1:cf:24:95:e8:0e:e4:d5:1f:
        b0:f9:fb:50:ca:cb:6e:9e:62:26:78:86:f5:c4:f5:78:8f:dd:
        72:af:6e:2e:d5:9e:dd:ce:3c:cb:b8:c7:2d:54:60:d7:e5:9c:
        02:4b:86:44:f0:57:51:2b:cd:0a:9b:3c:b1:f5:3a:4c:1d:8a:
        c5:f0:30:3e:65:87:c4:0e:5f:6e:4a:ac:8a:a8:1e:e7:fa:e4:
        33:80:15:84:56:65:25:9b:fb:9e:30:88:cb:91:16:c1:05:c3:
        a9:24:ec:21:d2:d5:b0:fc:b7:23:46:a7:9d:f7:f7:c6:53:12:
        78:37:b4:13:73:8f:37:97:5e:04:9b:f9:99:8b:93:3e:26:42:
        97:9f:fd:1e:b5:d5:cb:88:48:34:a2:66:a0:fa:ac:72:8f:dd:
        47:2f:82:74
SHA1 Fingerprint=69:FF:62:10:2A:A7:DA:9C:7F:7B:74:66:2A:A3:1C:6A:2F:0B:D0:0D
-----BEGIN CERTIFICATE-----
MIIEdzCCA1+gAwIBAgILBAAAAAABL07hRxAwDQYJKoZIhvcNAQEFBQAwVzELMAkG
A1UEBhMCQkUxGTAXBgNVBAoTEEdsb2JhbFNpZ24gbnYtc2ExEDAOBgNVBAsTB1Jv
b3QgQ0ExGzAZBgNVBAMTEkdsb2JhbFNpZ24gUm9vdCBDQTAeFw0wNjEyMTUwODAw
MDBaFw0yODAxMjgxMjAwMDBaMEwxIDAeBgNVBAsTF0dsb2JhbFNpZ24gUm9vdCBD
QSAtIFIyMRMwEQYDVQQKEwpHbG9iYWxTaWduMRMwEQYDVQQDEwpHbG9iYWxTaWdu
MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAps8kDr4ubyiZRULEqz4h
VJsL03+EcPoSs8u/h1/Gf4bTsjBc1v2t8Xvc5fhglgmSEPXQU977e35ziKxSiHtK
pspJpl6op4xaEbx6guu+jOmzrJYlB5dKmSoHL7Qed7+KD7UCfBuWuMW5Oiy81hK5
61l94tAGhl9eSWq1OV6INOy8eAwImIRsqM1LtKB9DHlN8LgtyyHK1WxbfeGgKYSh
+dOUScskYpEgvN0L1dnM+eonCitzkcadG6zIy+jgoPQvkItN+7A2G/YZeoXgbfJh
E4hcn+CTClGXilrOr6vV96oJqmC93Nlf33KpYBNeAAHJSvo/pOoHAyECjoLKA8Kb
jwIDAQABo4IBTTCCAUkwDgYDVR0PAQH/BAQDAgEGMA8GA1UdEwEB/wQFMAMBAf8w
HQYDVR0OBBYEFJviB1dnHB7AagbeWbSaLd/cGYYuMEcGA1UdIARAMD4wPAYEVR0g
ADA0MDIGCCsGAQUFBwIBFiZodHRwczovL3d3dy5nbG9iYWxzaWduLmNvbS9yZXBv
c2l0b3J5LzAzBgNVHR8ELDAqMCigJqAkhiJodHRwOi8vY3JsLmdsb2JhbHNpZ24u
bmV0L3Jvb3QuY3JsMD0GCCsGAQUFBwEBBDEwLzAtBggrBgEFBQcwAYYhaHR0cDov
L29jc3AuZ2xvYmFsc2lnbi5jb20vcm9vdHIxMCkGA1UdJQQiMCAGCCsGAQUFBwMB
BggrBgEFBQcDAgYKKwYBBAGCNwoDAzAfBgNVHSMEGDAWgBRge2YaRQ2XyolQL30E
zTSo//z9SzANBgkqhkiG9w0BAQUFAAOCAQEAOg/NJk04MAioxvxc2Ah67/ocKgPO
Mq5EluFSA5UKUtZnr1uWfN0ZizBbNjprbqAVxoKhyzlmAFeLAqJuhfusVVq4FVAa
kN4JSOyo9lccGDG9xn3IvevCpzlRbaL/HHjeHCcE4c8klegO5NUfsPn7UMrLbp5i
JniG9cT1eI/dcq9uLtWe3c48y7jHLVRg1+WcAkuGRPBXUSvNCps8sfU6TB2KxfAw
PmWHxA5fbkqsiqge5/rkM4AVhFZlJZv7njCIy5EWwQXDqSTsIdLVsPy3I0annff3
xlMSeDe0E3OPN5deBJv5mYuTPiZCl5/9HrXVy4hINKJmoPqsco/dRy+CdA==
-----END CERTIFICATE-----
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            04:00:00:00:00:01:2f:4e:e1:41:43
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=BE, O=GlobalSign nv-sa, OU=Root CA, CN=GlobalSign Root CA
        Validity
            Not Before: Apr 13 10:00:00 2011 GMT
            Not After : Apr 13 10:00:00 2022 GMT
        Subject: C=BE, O=GlobalSign nv-sa, CN=GlobalSign Domain Validation CA - G2
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (2048 bit)
                Modulus:
                    00:b1:a3:cd:c0:df:33:40:26:eb:de:5a:d7:94:66:
                    d4:01:63:cc:33:44:89:e0:e2:b8:c2:47:0d:8f:ad:
                    69:86:1c:a8:73:42:0b:f1:72:fb:2d:ac:b5:11:72:
                    83:22:f6:56:e7:2e:c5:67:71:9d:00:1c:32:bc:e3:
                    ed:2e:08:45:a9:e6:fa:dd:c8:8c:83:05:c1:6f:4b:
                    d0:26:4a:0b:f6:1b:45:c0:4d:7e:93:bc:0d:27:84:
                    ed:30:a3:e9:c6:26:26:dd:2d:1f:d8:8b:c3:ce:19:
                    d0:5b:fc:08:9f:e4:d8:e2:35:e4:a0:68:a6:f6:0d:
                    a3:74:60:42:b2:97:82:24:8e:41:a4:f2:2e:5e:b6:
                    8e:a7:6e:d9:6c:7f:0d:3b:24:35:6a:d0:ab:5b:6a:
                    f7:97:02:00:3f:51:a6:a7:6e:73:ca:77:0d:76:7c:
                    9b:b6:30:1a:1a:9c:f7:1f:28:7b:0e:8b:47:1f:e7:
                    7f:05:8c:c6:c9:c8:bb:cf:e9:dc:7a:41:2e:a1:86:
                    da:d4:39:b2:e2:13:40:a6:a8:3a:fa:0f:53:1e:4f:
                    ec:6e:98:09:1b:ca:9a:77:b3:55:85:85:e9:2e:16:
                    b5:9d:5e:54:f1:4a:7a:6c:39:ba:6e:17:06:34:b3:
                    b2:42:e1:f7:f3:9c:9a:0b:11:44:de:6a:78:8e:b1:
                    13:4f
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE, pathlen:0
            X509v3 Subject Key Identifier: 
                96:AD:FA:B0:5B:B9:83:64:2A:76:C2:1C:8A:69:DA:42:DC:FE:FD:28
            X509v3 Certificate Policies: 
                Policy: X509v3 Any Policy
                  CPS: https://www.globalsign.com/repository/

            X509v3 CRL Distribution Points: 

                Full Name:
                  URI:http://crl.globalsign.net/root.crl

            Authority Information Access: 
                OCSP - URI:http://ocsp.globalsign.com/rootr1

            X509v3 Authority Key Identifier: 
                keyid:60:7B:66:1A:45:0D:97:CA:89:50:2F:7D:04:CD:34:A8:FF:FC:FD:4B

    Signature Algorithm: sha1WithRSAEncryption
        3a:e7:fc:ae:af:05:43:80:27:75:41:5f:a8:f0:28:8f:1f:8f:
        83:7e:b2:b8:ba:ae:75:31:27:88:a5:e5:b9:4e:04:43:d2:ad:
        e8:13:00:a3:db:19:01:30:9e:6c:3c:52:7f:5c:de:ab:67:c3:
        84:04:54:51:99:9e:63:2f:bd:d5:b7:c0:d5:da:03:0e:49:d3:
        e1:b3:92:4f:df:92:4e:7d:ae:22:6a:ce:d8:bc:fc:7c:ae:6b:
        b6:8a:ea:45:62:90:11:d3:0b:71:a7:5e:06:22:ff:4d:38:ea:
        b9:3a:6e:cd:67:1a:02:7f:4b:f3:bf:0e:79:6f:be:d5:29:32:
        59:59:1d:96:08:9b:70:8f:f7:1e:5c:46:7b:4e:d0:9d:b4:53:
        c8:12:02:1b:0d:bb:32:eb:59:53:b9:3e:1b:56:8d:15:c8:f1:
        42:3f:77:fe:1f:e5:6d:9e:66:1f:ab:da:b2:83:57:b4:0c:22:
        d2:86:bc:da:32:d7:c0:ed:70:85:7c:93:aa:f0:97:dc:39:11:
        d2:d8:89:eb:8d:90:a3:b6:50:25:cb:6c:d9:a6:c3:6f:fb:88:
        54:b8:e4:92:70:87:ce:79:3b:f0:de:36:bf:03:04:00:3d:f9:
        ef:9e:a9:67:a4:f4:86:3e:23:97:b8:2a:71:e2:ed:fe:69:88:
        67:bf:26:5c
SHA1 Fingerprint=2A:3C:F4:BD:DC:74:CC:AA:48:05:58:F9:D8:D1:D2:A0:84:F3:4B:31
-----BEGIN CERTIFICATE-----
MIIEWjCCA0KgAwIBAgILBAAAAAABL07hQUMwDQYJKoZIhvcNAQEFBQAwVzELMAkG
A1UEBhMCQkUxGTAXBgNVBAoTEEdsb2JhbFNpZ24gbnYtc2ExEDAOBgNVBAsTB1Jv
b3QgQ0ExGzAZBgNVBAMTEkdsb2JhbFNpZ24gUm9vdCBDQTAeFw0xMTA0MTMxMDAw
MDBaFw0yMjA0MTMxMDAwMDBaMFcxCzAJBgNVBAYTAkJFMRkwFwYDVQQKExBHbG9i
YWxTaWduIG52LXNhMS0wKwYDVQQDEyRHbG9iYWxTaWduIERvbWFpbiBWYWxpZGF0
aW9uIENBIC0gRzIwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCxo83A
3zNAJuveWteUZtQBY8wzRIng4rjCRw2PrWmGHKhzQgvxcvstrLURcoMi9lbnLsVn
cZ0AHDK84+0uCEWp5vrdyIyDBcFvS9AmSgv2G0XATX6TvA0nhO0wo+nGJibdLR/Y
i8POGdBb/Aif5NjiNeSgaKb2DaN0YEKyl4IkjkGk8i5eto6nbtlsfw07JDVq0Ktb
aveXAgA/UaanbnPKdw12fJu2MBoanPcfKHsOi0cf538FjMbJyLvP6dx6QS6hhtrU
ObLiE0CmqDr6D1MeT+xumAkbypp3s1WFhekuFrWdXlTxSnpsObpuFwY0s7JC4ffz
nJoLEUTeaniOsRNPAgMBAAGjggElMIIBITAOBgNVHQ8BAf8EBAMCAQYwEgYDVR0T
AQH/BAgwBgEB/wIBADAdBgNVHQ4EFgQUlq36sFu5g2QqdsIcimnaQtz+/SgwRwYD
VR0gBEAwPjA8BgRVHSAAMDQwMgYIKwYBBQUHAgEWJmh0dHBzOi8vd3d3Lmdsb2Jh
bHNpZ24uY29tL3JlcG9zaXRvcnkvMDMGA1UdHwQsMCowKKAmoCSGImh0dHA6Ly9j
cmwuZ2xvYmFsc2lnbi5uZXQvcm9vdC5jcmwwPQYIKwYBBQUHAQEEMTAvMC0GCCsG
AQUFBzABhiFodHRwOi8vb2NzcC5nbG9iYWxzaWduLmNvbS9yb290cjEwHwYDVR0j
BBgwFoAUYHtmGkUNl8qJUC99BM00qP/8/UswDQYJKoZIhvcNAQEFBQADggEBADrn
/K6vBUOAJ3VBX6jwKI8fj4N+sri6rnUxJ4il5blOBEPSregTAKPbGQEwnmw8Un9c
3qtnw4QEVFGZnmMvvdW3wNXaAw5J0+Gzkk/fkk59riJqzti8/Hyua7aK6kVikBHT
C3GnXgYi/0046rk6bs1nGgJ/S/O/DnlvvtUpMllZHZYIm3CP9x5cRntO0J20U8gS
AhsNuzLrWVO5PhtWjRXI8UI/d/4f5W2eZh+r2rKDV7QMItKGvNoy18DtcIV8k6rw
l9w5EdLYieuNkKO2UCXLbNmmw2/7iFS45JJwh855O/DeNr8DBAA9+e+eqWek9IY+
I5e4KnHi7f5piGe/Jlw=
-----END CERTIFICATE-----
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            04:00:00:00:00:01:22:0d:3c:14:c5
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: OU=GlobalSign Root CA - R2, O=GlobalSign, CN=GlobalSign
        Validity
            Not Before: Jun 23 12:00:00 2009 GMT
            Not After : Dec 15 07:00:00 2021 GMT
        Subject: OU=Extended Validation CA, O=GlobalSign, CN=GlobalSign Extended Validation CA
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (2048 bit)
                Modulus:
                    00:b5:12:6b:7a:43:09:e7:44:b1:43:d1:f8:32:1e:
                    7d:97:24:eb:64:3f:2f:e2:78:6b:32:8d:6c:b2:45:
                    a9:17:82:67:7f:11:61:ad:90:b3:46:84:40:23:61:
                    50:f1:13:bd:2e:ff:be:7c:5e:85:c7:d9:0d:1c:f5:
                    ee:44:71:d7:b8:8f:85:b6:0e:46:cc:49:23:35:21:
                    3b:25:fa:50:2d:4b:7d:cd:2b:54:3f:8f:ea:29:23:
                    ea:93:0e:fc:aa:87:36:c4:66:d7:0e:73:f5:dc:f0:
                    fd:07:f9:c1:8f:7a:a0:48:df:de:cd:db:19:18:30:
                    ca:d8:83:f1:79:ac:36:8a:9f:a8:c0:d2:89:eb:60:
                    a4:ed:2a:55:c5:15:0c:63:2b:c7:0b:7e:31:ce:c1:
                    9b:2b:fa:86:a5:63:4d:f6:ba:e6:dc:ce:35:21:66:
                    cf:58:1c:c8:f3:aa:2f:8c:cb:cd:24:ba:01:bd:27:
                    bd:d5:ef:69:d5:75:a1:e2:a2:b8:a1:ee:88:af:75:
                    7f:5f:f2:d2:32:10:77:35:1f:69:f9:02:62:84:7f:
                    8a:27:0f:7f:fa:b6:be:99:72:ae:7d:ac:9b:72:0f:
                    58:c3:cb:c8:12:b5:b8:80:e1:c0:b1:c0:d1:d1:86:
                    35:fc:71:7c:20:2e:f6:b8:a7:b0:fc:84:20:36:36:
                    86:99
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE, pathlen:0
            X509v3 Certificate Policies: 
                Policy: X509v3 Any Policy
                  CPS: http://www.globalsign.net/repository/

            X509v3 Subject Key Identifier: 
                34:B1:F9:C9:8C:6B:35:44:CC:08:69:0A:EE:E3:A3:B9:5C:BF:16:E0
            X509v3 CRL Distribution Points: 

                Full Name:
                  URI:http://crl.globalsign.net/root-r2.crl

            Authority Information Access: 
                OCSP - URI:http://ocsp.globalsign.com/ExtendedSSLCA

            Netscape Cert Type: 
                SSL CA
            X509v3 Extended Key Usage: 
                Microsoft Server Gated Crypto, Netscape Server Gated Crypto
            X509v3 Authority Key Identifier: 
                keyid:9B:E2:07:57:67:1C:1E:C0:6A:06:DE:59:B4:9A:2D:DF:DC:19:86:2E

    Signature Algorithm: sha1WithRSAEncryption
        8e:9b:6b:5a:19:d4:61:21:1b:89:d3:ee:76:41:20:9d:f0:0d:
        4d:e4:f2:a1:b1:8c:f0:ce:53:68:f2:e9:2c:e2:69:cd:17:17:
        0c:b0:fe:69:dd:23:2b:c7:d9:22:7d:8e:2f:8e:6c:b4:31:ec:
        34:e3:c7:e2:f5:cd:58:0a:f5:fc:53:22:f3:82:e6:dc:4e:b5:
        31:22:3d:b9:c7:ea:4c:fc:9b:66:89:09:5e:4a:d7:75:4b:6d:
        b9:53:12:ff:67:aa:be:18:5a:a2:a7:c5:18:ee:d3:31:90:20:
        9d:4a:16:a6:a1:7c:ae:8f:42:d8:03:38:ec:1b:25:13:ef:0c:
        55:d6:7f:0e:eb:e3:92:85:27:4c:ed:88:9e:0a:4e:0c:89:5c:
        be:b5:1c:af:91:e1:19:9c:c4:dc:23:23:b4:a8:df:12:39:0d:
        5b:98:20:d1:bc:8c:c8:19:c0:50:76:f5:b1:fc:17:dd:c0:77:
        f0:a9:04:61:23:6e:7f:65:6e:4b:d5:0d:f3:5d:59:39:b8:47:
        cd:3c:8f:af:94:c2:91:42:7e:04:ad:99:3d:09:bf:eb:1f:ae:
        8c:db:02:af:b6:5e:87:b9:f4:f4:b5:a0:71:f7:91:36:b7:46:
        28:eb:ab:60:69:72:f5:f6:05:33:d1:b4:f3:78:67:80:f5:8a:
        d0:de:3b:ee
SHA1 Fingerprint=37:37:C5:FC:0E:F1:0F:4D:C7:A6:01:E4:29:3A:E1:6F:29:E5:E4:D0
-----BEGIN CERTIFICATE-----
MIIEmDCCA4CgAwIBAgILBAAAAAABIg08FMUwDQYJKoZIhvcNAQEFBQAwTDEgMB4G
A1UECxMXR2xvYmFsU2lnbiBSb290IENBIC0gUjIxEzARBgNVBAoTCkdsb2JhbFNp
Z24xEzARBgNVBAMTCkdsb2JhbFNpZ24wHhcNMDkwNjIzMTIwMDAwWhcNMjExMjE1
MDcwMDAwWjBiMR8wHQYDVQQLExZFeHRlbmRlZCBWYWxpZGF0aW9uIENBMRMwEQYD
VQQKEwpHbG9iYWxTaWduMSowKAYDVQQDEyFHbG9iYWxTaWduIEV4dGVuZGVkIFZh
bGlkYXRpb24gQ0EwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQC1Emt6
QwnnRLFD0fgyHn2XJOtkPy/ieGsyjWyyRakXgmd/EWGtkLNGhEAjYVDxE70u/758
XoXH2Q0c9e5Ecde4j4W2DkbMSSM1ITsl+lAtS33NK1Q/j+opI+qTDvyqhzbEZtcO
c/Xc8P0H+cGPeqBI397N2xkYMMrYg/F5rDaKn6jA0onrYKTtKlXFFQxjK8cLfjHO
wZsr+oalY032uubczjUhZs9YHMjzqi+My80kugG9J73V72nVdaHiorih7oivdX9f
8tIyEHc1H2n5AmKEf4onD3/6tr6Zcq59rJtyD1jDy8gStbiA4cCxwNHRhjX8cXwg
Lva4p7D8hCA2NoaZAgMBAAGjggFjMIIBXzAOBgNVHQ8BAf8EBAMCAQYwEgYDVR0T
AQH/BAgwBgEB/wIBADBGBgNVHSAEPzA9MDsGBFUdIAAwMzAxBggrBgEFBQcCARYl
aHR0cDovL3d3dy5nbG9iYWxzaWduLm5ldC9yZXBvc2l0b3J5LzAdBgNVHQ4EFgQU
NLH5yYxrNUTMCGkK7uOjuVy/FuAwNgYDVR0fBC8wLTAroCmgJ4YlaHR0cDovL2Ny
bC5nbG9iYWxzaWduLm5ldC9yb290LXIyLmNybDBEBggrBgEFBQcBAQQ4MDYwNAYI
KwYBBQUHMAGGKGh0dHA6Ly9vY3NwLmdsb2JhbHNpZ24uY29tL0V4dGVuZGVkU1NM
Q0EwEQYJYIZIAYb4QgEBBAQDAgIEMCAGA1UdJQQZMBcGCisGAQQBgjcKAwMGCWCG
SAGG+EIEATAfBgNVHSMEGDAWgBSb4gdXZxwewGoG3lm0mi3f3BmGLjANBgkqhkiG
9w0BAQUFAAOCAQEAjptrWhnUYSEbidPudkEgnfANTeTyobGM8M5TaPLpLOJpzRcX
DLD+ad0jK8fZIn2OL45stDHsNOPH4vXNWAr1/FMi84Lm3E61MSI9ucfqTPybZokJ
XkrXdUttuVMS/2eqvhhaoqfFGO7TMZAgnUoWpqF8ro9C2AM47BslE+8MVdZ/Duvj
koUnTO2IngpODIlcvrUcr5HhGZzE3CMjtKjfEjkNW5gg0byMyBnAUHb1sfwX3cB3
8KkEYSNuf2VuS9UN811ZObhHzTyPr5TCkUJ+BK2ZPQm/6x+ujNsCr7Zeh7n09LWg
cfeRNrdGKOurYGly9fYFM9G083hngPWK0N477g==
-----END CERTIFICATE-----
Certificate:
    Data:
        Version: 1 (0x0)
        Serial Number:
            cd:ba:7f:56:f0:df:e4:bc:54:fe:22:ac:b3:72:aa:55
        Signature Algorithm: md2WithRSAEncryption
        Issuer: C=US, O=VeriSign, Inc., OU=Class 1 Public Primary Certification Authority
        Validity
            Not Before: Jan 29 00:00:00 1996 GMT
            Not After : Aug  1 23:59:59 2028 GMT
        Subject: C=US, O=VeriSign, Inc., OU=Class 1 Public Primary Certification Authority
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (1024 bit)
                Modulus:
                    00:e5:19:bf:6d:a3:56:61:2d:99:48:71:f6:67:de:
                    b9:8d:eb:b7:9e:86:80:0a:91:0e:fa:38:25:af:46:
                    88:82:e5:73:a8:a0:9b:24:5d:0d:1f:cc:65:6e:0c:
                    b0:d0:56:84:18:87:9a:06:9b:10:a1:73:df:b4:58:
                    39:6b:6e:c1:f6:15:d5:a8:a8:3f:aa:12:06:8d:31:
                    ac:7f:b0:34:d7:8f:34:67:88:09:cd:14:11:e2:4e:
                    45:56:69:1f:78:02:80:da:dc:47:91:29:bb:36:c9:
                    63:5c:c5:e0:d7:2d:87:7b:a1:b7:32:b0:7b:30:ba:
                    2a:2f:31:aa:ee:a3:67:da:db
                Exponent: 65537 (0x10001)
    Signature Algorithm: md2WithRSAEncryption
        4c:3f:b8:8b:c6:68:df:ee:43:33:0e:5d:e9:a6:cb:07:84:4d:
        7a:33:ff:92:1b:f4:36:ad:d8:95:22:36:68:11:6c:7c:42:cc:
        f3:9c:2e:c4:07:3f:14:b0:0f:4f:ff:90:92:76:f9:e2:bc:4a:
        e9:8f:cd:a0:80:0a:f7:c5:29:f1:82:22:5d:b8:b1:dd:81:23:
        a3:7b:25:15:46:30:79:16:f8:ea:05:4b:94:7f:1d:c2:1c:c8:
        e3:b7:f4:10:40:3c:13:c3:5f:1f:53:e8:48:e4:86:b4:7b:a1:
        35:b0:7b:25:ba:b8:d3:8e:ab:3f:38:9d:00:34:00:98:f3:d1:
        71:94
SHA1 Fingerprint=90:AE:A2:69:85:FF:14:80:4C:43:49:52:EC:E9:60:84:77:AF:55:6F
-----BEGIN CERTIFICATE-----
MIICPTCCAaYCEQDNun9W8N/kvFT+IqyzcqpVMA0GCSqGSIb3DQEBAgUAMF8xCzAJ
BgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5jLjE3MDUGA1UECxMuQ2xh
c3MgMSBQdWJsaWMgUHJpbWFyeSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTAeFw05
NjAxMjkwMDAwMDBaFw0yODA4MDEyMzU5NTlaMF8xCzAJBgNVBAYTAlVTMRcwFQYD
VQQKEw5WZXJpU2lnbiwgSW5jLjE3MDUGA1UECxMuQ2xhc3MgMSBQdWJsaWMgUHJp
bWFyeSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTCBnzANBgkqhkiG9w0BAQEFAAOB
jQAwgYkCgYEA5Rm/baNWYS2ZSHH2Z965jeu3noaACpEO+jglr0aIguVzqKCbJF0N
H8xlbgyw0FaEGIeaBpsQoXPftFg5a27B9hXVqKg/qhIGjTGsf7A01480Z4gJzRQR
4k5FVmkfeAKA2txHkSm7NsljXMXg1y2He6G3MrB7MLoqLzGq7qNn2tsCAwEAATAN
BgkqhkiG9w0BAQIFAAOBgQBMP7iLxmjf7kMzDl3ppssHhE16M/+SG/Q2rdiVIjZo
EWx8QszznC7EBz8UsA9P/5CSdvnivErpj82ggAr3xSnxgiJduLHdgSOjeyUVRjB5
FvjqBUuUfx3CHMjjt/QQQDwTw18fU+hI5Ia0e6E1sHslurjTjqs/OJ0ANACY89Fx
lA==
-----END CERTIFICATE-----
SHA1 Fingerprint=30:D1:FD:4A:29:6A:B1:A8:83:1C:D5:6B:41:10:A2:27:F5:57:BF:FF
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 120010508 (0x727370c)
    Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=IE, O=Baltimore, OU=CyberTrust, CN=Baltimore CyberTrust Root
        Validity
            Not Before: Sep  8 17:35:16 2010 GMT
            Not After : Sep  8 17:34:08 2020 GMT
        Subject: O=Cybertrust Inc, CN=Cybertrust Public SureServer SV CA
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (2048 bit)
                Modulus:
                    00:a3:ba:99:8d:b7:e1:cd:73:88:f9:b9:dd:de:f4:
                    05:f3:25:f5:3f:c5:52:1e:51:5a:3f:9a:ff:4d:84:
                    b7:50:7f:f1:10:8a:5d:7f:64:55:1c:3b:a3:f3:ff:
                    97:7f:1c:4b:ed:6f:7f:e9:54:ec:97:2a:42:03:67:
                    7f:b9:c8:6c:a2:97:f8:40:93:24:c3:25:5e:a5:66:
                    8b:86:bd:d7:b9:26:22:6e:d2:66:83:b3:78:c1:7c:
                    58:76:11:eb:16:55:47:32:f0:b9:34:10:bd:8f:26:
                    a2:25:68:c1:14:2b:a2:73:d6:66:3d:44:87:5c:13:
                    7f:58:91:62:3d:57:7f:6c:ae:42:e8:12:7e:bd:78:
                    f1:f1:ac:5c:35:60:68:45:bc:53:73:87:11:1d:c5:
                    2e:fa:60:35:da:91:f9:da:f2:55:6c:bf:ca:a2:57:
                    5c:c8:64:bc:a9:5b:15:a0:fc:1c:f3:44:2e:bd:06:
                    f2:68:d8:40:2d:bb:b3:61:25:92:93:25:1c:77:46:
                    90:bf:d0:af:b7:83:a0:3c:87:5e:a5:91:a8:ff:c1:
                    31:1b:b6:4b:ac:12:34:08:d5:db:ec:89:87:63:06:
                    a7:53:f8:d5:f5:e6:66:ac:5e:84:65:46:c9:f4:3a:
                    25:0f:6c:cc:0f:66:b8:9a:55:a1:46:6c:fc:91:23:
                    5f:bd
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE, pathlen:0
            X509v3 Certificate Policies: 
                Policy: 1.3.6.1.4.1.6334.1.50
                  CPS: http://cybertrust.omniroot.com/repository

            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Authority Key Identifier: 
                keyid:E5:9D:59:30:82:47:58:CC:AC:FA:08:54:36:86:7B:3A:B5:04:4D:F0

            X509v3 CRL Distribution Points: 

                Full Name:
                  URI:http://cdp1.public-trust.com/CRL/Omniroot2025.crl

            X509v3 Subject Key Identifier: 
                04:98:60:DF:80:1B:96:49:5D:65:56:2D:A5:2C:09:24:0A:EC:DC:B9
    Signature Algorithm: sha1WithRSAEncryption
         5f:df:8b:cf:29:79:78:2b:f3:7c:f4:82:5f:79:e0:e1:b3:28:
         bd:08:75:41:ce:8c:88:d7:0e:55:b9:02:b5:05:79:3e:bb:52:
         31:b3:4b:1e:b1:fe:d3:a2:21:43:d2:91:d3:16:fa:6b:79:e4:
         8e:4d:19:ec:4c:86:68:34:52:b7:6f:c2:bd:9c:78:be:f0:6f:
         3f:3d:9e:9f:49:74:c4:7c:97:19:45:57:ac:6f:fa:5a:3e:3f:
         d3:d6:e3:2b:dc:8a:f8:c8:0a:0d:6b:8c:3f:94:78:37:98:88:
         61:91:df:59:14:0f:09:c5:63:54:fb:f4:f6:af:97:ec:fc:63:
         64:43:a6:bc:cc:e4:e3:1f:df:73:b0:6e:f7:b5:c8:29:9b:ae:
         25:52:b8:b4:72:e1:de:93:48:f1:28:9f:7e:66:3f:3f:8b:55:
         0f:f8:16:07:71:05:d7:65:9c:d7:1b:3c:34:e6:44:16:3a:bd:
         d8:60:93:83:83:0c:88:96:65:33:40:df:6a:ac:ff:fe:94:51:
         61:bb:89:3f:f7:ac:c4:e4:b3:47:e2:fd:a2:6a:32:83:e2:7e:
         6f:f0:12:8e:a3:66:76:40:97:fb:11:e1:f7:73:1f:da:8b:1c:
         31:42:8b:9f:11:c5:49:a5:60:ed:48:2b:05:84:15:ab:2f:8a:
         2c:51:72:c0
-----BEGIN CERTIFICATE-----
MIIEGzCCAwOgAwIBAgIEByc3DDANBgkqhkiG9w0BAQUFADBaMQswCQYDVQQGEwJJ
RTESMBAGA1UEChMJQmFsdGltb3JlMRMwEQYDVQQLEwpDeWJlclRydXN0MSIwIAYD
VQQDExlCYWx0aW1vcmUgQ3liZXJUcnVzdCBSb290MB4XDTEwMDkwODE3MzUxNloX
DTIwMDkwODE3MzQwOFowRjEXMBUGA1UEChMOQ3liZXJ0cnVzdCBJbmMxKzApBgNV
BAMTIkN5YmVydHJ1c3QgUHVibGljIFN1cmVTZXJ2ZXIgU1YgQ0EwggEiMA0GCSqG
SIb3DQEBAQUAA4IBDwAwggEKAoIBAQCjupmNt+HNc4j5ud3e9AXzJfU/xVIeUVo/
mv9NhLdQf/EQil1/ZFUcO6Pz/5d/HEvtb3/pVOyXKkIDZ3+5yGyil/hAkyTDJV6l
ZouGvde5JiJu0maDs3jBfFh2EesWVUcy8Lk0EL2PJqIlaMEUK6Jz1mY9RIdcE39Y
kWI9V39srkLoEn69ePHxrFw1YGhFvFNzhxEdxS76YDXakfna8lVsv8qiV1zIZLyp
WxWg/BzzRC69BvJo2EAtu7NhJZKTJRx3RpC/0K+3g6A8h16lkaj/wTEbtkusEjQI
1dvsiYdjBqdT+NX15masXoRlRsn0OiUPbMwPZriaVaFGbPyRI1+9AgMBAAGjgfww
gfkwEgYDVR0TAQH/BAgwBgEB/wIBADBPBgNVHSAESDBGMEQGCSsGAQQBsT4BMjA3
MDUGCCsGAQUFBwIBFilodHRwOi8vY3liZXJ0cnVzdC5vbW5pcm9vdC5jb20vcmVw
b3NpdG9yeTAOBgNVHQ8BAf8EBAMCAQYwHwYDVR0jBBgwFoAU5Z1ZMIJHWMys+ghU
NoZ7OrUETfAwQgYDVR0fBDswOTA3oDWgM4YxaHR0cDovL2NkcDEucHVibGljLXRy
dXN0LmNvbS9DUkwvT21uaXJvb3QyMDI1LmNybDAdBgNVHQ4EFgQUBJhg34Ablkld
ZVYtpSwJJArs3LkwDQYJKoZIhvcNAQEFBQADggEBAF/fi88peXgr83z0gl954OGz
KL0IdUHOjIjXDlW5ArUFeT67UjGzSx6x/tOiIUPSkdMW+mt55I5NGexMhmg0Urdv
wr2ceL7wbz89np9JdMR8lxlFV6xv+lo+P9PW4yvcivjICg1rjD+UeDeYiGGR31kU
DwnFY1T79Pavl+z8Y2RDprzM5OMf33Owbve1yCmbriVSuLRy4d6TSPEon35mPz+L
VQ/4FgdxBddlnNcbPDTmRBY6vdhgk4ODDIiWZTNA32qs//6UUWG7iT/3rMTks0fi
/aJqMoPifm/wEo6jZnZAl/sR4fdzH9qLHDFCi58RxUmlYO1IKwWEFasviixRcsA=
-----END CERTIFICATE-----
SHA1 Fingerprint=8F:86:D9:6D:C7:0B:EB:25:0A:66:AB:1C:28:10:12:47:FB:2D:89:88
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            04:00:00:00:00:01:10:25:56:4c:93
    Signature Algorithm: sha1WithRSAEncryption
        Issuer: O=Cybertrust, Inc, CN=Cybertrust Global Root
        Validity
            Not Before: Jan 15 10:00:00 2007 GMT
            Not After : Jan 15 10:00:00 2021 GMT
        Subject: O=Cybertrust Inc, CN=Cybertrust SureServer EV CA
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (2048 bit)
                Modulus:
                    00:b7:b0:eb:bb:9e:e4:c7:4c:78:5d:b6:cc:30:7b:
                    14:b7:63:53:9a:31:fa:81:e0:2a:d3:90:7a:0d:db:
                    8f:69:19:ce:e3:20:b4:68:2a:4f:21:67:f0:bc:65:
                    7d:a7:69:09:de:4d:bc:59:7b:5b:b3:82:83:eb:f9:
                    de:e9:32:7b:93:c8:16:82:b7:82:c3:78:06:dd:6b:
                    07:b3:7f:c8:22:27:bb:fc:88:e6:b1:f9:17:b4:b6:
                    2e:95:4e:1d:5e:5d:6d:03:88:a6:a2:f8:d1:d7:1d:
                    af:d8:c7:4a:09:e7:d1:25:c1:7b:4f:ab:65:0d:3e:
                    65:55:76:b9:8a:4f:c2:24:5e:33:4f:4e:ba:59:88:
                    4f:f7:81:55:fc:53:e1:e1:95:41:5d:99:8f:05:03:
                    3c:12:24:ca:c4:8e:da:14:31:03:07:b9:15:c6:18:
                    15:f0:5e:c0:ee:24:19:20:2a:f1:5d:e7:52:a7:c9:
                    f8:42:06:f7:5e:90:48:13:10:ca:61:2f:60:db:21:
                    95:f5:c2:4d:8b:d2:1f:5c:0c:d2:54:31:c7:c3:07:
                    0c:1f:b9:8b:1a:75:8e:34:2b:3a:aa:bd:da:d0:69:
                    15:a0:26:8d:78:34:08:f4:90:4a:63:34:29:45:43:
                    f0:62:2c:43:92:a4:d9:90:45:37:fc:b8:96:9b:3f:
                    ff:d7
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE, pathlen:0
            X509v3 Subject Key Identifier: 
                9B:7B:58:EB:3D:03:E4:87:C8:E4:8C:EA:46:7C:92:54:E9:36:BB:9E
            X509v3 Certificate Policies: 
                Policy: 1.3.6.1.4.1.6334.1.100.1
                  CPS: http://cybertrust.omniroot.com/repository

            X509v3 CRL Distribution Points: 

                Full Name:
                  URI:http://crl.omniroot.com/ctglobal.crl

            X509v3 Authority Key Identifier: 
                keyid:B6:08:7B:0D:7A:CC:AC:20:4C:86:56:32:5E:CF:AB:6E:85:2D:70:57

    Signature Algorithm: sha1WithRSAEncryption
         7e:41:8f:fd:8d:ca:ca:70:b5:5a:df:1c:b7:86:6b:4d:aa:a2:
         93:4a:cf:d7:78:35:47:76:b4:97:7f:db:95:5c:70:d5:2b:3a:
         b0:5b:5e:e6:8b:7d:56:db:ed:91:f5:08:95:eb:d9:6c:97:89:
         52:1c:67:74:f9:7b:f5:dc:a7:06:54:fc:02:8b:8d:f1:7b:cb:
         68:1f:cb:f5:ae:fa:54:6d:24:22:72:54:35:d5:24:62:2e:d1:
         bf:7b:df:53:12:ba:63:37:aa:04:1e:4b:f8:58:ab:c4:59:ba:
         f0:e5:f6:31:1b:e9:6c:e6:fc:0c:dd:76:e0:7b:80:86:0b:c2:
         4a:93:3f:7f:72:ec:6f:cb:66:62:1b:12:8f:87:35:56:78:14:
         ab:ad:d5:71:57:b3:d0:2f:d5:53:51:94:c3:b3:45:fe:81:25:
         7e:a4:35:c3:c9:20:4a:3f:10:2e:b3:27:bd:f5:25:58:e7:0d:
         2f:7d:d9:f2:8a:13:dd:91:87:24:2e:14:4e:22:1e:7f:b1:a9:
         71:50:ce:1d:d3:34:dc:2f:6a:0b:b7:85:88:82:b6:91:93:f4:
         cb:02:2a:06:8b:7b:83:04:c2:a6:dc:cf:bd:71:1a:02:05:8b:
         8b:8c:a6:03:4a:54:33:a2:cf:85:be:e3:17:d3:10:77:90:c2:
         cf:a7:8e:1e
-----BEGIN CERTIFICATE-----
MIID8DCCAtigAwIBAgILBAAAAAABECVWTJMwDQYJKoZIhvcNAQEFBQAwOzEYMBYG
A1UEChMPQ3liZXJ0cnVzdCwgSW5jMR8wHQYDVQQDExZDeWJlcnRydXN0IEdsb2Jh
bCBSb290MB4XDTA3MDExNTEwMDAwMFoXDTIxMDExNTEwMDAwMFowPzEXMBUGA1UE
ChMOQ3liZXJ0cnVzdCBJbmMxJDAiBgNVBAMTG0N5YmVydHJ1c3QgU3VyZVNlcnZl
ciBFViBDQTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBALew67ue5MdM
eF22zDB7FLdjU5ox+oHgKtOQeg3bj2kZzuMgtGgqTyFn8LxlfadpCd5NvFl7W7OC
g+v53ukye5PIFoK3gsN4Bt1rB7N/yCInu/yI5rH5F7S2LpVOHV5dbQOIpqL40dcd
r9jHSgnn0SXBe0+rZQ0+ZVV2uYpPwiReM09OulmIT/eBVfxT4eGVQV2ZjwUDPBIk
ysSO2hQxAwe5FcYYFfBewO4kGSAq8V3nUqfJ+EIG916QSBMQymEvYNshlfXCTYvS
H1wM0lQxx8MHDB+5ixp1jjQrOqq92tBpFaAmjXg0CPSQSmM0KUVD8GIsQ5Kk2ZBF
N/y4lps//9cCAwEAAaOB8DCB7TAOBgNVHQ8BAf8EBAMCAQYwEgYDVR0TAQH/BAgw
BgEB/wIBADAdBgNVHQ4EFgQUm3tY6z0D5IfI5IzqRnySVOk2u54wUAYDVR0gBEkw
RzBFBgorBgEEAbE+AWQBMDcwNQYIKwYBBQUHAgEWKWh0dHA6Ly9jeWJlcnRydXN0
Lm9tbmlyb290LmNvbS9yZXBvc2l0b3J5MDUGA1UdHwQuMCwwKqAooCaGJGh0dHA6
Ly9jcmwub21uaXJvb3QuY29tL2N0Z2xvYmFsLmNybDAfBgNVHSMEGDAWgBS2CHsN
esysIEyGVjJez6tuhS1wVzANBgkqhkiG9w0BAQUFAAOCAQEAfkGP/Y3KynC1Wt8c
t4ZrTaqik0rP13g1R3a0l3/blVxw1Ss6sFte5ot9VtvtkfUIlevZbJeJUhxndPl7
9dynBlT8AouN8XvLaB/L9a76VG0kInJUNdUkYi7Rv3vfUxK6YzeqBB5L+FirxFm6
8OX2MRvpbOb8DN124HuAhgvCSpM/f3Lsb8tmYhsSj4c1VngUq63VcVez0C/VU1GU
w7NF/oElfqQ1w8kgSj8QLrMnvfUlWOcNL33Z8ooT3ZGHJC4UTiIef7GpcVDOHdM0
3C9qC7eFiIK2kZP0ywIqBot7gwTCptzPvXEaAgWLi4ymA0pUM6LPhb7jF9MQd5DC
z6eOHg==
-----END CERTIFICATE-----
SHA1 Fingerprint=27:AC:93:69:FA:F2:52:07:BB:26:27:CE:FA:CC:BE:4E:F9:C3:19:B8
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 7 (0x7)
    Signature Algorithm: sha256WithRSAEncryption
        Issuer: C=US, ST=Arizona, L=Scottsdale, O=GoDaddy.com, Inc., CN=Go Daddy Root Certificate Authority - G2
        Validity
            Not Before: May  3 07:00:00 2011 GMT
            Not After : May  3 07:00:00 2031 GMT
        Subject: C=US, ST=Arizona, L=Scottsdale, O=GoDaddy.com, Inc., OU=http://certs.godaddy.com/repository/, CN=Go Daddy Secure Certificate Authority - G2
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (2048 bit)
                Modulus:
                    00:b9:e0:cb:10:d4:af:76:bd:d4:93:62:eb:30:64:
                    b8:81:08:6c:c3:04:d9:62:17:8e:2f:ff:3e:65:cf:
                    8f:ce:62:e6:3c:52:1c:da:16:45:4b:55:ab:78:6b:
                    63:83:62:90:ce:0f:69:6c:99:c8:1a:14:8b:4c:cc:
                    45:33:ea:88:dc:9e:a3:af:2b:fe:80:61:9d:79:57:
                    c4:cf:2e:f4:3f:30:3c:5d:47:fc:9a:16:bc:c3:37:
                    96:41:51:8e:11:4b:54:f8:28:be:d0:8c:be:f0:30:
                    38:1e:f3:b0:26:f8:66:47:63:6d:de:71:26:47:8f:
                    38:47:53:d1:46:1d:b4:e3:dc:00:ea:45:ac:bd:bc:
                    71:d9:aa:6f:00:db:db:cd:30:3a:79:4f:5f:4c:47:
                    f8:1d:ef:5b:c2:c4:9d:60:3b:b1:b2:43:91:d8:a4:
                    33:4e:ea:b3:d6:27:4f:ad:25:8a:a5:c6:f4:d5:d0:
                    a6:ae:74:05:64:57:88:b5:44:55:d4:2d:2a:3a:3e:
                    f8:b8:bd:e9:32:0a:02:94:64:c4:16:3a:50:f1:4a:
                    ae:e7:79:33:af:0c:20:07:7f:e8:df:04:39:c2:69:
                    02:6c:63:52:fa:77:c1:1b:c8:74:87:c8:b9:93:18:
                    50:54:35:4b:69:4e:bc:3b:d3:49:2e:1f:dc:c1:d2:
                    52:fb
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Subject Key Identifier: 
                40:C2:BD:27:8E:CC:34:83:30:A2:33:D7:FB:6C:B3:F0:B4:2C:80:CE
            X509v3 Authority Key Identifier: 
                keyid:3A:9A:85:07:10:67:28:B6:EF:F6:BD:05:41:6E:20:C1:94:DA:0F:DE

            Authority Information Access: 
                OCSP - URI:http://ocsp.godaddy.com/

            X509v3 CRL Distribution Points: 

                Full Name:
                  URI:http://crl.godaddy.com/gdroot-g2.crl

            X509v3 Certificate Policies: 
                Policy: X509v3 Any Policy
                  CPS: https://certs.godaddy.com/repository/

    Signature Algorithm: sha256WithRSAEncryption
         08:7e:6c:93:10:c8:38:b8:96:a9:90:4b:ff:a1:5f:4f:04:ef:
         6c:3e:9c:88:06:c9:50:8f:a6:73:f7:57:31:1b:be:bc:e4:2f:
         db:f8:ba:d3:5b:e0:b4:e7:e6:79:62:0e:0c:a2:d7:6a:63:73:
         31:b5:f5:a8:48:a4:3b:08:2d:a2:5d:90:d7:b4:7c:25:4f:11:
         56:30:c4:b6:44:9d:7b:2c:9d:e5:5e:e6:ef:0c:61:aa:bf:e4:
         2a:1b:ee:84:9e:b8:83:7d:c1:43:ce:44:a7:13:70:0d:91:1f:
         f4:c8:13:ad:83:60:d9:d8:72:a8:73:24:1e:b5:ac:22:0e:ca:
         17:89:62:58:44:1b:ab:89:25:01:00:0f:cd:c4:1b:62:db:51:
         b4:d3:0f:51:2a:9b:f4:bc:73:fc:76:ce:36:a4:cd:d9:d8:2c:
         ea:ae:9b:f5:2a:b2:90:d1:4d:75:18:8a:3f:8a:41:90:23:7d:
         5b:4b:fe:a4:03:58:9b:46:b2:c3:60:60:83:f8:7d:50:41:ce:
         c2:a1:90:c3:bb:ef:02:2f:d2:15:54:ee:44:15:d9:0a:ae:a7:
         8a:33:ed:b1:2d:76:36:26:dc:04:eb:9f:f7:61:1f:15:dc:87:
         6f:ee:46:96:28:ad:a1:26:7d:0a:09:a7:2e:04:a3:8d:bc:f8:
         bc:04:30:01
-----BEGIN CERTIFICATE-----
MIIE0DCCA7igAwIBAgIBBzANBgkqhkiG9w0BAQsFADCBgzELMAkGA1UEBhMCVVMx
EDAOBgNVBAgTB0FyaXpvbmExEzARBgNVBAcTClNjb3R0c2RhbGUxGjAYBgNVBAoT
EUdvRGFkZHkuY29tLCBJbmMuMTEwLwYDVQQDEyhHbyBEYWRkeSBSb290IENlcnRp
ZmljYXRlIEF1dGhvcml0eSAtIEcyMB4XDTExMDUwMzA3MDAwMFoXDTMxMDUwMzA3
MDAwMFowgbQxCzAJBgNVBAYTAlVTMRAwDgYDVQQIEwdBcml6b25hMRMwEQYDVQQH
EwpTY290dHNkYWxlMRowGAYDVQQKExFHb0RhZGR5LmNvbSwgSW5jLjEtMCsGA1UE
CxMkaHR0cDovL2NlcnRzLmdvZGFkZHkuY29tL3JlcG9zaXRvcnkvMTMwMQYDVQQD
EypHbyBEYWRkeSBTZWN1cmUgQ2VydGlmaWNhdGUgQXV0aG9yaXR5IC0gRzIwggEi
MA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQC54MsQ1K92vdSTYuswZLiBCGzD
BNliF44v/z5lz4/OYuY8UhzaFkVLVat4a2ODYpDOD2lsmcgaFItMzEUz6ojcnqOv
K/6AYZ15V8TPLvQ/MDxdR/yaFrzDN5ZBUY4RS1T4KL7QjL7wMDge87Am+GZHY23e
cSZHjzhHU9FGHbTj3ADqRay9vHHZqm8A29vNMDp5T19MR/gd71vCxJ1gO7GyQ5HY
pDNO6rPWJ0+tJYqlxvTV0KaudAVkV4i1RFXULSo6Pvi4vekyCgKUZMQWOlDxSq7n
eTOvDCAHf+jfBDnCaQJsY1L6d8EbyHSHyLmTGFBUNUtpTrw700kuH9zB0lL7AgMB
AAGjggEaMIIBFjAPBgNVHRMBAf8EBTADAQH/MA4GA1UdDwEB/wQEAwIBBjAdBgNV
HQ4EFgQUQMK9J47MNIMwojPX+2yz8LQsgM4wHwYDVR0jBBgwFoAUOpqFBxBnKLbv
9r0FQW4gwZTaD94wNAYIKwYBBQUHAQEEKDAmMCQGCCsGAQUFBzABhhhodHRwOi8v
b2NzcC5nb2RhZGR5LmNvbS8wNQYDVR0fBC4wLDAqoCigJoYkaHR0cDovL2NybC5n
b2RhZGR5LmNvbS9nZHJvb3QtZzIuY3JsMEYGA1UdIAQ/MD0wOwYEVR0gADAzMDEG
CCsGAQUFBwIBFiVodHRwczovL2NlcnRzLmdvZGFkZHkuY29tL3JlcG9zaXRvcnkv
MA0GCSqGSIb3DQEBCwUAA4IBAQAIfmyTEMg4uJapkEv/oV9PBO9sPpyIBslQj6Zz
91cxG7685C/b+LrTW+C05+Z5Yg4MotdqY3MxtfWoSKQ7CC2iXZDXtHwlTxFWMMS2
RJ17LJ3lXubvDGGqv+QqG+6EnriDfcFDzkSnE3ANkR/0yBOtg2DZ2HKocyQetawi
DsoXiWJYRBuriSUBAA/NxBti21G00w9RKpv0vHP8ds42pM3Z2Czqrpv1KrKQ0U11
GIo/ikGQI31bS/6kA1ibRrLDYGCD+H1QQc7CoZDDu+8CL9IVVO5EFdkKrqeKM+2x
LXY2JtwE65/3YR8V3Idv7kaWKK2hJn0KCacuBKONvPi8BDAB
-----END CERTIFICATE-----
SHA1 Fingerprint=FF:67:36:7C:5C:D4:DE:4A:E1:8B:CC:E1:D7:0F:DA:BD:7C:86:61:35
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            51:3f:b9:74:38:70:b7:34:40:41:8d:30:93:06:99:ff
    Signature Algorithm: sha256WithRSAEncryption
        Issuer: C=US, O=VeriSign, Inc., OU=VeriSign Trust Network, OU=(c) 2006 VeriSign, Inc. - For authorized use only, CN=VeriSign Class 3 Public Primary Certification Authority - G5
        Validity
            Not Before: Oct 31 00:00:00 2013 GMT
            Not After : Oct 30 23:59:59 2023 GMT
        Subject: C=US, O=Symantec Corporation, OU=Symantec Trust Network, CN=Symantec Class 3 Secure Server CA - G4
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (2048 bit)
                Modulus:
                    00:b2:d8:05:ca:1c:74:2d:b5:17:56:39:c5:4a:52:
                    09:96:e8:4b:d8:0c:f1:68:9f:9a:42:28:62:c3:a5:
                    30:53:7e:55:11:82:5b:03:7a:0d:2f:e1:79:04:c9:
                    b4:96:77:19:81:01:94:59:f9:bc:f7:7a:99:27:82:
                    2d:b7:83:dd:5a:27:7f:b2:03:7a:9c:53:25:e9:48:
                    1f:46:4f:c8:9d:29:f8:be:79:56:f6:f7:fd:d9:3a:
                    68:da:8b:4b:82:33:41:12:c3:c8:3c:cc:d6:96:7a:
                    84:21:1a:22:04:03:27:17:8b:1c:68:61:93:0f:0e:
                    51:80:33:1d:b4:b5:ce:eb:7e:d0:62:ac:ee:b3:7b:
                    01:74:ef:69:35:eb:ca:d5:3d:a9:ee:97:98:ca:8d:
                    aa:44:0e:25:99:4a:15:96:a4:ce:6d:02:54:1f:2a:
                    6a:26:e2:06:3a:63:48:ac:b4:4c:d1:75:93:50:ff:
                    13:2f:d6:da:e1:c6:18:f5:9f:c9:25:5d:f3:00:3a:
                    de:26:4d:b4:29:09:cd:0f:3d:23:6f:16:4a:81:16:
                    fb:f2:83:10:c3:b8:d6:d8:55:32:3d:f1:bd:0f:bd:
                    8c:52:95:4a:16:97:7a:52:21:63:75:2f:16:f9:c4:
                    66:be:f5:b5:09:d8:ff:27:00:cd:44:7c:6f:4b:3f:
                    b0:f7
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE, pathlen:0
            X509v3 CRL Distribution Points: 

                Full Name:
                  URI:http://s1.symcb.com/pca3-g5.crl

            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            Authority Information Access: 
                OCSP - URI:http://s2.symcb.com

            X509v3 Certificate Policies: 
                Policy: 2.16.840.1.113733.1.7.54
                  CPS: http://www.symauth.com/cps
                  User Notice:
                    Explicit Text: http://www.symauth.com/rpa

            X509v3 Subject Alternative Name: 
                DirName:/CN=SymantecPKI-1-534
            X509v3 Subject Key Identifier: 
                5F:60:CF:61:90:55:DF:84:43:14:8A:60:2A:B2:F5:7A:F4:43:18:EF
            X509v3 Authority Key Identifier: 
                keyid:7F:D3:65:A7:C2:DD:EC:BB:F0:30:09:F3:43:39:FA:02:AF:33:31:33

    Signature Algorithm: sha256WithRSAEncryption
         5e:94:56:49:dd:8e:2d:65:f5:c1:36:51:b6:03:e3:da:9e:73:
         19:f2:1f:59:ab:58:7e:6c:26:05:2c:fa:81:d7:5c:23:17:22:
         2c:37:93:f7:86:ec:85:e6:b0:a3:fd:1f:e2:32:a8:45:6f:e1:
         d9:fb:b9:af:d2:70:a0:32:42:65:bf:84:fe:16:2a:8f:3f:c5:
         a6:d6:a3:93:7d:43:e9:74:21:91:35:28:f4:63:e9:2e:ed:f7:
         f5:5c:7f:4b:9a:b5:20:e9:0a:bd:e0:45:10:0c:14:94:9a:5d:
         a5:e3:4b:91:e8:24:9b:46:40:65:f4:22:72:cd:99:f8:88:11:
         f5:f3:7f:e6:33:82:e6:a8:c5:7e:fe:d0:08:e2:25:58:08:71:
         68:e6:cd:a2:e6:14:de:4e:52:24:2d:fd:e5:79:13:53:e7:5e:
         2f:2d:4d:1b:6d:40:15:52:2b:f7:87:89:78:12:81:6e:d9:4d:
         aa:2d:78:d4:c2:2c:3d:08:5f:87:91:9e:1f:0e:b0:de:30:52:
         64:86:89:aa:9d:66:9c:0e:76:0c:80:f2:74:d8:2a:f8:b8:3a:
         ce:d7:d6:0f:11:be:6b:ab:14:f5:bd:41:a0:22:63:89:f1:ba:
         0f:6f:29:63:66:2d:3f:ac:8c:72:c5:fb:c7:e4:d4:0f:f2:3b:
         4f:8c:29:c7
-----BEGIN CERTIFICATE-----
MIIFODCCBCCgAwIBAgIQUT+5dDhwtzRAQY0wkwaZ/zANBgkqhkiG9w0BAQsFADCB
yjELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMR8wHQYDVQQL
ExZWZXJpU2lnbiBUcnVzdCBOZXR3b3JrMTowOAYDVQQLEzEoYykgMjAwNiBWZXJp
U2lnbiwgSW5jLiAtIEZvciBhdXRob3JpemVkIHVzZSBvbmx5MUUwQwYDVQQDEzxW
ZXJpU2lnbiBDbGFzcyAzIFB1YmxpYyBQcmltYXJ5IENlcnRpZmljYXRpb24gQXV0
aG9yaXR5IC0gRzUwHhcNMTMxMDMxMDAwMDAwWhcNMjMxMDMwMjM1OTU5WjB+MQsw
CQYDVQQGEwJVUzEdMBsGA1UEChMUU3ltYW50ZWMgQ29ycG9yYXRpb24xHzAdBgNV
BAsTFlN5bWFudGVjIFRydXN0IE5ldHdvcmsxLzAtBgNVBAMTJlN5bWFudGVjIENs
YXNzIDMgU2VjdXJlIFNlcnZlciBDQSAtIEc0MIIBIjANBgkqhkiG9w0BAQEFAAOC
AQ8AMIIBCgKCAQEAstgFyhx0LbUXVjnFSlIJluhL2AzxaJ+aQihiw6UwU35VEYJb
A3oNL+F5BMm0lncZgQGUWfm893qZJ4Itt4PdWid/sgN6nFMl6UgfRk/InSn4vnlW
9vf92Tpo2otLgjNBEsPIPMzWlnqEIRoiBAMnF4scaGGTDw5RgDMdtLXO637QYqzu
s3sBdO9pNevK1T2p7peYyo2qRA4lmUoVlqTObQJUHypqJuIGOmNIrLRM0XWTUP8T
L9ba4cYY9Z/JJV3zADreJk20KQnNDz0jbxZKgRb78oMQw7jW2FUyPfG9D72MUpVK
Fpd6UiFjdS8W+cRmvvW1Cdj/JwDNRHxvSz+w9wIDAQABo4IBYzCCAV8wEgYDVR0T
AQH/BAgwBgEB/wIBADAwBgNVHR8EKTAnMCWgI6Ahhh9odHRwOi8vczEuc3ltY2Iu
Y29tL3BjYTMtZzUuY3JsMA4GA1UdDwEB/wQEAwIBBjAvBggrBgEFBQcBAQQjMCEw
HwYIKwYBBQUHMAGGE2h0dHA6Ly9zMi5zeW1jYi5jb20wawYDVR0gBGQwYjBgBgpg
hkgBhvhFAQc2MFIwJgYIKwYBBQUHAgEWGmh0dHA6Ly93d3cuc3ltYXV0aC5jb20v
Y3BzMCgGCCsGAQUFBwICMBwaGmh0dHA6Ly93d3cuc3ltYXV0aC5jb20vcnBhMCkG
A1UdEQQiMCCkHjAcMRowGAYDVQQDExFTeW1hbnRlY1BLSS0xLTUzNDAdBgNVHQ4E
FgQUX2DPYZBV34RDFIpgKrL1evRDGO8wHwYDVR0jBBgwFoAUf9Nlp8Ld7LvwMAnz
Qzn6Aq8zMTMwDQYJKoZIhvcNAQELBQADggEBAF6UVkndji1l9cE2UbYD49qecxny
H1mrWH5sJgUs+oHXXCMXIiw3k/eG7IXmsKP9H+IyqEVv4dn7ua/ScKAyQmW/hP4W
Ko8/xabWo5N9Q+l0IZE1KPRj6S7t9/Vcf0uatSDpCr3gRRAMFJSaXaXjS5HoJJtG
QGX0InLNmfiIEfXzf+YzguaoxX7+0AjiJVgIcWjmzaLmFN5OUiQt/eV5E1PnXi8t
TRttQBVSK/eHiXgSgW7ZTaoteNTCLD0IX4eRnh8OsN4wUmSGiaqdZpwOdgyA8nTY
Kvi4Os7X1g8RvmurFPW9QaAiY4nxug9vKWNmLT+sjHLF+8fk1A/yO0+MKcc=
-----END CERTIFICATE-----
Verisign Class 3 Public Primary Certification Authority - G3
============================================================
SHA1 Fingerprint=13:2D:0D:45:53:4B:69:97:CD:B2:D5:C3:39:E2:55:76:60:9B:5C:C6
Certificate:
    Data:
        Version: 1 (0x0)
        Serial Number:
            9b:7e:06:49:a3:3e:62:b9:d5:ee:90:48:71:29:ef:57
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=VeriSign, Inc., OU=VeriSign Trust Network, OU=(c) 1999
VeriSign, Inc. - For authorized use only, CN=VeriSign Class 3 Public Primary
Certification Authority - G3
        Validity
            Not Before: Oct  1 00:00:00 1999 GMT
            Not After : Jul 16 23:59:59 2036 GMT
        Subject: C=US, O=VeriSign, Inc., OU=VeriSign Trust Network, OU=(c)
1999 VeriSign, Inc. - For authorized use only, CN=VeriSign Class 3 Public
Primary Certification Authority - G3
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (2048 bit)
                Modulus:
                    00:cb:ba:9c:52:fc:78:1f:1a:1e:6f:1b:37:73:bd:
                    f8:c9:6b:94:12:30:4f:f0:36:47:f5:d0:91:0a:f5:
                    17:c8:a5:61:c1:16:40:4d:fb:8a:61:90:e5:76:20:
                    c1:11:06:7d:ab:2c:6e:a6:f5:11:41:8e:fa:2d:ad:
                    2a:61:59:a4:67:26:4c:d0:e8:bc:52:5b:70:20:04:
                    58:d1:7a:c9:a4:69:bc:83:17:64:ad:05:8b:bc:d0:
                    58:ce:8d:8c:f5:eb:f0:42:49:0b:9d:97:27:67:32:
                    6e:e1:ae:93:15:1c:70:bc:20:4d:2f:18:de:92:88:
                    e8:6c:85:57:11:1a:e9:7e:e3:26:11:54:a2:45:96:
                    55:83:ca:30:89:e8:dc:d8:a3:ed:2a:80:3f:7f:79:
                    65:57:3e:15:20:66:08:2f:95:93:bf:aa:47:2f:a8:
                    46:97:f0:12:e2:fe:c2:0a:2b:51:e6:76:e6:b7:46:
                    b7:e2:0d:a6:cc:a8:c3:4c:59:55:89:e6:e8:53:5c:
                    1c:ea:9d:f0:62:16:0b:a7:c9:5f:0c:f0:de:c2:76:
                    ce:af:f7:6a:f2:fa:41:a6:a2:33:14:c9:e5:7a:63:
                    d3:9e:62:37:d5:85:65:9e:0e:e6:53:24:74:1b:5e:
                    1d:12:53:5b:c7:2c:e7:83:49:3b:15:ae:8a:68:b9:
                    57:97
                Exponent: 65537 (0x10001)
    Signature Algorithm: sha1WithRSAEncryption
        11:14:96:c1:ab:92:08:f7:3f:2f:c9:b2:fe:e4:5a:9f:64:de:
        db:21:4f:86:99:34:76:36:57:dd:d0:15:2f:c5:ad:7f:15:1f:
        37:62:73:3e:d4:e7:5f:ce:17:03:db:35:fa:2b:db:ae:60:09:
        5f:1e:5f:8f:6e:bb:0b:3d:ea:5a:13:1e:0c:60:6f:b5:c0:b5:
        23:22:2e:07:0b:cb:a9:74:cb:47:bb:1d:c1:d7:a5:6b:cc:2f:
        d2:42:fd:49:dd:a7:89:cf:53:ba:da:00:5a:28:bf:82:df:f8:
        ba:13:1d:50:86:82:fd:8e:30:8f:29:46:b0:1e:3d:35:da:38:
        62:16:18:4a:ad:e6:b6:51:6c:de:af:62:eb:01:d0:1e:24:fe:
        7a:8f:12:1a:12:68:b8:fb:66:99:14:14:45:5c:ae:e7:ae:69:
        17:81:2b:5a:37:c9:5e:2a:f4:c6:e2:a1:5c:54:9b:a6:54:00:
        cf:f0:f1:c1:c7:98:30:1a:3b:36:16:db:a3:6e:ea:fd:ad:b2:
        c2:da:ef:02:47:13:8a:c0:f1:b3:31:ad:4f:1c:e1:4f:9c:af:
        0f:0c:9d:f7:78:0d:d8:f4:35:56:80:da:b7:6d:17:8f:9d:1e:
        81:64:e1:fe:c5:45:ba:ad:6b:b9:0a:7a:4e:4f:4b:84:ee:4b:
        f1:7d:dd:11
-----BEGIN CERTIFICATE-----
MIIEGjCCAwICEQCbfgZJoz5iudXukEhxKe9XMA0GCSqGSIb3DQEBBQUAMIHKMQsw
CQYDVQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24sIEluYy4xHzAdBgNVBAsTFlZl
cmlTaWduIFRydXN0IE5ldHdvcmsxOjA4BgNVBAsTMShjKSAxOTk5IFZlcmlTaWdu
LCBJbmMuIC0gRm9yIGF1dGhvcml6ZWQgdXNlIG9ubHkxRTBDBgNVBAMTPFZlcmlT
aWduIENsYXNzIDMgUHVibGljIFByaW1hcnkgQ2VydGlmaWNhdGlvbiBBdXRob3Jp
dHkgLSBHMzAeFw05OTEwMDEwMDAwMDBaFw0zNjA3MTYyMzU5NTlaMIHKMQswCQYD
VQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24sIEluYy4xHzAdBgNVBAsTFlZlcmlT
aWduIFRydXN0IE5ldHdvcmsxOjA4BgNVBAsTMShjKSAxOTk5IFZlcmlTaWduLCBJ
bmMuIC0gRm9yIGF1dGhvcml6ZWQgdXNlIG9ubHkxRTBDBgNVBAMTPFZlcmlTaWdu
IENsYXNzIDMgUHVibGljIFByaW1hcnkgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkg
LSBHMzCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAMu6nFL8eB8aHm8b
N3O9+MlrlBIwT/A2R/XQkQr1F8ilYcEWQE37imGQ5XYgwREGfassbqb1EUGO+i2t
KmFZpGcmTNDovFJbcCAEWNF6yaRpvIMXZK0Fi7zQWM6NjPXr8EJJC52XJ2cybuGu
kxUccLwgTS8Y3pKI6GyFVxEa6X7jJhFUokWWVYPKMIno3Nij7SqAP395ZVc+FSBm
CC+Vk7+qRy+oRpfwEuL+wgorUeZ25rdGt+INpsyow0xZVYnm6FNcHOqd8GIWC6fJ
Xwzw3sJ2zq/3avL6QaaiMxTJ5Xpj055iN9WFZZ4O5lMkdBteHRJTW8cs54NJOxWu
imi5V5cCAwEAATANBgkqhkiG9w0BAQUFAAOCAQEAERSWwauSCPc/L8my/uRan2Te
2yFPhpk0djZX3dAVL8WtfxUfN2JzPtTnX84XA9s1+ivbrmAJXx5fj267Cz3qWhMe
DGBvtcC1IyIuBwvLqXTLR7sdwdela8wv0kL9Sd2nic9TutoAWii/gt/4uhMdUIaC
/Y4wjylGsB49Ndo4YhYYSq3mtlFs3q9i6wHQHiT+eo8SGhJouPtmmRQURVyu565p
F4ErWjfJXir0xuKhXFSbplQAz/DxwceYMBo7Nhbbo27q/a2ywtrvAkcTisDxszGt
TxzhT5yvDwyd93gN2PQ1VoDat20Xj50egWTh/sVFuq1ruQp6Tk9LhO5L8X3dEQ==
-----END CERTIFICATE-----
SHA1 Fingerprint=32:DF:D3:55:74:D8:81:1B:B9:0E:BE:33:84:6D:D3:A0:B9:45:E0:D9
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            ee:a1:92:ae:97:01:d2:af:03:92:0c:02:3d:c4:f7:93
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=MasterCard Worldwide, OU=MasterCard Worldwide SecureCode Gen 2, CN=PRD MC SecureCode Root CA
        Validity
            Not Before: Jun 22 09:08:30 2012 GMT
            Not After : Jun 22 09:08:31 2025 GMT
        Subject: C=US, O=MasterCard Worldwide, OU=MasterCard Worldwide SecureCode Gen 2, CN=PRD MC SecureCode Root CA
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:e9:b4:29:ac:e9:a2:36:d9:3f:52:4f:ad:24:e3:
                    ce:d2:64:fd:3a:4c:a6:d4:06:9a:26:ed:9d:41:a3:
                    c7:10:40:01:3f:b4:ce:54:3a:dd:d3:1c:c7:6b:85:
                    3f:b6:68:89:23:f5:3d:29:03:7e:48:c8:d3:02:34:
                    60:ed:f9:e8:e1:cb:bb:47:77:0d:6b:e9:e0:d7:fc:
                    a5:d8:1d:be:05:95:e9:98:d3:70:f0:46:b9:10:48:
                    7f:cb:f9:9b:9e:4b:97:42:7c:b3:37:9b:66:b3:c4:
                    15:ed:ad:55:c3:74:d7:9b:7e:1b:7c:b5:c5:91:2c:
                    ad:8e:bb:ab:e3:0f:37:48:ce:e9:ee:59:16:7a:91:
                    10:d0:ea:87:35:2d:25:4e:d8:1c:62:14:ed:13:2a:
                    8c:09:3f:f3:3b:a9:64:53:fc:9b:26:6f:a4:c6:83:
                    4b:e6:99:01:bd:40:4a:66:56:63:99:21:ec:55:c6:
                    e6:32:de:b9:fb:80:46:d5:d6:db:f7:93:86:86:d1:
                    44:8c:a7:65:ea:fd:77:b8:a9:ef:88:af:bb:05:a9:
                    1e:7a:1b:8c:8a:7b:34:95:2d:4c:d0:68:80:7f:75:
                    e7:82:93:d5:94:d9:3d:17:9a:27:00:11:80:c1:42:
                    87:9c:a1:2e:b5:47:89:e3:e4:e0:e6:cf:09:86:cb:
                    1a:e5
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: 
                CA:TRUE, pathlen:1
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Subject Key Identifier: 
                2A:15:37:31:54:33:BF:BB:12:35:86:91:45:DD:54:92:4C:53:06:BA
    Signature Algorithm: sha1WithRSAEncryption
        84:33:90:e7:35:17:db:00:72:56:fd:02:aa:46:b7:79:b9:e6:
        ff:ac:51:cd:04:1b:59:e9:73:9d:e0:d4:35:57:5c:b6:7d:67:
        84:9b:76:3c:ad:6e:19:5e:d1:04:60:06:ba:48:1d:02:e6:f0:
        c2:70:61:0f:61:5d:6e:10:47:4d:56:e9:2c:f6:31:05:b7:4c:
        03:27:82:f1:ec:da:5c:68:ab:5c:e0:00:bf:46:1b:1a:13:e5:
        d4:c5:05:88:39:aa:4a:58:9a:bc:11:54:b3:87:04:b8:12:1a:
        b3:80:54:a1:9e:45:cf:4e:36:74:34:80:59:f7:db:75:fd:e5:
        e3:3a:d4:e4:bc:e8:97:dd:f2:5f:1c:48:8e:a8:08:b1:3d:d0:
        23:eb:11:33:78:20:fc:67:70:a3:cd:03:51:0d:9f:45:f7:ec:
        19:d0:14:1f:60:bf:f0:bf:3f:c0:7f:84:f4:7b:29:8c:c0:e4:
        5e:56:68:84:f2:08:d3:1b:4a:85:d2:0f:5b:36:ce:07:a0:ce:
        50:b9:76:3e:47:46:1e:62:5c:e1:55:f1:7c:ec:04:d8:d2:40:
        43:19:a8:68:f4:43:60:68:0e:15:5b:e4:cd:8b:72:c5:59:31:
        5d:e5:c0:3c:db:7c:51:14:77:8d:f5:af:62:b0:46:1f:60:f9:
        03:8e:00:b6
-----BEGIN CERTIFICATE-----
MIIDzzCCAregAwIBAgIRAO6hkq6XAdKvA5IMAj3E95MwDQYJKoZIhvcNAQEFBQAw
gYAxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRNYXN0ZXJDYXJkIFdvcmxkd2lkZTEu
MCwGA1UECxMlTWFzdGVyQ2FyZCBXb3JsZHdpZGUgU2VjdXJlQ29kZSBHZW4gMjEi
MCAGA1UEAxMZUFJEIE1DIFNlY3VyZUNvZGUgUm9vdCBDQTAeFw0xMjA2MjIwOTA4
MzBaFw0yNTA2MjIwOTA4MzFaMIGAMQswCQYDVQQGEwJVUzEdMBsGA1UEChMUTWFz
dGVyQ2FyZCBXb3JsZHdpZGUxLjAsBgNVBAsTJU1hc3RlckNhcmQgV29ybGR3aWRl
IFNlY3VyZUNvZGUgR2VuIDIxIjAgBgNVBAMTGVBSRCBNQyBTZWN1cmVDb2RlIFJv
b3QgQ0EwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDptCms6aI22T9S
T60k487SZP06TKbUBpom7Z1Bo8cQQAE/tM5UOt3THMdrhT+2aIkj9T0pA35IyNMC
NGDt+ejhy7tHdw1r6eDX/KXYHb4FlemY03DwRrkQSH/L+ZueS5dCfLM3m2azxBXt
rVXDdNebfht8tcWRLK2Ou6vjDzdIzunuWRZ6kRDQ6oc1LSVO2BxiFO0TKowJP/M7
qWRT/Jsmb6TGg0vmmQG9QEpmVmOZIexVxuYy3rn7gEbV1tv3k4aG0USMp2Xq/Xe4
qe+Ir7sFqR56G4yKezSVLUzQaIB/deeCk9WU2T0XmicAEYDBQoecoS61R4nj5ODm
zwmGyxrlAgMBAAGjQjBAMA8GA1UdEwQIMAYBAf8CAQEwDgYDVR0PAQH/BAQDAgEG
MB0GA1UdDgQWBBQqFTcxVDO/uxI1hpFF3VSSTFMGujANBgkqhkiG9w0BAQUFAAOC
AQEAhDOQ5zUX2wByVv0Cqka3ebnm/6xRzQQbWelzneDUNVdctn1nhJt2PK1uGV7R
BGAGukgdAubwwnBhD2FdbhBHTVbpLPYxBbdMAyeC8ezaXGirXOAAv0YbGhPl1MUF
iDmqSliavBFUs4cEuBIas4BUoZ5Fz042dDSAWffbdf3l4zrU5Lzol93yXxxIjqgI
sT3QI+sRM3gg/Gdwo80DUQ2fRffsGdAUH2C/8L8/wH+E9HspjMDkXlZohPII0xtK
hdIPWzbOB6DOULl2PkdGHmJc4VXxfOwE2NJAQxmoaPRDYGgOFVvkzYtyxVkxXeXA
PNt8URR3jfWvYrBGH2D5A44Atg==
-----END CERTIFICATE-----
SHA1 Fingerprint=E0:AB:05:94:20:72:54:93:05:60:62:02:36:70:F7:CD:2E:FC:66:66
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            36:12:22:96:c5:e3:38:a5:20:a1:d2:5f:4c:d7:09:54
        Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=ZA, ST=Western Cape, L=Cape Town, O=Thawte Consulting cc, OU=Certification Services Division, CN=Thawte Premium Server CA/emailAddress=premium-server@thawte.com
        Validity
            Not Before: Aug  1 00:00:00 1996 GMT
            Not After : Jan  1 23:59:59 2021 GMT
        Subject: C=ZA, ST=Western Cape, L=Cape Town, O=Thawte Consulting cc, OU=Certification Services Division, CN=Thawte Premium Server CA/emailAddress=premium-server@thawte.com
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (1024 bit)
                Modulus (1024 bit):
                    00:d2:36:36:6a:8b:d7:c2:5b:9e:da:81:41:62:8f:
                    38:ee:49:04:55:d6:d0:ef:1c:1b:95:16:47:ef:18:
                    48:35:3a:52:f4:2b:6a:06:8f:3b:2f:ea:56:e3:af:
                    86:8d:9e:17:f7:9e:b4:65:75:02:4d:ef:cb:09:a2:
                    21:51:d8:9b:d0:67:d0:ba:0d:92:06:14:73:d4:93:
                    cb:97:2a:00:9c:5c:4e:0c:bc:fa:15:52:fc:f2:44:
                    6e:da:11:4a:6e:08:9f:2f:2d:e3:f9:aa:3a:86:73:
                    b6:46:53:58:c8:89:05:bd:83:11:b8:73:3f:aa:07:
                    8d:f4:42:4d:e7:40:9d:1c:37
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
    Signature Algorithm: sha1WithRSAEncryption
        65:90:ac:88:0f:56:d9:e6:30:34:d4:26:c7:d0:50:f1:92:de:
        6b:d4:39:88:09:22:c6:a6:63:83:03:f7:99:77:d8:b2:e5:18:
        b8:5d:63:f3:d4:73:fb:6c:9c:99:78:f1:4b:78:7d:19:24:c3:
        2b:02:84:f8:bc:22:d9:8a:22:d7:a0:fc:71:ec:91:87:20:f1:
        b8:ec:b1:e5:55:80:ac:3d:52:c8:39:0e:c2:f0:c0:05:4f:d6:
        82:75:8c:bd:5f:d2:dc:76:9a:05:12:c9:af:72:c3:dc:25:7e:
        a4:4d:8e:17:a5:e0:87:7f:e1:9a:5a:e1:60:dc:64:23:3c:42:
        2e:4d
-----BEGIN CERTIFICATE-----
MIIDNjCCAp+gAwIBAgIQNhIilsXjOKUgodJfTNcJVDANBgkqhkiG9w0BAQUFADCB
zjELMAkGA1UEBhMCWkExFTATBgNVBAgTDFdlc3Rlcm4gQ2FwZTESMBAGA1UEBxMJ
Q2FwZSBUb3duMR0wGwYDVQQKExRUaGF3dGUgQ29uc3VsdGluZyBjYzEoMCYGA1UE
CxMfQ2VydGlmaWNhdGlvbiBTZXJ2aWNlcyBEaXZpc2lvbjEhMB8GA1UEAxMYVGhh
d3RlIFByZW1pdW0gU2VydmVyIENBMSgwJgYJKoZIhvcNAQkBFhlwcmVtaXVtLXNl
cnZlckB0aGF3dGUuY29tMB4XDTk2MDgwMTAwMDAwMFoXDTIxMDEwMTIzNTk1OVow
gc4xCzAJBgNVBAYTAlpBMRUwEwYDVQQIEwxXZXN0ZXJuIENhcGUxEjAQBgNVBAcT
CUNhcGUgVG93bjEdMBsGA1UEChMUVGhhd3RlIENvbnN1bHRpbmcgY2MxKDAmBgNV
BAsTH0NlcnRpZmljYXRpb24gU2VydmljZXMgRGl2aXNpb24xITAfBgNVBAMTGFRo
YXd0ZSBQcmVtaXVtIFNlcnZlciBDQTEoMCYGCSqGSIb3DQEJARYZcHJlbWl1bS1z
ZXJ2ZXJAdGhhd3RlLmNvbTCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEA0jY2
aovXwlue2oFBYo847kkEVdbQ7xwblRZH7xhINTpS9CtqBo87L+pW46+GjZ4X9560
ZXUCTe/LCaIhUdib0GfQug2SBhRz1JPLlyoAnFxODLz6FVL88kRu2hFKbgifLy3j
+ao6hnO2RlNYyIkFvYMRuHM/qgeN9EJN50CdHDcCAwEAAaMTMBEwDwYDVR0TAQH/
BAUwAwEB/zANBgkqhkiG9w0BAQUFAAOBgQBlkKyID1bZ5jA01CbH0FDxkt5r1DmI
CSLGpmODA/eZd9iy5Ri4XWPz1HP7bJyZePFLeH0ZJMMrAoT4vCLZiiLXoPxx7JGH
IPG47LHlVYCsPVLIOQ7C8MAFT9aCdYy9X9LcdpoFEsmvcsPcJX6kTY4XpeCHf+Ga
WuFg3GQjPEIuTQ==
-----END CERTIFICATE-----
SHA1 Fingerprint=8C:F4:27:FD:79:0C:3A:D1:66:06:8D:E8:1E:57:EF:BB:93:22:72:D4
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 1246989352 (0x4a538c28)
        Signature Algorithm: sha256WithRSAEncryption
        Issuer: C=US, O=Entrust, Inc., OU=See www.entrust.net/legal-terms, OU=(c) 2009 Entrust, Inc. - for authorized use only, CN=Entrust Root Certification Authority - G2
        Validity
            Not Before: Jul  7 17:25:54 2009 GMT
            Not After : Dec  7 17:55:54 2030 GMT
        Subject: C=US, O=Entrust, Inc., OU=See www.entrust.net/legal-terms, OU=(c) 2009 Entrust, Inc. - for authorized use only, CN=Entrust Root Certification Authority - G2
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:ba:84:b6:72:db:9e:0c:6b:e2:99:e9:30:01:a7:
                    76:ea:32:b8:95:41:1a:c9:da:61:4e:58:72:cf:fe:
                    f6:82:79:bf:73:61:06:0a:a5:27:d8:b3:5f:d3:45:
                    4e:1c:72:d6:4e:32:f2:72:8a:0f:f7:83:19:d0:6a:
                    80:80:00:45:1e:b0:c7:e7:9a:bf:12:57:27:1c:a3:
                    68:2f:0a:87:bd:6a:6b:0e:5e:65:f3:1c:77:d5:d4:
                    85:8d:70:21:b4:b3:32:e7:8b:a2:d5:86:39:02:b1:
                    b8:d2:47:ce:e4:c9:49:c4:3b:a7:de:fb:54:7d:57:
                    be:f0:e8:6e:c2:79:b2:3a:0b:55:e2:50:98:16:32:
                    13:5c:2f:78:56:c1:c2:94:b3:f2:5a:e4:27:9a:9f:
                    24:d7:c6:ec:d0:9b:25:82:e3:cc:c2:c4:45:c5:8c:
                    97:7a:06:6b:2a:11:9f:a9:0a:6e:48:3b:6f:db:d4:
                    11:19:42:f7:8f:07:bf:f5:53:5f:9c:3e:f4:17:2c:
                    e6:69:ac:4e:32:4c:62:77:ea:b7:e8:e5:bb:34:bc:
                    19:8b:ae:9c:51:e7:b7:7e:b5:53:b1:33:22:e5:6d:
                    cf:70:3c:1a:fa:e2:9b:67:b6:83:f4:8d:a5:af:62:
                    4c:4d:e0:58:ac:64:34:12:03:f8:b6:8d:94:63:24:
                    a4:71
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Subject Key Identifier: 
                6A:72:26:7A:D0:1E:EF:7D:E7:3B:69:51:D4:6C:8D:9F:90:12:66:AB
    Signature Algorithm: sha256WithRSAEncryption
        79:9f:1d:96:c6:b6:79:3f:22:8d:87:d3:87:03:04:60:6a:6b:
        9a:2e:59:89:73:11:ac:43:d1:f5:13:ff:8d:39:2b:c0:f2:bd:
        4f:70:8c:a9:2f:ea:17:c4:0b:54:9e:d4:1b:96:98:33:3c:a8:
        ad:62:a2:00:76:ab:59:69:6e:06:1d:7e:c4:b9:44:8d:98:af:
        12:d4:61:db:0a:19:46:47:f3:eb:f7:63:c1:40:05:40:a5:d2:
        b7:f4:b5:9a:36:bf:a9:88:76:88:04:55:04:2b:9c:87:7f:1a:
        37:3c:7e:2d:a5:1a:d8:d4:89:5e:ca:bd:ac:3d:6c:d8:6d:af:
        d5:f3:76:0f:cd:3b:88:38:22:9d:6c:93:9a:c4:3d:bf:82:1b:
        65:3f:a6:0f:5d:aa:fc:e5:b2:15:ca:b5:ad:c6:bc:3d:d0:84:
        e8:ea:06:72:b0:4d:39:32:78:bf:3e:11:9c:0b:a4:9d:9a:21:
        f3:f0:9b:0b:30:78:db:c1:dc:87:43:fe:bc:63:9a:ca:c5:c2:
        1c:c9:c7:8d:ff:3b:12:58:08:e6:b6:3d:ec:7a:2c:4e:fb:83:
        96:ce:0c:3c:69:87:54:73:a4:73:c2:93:ff:51:10:ac:15:54:
        01:d8:fc:05:b1:89:a1:7f:74:83:9a:49:d7:dc:4e:7b:8a:48:
        6f:8b:45:f6
-----BEGIN CERTIFICATE-----
MIIEPjCCAyagAwIBAgIESlOMKDANBgkqhkiG9w0BAQsFADCBvjELMAkGA1UEBhMC
VVMxFjAUBgNVBAoTDUVudHJ1c3QsIEluYy4xKDAmBgNVBAsTH1NlZSB3d3cuZW50
cnVzdC5uZXQvbGVnYWwtdGVybXMxOTA3BgNVBAsTMChjKSAyMDA5IEVudHJ1c3Qs
IEluYy4gLSBmb3IgYXV0aG9yaXplZCB1c2Ugb25seTEyMDAGA1UEAxMpRW50cnVz
dCBSb290IENlcnRpZmljYXRpb24gQXV0aG9yaXR5IC0gRzIwHhcNMDkwNzA3MTcy
NTU0WhcNMzAxMjA3MTc1NTU0WjCBvjELMAkGA1UEBhMCVVMxFjAUBgNVBAoTDUVu
dHJ1c3QsIEluYy4xKDAmBgNVBAsTH1NlZSB3d3cuZW50cnVzdC5uZXQvbGVnYWwt
dGVybXMxOTA3BgNVBAsTMChjKSAyMDA5IEVudHJ1c3QsIEluYy4gLSBmb3IgYXV0
aG9yaXplZCB1c2Ugb25seTEyMDAGA1UEAxMpRW50cnVzdCBSb290IENlcnRpZmlj
YXRpb24gQXV0aG9yaXR5IC0gRzIwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEK
AoIBAQC6hLZy254Ma+KZ6TABp3bqMriVQRrJ2mFOWHLP/vaCeb9zYQYKpSfYs1/T
RU4cctZOMvJyig/3gxnQaoCAAEUesMfnmr8SVycco2gvCoe9amsOXmXzHHfV1IWN
cCG0szLni6LVhjkCsbjSR87kyUnEO6fe+1R9V77w6G7CebI6C1XiUJgWMhNcL3hW
wcKUs/Ja5CeanyTXxuzQmyWC48zCxEXFjJd6BmsqEZ+pCm5IO2/b1BEZQvePB7/1
U1+cPvQXLOZprE4yTGJ36rfo5bs0vBmLrpxR57d+tVOxMyLlbc9wPBr64ptntoP0
jaWvYkxN4FisZDQSA/i2jZRjJKRxAgMBAAGjQjBAMA4GA1UdDwEB/wQEAwIBBjAP
BgNVHRMBAf8EBTADAQH/MB0GA1UdDgQWBBRqciZ60B7vfec7aVHUbI2fkBJmqzAN
BgkqhkiG9w0BAQsFAAOCAQEAeZ8dlsa2eT8ijYfThwMEYGprmi5ZiXMRrEPR9RP/
jTkrwPK9T3CMqS/qF8QLVJ7UG5aYMzyorWKiAHarWWluBh1+xLlEjZivEtRh2woZ
Rkfz6/djwUAFQKXSt/S1mja/qYh2iARVBCuch38aNzx+LaUa2NSJXsq9rD1s2G2v
1fN2D807iDginWyTmsQ9v4IbZT+mD12q/OWyFcq1rca8PdCE6OoGcrBNOTJ4vz4R
nAuknZoh8/CbCzB428Hch0P+vGOaysXCHMnHjf87ElgI5rY97HosTvuDls4MPGmH
VHOkc8KT/1EQrBVUAdj8BbGJoX90g5pJ19xOe4pIb4tF9g==
-----END CERTIFICATE-----
SHA1 Fingerprint=0E:34:14:18:46:E7:42:3D:37:F2:0D:C0:AB:06:C9:BB:D8:43:DC:24
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 146039 (0x23a77)
        Signature Algorithm: sha256WithRSAEncryption
        Issuer: C=US, O=GeoTrust Inc., CN=GeoTrust Global CA
        Validity
            Not Before: Aug 29 21:39:32 2014 GMT
            Not After : May 20 21:39:32 2022 GMT
        Subject: C=US, O=GeoTrust Inc., CN=RapidSSL SHA256 CA - G3
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
            RSA Public Key: (2048 bit)
                Modulus (2048 bit):
                    00:af:54:9b:d9:58:5d:1e:2c:56:c6:d5:e8:7f:f4:
                    7d:16:03:ff:d0:8b:5a:e4:8e:a7:dd:54:2e:d4:04:
                    c0:5d:98:9c:8d:90:0f:bc:10:65:5f:da:9a:d6:44:
                    7c:c0:9f:b5:e9:4a:8c:0b:06:43:04:bb:f4:96:e2:
                    26:f6:61:01:91:66:31:22:c3:34:34:5f:3f:3f:91:
                    2f:44:5f:dc:c7:14:b6:03:9f:86:4b:0e:a3:ff:a0:
                    80:02:83:c3:d3:1f:69:52:d6:9d:64:0f:c9:83:e7:
                    1b:c4:70:ac:94:e7:c3:a4:6a:2c:bd:b8:9e:69:d8:
                    be:0a:8f:16:63:5a:68:71:80:7b:30:de:15:04:bf:
                    cc:d3:bf:3e:48:05:55:7a:b3:d7:10:0c:03:fc:9b:
                    fd:08:a7:8c:8c:db:a7:8e:f1:1e:63:dc:b3:01:2f:
                    7f:af:57:c3:3c:48:a7:83:68:21:a7:2f:e7:a7:3f:
                    f0:b5:0c:fc:f5:84:d1:53:bc:0e:72:4f:60:0c:42:
                    b8:98:ad:19:88:57:d7:04:ec:87:bf:7e:87:4e:a3:
                    21:f9:53:fd:36:98:48:8d:d6:f8:bb:48:f2:29:c8:
                    64:d1:cc:54:48:53:8b:af:b7:65:1e:bf:29:33:29:
                    d9:29:60:48:f8:ff:91:bc:57:58:e5:35:2e:bb:69:
                    b6:59
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Authority Key Identifier: 
                keyid:C0:7A:98:68:8D:89:FB:AB:05:64:0C:11:7D:AA:7D:65:B8:CA:CC:4E

            X509v3 Subject Key Identifier: 
                C3:9C:F3:FC:D3:46:08:34:BB:CE:46:7F:A0:7C:5B:F3:E2:08:CB:59
            X509v3 Basic Constraints: critical
                CA:TRUE, pathlen:0
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 CRL Distribution Points: 
                URI:http://g.symcb.com/crls/gtglobal.crl

            Authority Information Access: 
                OCSP - URI:http://g.symcd.com

            X509v3 Certificate Policies: 
                Policy: 2.16.840.1.113733.1.7.54
                  CPS: http://www.geotrust.com/resources/cps

    Signature Algorithm: sha256WithRSAEncryption
        a3:58:1e:c6:43:32:ac:ac:2f:93:78:b7:ea:ae:54:40:47:2d:
        7e:78:8d:50:f6:f8:66:ac:d6:4f:73:d6:44:ef:af:0b:cc:5b:
        c1:f4:4f:9a:8f:49:7e:60:af:c2:27:c7:16:f1:fb:93:81:90:
        a9:7c:ef:6f:7e:6e:45:94:16:84:bd:ec:49:f1:c4:0e:f4:af:
        04:59:83:87:0f:2c:3b:97:c3:5a:12:9b:7b:04:35:7b:a3:95:
        33:08:7b:93:71:22:42:b3:a9:d9:6f:4f:81:92:fc:07:b6:79:
        bc:84:4a:9d:77:09:f1:c5:89:f2:f0:b4:9c:54:aa:12:7b:0d:
        ba:4f:ef:93:19:ec:ef:7d:4e:61:a3:8e:76:9c:59:cf:8c:94:
        b1:84:97:f7:1a:b9:07:b8:b2:c6:4f:13:79:db:bf:4f:51:1b:
        7f:69:0d:51:2a:c1:d6:15:ff:37:51:34:65:51:f4:1e:be:38:
        6a:ec:0e:ab:bf:3d:7b:39:05:7b:f4:f3:fb:1a:a1:d0:c8:7e:
        4e:64:8d:cd:8c:61:55:90:fe:3a:ca:5d:25:0f:f8:1d:a3:4a:
        74:56:4f:1a:55:40:70:75:25:a6:33:2e:ba:4b:a5:5d:53:9a:
        0d:30:e1:8d:5f:61:2c:af:cc:ef:b0:99:a1:80:ff:0b:f2:62:
        4c:70:26:98
-----BEGIN CERTIFICATE-----
MIIEJTCCAw2gAwIBAgIDAjp3MA0GCSqGSIb3DQEBCwUAMEIxCzAJBgNVBAYTAlVT
MRYwFAYDVQQKEw1HZW9UcnVzdCBJbmMuMRswGQYDVQQDExJHZW9UcnVzdCBHbG9i
YWwgQ0EwHhcNMTQwODI5MjEzOTMyWhcNMjIwNTIwMjEzOTMyWjBHMQswCQYDVQQG
EwJVUzEWMBQGA1UEChMNR2VvVHJ1c3QgSW5jLjEgMB4GA1UEAxMXUmFwaWRTU0wg
U0hBMjU2IENBIC0gRzMwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCv
VJvZWF0eLFbG1eh/9H0WA//Qi1rkjqfdVC7UBMBdmJyNkA+8EGVf2prWRHzAn7Xp
SowLBkMEu/SW4ib2YQGRZjEiwzQ0Xz8/kS9EX9zHFLYDn4ZLDqP/oIACg8PTH2lS
1p1kD8mD5xvEcKyU58Okaiy9uJ5p2L4KjxZjWmhxgHsw3hUEv8zTvz5IBVV6s9cQ
DAP8m/0Ip4yM26eO8R5j3LMBL3+vV8M8SKeDaCGnL+enP/C1DPz1hNFTvA5yT2AM
QriYrRmIV9cE7Ie/fodOoyH5U/02mEiN1vi7SPIpyGTRzFRIU4uvt2UevykzKdkp
YEj4/5G8V1jlNS67abZZAgMBAAGjggEdMIIBGTAfBgNVHSMEGDAWgBTAephojYn7
qwVkDBF9qn1luMrMTjAdBgNVHQ4EFgQUw5zz/NNGCDS7zkZ/oHxb8+IIy1kwEgYD
VR0TAQH/BAgwBgEB/wIBADAOBgNVHQ8BAf8EBAMCAQYwNQYDVR0fBC4wLDAqoCig
JoYkaHR0cDovL2cuc3ltY2IuY29tL2NybHMvZ3RnbG9iYWwuY3JsMC4GCCsGAQUF
BwEBBCIwIDAeBggrBgEFBQcwAYYSaHR0cDovL2cuc3ltY2QuY29tMEwGA1UdIARF
MEMwQQYKYIZIAYb4RQEHNjAzMDEGCCsGAQUFBwIBFiVodHRwOi8vd3d3Lmdlb3Ry
dXN0LmNvbS9yZXNvdXJjZXMvY3BzMA0GCSqGSIb3DQEBCwUAA4IBAQCjWB7GQzKs
rC+TeLfqrlRARy1+eI1Q9vhmrNZPc9ZE768LzFvB9E+aj0l+YK/CJ8cW8fuTgZCp
fO9vfm5FlBaEvexJ8cQO9K8EWYOHDyw7l8NaEpt7BDV7o5UzCHuTcSJCs6nZb0+B
kvwHtnm8hEqddwnxxYny8LScVKoSew26T++TGezvfU5ho452nFnPjJSxhJf3GrkH
uLLGTxN5279PURt/aQ1RKsHWFf83UTRlUfQevjhq7A6rvz17OQV79PP7GqHQyH5O
ZI3NjGFVkP46yl0lD/gdo0p0Vk8aVUBwdSWmMy66S6VdU5oNMOGNX2Esr8zvsJmh
gP8L8mJMcCaY
-----END CERTIFICATE-----

Sonera Class 1 Root CA
======================
SHA1 Fingerprint=07:47:22:01:99:CE:74:B9:7C:B0:3D:79:B2:64:A2:C8:55:E9:33:FF
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 36 (0x24)
    Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=FI, O=Sonera, CN=Sonera Class1 CA
        Validity
            Not Before: Apr  6 10:49:13 2001 GMT
            Not After : Apr  6 10:49:13 2021 GMT
        Subject: C=FI, O=Sonera, CN=Sonera Class1 CA
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (2048 bit)
                Modulus:
                    00:b5:89:1f:2b:4f:67:0a:79:ff:c5:1e:f8:7f:3c:
                    ed:d1:7e:da:b0:cd:6d:2f:36:ac:34:c6:db:d9:64:
                    17:08:63:30:33:22:8a:4c:ee:8e:bb:0f:0d:42:55:
                    c9:9d:2e:a5:ef:f7:a7:8c:c3:ab:b9:97:cb:8e:ef:
                    3f:15:67:a8:82:72:63:53:0f:41:8c:7d:10:95:24:
                    a1:5a:a5:06:fa:92:57:9d:fa:a5:01:f2:75:e9:1f:
                    bc:56:26:52:4e:78:19:65:58:55:03:58:c0:14:ae:
                    8c:7c:55:5f:70:5b:77:23:06:36:97:f3:24:b5:9a:
                    46:95:e4:df:0d:0b:05:45:e5:d1:f2:1d:82:bb:c6:
                    13:e0:fe:aa:7a:fd:69:30:94:f3:d2:45:85:fc:f2:
                    32:5b:32:de:e8:6c:5d:1f:cb:a4:22:74:b0:80:8e:
                    5d:94:f7:06:00:4b:a9:d4:5e:2e:35:50:09:f3:80:
                    97:f4:0c:17:ae:39:d8:5f:cd:33:c1:1c:ca:89:c2:
                    22:f7:45:12:ed:5e:12:93:9d:63:ab:82:2e:b9:eb:
                    42:41:44:cb:4a:1a:00:82:0d:9e:f9:8b:57:3e:4c:
                    c7:17:ed:2c:8b:72:33:5f:72:7a:38:56:d5:e6:d9:
                    ae:05:1a:1d:75:45:b1:cb:a5:25:1c:12:57:36:fd:
                    22:37
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Subject Key Identifier:
                47:E2:0C:8B:F6:53:88:52
            X509v3 Key Usage:
                Certificate Sign, CRL Sign
    Signature Algorithm: sha1WithRSAEncryption
         8b:1a:b2:c9:5d:61:b4:e1:b9:2b:b9:53:d1:b2:85:9d:77:8e:
         16:ee:11:3d:db:c2:63:d9:5b:97:65:fb:12:67:d8:2a:5c:b6:
         ab:e5:5e:c3:b7:16:2f:c8:e8:ab:1d:8a:fd:ab:1a:7c:d5:5f:
         63:cf:dc:b0:dd:77:b9:a8:e6:d2:22:38:87:07:14:d9:ff:be:
         56:b5:fd:07:0e:3c:55:ca:16:cc:a7:a6:77:37:fb:db:5c:1f:
         4e:59:06:87:a3:03:43:f5:16:ab:b7:84:bd:4e:ef:9f:31:37:
         f0:46:f1:40:b6:d1:0c:a5:64:f8:63:5e:21:db:55:4e:4f:31:
         76:9c:10:61:8e:b6:53:3a:a3:11:be:af:6d:7c:1e:bd:ae:2d:
         e2:0c:69:c7:85:53:68:a2:61:ba:c5:3e:b4:79:54:78:9e:0a:
         c7:02:be:62:d1:11:82:4b:65:2f:91:5a:c2:a8:87:b1:56:68:
         94:79:f9:25:f7:c1:d5:ae:1a:b8:bb:3d:8f:a9:8a:38:15:f7:
         73:d0:5a:60:d1:80:b0:f0:dc:d5:50:cd:4e:ee:92:48:69:ed:
         b2:23:1e:30:cc:c8:94:c8:b6:f5:3b:86:7f:3f:a6:2e:9f:f6:
         3e:2c:b5:92:96:3e:df:2c:93:8a:ff:81:8c:0f:0f:59:21:19:
         57:bd:55:9a
-----BEGIN CERTIFICATE-----
MIIDIDCCAgigAwIBAgIBJDANBgkqhkiG9w0BAQUFADA5MQswCQYDVQQGEwJGSTEP
MA0GA1UEChMGU29uZXJhMRkwFwYDVQQDExBTb25lcmEgQ2xhc3MxIENBMB4XDTAx
MDQwNjEwNDkxM1oXDTIxMDQwNjEwNDkxM1owOTELMAkGA1UEBhMCRkkxDzANBgNV
BAoTBlNvbmVyYTEZMBcGA1UEAxMQU29uZXJhIENsYXNzMSBDQTCCASIwDQYJKoZI
hvcNAQEBBQADggEPADCCAQoCggEBALWJHytPZwp5/8Ue+H887dF+2rDNbS82rDTG
29lkFwhjMDMiikzujrsPDUJVyZ0upe/3p4zDq7mXy47vPxVnqIJyY1MPQYx9EJUk
oVqlBvqSV536pQHydekfvFYmUk54GWVYVQNYwBSujHxVX3BbdyMGNpfzJLWaRpXk
3w0LBUXl0fIdgrvGE+D+qnr9aTCU89JFhfzyMlsy3uhsXR/LpCJ0sICOXZT3BgBL
qdReLjVQCfOAl/QMF6452F/NM8EcyonCIvdFEu1eEpOdY6uCLrnrQkFEy0oaAIIN
nvmLVz5MxxftLItyM19yejhW1ebZrgUaHXVFsculJRwSVzb9IjcCAwEAAaMzMDEw
DwYDVR0TAQH/BAUwAwEB/zARBgNVHQ4ECgQIR+IMi/ZTiFIwCwYDVR0PBAQDAgEG
MA0GCSqGSIb3DQEBBQUAA4IBAQCLGrLJXWG04bkruVPRsoWdd44W7hE928Jj2VuX
ZfsSZ9gqXLar5V7DtxYvyOirHYr9qxp81V9jz9yw3Xe5qObSIjiHBxTZ/75Wtf0H
DjxVyhbMp6Z3N/vbXB9OWQaHowND9Rart4S9Tu+fMTfwRvFAttEMpWT4Y14h21VO
TzF2nBBhjrZTOqMRvq9tfB69ri3iDGnHhVNoomG6xT60eVR4ngrHAr5i0RGCS2Uv
kVrCqIexVmiUefkl98HVrhq4uz2PqYo4Ffdz0Fpg0YCw8NzVUM1O7pJIae2yIx4w
zMiUyLb1O4Z/P6Yun/Y+LLWSlj7fLJOK/4GMDw9ZIRlXvVWa
-----END CERTIFICATE-----

S-TRUST Universal Root CA
=========================
SHA1 Fingerprint=1B:3D:11:14:EA:7A:0F:95:58:54:41:95:BF:6B:25:82:AB:40:CE:9A
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            60:56:c5:4b:23:40:5b:64:d4:ed:25:da:d9:d6:1e:1e
    Signature Algorithm: sha256WithRSAEncryption
        Issuer: C=DE, O=Deutscher Sparkassen Verlag GmbH, OU=S-TRUST
Certification Services, CN=S-TRUST Universal Root CA
        Validity
            Not Before: Oct 22 00:00:00 2013 GMT
            Not After : Oct 21 23:59:59 2038 GMT
        Subject: C=DE, O=Deutscher Sparkassen Verlag GmbH, OU=S-TRUST
Certification Services, CN=S-TRUST Universal Root CA
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (2048 bit)
                Modulus:
                    00:a8:e3:0b:df:11:37:85:82:9a:b5:6c:66:7c:61:
                    3f:c0:47:1a:1d:46:e3:b0:55:64:e5:b8:82:39:28:
                    07:7e:17:ff:f4:9b:8a:f0:91:81:ea:38:3f:21:78:
                    6c:48:ec:6b:2f:a2:d3:8a:72:b2:a7:d7:d9:ea:7f:
                    b4:c0:49:6b:30:25:89:8c:eb:b7:d5:40:61:98:e2:
                    dc:3c:20:92:cd:65:4a:72:9f:1a:8e:8c:fa:25:15:
                    bf:f3:21:83:28:0d:8b:af:59:11:82:43:5c:9b:4d:
                    25:51:7f:58:18:63:60:3b:b3:b5:8a:8b:58:63:37:
                    48:48:90:44:c2:40:dd:5d:f7:43:69:29:98:5c:12:
                    65:5e:ab:90:92:4b:66:df:d5:75:12:53:54:18:a6:
                    de:8a:d6:bb:57:03:39:59:99:18:05:0c:f9:fd:15:
                    c6:90:64:46:17:82:d7:c2:4a:41:3d:fd:00:be:57:
                    72:18:94:77:1b:53:5a:89:01:f6:33:72:0e:93:3a:
                    dc:e8:1e:fd:05:05:d6:bc:73:e0:88:dc:ab:4f:ec:
                    b5:18:86:4f:79:84:0e:48:2a:66:2a:dd:32:c8:78:
                    65:c8:0b:9d:58:01:05:71:ed:81:f5:68:17:6e:cb:
                    0d:b4:4b:d8:a1:ec:ae:38:eb:1c:58:2f:a1:65:03:
                    34:2f
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Subject Key Identifier:
                9A:7D:D7:EB:EB:7F:54:98:45:29:B4:20:AB:6D:0B:96:23:19:A4:C2
    Signature Algorithm: sha256WithRSAEncryption
         4e:96:12:db:7e:77:5e:92:27:9e:21:17:18:82:76:d8:3f:bc:
         a5:09:04:66:88:89:ad:db:55:b3:33:6a:c6:65:c4:8f:4d:f3:
         32:36:dc:79:04:96:a9:77:32:d1:97:f5:18:6b:8c:ba:ed:ce:
         11:d0:44:c7:92:f1:b4:44:8e:ed:88:52:48:9e:d5:fd:59:f8:
         a3:1e:51:fb:01:52:e5:5f:e5:7a:dd:aa:24:4f:22:8b:dd:76:
         46:f6:a5:a0:0f:35:d8:ca:0f:98:b9:30:5d:20:6f:c2:81:1e:
         bd:bd:c0:fe:15:d3:38:2a:09:93:98:27:1b:93:7b:d0:2b:34:
         5e:68:a5:15:4f:d1:52:c3:a0:ca:a0:83:45:1d:f5:f5:b7:59:
         73:5d:59:01:8f:aa:c2:47:2f:14:71:d5:29:e3:10:b5:47:93:
         25:cc:23:29:da:b7:72:d8:91:d4:ec:1b:48:8a:22:e4:c1:2a:
         f7:3a:68:93:9f:45:19:6e:43:b7:cc:fe:b8:91:9a:61:1a:36:
         69:63:64:92:28:f3:6f:61:92:85:13:9f:c9:07:2c:8b:57:dc:
         eb:9e:79:d5:c2:de:08:d5:54:b2:57:4e:2a:32:8d:a1:e2:3a:
         d1:10:20:22:39:7d:34:45:6f:71:3b:c3:1d:fc:ff:b2:4f:a8:
         e2:f6:30:1e
-----BEGIN CERTIFICATE-----
MIID2DCCAsCgAwIBAgIQYFbFSyNAW2TU7SXa2dYeHjANBgkqhkiG9w0BAQsFADCB
hTELMAkGA1UEBhMCREUxKTAnBgNVBAoTIERldXRzY2hlciBTcGFya2Fzc2VuIFZl
cmxhZyBHbWJIMScwJQYDVQQLEx5TLVRSVVNUIENlcnRpZmljYXRpb24gU2Vydmlj
ZXMxIjAgBgNVBAMTGVMtVFJVU1QgVW5pdmVyc2FsIFJvb3QgQ0EwHhcNMTMxMDIy
MDAwMDAwWhcNMzgxMDIxMjM1OTU5WjCBhTELMAkGA1UEBhMCREUxKTAnBgNVBAoT
IERldXRzY2hlciBTcGFya2Fzc2VuIFZlcmxhZyBHbWJIMScwJQYDVQQLEx5TLVRS
VVNUIENlcnRpZmljYXRpb24gU2VydmljZXMxIjAgBgNVBAMTGVMtVFJVU1QgVW5p
dmVyc2FsIFJvb3QgQ0EwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCo
4wvfETeFgpq1bGZ8YT/ARxodRuOwVWTluII5KAd+F//0m4rwkYHqOD8heGxI7Gsv
otOKcrKn19nqf7TASWswJYmM67fVQGGY4tw8IJLNZUpynxqOjPolFb/zIYMoDYuv
WRGCQ1ybTSVRf1gYY2A7s7WKi1hjN0hIkETCQN1d90NpKZhcEmVeq5CSS2bf1XUS
U1QYpt6K1rtXAzlZmRgFDPn9FcaQZEYXgtfCSkE9/QC+V3IYlHcbU1qJAfYzcg6T
OtzoHv0FBda8c+CI3KtP7LUYhk95hA5IKmYq3TLIeGXIC51YAQVx7YH1aBduyw20
S9ih7K446xxYL6FlAzQvAgMBAAGjQjBAMA8GA1UdEwEB/wQFMAMBAf8wDgYDVR0P
AQH/BAQDAgEGMB0GA1UdDgQWBBSafdfr639UmEUptCCrbQuWIxmkwjANBgkqhkiG
9w0BAQsFAAOCAQEATpYS2353XpInniEXGIJ22D+8pQkEZoiJrdtVszNqxmXEj03z
MjbceQSWqXcy0Zf1GGuMuu3OEdBEx5LxtESO7YhSSJ7V/Vn4ox5R+wFS5V/let2q
JE8ii912RvaloA812MoPmLkwXSBvwoEevb3A/hXTOCoJk5gnG5N70Cs0XmilFU/R
UsOgyqCDRR319bdZc11ZAY+qwkcvFHHVKeMQtUeTJcwjKdq3ctiR1OwbSIoi5MEq
9zpok59FGW5Dt8z+uJGaYRo2aWNkkijzb2GShROfyQcsi1fc65551cLeCNVUsldO
KjKNoeI60RAgIjl9NEVvcTvDHfz/sk+o4vYwHg==
-----END CERTIFICATE-----

Verisign Class 1 Public Primary Certification Authority - G3
============================================================
SHA1 Fingerprint=20:42:85:DC:F7:EB:76:41:95:57:8E:13:6B:D4:B7:D1:E9:8E:46:A5
Certificate:
    Data:
        Version: 1 (0x0)
        Serial Number:
            8b:5b:75:56:84:54:85:0b:00:cf:af:38:48:ce:b1:a4
    Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=VeriSign, Inc., OU=VeriSign Trust Network, OU=(c) 1999
VeriSign, Inc. - For authorized use only, CN=VeriSign Class 1 Public Primary
Certification Authority - G3
        Validity
            Not Before: Oct  1 00:00:00 1999 GMT
            Not After : Jul 16 23:59:59 2036 GMT
        Subject: C=US, O=VeriSign, Inc., OU=VeriSign Trust Network, OU=(c)
1999 VeriSign, Inc. - For authorized use only, CN=VeriSign Class 1 Public
Primary Certification Authority - G3
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (2048 bit)
                Modulus:
                    00:dd:84:d4:b9:b4:f9:a7:d8:f3:04:78:9c:de:3d:
                    dc:6c:13:16:d9:7a:dd:24:51:66:c0:c7:26:59:0d:
                    ac:06:08:c2:94:d1:33:1f:f0:83:35:1f:6e:1b:c8:
                    de:aa:6e:15:4e:54:27:ef:c4:6d:1a:ec:0b:e3:0e:
                    f0:44:a5:57:c7:40:58:1e:a3:47:1f:71:ec:60:f6:
                    6d:94:c8:18:39:ed:fe:42:18:56:df:e4:4c:49:10:
                    78:4e:01:76:35:63:12:36:dd:66:bc:01:04:36:a3:
                    55:68:d5:a2:36:09:ac:ab:21:26:54:06:ad:3f:ca:
                    14:e0:ac:ca:ad:06:1d:95:e2:f8:9d:f1:e0:60:ff:
                    c2:7f:75:2b:4c:cc:da:fe:87:99:21:ea:ba:fe:3e:
                    54:d7:d2:59:78:db:3c:6e:cf:a0:13:00:1a:b8:27:
                    a1:e4:be:67:96:ca:a0:c5:b3:9c:dd:c9:75:9e:eb:
                    30:9a:5f:a3:cd:d9:ae:78:19:3f:23:e9:5c:db:29:
                    bd:ad:55:c8:1b:54:8c:63:f6:e8:a6:ea:c7:37:12:
                    5c:a3:29:1e:02:d9:db:1f:3b:b4:d7:0f:56:47:81:
                    15:04:4a:af:83:27:d1:c5:58:88:c1:dd:f6:aa:a7:
                    a3:18:da:68:aa:6d:11:51:e1:bf:65:6b:9f:96:76:
                    d1:3d
                Exponent: 65537 (0x10001)
    Signature Algorithm: sha1WithRSAEncryption
         ab:66:8d:d7:b3:ba:c7:9a:b6:e6:55:d0:05:f1:9f:31:8d:5a:
         aa:d9:aa:46:26:0f:71:ed:a5:ad:53:56:62:01:47:2a:44:e9:
         fe:3f:74:0b:13:9b:b9:f4:4d:1b:b2:d1:5f:b2:b6:d2:88:5c:
         b3:9f:cd:cb:d4:a7:d9:60:95:84:3a:f8:c1:37:1d:61:ca:e7:
         b0:c5:e5:91:da:54:a6:ac:31:81:ae:97:de:cd:08:ac:b8:c0:
         97:80:7f:6e:72:a4:e7:69:13:95:65:1f:c4:93:3c:fd:79:8f:
         04:d4:3e:4f:ea:f7:9e:ce:cd:67:7c:4f:65:02:ff:91:85:54:
         73:c7:ff:36:f7:86:2d:ec:d0:5e:4f:ff:11:9f:72:06:d6:b8:
         1a:f1:4c:0d:26:65:e2:44:80:1e:c7:9f:e3:dd:e8:0a:da:ec:
         a5:20:80:69:68:a1:4f:7e:e1:6b:cf:07:41:fa:83:8e:bc:38:
         dd:b0:2e:11:b1:6b:b2:42:cc:9a:bc:f9:48:22:79:4a:19:0f:
         b2:1c:3e:20:74:d9:6a:c3:be:f2:28:78:13:56:79:4f:6d:50:
         ea:1b:b0:b5:57:b1:37:66:58:23:f3:dc:0f:df:0a:87:c4:ef:
         86:05:d5:38:14:60:99:a3:4b:de:06:96:71:2c:f2:db:b6:1f:
         a4:ef:3f:ee
-----BEGIN CERTIFICATE-----
MIIEGjCCAwICEQCLW3VWhFSFCwDPrzhIzrGkMA0GCSqGSIb3DQEBBQUAMIHKMQsw
CQYDVQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24sIEluYy4xHzAdBgNVBAsTFlZl
cmlTaWduIFRydXN0IE5ldHdvcmsxOjA4BgNVBAsTMShjKSAxOTk5IFZlcmlTaWdu
LCBJbmMuIC0gRm9yIGF1dGhvcml6ZWQgdXNlIG9ubHkxRTBDBgNVBAMTPFZlcmlT
aWduIENsYXNzIDEgUHVibGljIFByaW1hcnkgQ2VydGlmaWNhdGlvbiBBdXRob3Jp
dHkgLSBHMzAeFw05OTEwMDEwMDAwMDBaFw0zNjA3MTYyMzU5NTlaMIHKMQswCQYD
VQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24sIEluYy4xHzAdBgNVBAsTFlZlcmlT
aWduIFRydXN0IE5ldHdvcmsxOjA4BgNVBAsTMShjKSAxOTk5IFZlcmlTaWduLCBJ
bmMuIC0gRm9yIGF1dGhvcml6ZWQgdXNlIG9ubHkxRTBDBgNVBAMTPFZlcmlTaWdu
IENsYXNzIDEgUHVibGljIFByaW1hcnkgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkg
LSBHMzCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAN2E1Lm0+afY8wR4
nN493GwTFtl63SRRZsDHJlkNrAYIwpTRMx/wgzUfbhvI3qpuFU5UJ+/EbRrsC+MO
8ESlV8dAWB6jRx9x7GD2bZTIGDnt/kIYVt/kTEkQeE4BdjVjEjbdZrwBBDajVWjV
ojYJrKshJlQGrT/KFOCsyq0GHZXi+J3x4GD/wn91K0zM2v6HmSHquv4+VNfSWXjb
PG7PoBMAGrgnoeS+Z5bKoMWznN3JdZ7rMJpfo83ZrngZPyPpXNspva1VyBtUjGP2
6KbqxzcSXKMpHgLZ2x87tNcPVkeBFQRKr4Mn0cVYiMHd9qqnoxjaaKptEVHhv2Vr
n5Z20T0CAwEAATANBgkqhkiG9w0BAQUFAAOCAQEAq2aN17O6x5q25lXQBfGfMY1a
qtmqRiYPce2lrVNWYgFHKkTp/j90CxObufRNG7LRX7K20ohcs5/Ny9Sn2WCVhDr4
wTcdYcrnsMXlkdpUpqwxga6X3s0IrLjAl4B/bnKk52kTlWUfxJM8/XmPBNQ+T+r3
ns7NZ3xPZQL/kYVUc8f/NveGLezQXk//EZ9yBta4GvFMDSZl4kSAHsef493oCtrs
pSCAaWihT37ha88HQfqDjrw43bAuEbFrskLMmrz5SCJ5ShkPshw+IHTZasO+8ih4
E1Z5T21Q6huwtVexN2ZYI/PcD98Kh8TvhgXVOBRgmaNL3gaWcSzy27YfpO8/7g==
-----END CERTIFICATE-----

SwissSign Platinum CA - G2
==========================
SHA1 Fingerprint=56:E0:FA:C0:3B:8F:18:23:55:18:E5:D3:11:CA:E8:C2:43:31:AB:66
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number: 5670595323396054351 (0x4eb200670c035d4f)
    Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=CH, O=SwissSign AG, CN=SwissSign Platinum CA - G2
        Validity
            Not Before: Oct 25 08:36:00 2006 GMT
            Not After : Oct 25 08:36:00 2036 GMT
        Subject: C=CH, O=SwissSign AG, CN=SwissSign Platinum CA - G2
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (4096 bit)
                Modulus:
                    00:ca:df:a2:02:e2:da:f8:fc:07:16:b1:de:60:aa:
                    de:96:5c:64:1f:c7:2f:7e:cf:67:fa:44:42:d6:76:
                    63:95:ae:eb:af:72:20:8a:45:47:86:62:78:86:d6:
                    20:39:26:f4:ae:a3:fd:23:e7:a5:9c:b5:22:21:19:
                    b7:37:93:22:c0:50:9c:82:7b:d4:d5:04:44:5c:cb:
                    b4:c2:9f:92:be:24:d8:7b:67:22:e2:69:5f:e5:05:
                    78:d4:87:d9:71:70:33:25:53:b4:87:3b:29:90:28:
                    36:9a:55:44:30:68:a4:83:97:7f:0d:1e:9c:76:ff:
                    15:9d:60:97:00:8d:8a:85:03:ec:80:be:ea:2c:6e:
                    10:51:92:cc:7e:d5:a3:33:d8:d6:49:de:58:2a:af:
                    f6:16:eb:4b:7b:90:32:97:b9:ba:9d:58:f1:f8:57:
                    49:04:1e:a2:5d:06:70:dd:71:db:f9:dd:8b:9a:1b:
                    8c:cf:3d:a3:4d:ce:cb:7c:f6:bb:9c:a0:fa:09:ce:
                    23:62:b2:e9:0d:1f:e2:72:28:8f:9f:ac:68:20:7d:
                    6f:3b:a8:85:31:09:7f:0b:c7:e8:65:e9:e3:78:0e:
                    09:67:30:8b:34:82:fb:5d:e0:cc:9d:81:6d:62:ee:
                    08:1e:04:2c:4e:9b:ec:fe:a9:4f:5f:fd:69:78:ef:
                    09:1f:a1:b4:bf:fa:f3:ef:90:1e:4c:05:8b:1e:ea:
                    7a:91:7a:c3:d7:e5:fb:30:bc:6c:1b:10:58:98:f7:
                    1a:5f:d0:29:32:03:13:46:4d:61:6a:85:4c:52:74:
                    2f:06:1f:7b:11:e2:84:97:c6:99:f3:6d:7f:d7:67:
                    83:7e:13:68:d8:71:28:5a:d8:ce:dd:e8:10:14:9a:
                    fe:6d:23:87:6e:8e:5a:70:3c:d5:8d:09:00:a7:aa:
                    bc:b0:31:37:6d:c8:84:14:1e:5b:bd:45:63:20:6b:
                    4b:74:8c:bd:db:3a:0e:c1:cf:5a:16:8f:a5:98:f2:
                    76:89:b2:13:12:3b:0b:77:77:ac:bb:e5:3c:29:4a:
                    92:72:ca:61:1a:2b:5e:4c:e2:83:74:77:fa:35:48:
                    7a:85:4d:8d:9a:53:c4:df:78:ca:97:91:48:2b:45:
                    2b:01:f7:1c:1a:a2:ed:18:ba:0a:bd:83:fa:6f:bc:
                    8d:57:93:3b:d4:d4:a6:ce:1e:f1:a0:b1:ce:ab:fd:
                    2b:28:9a:4f:1b:d7:c3:72:db:a4:c4:bf:5d:4c:f5:
                    dd:7b:96:69:ee:68:80:e6:e7:98:ba:36:b7:fe:6e:
                    ed:2b:bd:20:f8:65:19:da:55:09:7e:25:dc:fe:61:
                    62:72:f9:7e:18:02:ef:63:b4:d0:fb:af:e5:3b:63:
                    8c:67:8f
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Subject Key Identifier:
                50:AF:CC:07:87:15:47:6F:38:C5:B4:65:D1:DE:95:AA:E9:DF:9C:CC
            X509v3 Authority Key Identifier:
                keyid:50:AF:CC:07:87:15:47:6F:38:C5:B4:65:D1:DE:95:AA:E9:DF:9C:CC

            X509v3 Certificate Policies:
                Policy: 2.16.756.1.89.1.1.1.1
                  CPS: http://repository.swisssign.com/

    Signature Algorithm: sha1WithRSAEncryption
         08:85:a6:f5:16:0c:fc:44:1a:c1:63:e0:f9:55:46:08:fc:70:
         1c:42:28:96:8e:b7:c5:c1:41:75:4e:09:71:79:e5:6d:96:ca:
         4b:a5:88:60:d0:30:74:b8:ca:08:dc:b4:30:9e:40:07:16:6b:
         65:95:77:01:ae:a4:b7:35:0b:81:da:71:15:a9:74:17:38:7b:
         58:ca:f9:2f:fb:c0:65:76:8d:5b:01:b9:7d:de:82:3d:64:b8:
         be:14:74:a3:0a:54:d3:2c:95:18:17:35:f5:51:6b:3f:8f:a2:
         96:61:39:78:6b:4b:e5:a6:a0:f8:53:df:51:10:93:62:e7:80:
         2f:e2:d1:e0:bc:8e:36:46:77:33:ec:b8:fb:8e:9a:2c:89:4d:
         31:11:0f:26:9e:04:bb:b7:04:8d:0b:f2:b9:fc:5a:9d:3b:16:
         b7:2f:c8:98:ab:fe:8a:50:59:2e:a3:3b:fc:29:5d:8b:c1:4b:
         c9:e2:8a:13:1d:b1:bf:bb:42:1d:52:dd:4e:d8:14:5e:10:c6:
         31:07:ef:71:27:f7:1b:39:09:dc:82:ea:8b:b3:95:86:5e:fd:
         f5:da:5d:31:a6:e0:31:b6:94:e6:44:49:74:c5:16:e5:f7:1f:
         03:61:28:c5:c8:cb:12:a0:42:4b:f9:6b:88:08:8d:b4:32:18:
         f3:75:9f:c4:7f:00:4f:05:95:9c:a3:17:02:c3:b3:53:9b:aa:
         20:39:29:2b:66:fa:9d:af:5e:b3:92:d2:b5:a6:e1:1a:f9:2d:
         41:69:81:14:b4:b4:b5:ed:89:3d:ce:fb:a9:9d:35:42:44:b1:
         1c:14:73:81:cf:2a:01:35:9a:31:d5:2d:8f:6d:84:df:80:4d:
         57:e3:3f:c5:84:75:da:89:c6:30:bb:eb:8f:cb:22:08:a0:ae:
         aa:f1:03:6c:3a:4b:4d:09:a5:0e:72:c6:56:6b:21:42:4e:23:
         25:14:68:ae:76:0a:7c:0c:07:70:64:f9:9a:2f:f6:05:39:26:
         c6:0c:8f:19:7f:43:5e:6e:f4:5b:15:2f:db:61:5d:e6:67:2f:
         3f:08:94:f9:60:b4:98:31:da:74:f1:84:93:71:4d:5f:fb:60:
         58:d1:fb:c4:c1:6d:89:a2:bb:20:1f:9d:71:91:cb:32:9b:13:
         3d:3e:7d:92:52:35:ac:92:94:a2:d3:18:c2:7c:c7:ea:af:76:
         05:16:dd:67:27:c2:7e:1c:07:22:21:f3:40:0a:1b:34:07:44:
         13:c2:84:6a:8e:df:19:5a:bf:7f:eb:1d:e2:1a:38:d1:5c:af:
         47:92:6b:80:b5:30:a5:c9:8d:d8:ab:31:81:1f:df:c2:66:37:
         d3:93:a9:85:86:79:65:d2
-----BEGIN CERTIFICATE-----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-----END CERTIFICATE-----

Verisign Class 2 Public Primary Certification Authority - G3
============================================================
SHA1 Fingerprint=61:EF:43:D7:7F:CA:D4:61:51:BC:98:E0:C3:59:12:AF:9F:EB:63:11
Certificate:
    Data:
        Version: 1 (0x0)
        Serial Number:
            61:70:cb:49:8c:5f:98:45:29:e7:b0:a6:d9:50:5b:7a
    Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=VeriSign, Inc., OU=VeriSign Trust Network, OU=(c) 1999
VeriSign, Inc. - For authorized use only, CN=VeriSign Class 2 Public Primary
Certification Authority - G3
        Validity
            Not Before: Oct  1 00:00:00 1999 GMT
            Not After : Jul 16 23:59:59 2036 GMT
        Subject: C=US, O=VeriSign, Inc., OU=VeriSign Trust Network, OU=(c)
1999 VeriSign, Inc. - For authorized use only, CN=VeriSign Class 2 Public
Primary Certification Authority - G3
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (2048 bit)
                Modulus:
                    00:af:0a:0d:c2:d5:2c:db:67:b9:2d:e5:94:27:dd:
                    a5:be:e0:b0:4d:8f:b3:61:56:3c:d6:7c:c3:f4:cd:
                    3e:86:cb:a2:88:e2:e1:d8:a4:69:c5:b5:e2:bf:c1:
                    a6:47:50:5e:46:39:8b:d5:96:ba:b5:6f:14:bf:10:
                    ce:27:13:9e:05:47:9b:31:7a:13:d8:1f:d9:d3:02:
                    37:8b:ad:2c:47:f0:8e:81:06:a7:0d:30:0c:eb:f7:
                    3c:0f:20:1d:dc:72:46:ee:a5:02:c8:5b:c3:c9:56:
                    69:4c:c5:18:c1:91:7b:0b:d5:13:00:9b:bc:ef:c3:
                    48:3e:46:60:20:85:2a:d5:90:b6:cd:8b:a0:cc:32:
                    dd:b7:fd:40:55:b2:50:1c:56:ae:cc:8d:77:4d:c7:
                    20:4d:a7:31:76:ef:68:92:8a:90:1e:08:81:56:b2:
                    ad:69:a3:52:d0:cb:1c:c4:23:3d:1f:99:fe:4c:e8:
                    16:63:8e:c6:08:8e:f6:31:f6:d2:fa:e5:76:dd:b5:
                    1c:92:a3:49:cd:cd:01:cd:68:cd:a9:69:ba:a3:eb:
                    1d:0d:9c:a4:20:a6:c1:a0:c5:d1:46:4c:17:6d:d2:
                    ac:66:3f:96:8c:e0:84:d4:36:ff:22:59:c5:f9:11:
                    60:a8:5f:04:7d:f2:1a:f6:25:42:61:0f:c4:4a:b8:
                    3e:89
                Exponent: 65537 (0x10001)
    Signature Algorithm: sha1WithRSAEncryption
         34:26:15:3c:c0:8d:4d:43:49:1d:bd:e9:21:92:d7:66:9c:b7:
         de:c5:b8:d0:e4:5d:5f:76:22:c0:26:f9:84:3a:3a:f9:8c:b5:
         fb:ec:60:f1:e8:ce:04:b0:c8:dd:a7:03:8f:30:f3:98:df:a4:
         e6:a4:31:df:d3:1c:0b:46:dc:72:20:3f:ae:ee:05:3c:a4:33:
         3f:0b:39:ac:70:78:73:4b:99:2b:df:30:c2:54:b0:a8:3b:55:
         a1:fe:16:28:cd:42:bd:74:6e:80:db:27:44:a7:ce:44:5d:d4:
         1b:90:98:0d:1e:42:94:b1:00:2c:04:d0:74:a3:02:05:22:63:
         63:cd:83:b5:fb:c1:6d:62:6b:69:75:fd:5d:70:41:b9:f5:bf:
         7c:df:be:c1:32:73:22:21:8b:58:81:7b:15:91:7a:ba:e3:64:
         48:b0:7f:fb:36:25:da:95:d0:f1:24:14:17:dd:18:80:6b:46:
         23:39:54:f5:8e:62:09:04:1d:94:90:a6:9b:e6:25:e2:42:45:
         aa:b8:90:ad:be:08:8f:a9:0b:42:18:94:cf:72:39:e1:b1:43:
         e0:28:cf:b7:e7:5a:6c:13:6b:49:b3:ff:e3:18:7c:89:8b:33:
         5d:ac:33:d7:a7:f9:da:3a:55:c9:58:10:f9:aa:ef:5a:b6:cf:
         4b:4b:df:2a
-----BEGIN CERTIFICATE-----
MIIEGTCCAwECEGFwy0mMX5hFKeewptlQW3owDQYJKoZIhvcNAQEFBQAwgcoxCzAJ
BgNVBAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5jLjEfMB0GA1UECxMWVmVy
aVNpZ24gVHJ1c3QgTmV0d29yazE6MDgGA1UECxMxKGMpIDE5OTkgVmVyaVNpZ24s
IEluYy4gLSBGb3IgYXV0aG9yaXplZCB1c2Ugb25seTFFMEMGA1UEAxM8VmVyaVNp
Z24gQ2xhc3MgMiBQdWJsaWMgUHJpbWFyeSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0
eSAtIEczMB4XDTk5MTAwMTAwMDAwMFoXDTM2MDcxNjIzNTk1OVowgcoxCzAJBgNV
BAYTAlVTMRcwFQYDVQQKEw5WZXJpU2lnbiwgSW5jLjEfMB0GA1UECxMWVmVyaVNp
Z24gVHJ1c3QgTmV0d29yazE6MDgGA1UECxMxKGMpIDE5OTkgVmVyaVNpZ24sIElu
Yy4gLSBGb3IgYXV0aG9yaXplZCB1c2Ugb25seTFFMEMGA1UEAxM8VmVyaVNpZ24g
Q2xhc3MgMiBQdWJsaWMgUHJpbWFyeSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eSAt
IEczMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEArwoNwtUs22e5LeWU
J92lvuCwTY+zYVY81nzD9M0+hsuiiOLh2KRpxbXiv8GmR1BeRjmL1Za6tW8UvxDO
JxOeBUebMXoT2B/Z0wI3i60sR/COgQanDTAM6/c8DyAd3HJG7qUCyFvDyVZpTMUY
wZF7C9UTAJu878NIPkZgIIUq1ZC2zYugzDLdt/1AVbJQHFauzI13TccgTacxdu9o
koqQHgiBVrKtaaNS0MscxCM9H5n+TOgWY47GCI72MfbS+uV23bUckqNJzc0BzWjN
qWm6o+sdDZykIKbBoMXRRkwXbdKsZj+WjOCE1Db/IlnF+RFgqF8EffIa9iVCYQ/E
Srg+iQIDAQABMA0GCSqGSIb3DQEBBQUAA4IBAQA0JhU8wI1NQ0kdvekhktdmnLfe
xbjQ5F1fdiLAJvmEOjr5jLX77GDx6M4EsMjdpwOPMPOY36TmpDHf0xwLRtxyID+u
7gU8pDM/CzmscHhzS5kr3zDCVLCoO1Wh/hYozUK9dG6A2ydEp85EXdQbkJgNHkKU
sQAsBNB0owIFImNjzYO1+8FtYmtpdf1dcEG59b98377BMnMiIYtYgXsVkXq642RI
sH/7NiXaldDxJBQX3RiAa0YjOVT1jmIJBB2UkKab5iXiQkWquJCtvgiPqQtCGJTP
cjnhsUPgKM+351psE2tJs//jGHyJizNdrDPXp/naOlXJWBD5qu9ats9LS98q
-----END CERTIFICATE-----

Verisign Class 3 Public Primary Certification Authority
=======================================================
SHA1 Fingerprint=74:2C:31:92:E6:07:E4:24:EB:45:49:54:2B:E1:BB:C5:3E:61:74:E2
Certificate:
    Data:
        Version: 1 (0x0)
        Serial Number:
            70:ba:e4:1d:10:d9:29:34:b6:38:ca:7b:03:cc:ba:bf
    Signature Algorithm: md2WithRSAEncryption
        Issuer: C=US, O=VeriSign, Inc., OU=Class 3 Public Primary
Certification Authority
        Validity
            Not Before: Jan 29 00:00:00 1996 GMT
            Not After : Aug  1 23:59:59 2028 GMT
        Subject: C=US, O=VeriSign, Inc., OU=Class 3 Public Primary
Certification Authority
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (1024 bit)
                Modulus:
                    00:c9:5c:59:9e:f2:1b:8a:01:14:b4:10:df:04:40:
                    db:e3:57:af:6a:45:40:8f:84:0c:0b:d1:33:d9:d9:
                    11:cf:ee:02:58:1f:25:f7:2a:a8:44:05:aa:ec:03:
                    1f:78:7f:9e:93:b9:9a:00:aa:23:7d:d6:ac:85:a2:
                    63:45:c7:72:27:cc:f4:4c:c6:75:71:d2:39:ef:4f:
                    42:f0:75:df:0a:90:c6:8e:20:6f:98:0f:f8:ac:23:
                    5f:70:29:36:a4:c9:86:e7:b1:9a:20:cb:53:a5:85:
                    e7:3d:be:7d:9a:fe:24:45:33:dc:76:15:ed:0f:a2:
                    71:64:4c:65:2e:81:68:45:a7
                Exponent: 65537 (0x10001)
    Signature Algorithm: md2WithRSAEncryption
         bb:4c:12:2b:cf:2c:26:00:4f:14:13:dd:a6:fb:fc:0a:11:84:
         8c:f3:28:1c:67:92:2f:7c:b6:c5:fa:df:f0:e8:95:bc:1d:8f:
         6c:2c:a8:51:cc:73:d8:a4:c0:53:f0:4e:d6:26:c0:76:01:57:
         81:92:5e:21:f1:d1:b1:ff:e7:d0:21:58:cd:69:17:e3:44:1c:
         9c:19:44:39:89:5c:dc:9c:00:0f:56:8d:02:99:ed:a2:90:45:
         4c:e4:bb:10:a4:3d:f0:32:03:0e:f1:ce:f8:e8:c9:51:8c:e6:
         62:9f:e6:9f:c0:7d:b7:72:9c:c9:36:3a:6b:9f:4e:a8:ff:64:
         0d:64
-----BEGIN CERTIFICATE-----
MIICPDCCAaUCEHC65B0Q2Sk0tjjKewPMur8wDQYJKoZIhvcNAQECBQAwXzELMAkG
A1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMTcwNQYDVQQLEy5DbGFz
cyAzIFB1YmxpYyBQcmltYXJ5IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTk2
MDEyOTAwMDAwMFoXDTI4MDgwMTIzNTk1OVowXzELMAkGA1UEBhMCVVMxFzAVBgNV
BAoTDlZlcmlTaWduLCBJbmMuMTcwNQYDVQQLEy5DbGFzcyAzIFB1YmxpYyBQcmlt
YXJ5IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MIGfMA0GCSqGSIb3DQEBAQUAA4GN
ADCBiQKBgQDJXFme8huKARS0EN8EQNvjV69qRUCPhAwL0TPZ2RHP7gJYHyX3KqhE
BarsAx94f56TuZoAqiN91qyFomNFx3InzPRMxnVx0jnvT0Lwdd8KkMaOIG+YD/is
I19wKTakyYbnsZogy1Olhec9vn2a/iRFM9x2Fe0PonFkTGUugWhFpwIDAQABMA0G
CSqGSIb3DQEBAgUAA4GBALtMEivPLCYATxQT3ab7/AoRhIzzKBxnki98tsX63/Do
lbwdj2wsqFHMc9ikwFPwTtYmwHYBV4GSXiHx0bH/59AhWM1pF+NEHJwZRDmJXNyc
AA9WjQKZ7aKQRUzkuxCkPfAyAw7xzvjoyVGM5mKf5p/AfbdynMk2OmufTqj/ZA1k
-----END CERTIFICATE-----
TC TrustCenter Class 3 CA II
============================
SHA1 Fingerprint=80:25:EF:F4:6E:70:C8:D4:72:24:65:84:FE:40:3B:8A:8D:6A:DB:F5
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            4a:47:00:01:00:02:e5:a0:5d:d6:3f:00:51:bf
    Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=DE, O=TC TrustCenter GmbH, OU=TC TrustCenter Class 3 CA,
CN=TC TrustCenter Class 3 CA II
        Validity
            Not Before: Jan 12 14:41:57 2006 GMT
            Not After : Dec 31 22:59:59 2025 GMT
        Subject: C=DE, O=TC TrustCenter GmbH, OU=TC TrustCenter Class 3 CA,
CN=TC TrustCenter Class 3 CA II
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (2048 bit)
                Modulus:
                    00:b4:e0:bb:51:bb:39:5c:8b:04:c5:4c:79:1c:23:
                    86:31:10:63:43:55:27:3f:c6:45:c7:a4:3d:ec:09:
                    0d:1a:1e:20:c2:56:1e:de:1b:37:07:30:22:2f:6f:
                    f1:06:f1:ab:ad:d6:c8:ab:61:a3:2f:43:c4:b0:b2:
                    2d:fc:c3:96:69:7b:7e:8a:e4:cc:c0:39:12:90:42:
                    60:c9:cc:35:68:ee:da:5f:90:56:5f:cd:1c:4d:5b:
                    58:49:eb:0e:01:4f:64:fa:2c:3c:89:58:d8:2f:2e:
                    e2:b0:68:e9:22:3b:75:89:d6:44:1a:65:f2:1b:97:
                    26:1d:28:6d:ac:e8:bd:59:1d:2b:24:f6:d6:84:03:
                    66:88:24:00:78:60:f1:f8:ab:fe:02:b2:6b:fb:22:
                    fb:35:e6:16:d1:ad:f6:2e:12:e4:fa:35:6a:e5:19:
                    b9:5d:db:3b:1e:1a:fb:d3:ff:15:14:08:d8:09:6a:
                    ba:45:9d:14:79:60:7d:af:40:8a:07:73:b3:93:96:
                    d3:74:34:8d:3a:37:29:de:5c:ec:f5:ee:2e:31:c2:
                    20:dc:be:f1:4f:7f:23:52:d9:5b:e2:64:d9:9c:aa:
                    07:08:b5:45:bd:d1:d0:31:c1:ab:54:9f:a9:d2:c3:
                    62:60:03:f1:bb:39:4a:92:4a:3d:0a:b9:9d:c5:a0:
                    fe:37
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Subject Key Identifier:
                D4:A2:FC:9F:B3:C3:D8:03:D3:57:5C:07:A4:D0:24:A7:C0:F2:00:D4
            X509v3 CRL Distribution Points:

                Full Name:
                  URI:http://www.trustcenter.de/crl/v2/tc_class_3_ca_II.crl
                  URI:ldap://www.trustcenter.de/CN=TC%20TrustCenter%20Class%203%20CA%20II,O=TC%20TrustCenter%20GmbH,OU=rootcerts,DC=trustcenter,DC=de?certificateRevocationList?base?

    Signature Algorithm: sha1WithRSAEncryption
         36:60:e4:70:f7:06:20:43:d9:23:1a:42:f2:f8:a3:b2:b9:4d:
         8a:b4:f3:c2:9a:55:31:7c:c4:3b:67:9a:b4:df:4d:0e:8a:93:
         4a:17:8b:1b:8d:ca:89:e1:cf:3a:1e:ac:1d:f1:9c:32:b4:8e:
         59:76:a2:41:85:25:37:a0:13:d0:f5:7c:4e:d5:ea:96:e2:6e:
         72:c1:bb:2a:fe:6c:6e:f8:91:98:46:fc:c9:1b:57:5b:ea:c8:
         1a:3b:3f:b0:51:98:3c:07:da:2c:59:01:da:8b:44:e8:e1:74:
         fd:a7:68:dd:54:ba:83:46:ec:c8:46:b5:f8:af:97:c0:3b:09:
         1c:8f:ce:72:96:3d:33:56:70:bc:96:cb:d8:d5:7d:20:9a:83:
         9f:1a:dc:39:f1:c5:72:a3:11:03:fd:3b:42:52:29:db:e8:01:
         f7:9b:5e:8c:d6:8d:86:4e:19:fa:bc:1c:be:c5:21:a5:87:9e:
         78:2e:36:db:09:71:a3:72:34:f8:6c:e3:06:09:f2:5e:56:a5:
         d3:dd:98:fa:d4:e6:06:f4:f0:b6:20:63:4b:ea:29:bd:aa:82:
         66:1e:fb:81:aa:a7:37:ad:13:18:e6:92:c3:81:c1:33:bb:88:
         1e:a1:e7:e2:b4:bd:31:6c:0e:51:3d:6f:fb:96:56:80:e2:36:
         17:d1:dc:e4
-----BEGIN CERTIFICATE-----
MIIEqjCCA5KgAwIBAgIOSkcAAQAC5aBd1j8AUb8wDQYJKoZIhvcNAQEFBQAwdjEL
MAkGA1UEBhMCREUxHDAaBgNVBAoTE1RDIFRydXN0Q2VudGVyIEdtYkgxIjAgBgNV
BAsTGVRDIFRydXN0Q2VudGVyIENsYXNzIDMgQ0ExJTAjBgNVBAMTHFRDIFRydXN0
Q2VudGVyIENsYXNzIDMgQ0EgSUkwHhcNMDYwMTEyMTQ0MTU3WhcNMjUxMjMxMjI1
OTU5WjB2MQswCQYDVQQGEwJERTEcMBoGA1UEChMTVEMgVHJ1c3RDZW50ZXIgR21i
SDEiMCAGA1UECxMZVEMgVHJ1c3RDZW50ZXIgQ2xhc3MgMyBDQTElMCMGA1UEAxMc
VEMgVHJ1c3RDZW50ZXIgQ2xhc3MgMyBDQSBJSTCCASIwDQYJKoZIhvcNAQEBBQAD
ggEPADCCAQoCggEBALTgu1G7OVyLBMVMeRwjhjEQY0NVJz/GRcekPewJDRoeIMJW
Ht4bNwcwIi9v8Qbxq63WyKthoy9DxLCyLfzDlml7forkzMA5EpBCYMnMNWju2l+Q
Vl/NHE1bWEnrDgFPZPosPIlY2C8u4rBo6SI7dYnWRBpl8huXJh0obazovVkdKyT2
1oQDZogkAHhg8fir/gKya/si+zXmFtGt9i4S5Po1auUZuV3bOx4a+9P/FRQI2Alq
ukWdFHlgfa9Aigdzs5OW03Q0jTo3Kd5c7PXuLjHCINy+8U9/I1LZW+Jk2ZyqBwi1
Rb3R0DHBq1SfqdLDYmAD8bs5SpJKPQq5ncWg/jcCAwEAAaOCATQwggEwMA8GA1Ud
EwEB/wQFMAMBAf8wDgYDVR0PAQH/BAQDAgEGMB0GA1UdDgQWBBTUovyfs8PYA9NX
XAek0CSnwPIA1DCB7QYDVR0fBIHlMIHiMIHfoIHcoIHZhjVodHRwOi8vd3d3LnRy
dXN0Y2VudGVyLmRlL2NybC92Mi90Y19jbGFzc18zX2NhX0lJLmNybIaBn2xkYXA6
Ly93d3cudHJ1c3RjZW50ZXIuZGUvQ049VEMlMjBUcnVzdENlbnRlciUyMENsYXNz
JTIwMyUyMENBJTIwSUksTz1UQyUyMFRydXN0Q2VudGVyJTIwR21iSCxPVT1yb290
Y2VydHMsREM9dHJ1c3RjZW50ZXIsREM9ZGU/Y2VydGlmaWNhdGVSZXZvY2F0aW9u
TGlzdD9iYXNlPzANBgkqhkiG9w0BAQUFAAOCAQEANmDkcPcGIEPZIxpC8vijsrlN
irTzwppVMXzEO2eatN9NDoqTSheLG43KieHPOh6sHfGcMrSOWXaiQYUlN6AT0PV8
TtXqluJucsG7Kv5sbviRmEb8yRtXW+rIGjs/sFGYPAfaLFkB2otE6OF0/ado3VS6
g0bsyEa1+K+XwDsJHI/OcpY9M1ZwvJbL2NV9IJqDnxrcOfHFcqMRA/07QlIp2+gB
95tejNaNhk4Z+rwcvsUhpYeeeC422wlxo3I0+GzjBgnyXlal092Y+tTmBvTwtiBj
S+opvaqCZh77gaqnN60TGOaSw4HBM7uIHqHn4rS9MWwOUT1v+5ZWgOI2F9Hc5A==
-----END CERTIFICATE-----
ign Class 2 Public Primary Certification Authority - G2
============================================================
SHA1 Fingerprint=B3:EA:C4:47:76:C9:C8:1C:EA:F2:9D:95:B6:CC:A0:08:1B:67:EC:9D
Certificate:
    Data:
        Version: 1 (0x0)
        Serial Number:
            b9:2f:60:cc:88:9f:a1:7a:46:09:b8:5b:70:6c:8a:af
    Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=VeriSign, Inc., OU=Class 2 Public Primary
Certification Authority - G2, OU=(c) 1998 VeriSign, Inc. - For authorized use
only, OU=VeriSign Trust Network
        Validity
            Not Before: May 18 00:00:00 1998 GMT
            Not After : Aug  1 23:59:59 2028 GMT
        Subject: C=US, O=VeriSign, Inc., OU=Class 2 Public Primary
Certification Authority - G2, OU=(c) 1998 VeriSign, Inc. - For authorized use
only, OU=VeriSign Trust Network
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (1024 bit)
                Modulus:
                    00:a7:88:01:21:74:2c:e7:1a:03:f0:98:e1:97:3c:
                    0f:21:08:f1:9c:db:97:e9:9a:fc:c2:04:06:13:be:
                    5f:52:c8:cc:1e:2c:12:56:2c:b8:01:69:2c:cc:99:
                    1f:ad:b0:96:ae:79:04:f2:13:39:c1:7b:98:ba:08:
                    2c:e8:c2:84:13:2c:aa:69:e9:09:f4:c7:a9:02:a4:
                    42:c2:23:4f:4a:d8:f0:0e:a2:fb:31:6c:c9:e6:6f:
                    99:27:07:f5:e6:f4:4c:78:9e:6d:eb:46:86:fa:b9:
                    86:c9:54:f2:b2:c4:af:d4:46:1c:5a:c9:15:30:ff:
                    0d:6c:f5:2d:0e:6d:ce:7f:77
                Exponent: 65537 (0x10001)
    Signature Algorithm: sha1WithRSAEncryption
         72:2e:f9:7f:d1:f1:71:fb:c4:9e:f6:c5:5e:51:8a:40:98:b8:
         68:f8:9b:1c:83:d8:e2:9d:bd:ff:ed:a1:e6:66:ea:2f:09:f4:
         ca:d7:ea:a5:2b:95:f6:24:60:86:4d:44:2e:83:a5:c4:2d:a0:
         d3:ae:78:69:6f:72:da:6c:ae:08:f0:63:92:37:e6:bb:c4:30:
         17:ad:77:cc:49:35:aa:cf:d8:8f:d1:be:b7:18:96:47:73:6a:
         54:22:34:64:2d:b6:16:9b:59:5b:b4:51:59:3a:b3:0b:14:f4:
         12:df:67:a0:f4:ad:32:64:5e:b1:46:72:27:8c:12:7b:c5:44:
         b4:ae
-----BEGIN CERTIFICATE-----
MIIDAzCCAmwCEQC5L2DMiJ+hekYJuFtwbIqvMA0GCSqGSIb3DQEBBQUAMIHBMQsw
CQYDVQQGEwJVUzEXMBUGA1UEChMOVmVyaVNpZ24sIEluYy4xPDA6BgNVBAsTM0Ns
YXNzIDIgUHVibGljIFByaW1hcnkgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkgLSBH
MjE6MDgGA1UECxMxKGMpIDE5OTggVmVyaVNpZ24sIEluYy4gLSBGb3IgYXV0aG9y
aXplZCB1c2Ugb25seTEfMB0GA1UECxMWVmVyaVNpZ24gVHJ1c3QgTmV0d29yazAe
Fw05ODA1MTgwMDAwMDBaFw0yODA4MDEyMzU5NTlaMIHBMQswCQYDVQQGEwJVUzEX
MBUGA1UEChMOVmVyaVNpZ24sIEluYy4xPDA6BgNVBAsTM0NsYXNzIDIgUHVibGlj
IFByaW1hcnkgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkgLSBHMjE6MDgGA1UECxMx
KGMpIDE5OTggVmVyaVNpZ24sIEluYy4gLSBGb3IgYXV0aG9yaXplZCB1c2Ugb25s
eTEfMB0GA1UECxMWVmVyaVNpZ24gVHJ1c3QgTmV0d29yazCBnzANBgkqhkiG9w0B
AQEFAAOBjQAwgYkCgYEAp4gBIXQs5xoD8JjhlzwPIQjxnNuX6Zr8wgQGE75fUsjM
HiwSViy4AWkszJkfrbCWrnkE8hM5wXuYuggs6MKEEyyqaekJ9MepAqRCwiNPStjw
DqL7MWzJ5m+ZJwf15vRMeJ5t60aG+rmGyVTyssSv1EYcWskVMP8NbPUtDm3Of3cC
AwEAATANBgkqhkiG9w0BAQUFAAOBgQByLvl/0fFx+8Se9sVeUYpAmLho+Jscg9ji
nb3/7aHmZuovCfTK1+qlK5X2JGCGTUQug6XELaDTrnhpb3LabK4I8GOSN+a7xDAX
rXfMSTWqz9iP0b63GJZHc2pUIjRkLbYWm1lbtFFZOrMLFPQS32eg9K0yZF6xRnIn
jBJ7xUS0rg==
-----END CERTIFICATE-----

S-TRUST Authentication and Encryption Root CA 2005 PN
=====================================================
SHA1 Fingerprint=BE:B5:A9:95:74:6B:9E:DF:73:8B:56:E6:DF:43:7A:77:BE:10:6B:81
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            37:19:18:e6:53:54:7c:1a:b5:b8:cb:59:5a:db:35:b7
    Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=DE, ST=Baden-Wuerttemberg (BW), L=Stuttgart, O=Deutscher
Sparkassen Verlag GmbH, CN=S-TRUST Authentication and Encryption Root CA
2005:PN
        Validity
            Not Before: Jun 22 00:00:00 2005 GMT
            Not After : Jun 21 23:59:59 2030 GMT
        Subject: C=DE, ST=Baden-Wuerttemberg (BW), L=Stuttgart, O=Deutscher
Sparkassen Verlag GmbH, CN=S-TRUST Authentication and Encryption Root CA
2005:PN
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (2048 bit)
                Modulus:
                    00:d9:b5:4a:c1:d3:33:ea:d3:46:b3:d1:e2:4c:d2:
                    f5:b6:83:d0:6f:d5:18:e9:93:af:27:8e:13:cd:b5:
                    25:36:50:34:12:64:29:a1:55:e1:3a:60:93:9e:28:
                    c9:e3:f3:9b:e1:04:b0:23:bf:95:8a:8e:5b:1b:41:
                    7f:5a:c3:e8:4d:4c:d5:24:16:3e:87:48:d4:27:ae:
                    e6:f7:53:1d:bb:0c:00:ef:3e:61:71:ad:bf:3a:7a:
                    58:1f:94:3d:5c:81:d5:d5:6f:df:b8:9b:d2:f5:e5:
                    cb:83:72:92:c2:53:b2:82:02:eb:ad:ad:5f:16:2d:
                    92:53:76:f1:89:b6:2c:f5:c1:2f:e0:a7:4a:6f:a0:
                    30:6a:32:eb:9a:74:03:68:78:13:9d:ca:2f:9b:0b:
                    1d:be:cf:75:0d:26:97:9b:c7:f5:5e:0a:9f:78:df:
                    b3:bc:ec:9a:ba:ef:55:8f:1b:9a:a6:07:63:29:17:
                    59:62:09:2a:79:07:77:a5:e0:d1:17:69:e9:5b:dd:
                    f6:90:ab:e2:98:0a:00:d1:25:6d:9e:d7:85:87:2f:
                    92:f1:d1:76:83:4f:0b:3a:59:37:28:2f:33:a7:17:
                    50:d6:20:0b:0a:f4:26:f9:9f:38:e7:2d:a4:b8:9b:
                    89:8d:ad:ad:c9:6a:7d:89:17:bb:f6:7f:80:83:7a:
                    e6:ed
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE, pathlen:0
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Subject Alternative Name:
                DirName:/CN=STRonline1-2048-5
            X509v3 Subject Key Identifier:
                0F:CA:1E:5C:79:E0:A2:F3:29:B6:D2:85:B3:0B:4A:B5:65:EC:6B:52
            X509v3 Authority Key Identifier:
                keyid:0F:CA:1E:5C:79:E0:A2:F3:29:B6:D2:85:B3:0B:4A:B5:65:EC:6B:52

    Signature Algorithm: sha1WithRSAEncryption
         af:01:f0:ed:19:3c:28:e8:4d:5c:bb:a5:63:1c:88:33:03:a7:
         00:87:a4:1f:20:ab:d6:1c:e3:06:1f:97:7e:54:bd:b7:d1:b2:
         c9:d5:da:80:ec:17:d7:8a:f5:7b:c2:00:f6:e9:11:6f:84:a0:
         5a:25:31:e2:89:f9:a4:00:3f:31:68:2e:d5:3d:e8:6e:e6:d5:
         1d:3c:3f:b2:bd:9f:77:eb:9d:d3:8c:ba:c0:d7:b6:4d:ec:53:
         9c:0f:04:6e:ea:35:67:57:e3:0a:65:7b:90:3a:e1:4f:3e:c3:
         00:92:7a:bb:05:89:73:8c:cb:a6:4d:c0:fb:f6:02:d6:b0:07:
         a3:03:c2:27:40:9f:0c:e4:85:82:2d:af:9a:42:1d:d0:c7:8d:
         f8:40:ee:9d:06:57:1c:d9:a2:d8:80:14:fe:e1:63:2d:32:87:
         d5:94:52:96:3a:46:c6:71:96:3d:f7:98:0e:b2:91:aa:8f:da:
         f4:4e:24:00:39:55:e8:ad:17:b9:d3:34:2b:4a:a9:40:cc:17:
         2a:55:65:41:74:42:7e:f5:c0:af:c8:93:ad:f2:18:5b:3d:89:
         0c:db:47:39:24:f8:e0:4c:f2:1f:b0:3d:0a:ca:05:4e:89:21:
         1a:e3:2a:99:ac:fc:7f:a1:f1:0f:1b:1f:3d:9e:04:83:dd:96:
         d9:1d:3a:94
-----BEGIN CERTIFICATE-----
MIIEezCCA2OgAwIBAgIQNxkY5lNUfBq1uMtZWts1tzANBgkqhkiG9w0BAQUFADCB
rjELMAkGA1UEBhMCREUxIDAeBgNVBAgTF0JhZGVuLVd1ZXJ0dGVtYmVyZyAoQlcp
MRIwEAYDVQQHEwlTdHV0dGdhcnQxKTAnBgNVBAoTIERldXRzY2hlciBTcGFya2Fz
c2VuIFZlcmxhZyBHbWJIMT4wPAYDVQQDEzVTLVRSVVNUIEF1dGhlbnRpY2F0aW9u
IGFuZCBFbmNyeXB0aW9uIFJvb3QgQ0EgMjAwNTpQTjAeFw0wNTA2MjIwMDAwMDBa
Fw0zMDA2MjEyMzU5NTlaMIGuMQswCQYDVQQGEwJERTEgMB4GA1UECBMXQmFkZW4t
V3VlcnR0ZW1iZXJnIChCVykxEjAQBgNVBAcTCVN0dXR0Z2FydDEpMCcGA1UEChMg
RGV1dHNjaGVyIFNwYXJrYXNzZW4gVmVybGFnIEdtYkgxPjA8BgNVBAMTNVMtVFJV
U1QgQXV0aGVudGljYXRpb24gYW5kIEVuY3J5cHRpb24gUm9vdCBDQSAyMDA1OlBO
MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA2bVKwdMz6tNGs9HiTNL1
toPQb9UY6ZOvJ44TzbUlNlA0EmQpoVXhOmCTnijJ4/Ob4QSwI7+Vio5bG0F/WsPo
TUzVJBY+h0jUJ67m91MduwwA7z5hca2/OnpYH5Q9XIHV1W/fuJvS9eXLg3KSwlOy
ggLrra1fFi2SU3bxibYs9cEv4KdKb6AwajLrmnQDaHgTncovmwsdvs91DSaXm8f1
XgqfeN+zvOyauu9VjxuapgdjKRdZYgkqeQd3peDRF2npW932kKvimAoA0SVtnteF
hy+S8dF2g08LOlk3KC8zpxdQ1iALCvQm+Z845y2kuJuJja2tyWp9iRe79n+Ag3rm
7QIDAQABo4GSMIGPMBIGA1UdEwEB/wQIMAYBAf8CAQAwDgYDVR0PAQH/BAQDAgEG
MCkGA1UdEQQiMCCkHjAcMRowGAYDVQQDExFTVFJvbmxpbmUxLTIwNDgtNTAdBgNV
HQ4EFgQUD8oeXHngovMpttKFswtKtWXsa1IwHwYDVR0jBBgwFoAUD8oeXHngovMp
ttKFswtKtWXsa1IwDQYJKoZIhvcNAQEFBQADggEBAK8B8O0ZPCjoTVy7pWMciDMD
pwCHpB8gq9Yc4wYfl35UvbfRssnV2oDsF9eK9XvCAPbpEW+EoFolMeKJ+aQAPzFo
LtU96G7m1R08P7K9n3frndOMusDXtk3sU5wPBG7qNWdX4wple5A64U8+wwCSersF
iXOMy6ZNwPv2AtawB6MDwidAnwzkhYItr5pCHdDHjfhA7p0GVxzZotiAFP7hYy0y
h9WUUpY6RsZxlj33mA6ykaqP2vROJAA5VeitF7nTNCtKqUDMFypVZUF0Qn71wK/I
k63yGFs9iQzbRzkk+OBM8h+wPQrKBU6JIRrjKpms/H+h8Q8bHz2eBIPdltkdOpQ=
-----END CERTIFICATE-----

AC Ra\xC3\xADz Certic\xC3\xA1mara S.A.
======================================
SHA1 Fingerprint=CB:A1:C5:F8:B0:E3:5E:B8:B9:45:12:D3:F9:34:A2:E9:06:10:D3:36
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            07:7e:52:93:7b:e0:15:e3:57:f0:69:8c:cb:ec:0c
    Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=CO, O=Sociedad Cameral de Certificaci\xC3\xB3n Digital -
Certic\xC3\xA1mara S.A., CN=AC Ra\xC3\xADz Certic\xC3\xA1mara S.A.
        Validity
            Not Before: Nov 27 20:46:29 2006 GMT
            Not After : Apr  2 21:42:02 2030 GMT
        Subject: C=CO, O=Sociedad Cameral de Certificaci\xC3\xB3n Digital -
Certic\xC3\xA1mara S.A., CN=AC Ra\xC3\xADz Certic\xC3\xA1mara S.A.
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (4096 bit)
                Modulus:
                    00:ab:6b:89:a3:53:cc:48:23:08:fb:c3:cf:51:96:
                    08:2e:b8:08:7a:6d:3c:90:17:86:a9:e9:ed:2e:13:
                    34:47:b2:d0:70:dc:c9:3c:d0:8d:ca:ee:4b:17:ab:
                    d0:85:b0:a7:23:04:cb:a8:a2:fc:e5:75:db:40:ca:
                    62:89:8f:50:9e:01:3d:26:5b:18:84:1c:cb:7c:37:
                    b7:7d:ec:d3:7f:73:19:b0:6a:b2:d8:88:8a:2d:45:
                    74:a8:f7:b3:b8:c0:d4:da:cd:22:89:74:4d:5a:15:
                    39:73:18:74:4f:b5:eb:99:a7:c1:1e:88:b4:c2:93:
                    90:63:97:f3:a7:a7:12:b2:09:22:07:33:d9:91:cd:
                    0e:9c:1f:0e:20:c7:ee:bb:33:8d:8f:c2:d2:58:a7:
                    5f:fd:65:37:e2:88:c2:d8:8f:86:75:5e:f9:2d:a7:
                    87:33:f2:78:37:2f:8b:bc:1d:86:37:39:b1:94:f2:
                    d8:bc:4a:9c:83:18:5a:06:fc:f3:d4:d4:ba:8c:15:
                    09:25:f0:f9:b6:8d:04:7e:17:12:33:6b:57:48:4c:
                    4f:db:26:1e:eb:cc:90:e7:8b:f9:68:7c:70:0f:a3:
                    2a:d0:3a:38:df:37:97:e2:5b:de:80:61:d3:80:d8:
                    91:83:42:5a:4c:04:89:68:11:3c:ac:5f:68:80:41:
                    cc:60:42:ce:0d:5a:2a:0c:0f:9b:30:c0:a6:f0:86:
                    db:ab:49:d7:97:6d:48:8b:f9:03:c0:52:67:9b:12:
                    f7:c2:f2:2e:98:65:42:d9:d6:9a:e3:d0:19:31:0c:
                    ad:87:d5:57:02:7a:30:e8:86:26:fb:8f:23:8a:54:
                    87:e4:bf:3c:ee:eb:c3:75:48:5f:1e:39:6f:81:62:
                    6c:c5:2d:c4:17:54:19:b7:37:8d:9c:37:91:c8:f6:
                    0b:d5:ea:63:6f:83:ac:38:c2:f3:3f:de:9a:fb:e1:
                    23:61:f0:c8:26:cb:36:c8:a1:f3:30:8f:a4:a3:a2:
                    a1:dd:53:b3:de:f0:9a:32:1f:83:91:79:30:c1:a9:
                    1f:53:9b:53:a2:15:53:3f:dd:9d:b3:10:3b:48:7d:
                    89:0f:fc:ed:03:f5:fb:25:64:75:0e:17:19:0d:8f:
                    00:16:67:79:7a:40:fc:2d:59:07:d9:90:fa:9a:ad:
                    3d:dc:80:8a:e6:5c:35:a2:67:4c:11:6b:b1:f8:80:
                    64:00:2d:6f:22:61:c5:ac:4b:26:e5:5a:10:82:9b:
                    a4:83:7b:34:f7:9e:89:91:20:97:8e:b7:42:c7:66:
                    c3:d0:e9:a4:d6:f5:20:8d:c4:c3:95:ac:44:0a:9d:
                    5b:73:3c:26:3d:2f:4a:be:a7:c9:a7:10:1e:fb:9f:
                    50:69:f3
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints: critical
                CA:TRUE
            X509v3 Key Usage: critical
                Certificate Sign, CRL Sign
            X509v3 Subject Key Identifier:
                D1:09:D0:E9:D7:CE:79:74:54:F9:3A:30:B3:F4:6D:2C:03:03:1B:68
            X509v3 Certificate Policies:
                Policy: X509v3 Any Policy
                  CPS: http://www.certicamara.com/dpc/
                  User Notice:
                    Explicit Text: Limitaciones de garantías de este
certificado se pueden encontrar en la DPC.

    Signature Algorithm: sha1WithRSAEncryption
         5c:94:b5:b8:45:91:4d:8e:61:1f:03:28:0f:53:7c:e6:a4:59:
         a9:b3:8a:7a:c5:b0:ff:08:7c:2c:a3:71:1c:21:13:67:a1:95:
         12:40:35:83:83:8f:74:db:33:5c:f0:49:76:0a:81:52:dd:49:
         d4:9a:32:33:ef:9b:a7:cb:75:e5:7a:cb:97:12:90:5c:ba:7b:
         c5:9b:df:bb:39:23:c8:ff:98:ce:0a:4d:22:01:48:07:7e:8a:
         c0:d5:20:42:94:44:ef:bf:77:a2:89:67:48:1b:40:03:05:a1:
         89:ec:cf:62:e3:3d:25:76:66:bf:26:b7:bb:22:be:6f:ff:39:
         57:74:ba:7a:c9:01:95:c1:95:51:e8:ab:2c:f8:b1:86:20:e9:
         3f:cb:35:5b:d2:17:e9:2a:fe:83:13:17:40:ee:88:62:65:5b:
         d5:3b:60:e9:7b:3c:b8:c9:d5:7f:36:02:25:aa:68:c2:31:15:
         b7:30:65:eb:7f:1d:48:79:b1:cf:39:e2:42:80:16:d3:f5:93:
         23:fc:4c:97:c9:5a:37:6c:7c:22:d8:4a:cd:d2:8e:36:83:39:
         91:90:10:c8:f1:c9:35:7e:3f:b8:d3:81:c6:20:64:1a:b6:50:
         c2:21:a4:78:dc:d0:2f:3b:64:93:74:f0:96:90:f1:ef:fb:09:
         5a:34:40:96:f0:36:12:c1:a3:74:8c:93:7e:41:de:77:8b:ec:
         86:d9:d2:0f:3f:2d:d1:cc:40:a2:89:66:48:1e:20:b3:9c:23:
         59:73:a9:44:73:bc:24:79:90:56:37:b3:c6:29:7e:a3:0f:f1:
         29:39:ef:7e:5c:28:32:70:35:ac:da:b8:c8:75:66:fc:9b:4c:
         39:47:8e:1b:6f:9b:4d:02:54:22:33:ef:61:ba:9e:29:84:ef:
         4e:4b:33:47:76:97:6a:cb:7e:5f:fd:15:a6:9e:42:43:5b:66:
         5a:8a:88:0d:f7:16:b9:3f:51:65:2b:66:6a:8b:d1:38:52:a2:
         d6:46:11:fa:fc:9a:1c:74:9e:8f:97:0b:02:4f:64:c6:f5:68:
         d3:4b:2d:ff:a4:37:1e:8b:3f:bf:44:be:61:46:a1:84:3d:08:
         27:4c:81:20:77:89:08:ea:67:40:5e:6c:08:51:5f:34:5a:8c:
         96:68:cd:d7:f7:89:c2:1c:d3:32:00:af:52:cb:d3:60:5b:2a:
         3a:47:7e:6b:30:33:a1:62:29:7f:4a:b9:e1:2d:e7:14:23:0e:
         0e:18:47:e1:79:fc:15:55:d0:b1:fc:25:71:63:75:33:1c:23:
         2b:af:5c:d9:ed:47:77:60:0e:3b:0f:1e:d2:c0:dc:64:05:89:
         fc:78:d6:5c:2c:26:43:a9
-----BEGIN CERTIFICATE-----
MIIGZjCCBE6gAwIBAgIPB35Sk3vgFeNX8GmMy+wMMA0GCSqGSIb3DQEBBQUAMHsx
CzAJBgNVBAYTAkNPMUcwRQYDVQQKDD5Tb2NpZWRhZCBDYW1lcmFsIGRlIENlcnRp
ZmljYWNpw7NuIERpZ2l0YWwgLSBDZXJ0aWPDoW1hcmEgUy5BLjEjMCEGA1UEAwwa
QUMgUmHDrXogQ2VydGljw6FtYXJhIFMuQS4wHhcNMDYxMTI3MjA0NjI5WhcNMzAw
NDAyMjE0MjAyWjB7MQswCQYDVQQGEwJDTzFHMEUGA1UECgw+U29jaWVkYWQgQ2Ft
ZXJhbCBkZSBDZXJ0aWZpY2FjacOzbiBEaWdpdGFsIC0gQ2VydGljw6FtYXJhIFMu
QS4xIzAhBgNVBAMMGkFDIFJhw616IENlcnRpY8OhbWFyYSBTLkEuMIICIjANBgkq
hkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAq2uJo1PMSCMI+8PPUZYILrgIem08kBeG
qentLhM0R7LQcNzJPNCNyu5LF6vQhbCnIwTLqKL85XXbQMpiiY9QngE9JlsYhBzL
fDe3fezTf3MZsGqy2IiKLUV0qPezuMDU2s0iiXRNWhU5cxh0T7XrmafBHoi0wpOQ
Y5fzp6cSsgkiBzPZkc0OnB8OIMfuuzONj8LSWKdf/WU34ojC2I+GdV75LaeHM/J4
Ny+LvB2GNzmxlPLYvEqcgxhaBvzz1NS6jBUJJfD5to0EfhcSM2tXSExP2yYe68yQ
54v5aHxwD6Mq0Do43zeX4lvegGHTgNiRg0JaTASJaBE8rF9ogEHMYELODVoqDA+b
MMCm8Ibbq0nXl21Ii/kDwFJnmxL3wvIumGVC2daa49AZMQyth9VXAnow6IYm+48j
ilSH5L887uvDdUhfHjlvgWJsxS3EF1QZtzeNnDeRyPYL1epjb4OsOMLzP96a++Ej
YfDIJss2yKHzMI+ko6Kh3VOz3vCaMh+DkXkwwakfU5tTohVTP92dsxA7SH2JD/zt
A/X7JWR1DhcZDY8AFmd5ekD8LVkH2ZD6mq093ICK5lw1omdMEWux+IBkAC1vImHF
rEsm5VoQgpukg3s0956JkSCXjrdCx2bD0Omk1vUgjcTDlaxECp1bczwmPS9KvqfJ
pxAe+59QafMCAwEAAaOB5jCB4zAPBgNVHRMBAf8EBTADAQH/MA4GA1UdDwEB/wQE
AwIBBjAdBgNVHQ4EFgQU0QnQ6dfOeXRU+Tows/RtLAMDG2gwgaAGA1UdIASBmDCB
lTCBkgYEVR0gADCBiTArBggrBgEFBQcCARYfaHR0cDovL3d3dy5jZXJ0aWNhbWFy
YS5jb20vZHBjLzBaBggrBgEFBQcCAjBOGkxMaW1pdGFjaW9uZXMgZGUgZ2FyYW50
7WFzIGRlIGVzdGUgY2VydGlmaWNhZG8gc2UgcHVlZGVuIGVuY29udHJhciBlbiBs
YSBEUEMuMA0GCSqGSIb3DQEBBQUAA4ICAQBclLW4RZFNjmEfAygPU3zmpFmps4p6
xbD/CHwso3EcIRNnoZUSQDWDg4902zNc8El2CoFS3UnUmjIz75uny3XlesuXEpBc
unvFm9+7OSPI/5jOCk0iAUgHforA1SBClETvv3eiiWdIG0ADBaGJ7M9i4z0ldma/
Jre7Ir5v/zlXdLp6yQGVwZVR6Kss+LGGIOk/yzVb0hfpKv6DExdA7ohiZVvVO2Dp
ezy4ydV/NgIlqmjCMRW3MGXrfx1IebHPOeJCgBbT9ZMj/EyXyVo3bHwi2ErN0o42
gzmRkBDI8ck1fj+404HGIGQatlDCIaR43NAvO2STdPCWkPHv+wlaNECW8DYSwaN0
jJN+Qd53i+yG2dIPPy3RzECiiWZIHiCznCNZc6lEc7wkeZBWN7PGKX6jD/EpOe9+
XCgycDWs2rjIdWb8m0w5R44bb5tNAlQiM+9hup4phO9OSzNHdpdqy35f/RWmnkJD
W2ZaiogN9xa5P1FlK2Zqi9E4UqLWRhH6/JocdJ6PlwsCT2TG9WjTSy3/pDceiz+/
RL5hRqGEPQgnTIEgd4kI6mdAXmwIUV80WoyWaM3X94nCHNMyAK9Sy9NgWyo6R35r
MDOhYil/SrnhLecUIw4OGEfhefwVVdCx/CVxY3UzHCMrr1zZ7Ud3YA47Dx7SwNxk
BYn8eNZcLCZDqQ==
-----END CERTIFICATE-----

Verisign Class 1 Public Primary Certification Authority
=======================================================
SHA1 Fingerprint=CE:6A:64:A3:09:E4:2F:BB:D9:85:1C:45:3E:64:09:EA:E8:7D:60:F1
Certificate:
    Data:
        Version: 1 (0x0)
        Serial Number:
            3f:69:1e:81:9c:f0:9a:4a:f3:73:ff:b9:48:a2:e4:dd
    Signature Algorithm: sha1WithRSAEncryption
        Issuer: C=US, O=VeriSign, Inc., OU=Class 1 Public Primary
Certification Authority
        Validity
            Not Before: Jan 29 00:00:00 1996 GMT
            Not After : Aug  2 23:59:59 2028 GMT
        Subject: C=US, O=VeriSign, Inc., OU=Class 1 Public Primary
Certification Authority
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (1024 bit)
                Modulus:
                    00:e5:19:bf:6d:a3:56:61:2d:99:48:71:f6:67:de:
                    b9:8d:eb:b7:9e:86:80:0a:91:0e:fa:38:25:af:46:
                    88:82:e5:73:a8:a0:9b:24:5d:0d:1f:cc:65:6e:0c:
                    b0:d0:56:84:18:87:9a:06:9b:10:a1:73:df:b4:58:
                    39:6b:6e:c1:f6:15:d5:a8:a8:3f:aa:12:06:8d:31:
                    ac:7f:b0:34:d7:8f:34:67:88:09:cd:14:11:e2:4e:
                    45:56:69:1f:78:02:80:da:dc:47:91:29:bb:36:c9:
                    63:5c:c5:e0:d7:2d:87:7b:a1:b7:32:b0:7b:30:ba:
                    2a:2f:31:aa:ee:a3:67:da:db
                Exponent: 65537 (0x10001)
    Signature Algorithm: sha1WithRSAEncryption
         58:15:29:39:3c:77:a3:da:5c:25:03:7c:60:fa:ee:09:99:3c:
         27:10:70:c8:0c:09:e6:b3:87:cf:0a:e2:18:96:35:62:cc:bf:
         9b:27:79:89:5f:c9:c4:09:f4:ce:b5:1d:df:2a:bd:e5:db:86:
         9c:68:25:e5:30:7c:b6:89:15:fe:67:d1:ad:e1:50:ac:3c:7c:
         62:4b:8f:ba:84:d7:12:15:1b:1f:ca:5d:0f:c1:52:94:2a:11:
         99:da:7b:cf:0c:36:13:d5:35:dc:10:19:59:ea:94:c1:00:bf:
         75:8f:d9:fa:fd:76:04:db:62:bb:90:6a:03:d9:46:35:d9:f8:
         7c:5b
-----BEGIN CERTIFICATE-----
MIICPDCCAaUCED9pHoGc8JpK83P/uUii5N0wDQYJKoZIhvcNAQEFBQAwXzELMAkG
A1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMTcwNQYDVQQLEy5DbGFz
cyAxIFB1YmxpYyBQcmltYXJ5IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTk2
MDEyOTAwMDAwMFoXDTI4MDgwMjIzNTk1OVowXzELMAkGA1UEBhMCVVMxFzAVBgNV
BAoTDlZlcmlTaWduLCBJbmMuMTcwNQYDVQQLEy5DbGFzcyAxIFB1YmxpYyBQcmlt
YXJ5IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MIGfMA0GCSqGSIb3DQEBAQUAA4GN
ADCBiQKBgQDlGb9to1ZhLZlIcfZn3rmN67eehoAKkQ76OCWvRoiC5XOooJskXQ0f
zGVuDLDQVoQYh5oGmxChc9+0WDlrbsH2FdWoqD+qEgaNMax/sDTXjzRniAnNFBHi
TkVWaR94AoDa3EeRKbs2yWNcxeDXLYd7obcysHswuiovMaruo2fa2wIDAQABMA0G
CSqGSIb3DQEBBQUAA4GBAFgVKTk8d6PaXCUDfGD67gmZPCcQcMgMCeazh88K4hiW
NWLMv5sneYlfycQJ9M61Hd8qveXbhpxoJeUwfLaJFf5n0a3hUKw8fGJLj7qE1xIV
Gx/KXQ/BUpQqEZnae88MNhPVNdwQGVnqlMEAv3WP2fr9dgTbYruQagPZRjXZ+Hxb
-----END CERTIFICATE-----
ComSign CA
==========
SHA1 Fingerprint=E1:A4:5B:14:1A:21:DA:1A:79:F4:1A:42:A9:61:D6:69:CD:06:34:C1
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            14:13:96:83:14:55:8c:ea:7b:63:e5:fc:34:87:77:44
    Signature Algorithm: sha1WithRSAEncryption
        Issuer: CN=ComSign CA, O=ComSign, C=IL
        Validity
            Not Before: Mar 24 11:32:18 2004 GMT
            Not After : Mar 19 15:02:18 2029 GMT
        Subject: CN=ComSign CA, O=ComSign, C=IL
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (2048 bit)
                Modulus:
                    00:f0:e4:54:69:2b:d3:c7:8f:6a:44:e4:7e:58:27:
                    f8:0b:d0:e4:94:12:8a:f1:1b:38:38:2f:1f:31:9c:
                    06:d4:2c:a7:de:0b:2a:ae:1a:a0:e3:9e:6a:bf:9f:
                    3c:c7:6e:a2:f9:8b:64:6c:3a:ad:85:55:51:54:a5:
                    38:55:b8:ab:83:04:f2:3f:64:36:f7:c0:8d:43:43:
                    6a:66:d1:f7:17:2a:d5:ef:36:fa:30:10:42:d7:53:
                    cd:f9:fa:33:73:4c:b3:e9:84:20:8a:d6:41:27:35:
                    e4:38:fa:94:9b:b8:7a:e4:79:1f:33:fb:1b:d8:21:
                    09:28:7c:4d:18:69:5e:64:8a:7a:19:93:ca:7e:ec:
                    f3:72:e7:37:07:58:59:28:ac:42:f9:c5:ff:cd:3f:
                    e7:a5:fa:38:b1:d0:0c:c7:d9:52:1a:53:d6:81:cc:
                    42:7a:35:5b:ed:4b:3a:7a:f6:b5:8e:cc:ff:0f:7c:
                    e4:60:36:87:2f:ad:f0:a1:25:7d:ff:d2:4b:11:88:
                    70:54:a6:41:a8:67:53:52:42:5e:e4:34:9e:e4:be:
                    a3:ec:aa:62:5d:dd:c3:4c:a6:82:41:e4:33:0b:ac:
                    c9:33:0f:64:82:57:2a:fd:0c:ad:36:e1:0c:ae:4b:
                    c5:ef:3b:99:d9:23:b3:5b:5d:b4:57:ec:74:70:0c:
                    2a:4f
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints:
                CA:TRUE
            X509v3 CRL Distribution Points:

                Full Name:
                  URI:http://fedir.comsign.co.il/crl/ComSignCA.crl

            X509v3 Key Usage: critical
                Digital Signature, Certificate Sign, CRL Sign
            X509v3 Authority Key Identifier:
                keyid:4B:01:9B:3E:56:1A:65:36:76:CB:7B:97:AA:92:05:EE:32:E7:28:31

            X509v3 Subject Key Identifier:
                4B:01:9B:3E:56:1A:65:36:76:CB:7B:97:AA:92:05:EE:32:E7:28:31
    Signature Algorithm: sha1WithRSAEncryption
         d0:d9:a5:7e:fe:29:60:45:9d:7e:83:cf:6e:bc:47:6e:f5:1a:
         9e:54:76:42:71:b4:3c:58:3f:2d:40:25:42:f6:81:9c:f1:89:
         10:c8:0e:aa:78:4f:38:09:57:b0:3c:c0:08:fc:35:8e:f1:48:
         51:8d:0c:71:74:ba:84:c4:d7:72:9b:84:7c:38:4e:64:06:27:
         2a:e1:a7:b5:ec:08:99:b4:0a:0d:d4:85:73:c8:12:e1:35:ed:
         f1:05:31:1d:73:99:0c:eb:96:ca:dd:d3:e6:85:aa:f0:8a:fb:
         75:c1:f2:09:3c:65:65:64:f3:4c:d8:ad:cb:88:69:f3:e4:83:
         b7:0c:bd:17:5a:96:17:ca:5b:ff:ad:bb:1c:e9:2d:84:80:d8:
         21:be:85:52:d9:d4:74:b9:69:85:ba:4d:ed:28:32:eb:f9:61:
         4a:e4:c4:36:1e:19:dc:6f:84:11:1f:95:f5:83:28:18:a8:33:
         92:43:27:dd:5d:13:04:45:4f:87:d5:46:cd:3d:a8:ba:f0:f3:
         b8:56:24:45:eb:37:c7:e1:76:4f:72:39:18:df:7e:74:72:c7:
         73:2d:39:ea:60:e6:ad:11:a2:56:87:7b:c3:68:9a:fe:f8:8c:
         70:a8:df:65:32:f4:a4:40:8c:a1:c2:44:03:0e:94:00:67:a0:
         71:00:82:48
-----BEGIN CERTIFICATE-----
MIIDkzCCAnugAwIBAgIQFBOWgxRVjOp7Y+X8NId3RDANBgkqhkiG9w0BAQUFADA0
MRMwEQYDVQQDEwpDb21TaWduIENBMRAwDgYDVQQKEwdDb21TaWduMQswCQYDVQQG
EwJJTDAeFw0wNDAzMjQxMTMyMThaFw0yOTAzMTkxNTAyMThaMDQxEzARBgNVBAMT
CkNvbVNpZ24gQ0ExEDAOBgNVBAoTB0NvbVNpZ24xCzAJBgNVBAYTAklMMIIBIjAN
BgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA8ORUaSvTx49qROR+WCf4C9DklBKK
8Rs4OC8fMZwG1Cyn3gsqrhqg455qv588x26i+YtkbDqthVVRVKU4VbirgwTyP2Q2
98CNQ0NqZtH3FyrV7zb6MBBC11PN+fozc0yz6YQgitZBJzXkOPqUm7h65HkfM/sb
2CEJKHxNGGleZIp6GZPKfuzzcuc3B1hZKKxC+cX/zT/npfo4sdAMx9lSGlPWgcxC
ejVb7Us6eva1jsz/D3zkYDaHL63woSV9/9JLEYhwVKZBqGdTUkJe5DSe5L6j7Kpi
Xd3DTKaCQeQzC6zJMw9kglcq/QytNuEMrkvF7zuZ2SOzW120V+x0cAwqTwIDAQAB
o4GgMIGdMAwGA1UdEwQFMAMBAf8wPQYDVR0fBDYwNDAyoDCgLoYsaHR0cDovL2Zl
ZGlyLmNvbXNpZ24uY28uaWwvY3JsL0NvbVNpZ25DQS5jcmwwDgYDVR0PAQH/BAQD
AgGGMB8GA1UdIwQYMBaAFEsBmz5WGmU2dst7l6qSBe4y5ygxMB0GA1UdDgQWBBRL
AZs+VhplNnbLe5eqkgXuMucoMTANBgkqhkiG9w0BAQUFAAOCAQEA0Nmlfv4pYEWd
foPPbrxHbvUanlR2QnG0PFg/LUAlQvaBnPGJEMgOqnhPOAlXsDzACPw1jvFIUY0M
cXS6hMTXcpuEfDhOZAYnKuGntewImbQKDdSFc8gS4TXt8QUxHXOZDOuWyt3T5oWq
8Ir7dcHyCTxlZWTzTNity4hp8+SDtwy9F1qWF8pb/627HOkthIDYIb6FUtnUdLlp
hbpN7Sgy6/lhSuTENh4Z3G+EER+V9YMoGKgzkkMn3V0TBEVPh9VGzT2ouvDzuFYk
Res3x+F2T3I5GN9+dHLHcy056mDmrRGiVod7w2ia/viMcKjfZTL0pECMocJEAw6U
AGegcQCCSA==
-----END CERTIFICATE-----

ComSign Secured CA
==================
SHA1 Fingerprint=F9:CD:0E:2C:DA:76:24:C1:8F:BD:F0:F0:AB:B6:45:B8:F7:FE:D5:7A
Certificate:
    Data:
        Version: 3 (0x2)
        Serial Number:
            c7:28:47:09:b3:b8:6c:45:8c:1d:fa:24:f5:36:4e:e9
    Signature Algorithm: sha1WithRSAEncryption
        Issuer: CN=ComSign Secured CA, O=ComSign, C=IL
        Validity
            Not Before: Mar 24 11:37:20 2004 GMT
            Not After : Mar 16 15:04:56 2029 GMT
        Subject: CN=ComSign Secured CA, O=ComSign, C=IL
        Subject Public Key Info:
            Public Key Algorithm: rsaEncryption
                Public-Key: (2048 bit)
                Modulus:
                    00:c6:b5:68:5f:1d:94:15:c3:a4:08:55:2d:e3:a0:
                    57:7a:ef:e9:74:2a:bb:b9:7c:57:49:1a:11:5e:4f:
                    29:87:0c:48:d6:6a:e7:8f:d4:7e:57:24:b9:06:89:
                    e4:1c:3c:ea:ac:e3:da:21:80:73:21:0a:ef:79:98:
                    6c:1f:08:ff:a1:50:7d:f2:98:1b:c9:54:6f:3e:a5:
                    28:ec:21:04:0f:45:bb:07:3d:a1:c0:fa:2a:98:1d:
                    4e:06:93:fb:f5:88:3b:ab:5f:cb:16:bf:e6:f3:9e:
                    4a:87:ed:19:ea:c2:9f:43:e4:f1:81:a5:7f:10:4f:
                    3e:d1:4a:62:ad:53:1b:cb:83:ff:07:65:a5:92:2d:
                    66:a9:5b:b8:5a:f4:1d:b4:21:91:4a:17:7b:9e:32:
                    fe:56:24:39:b2:54:84:43:f5:84:c2:d8:bc:41:90:
                    cc:9d:d6:68:da:e9:82:50:a9:3b:68:cf:b5:5d:02:
                    94:60:16:b1:43:d9:43:5d:dd:5d:87:6e:ea:bb:b3:
                    c9:6b:f6:03:94:09:70:de:16:11:7a:2b:e8:76:8f:
                    49:10:98:77:b9:63:5c:8b:33:97:75:f6:0b:8c:b2:
                    ab:5b:de:74:20:25:3f:e3:f3:11:f9:87:68:86:35:
                    71:c3:1d:8c:2d:eb:e5:1a:ac:0f:73:d5:82:59:40:
                    80:d3
                Exponent: 65537 (0x10001)
        X509v3 extensions:
            X509v3 Basic Constraints:
                CA:TRUE
            X509v3 CRL Distribution Points:

                Full Name:
                  URI:http://fedir.comsign.co.il/crl/ComSignSecuredCA.crl

            X509v3 Key Usage: critical
                Digital Signature, Certificate Sign, CRL Sign
            X509v3 Authority Key Identifier:
                keyid:C1:4B:ED:70:B6:F7:3E:7C:00:3B:00:8F:C7:3E:0E:45:9F:1E:5D:EC

            X509v3 Subject Key Identifier:
                C1:4B:ED:70:B6:F7:3E:7C:00:3B:00:8F:C7:3E:0E:45:9F:1E:5D:EC
    Signature Algorithm: sha1WithRSAEncryption
         16:cf:ee:92:13:50:ab:7b:14:9e:33:b6:42:20:6a:d4:15:bd:
         09:ab:fc:72:e8:ef:47:7a:90:ac:51:c1:64:4e:e9:88:bd:43:
         45:81:e3:66:23:3f:12:86:4d:19:e4:05:b0:e6:37:c2:8d:da:
         06:28:c9:0f:89:a4:53:a9:75:3f:b0:96:fb:ab:4c:33:55:f9:
         78:26:46:6f:1b:36:98:fb:42:76:c1:82:b9:8e:de:fb:45:f9:
         63:1b:62:3b:39:06:ca:77:7a:a8:3c:09:cf:6c:36:3d:0f:0a:
         45:4b:69:16:1a:45:7d:33:03:65:f9:52:71:90:26:95:ac:4c:
         0c:f5:8b:93:3f:cc:75:74:85:98:ba:ff:62:7a:4d:1f:89:fe:
         ae:bd:94:00:99:bf:11:a5:dc:e0:79:c5:16:0b:7d:02:61:1d:
         ea:85:f9:02:15:4f:e7:5a:89:4e:14:6f:e3:37:4b:85:f5:c1:
         3c:61:e0:fd:05:41:b2:92:7f:c3:1d:a0:d0:ae:52:64:60:6b:
         18:c6:26:9c:d8:f5:64:e4:36:1a:62:9f:8a:0f:3e:ff:6d:4e:
         19:56:4e:20:91:6c:9f:34:33:3a:34:57:50:3a:6f:81:5e:06:
         c6:f5:3e:7c:4e:8e:2b:ce:65:06:2e:5d:d2:2a:53:74:5e:d3:
         6e:27:9e:8f
-----BEGIN CERTIFICATE-----
MIIDqzCCApOgAwIBAgIRAMcoRwmzuGxFjB36JPU2TukwDQYJKoZIhvcNAQEFBQAw
PDEbMBkGA1UEAxMSQ29tU2lnbiBTZWN1cmVkIENBMRAwDgYDVQQKEwdDb21TaWdu
MQswCQYDVQQGEwJJTDAeFw0wNDAzMjQxMTM3MjBaFw0yOTAzMTYxNTA0NTZaMDwx
GzAZBgNVBAMTEkNvbVNpZ24gU2VjdXJlZCBDQTEQMA4GA1UEChMHQ29tU2lnbjEL
MAkGA1UEBhMCSUwwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDGtWhf
HZQVw6QIVS3joFd67+l0Kru5fFdJGhFeTymHDEjWaueP1H5XJLkGieQcPOqs49oh
gHMhCu95mGwfCP+hUH3ymBvJVG8+pSjsIQQPRbsHPaHA+iqYHU4Gk/v1iDurX8sW
v+bznkqH7Rnqwp9D5PGBpX8QTz7RSmKtUxvLg/8HZaWSLWapW7ha9B20IZFKF3ue
Mv5WJDmyVIRD9YTC2LxBkMyd1mja6YJQqTtoz7VdApRgFrFD2UNd3V2Hbuq7s8lr
9gOUCXDeFhF6K+h2j0kQmHe5Y1yLM5d19guMsqtb3nQgJT/j8xH5h2iGNXHDHYwt
6+UarA9z1YJZQIDTAgMBAAGjgacwgaQwDAYDVR0TBAUwAwEB/zBEBgNVHR8EPTA7
MDmgN6A1hjNodHRwOi8vZmVkaXIuY29tc2lnbi5jby5pbC9jcmwvQ29tU2lnblNl
Y3VyZWRDQS5jcmwwDgYDVR0PAQH/BAQDAgGGMB8GA1UdIwQYMBaAFMFL7XC29z58
ADsAj8c+DkWfHl3sMB0GA1UdDgQWBBTBS+1wtvc+fAA7AI/HPg5Fnx5d7DANBgkq
hkiG9w0BAQUFAAOCAQEAFs/ukhNQq3sUnjO2QiBq1BW9Cav8cujvR3qQrFHBZE7p
iL1DRYHjZiM/EoZNGeQFsOY3wo3aBijJD4mkU6l1P7CW+6tMM1X5eCZGbxs2mPtC
dsGCuY7e+0X5YxtiOzkGynd6qDwJz2w2PQ8KRUtpFhpFfTMDZflScZAmlaxMDPWL
kz/MdXSFmLr/YnpNH4n+rr2UAJm/EaXc4HnFFgt9AmEd6oX5AhVP51qJThRv4zdL
hfXBPGHg/QVBspJ/wx2g0K5SZGBrGMYmnNj1ZOQ2GmKfig8+/21OGVZOIJFsnzQz
OjRXUDpvgV4GxvU+fE6OK85lBi5d0ipTdF7Tbieejw==
-----END CERTIFICATE-----
